/**
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#include "common.h"

#ifdef OS_FRTOS
#include "osi_frtos.h"
extern char *p_optarg;
extern int *p_optind;

#define CLEAN_DRIVER_BUFFER()    \
    DBGPRINT(ERROR, "clean driver buffer");    \
    do {    \
        ret = osi_read(fd, buffer, sizeof(buffer));    \
    } while (ret > 0);    \

#define CHECK_READ_LENGTH(ret, length)    \
    if (ret < length) {    \
        DBGPRINT(ERROR, "clean driver buffer");    \
        CLEAN_DRIVER_BUFFER()    \
        continue;    \
    }
#define FIRST_READ_LEN 3
#else
#include "osi_linux.h"
char *p_optarg;
int *p_optind;
#endif

//---------------------------------------------------------------------------
#define VERSION     "1.0.20091001"

#define FILE_NAME_SIZE          64
#define BUF_SIZE                2050
#define DEFAULT_BUF_SIZE        20000       // tempararily set to 0

//---------------------------------------------------------------------------
static uint8_t buffer[BUF_SIZE] = {0};
static uint8_t cont = 1;    /** loop continue running */
static int buf_size = DEFAULT_BUF_SIZE;   /** allocate a buf to save log */

//---------------------------------------------------------------------------
#ifdef OS_FRTOS
int wifi_dump_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
    OSI_FILE *fw_dump_fscript = 0;
    int nRead = 0;
    int fd = 0;
    int ret = 0;
    int opt;
	int fw_dump_writetofilelength = 0;
	char fw_dump_file_name[FILE_NAME_SIZE] = {0};
	int fw_dump_file_seq = 0;
    int retry_file_open = 0;
    int file_size = FW_LOG_SWITCH_SIZE;     /** default file size is 20 MB */
    int i = 0;
    char *log_path = DEFAULT_PATH;
    char timestamp_buffer[24];
    osi_fd_set rset;                        /** For select */
	osi_fd_set card_remove;
    TIMEVAL tv;
    TIME_T local_timestamp;
    struct itimerval it_val;
    FLOCK fl;
#if 0
    char fullname[PATH_MAX + NAME_MAX + 2] = {0};
#endif

    /** Create fifo for inteprocess communication */
    uint8_t coredump_end = 0;
#ifdef OS_FRTOS
    int second_part_len = 0;
    int read_payload_len = 0;
#endif

    if (argv)
        DBGPRINT(SHOW, "%s Version: %s", argv[0], VERSION);
    else
        DBGPRINT(SHOW, "argv is NULL, Version: %s", VERSION);

    init_flock(&fl);

#ifdef OS_FRTOS
    DBGPRINT(SHOW, "FRTOS");
#else
    DBGPRINT(SHOW, "Linux");
    p_optarg = optarg;
    p_optind = &optind;
#endif

    /* init for write to file timer */
    memset(&it_val, 0, sizeof(it_val));

    while ((opt = osi_getopt(argc, argv, "t:d:c:p:n:s:b:l:v:h::mfo")) != -1) {
        /* If your option didn't use argument, please don't use ':' into getopt */
        switch (opt) {
        /* debug */
        case 'd':
            if (strcmp(p_optarg, "kill") == 0) {
                osi_system("killall wifi_dump");
                DBGPRINT(SHOW, "Kill all wifi_dump process.");
                goto done;
            }
            break;
        /* change path */
        case 'p':
            DBGPRINT(SHOW, "-p p_optarg = %s", p_optarg);
#ifdef OS_FRTOS
#else
            osi_validate_log_path(p_optarg);
#endif
            if (OSI_STAT(p_optarg)) {
                log_path = p_optarg;
                DBGPRINT(SHOW, "Log path is %s", log_path);
            } else {
                DBGPRINT(SHOW, "Directory is invalid");
                goto done;
            }
            break;
        /* command Usage */
        case '?':
        default:
            DBGPRINT(SHOW, "Usage: wifi_dump [option] [path | command]");
            DBGPRINT(SHOW, "[option]");
            DBGPRINT(SHOW, "\t-d [command]\tSend debug command");
            DBGPRINT(SHOW, "\t  \t\tUsing \"kill\" command to kill all wifi_dump");
            DBGPRINT(SHOW, "\t-p [path]\tOutput the file to specific dictionary");
            goto done;
            break;
        }
    }

open_again:

    do {
        fd = osi_open(CUST_WIFI_FWLOG_PORT, OSI_RDONLY | OSI_NOCTTY | OSI_NONBLOCK);
        if (fd <= 0) {
            DBGPRINT(ERROR, "Can't open device node %s, fd: %d", CUST_WIFI_FWLOG_PORT, fd);
            osi_sleep_ms(2);
            if (i == RETRY_COUNT)
                goto done;
            else
                continue;
        } else {
            DBGPRINT(SHOW, "Open device node successfully fd = %d", fd);
            break;
        }
	} while (cont);

    /* flock the device node */
#if 1
    if (osi_fcntl(fd, OSI_F_SETLK, &fl) < 0) {
        DBGPRINT(SHOW, "lock device node failed, wifi_dump already running.");
        goto done;
    }
#endif

    if (buf_size > file_size) {
        buf_size = 0;
        DBGPRINT(SHOW, "buf size larger than file, set defaule value, no buf.");
    } else
        DBGPRINT(SHOW, " Alloc buf for save fwlog, size is %d.", buf_size);

    osi_usleep(10000);

    /* check already exist file under log_path */
#if 0
    char temp_zero_filename[36] = {0};
    DIR *p_dir = osi_opendir(log_path);
    if (p_dir != NULL) {
        DIRENT *p_file;
        while ((p_file = osi_readdir(p_dir)) != NULL) {
            /* ignore . and .. directory */
            if (strncmp(osi_get_dirent_name(p_file), "..", 2) == 0
                || strncmp(osi_get_dirent_name(p_file), ".", 1) == 0) {
                continue;
            }

            /* Remove the old fw_dump log */
            if (strstr(osi_get_dirent_name(p_file), FW_DUMP_PICUS_NAME_PREFIX) != NULL) {
                memset(temp_zero_filename, 0, sizeof(temp_zero_filename));
                snprintf(temp_zero_filename, sizeof(temp_zero_filename), "%s", osi_get_dirent_name(p_file));
                memset(fullname, 0, sizeof(fullname));
                snprintf(fullname, sizeof(fullname), "%s/%s", log_path, temp_zero_filename);
                if (osi_remove(fullname)) {
                    DBGPRINT(SHOW, "The old log:%s can't remove", temp_zero_filename);
                } else {
                    DBGPRINT(SHOW, "The old log:%s remove", temp_zero_filename);
                }
            }
        }
        osi_closedir(p_dir);
    }
#endif

    ret = 0;
    retry_file_open = 0;

    do {
        FD_ZERO(&rset);
        FD_ZERO(&card_remove);
        osi_FD_SET(fd,&rset);
        osi_FD_SET(fd,&card_remove);
        set_timeval(&tv, 20, 0);/* timeout is 20s for select method */
        if (osi_select(fd + 1, &rset, &card_remove, NULL, &tv) == 0) {
            DBGPRINT(TRACE, "Read data timeout(20s) from %s", CUST_WIFI_FWLOG_PORT);
            continue;
        }

		if(osi_FD_ISSET(fd, &card_remove)) {
			DBGPRINT(ERROR, "Select fail, close fd first");
			unlock_device_node(fd, &fl, OSI_F_UNLCK, OSI_SEEK_SET);
			if (fd > 0)
				osi_close(fd);
			goto open_again;
		}

        if (!osi_FD_ISSET(fd, &rset))
            continue;
#ifdef OS_FRTOS
        /* Read packet header and length from driver fwlog queue */
        memset(buffer, 0, sizeof(buffer));
        ret = osi_read(fd, buffer, FIRST_READ_LEN);

        if (ret <= 0)
            continue;

        nRead = ret;
        CHECK_READ_LENGTH(ret, FIRST_READ_LEN);
#else
        /* Read all packet from driver fwlog queue */
        memset(buffer, 0, sizeof(buffer));
        ret = osi_read(fd, buffer, sizeof(buffer));
        nRead = ret;
#endif

        if (nRead >= 3) {
			/* dump file for fw dump */
			if (fw_dump_fscript == NULL) {
				osi_time(&local_timestamp);
				osi_strftime(timestamp_buffer, 24, "%Y%m%d%H%M%S", osi_localtime(&local_timestamp));
				/* combine file path and file name */
				/* add sequence number behind timestamp for get same timestamp case */
				snprintf(fw_dump_file_name, sizeof(fw_dump_file_name), "%s/" FW_DUMP_PICUS_NAME_PREFIX "%s_%d",
						log_path, timestamp_buffer, fw_dump_file_seq);
				fw_dump_file_seq++;
			
				while(1) {
					if ((fw_dump_fscript = osi_fopen(fw_dump_file_name, "wb")) == NULL) {
						DBGPRINT(ERROR, "Open script file %s fail [%s] errno %d", fw_dump_file_name,
								strerror(errno), errno);
						if (retry_file_open >= RETRY_COUNT)
							goto done;
					} else {
						DBGPRINT(SHOW, "%s created, dumping...", fw_dump_file_name);
						retry_file_open = 0;
						break;
					}
					++retry_file_open;
				}
			}
			fw_dump_writetofilelength = nRead;
			if (buffer[nRead - 5] == ' ' &&
				buffer[nRead - 4] == 'e' &&
				buffer[nRead - 3] == 'n' &&
				buffer[nRead - 2] == 'd') {
				coredump_end = 1;
				DBGPRINT(SHOW, "FW dump end");
			} 
			osi_fwrite(&buffer[0], 1, fw_dump_writetofilelength, fw_dump_fscript);
			osi_fflush(fw_dump_fscript);
			if (coredump_end) {
				osi_fclose(fw_dump_fscript);
				fw_dump_fscript = NULL;
				coredump_end = 0;
			}
    	}
        ret = 0;
    } while (cont);

done:
    /* unlock the device node */
    unlock_device_node(fd, &fl, OSI_F_UNLCK, OSI_SEEK_SET);

    if (fd > 0) osi_close(fd);

    if (fw_dump_fscript) {
        DBGPRINT(SHOW, "release %s", fw_dump_file_name);
        osi_fclose(fw_dump_fscript);
        fw_dump_fscript = NULL;
        coredump_end = 0;
    }

    return 0;
}
//---------------------------------------------------------------------------
