/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.2*/
#ifndef _HALBB_HWIMG_RAW_DATA_8851B_H
#define _HALBB_HWIMG_RAW_DATA_8851B_H


/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8851b_phy_reg[] = {
		0x704, 0x601E0500,
		0x4000, 0x00000000,
		0x4004, 0xCA014000,
		0x4008, 0xC751D4F0,
		0x400C, 0x44511475,
		0x4010, 0x00000000,
		0x4014, 0x00000000,
		0x47BC, 0x00000380,
		0x4018, 0x4F4C084B,
		0x401C, 0x084A4E52,
		0x4020, 0x4D504E4B,
		0x4024, 0x4F4C0849,
		0x4028, 0x08484C50,
		0x402C, 0x4C50504C,
		0x4030, 0x5454084A,
		0x4034, 0x084B5654,
		0x4038, 0x6A6C605A,
		0x403C, 0x4C4C084C,
		0x4040, 0x084B4E4D,
		0x4044, 0x4E4C4B4B,
		0x4048, 0x4B4B084A,
		0x404C, 0x084A4E4C,
		0x4050, 0x514F4C4A,
		0x4054, 0x524E084A,
		0x4058, 0x084A5154,
		0x405C, 0x53555554,
		0x4060, 0x45450845,
		0x4064, 0x08454144,
		0x4068, 0x40434445,
		0x406C, 0x44450845,
		0x4070, 0x08444043,
		0x4074, 0x42434444,
		0x4078, 0x46450844,
		0x407C, 0x08444843,
		0x4080, 0x4B4E4A47,
		0x4084, 0x4F4C084B,
		0x4088, 0x084A4E52,
		0x408C, 0x4D504E4B,
		0x4090, 0x4F4C0849,
		0x4094, 0x08484C50,
		0x4098, 0x4C50504C,
		0x409C, 0x5454084A,
		0x40A0, 0x084B5654,
		0x40A4, 0x6A6C605A,
		0x40A8, 0x4C4C084C,
		0x40AC, 0x084B4E4D,
		0x40B0, 0x4E4C4B4B,
		0x40B4, 0x4B4B084A,
		0x40B8, 0x084A4E4C,
		0x40BC, 0x514F4C4A,
		0x40C0, 0x524E084A,
		0x40C4, 0x084A5154,
		0x40C8, 0x53555554,
		0x40CC, 0x45450845,
		0x40D0, 0x08454144,
		0x40D4, 0x40434445,
		0x40D8, 0x44450845,
		0x40DC, 0x08444043,
		0x40E0, 0x42434444,
		0x40E4, 0x46450844,
		0x40E8, 0x08444843,
		0x40EC, 0x4B4E4A47,
		0x40F0, 0x00000000,
		0x4A38, 0x00000000,
		0x40F4, 0x00000006,
		0x40F8, 0x00000000,
		0x40FC, 0x8C30C30C,
		0x4100, 0x4C30C30C,
		0x4104, 0x0C30C30C,
		0x4108, 0x0C30C30C,
		0x410C, 0x0C30C30C,
		0x4110, 0x0C30C30C,
		0x4114, 0x28A28A28,
		0x4118, 0x28A28A28,
		0x411C, 0x28A28A28,
		0x4120, 0x28A28A28,
		0x4124, 0x28A28A28,
		0x4128, 0x28A28A28,
		0x412C, 0x06666666,
		0x4130, 0x33333333,
		0x4134, 0x33333333,
		0x4138, 0x33333333,
		0x413C, 0x00000031,
		0x4140, 0x5100600A,
		0x4144, 0x18363113,
		0x4148, 0x1D976DDC,
		0x414C, 0x1C072DD7,
		0x4150, 0x1127CDF4,
		0x4154, 0x1E37BDF1,
		0x4158, 0x1FB7F1D6,
		0x415C, 0x1EA7DDF9,
		0x4160, 0x1FE445DD,
		0x4164, 0x1F97F1FE,
		0x4168, 0x1FF781ED,
		0x416C, 0x1FA7F5FE,
		0x4170, 0x1E07B913,
		0x4174, 0x1FD7FDFF,
		0x4178, 0x1E17B9FA,
		0x417C, 0x19A66914,
		0x4180, 0x10F65598,
		0x4184, 0x14A5A111,
		0x4188, 0x1D3765DB,
		0x418C, 0x17C685CA,
		0x4190, 0x1107C5F3,
		0x4194, 0x1B5785EB,
		0x4198, 0x1F97ED8F,
		0x419C, 0x1BC7A5F3,
		0x41A0, 0x1FE43595,
		0x41A4, 0x1EB7D9FC,
		0x41A8, 0x1FE65DBE,
		0x41AC, 0x1EC7D9FC,
		0x41B0, 0x1976FCFF,
		0x41B4, 0x1F77F5FF,
		0x41B8, 0x1976FDEC,
		0x41BC, 0x198664EF,
		0x41C0, 0x11062D93,
		0x41C4, 0x10C4E910,
		0x41C8, 0x1CA759DB,
		0x41CC, 0x1335A9B5,
		0x41D0, 0x1097B9F3,
		0x41D4, 0x17B72DE1,
		0x41D8, 0x1F67ED42,
		0x41DC, 0x18074DE9,
		0x41E0, 0x1FD40547,
		0x41E4, 0x1D57ADF9,
		0x41E8, 0x1FE52182,
		0x41EC, 0x1D67B1F9,
		0x41F0, 0x14860CE1,
		0x41F4, 0x1EC7E9FE,
		0x41F8, 0x14860DD6,
		0x41FC, 0x195664C7,
		0x4200, 0x0005E58A,
		0x4204, 0x00000000,
		0x4208, 0x00000000,
		0x420C, 0x7A000000,
		0x4210, 0x0F9F3D7A,
		0x4214, 0x0040817C,
		0x4218, 0x00E10204,
		0x421C, 0x227D94CD,
		0x4220, 0x08028A28,
		0x4224, 0x00000200,
		0x4228, 0x04688000,
		0x47C0, 0x00000001,
		0x4A48, 0x00000002,
		0x4B04, 0x00000000,
		0x4B08, 0x00000000,
		0x422C, 0x0060B002,
		0x4230, 0x9A8249A8,
		0x4234, 0x26A1469E,
		0x4238, 0x2099A824,
		0x423C, 0x2359461C,
		0x4240, 0x1631A675,
		0x4244, 0x2C6B1D63,
		0x4248, 0x0000000E,
		0x424C, 0x00000001,
		0x4250, 0x00000001,
		0x4254, 0x00000000,
		0x4258, 0x00000000,
		0x425C, 0x00000000,
		0x4260, 0x0020000C,
		0x4A30, 0x00000000,
		0x4264, 0x00000000,
		0x4268, 0x00000000,
		0x426C, 0x0418317C,
		0x4270, 0x2B33135C,
		0x4274, 0x00000002,
		0x4278, 0x00000000,
		0x427C, 0x00000000,
		0x4280, 0x00000000,
		0x4284, 0x00000000,
		0x4288, 0x00000000,
		0x428C, 0x00000000,
		0x4290, 0x00000000,
		0x4294, 0x00000000,
		0x4298, 0x00000000,
		0x429C, 0x84026000,
		0x42A0, 0x0051AC20,
		0x4A24, 0x0010C040,
		0x42A4, 0x02024008,
		0x42A8, 0x00000000,
		0x42AC, 0x00000000,
		0x42B0, 0x22CE803C,
		0x42B4, 0xD8000000,
		0x42B8, 0x596FD67E,
		0x42BC, 0x7D67D67D,
		0x42C0, 0x7D67D65B,
		0x42C4, 0x28029F59,
		0x42C8, 0x00280280,
		0x4AF4, 0x00000000,
		0x42CC, 0x00000000,
		0x42D0, 0x00000000,
		0x42D4, 0x00000003,
		0x4AF8, 0x00280000,
		0x42D8, 0x00000001,
		0x42DC, 0x69AEC800,
		0x42E0, 0x8B4CD3D1,
		0x42E4, 0xC514534F,
		0x42E8, 0x85145145,
		0x42EC, 0x45145145,
		0x42F0, 0x05145145,
		0x42F4, 0x05145145,
		0x42F8, 0x05145145,
		0x42FC, 0x17659145,
		0x4300, 0x176DD5D9,
		0x4304, 0x0F65765B,
		0x4308, 0x0F3CF3CF,
		0x430C, 0x0F3CF3CF,
		0x4310, 0x0F3CF3CF,
		0x4314, 0x0F3CF3CF,
		0x4318, 0x0F3CF3CF,
		0x431C, 0x0F3CF3CF,
		0x4320, 0x0F3CF3CF,
		0x4324, 0x0F44F351,
		0x4328, 0x192D7547,
		0x432C, 0x0F5CF5CF,
		0x4330, 0x051593D9,
		0x4334, 0x05145145,
		0x4338, 0x05145145,
		0x433C, 0x05145145,
		0x4340, 0x05145145,
		0x4344, 0x05145145,
		0x4348, 0x19545145,
		0x434C, 0x1B65B5DB,
		0x4350, 0x1965965B,
		0x4354, 0x0F3CF3CF,
		0x4358, 0x0F3CF3CF,
		0x435C, 0x0F3CF1CF,
		0x4360, 0x0F3CF3CF,
		0x4364, 0x0F3CF3CF,
		0x4368, 0x0F3CF3CF,
		0x436C, 0x0F3CF3CF,
		0x4370, 0x0934D2CF,
		0x4374, 0x112CB3CF,
		0x4378, 0x9777A777,
		0x437C, 0xBB7BAC95,
		0x4380, 0xB667B889,
		0x4384, 0x7B9B8899,
		0x4388, 0x7A5567C8,
		0x438C, 0x2278CCCC,
		0x4390, 0x7C222222,
		0x4394, 0x0000029B,
		0x4398, 0x001CCCCC,
		0x4AAC, 0xCCCCC88C,
		0x4AB0, 0x0000AACC,
		0x439C, 0x00000000,
		0x43A0, 0x00000008,
		0x43A4, 0x00000000,
		0x43A8, 0x00000000,
		0x43AC, 0x00000000,
		0x43B0, 0x10000000,
		0x43B4, 0x00401001,
		0x43B8, 0x00061003,
		0x43BC, 0x000024D8,
		0x43C0, 0x00000000,
		0x43C4, 0x10000020,
		0x43C8, 0x20000200,
		0x43CC, 0x00000000,
		0x43D0, 0x04000000,
		0x43D4, 0x44000100,
		0x43D8, 0x60804060,
		0x43DC, 0x44204210,
		0x43E0, 0x82108082,
		0x43E4, 0x82108402,
		0x43E8, 0xC8082108,
		0x43EC, 0xC8202084,
		0x43F0, 0x44208208,
		0x43F4, 0x84108204,
		0x43F8, 0xD0108104,
		0x43FC, 0xF8210108,
		0x4400, 0x6431E930,
		0x4404, 0x02309468,
		0x4408, 0x10C61C22,
		0x440C, 0x02109469,
		0x4410, 0x10C61C22,
		0x4414, 0x00041049,
		0x4A4C, 0x00060581,
		0x4418, 0x00000000,
		0x441C, 0x00000000,
		0x4420, 0xEC000000,
		0x4424, 0xB0200020,
		0x4428, 0x00001FF0,
		0x4AC8, 0x00000001,
		0x4B0C, 0x00000000,
		0x4CDC, 0x00000000,
		0x442C, 0x00000000,
		0x4430, 0x00000000,
		0x4434, 0x00000000,
		0x4438, 0x00000000,
		0x443C, 0x190642D0,
		0x4440, 0xA80668A0,
		0x4444, 0x60900820,
		0x4448, 0x9F28518C,
		0x444C, 0x32488A62,
		0x4450, 0x9C6E36DC,
		0x4454, 0x0000F52B,
		0x4A34, 0x00000007,
		0x4CE0, 0x68120000,
		0x4CE4, 0x1A0681E0,
		0x4CE8, 0x94060180,
		0x4CEC, 0x000603FF,
		0x4CF0, 0xA0502000,
		0x4CF4, 0x00001000,
		0x4D00, 0x00000044,
		0x4B14, 0x00000000,
		0x4458, 0x00000000,
		0x445C, 0x4801442E,
		0x4460, 0x0051A0FA,
		0x4B18, 0x0000011F,
		0x4B1C, 0x0000011F,
		0x4464, 0x00000000,
		0x4468, 0x00000000,
		0x446C, 0x00000000,
		0x4470, 0x00000000,
		0x4474, 0x00000000,
		0x4478, 0x00000000,
		0x447C, 0x00000000,
		0x4480, 0x2A0A6040,
		0x4484, 0x0A0A6829,
		0x4488, 0x00000004,
		0x448C, 0x00000000,
		0x4490, 0x80000000,
		0x4494, 0x10000000,
		0x4498, 0xE0000000,
		0x4A28, 0x000ED877,
		0x4AB4, 0x00000000,
		0x4B20, 0x00000000,
		0x4B24, 0x00000000,
		0x4B28, 0x00000000,
		0x4B2C, 0x00000000,
		0x449C, 0x0000001E,
		0x44A0, 0x02B2C394,
		0x44A4, 0x00000400,
		0x4A2C, 0x0050240E,
		0x4B30, 0x7FFFFD20,
		0x4B34, 0x920823FF,
		0x4B38, 0x7FFFFFFF,
		0x4B3C, 0x01773773,
		0x44A8, 0x00000001,
		0x44AC, 0x000190C0,
		0x44B0, 0x00000000,
		0x44B4, 0x00000000,
		0x44B8, 0x00000000,
		0x44BC, 0x00000000,
		0x44C0, 0x00000000,
		0x44C4, 0x00000000,
		0x44C8, 0x00000000,
		0x44CC, 0x00000000,
		0x44D0, 0x00000000,
		0x44D4, 0x00000000,
		0x44D8, 0x00000000,
		0x44DC, 0x00000000,
		0x44E0, 0x00000000,
		0x44E4, 0x00000000,
		0x44E8, 0x00000000,
		0x44EC, 0x00000000,
		0x44F0, 0x00000000,
		0x44F4, 0x00000000,
		0x44F8, 0x00000000,
		0x44FC, 0x00000000,
		0x4500, 0x00000000,
		0x4504, 0x00000000,
		0x4508, 0x00000000,
		0x450C, 0x00000000,
		0x4510, 0x00000000,
		0x4514, 0x00000000,
		0x4518, 0x00000000,
		0x451C, 0x00000000,
		0x4520, 0x00000000,
		0x4524, 0x00000000,
		0x4528, 0x00000000,
		0x452C, 0x00000000,
		0x4530, 0x4E830171,
		0x4534, 0x00000870,
		0x4538, 0x000000FF,
		0x453C, 0x00000000,
		0x4540, 0x00000000,
		0x4544, 0x00000000,
		0x4548, 0x00000000,
		0x454C, 0x00000000,
		0x4550, 0x00000000,
		0x4554, 0x00000000,
		0x4558, 0x00000000,
		0x455C, 0x00000000,
		0x4560, 0x40000000,
		0x4564, 0x40000000,
		0x4568, 0x00000000,
		0x456C, 0x20000000,
		0x4570, 0x04F040BB,
		0x4574, 0x000E53FF,
		0x4578, 0x000205CB,
		0x457C, 0x00200000,
		0x4580, 0x00000040,
		0x4584, 0x00000000,
		0x4588, 0x00000017,
		0x458C, 0x30000000,
		0x4590, 0x00000000,
		0x4594, 0x00000000,
		0x4598, 0x00000001,
		0x459C, 0x0003FE00,
		0x45A0, 0x00000086,
		0x45A4, 0x00000000,
		0x45A8, 0xC00001C0,
		0x45AC, 0x78038000,
		0x45B0, 0x8000004A,
		0x45B4, 0x04094800,
		0x45B8, 0x00280002,
		0x45BC, 0x06748790,
		0x45C0, 0x80000000,
		0x45C4, 0x00000000,
		0x45C8, 0x00000000,
		0x45CC, 0x00558670,
		0x45D0, 0x002883F0,
		0x45D4, 0x00090120,
		0x45D8, 0x00000000,
		0x45E0, 0xA3A6D3C4,
		0x45E4, 0xAB27B126,
		0x45E8, 0x00006778,
		0x45F4, 0x000001B5,
		0x45EC, 0x11110F0A,
		0x45F0, 0x00000003,
		0x4A0C, 0x0000000A,
		0x45F8, 0x0058BC3F,
		0x45FC, 0x00000003,
		0x462C, 0x00000020,
		0x4600, 0x000003D9,
		0x45F0, 0x00000004,
		0x4604, 0x002B1CB0,
		0x4A50, 0xC0000000,
		0x4A54, 0x00001000,
		0x4A58, 0x00000000,
		0x4A18, 0x00000024,
		0x4608, 0x00000001,
		0x460C, 0x00000000,
		0x4A10, 0x00000001,
		0x4610, 0x00000001,
		0x4614, 0x16E5298F,
		0x4618, 0x18C6294A,
		0x461C, 0x0E06318A,
		0x4620, 0x0E539CE5,
		0x4624, 0x00019287,
		0x4A14, 0x000000BF,
		0x4628, 0x00000001,
		0x4630, 0x000001AA,
		0x4A18, 0x00001900,
		0x4A1C, 0x000002A6,
		0x4634, 0x000000A3,
		0x4A20, 0x00000086,
		0x4638, 0x00045656,
		0x49F8, 0x00000000,
		0x463C, 0x00000000,
		0x4640, 0x00000000,
		0x4644, 0x00C8CC00,
		0x4648, 0xC400B6B6,
		0x464C, 0xDC400FC0,
		0x4A44, 0x00000000,
		0x4A8C, 0x00000110,
		0x4BC4, 0x00000001,
		0x4650, 0x08882550,
		0x4654, 0x08CC2660,
		0x4658, 0x09102660,
		0x465C, 0x00000154,
		0x45DC, 0xC39E38E8,
		0x4660, 0x452607E6,
		0x4664, 0x6750DC65,
		0x4668, 0xF3F0F1ED,
		0x466C, 0x30141506,
		0x4670, 0x2C2B2B2B,
		0x4674, 0x2C2C2C2C,
		0x4678, 0xDDB738E8,
		0x467C, 0x543618FB,
		0x4680, 0x4F31DC6F,
		0x4684, 0xFBEBDA00,
		0x4688, 0x1A10FF04,
		0x468C, 0x282A3000,
		0x4690, 0x2A29292A,
		0x4694, 0x04FA2A2A,
		0x4698, 0xEE0F04D1,
		0x469C, 0x99E91436,
		0x46A0, 0x0701E79E,
		0x46A4, 0x08D77CFF,
		0x46A8, 0x321AFF14,
		0x46AC, 0x60313447,
		0x46B0, 0x63666666,
		0x46B4, 0x35374425,
		0x46B8, 0x35883042,
		0x46BC, 0x5177C252,
		0x4720, 0x7FFFFD63,
		0x4724, 0xB58D11FF,
		0x4728, 0x47FFFFFF,
		0x472C, 0x0E7893B6,
		0x4730, 0xE0391201,
		0x4734, 0x00000020,
		0x4738, 0x8325C500,
		0x473C, 0x00000B7F,
		0x46C0, 0x00000000,
		0x46C4, 0x00000000,
		0x46C8, 0x00000219,
		0x4BDC, 0x00002020,
		0x46CC, 0x00000000,
		0x46D0, 0x00000000,
		0x4A3C, 0x00000002,
		0x46D4, 0x00000001,
		0x46D8, 0x00000001,
		0x46DC, 0x00000000,
		0x46E0, 0x00000000,
		0x46E4, 0x00000151,
		0x46E8, 0x00000498,
		0x46EC, 0x00000498,
		0x46F0, 0x00000000,
		0x46F4, 0x00000000,
		0x46F8, 0x00001146,
		0x46FC, 0x00000000,
		0x4700, 0x00000000,
		0x4704, 0x00C8CC00,
		0x4708, 0xC400B6B6,
		0x470C, 0xDC400FC0,
		0x4A90, 0x00000110,
		0x4B10, 0x00000000,
		0x4BE0, 0x00000001,
		0x4710, 0x08882550,
		0x4714, 0x08CC2660,
		0x4718, 0x09102660,
		0x471C, 0x00000154,
		0x4740, 0xC69F38E8,
		0x4744, 0x462709E9,
		0x4748, 0x6750DC67,
		0x474C, 0xF3F0F1ED,
		0x4750, 0x30141506,
		0x4754, 0x2C2B2B2B,
		0x4758, 0x2C2C2C2C,
		0x475C, 0xE0B738E8,
		0x4760, 0x52381BFE,
		0x4764, 0x5031DC6C,
		0x4768, 0xFBEBDA00,
		0x476C, 0x1A10FF04,
		0x4770, 0x282A3000,
		0x4774, 0x2A29292A,
		0x4778, 0x04FA2A2A,
		0x477C, 0xEE0F04D1,
		0x47C4, 0x00000000,
		0x47C8, 0xA32103FE,
		0x47CC, 0xB20A5328,
		0x47D0, 0xC686314F,
		0x47D4, 0x000004D7,
		0x4BFC, 0x00000000,
		0x4C00, 0x0C442416,
		0x4C04, 0x00000000,
		0x47D8, 0x009B902A,
		0x47DC, 0x009B902A,
		0x47E0, 0x98682C18,
		0x47E4, 0x6318C4C1,
		0x47E8, 0x6248C631,
		0x47EC, 0x922A8253,
		0x47F0, 0x00000005,
		0x47F4, 0x00001759,
		0x47F8, 0x4BB01800,
		0x47FC, 0x831408BE,
		0x4A84, 0x000000E9,
		0x4C08, 0x0F801404,
		0x4C0C, 0x00A2B404,
		0x4800, 0x9ABBCACB,
		0x4804, 0x56867578,
		0x4808, 0xBCCBBB13,
		0x480C, 0x7889989B,
		0x4810, 0xBBB0F455,
		0x4814, 0x777BBBBB,
		0x4818, 0x15277777,
		0x481C, 0x27039CE9,
		0x4820, 0x42424432,
		0x4824, 0x36058342,
		0x4828, 0x00000006,
		0x482C, 0x00000005,
		0x4830, 0x00000005,
		0x4834, 0xC7013016,
		0x4838, 0x84413016,
		0x483C, 0x84413016,
		0x4840, 0x8C413016,
		0x4844, 0x8C40B028,
		0x4848, 0x3140B028,
		0x484C, 0x2940B028,
		0x4850, 0x8440B028,
		0x4854, 0x2318C610,
		0x4858, 0x45344753,
		0x485C, 0x236A6A88,
		0x4860, 0xAC8DF814,
		0x4864, 0x08877ACB,
		0x4868, 0x000107AA,
		0x4A94, 0x00000000,
		0x486C, 0xBCEB4A14,
		0x4870, 0x000A3A4A,
		0x4874, 0xBCEB4A14,
		0x4878, 0x000A3A4A,
		0x487C, 0xBCBDBD85,
		0x4880, 0x0CABB99A,
		0x4884, 0x38384242,
		0x4888, 0x0086102E,
		0x488C, 0xCA24C82A,
		0x4AFC, 0x00000000,
		0x4C14, 0x0000349D,
		0x4CF8, 0x00000007,
		0x4890, 0x00008A62,
		0x4894, 0x00000008,
		0x4958, 0x80040000,
		0x495C, 0x80040000,
		0x4960, 0xFE800000,
		0x4964, 0x834C0000,
		0x4968, 0x00000000,
		0x496C, 0x00000000,
		0x4970, 0x00000000,
		0x4974, 0x00000000,
		0x4978, 0x00000000,
		0x497C, 0x00000000,
		0x4980, 0x40000000,
		0x4984, 0x00000000,
		0x4988, 0x00000000,
		0x498C, 0x00000000,
		0x4990, 0x00000000,
		0x4994, 0x04065800,
		0x4998, 0x02004080,
		0x499C, 0x0E1E3E05,
		0x49A0, 0x0A163068,
		0x49A4, 0x00206040,
		0x49A8, 0x02020202,
		0x49AC, 0x00002020,
		0x49B0, 0xF8F8F418,
		0x49B4, 0xF8E8F8F8,
		0x49B8, 0xF80808E8,
		0x4A00, 0xF8F8FA00,
		0x4A04, 0xFAFAFAF8,
		0x4A08, 0xFAFAFAFA,
		0x49BC, 0x00000000,
		0x49C0, 0x800C562D,
		0x49C4, 0x00000101,
		0x49C8, 0x00000000,
		0x49CC, 0x00000000,
		0x49D0, 0x00000000,
		0x49D4, 0x00000000,
		0x49D8, 0x00000000,
		0x49DC, 0x00000000,
		0x49E0, 0x00000000,
		0x49E4, 0x00000000,
		0x49E8, 0x00000000,
		0x49EC, 0x00000000,
		0x4C28, 0x00000000,
		0x4C2C, 0x00000000,
		0x4C30, 0x00000000,
		0x4C34, 0x00000000,
		0x4C38, 0x00000000,
		0x4C3C, 0x00000000,
		0x4C40, 0x00000000,
		0x4C44, 0x01C0C832,
		0x4C48, 0x03207032,
		0x4C4C, 0x0320701C,
		0x4C50, 0x03207032,
		0x4C54, 0x01C0C81C,
		0x4C58, 0x00A0281C,
		0x4C5C, 0x0320C80A,
		0x4C60, 0x00A0C832,
		0x4C64, 0x01C0C832,
		0x4C68, 0x03207032,
		0x4C6C, 0x0320701C,
		0x4C70, 0x03207032,
		0x4C74, 0x01C0C81C,
		0x4C78, 0x00A0281C,
		0x4C7C, 0x0321A80A,
		0x4C80, 0x0320C86A,
		0x4C84, 0x12B02832,
		0x4C88, 0x12B3292B,
		0x4C8C, 0x0CA4ACCA,
		0x4C90, 0x12B4AC6A,
		0x4C94, 0x0CA4ACCA,
		0x4C98, 0x06A3292B,
		0x4C9C, 0x06A0280A,
		0x4CA0, 0x0CA0286A,
		0x4CA4, 0x0CA1A8CA,
		0x4CA8, 0x06A3286A,
		0x4CAC, 0x0000000A,
		0x4CB0, 0x01209C27,
		0x4CB4, 0x02704800,
		0x4CB8, 0x02704812,
		0x4CBC, 0x00004827,
		0x4CC0, 0x01209C12,
		0x4CC4, 0x00000012,
		0x4CC8, 0x02718000,
		0x4CCC, 0x02709C60,
		0x4CD0, 0x00000027,
		0x4CD4, 0x00000000,
		0x4CD8, 0x0000014A,
		0x994, 0x00000010,
		0x904, 0x00000005,
		0x708, 0x00000000,
		0x884, 0x0043F01D,
		0x710, 0xEF810000,
		0x718, 0x1333233F,
		0x604, 0x041E1E1E,
		0x714, 0x00010000,
		0x586C, 0x000000F0,
		0x586C, 0x000000E0,
		0x586C, 0x000000D0,
		0x586C, 0x000000C0,
		0x586C, 0x000000B0,
		0x586C, 0x000000A0,
		0x586C, 0x00000090,
		0x586C, 0x00000080,
		0x586C, 0x00000070,
		0x586C, 0x00000060,
		0x586C, 0x00000050,
		0x586C, 0x00000040,
		0x586C, 0x00000030,
		0x586C, 0x00000020,
		0x586C, 0x00000010,
		0x586C, 0x00000000,
		0xC0D4, 0xABA41460,
		0xC0D8, 0xC43A7E87,
		0xC0DC, 0x30C194B8,
		0xC0E0, 0x75008138,
		0xC0E4, 0x0000272B,
		0xC0E8, 0x000A0C81,
		0xC0EC, 0x00030003,
		0xC0F0, 0x00000024,
		0xC0C4, 0x005E3A00,
		0xC004, 0x45800000,
		0xC024, 0x45800000,
		0x334, 0xFFFFFFFF,
		0x33C, 0x55000000,
		0x340, 0x00005555,
		0x724, 0x00111200,
		0x5868, 0xA9550000,
		0x5870, 0x33221100,
		0x5874, 0x77665544,
		0x5878, 0xBBAA9988,
		0x587C, 0xFFEEDDCC,
		0x5880, 0x76543210,
		0x5884, 0xFEDCBA98,
		0x5888, 0x00000000,
		0x588C, 0x00000000,
		0x5894, 0x00000008,
		0x650, 0x00200888,
		0x710, 0xF3810000,
		0x020, 0x0000F381,
		0x024, 0x0000F381,
		0x000, 0xC580801E,
		0x980, 0x10002250,
		0x988, 0x3C3C4107,
		0x994, 0x00000010,
		0x000, 0x0580801F,
		0x240C, 0x00000000,
		0x640, 0x210A141E,
		0x640, 0x2114141E,
		0x640, 0x2114141E,
		0x644, 0x3414283C,
		0x644, 0x3425283C,
		0x644, 0x3426283C,
		0x2640, 0x140A141E,
		0x2640, 0x1414141E,
		0x2640, 0x1414141E,
		0x2644, 0x3414283C,
		0x2644, 0x3425283C,
		0x2644, 0x3425183C,
		0x2300, 0x02748790,
		0x2304, 0x00558670,
		0x2308, 0x002883F0,
		0x230C, 0x00090120,
		0x2310, 0x00000000,
		0x2314, 0x06000000,
		0x2318, 0x00000000,
		0x231C, 0x00000000,
		0x2320, 0x03020100,
		0x2324, 0x07060504,
		0x2328, 0x0B0A0908,
		0x232C, 0x0F0E0D0C,
		0x2330, 0x13121110,
		0x2334, 0x17161514,
		0x2338, 0x0C700022,
		0x233C, 0x0A0529D0,
		0x2340, 0x000529D0,
		0x2344, 0x0006318A,
		0x2348, 0xB7E6318A,
		0x234C, 0x80039C00,
		0x2350, 0x80039C00,
		0x2354, 0x0005298F,
		0x2358, 0x0015296E,
		0x235C, 0x0C07FC31,
		0x2360, 0x0219AAAE,
		0x2364, 0xE4F624C3,
		0x2368, 0x53626F15,
		0x236C, 0x48000000,
		0x2370, 0x48000000,
		0x2374, 0x07540000,
		0x2378, 0x202401B9,
		0x237C, 0x00F7000E,
		0x2380, 0x0F0A1111,
		0x2384, 0x30D9000F,
		0x2388, 0x0200EA02,
		0x238C, 0x003CB061,
		0x2390, 0x69C00000,
		0x2394, 0x00000000,
		0x2398, 0x000000F0,
		0x239C, 0x0001FFFF,
		0x23A0, 0x00C80064,
		0x23A4, 0x0190012C,
		0x23A8, 0x001917BE,
		0x23AC, 0x0B30880C,
		0x23B0, 0x9281CE00,
		0x23B4, 0x7F027C00,
		0x704, 0x601E0502,
		0x5600, 0x00000000,
		0x5604, 0x802D2721,
		0x5610, 0x00201020,
		0x5618, 0x00801008,
		0x5624, 0x0808081E,
		0x562C, 0x0000081D,
		0x5634, 0x3D2EE000,
		0x5638, 0x0001AC42,
		0x5640, 0x3D6EF000,
		0x5644, 0x0001AC3E,
		0x566C, 0x00210005,
		0x5680, 0x20500010,
		0x5684, 0x00020001,
		0x56A0, 0x0034C000,
		0x56BC, 0x04000000,
		0x56C0, 0x00000688,
		0x56C4, 0x00000010,
		0x56C8, 0x0E800400,
		0x56CC, 0x01E400FF,
		0x5800, 0x003F807F,
		0x5810, 0x59008400,
		0x5814, 0x201AF000,
		0x5818, 0x182C18E8,
		0x581C, 0x3DD80280,
		0x5820, 0x80000080,
		0x5828, 0x023F8121,
		0x5830, 0x023F8121,
		0x5838, 0x003F8121,
		0x5840, 0x023F8121,
		0x5848, 0x023F8121,
		0x5850, 0x023F8121,
		0x5858, 0x003F7121,
		0x5860, 0x023F7121,
		0x5864, 0x1A1801FF,
		0x5868, 0xA9A90002,
		0x5880, 0x77777777,
		0x5884, 0x77777777,
		0x5894, 0x01080604,
		0x5898, 0x00000000,
		0x589C, 0x00000000,
		0x58A0, 0x000000FE,
		0x58B0, 0x00000800,
		0x58BC, 0x07A7807F,
		0x58C0, 0x007E0000,
		0x58C4, 0x0003FFFF,
		0x58D4, 0x7401FE00,
		0x58D8, 0x8008016C,
		0x58DC, 0xC000807F,
		0x58E4, 0x3000881F,
		0x58E8, 0x00000003,
		0x58F0, 0x400401FF,
		0x58F4, 0x80000000,
		0x58F8, 0xC0000000,
		0x58FC, 0x00000000,
		0x700, 0x40000030,
		0x704, 0x601E0502,
		0x704, 0x601E0500,
		0x704, 0x601E0502,
		0x20FC, 0x00000000,
		0x20F8, 0x00000000,
		0x20F0, 0x00000000,
		0x9C0, 0x00000001,
		0x9C0, 0x00000000,
		0x9C0, 0x00000001,
		0x9C0, 0x00000000,
		0x4AE8, 0x00000744,
		0x4AD4, 0x00000040,
		0x4AE4, 0x0079E99E,
		0x4BC8, 0xFBD5B89F,
		0x4BCC, 0x99563918,
		0x4BD0, 0x12EED5B8,
		0x4BD4, 0x6F7D542F,
		0x4BD8, 0x0000001D,
		0x300, 0xF30CE31C,
		0x304, 0x13EF1F19,
		0x308, 0x0C0CF3F3,
		0x30C, 0x0CE30C0C,
		0x310, 0x80496000,
		0x314, 0x0041E000,
		0x318, 0x20022042,
		0x31C, 0x20448009,
		0x320, 0x00010031,
		0x324, 0xE000E000,
		0x328, 0xE000E000,
		0x32C, 0xE0008049,
		0x12BC, 0x10104041,
		0x12C0, 0x13311111,
		0x12E4, 0x30D52A68,
		0x010, 0x0005FFFF,
		0x028, 0x0000F381,
		0x02C, 0x0000F381,
		0x620, 0x00141230,
		0x70C, 0x00000020,
		0x720, 0x20000000,
		0x730, 0x00000002,
		0x738, 0x004100C0,
		0x73C, 0x00000002,
		0x748, 0x01000002,
		0x74C, 0x00000001,
		0xA08, 0x00007800,
		0xC14, 0x25010000,
		0xC3C, 0x2840E1BF,
		0xC40, 0x00000000,
		0xC44, 0x00000007,
		0xC48, 0x410E4000,
		0xC54, 0x1EE14368,
		0xC58, 0x41000000,
		0xC5C, 0x80558000,
		0xC60, 0x017FFFF2,
		0xC64, 0x0010A130,
		0xC68, 0x90000050,
		0xC6C, 0x10201021,
		0xC70, 0x071B0660,
		0xC74, 0x00000000,
		0xC78, 0x80000000,
		0xC7C, 0x0020BFE0,
		0xC88, 0xC2AC8000,
		0xC8C, 0x02F2FC08,
		0xD00, 0x77777777,
		0xD04, 0xBBBBBBBB,
		0xD08, 0xBBBBBBBB,
		0xD0C, 0x000B2070,
		0xD10, 0x20110FFF,
		0xD18, 0x50009800,
		0xD20, 0x01900000,
		0xD30, 0x03FF8000,
		0xD40, 0xF64FA0F7,
		0xD44, 0x0401463F,
		0xD48, 0x0003FF7F,
		0xD4C, 0x00000000,
		0xD50, 0xF64FA0F7,
		0xD54, 0x04100437,
		0xD58, 0x0000FF7F,
		0xD5C, 0x00000000,
		0xD60, 0x00000000,
		0xD64, 0x00000000,
		0xD70, 0x00000015,
		0xD78, 0x00000001,
		0xD7C, 0x001D050E,
		0xD80, 0x00000100,
		0xD84, 0x00006607,
		0xD90, 0x000003FF,
		0xD94, 0x00000000,
		0xD98, 0x0000003F,
		0xD9C, 0x00000000,
		0xDA0, 0x000003FE,
		0xDA4, 0x00000000,
		0xDA8, 0x0000003F,
		0xDAC, 0x00000000,
		0xDD4, 0x00000000,
		0x1010, 0x00000000,
		0x2000, 0x50BBBF04,
		0x2008, 0x000FFFFF,
		0x5800, 0x03FF807F,
		0x5804, 0x04237040,
		0x5808, 0x04237040,
		0x5818, 0x082C1800,
		0x624, 0x0101030A,
		0x241C, 0x00000001,
		0xC0F8, 0x00000001,
		0x35C, 0x000004C4,
		0x1200, 0x00010142,
		0x120C, 0x00012233,
		0x1210, 0x8049E304,
		0x12A0, 0x49107056,
		0x12A8, 0x33337025,
		0x12AC, 0x12333121,
		0x12B8, 0x30020000,
		0x0F0, 0x00000001,
		0x0F4, 0x00000012,
		0x0F8, 0x20230324,

};


/******************************************************************************
 *                           phy_reg_gain.TXT
 ******************************************************************************/

const u32 array_mp_8851b_phy_reg_gain[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0030000, 0x00000002,
		0xF0040000, 0x00000003,
		0xF0050000, 0x00000004,
		0xF0060000, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x13F6D7B6,
		0x001, 0x00725132,
		0x002, 0x00005A38,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x13F6D7B6,
		0x001, 0x00725132,
		0x002, 0x00005A38,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x13F6D7B6,
		0x001, 0x00725132,
		0x002, 0x00005A38,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x19FADCBC,
		0x001, 0x007A5A3A,
		0x002, 0x00005838,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x19FADCBC,
		0x001, 0x007A5A3A,
		0x002, 0x00005838,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x19FADCBC,
		0x001, 0x007A5A3A,
		0x002, 0x00005838,
	0xA0000000,	0x00000000,
		0x000, 0x13F6D7B6,
		0x001, 0x00725132,
		0x002, 0x00005A38,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0xA0000000,	0x00000000,
		0x100, 0x1BFEE0B7,
		0x101, 0x006C5238,
		0x102, 0x00005031,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x19F8D8C1,
		0x10001, 0x006F4F31,
		0x10002, 0x00006F58,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x19F8D8C1,
		0x10001, 0x006F4F31,
		0x10002, 0x00006F58,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x19F8D8C1,
		0x10001, 0x006F4F31,
		0x10002, 0x00006F58,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x1DF8DAC1,
		0x10001, 0x00755437,
		0x10002, 0x00007058,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x1DF8DAC1,
		0x10001, 0x00755437,
		0x10002, 0x00007058,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x10000, 0x1DF8DAC1,
		0x10001, 0x00755437,
		0x10002, 0x00007058,
	0xA0000000,	0x00000000,
		0x10000, 0x19F8D8C1,
		0x10001, 0x006F4F31,
		0x10002, 0x00006F58,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0xA0000000,	0x00000000,
		0x10100, 0x09E9C69F,
		0x10101, 0x00674627,
		0x10102, 0x00006750,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1AF0D2B8,
		0x20001, 0x00755334,
		0x20002, 0x00006F58,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1AF0D2B8,
		0x20001, 0x00755334,
		0x20002, 0x00006F58,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1AF0D2B8,
		0x20001, 0x00755334,
		0x20002, 0x00006F58,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1D00E2C8,
		0x20001, 0x00775336,
		0x20002, 0x00006D58,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1D00E2C8,
		0x20001, 0x00775336,
		0x20002, 0x00006D58,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x20000, 0x1D00E2C8,
		0x20001, 0x00775336,
		0x20002, 0x00006D58,
	0xA0000000,	0x00000000,
		0x20000, 0x1AF0D2B8,
		0x20001, 0x00755334,
		0x20002, 0x00006F58,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0xA0000000,	0x00000000,
		0x20100, 0x07E9C6A0,
		0x20101, 0x00674728,
		0x20102, 0x00006850,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x15EED2B6,
		0x30001, 0x006F4D2F,
		0x30002, 0x00006F58,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x15EED2B6,
		0x30001, 0x006F4D2F,
		0x30002, 0x00006F58,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x15EED2B6,
		0x30001, 0x006F4D2F,
		0x30002, 0x00006F58,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x1F00E2C6,
		0x30001, 0x00795739,
		0x30002, 0x00006F58,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x1F00E2C6,
		0x30001, 0x00795739,
		0x30002, 0x00006F58,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x30000, 0x1F00E2C6,
		0x30001, 0x00795739,
		0x30002, 0x00006F58,
	0xA0000000,	0x00000000,
		0x30000, 0x15EED2B6,
		0x30001, 0x006F4D2F,
		0x30002, 0x00006F58,
	0xB0000000,	0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0x90030000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0x90040000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0x90050000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0x90060000,	0x00000000,	0x40000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0xA0000000,	0x00000000,
		0x30100, 0x06E9C69F,
		0x30101, 0x00654527,
		0x30102, 0x00006750,
	0xB0000000,	0x00000000,
		0x1000000, 0x000000F4,
		0x1000010, 0x000000F8,
		0x1000011, 0x0000F8F8,
		0x1000100, 0x000000F8,
		0x1000110, 0x00000000,
		0x1000111, 0x00000000,
		0x1010000, 0x000000F4,
		0x1010010, 0x000000F8,
		0x1010011, 0x0000F8F8,
		0x1010020, 0x000000F8,
		0x1010021, 0x0808E8E8,
		0x1010029, 0x0000F8F8,
		0x1010100, 0x000000F4,
		0x1010110, 0x000000F8,
		0x1010111, 0x0000F8F8,
		0x1010120, 0x000000F8,
		0x1010121, 0x0808E8E8,
		0x1010129, 0x0000F8F8,
		0x1020000, 0x000000F4,
		0x1020010, 0x000000F8,
		0x1020011, 0x0000F8F8,
		0x1020020, 0x000000F8,
		0x1020021, 0x0808E8E8,
		0x1020029, 0x0000F8F8,
		0x1020100, 0x000000F4,
		0x1020110, 0x000000F8,
		0x1020111, 0x0000F8F8,
		0x1020120, 0x000000F8,
		0x1020121, 0x0808E8E8,
		0x1020129, 0x0000F8F8,
		0x1030000, 0x000000F4,
		0x1030010, 0x000000F8,
		0x1030011, 0x0000F8F8,
		0x1030020, 0x000000F8,
		0x1030021, 0x0808E8E8,
		0x1030029, 0x0000F8F8,
		0x1030100, 0x000000F4,
		0x1030110, 0x000000F8,
		0x1030111, 0x0000F8F8,
		0x1030120, 0x000000F8,
		0x1030121, 0x0808E8E8,
		0x1030129, 0x0000F8F8,

};


#endif	/* _HALBB_HWIMG_RAW_DATA_8851B_H */