/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

#ifndef _HALBB_PLCP_TX_H_
#define _HALBB_PLCP_TX_H_

/* 0x5428-0x547c; 0x7428-0x747c for digital pwr compensation*/
static const u32 pwr_comp_1ss_32b[][2] = {
		{0x01f400A0, 0x01f400A0},
		{0x0708044c, 0x0708044c},
		{0x00320CE4, 0x00320CE4},
		{0x015E0096, 0x015E0096},
		{0x03c8028A, 0x03c8028A},
		{0x0BB805DC, 0x0BB805DC},
		{0x17701194, 0x17701194},
		{0x03020100, 0x03020100},
		{0x04040404, 0x04040404},
		{0x01000505, 0x01000505},
		{0x06050403, 0x06050403},
		{0x08080807, 0x08080807},
		{0x08060200, 0x06040200},
		{0x100E0B09, 0x0E0C0A08},
		{0x03001111, 0x03000E0E},
		{0x0F0D0A07, 0x0D0A0806},
		{0x16161512, 0x14141210},
		{0x0B080301, 0x0A070301},
		{0x1C16120E, 0x1814100C},
		{0x04021C1C, 0x04021818},
		{0x130D0C09, 0x110D0B08},
		{0x1D1D1D17, 0x19191915}};

static const u32 pwr_comp_2ss_32b[][2] = {
		{0x01f400A0, 0x01f400A0},
		{0x0708044c, 0x0708044c},
		{0x00320CE4, 0x00320CE4},
		{0x015E0096, 0x015E0096},
		{0x03c8028A, 0x03c8028A},
		{0x0BB805DC, 0x0BB805DC},
		{0x17701194, 0x17701194},
		{0x06060400, 0x06060400},
		{0x08080808, 0x08080808},
		{0x05010808, 0x05010808},
		{0x0A090807, 0x0A090807},
		{0x0c0c0c0c, 0x0c0c0c0c},
		{0x0A080602, 0x0A080602},
		{0x15120F0D, 0x15120F0D},
		{0x08031616, 0x08031616},
		{0x14110E0A, 0x14110E0A},
		{0x1A1A1A18, 0x1A1A1A18},
		{0x0F0B0904, 0x0F0B0904},
		{0x201B1812, 0x201B1812},
		{0x0A052020, 0x0A052020},
		{0x1913100C, 0x1913100C},
		{0x2121211C, 0x2121211C}};

static const u32 pwr_comp_92xb[][2] = {
		{0x02F80104, 0x02F80104},
		{0x08D405F0, 0x08D405F0},
		{0x00320CBC, 0x00320CBC},
		{0x015E0096, 0x015E0096},
		{0x03c8028A, 0x03c8028A},
		{0x0BB805DC, 0x0BB805DC},
		{0x17701194, 0x17701194},
		{0x01000000, 0x01000000},
		{0x03030201, 0x03030201},
		{0x00000404, 0x01000404},
		{0x05040201, 0x06040302},
		{0x09090807, 0x09090807},
		{0x04020100, 0x04020100},
		{0x0D0B0908, 0x0C0A0806},
		{0x01000D0D, 0x01000D0D},
		{0x09060402, 0x09060402},
		{0x1111100C, 0x1111100C},
		{0x05030200, 0x05030200},
		{0x120F0A08, 0x120F0A08},
		{0x03001313, 0x03001313},
		{0x0B090604, 0x0B090604},
		{0x14141310, 0x14141310}};

static const u32 pwr_comp_1ss_8852c[] = {
		0x00C80050, 0x00C80050,
		0x038401F4, 0x038401F4,
		0x00320640, 0x00320640,
		0x015E0096, 0x015E0096,
		0x03c8028A, 0x03c8028A,
		0x0BB805DC, 0x0BB805DC,
		0x17701194, 0x17701194,
		0x04030200, 0x04030200,
		0x04040404, 0x04040404,
		0x03000404, 0x03000404,
		0x09080706, 0x09080706,
		0x0A0A0A0A, 0x0A0A0A0A,
		0x0B080401, 0x0B080401,
		0x11100E0D, 0x1312100E,
		0x04011212, 0x04011313,
		0x120F0C09, 0x120F0C09,
		0x16161614, 0x16161614,
		0x0D090501, 0x0E0A0501,
		0x1B181510, 0x1F1B1611,
		0x06021B1B, 0x06021F1F,
		0x17120F0B, 0x17120F0B,
		0x2020201C, 0x2020201C};

static const u32 pwr_comp_2ss_8852c[] = {
		0x00C80050, 0x00C80050,
		0x038401F4, 0x038401F4,
		0x00320640, 0x00320640,
		0x015E0096, 0x015E0096,
		0x03c8028A, 0x03c8028A,
		0x0BB805DC, 0x0BB805DC,
		0x17701194, 0x17701194,
		0x06050300, 0x06050300,
		0x06060606, 0x06060606,
		0x05010606, 0x05010606,
		0x0B0A0908, 0x0B0A0908,
		0x0D0D0D0D, 0x0D0D0D0D,
		0x0E0C0702, 0x0E0C0702,
		0x16151311, 0x16151311,
		0x09021616, 0x09021616,
		0x1614110C, 0x1614110C,
		0x1B1B1B19, 0x1B1B1B19,
		0x130E0902, 0x130E0902,
		0x221F1A15, 0x221F1A15,
		0x0A032222, 0x0A032222,
		0x1B16140F, 0x1B16140F,
		0x23232320, 0x23232320};

static const u32 pwr_comp_1ss_efem_8852c[] = {
		0x00C80050, 0x00C80050,
		0x0384017C, 0x0384017C,
		0x00320640, 0x00320640,
		0x015E0096, 0x015E0096,
		0x03c8028A, 0x03c8028A,
		0x0BB805DC, 0x0BB805DC,
		0x17701194, 0x17701194,
		0x02020201, 0x02020201,
		0x06050403, 0x06050403,
		0x02010606, 0x02010606,
		0x05040302, 0x05040302,
		0x08080706, 0x08080706,
		0x04030201, 0x04030201,
		0x0A080705, 0x0A080705,
		0x05020A0A, 0x05020A0A,
		0x0B090706, 0x0B090706,
		0x0F0F0F0D, 0x0F0F0F0D,
		0x08060402, 0x08060402,
		0x120F0C09, 0x120F0C09,
		0x05021212, 0x05021212,
		0x0D0A0907, 0x0D0A0907,
		0x13131310, 0x13131310};

static const u32 pwr_comp_2ss_efem_8852c[] = {
		0x00C80050, 0x00C80050,
		0x0384017C, 0x0384017C,
		0x00320640, 0x00320640,
		0x015E0096, 0x015E0096,
		0x03c8028A, 0x03c8028A,
		0x0BB805DC, 0x0BB805DC,
		0x17701194, 0x17701194,
		0x02020201, 0x02020201,
		0x06050403, 0x06050403,
		0x02010606, 0x02010606,
		0x05040302, 0x05040302,
		0x08080706, 0x08080706,
		0x04030201, 0x04030201,
		0x0A090705, 0x0A090705,
		0x05020A0A, 0x05020A0A,
		0x0B090706, 0x0B090706,
		0x1010100E, 0x1010100E,
		0x08060402, 0x08060402,
		0x14110E0A, 0x14110E0A,
		0x05021414, 0x05021414,
		0x0F0B0907, 0x0F0B0907,
		0x15151512, 0x15151512};
/*  ============================================================
 			   structure
    ============================================================
*/
struct bb_plcp_cr_info {
	u32 b_header_0;
	u32 b_header_0_m;	
	u32 b_header_1;
	u32 b_header_1_m;	
	u32 b_header_2;	
	u32 b_header_2_m;	
	u32 b_header_3;	
	u32 b_header_3_m;	
	u32 b_header_4;	
	u32 b_header_4_m;	
	u32 b_header_5;	
	u32 b_header_5_m;	
	u32 b_psdu_byte;	
	u32 b_psdu_byte_m;
	u32 b_carrier_suppress_tx;	
	u32 b_carrier_suppress_tx_m;	
	u32 b_ppdu_type;		
	u32 b_ppdu_type_m;	
	u32 b_psdu_rate;		
	u32 b_psdu_rate_m;	
	u32 b_service_bit2;	
	u32 b_service_bit2_m;	
	// For AX series
	u32 he_sigb_ch1_0;		
	u32 he_sigb_ch1_0_m;	
	u32 he_sigb_ch1_1;		
	u32 he_sigb_ch1_1_m;	
	u32 he_sigb_ch1_10;		
	u32 he_sigb_ch1_10_m;	
	u32 he_sigb_ch1_11;		
	u32 he_sigb_ch1_11_m;	
	u32 he_sigb_ch1_12;		
	u32 he_sigb_ch1_12_m;	
	u32 he_sigb_ch1_13;		
	u32 he_sigb_ch1_13_m;	
	u32 he_sigb_ch1_14;		
	u32 he_sigb_ch1_14_m;	
	u32 he_sigb_ch1_15;		
	u32 he_sigb_ch1_15_m;	
	u32 he_sigb_ch1_2;		
	u32 he_sigb_ch1_2_m;	
	u32 he_sigb_ch1_3;		
	u32 he_sigb_ch1_3_m;	
	u32 he_sigb_ch1_4;		
	u32 he_sigb_ch1_4_m;	
	u32 he_sigb_ch1_5;		
	u32 he_sigb_ch1_5_m;	
	u32 he_sigb_ch1_6;		
	u32 he_sigb_ch1_6_m;	
	u32 he_sigb_ch1_7;		
	u32 he_sigb_ch1_7_m;	
	u32 he_sigb_ch1_8;		
	u32 he_sigb_ch1_8_m;	
	u32 he_sigb_ch1_9;		
	u32 he_sigb_ch1_9_m;	
	u32 he_sigb_ch2_0;		
	u32 he_sigb_ch2_0_m;	
	u32 he_sigb_ch2_1;		
	u32 he_sigb_ch2_1_m;	
	u32 he_sigb_ch2_10;		
	u32 he_sigb_ch2_10_m;	
	u32 he_sigb_ch2_11;		
	u32 he_sigb_ch2_11_m;	
	u32 he_sigb_ch2_12;		
	u32 he_sigb_ch2_12_m;	
	u32 he_sigb_ch2_13;		
	u32 he_sigb_ch2_13_m;	
	u32 he_sigb_ch2_14;		
	u32 he_sigb_ch2_14_m;	
	u32 he_sigb_ch2_15;		
	u32 he_sigb_ch2_15_m;	
	u32 he_sigb_ch2_2;		
	u32 he_sigb_ch2_2_m;	
	u32 he_sigb_ch2_3;		
	u32 he_sigb_ch2_3_m;	
	u32 he_sigb_ch2_4;		
	u32 he_sigb_ch2_4_m;	
	u32 he_sigb_ch2_5;		
	u32 he_sigb_ch2_5_m;	
	u32 he_sigb_ch2_6;		
	u32 he_sigb_ch2_6_m;	
	u32 he_sigb_ch2_7;		
	u32 he_sigb_ch2_7_m;	
	u32 he_sigb_ch2_8;		
	u32 he_sigb_ch2_8_m;	
	u32 he_sigb_ch2_9;		
	u32 he_sigb_ch2_9_m;	
	// For BE series
	u32 hesigb_ehtsig_0;
	u32 hesigb_ehtsig_0_m;
	u32 hesigb_ehtsig_1;
	u32 hesigb_ehtsig_1_m;
	u32 hesigb_ehtsig_2;
	u32 hesigb_ehtsig_2_m;
	u32 hesigb_ehtsig_3;
	u32 hesigb_ehtsig_3_m;
	u32 hesigb_ehtsig_4;
	u32 hesigb_ehtsig_4_m;
	u32 hesigb_ehtsig_5;
	u32 hesigb_ehtsig_5_m;
	u32 hesigb_ehtsig_6;
	u32 hesigb_ehtsig_6_m;
	u32 hesigb_ehtsig_7;
	u32 hesigb_ehtsig_7_m;
	u32 hesigb_ehtsig_8;
	u32 hesigb_ehtsig_8_m;
	u32 hesigb_ehtsig_9;
	u32 hesigb_ehtsig_9_m;
	u32 hesigb_ehtsig_10;
	u32 hesigb_ehtsig_10_m;
	u32 hesigb_ehtsig_11;
	u32 hesigb_ehtsig_11_m;
	u32 hesigb_ehtsig_12;
	u32 hesigb_ehtsig_12_m;
	u32 hesigb_ehtsig_13;
	u32 hesigb_ehtsig_13_m;
	u32 hesigb_ehtsig_14;
	u32 hesigb_ehtsig_14_m;
	u32 hesigb_ehtsig_15;
	u32 hesigb_ehtsig_15_m;
	u32 hesigb_ehtsig_16;
	u32 hesigb_ehtsig_16_m;
	u32 hesigb_ehtsig_17;
	u32 hesigb_ehtsig_17_m;
	u32 hesigb_ehtsig_18;
	u32 hesigb_ehtsig_18_m;
	u32 hesigb_ehtsig_19;
	u32 hesigb_ehtsig_19_m;
	u32 hesigb_ehtsig_20;
	u32 hesigb_ehtsig_20_m;
	u32 hesigb_ehtsig_21;
	u32 hesigb_ehtsig_21_m;
	u32 hesigb_ehtsig_22;
	u32 hesigb_ehtsig_22_m;
	u32 hesigb_ehtsig_23;
	u32 hesigb_ehtsig_23_m;
	u32 hesigb_ehtsig_24;
	u32 hesigb_ehtsig_24_m;
	u32 hesigb_ehtsig_25;
	u32 hesigb_ehtsig_25_m;
	u32 hesigb_ehtsig_26;
	u32 hesigb_ehtsig_26_m;
	u32 hesigb_ehtsig_27;
	u32 hesigb_ehtsig_27_m;
	u32 hesigb_ehtsig_28;
	u32 hesigb_ehtsig_28_m;
	u32 hesigb_ehtsig_29;
	u32 hesigb_ehtsig_29_m;
	u32 hesigb_ehtsig_30;
	u32 hesigb_ehtsig_30_m;
	u32 hesigb_ehtsig_31;
	u32 hesigb_ehtsig_31_m;
	u32 hesigb_ehtsig_32;
	u32 hesigb_ehtsig_32_m;
	u32 hesigb_ehtsig_33;
	u32 hesigb_ehtsig_33_m;
	u32 hesigb_ehtsig_34;
	u32 hesigb_ehtsig_34_m;
	u32 hesigb_ehtsig_35;
	u32 hesigb_ehtsig_35_m;
	u32 hesigb_ehtsig_36;
	u32 hesigb_ehtsig_36_m;
	u32 hesigb_ehtsig_37;
	u32 hesigb_ehtsig_37_m;
	u32 hesigb_ehtsig_38;
	u32 hesigb_ehtsig_38_m;
	u32 hesigb_ehtsig_39;
	u32 hesigb_ehtsig_39_m;
	u32 hesigb_ehtsig_40;
	u32 hesigb_ehtsig_40_m;
	u32 hesigb_ehtsig_41;
	u32 hesigb_ehtsig_41_m;
	u32 hesigb_ehtsig_42;
	u32 hesigb_ehtsig_42_m;
	u32 hesigb_ehtsig_43;
	u32 hesigb_ehtsig_43_m;
	u32 hesigb_ehtsig_44;
	u32 hesigb_ehtsig_44_m;
	u32 hesigb_ehtsig_45;
	u32 hesigb_ehtsig_45_m;
	u32 hesigb_ehtsig_46;
	u32 hesigb_ehtsig_46_m;
	u32 hesigb_ehtsig_47;
	u32 hesigb_ehtsig_47_m;
	u32 hesigb_ehtsig_48;
	u32 hesigb_ehtsig_48_m;
	u32 hesigb_ehtsig_49;
	u32 hesigb_ehtsig_49_m;
	u32 hesigb_ehtsig_50;
	u32 hesigb_ehtsig_50_m;
	u32 hesigb_ehtsig_51;
	u32 hesigb_ehtsig_51_m;
	u32 hesigb_ehtsig_52;
	u32 hesigb_ehtsig_52_m;
	u32 hesigb_ehtsig_53;
	u32 hesigb_ehtsig_53_m;
	u32 hesigb_ehtsig_54;
	u32 hesigb_ehtsig_54_m;
	u32 hesigb_ehtsig_55;
	u32 hesigb_ehtsig_55_m;
	u32 hesigb_ehtsig_56;
	u32 hesigb_ehtsig_56_m;
	u32 hesigb_ehtsig_57;
	u32 hesigb_ehtsig_57_m;
	u32 hesigb_ehtsig_58;
	u32 hesigb_ehtsig_58_m;
	u32 hesigb_ehtsig_59;
	u32 hesigb_ehtsig_59_m;
	u32 hesigb_ehtsig_60;
	u32 hesigb_ehtsig_60_m;
	u32 hesigb_ehtsig_61;
	u32 hesigb_ehtsig_61_m;
	u32 hesigb_ehtsig_62;
	u32 hesigb_ehtsig_62_m;
	u32 hesigb_ehtsig_63;
	u32 hesigb_ehtsig_63_m;
	u32 hesigb_ehtsig_64;
	u32 hesigb_ehtsig_64_m;
	u32 hesigb_ehtsig_65;
	u32 hesigb_ehtsig_65_m;
	u32 hesigb_ehtsig_66;
	u32 hesigb_ehtsig_66_m;
	u32 hesigb_ehtsig_67;
	u32 hesigb_ehtsig_67_m;
	u32 hesigb_ehtsig_68;
	u32 hesigb_ehtsig_68_m;
	u32 hesigb_ehtsig_69;
	u32 hesigb_ehtsig_69_m;
	u32 hesigb_ehtsig_70;
	u32 hesigb_ehtsig_70_m;
	u32 hesigb_ehtsig_71;
	u32 hesigb_ehtsig_71_m;
	u32 hesigb_ehtsig_72;
	u32 hesigb_ehtsig_72_m;
	u32 hesigb_ehtsig_73;
	u32 hesigb_ehtsig_73_m;
	u32 hesigb_ehtsig_74;
	u32 hesigb_ehtsig_74_m;
	u32 hesigb_ehtsig_75;
	u32 hesigb_ehtsig_75_m;
	u32 hesigb_ehtsig_76;
	u32 hesigb_ehtsig_76_m;
	u32 hesigb_ehtsig_77;
	u32 hesigb_ehtsig_77_m;
	u32 hesigb_ehtsig_78;
	u32 hesigb_ehtsig_78_m;
	u32 hesigb_ehtsig_79;
	u32 hesigb_ehtsig_79_m;

	u32 usr0_delmter;		
	u32 usr0_delmter_m;	
	u32 usr0_eof_padding_len;	
	u32 usr0_eof_padding_len_m;	
	u32 usr0_init_seed;		
	u32 usr0_init_seed_m;		
	u32 usr1_delmter;		
	u32 usr1_delmter_m;	
	u32 usr1_eof_padding_len;	
	u32 usr1_eof_padding_len_m;	
	u32 usr1_init_seed;	
	u32 usr1_init_seed_m;	
	u32 usr2_delmter;		
	u32 usr2_delmter_m;	
	u32 usr2_eof_padding_len;	
	u32 usr2_eof_padding_len_m;	
	u32 usr2_init_seed;	
	u32 usr2_init_seed_m;	
	u32 usr3_delmter;		
	u32 usr3_delmter_m;	
	u32 usr3_eof_padding_len;	
	u32 usr3_eof_padding_len_m;
	u32 usr3_init_seed;	
	u32 usr3_init_seed_m;	
	u32 vht_sigb0;		
	u32 vht_sigb0_m;	
	u32 vht_sigb1;		
	u32 vht_sigb1_m;	
	u32 vht_sigb2;		
	u32 vht_sigb2_m;
	u32 he_sigb_mcs;
	u32 he_sigb_mcs_m;	
	u32 vht_sigb3;	
	u32 vht_sigb3_m;
	u32 n_ltf;	
	u32 n_ltf_m;
	u32 siga1;		
	u32 siga1_m;	
	u32 siga2;		
	u32 siga2_m;	
	u32 lsig;		
	u32 lsig_m;		
	u32 cca_pw_th;	
	u32 cca_pw_th_m;	
	u32 n_sym;		
	u32 n_sym_m;	
	u32 usr0_service;		
	u32 usr0_service_m;	
	u32 usr1_service;		
	u32 usr1_service_m;	
	u32 usr2_service;		
	u32 usr2_service_m;	
	u32 usr3_service;		
	u32 usr3_service_m;	
	u32 usr0_mdpu_len_byte;
	u32 usr0_mdpu_len_byte_m;		
	u32 usr1_mdpu_len_byte;		
	u32 usr1_mdpu_len_byte_m;		
	u32 obw_cts2self_dup_type;		
	u32 obw_cts2self_dup_type_m;		
	u32 usr2_mdpu_len_byte;	
	u32 usr2_mdpu_len_byte_m;	
	u32 usr3_mdpu_len_byte;
	u32 usr3_mdpu_len_byte_m;	
	u32 usr0_csi_buf_id;	
	u32 usr0_csi_buf_id_m;	
	u32 usr1_csi_buf_id;	
	u32 usr1_csi_buf_id_m;	
	u32 rf_gain_idx;	
	u32 rf_gain_idx_m;	
	u32 usr2_csi_buf_id;	
	u32 usr2_csi_buf_id_m;	
	u32 usr3_csi_buf_id;	
	u32 usr3_csi_buf_id_m;	
	u32 usr0_n_mpdu;	
	u32 usr0_n_mpdu_m;		
	u32 usr1_n_mpdu;		
	u32 usr1_n_mpdu_m;		
	u32 usr2_n_mpdu;		
	u32 usr2_n_mpdu_m;		
	u32 usr0_pw_boost_fctr_db;		
	u32 usr0_pw_boost_fctr_db_m;	
	u32 usr3_n_mpdu;		
	u32 usr3_n_mpdu_m;		
	u32 ch20_with_data;		
	u32 ch20_with_data_m;	
	u32 n_usr;		
	u32 n_usr_m;		
	u32 txcmd_txtp;
	u32 txcmd_txtp_m;
	u32 usr0_ru_alloc;	
	u32 usr0_ru_alloc_m;
	u32 usr0_u_id;		
	u32 usr0_u_id_m;
	u32 usr1_ru_alloc;	
	u32 usr1_ru_alloc_m;
	u32 usr1_u_id;		
	u32 usr1_u_id_m;	
	u32 usr2_ru_alloc;	
	u32 usr2_ru_alloc_m;
	u32 usr2_u_id;		
	u32 usr2_u_id_m;	
	u32 usr3_ru_alloc;	
	u32 usr3_ru_alloc_m;
	u32 usr3_u_id;		
	u32 usr3_u_id_m;	
	u32 n_sym_hesigb;		
	u32 n_sym_hesigb_m;		
	u32 usr0_mcs;	
	u32 usr0_mcs_m;	
	u32 usr1_mcs;	
	u32 usr1_mcs_m;	
	u32 usr2_mcs;	
	u32 usr2_mcs_m;	
	u32 usr3_mcs;	
	u32 usr3_mcs_m;	
	u32 usr1_pw_boost_fctr_db;	
	u32 usr1_pw_boost_fctr_db_m;
	u32 usr2_pw_boost_fctr_db;	
	u32 usr2_pw_boost_fctr_db_m;
	u32 usr3_pw_boost_fctr_db;	
	u32 usr3_pw_boost_fctr_db_m;
	u32 ppdu_type;	
	u32 ppdu_type_m;	
	u32 txsc;		
	u32 txsc_m;		
	u32 cfo_comp;	
	u32 cfo_comp_m;	
	u32 pkt_ext_idx;
	u32 pkt_ext_idx_m;		
	u32 usr0_n_sts;		
	u32 usr0_n_sts_m;	
	u32 usr0_n_sts_ru_tot;	
	u32 usr0_n_sts_ru_tot_m;
	u32 usr0_strt_sts;		
	u32 usr0_strt_sts_m;	
	u32 usr1_n_sts;		
	u32 usr1_n_sts_m;	
	u32 usr1_n_sts_ru_tot;
	u32 usr1_n_sts_ru_tot_m;
	u32 usr1_strt_sts;	
	u32 usr1_strt_sts_m;
	u32 usr2_n_sts;	
	u32 usr2_n_sts_m;	
	u32 usr2_n_sts_ru_tot;	
	u32 usr2_n_sts_ru_tot_m;	
	u32 usr2_strt_sts;	
	u32 usr2_strt_sts_m;	
	u32 usr3_n_sts;		
	u32 usr3_n_sts_m;	
	u32 usr3_n_sts_ru_tot;
	u32 usr3_n_sts_ru_tot_m;
	u32 usr3_strt_sts;		
	u32 usr3_strt_sts_m;	
	u32 source_gen_mode_idx;	
	u32 source_gen_mode_idx_m;	
	u32 gi_type;		
	u32 gi_type_m;		
	u32 ltf_type;		
	u32 ltf_type_m;	
	u32 dbw_idx;		
	u32 dbw_idx_m;	
	u32 pre_fec_fctr;	
	u32 pre_fec_fctr_m;	
	u32 beam_change_en;	
	u32 beam_change_en_m;
	u32 doppler_en;		
	u32 doppler_en_m;	
	u32 fb_mumimo_en;	
	u32 fb_mumimo_en_m;	
	u32 feedback_status;
	u32 feedback_status_m;		
	u32 he_sigb_dcm_en;	
	u32 he_sigb_dcm_en_m;	
	u32 midamble_mode;	
	u32 midamble_mode_m;
	u32 mumimo_ltf_mode_en;		
	u32 mumimo_ltf_mode_en_m;	
	u32 ndp;		
	u32 ndp_m;		
	u32 stbc_en;	
	u32 stbc_en_m;	
	u32 ant_sel_a;	
	u32 ant_sel_a_m;	
	u32 ant_sel_b;	
	u32 ant_sel_b_m;	
	u32 ant_sel_c;	
	u32 ant_sel_c_m;	
	u32 ant_sel_d;	
	u32 ant_sel_d_m;	
	u32 cca_pw_th_en;
	u32 cca_pw_th_en_m;	
	u32 rf_fixed_gain_en;
	u32 rf_fixed_gain_en_m;
	u32 ul_cqi_rpt_tri;		
	u32 ul_cqi_rpt_tri_m;	
	u32 ldpc_extr;		
	u32 ldpc_extr_m;	
	u32 usr0_dcm_en;		
	u32 usr0_dcm_en_m;		
	u32 usr0_fec_type;		
	u32 usr0_fec_type_m;		
	u32 usr0_txbf_en;		
	u32 usr0_txbf_en_m;		
	u32 usr1_dcm_en;	
	u32 usr1_dcm_en_m;		
	u32 usr1_fec_type;		
	u32 usr1_fec_type_m;		
	u32 usr1_txbf_en;		
	u32 usr1_txbf_en_m;		
	u32 usr2_dcm_en;		
	u32 usr2_dcm_en_m;		
	u32 usr2_fec_type;		
	u32 usr2_fec_type_m;		
	u32 usr2_txbf_en;		
	u32 usr2_txbf_en_m;		
	u32 usr3_dcm_en;		
	u32 usr3_dcm_en_m;		
	u32 usr3_fec_type;		
	u32 usr3_fec_type_m;	
	u32 usr3_txbf_en;		
	u32 usr3_txbf_en_m;
	u32 usr0_precoding_mode_idx;
	u32 usr0_precoding_mode_idx_m;
	u32 usr1_precoding_mode_idx;
	u32 usr1_precoding_mode_idx_m;
	u32 usr2_precoding_mode_idx;
	u32 usr2_precoding_mode_idx_m;
	u32 usr3_precoding_mode_idx;
	u32 usr3_precoding_mode_idx_m;
	u32 b_rate_idx;
	u32 b_rate_idx_m;
	u32 b_locked_clk_en;
	u32 b_locked_clk_en_m;
	u32 max_mcs;
	u32 max_mcs_m;
	u32 tx_tri_idx;
	u32 tx_tri_idx_m;
	u32 tx_tri_pw_ofst;
	u32 tx_tri_pw_ofst_m;
	u32 usr0_ru_id;
	u32 usr0_ru_id_m;
	u32 usr1_ru_id;
	u32 usr1_ru_id_m;
	u32 usr2_ru_id;
	u32 usr2_ru_id_m;
	u32 usr3_ru_id;
	u32 usr3_ru_id_m;
	u32 usr0_ru_size;
	u32 usr0_ru_size_m;
	u32 usr1_ru_size;
	u32 usr1_ru_size_m;
	u32 usr2_ru_size;
	u32 usr2_ru_size_m;
	u32 usr3_ru_size;
	u32 usr3_ru_size_m;
	u32 n_sym_hesigb_ehtsig;
	u32 n_sym_hesigb_ehtsig_m;
	u32 he_sigb_ehtsig_mcs;
	u32 he_sigb_ehtsig_mcs_m;
	u32 txsb;
	u32 txsb_m;
	u32 ppdu_var;
	u32 ppdu_var_m;
	u32 usig_0;
	u32 usig_0_m;
	u32 usig_1;
	u32 usig_1_m;
	u32 tssi_ru_size;
	u32 tssi_ru_size_m;
};

struct bb_plcp_info {
	u8 prim_sb;
	u8 ehtsig_sym_num;
	u8 ru2su_flag;
	u8 c2h_done;
	struct bb_plcp_cr_info bb_plcp_cr_i;
};


/*  ============================================================
 		     Function Prototype
    ============================================================
*/

struct bb_info;

void halbb_cr_cfg_plcp_init(struct bb_info *bb);

void halbb_plcp_init(struct bb_info *bb);

enum plcp_sts halbb_plcp_gen_6(struct bb_info *bb, struct halbb_plcp_info *in,
		    struct usr_plcp_gen_in *user, enum phl_phy_idx phy_idx);

#endif
