#ifndef __MAC_REG_AX_H__
#define __MAC_REG_AX_H__

#include "hci_reg_ax.h"
#include "plat_reg_ax.h"

//
// WL_AX_REG_DMAC.xls
//

//
// TOP_OFF
//

#define R_AX_GT0_CTRL 0x8000
#define B_AX_GT_COUNT_EN BIT(31)
#define B_AX_GT_MODE BIT(30)
#define B_AX_GT_EN BIT(29)
#define B_AX_GT_SORT_EN BIT(28)
#define B_AX_GT_DATA_SH 0
#define B_AX_GT_DATA_MSK 0xfffffff

#define R_AX_GT0_CNT 0x8004
#define B_AX_GT_CNT_SH 0
#define B_AX_GT_CNT_MSK 0xfffffff

#define R_AX_GT1_CTRL 0x8008
#define B_AX_GT1_COUNT_EN BIT(31)
#define B_AX_GT1_MODE BIT(30)
#define B_AX_GT1_EN BIT(29)
#define B_AX_GT1_SORT_EN BIT(28)
#define B_AX_GT1_DATA_SH 0
#define B_AX_GT1_DATA_MSK 0xfffffff

#define R_AX_GT1_CNT 0x800C
#define B_AX_GT1_CNT_SH 0
#define B_AX_GT1_CNT_MSK 0xfffffff

#define R_AX_GT2_CTRL 0x8010
#define B_AX_GT2_COUNT_EN BIT(31)
#define B_AX_GT2_MODE BIT(30)
#define B_AX_GT2_EN BIT(29)
#define B_AX_GT2_SORT_EN BIT(28)
#define B_AX_GT2_DATA_SH 0
#define B_AX_GT2_DATA_MSK 0xfffffff

#define R_AX_GT2_CNT 0x8014
#define B_AX_GT2_CNT_SH 0
#define B_AX_GT2_CNT_MSK 0xfffffff

#define R_AX_GT3_CTRL 0x8018
#define B_AX_GT3_COUNT_EN BIT(31)
#define B_AX_GT3_MODE BIT(30)
#define B_AX_GT3_EN BIT(29)
#define B_AX_GT3_SORT_EN BIT(28)
#define B_AX_GT3_DATA_SH 0
#define B_AX_GT3_DATA_MSK 0xfffffff

#define R_AX_GT3_CNT 0x801C
#define B_AX_GT3_CNT_SH 0
#define B_AX_GT3_CNT_MSK 0xfffffff

#define R_AX_SORT_CTRL 0x8024
#define B_AX_CMAC1_SORT_EN BIT(1)
#define B_AX_CMAC0_SORT_EN BIT(0)

#define R_AX_PHYREG_SET 0x8040
#define B_AX_PHYREG_SET_SH 0
#define B_AX_PHYREG_SET_MSK 0xf

#define R_AX_FWD0IMR 0x8100
#define B_AX_FS_H2C_INT_EN BIT(8)
#define B_AX_FS_HIOE_ERR_INT_EN BIT(7)
#define B_AX_FS_SW_PLL_LEAVE_32K_INT_EN BIT(6)
#define B_AX_FS_MAILBOX_OUT_EMPTY_INT_EN BIT(5)
#define B_AX_FS_LTE_COEX_INT_EN BIT(4)
#define B_AX_FS_GT3_INT_EN BIT(3)
#define B_AX_FS_GT2_INT_EN BIT(2)
#define B_AX_FS_GT1_INT_EN BIT(1)
#define B_AX_FS_GT0_INT_EN BIT(0)

#define R_AX_FWD0ISR 0x8104
#define B_AX_FS_H2C_INT BIT(8)
#define B_AX_FS_HIOE_ERR_INT BIT(7)
#define B_AX_FS_SW_PLL_LEAVE_32K_INT BIT(6)
#define B_AX_FS_MAILBOX_OUT_EMPTY_INT BIT(5)
#define B_AX_FS_LTE_COEX_INT BIT(4)
#define B_AX_FS_GT3_INT BIT(3)
#define B_AX_FS_GT2_INT BIT(2)
#define B_AX_FS_GT1_INT BIT(1)
#define B_AX_FS_GT0_INT BIT(0)

#define R_AX_HD0IMR 0x8110
#define B_AX_WDT_PTFM_INT_EN BIT(5)
#define B_AX_CPWM_INT_EN BIT(2)
#define B_AX_GT3_INT_EN BIT(1)
#define B_AX_C2H_INT_EN BIT(0)

#define R_AX_HD0ISR 0x8114
#define B_AX_WDT_PTFM_INT BIT(5)
#define B_AX_CPWM_INT BIT(2)
#define B_AX_GT3_INT BIT(1)
#define B_AX_C2H_INT BIT(0)

#define R_AX_H2CREG_DATA0 0x8140
#define B_AX_H2CREG_D0_SH 0
#define B_AX_H2CREG_D0_MSK 0xffffffffL

#define R_AX_H2CREG_DATA1 0x8144
#define B_AX_H2CREG_D1_SH 0
#define B_AX_H2CREG_D1_MSK 0xffffffffL

#define R_AX_H2CREG_DATA2 0x8148
#define B_AX_H2CREG_D2_SH 0
#define B_AX_H2CREG_D2_MSK 0xffffffffL

#define R_AX_H2CREG_DATA3 0x814C
#define B_AX_H2CREG_D3_SH 0
#define B_AX_H2CREG_D3_MSK 0xffffffffL

#define R_AX_C2HREG_DATA0 0x8150
#define B_AX_C2HREG_D0_SH 0
#define B_AX_C2HREG_D0_MSK 0xffffffffL

#define R_AX_C2HREG_DATA1 0x8154
#define B_AX_C2HREG_D1_SH 0
#define B_AX_C2HREG_D1_MSK 0xffffffffL

#define R_AX_C2HREG_DATA2 0x8158
#define B_AX_C2HREG_D2_SH 0
#define B_AX_C2HREG_D2_MSK 0xffffffffL

#define R_AX_C2HREG_DATA3 0x815C
#define B_AX_C2HREG_D3_SH 0
#define B_AX_C2HREG_D3_MSK 0xffffffffL

#define R_AX_H2CREG_CTRL 0x8160
#define B_AX_H2CREG_TRIGGER BIT(0)

#define R_AX_C2HREG_CTRL 0x8164
#define B_AX_C2HREG_TRIGGER BIT(0)

#define R_AX_CPWM 0x8170
#define B_AX_CPWM_TOGGLE BIT(15)
#define B_AX_CPWM_VAL_SH 0
#define B_AX_CPWM_VAL_MSK 0x7fff

#define R_AX_ANACLK_CAL_CTRL 0x8180
#define B_AX_ANACLK_CAL_EN BIT(31)
#define B_AX_ANACLK_SEL_SH 24
#define B_AX_ANACLK_SEL_MSK 0x3
#define B_AX_ANACLK_CAL_RPT_SH 0
#define B_AX_ANACLK_CAL_RPT_MSK 0xffff

#define R_AX_PARAM_BIST_CTRL 0x8200
#define B_AX_BIST_DYN_READ_EN BIT(14)
#define B_AX_BIST_LOOP_MODE BIT(13)
#define B_AX_BIST_LVDRF_CLKDIS BIT(12)
#define B_AX_BIST_WLMCU_ROM_MISR_OUTPUT_SEL_SH 8
#define B_AX_BIST_WLMCU_ROM_MISR_OUTPUT_SEL_MSK 0x7
#define B_AX_BIST_BT_RPT_SEL_SH 4
#define B_AX_BIST_BT_RPT_SEL_MSK 0xf
#define B_AX_BIST_DRF_RESUME BIT(3)
#define B_AX_BIST_DRF_MODE BIT(2)
#define B_AX_BIST_MODE BIT(1)
#define B_AX_BIST_RSTN_ALL BIT(0)

#define R_AX_PARAM_MEM_RM_CTRL 0x8204
#define B_AX_SYM_MEM_RMV_FABDBG_SH 30
#define B_AX_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_AX_SYM_MEM_RMV_SIGN BIT(29)
#define B_AX_SYM_MEM_RMV_2PRF BIT(27)
#define B_AX_SYM_MEM_RMV_1PRF BIT(26)
#define B_AX_SYM_MEM_RMV_1PSR BIT(25)
#define B_AX_SYM_MEM_RMV_ROM BIT(24)
#define B_AX_SYM_MEM_RME_BT_SH 8
#define B_AX_SYM_MEM_RME_BT_MSK 0xf
#define B_AX_SYM_MEM_RME_WLMCU_SH 4
#define B_AX_SYM_MEM_RME_WLMCU_MSK 0xf
#define B_AX_SYM_MEM_RME_HCI_SH 0
#define B_AX_SYM_MEM_RME_HCI_MSK 0xf

#define R_AX_PARAM_USB_BIST_RSTN 0x8210
#define B_AX_BIST_RST_N_USB_SH 0
#define B_AX_BIST_RST_N_USB_MSK 0x3f

#define R_AX_PARAM_USB_BIST_DONE 0x8214
#define B_AX_BIST_DONE_USB_SH 0
#define B_AX_BIST_DONE_USB_MSK 0x3f

#define R_AX_PARAM_USB_BIST_FAIL 0x8218
#define B_AX_BIST_FAIL_USB_SH 0
#define B_AX_BIST_FAIL_USB_MSK 0x3f

#define R_AX_PARAM_USB_DRF_PAUSE 0x821C
#define B_AX_BIST_DRF_PAUSE_USB_SH 0
#define B_AX_BIST_DRF_PAUSE_USB_MSK 0x3f

#define R_AX_PARAM_PCIE_BIST_RSTN 0x8220
#define B_AX_BIST_RST_N_PCIE_SH 0
#define B_AX_BIST_RST_N_PCIE_MSK 0x3f

#define R_AX_PARAM_PCIE_BIST_DONE 0x8224
#define B_AX_BIST_DONE_PCIE_SH 0
#define B_AX_BIST_DONE_PCIE_MSK 0x3f

#define R_AX_PARAM_PCIE_BIST_FAIL 0x8228
#define B_AX_BIST_FAIL_PCIE_SH 0
#define B_AX_BIST_FAIL_PCIE_MSK 0x3f

#define R_AX_PARAM_PCIE_DRF_PAUSE 0x822C
#define B_AX_BIST_DRF_PAUSE_SH 0
#define B_AX_BIST_DRF_PAUSE_MSK 0x3f

#define R_AX_PARAM_WLMCU_BIST_RSTN 0x8230
#define B_AX_BIST_RST_N_WLMCU_SH 0
#define B_AX_BIST_RST_N_WLMCU_MSK 0x1ffff

#define R_AX_PARAM_WLMCU_BIST_DONE 0x8234
#define B_AX_BIST_DONE_WLMCU_SH 0
#define B_AX_BIST_DONE_WLMCU_MSK 0x1ffff

#define R_AX_PARAM_WLMCU_BIST_FAIL 0x8238
#define B_AX_BIST_FAIL_WLMCU_SH 0
#define B_AX_BIST_FAIL_WLMCU_MSK 0x1ffff

#define R_AX_PARAM_WLMCU_DRF_PAUSE 0x823C

#define R_AX_PARAM_SDIO_BIST_RSTN 0x8240
#define B_AX_BIST_RST_N_SDIO_SH 0
#define B_AX_BIST_RST_N_SDIO_MSK 0x3

#define R_AX_PARAM_SDIO_BIST_DONE 0x8244
#define B_AX_BIST_DONE_SDIO_SH 0
#define B_AX_BIST_DONE_SDIO_MSK 0x3

#define R_AX_PARAM_SDIO_BIST_FAIL 0x8248
#define B_AX_BIST_FAIL_SDIO_SH 0
#define B_AX_BIST_FAIL_SDIO_MSK 0x3

#define R_AX_PARAM_SDIO_DRF_PAUSE 0x824C
#define B_AX_DRF_PAUSE_SDIO_SH 0
#define B_AX_DRF_PAUSE_SDIO_MSK 0x3

#define R_AX_PARAM_BT0_BIST_RSTN 0x8250
#define B_AX_BIST_RST_N_BT0_SH 0
#define B_AX_BIST_RST_N_BT0_MSK 0xffffffffL

#define R_AX_PARAM_BT0_BIST_DONE 0x8254
#define B_AX_BIST_DONE_BIT0_SH 0
#define B_AX_BIST_DONE_BIT0_MSK 0xffffffffL

#define R_AX_PARAM_BT0_BIST_FAIL 0x8258
#define B_AX_BIST_FAIL_BT0_SH 0
#define B_AX_BIST_FAIL_BT0_MSK 0xffffffffL

#define R_AX_PARAM_BT0_DRF_PAUSE 0x825C
#define B_AX_BIST_DRF_PAUSE_BT0_SH 0
#define B_AX_BIST_DRF_PAUSE_BT0_MSK 0xffffffffL

#define R_AX_PARAM_BT1_BIST_RSTN 0x8260
#define B_AX_BIST_RST_N_BT1_SH 0
#define B_AX_BIST_RST_N_BT1_MSK 0x1ff

#define R_AX_PARAM_BT1_BIST_DONE 0x8264
#define B_AX_BIST_DONE_BT1_SH 0
#define B_AX_BIST_DONE_BT1_MSK 0x1ff

#define R_AX_PARAM_BT1_BIST_FAIL 0x8268
#define B_AX_BIST_FAIL_BT1_SH 0
#define B_AX_BIST_FAIL_BT1_MSK 0x1ff

#define R_AX_PARAM_BT1_DRF_PAUSE 0x826C
#define B_AX_BIST_DRF_PAUSE_BT1_SH 0
#define B_AX_BIST_DRF_PAUSE_BT1_MSK 0x1ff

#define R_AX_PARAM_WLMCU_ROM_MISR_DOUT 0x8270
#define B_AX_WLMCU_BIST_ROM_MISR_DOUT_SH 0
#define B_AX_WLMCU_BIST_ROM_MISR_DOUT_MSK 0xffffffffL

#define R_AX_PARAM_BT_BIST_RPT 0x8274
#define B_AX_BT_BIST_RPT_SH 0
#define B_AX_BT_BIST_RPT_MSK 0xffffffffL

//
// WL_PON
//

#define R_AX_FWD1IMR 0x8300
#define B_AX_FS_TM_WAKE_INT_EN BIT(16)
#define B_AX_FS_BT_MAILBOX_INT_EN BIT(1)
#define B_AX_FS_RPWM_INT_EN BIT(0)

#define R_AX_FWD1ISR 0x8304
#define B_AX_FS_TM_WAKE_INT BIT(16)
#define B_AX_FS_BT_MAILBOX_INT BIT(1)
#define B_AX_FS_RPWM_INT BIT(0)

#define R_AX_FSMIMR 0x8308
#define B_AX_FSM_RP_END_EVENT_IMR BIT(6)
#define B_AX_FSM_RX_BCN_TO_CNT_EVENT_IMR BIT(5)
#define B_AX_FSM_RX_MATCH_EVENT_IMR BIT(4)
#define B_AX_FSM_HIOE_ERR_EVENT_IMR BIT(3)
#define B_AX_FSM_OTHERS_WAKE_EVENT_IMR BIT(2)
#define B_AX_FSM_TIMER_TO_EVENT_IMR BIT(1)

#define R_AX_FSMISR 0x830C
#define B_AX_FSM_RP_END_EVENT_ISR BIT(6)
#define B_AX_FSM_RX_BCN_TO_CNT_EVENT_ISR BIT(5)
#define B_AX_FSM_RX_MATCH_EVENT_ISR BIT(4)
#define B_AX_FSM_HIOE_ERR_EVENT_ISR BIT(3)
#define B_AX_FSM_OTHERS_WAKE_EVENT_ISR BIT(2)
#define B_AX_FSM_TIMER_TO_EVENT_ISR BIT(1)

#define R_AX_TM_BKP_RES_CTRL 0x8310
#define B_AX_SORTING_ROLE_SEL_SH 12
#define B_AX_SORTING_ROLE_SEL_MSK 0x3
#define B_AX_SORTING_ROLE_ST_SH 8
#define B_AX_SORTING_ROLE_ST_MSK 0xf
#define B_AX_TM_WAKE_IND BIT(7)
#define B_AX_TM_BKP_EN_STS BIT(6)
#define B_AX_SCH_RES_EN BIT(4)
#define B_AX_PRE_CHK_DONE BIT(3)
#define B_AX_PRE_CHK_VALID BIT(2)
#define B_AX_TM_RES_EN BIT(1)
#define B_AX_TM_BKP_EN_TRIGGER BIT(0)

#define R_AX_PRE_CHK_CTRL 0x8314
#define B_AX_PRE_CHK_THD_SH 16
#define B_AX_PRE_CHK_THD_MSK 0xffff
#define B_AX_PRE_WAKE_TIME_SH 0
#define B_AX_PRE_WAKE_TIME_MSK 0xffff

#define R_AX_LPS_WTM_SC 0x8318
#define B_AX_LPS_WTM_SC_SH 0
#define B_AX_LPS_WTM_SC_MSK 0xffffffffL

#define R_AX_LPS_WTM_CNT 0x831C
#define B_AX_LPS_WTM_CNT_SH 0
#define B_AX_LPS_WTM_CNT_MSK 0xffffffffL

#define R_AX_TSF_32K_SEL 0x8320
#define B_AX_TSF_CLK_STABLE BIT(17)
#define B_AX_CKSL_WLTSF BIT(16)
#define B_AX_32K_SRC_SEL BIT(8)
#define B_AX_US_TIME_VALUE_SH 0
#define B_AX_US_TIME_VALUE_MSK 0xff

#define R_AX_HIOE_END_ADDR 0x8340
#define B_AX_HIOE_END_ADDR_SH 0
#define B_AX_HIOE_END_ADDR_MSK 0xffffffffL

#define R_AX_HIOE_STR_ADDR 0x8344
#define B_AX_HIOE_STR_ADDR_SH 0
#define B_AX_HIOE_STR_ADDR_MSK 0xffffffffL

#define R_AX_BKP_HIOE_CTRL 0x8348
#define B_AX_BKP_HIOE_CTRL_SH 16
#define B_AX_BKP_HIOE_CTRL_MSK 0xffff

#define R_AX_RES_HIOE_CTRL 0x834C
#define B_AX_RES_HIOE_CTRL_SH 16
#define B_AX_RES_HIOE_CTRL_MSK 0xffff

#define R_AX_HCI_FUNC_EN 0x8380
#define B_AX_HCI_RXDMA_EN BIT(1)
#define B_AX_HCI_TXDMA_EN BIT(0)

#define R_AX_OSC_32K_CTRL 0x8394
#define B_AX_LPOSC32K_OK BIT(31)
#define B_AX_CAL_32K_DBG_SEL BIT(3)
#define B_AX_CAL32K_XTAL_EN BIT(2)
#define B_AX_CAL32K_OSC_EN BIT(1)
#define B_AX_WL_POW_32KOSC BIT(0)

#define R_AX_32K_CAL_REG0 0x8398
#define B_AX_CAL_32K_REG_WR BIT(31)
#define B_AX_CAL_OSC_XTAL_SEL BIT(22)
#define B_AX_CAL_32K_REG_ADDR_SH 16
#define B_AX_CAL_32K_REG_ADDR_MSK 0x3f
#define B_AX_CAL_32K_REG_DATA_SH 0
#define B_AX_CAL_32K_REG_DATA_MSK 0xffff

#define R_AX_OSC32K_RCAL 0x839C
#define B_AX_OSC32K_RCAL_SH 0
#define B_AX_OSC32K_RCAL_MSK 0x7fff

#define R_AX_BOOT_DBG 0x83F0
#define B_AX_BOOT_STATUS_SH 16
#define B_AX_BOOT_STATUS_MSK 0xffff
#define B_AX_SECUREBOOT_STATUS_SH 0
#define B_AX_SECUREBOOT_STATUS_MSK 0xffff

//
// COMMON
//

#define R_AX_DMAC_FUNC_EN 0x8400
#define B_AX_DMAC_CRPRT BIT(31)
#define B_AX_MAC_FUNC_EN BIT(30)
#define B_AX_DMAC_FUNC_EN BIT(29)
#define B_AX_MPDU_PROC_EN BIT(28)
#define B_AX_WD_RLS_EN BIT(27)
#define B_AX_DLE_WDE_EN BIT(26)
#define B_AX_TXPKT_CTRL_EN BIT(25)
#define B_AX_STA_SCH_EN BIT(24)
#define B_AX_DLE_PLE_EN BIT(23)
#define B_AX_PKT_BUF_EN BIT(22)
#define B_AX_DMAC_TBL_EN BIT(21)
#define B_AX_PKT_IN_EN BIT(20)
#define B_AX_DLE_CPUIO_EN BIT(19)
#define B_AX_DISPATCHER_EN BIT(18)
#define B_AX_BBRPT_EN BIT(17)
#define B_AX_MAC_SEC_EN BIT(16)
#define B_AX_DMACREG_GCKEN BIT(15)

#define R_AX_DMAC_CLK_EN 0x8404
#define B_AX_MPDU_CKEN BIT(28)
#define B_AX_WD_RLS_CLK_EN BIT(27)
#define B_AX_DLE_WDE_CLK_EN BIT(26)
#define B_AX_TXPKT_CTRL_CLK_EN BIT(25)
#define B_AX_STA_SCH_CLK_EN BIT(24)
#define B_AX_DLE_PLE_CLK_EN BIT(23)
#define B_AX_PKTBUF_CKEN BIT(22)
#define B_AX_DMAC_TABLE_CLK_EN BIT(21)
#define B_AX_PKT_IN_CLK_EN BIT(20)
#define B_AX_DLE_CPUIO_CLK_EN BIT(19)
#define B_AX_DISPATCHER_CLK_EN BIT(18)
#define B_AX_BBRPT_CLK_EN BIT(17)
#define B_AX_MAC_SEC_CLK_EN BIT(16)
#define B_AX_AXIDMA_CLK_EN BIT(9) //HOTFIX

#define R_AX_LTR_CTRL_0 0x8410
#define B_AX_LTR_SPACE_IDX_SH 12
#define B_AX_LTR_SPACE_IDX_MSK 0x3
#define B_AX_LTR_IDLE_TIMER_IDX_SH 8
#define B_AX_LTR_IDLE_TIMER_IDX_MSK 0x7
#define B_AX_LTR_WD_NOEMP_CHK BIT(6)
#define B_AX_APP_LTR_ACT BIT(5)
#define B_AX_APP_LTR_IDLE BIT(4)
#define B_AX_LTR_EN BIT(1)
#define B_AX_LTR_HW_EN BIT(0)

#define R_AX_LTR_CTRL_1 0x8414
#define B_AX_LTR_RX1_TH_SH 16
#define B_AX_LTR_RX1_TH_MSK 0xfff
#define B_AX_LTR_RX0_TH_SH 0
#define B_AX_LTR_RX0_TH_MSK 0xfff

#define R_AX_LTR_IDLE_LATENCY 0x8418
#define B_AX_LTR_IDLE_LTCY_SH 0
#define B_AX_LTR_IDLE_LTCY_MSK 0xffffffffL

#define R_AX_LTR_ACTIVE_LATENCY 0x841C
#define B_AX_LTR_ACT_LTCY_SH 0
#define B_AX_LTR_ACT_LTCY_MSK 0xffffffffL

#define R_AX_DMAC_TABLE_CTRL 0x8420
#define B_AX_HWAMSDU_PADDING_MODE BIT(31)
#define B_AX_MACID_MPDU_PROCESSOR_OFFSET_SH 16
#define B_AX_MACID_MPDU_PROCESSOR_OFFSET_MSK 0x7ff
#define B_AX_DMAC_CTRL_INFO_OFFSET_SH 0
#define B_AX_DMAC_CTRL_INFO_OFFSET_MSK 0x7ff

#define R_AX_SER_DBG_INFO 0x8424
#define B_AX_SER_L0_PROMOTE_L1_EVENT_SH 28
#define B_AX_SER_L0_PROMOTE_L1_EVENT_MSK 0xf
#define B_AX_SER_L1_COUNTER_SH 24
#define B_AX_SER_L1_COUNTER_MSK 0xf
#define B_AX_RMAC_PPDU_HANG_CNT_SH 16
#define B_AX_RMAC_PPDU_HANG_CNT_MSK 0xff
#define B_AX_SER_L0_COUNTER_SH 0
#define B_AX_SER_L0_COUNTER_MSK 0xff
#define B_AX_DMAC_ASSERTION BIT(31)

#define R_AX_DLE_EMPTY0 0x8430
#define B_AX_PLE_EMPTY_QTA_DMAC_CPUIO BIT(26)
#define B_AX_PLE_EMPTY_QTA_DMAC_MPDU_TX BIT(25)
#define B_AX_PLE_EMPTY_QTA_DMAC_WLAN_CPU BIT(24)
#define B_AX_PLE_EMPTY_QTA_DMAC_H2C BIT(23)
#define B_AX_PLE_EMPTY_QTA_DMAC_B1_TXPL BIT(22)
#define B_AX_PLE_EMPTY_QTA_DMAC_B0_TXPL BIT(21)
#define B_AX_WDE_EMPTY_QTA_DMAC_CPUIO BIT(20)
#define B_AX_WDE_EMPTY_QTA_DMAC_PKTIN BIT(19)
#define B_AX_WDE_EMPTY_QTA_DMAC_DATA_CPU BIT(18)
#define B_AX_WDE_EMPTY_QTA_DMAC_WLAN_CPU BIT(17)
#define B_AX_WDE_EMPTY_QTA_DMAC_HIF BIT(16)
#define B_AX_WDE_EMPTY_QUE_DMAC_PKTIN BIT(10)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_TX BIT(9)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_TX BIT(8)
#define B_AX_WDE_EMPTY_QUE_OTHERS BIT(7)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM1 BIT(4)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM0 BIT(3)
#define B_AX_WDE_EMPTY_QUE_CMAC1_MBH BIT(2)
#define B_AX_WDE_EMPTY_QUE_CMAC0_MBH BIT(1)
#define B_AX_WDE_EMPTY_QUE_CMAC0_ALL_AC BIT(0)

#define R_AX_DLE_EMPTY1 0x8434
#define B_AX_PLE_EMPTY_QTA_DMAC_WDRLS BIT(20)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_BBRPT BIT(19)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_RX BIT(18)
#define B_AX_PLE_EMPTY_QTA_CMAC0_DMA_RX BIT(17)
#define B_AX_PLE_EMPTY_QTA_DMAC_C2H BIT(16)
#define B_AX_PLE_EMPTY_QUE_DMAC_PLRLS BIT(5)
#define B_AX_PLE_EMPTY_QUE_DMAC_CPUIO BIT(4)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_RX BIT(3)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_RX BIT(2)
#define B_AX_PLE_EMPTY_QUE_DMAC_HDP BIT(1)
#define B_AX_WDE_EMPTY_QUE_DMAC_WDRLS BIT(0)

#define R_AX_FWD2IMR 0x8500
#define B_AX_FS_TXPKTIN_INT_EN BIT(5)
#define B_AX_FS_WWLAN_INT_EN BIT(4)
#define B_AX_FS_PLD_CPU_IO_PORT_Q1_INT_EN BIT(3)
#define B_AX_FS_PLD_CPU_IO_PORT_Q0_INT_EN BIT(2)
#define B_AX_FS_WD_CPU_IO_PORT_Q1_INT_EN BIT(1)
#define B_AX_FS_WD_CPU_IO_PORT_Q0_INT_EN BIT(0)

#define R_AX_FWD2ISR 0x8504
#define B_AX_FS_TXPKTIN_INT BIT(5)
#define B_AX_FS_WWLAN_INT BIT(4)
#define B_AX_FS_PLD_CPU_IO_PORT_Q1_INT BIT(3)
#define B_AX_FS_PLD_CPU_IO_PORT_Q0_INT BIT(2)
#define B_AX_FS_WD_CPU_IO_PORT_Q1_INT BIT(1)
#define B_AX_FS_WD_CPU_IO_PORT_Q0_INT BIT(0)

#define R_AX_DMAC_ERR_IMR 0x8520
#define B_AX_DLE_CPUIO_ERR_INT_EN BIT(10)
#define B_AX_APB_BRIDGE_ERR_INT_EN BIT(9)
#define B_AX_DISPATCH_ERR_INT_EN BIT(8)
#define B_AX_PKTIN_ERR_INT_EN BIT(7)
#define B_AX_PLE_DLE_ERR_INT_EN BIT(6)
#define B_AX_TXPKTCTRL_ERR_INT_EN BIT(5)
#define B_AX_WDE_DLE_ERR_INT_EN BIT(4)
#define B_AX_STA_SCHEDULER_ERR_INT_EN BIT(3)
#define B_AX_MPDU_ERR_INT_EN BIT(2)
#define B_AX_WSEC_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_ERR_INT_EN BIT(0)

#define R_AX_DMAC_ERR_ISR 0x8524
#define B_AX_HAXIDMA_ERR_FLAG BIT(14)
#define B_AX_DLE_CPUIO_ERR_FLAG BIT(10)
#define B_AX_APB_BRIDGE_ERR_FLAG BIT(9)
#define B_AX_DISPATCH_ERR_FLAG BIT(8)
#define B_AX_PKTIN_ERR_FLAG BIT(7)
#define B_AX_PLE_DLE_ERR_FLAG BIT(6)
#define B_AX_TXPKTCTRL_ERR_FLAG BIT(5)
#define B_AX_WDE_DLE_ERR_FLAG BIT(4)
#define B_AX_STA_SCHEDULER_ERR_FLAG BIT(3)
#define B_AX_MPDU_ERR_FLAG BIT(2)
#define B_AX_WSEC_ERR_FLAG BIT(1)
#define B_AX_WDRLS_ERR_FLAG BIT(0)

#define R_AX_FWD2ISR_HOST_EN 0x8550
#define B_AX_FWD2ISR_HOST_EN_SH 0
#define B_AX_FWD2ISR_HOST_EN_MSK 0xfffff

#define R_AX_FWD2ISR_HOST 0x8554
#define B_AX_FWD2ISR_HOST_SH 0
#define B_AX_FWD2ISR_HOST_MSK 0xfffff

#define R_AX_BIST_CTRL 0x8600

#define R_AX_SYS_CTRL 0x8604
#define B_AX_SYM_MEM_RMV_WL_SH 4
#define B_AX_SYM_MEM_RMV_WL_MSK 0xf

#define R_AX_BIST_CTRL_1 0x8610
#define B_AX_BIST_RSTN_N_DMAC_SH 0
#define B_AX_BIST_RSTN_N_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_2 0x8614
#define B_AX_BIST_DONE_DMAC_SH 0
#define B_AX_BIST_DONE_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_3 0x8618
#define B_AX_BIST_FAIL_DMAC_SH 0
#define B_AX_BIST_FAIL_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_4 0x861C
#define B_AX_BIST_DRF_PAUSE_DMAC_SH 0
#define B_AX_BIST_DRF_PAUSE_DMAC_MSK 0xfffffff

//
// Dispatcher
//

#define R_AX_DISPATCHER_GLOBAL_SETTING_0 0x8800
#define B_AX_PLE_LAST_OPT BIT(17)
#define B_AX_WDE_LAST_OPT BIT(16)
#define B_AX_PL_PAGE_128B_SEL BIT(9)
#define B_AX_WD_PAGE_64B_SEL BIT(8)
#define B_AX_CDR_GATTING_DISABLE BIT(3)
#define B_AX_CDT_GATTING_DISABLE BIT(2)
#define B_AX_HDR_GATTING_DISABLE BIT(1)
#define B_AX_HDT_GATTING_DISABLE BIT(0)

#define R_AX_OTHER_DISPATCHER_ERR_ISR 0x8804
#define B_AX_OTHER_STF_WROQT_UNDERFLOW BIT(29)
#define B_AX_OTHER_STF_WROQT_OVERFLOW BIT(28)
#define B_AX_OTHER_STF_WRFF_UNDERFLOW BIT(27)
#define B_AX_OTHER_STF_WRFF_OVERFLOW BIT(26)
#define B_AX_OTHER_STF_CMD_UNDERFLOW BIT(25)
#define B_AX_OTHER_STF_CMD_OVERFLOW BIT(24)
#define B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR BIT(17)
#define B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR BIT(16)
#define B_AX_PLE_OUTPUT_ERR BIT(12)
#define B_AX_PLE_RESP_ERR BIT(11)
#define B_AX_PLE_BURST_NUM_ERR BIT(10)
#define B_AX_PLE_NULL_PKT_ERR BIT(9)
#define B_AX_PLE_FLOW_CTRL_ERR BIT(8)
#define B_AX_WDE_OUTPUT_ERR BIT(4)
#define B_AX_WDE_RESP_ERR BIT(3)
#define B_AX_WDE_BURST_NUM_ERR BIT(2)
#define B_AX_WDE_NULL_PKT_ERR BIT(1)
#define B_AX_WDE_FLOW_CTRL_ERR BIT(0)

#define R_AX_HOST_DISPATCHER_ERR_ISR 0x8808
#define B_AX_HDT_RX_WRITE_UNDERFLOW BIT(31)
#define B_AX_HDT_RX_WRITE_OVERFLOW BIT(30)
#define B_AX_HDT_CHKSUM_FSM_ERR BIT(29)
#define B_AX_HDT_SHIFT_DMA_CFG_ERR BIT(28)
#define B_AX_HDT_DMA_PROCESS_ERR BIT(27)
#define B_AX_HDT_TOTAL_LEN_ERR BIT(26)
#define B_AX_HDT_SHIFT_EN_ERR BIT(25)
#define B_AX_HDT_RXAGG_CFG_ERR BIT(24)
#define B_AX_HDT_OUTPUT_ERR BIT(21)
#define B_AX_HDT_RESP_ERR BIT(20)
#define B_AX_HDT_BURST_NUM_ERR BIT(19)
#define B_AX_HDT_NULLPKT_ERR BIT(18)
#define B_AX_HDT_FLOW_CTRL_ERR BIT(17)
#define B_AX_HDT_PLD_CMD_UNDERFLOW BIT(16)
#define B_AX_HDT_PLD_CMD_OVERLOW BIT(15)
#define B_AX_HDT_TX_WRITE_UNDERFLOW BIT(14)
#define B_AX_HDT_TX_WRITE_OVERFLOW BIT(13)
#define B_AX_HDT_TCP_CHK_ERR BIT(12)
#define B_AX_HDT_TXPKTSIZE_ERR BIT(11)
#define B_AX_HDT_PRE_COST_ERR BIT(10)
#define B_AX_HDT_WD_CHK_ERR BIT(9)
#define B_AX_HDT_CHANNEL_DMA_ERR BIT(8)
#define B_AX_HDT_OFFSET_UNMATCH BIT(7)
#define B_AX_HDT_PAYLOAD_UNDERFLOW BIT(6)
#define B_AX_HDT_PAYLOAD_OVERFLOW BIT(5)
#define B_AX_HDT_PERMU_UNDERFLOW BIT(4)
#define B_AX_HDT_PERMU_OVERFLOW BIT(3)
#define B_AX_HDT_PKT_FAIL_DBG BIT(2)
#define B_AX_HDT_CHANNEL_ID_ERR BIT(1)
#define B_AX_HDT_CHANNEL_DIFF_ERR BIT(0)

#define R_AX_CPU_DISPATCHER_ERR_ISR 0x880C
#define B_AX_CPU_RX_WRITE_UNDERFLOW BIT(31)
#define B_AX_CPU_RX_WRITE_OVERFLOW BIT(30)
#define B_AX_CPU_CHKSUM_FSM_ERR BIT(29)
#define B_AX_CPU_SHIFT_DMA_CFG_ERR BIT(28)
#define B_AX_CPU_DMA_PROCESS_ERR BIT(27)
#define B_AX_CPU_TOTAL_LEN_ERR BIT(26)
#define B_AX_CPU_SHIFT_EN_ERR BIT(25)
#define B_AX_CPU_RXAGG_CFG_ERR BIT(24)
#define B_AX_CPU_OUTPUT_ERR BIT(20)
#define B_AX_CPU_RESP_ERR BIT(19)
#define B_AX_CPU_BURST_NUM_ERR BIT(18)
#define B_AX_CPU_NULLPKT_ERR BIT(17)
#define B_AX_CPU_FLOW_CTRL_ERR BIT(16)
#define B_AX_CPU_F2P_SEQ_ERR BIT(15)
#define B_AX_CPU_F2P_QSEL_ERR BIT(14)
#define B_AX_CPU_PLD_CMD_UNDERFLOW BIT(13)
#define B_AX_CPU_PLD_CMD_OVERLOW BIT(12)
#define B_AX_CPU_PRE_COST_ERR BIT(11)
#define B_AX_CPU_WD_CHK_ERR BIT(10)
#define B_AX_CPU_CHANNEL_DMA_ERR BIT(9)
#define B_AX_CPU_OFFSET_UNMATCH BIT(8)
#define B_AX_CPU_PAYLOAD_CHKSUM_ERR BIT(7)
#define B_AX_CPU_PAYLOAD_UNDERFLOW BIT(6)
#define B_AX_CPU_PAYLOAD_OVERFLOW BIT(5)
#define B_AX_CPU_PERMU_UNDERFLOW BIT(4)
#define B_AX_CPU_PERMU_OVERFLOW BIT(3)
#define B_AX_CPU_CHANNEL_ID_ERR BIT(2)
#define B_AX_CPU_PKT_FAIL_DBG BIT(1)
#define B_AX_CPU_CHANNEL_DIFF_ERR BIT(0)

#define R_AX_TX_ADDRESS_INFO_MODE_SETTING 0x8810
#define B_AX_CPU_ADDR_INFO_8B_SEL BIT(8)
#define B_AX_HOST_ADDR_INFO_8B_SEL BIT(0)

#define R_AX_TX_TCPIP_CHECKSUM_FUNCTION 0x8814
#define B_AX_HDT_TCPIP_CHKSUM_EN BIT(0)

#define R_AX_TXAGG_ALIGN_CFG 0x8818
#define B_AX_TXAGG_ALIGN_SIZE_EN BIT(31)
#define B_AX_TXAGG_ALIGN_SIZE_SH 0
#define B_AX_TXAGG_ALIGN_SIZE_MSK 0xfff

#define R_AX_TX_PASTE_TIMESTAMP_SETTING 0x881C
#define B_AX_HDT_TIMESTAMP_EN BIT(0)

#define R_AX_CPU_PORT_DEBUG_SETTING 0x8820
#define B_AX_CDT_F2P_CPU_PORT_EN BIT(9)
#define B_AX_CDT_AC_CPU_PORT_EN BIT(8)
#define B_AX_HDT_AC_CPU_PORT_EN BIT(0)

#define R_AX_TX_CHECK_OFFSET_SETTING 0x8824
#define B_AX_CDT_CHK_OFFSET_EN BIT(24)
#define B_AX_CDT_CHK_OFFSET_SH 16
#define B_AX_CDT_CHK_OFFSET_MSK 0xff
#define B_AX_HDT_CHK_OFFSET_EN BIT(8)
#define B_AX_HDT_CHK_OFFSET_SH 0
#define B_AX_HDT_CHK_OFFSET_MSK 0xff

#define R_AX_TX_QUEUE_CLEAR_SETTING 0x8828
#define B_AX_HDT_TXQUE_CLR_EN BIT(0)

#define R_AX_TX_ERROR_STOP_DEBUG_SETTING 0x882C
#define B_AX_CDT_ERROR_STOP BIT(8)
#define B_AX_HDT_ERROR_STOP BIT(0)

#define R_AX_WD_CHECKSUM_FUNCTION_ENABLE 0x8830
#define B_AX_CDT_WD_CHKSUM_EN BIT(8)
#define B_AX_HDT_WD_CHKSUM_EN BIT(0)

#define R_AX_TX_DTAT_DROP_DEBUG_SETTING 0x8834
#define B_AX_CDT_DATA_DROP_EN BIT(8)
#define B_AX_HDT_DATA_DROP_EN BIT(0)

#define R_AX_REQUEST_PLE_BUFFER_SETTING 0x8838
#define B_AX_AMSDU_PADDING_SPACE_SH 8
#define B_AX_AMSDU_PADDING_SPACE_MSK 0xff
#define B_AX_RSV_PLD_SPACE_SH 0
#define B_AX_RSV_PLD_SPACE_MSK 0xff

#define R_AX_DMAC_MACID_DROP_0 0x8840
#define B_AX_DMAC_MACID31_0_DROP_SH 0
#define B_AX_DMAC_MACID31_0_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_1 0x8844
#define B_AX_DMAC_MACID63_32_DROP_SH 0
#define B_AX_DMAC_MACID63_32_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_2 0x8848
#define B_AX_DMAC_MACID95_64_DROP_SH 0
#define B_AX_DMAC_MACID95_64_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_3 0x884C
#define B_AX_DMAC_MACID127_96_DROP_SH 0
#define B_AX_DMAC_MACID127_96_DROP_MSK 0xffffffffL

#define R_AX_HOST_DISPATCHER_ERR_IMR 0x8850
#define B_AX_HDT_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_HDT_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_HDT_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_HDT_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_HDT_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_HDT_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_HDT_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_HDT_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_HDT_OUTPUT_ERR_INT_EN BIT(21)
#define B_AX_HDT_RES_ERR_INT_EN BIT(20)
#define B_AX_HDT_BURST_NUM_ERR_INT_EN BIT(19)
#define B_AX_HDT_NULLPKT_ERR_INT_EN BIT(18)
#define B_AX_HDT_FLOW_CTRL_ERR_INT_EN BIT(17)
#define B_AX_HDT_PLD_CMD_UNDERFLOW_INT_EN BIT(16)
#define B_AX_HDT_PLD_CMD_OVERLOW_INT_EN BIT(15)
#define B_AX_HDT_TX_WRITE_UNDERFLOW_INT_EN BIT(14)
#define B_AX_HDT_TX_WRITE_OVERFLOW_INT_EN BIT(13)
#define B_AX_HDT_TCP_CHK_ERR_INT_EN BIT(12)
#define B_AX_HDT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_AX_HDT_PRE_COST_ERR_INT_EN BIT(10)
#define B_AX_HDT_WD_CHK_ERR_INT_EN BIT(9)
#define B_AX_HDT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_AX_HDT_OFFSET_UNMATCH_INT_EN BIT(7)
#define B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_HDT_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_HDT_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_HDT_PKT_FAIL_DBG_INT_EN BIT(2)
#define B_AX_HDT_CHANNEL_ID_ERR_INT_EN BIT(1)
#define B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN BIT(0)

#define R_AX_CPU_DISPATCHER_ERR_IMR 0x8854
#define B_AX_CPU_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_CPU_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_CPU_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_CPU_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_CPU_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_CPU_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_CPU_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_CPU_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_CPU_OUTPUT_ERR_INT_EN BIT(20)
#define B_AX_CPU_RESP_ERR_INT_EN BIT(19)
#define B_AX_CPU_BURST_NUM_ERR_INT_EN BIT(18)
#define B_AX_CPU_NULLPKT_ERR_INT_EN BIT(17)
#define B_AX_CPU_FLOW_CTRL_ERR_INT_EN BIT(16)
#define B_AX_CPU_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_AX_CPU_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_AX_CPU_PLD_CMD_UNDERFLOW_INT_EN BIT(13)
#define B_AX_CPU_PLD_CMD_OVERLOW_INT_EN BIT(12)
#define B_AX_CPU_PRE_COST_ERR_INT_EN BIT(11)
#define B_AX_CPU_WD_CHK_ERR_INT_EN BIT(10)
#define B_AX_CPU_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_AX_CPU_OFFSET_UNMATCH_INT_EN BIT(8)
#define B_AX_CPU_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_AX_CPU_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_CPU_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_CPU_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_CPU_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_CPU_CHANNEL_ID_ERR_INT_EN BIT(2)
#define B_AX_CPU_PKT_FAIL_DBG_INT_EN BIT(1)
#define B_AX_CPU_CHANNEL_DIFF_ERR_INT_EN BIT(0)

#define R_AX_OTHER_DISPATCHER_ERR_IMR 0x8858
#define B_AX_OTHER_STF_WROQT_UNDERFLOW_INT_EN BIT(29)
#define B_AX_OTHER_STF_WROQT_OVERFLOW_INT_EN BIT(28)
#define B_AX_OTHER_STF_WRFF_UNDERFLOW_INT_EN BIT(27)
#define B_AX_OTHER_STF_WRFF_OVERFLOW_INT_EN BIT(26)
#define B_AX_OTHER_STF_CMD_UNDERFLOW_INT_EN BIT(25)
#define B_AX_OTHER_STF_CMD_OVERFLOW_INT_EN BIT(24)
#define B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(17)
#define B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(16)
#define B_AX_PLE_OUTPUT_ERR_INT_EN BIT(12)
#define B_AX_PLE_RESP_ERR_INT_EN BIT(11)
#define B_AX_PLE_BURST_NUM_ERR_INT_EN BIT(10)
#define B_AX_PLE_NULL_PKT_ERR_INT_EN BIT(9)
#define B_AX_PLE_FLOW_CTRL_ERR_INT_EN BIT(8)
#define B_AX_WDE_OUTPUT_ERR_INT_EN BIT(4)
#define B_AX_WDE_RESP_ERR_INT_EN BIT(3)
#define B_AX_WDE_BURST_NUM_ERR_INT_EN BIT(2)
#define B_AX_WDE_NULL_PKT_ERR_INT_EN BIT(1)
#define B_AX_WDE_FLOW_CTRL_ERR_INT_EN BIT(0)

#define R_AX_DISPATCHER_DBG_PORT 0x8860
#define B_AX_DISPATCHER_DBG_SEL_SH 8
#define B_AX_DISPATCHER_DBG_SEL_MSK 0xf
#define B_AX_DISPATCHER_INTN_SEL_SH 4
#define B_AX_DISPATCHER_INTN_SEL_MSK 0xf
#define B_AX_DISPATCHER_CH_SEL_SH 0
#define B_AX_DISPATCHER_CH_SEL_MSK 0xf

#define R_AX_HDP_DBG_INFO_0 0x8880
#define B_AX_PTR_CS_WP_SH 28
#define B_AX_PTR_CS_WP_MSK 0xf
#define B_AX_PTR_CS_10_SH 24
#define B_AX_PTR_CS_10_MSK 0xf
#define B_AX_PTR_CS_8_SH 20
#define B_AX_PTR_CS_8_MSK 0xf
#define B_AX_PTR_CS_6_SH 16
#define B_AX_PTR_CS_6_MSK 0xf
#define B_AX_PTR_CS_4_SH 12
#define B_AX_PTR_CS_4_MSK 0xf
#define B_AX_PTR_CS_2_SH 8
#define B_AX_PTR_CS_2_MSK 0xf
#define B_AX_PTR_CS_0_SH 4
#define B_AX_PTR_CS_0_MSK 0xf
#define B_AX_DATA_CS_SH 0
#define B_AX_DATA_CS_MSK 0x7

#define R_AX_HDP_DBG_INFO_1 0x8884
#define B_AX_CH6_PKT_CNT_SH 24
#define B_AX_CH6_PKT_CNT_MSK 0xff
#define B_AX_CH4_PKT_CNT_SH 16
#define B_AX_CH4_PKT_CNT_MSK 0xff
#define B_AX_CH2_PKT_CNT_SH 8
#define B_AX_CH2_PKT_CNT_MSK 0xff
#define B_AX_CH0_PKT_CNT_SH 0
#define B_AX_CH0_PKT_CNT_MSK 0xff

#define R_AX_HDP_DBG_INFO_2 0x8888
#define B_AX_HCIFF_NON_EMPTY BIT(31)
#define B_AX_AXIFF_NON_EMPTY BIT(30)
#define B_AX_WP_PKT_CNT_SH 16
#define B_AX_WP_PKT_CNT_MSK 0xff
#define B_AX_CH10_PKT_CNT_SH 8
#define B_AX_CH10_PKT_CNT_MSK 0xff
#define B_AX_CH8_PKT_CNT_SH 0
#define B_AX_CH8_PKT_CNT_MSK 0xff

#define R_AX_HDP_DBG_INFO_3 0x888C
#define B_AX_WP_PKT_CNT_2_SH 24
#define B_AX_WP_PKT_CNT_2_MSK 0xff
#define B_AX_CH1_PKT_CNT_SH 16
#define B_AX_CH1_PKT_CNT_MSK 0xff
#define B_AX_PTR_CS_WP_2_SH 12
#define B_AX_PTR_CS_WP_2_MSK 0xf
#define B_AX_PTR_CS_1_SH 8
#define B_AX_PTR_CS_1_MSK 0xf
#define B_AX_DATA_CS_2_SH 0
#define B_AX_DATA_CS_2_MSK 0x7

#define R_AX_HDP_DBG_INFO_4 0x8890
#define B_AX_ADDR_INFO_CS_SH 28
#define B_AX_ADDR_INFO_CS_MSK 0xf
#define B_AX_HCI_WP_FF_FULL BIT(27)
#define B_AX_AXI_WP_FF_FULL BIT(26)
#define B_AX_HFC_CH_FULL_SH 13
#define B_AX_HFC_CH_FULL_MSK 0x1fff
#define B_AX_HFC_CH_REQ_SH 0
#define B_AX_HFC_CH_REQ_MSK 0x1fff

#define R_AX_HDP_DBG_INFO_5 0x8894
#define B_AX_FETCH_PLD_PKT_CNT_SH 24
#define B_AX_FETCH_PLD_PKT_CNT_MSK 0xff

#define R_AX_HDP_DBG_INFO_6 0x8898
#define B_AX_INTF_BTWN_TPKTCTL_SH 12
#define B_AX_INTF_BTWN_TPKTCTL_MSK 0xf

#define R_AX_HDP_DBG_INFO_7 0x889C

#define R_AX_HDP_DBG_INFO_8 0x88A0

#define R_AX_HDP_DBG_INFO_9 0x88A4

#define R_AX_HDP_DBG_INFO_10 0x88A8
#define B_AX_WRFF_EMPTY_HDP BIT(31)
#define B_AX_DMA_ST_HDR_HDP_SH 20
#define B_AX_DMA_ST_HDR_HDP_MSK 0x7
#define B_AX_RX_ST_HDR_HDP_SH 16
#define B_AX_RX_ST_HDR_HDP_MSK 0x7

#define R_AX_HDP_DBG_INFO_11 0x88AC
#define B_AX_HCI_REQ_SH 28
#define B_AX_HCI_REQ_MSK 0x3
#define B_AX_HCI_EMPTY BIT(27)
#define B_AX_PCIE_RXBD_VLD_SH 24
#define B_AX_PCIE_RXBD_VLD_MSK 0x3

#define R_AX_HDP_DBG_INFO_12 0x88B0
#define B_AX_WRFF_EMPTY_CDP BIT(31)
#define B_AX_PLE_DISPATCHER_Q_EMPTY_SH 0
#define B_AX_PLE_DISPATCHER_Q_EMPTY_MSK 0xffffff

#define R_AX_HDP_DBG_INFO_13 0x88B4
#define B_AX_DMA_ST_HDR_CDP_SH 28
#define B_AX_DMA_ST_HDR_CDP_MSK 0x7
#define B_AX_RX_ST_HDR_CDP_SH 24
#define B_AX_RX_ST_HDR_CDP_MSK 0x7
#define B_AX_AXI_REQ_SH 16
#define B_AX_AXI_REQ_MSK 0x1f
#define B_AX_AXIDMA_RXBD_VLD_SH 0
#define B_AX_AXIDMA_RXBD_VLD_MSK 0x1f

#define R_AX_RXAGG_0 0x8900
#define B_AX_RXAGG_EN BIT(31)
#define B_AX_RXAGG_DMA_STORE BIT(30)
#define B_AX_RXAGG_SW_EN BIT(29)
#define B_AX_RXAGG_SW_TRIG BIT(28)
#define B_AX_RXAGG_PKTNUM_TH_SH 16
#define B_AX_RXAGG_PKTNUM_TH_MSK 0xff
#define B_AX_RXAGG_TIMEOUT_TH_SH 8
#define B_AX_RXAGG_TIMEOUT_TH_MSK 0xff
#define B_AX_RXAGG_LEN_TH_SH 0
#define B_AX_RXAGG_LEN_TH_MSK 0xff

#define R_AX_RXAGG_1 0x8904
#define B_AX_RXAGG_SML_PKT_SIZE_SH 8
#define B_AX_RXAGG_SML_PKT_SIZE_MSK 0x7
#define B_AX_RXAGG_SML_PKTNUM_TH_SH 0
#define B_AX_RXAGG_SML_PKTNUM_TH_MSK 0x1f

#define R_AX_RXDMA_SETTING 0x8908
#define B_AX_PLE_BURST_READ BIT(24)
#define B_AX_REQ_DEPTH_SH 16
#define B_AX_REQ_DEPTH_MSK 0x3
#define B_AX_BULK_TH_OPT BIT(10)
#define B_AX_BURST_CNT_SH 8
#define B_AX_BURST_CNT_MSK 0x3
#define B_AX_BULK_SIZE_SH 0
#define B_AX_BULK_SIZE_MSK 0x3

#define R_AX_FWDL_CHECKSUM 0x890C
#define B_AX_FWDL_CHKSUM_SH 16
#define B_AX_FWDL_CHKSUM_MSK 0xffff
#define B_AX_FWDL_CHKSUM_VALID BIT(2)
#define B_AX_FWDL_CHKSUM_RESULT BIT(1)
#define B_AX_FWDL_CHKSUM_EN BIT(0)

#define R_AX_H2C_SETTING 0x8910
#define B_AX_CDR_REMOVE_H2C_WD BIT(0)

#define R_AX_RX_PPDU_STATUS_FW_MODE 0x8914
#define B_AX_HDR_PPDU_ENQ_WLCPU_EN BIT(31)
#define B_AX_CDR_PPDU_2_WLCPU_LEN_SH 0
#define B_AX_CDR_PPDU_2_WLCPU_LEN_MSK 0x3fff

#define R_AX_RX_TCPIP_CHECKSUM_FUNCTION 0x8918
#define B_AX_HDR_TCPIP_CHKSUM_EN BIT(0)

#define R_AX_RX_FC_BD_VALID_MASK 0x891C
#define B_AX_CDR_BD_MASK_SH 8
#define B_AX_CDR_BD_MASK_MSK 0x1f
#define B_AX_HDR_BD_MASK_SH 0
#define B_AX_HDR_BD_MASK_MSK 0x3

#define R_AX_RX_FUNCTION_STOP 0x8920
#define B_AX_CDR_DISABLE_PPDU BIT(20)
#define B_AX_CDR_DISABLE_RPQ BIT(19)
#define B_AX_CDR_DISABLE_H2C BIT(18)
#define B_AX_CDR_DISABLE_TXRPT BIT(17)
#define B_AX_CDR_DISABLE_NORMAL BIT(16)
#define B_AX_HDR_DISABLE_RPQ BIT(11)
#define B_AX_HDR_DISABLE_C2H BIT(10)
#define B_AX_HDR_DISABLE_REPORT BIT(9)
#define B_AX_HDR_DISABLE_NORMAL BIT(8)
#define B_AX_CDR_RX_STOP BIT(1)
#define B_AX_HDR_RX_STOP BIT(0)

#define R_AX_HCI_FC_CTRL 0x8A00
#define B_AX_HCI_FC_CH12_FULL_COND_SH 10
#define B_AX_HCI_FC_CH12_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WP_CH811_FULL_COND_SH 8
#define B_AX_HCI_FC_WP_CH811_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WP_CH07_FULL_COND_SH 6
#define B_AX_HCI_FC_WP_CH07_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WD_FULL_COND_SH 4
#define B_AX_HCI_FC_WD_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_CH12_EN BIT(3)
#define B_AX_HCI_FC_MODE_SH 1
#define B_AX_HCI_FC_MODE_MSK 0x3
#define B_AX_HCI_FC_EN BIT(0)

#define R_AX_CH_PAGE_CTRL 0x8A04
#define B_AX_PREC_PAGE_CH12_SH 16
#define B_AX_PREC_PAGE_CH12_MSK 0x1ff
#define B_AX_PREC_PAGE_CH011_SH 0
#define B_AX_PREC_PAGE_CH011_MSK 0x1ff

#define R_AX_ACH011_INTRPT_STAT 0x8A08
#define B_AX_ACH11_INTRPT_STAT BIT(11)
#define B_AX_ACH10_INTRPT_STAT BIT(10)
#define B_AX_ACH9_INTRPT_STAT BIT(9)
#define B_AX_ACH8_INTRPT_STAT BIT(8)
#define B_AX_ACH7_INTRPT_STAT BIT(7)
#define B_AX_ACH6_INTRPT_STAT BIT(6)
#define B_AX_ACH5_INTRPT_STAT BIT(5)
#define B_AX_ACH4_INTRPT_STAT BIT(4)
#define B_AX_ACH3_INTRPT_STAT BIT(3)
#define B_AX_ACH2_INTRPT_STAT BIT(2)
#define B_AX_ACH1_INTRPT_STAT BIT(1)
#define B_AX_ACH0_INTRPT_STAT BIT(0)

#define R_AX_HCI_FC_ERR_FLAG 0x8A0C
#define B_AX_PUB_AVAL_PG_OFW BIT(10)
#define B_AX_PUB_AVAL_PG_UFW BIT(9)
#define B_AX_PUB_USE_PG_OFW BIT(8)
#define B_AX_PUB_USE_PG_UFW BIT(7)
#define B_AX_CH011_USE_PG_OFW BIT(6)
#define B_AX_CH011_USE_PG_UFW BIT(5)
#define B_AX_CH011_AVAL_PG_OFW BIT(4)
#define B_AX_CH011_AVAL_PG_UFW BIT(3)

#define R_AX_ACH0_PAGE_CTRL 0x8A10
#define B_AX_ACH0_GRP BIT(31)
#define B_AX_ACH0_MAX_PG_SH 16
#define B_AX_ACH0_MAX_PG_MSK 0x1fff
#define B_AX_ACH0_MIN_PG_SH 0
#define B_AX_ACH0_MIN_PG_MSK 0x1fff

#define R_AX_ACH1_PAGE_CTRL 0x8A14
#define B_AX_ACH1_GRP BIT(31)
#define B_AX_ACH1_MAX_PG_SH 16
#define B_AX_ACH1_MAX_PG_MSK 0x1fff
#define B_AX_ACH1_MIN_PG_SH 0
#define B_AX_ACH1_MIN_PG_MSK 0x1fff

#define R_AX_ACH2_PAGE_CTRL 0x8A18
#define B_AX_ACH2_GRP BIT(31)
#define B_AX_ACH2_MAX_PG_SH 16
#define B_AX_ACH2_MAX_PG_MSK 0x1fff
#define B_AX_ACH2_MIN_PG_SH 0
#define B_AX_ACH2_MIN_PG_MSK 0x1fff

#define R_AX_ACH3_PAGE_CTRL 0x8A1C
#define B_AX_ACH3_GRP BIT(31)
#define B_AX_ACH3_MAX_PG_SH 16
#define B_AX_ACH3_MAX_PG_MSK 0x1fff
#define B_AX_ACH3_MIN_PG_SH 0
#define B_AX_ACH3_MIN_PG_MSK 0x1fff

#define R_AX_ACH4_PAGE_CTRL 0x8A20
#define B_AX_ACH4_GRP BIT(31)
#define B_AX_ACH4_MAX_PG_SH 16
#define B_AX_ACH4_MAX_PG_MSK 0x1fff
#define B_AX_ACH4_MIN_PG_SH 0
#define B_AX_ACH4_MIN_PG_MSK 0x1fff

#define R_AX_ACH5_PAGE_CTRL 0x8A24
#define B_AX_ACH5_GRP BIT(31)
#define B_AX_ACH5_MAX_PG_SH 16
#define B_AX_ACH5_MAX_PG_MSK 0x1fff
#define B_AX_ACH5_MIN_PG_SH 0
#define B_AX_ACH5_MIN_PG_MSK 0x1fff

#define R_AX_ACH6_PAGE_CTRL 0x8A28
#define B_AX_ACH6_GRP BIT(31)
#define B_AX_ACH6_MAX_PG_SH 16
#define B_AX_ACH6_MAX_PG_MSK 0x1fff
#define B_AX_ACH6_MIN_PG_SH 0
#define B_AX_ACH6_MIN_PG_MSK 0x1fff

#define R_AX_ACH7_PAGE_CTRL 0x8A2C
#define B_AX_ACH7_GRP BIT(31)
#define B_AX_ACH7_MAX_PG_SH 16
#define B_AX_ACH7_MAX_PG_MSK 0x1fff
#define B_AX_ACH7_MIN_PG_SH 0
#define B_AX_ACH7_MIN_PG_MSK 0x1fff

#define R_AX_CH8_PAGE_CTRL 0x8A30
#define B_AX_CH8_GRP BIT(31)
#define B_AX_CH8_MAX_PG_SH 16
#define B_AX_CH8_MAX_PG_MSK 0x1fff
#define B_AX_CH8_MIN_PG_SH 0
#define B_AX_CH8_MIN_PG_MSK 0x1fff

#define R_AX_CH9_PAGE_CTRL 0x8A34
#define B_AX_CH9_GRP BIT(31)
#define B_AX_CH9_MAX_PG_SH 16
#define B_AX_CH9_MAX_PG_MSK 0x1fff
#define B_AX_CH9_MIN_PG_SH 0
#define B_AX_CH9_MIN_PG_MSK 0x1fff

#define R_AX_CH10_PAGE_CTRL 0x8A38
#define B_AX_CH10_GRP BIT(31)
#define B_AX_CH10_MAX_PG_SH 16
#define B_AX_CH10_MAX_PG_MSK 0x1fff
#define B_AX_CH10_MIN_PG_SH 0
#define B_AX_CH10_MIN_PG_MSK 0x1fff

#define R_AX_CH11_PAGE_CTRL 0x8A3C
#define B_AX_CH11_GRP BIT(31)
#define B_AX_CH11_MAX_PG_SH 16
#define B_AX_CH11_MAX_PG_MSK 0x1fff
#define B_AX_CH11_MIN_PG_SH 0
#define B_AX_CH11_MIN_PG_MSK 0x1fff

#define R_AX_ACH0_PAGE_INFO 0x8A50
#define B_AX_ACH0_AVAL_PG_SH 16
#define B_AX_ACH0_AVAL_PG_MSK 0x1fff
#define B_AX_ACH0_USE_PG_SH 0
#define B_AX_ACH0_USE_PG_MSK 0x1fff

#define R_AX_ACH1_PAGE_INFO 0x8A54
#define B_AX_ACH1_AVAL_PG_SH 16
#define B_AX_ACH1_AVAL_PG_MSK 0x1fff
#define B_AX_ACH1_USE_PG_SH 0
#define B_AX_ACH1_USE_PG_MSK 0x1fff

#define R_AX_ACH2_PAGE_INFO 0x8A58
#define B_AX_ACH2_AVAL_PG_SH 16
#define B_AX_ACH2_AVAL_PG_MSK 0x1fff
#define B_AX_ACH2_USE_PG_SH 0
#define B_AX_ACH2_USE_PG_MSK 0x1fff

#define R_AX_ACH3_PAGE_INFO 0x8A5C
#define B_AX_ACH3_AVAL_PG_SH 16
#define B_AX_ACH3_AVAL_PG_MSK 0x1fff
#define B_AX_ACH3_USE_PG_SH 0
#define B_AX_ACH3_USE_PG_MSK 0x1fff

#define R_AX_ACH4_PAGE_INFO 0x8A60
#define B_AX_ACH4_AVAL_PG_SH 16
#define B_AX_ACH4_AVAL_PG_MSK 0x1fff
#define B_AX_ACH4_USE_PG_SH 0
#define B_AX_ACH4_USE_PG_MSK 0x1fff

#define R_AX_ACH5_PAGE_INFO 0x8A64
#define B_AX_ACH5_AVAL_PG_SH 16
#define B_AX_ACH5_AVAL_PG_MSK 0x1fff
#define B_AX_ACH5_USE_PG_SH 0
#define B_AX_ACH5_USE_PG_MSK 0x1fff

#define R_AX_ACH6_PAGE_INFO 0x8A68
#define B_AX_ACH6_AVAL_PG_SH 16
#define B_AX_ACH6_AVAL_PG_MSK 0x1fff
#define B_AX_ACH6_USE_PG_SH 0
#define B_AX_ACH6_USE_PG_MSK 0x1fff

#define R_AX_ACH7_PAGE_INFO 0x8A6C
#define B_AX_ACH7_AVAL_PG_SH 16
#define B_AX_ACH7_AVAL_PG_MSK 0x1fff
#define B_AX_ACH7_USE_PG_SH 0
#define B_AX_ACH7_USE_PG_MSK 0x1fff

#define R_AX_CH8_PAGE_INFO 0x8A70
#define B_AX_CH8_AVAL_PG_SH 16
#define B_AX_CH8_AVAL_PG_MSK 0x1fff
#define B_AX_CH8_USE_PG_SH 0
#define B_AX_CH8_USE_PG_MSK 0x1fff

#define R_AX_CH9_PAGE_INFO 0x8A74
#define B_AX_CH9_AVAL_PG_SH 16
#define B_AX_CH9_AVAL_PG_MSK 0x1fff
#define B_AX_CH9_USE_PG_SH 0
#define B_AX_CH9_USE_PG_MSK 0x1fff

#define R_AX_CH10_PAGE_INFO 0x8A78
#define B_AX_CH10_AVAL_PG_SH 16
#define B_AX_CH10_AVAL_PG_MSK 0x1fff
#define B_AX_CH10_USE_PG_SH 0
#define B_AX_CH10_USE_PG_MSK 0x1fff

#define R_AX_CH11_PAGE_INFO 0x8A7C
#define B_AX_CH11_AVAL_PG_SH 16
#define B_AX_CH11_AVAL_PG_MSK 0x1fff
#define B_AX_CH11_USE_PG_SH 0
#define B_AX_CH11_USE_PG_MSK 0x1fff

#define R_AX_CH12_PAGE_INFO 0x8A80
#define B_AX_CH12_AVAL_PG_SH 16
#define B_AX_CH12_AVAL_PG_MSK 0x1fff

#define R_AX_PUB_PAGE_INFO3 0x8A8C
#define B_AX_G1_AVAL_PG_SH 16
#define B_AX_G1_AVAL_PG_MSK 0x1fff
#define B_AX_G0_AVAL_PG_SH 0
#define B_AX_G0_AVAL_PG_MSK 0x1fff

#define R_AX_PUB_PAGE_CTRL1 0x8A90
#define B_AX_PUBPG_G1_SH 16
#define B_AX_PUBPG_G1_MSK 0x1fff
#define B_AX_PUBPG_G0_SH 0
#define B_AX_PUBPG_G0_MSK 0x1fff

#define R_AX_PUB_PAGE_CTRL2 0x8A94
#define B_AX_PUBPG_ALL_SH 0
#define B_AX_PUBPG_ALL_MSK 0x1fff

#define R_AX_PUB_PAGE_INFO1 0x8A98
#define B_AX_G1_USE_PG_SH 16
#define B_AX_G1_USE_PG_MSK 0x1fff
#define B_AX_G0_USE_PG_SH 0
#define B_AX_G0_USE_PG_MSK 0x1fff

#define R_AX_PUB_PAGE_INFO2 0x8A9C
#define B_AX_PUB_AVAL_PG_SH 0
#define B_AX_PUB_AVAL_PG_MSK 0x1fff

#define R_AX_WP_PAGE_CTRL1 0x8AA0
#define B_AX_PREC_PAGE_WP_CH811_SH 16
#define B_AX_PREC_PAGE_WP_CH811_MSK 0x1ff
#define B_AX_PREC_PAGE_WP_CH07_SH 0
#define B_AX_PREC_PAGE_WP_CH07_MSK 0x1ff

#define R_AX_WP_PAGE_CTRL2 0x8AA4
#define B_AX_WP_THRD_SH 0
#define B_AX_WP_THRD_MSK 0x1fff

#define R_AX_WP_PAGE_INFO1 0x8AA8
#define B_AX_WP_AVAL_PG_SH 16
#define B_AX_WP_AVAL_PG_MSK 0x1fff

#define R_AX_ACH0_THR 0x8AB0
#define B_AX_ACH0_INTRPT_EN BIT(31)
#define B_AX_ACH0_THR_WP_SH 16
#define B_AX_ACH0_THR_WP_MSK 0x1fff
#define B_AX_ACH0_THR_WD_SH 0
#define B_AX_ACH0_THR_WD_MSK 0x1fff

#define R_AX_ACH1_THR 0x8AB4
#define B_AX_ACH1_INTRPT_EN BIT(31)
#define B_AX_ACH1_THR_WP_SH 16
#define B_AX_ACH1_THR_WP_MSK 0x1fff
#define B_AX_ACH1_THR_WD_SH 0
#define B_AX_ACH1_THR_WD_MSK 0x1fff

#define R_AX_ACH2_THR 0x8AB8
#define B_AX_ACH2_INTRPT_EN BIT(31)
#define B_AX_ACH2_THR_WP_SH 16
#define B_AX_ACH2_THR_WP_MSK 0x1fff
#define B_AX_ACH2_THR_WD_SH 0
#define B_AX_ACH2_THR_WD_MSK 0x1fff

#define R_AX_ACH3_THR 0x8ABC
#define B_AX_ACH3_INTRPT_EN BIT(31)
#define B_AX_ACH3_THR_WP_SH 16
#define B_AX_ACH3_THR_WP_MSK 0x1fff
#define B_AX_ACH3_THR_WD_SH 0
#define B_AX_ACH3_THR_WD_MSK 0x1fff

#define R_AX_ACH4_THR 0x8AC0
#define B_AX_ACH4_INTRPT_EN BIT(31)
#define B_AX_ACH4_THR_WP_SH 16
#define B_AX_ACH4_THR_WP_MSK 0x1fff
#define B_AX_ACH4_THR_WD_SH 0
#define B_AX_ACH4_THR_WD_MSK 0x1fff

#define R_AX_ACH5_THR 0x8AC4
#define B_AX_ACH5_INTRPT_EN BIT(31)
#define B_AX_ACH5_THR_WP_SH 16
#define B_AX_ACH5_THR_WP_MSK 0x1fff
#define B_AX_ACH5_THR_WD_SH 0
#define B_AX_ACH5_THR_WD_MSK 0x1fff

#define R_AX_ACH6_THR 0x8AC8
#define B_AX_ACH6_INTRPT_EN BIT(31)
#define B_AX_ACH6_THR_WP_SH 16
#define B_AX_ACH6_THR_WP_MSK 0x1fff
#define B_AX_ACH6_THR_WD_SH 0
#define B_AX_ACH6_THR_WD_MSK 0x1fff

#define R_AX_ACH7_THR 0x8ACC
#define B_AX_ACH7_INTRPT_EN BIT(31)
#define B_AX_ACH7_THR_WP_SH 16
#define B_AX_ACH7_THR_WP_MSK 0x1fff
#define B_AX_ACH7_THR_WD_SH 0
#define B_AX_ACH7_THR_WD_MSK 0x1fff

#define R_AX_CH8_THR 0x8AD0
#define B_AX_CH8_INTRPT_EN BIT(31)
#define B_AX_CH8_THR_WP_SH 16
#define B_AX_CH8_THR_WP_MSK 0x1fff
#define B_AX_CH8_THR_WD_SH 0
#define B_AX_CH8_THR_WD_MSK 0x1fff

#define R_AX_CH9_THR 0x8AD4
#define B_AX_CH9_INTRPT_EN BIT(31)
#define B_AX_CH9_THR_WP_SH 16
#define B_AX_CH9_THR_WP_MSK 0x1fff
#define B_AX_CH9_THR_WD_SH 0
#define B_AX_CH9_THR_WD_MSK 0x1fff

#define R_AX_CH10_THR 0x8AD8
#define B_AX_CH10_INTRPT_EN BIT(31)
#define B_AX_CH10_THR_WP_SH 16
#define B_AX_CH10_THR_WP_MSK 0x1fff
#define B_AX_CH10_THR_WD_SH 0
#define B_AX_CH10_THR_WD_MSK 0x1fff

#define R_AX_CH11_THR 0x8ADC
#define B_AX_CH11_INTRPT_EN BIT(31)
#define B_AX_CH11_THR_WP_SH 16
#define B_AX_CH11_THR_WP_MSK 0x1fff
#define B_AX_CH11_THR_WD_SH 0
#define B_AX_CH11_THR_WD_MSK 0x1fff

//
// WDE_DLE
//

#define R_AX_WDE_WORD000 0x8C00

#define R_AX_WDE_WORD004 0x8C04

#define R_AX_WDE_PKTBUF_CFG 0x8C08
#define B_AX_WDE_FREE_PAGE_NUM_SH 16
#define B_AX_WDE_FREE_PAGE_NUM_MSK 0x1fff
#define B_AX_WDE_START_BOUND_SH 8
#define B_AX_WDE_START_BOUND_MSK 0x3f
#define B_AX_WDE_PAGE_SEL_SH 0
#define B_AX_WDE_PAGE_SEL_MSK 0x3

#define R_AX_WDE_WORD00C 0x8C0C

#define R_AX_WDE_WORD010 0x8C10

#define R_AX_WDE_WORD014 0x8C14

#define R_AX_WDE_WORD018 0x8C18

#define R_AX_WDE_WORD01C 0x8C1C

#define R_AX_WDE_WORD020 0x8C20

#define R_AX_WDE_WORD024 0x8C24

#define R_AX_WDE_WORD028 0x8C28

#define R_AX_WDE_WORD02C 0x8C2C

#define R_AX_WDE_WORD030 0x8C30

#define R_AX_WDE_ERR_FLAG_CFG_NUM1 0x8C34
#define B_AX_WDE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_WDE_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_AX_WDE_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_AX_WDE_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_AX_WDE_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_AX_WDE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_WDE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_WDE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_WDE_ERR_IMR 0x8C38
#define B_AX_WDE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_AX_WDE_ERR_ISR 0x8C3C
#define B_AX_WDE_DATCHN_RRDY_ERR BIT(27)
#define B_AX_WDE_DATCHN_FRZTO_ERR BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR BIT(0)

#define R_AX_WDE_QTA0_CFG 0x8C40
#define B_AX_WDE_Q0_MAX_SIZE_SH 16
#define B_AX_WDE_Q0_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q0_MIN_SIZE_SH 0
#define B_AX_WDE_Q0_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA1_CFG 0x8C44
#define B_AX_WDE_Q1_MAX_SIZE_SH 16
#define B_AX_WDE_Q1_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q1_MIN_SIZE_SH 0
#define B_AX_WDE_Q1_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA2_CFG 0x8C48
#define B_AX_WDE_Q2_MAX_SIZE_SH 16
#define B_AX_WDE_Q2_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q2_MIN_SIZE_SH 0
#define B_AX_WDE_Q2_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA3_CFG 0x8C4C
#define B_AX_WDE_Q3_MAX_SIZE_SH 16
#define B_AX_WDE_Q3_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q3_MIN_SIZE_SH 0
#define B_AX_WDE_Q3_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA4_CFG 0x8C50
#define B_AX_WDE_Q4_MAX_SIZE_SH 16
#define B_AX_WDE_Q4_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q4_MIN_SIZE_SH 0
#define B_AX_WDE_Q4_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA5_CFG 0x8C54

#define R_AX_WDE_QTA6_CFG 0x8C58

#define R_AX_WDE_QTA7_CFG 0x8C5C

#define R_AX_WDE_QTA8_CFG 0x8C60

#define R_AX_WDE_QTA9_CFG 0x8C64

#define R_AX_WDE_QTA10_CFG 0x8C68

#define R_AX_WDE_QTA11_CFG 0x8C6C

#define R_AX_WDE_QTA12_CFG 0x8C70

#define R_AX_WDE_QTA13_CFG 0x8C74

#define R_AX_WDE_QTA14_CFG 0x8C78

#define R_AX_WDE_QTA15_CFG 0x8C7C

#define R_AX_WDE_INI_STATUS 0x8D00
#define B_AX_WDE_Q_MGN_INI_RDY BIT(1)
#define B_AX_WDE_BUF_MGN_INI_RDY BIT(0)

#define R_AX_WDE_WORD104 0x8D04

#define R_AX_WDE_WORD108 0x8D08

#define R_AX_WDE_WORD10C 0x8D0C

#define R_AX_WDE_DBG_FUN_INTF_CTL 0x8D10
#define B_AX_WDE_DFI_ACTIVE BIT(31)
#define B_AX_WDE_DFI_TRGSEL_SH 16
#define B_AX_WDE_DFI_TRGSEL_MSK 0xf
#define B_AX_WDE_DFI_ADDR_SH 0
#define B_AX_WDE_DFI_ADDR_MSK 0xffff

#define R_AX_WDE_DBG_FUN_INTF_DATA 0x8D14
#define B_AX_WDE_DFI_DATA_SH 0
#define B_AX_WDE_DFI_DATA_MSK 0xffffffffL

#define R_AX_WDE_DBG_CTL 0x8D18
#define B_AX_WDE_DBG1_SEL_SH 8
#define B_AX_WDE_DBG1_SEL_MSK 0xff
#define B_AX_WDE_DBG0_SEL_SH 0
#define B_AX_WDE_DBG0_SEL_MSK 0xff

#define R_AX_DBG_OUT 0x8D1C
#define B_AX_WDE_DBG1_OUT_SH 16
#define B_AX_WDE_DBG1_OUT_MSK 0xffff
#define B_AX_WDE_DBG0_OUT_SH 0
#define B_AX_WDE_DBG0_OUT_MSK 0xffff

#define R_AX_WDE_Q_STATUS_CFG 0x8D80
#define B_AX_WDE_Q_STATUS_SEL_SH 0
#define B_AX_WDE_Q_STATUS_SEL_MSK 0x7

#define R_AX_WDE_Q_STATUS_VAL 0x8D84
#define B_AX_WDE_Q_STATUS_VAL_SH 0
#define B_AX_WDE_Q_STATUS_VAL_MSK 0xffffffffL

//
// PLE_DLE
//

#define R_AX_PLE_WORD000 0x9000

#define R_AX_PLE_WORD004 0x9004

#define R_AX_PLE_PKTBUF_CFG 0x9008
#define B_AX_PLE_FREE_PAGE_NUM_SH 16
#define B_AX_PLE_FREE_PAGE_NUM_MSK 0x1fff
#define B_AX_PLE_START_BOUND_SH 8
#define B_AX_PLE_START_BOUND_MSK 0x3f
#define B_AX_PLE_PAGE_SEL_SH 0
#define B_AX_PLE_PAGE_SEL_MSK 0x3

#define R_AX_PLE_WORD00C 0x900C

#define R_AX_PLE_WORD010 0x9010

#define R_AX_PLE_WORD014 0x9014

#define R_AX_PLE_WORD018 0x9018

#define R_AX_PLE_WORD01C 0x901C

#define R_AX_PLE_WORD020 0x9020

#define R_AX_PLE_WORD024 0x9024

#define R_AX_PLE_WORD028 0x9028

#define R_AX_PLE_WORD02C 0x902C

#define R_AX_PLE_WORD030 0x9030

#define R_AX_PLE_ERR_FLAG_CFG_NUM1 0x9034
#define B_AX_PLE_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_PLE_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_AX_PLE_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_AX_PLE_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_AX_PLE_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_AX_PLE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_PLE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_PLE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_PLE_ERR_IMR 0x9038
#define B_AX_PLE_DATCHN_RRDY_ERR_INT_EN BIT(27)
#define B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_PLE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_AX_PLE_ERR_FLAG_ISR 0x903C
#define B_AX_PLE_DATCHN_RRDY_ERR BIT(27)
#define B_AX_PLE_DATCHN_FRZTO_ERR BIT(26)
#define B_AX_PLE_DATCHN_NULLPG_ERR BIT(25)
#define B_AX_PLE_DATCHN_ARBT_ERR BIT(24)
#define B_AX_PLE_QUEMGN_FRZTO_ERR BIT(19)
#define B_AX_PLE_NXTPKTLL_AD_ERR BIT(18)
#define B_AX_PLE_PREPKTLLT_AD_ERR BIT(17)
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_AX_PLE_QUE_SRCQUEID_ERR BIT(14)
#define B_AX_PLE_QUE_DSTQUEID_ERR BIT(13)
#define B_AX_PLE_QUE_CMDTYPE_ERR BIT(12)
#define B_AX_PLE_BUFMGN_FRZTO_ERR BIT(7)
#define B_AX_PLE_GETNPG_PGOFST_ERR BIT(6)
#define B_AX_PLE_GETNPG_STRPG_ERR BIT(5)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR BIT(4)
#define B_AX_PLE_BUFRTN_SIZE_ERR BIT(3)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR BIT(2)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR BIT(1)
#define B_AX_PLE_BUFREQ_QTAID_ERR BIT(0)

#define R_AX_PLE_QTA0_CFG 0x9040
#define B_AX_PLE_Q0_MAX_SIZE_SH 16
#define B_AX_PLE_Q0_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q0_MIN_SIZE_SH 0
#define B_AX_PLE_Q0_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA1_CFG 0x9044
#define B_AX_PLE_Q1_MAX_SIZE_SH 16
#define B_AX_PLE_Q1_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q1_MIN_SIZE_SH 0
#define B_AX_PLE_Q1_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA2_CFG 0x9048
#define B_AX_PLE_Q2_MAX_SIZE_SH 16
#define B_AX_PLE_Q2_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q2_MIN_SIZE_SH 0
#define B_AX_PLE_Q2_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA3_CFG 0x904C
#define B_AX_PLE_Q3_MAX_SIZE_SH 16
#define B_AX_PLE_Q3_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q3_MIN_SIZE_SH 0
#define B_AX_PLE_Q3_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA4_CFG 0x9050
#define B_AX_PLE_Q4_MAX_SIZE_SH 16
#define B_AX_PLE_Q4_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q4_MIN_SIZE_SH 0
#define B_AX_PLE_Q4_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA5_CFG 0x9054
#define B_AX_PLE_Q5_MAX_SIZE_SH 16
#define B_AX_PLE_Q5_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q5_MIN_SIZE_SH 0
#define B_AX_PLE_Q5_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA6_CFG 0x9058
#define B_AX_PLE_Q6_MAX_SIZE_SH 16
#define B_AX_PLE_Q6_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q6_MIN_SIZE_SH 0
#define B_AX_PLE_Q6_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA7_CFG 0x905C
#define B_AX_PLE_Q7_MAX_SIZE_SH 16
#define B_AX_PLE_Q7_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q7_MIN_SIZE_SH 0
#define B_AX_PLE_Q7_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA8_CFG 0x9060
#define B_AX_PLE_Q8_MAX_SIZE_SH 16
#define B_AX_PLE_Q8_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q8_MIN_SIZE_SH 0
#define B_AX_PLE_Q8_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA9_CFG 0x9064
#define B_AX_PLE_Q9_MAX_SIZE_SH 16
#define B_AX_PLE_Q9_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q9_MIN_SIZE_SH 0
#define B_AX_PLE_Q9_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA10_CFG 0x9068
#define B_AX_PLE_Q10_MAX_SIZE_SH 16
#define B_AX_PLE_Q10_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q10_MIN_SIZE_SH 0
#define B_AX_PLE_Q10_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA11_CFG 0x906C
#define B_AX_PLE_Q11_MAX_SIZE_SH 16
#define B_AX_PLE_Q11_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q11_MIN_SIZE_SH 0
#define B_AX_PLE_Q11_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA12_CFG 0x9070
#define B_AX_PLE_Q12_MAX_SIZE_SH 16
#define B_AX_PLE_Q12_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q12_MIN_SIZE_SH 0
#define B_AX_PLE_Q12_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA13_CFG 0x9074
#define B_AX_PLE_Q13_MAX_SIZE_SH 16
#define B_AX_PLE_Q13_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q13_MIN_SIZE_SH 0
#define B_AX_PLE_Q13_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA14_CFG 0x9078
#define B_AX_PLE_Q14_MAX_SIZE_SH 16
#define B_AX_PLE_Q14_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q14_MIN_SIZE_SH 0
#define B_AX_PLE_Q14_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA15_CFG 0x907C
#define B_AX_PLE_Q15_MAX_SIZE_SH 16
#define B_AX_PLE_Q15_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q15_MIN_SIZE_SH 0
#define B_AX_PLE_Q15_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_WORD080 0x9080

#define R_AX_PLE_WORD084 0x9084

#define R_AX_PLE_WORD088 0x9088

#define R_AX_PLE_WORD08C 0x908C

#define R_AX_PLE_WORD090 0x9090

#define R_AX_PLE_WORD094 0x9094

#define R_AX_PLE_WORD098 0x9098

#define R_AX_PLE_WORD09C 0x909C

#define R_AX_PLE_WORD0A0 0x90A0

#define R_AX_PLE_WORD0A4 0x90A4

#define R_AX_PLE_WORD0A8 0x90A8

#define R_AX_PLE_WORD0AC 0x90AC

#define R_AX_PLE_WORD0B0 0x90B0

#define R_AX_PLE_WORD0B4 0x90B4

#define R_AX_PLE_WORD0B8 0x90B8

#define R_AX_PLE_WORD0BC 0x90BC

#define R_AX_PLE_WORD0C0 0x90C0

#define R_AX_PLE_WORD0C4 0x90C4

#define R_AX_PLE_WORD0C8 0x90C8

#define R_AX_PLE_WORD0CC 0x90CC

#define R_AX_PLE_WORD0D0 0x90D0

#define R_AX_PLE_WORD0D4 0x90D4

#define R_AX_PLE_WORD0D8 0x90D8

#define R_AX_PLE_WORD0DC 0x90DC

#define R_AX_PLE_WORD0E0 0x90E0

#define R_AX_PLE_WORD0E4 0x90E4

#define R_AX_PLE_WORD0E8 0x90E8

#define R_AX_PLE_WORD0EC 0x90EC

#define R_AX_PLE_WORD0F0 0x90F0

#define R_AX_PLE_WORD0F4 0x90F4

#define R_AX_PLE_WORD0F8 0x90F8

#define R_AX_PLE_WORD0FC 0x90FC

#define R_AX_PLE_INI_STATUS 0x9100
#define B_AX_PLE_Q_MGN_INI_RDY BIT(1)
#define B_AX_PLE_BUF_MGN_INI_RDY BIT(0)

#define R_AX_PLE_WORD104 0x9104

#define R_AX_PLE_WORD108 0x9108

#define R_AX_PLE_WORD10C 0x910C

#define R_AX_PLE_DBG_FUN_INTF_CTL 0x9110
#define B_AX_PLE_DFI_ACTIVE BIT(31)
#define B_AX_PLE_DFI_TRGSEL_SH 16
#define B_AX_PLE_DFI_TRGSEL_MSK 0xf
#define B_AX_PLE_DFI_ADDR_SH 0
#define B_AX_PLE_DFI_ADDR_MSK 0xffff

#define R_AX_PLE_DBG_FUN_INTF_DATA 0x9114
#define B_AX_PLE_DFI_DATA_SH 0
#define B_AX_PLE_DFI_DATA_MSK 0xffffffffL

#define R_AX_PLE_DBG_CTL 0x9118
#define B_AX_PLE_DBG1_SEL_SH 8
#define B_AX_PLE_DBG1_SEL_MSK 0xff
#define B_AX_PLE_DBG0_SEL_SH 0
#define B_AX_PLE_DBG0_SEL_MSK 0xff

#define R_AX_PLE_DBG_OUT 0x911C
#define B_AX_PLE_DBG1_OUT_SH 16
#define B_AX_PLE_DBG1_OUT_MSK 0xffff
#define B_AX_PLE_DBG0_OUT_SH 0
#define B_AX_PLE_DBG0_OUT_MSK 0xffff

#define R_AX_PLE_WORD120 0x9120

#define R_AX_PLE_WORD124 0x9124

#define R_AX_PLE_WORD128 0x9128

#define R_AX_PLE_WORD12C 0x912C

#define R_AX_PLE_WORD130 0x9130

#define R_AX_PLE_WORD134 0x9134

#define R_AX_PLE_WORD138 0x9138

#define R_AX_PLE_WORD13C 0x913C

#define R_AX_PLE_WORD140 0x9140

#define R_AX_PLE_WORD144 0x9144

#define R_AX_PLE_WORD148 0x9148

#define R_AX_PLE_WORD14C 0x914C

#define R_AX_PLE_WORD150 0x9150

#define R_AX_PLE_WORD154 0x9154

#define R_AX_PLE_WORD158 0x9158

#define R_AX_PLE_WORD15C 0x915C

#define R_AX_PLE_WORD160 0x9160

#define R_AX_PLE_WORD164 0x9164

#define R_AX_PLE_WORD168 0x9168

#define R_AX_PLE_WORD16C 0x916C

#define R_AX_PLE_WORD170 0x9170

#define R_AX_PLE_WORD174 0x9174

#define R_AX_PLE_WORD178 0x9178

#define R_AX_PLE_WORD17C 0x917C

#define R_AX_PLE_WORD180 0x9180

#define R_AX_PLE_WORD184 0x9184

#define R_AX_PLE_WORD188 0x9188

#define R_AX_PLE_WORD18C 0x918C

#define R_AX_PLE_WORD190 0x9190

#define R_AX_PLE_WORD194 0x9194

#define R_AX_PLE_WORD198 0x9198

#define R_AX_PLE_WORD19C 0x919C

#define R_AX_PLE_WORD1A0 0x91A0

#define R_AX_PLE_WORD1A4 0x91A4

#define R_AX_PLE_WORD1A8 0x91A8

#define R_AX_PLE_WORD1AC 0x91AC

#define R_AX_PLE_WORD1B0 0x91B0

#define R_AX_PLE_WORD1B4 0x91B4

#define R_AX_PLE_WORD1B8 0x91B8

#define R_AX_PLE_WORD1BC 0x91BC

#define R_AX_PLE_WORD1C0 0x91C0

#define R_AX_PLE_WORD1C4 0x91C4

#define R_AX_PLE_WORD1C8 0x91C8

#define R_AX_PLE_WORD1CC 0x91CC

#define R_AX_PLE_WORD1D0 0x91D0

#define R_AX_PLE_WORD1D4 0x91D4

#define R_AX_PLE_WORD1D8 0x91D8

#define R_AX_PLE_WORD1DC 0x91DC

#define R_AX_PLE_WORD1E0 0x91E0

#define R_AX_PLE_WORD1E4 0x91E4

#define R_AX_PLE_WORD1E8 0x91E8

#define R_AX_PLE_WORD1EC 0x91EC

#define R_AX_PLE_WORD1F0 0x91F0

#define R_AX_PLE_WORD1F4 0x91F4

#define R_AX_PLE_WORD1F8 0x91F8

#define R_AX_PLE_WORD1FC 0x91FC

//
// WDRLS
//

#define R_AX_WDRLS_WORD000 0x9400

#define R_AX_WDRLS_WORD004 0x9404

#define R_AX_WDRLS_CFG 0x9408
#define B_AX_RLSRPT_BUFREQ_TO_SH 8
#define B_AX_RLSRPT_BUFREQ_TO_MSK 0xff
#define B_AX_WDRLS_MODE_SH 0
#define B_AX_WDRLS_MODE_MSK 0x3

#define R_AX_WDRLS_WORD00C 0x940C

#define R_AX_RLSRPT0_CFG0 0x9410
#define B_AX_RLSRPT0_FLTR_MAP_SH 24
#define B_AX_RLSRPT0_FLTR_MAP_MSK 0xf
#define B_AX_RLSRPT0_PKTTYPE_SH 16
#define B_AX_RLSRPT0_PKTTYPE_MSK 0xf
#define B_AX_RLSRPT0_PID_SH 8
#define B_AX_RLSRPT0_PID_MSK 0x7
#define B_AX_RLSRPT0_QID_SH 0
#define B_AX_RLSRPT0_QID_MSK 0x3f

#define R_AX_RLSRPT0_CFG1 0x9414
#define B_AX_RLSRPT0_TO_SH 16
#define B_AX_RLSRPT0_TO_MSK 0xff
#define B_AX_RLSRPT0_AGGNUM_SH 0
#define B_AX_RLSRPT0_AGGNUM_MSK 0xff

#define R_AX_WDRLS_WORD018 0x9418

#define R_AX_WDRLS_WORD01C 0x941C

#define R_AX_RLSRPT1_CFG0 0x9420
#define B_AX_RLSRPT1_FLTR_MAP_SH 24
#define B_AX_RLSRPT1_FLTR_MAP_MSK 0xf
#define B_AX_RLSRPT1_PKTTYPE_SH 16
#define B_AX_RLSRPT1_PKTTYPE_MSK 0xf
#define B_AX_RLSRPT1_PID_SH 8
#define B_AX_RLSRPT1_PID_MSK 0x7
#define B_AX_RLSRPT1_QID_SH 0
#define B_AX_RLSRPT1_QID_MSK 0x3f

#define R_AX_RLSRPT1_CFG1 0x9424
#define B_AX_RLSRPT1_TO_SH 16
#define B_AX_RLSRPT1_TO_MSK 0xff
#define B_AX_RLSRPT1_AGGNUM_SH 0
#define B_AX_RLSRPT1_AGGNUM_MSK 0xff

#define R_AX_WDRLS_WORD028 0x9428

#define R_AX_WDRLS_WORD02C 0x942C

#define R_AX_WDRLS_ERR_IMR 0x9430
#define B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN BIT(13)
#define B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN BIT(12)
#define B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN BIT(8)
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN BIT(5)
#define B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN BIT(4)
#define B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN BIT(2)
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN BIT(0)

#define R_AX_WDRLS_ERR_ISR 0x9434
#define B_AX_WDRLS_RPT1_FRZTO_ERR BIT(13)
#define B_AX_WDRLS_RPT1_AGGNUM_ERR BIT(12)
#define B_AX_WDRLS_RPT0_FRZTO_ERR BIT(9)
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR BIT(8)
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR BIT(5)
#define B_AX_WDRLS_PLEBREQ_TO_ERR BIT(4)
#define B_AX_WDRLS_CTL_FRZTO_ERR BIT(2)
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR BIT(1)
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR BIT(0)

#define R_AX_DBG_CTL_WDRLS 0x9438
#define B_AX_DBG1_SEL_SH 8
#define B_AX_DBG1_SEL_MSK 0xff
#define B_AX_DBG0_SEL_SH 0
#define B_AX_DBG0_SEL_MSK 0xff

#define R_AX_DBG_OUT_WDRLS 0x943C
#define B_AX_DBG1_OUT_SH 16
#define B_AX_DBG1_OUT_MSK 0xffff
#define B_AX_DBG0_OUT_SH 0
#define B_AX_DBG0_OUT_MSK 0xffff

#define R_AX_WDRLS_WORD040 0x9440

#define R_AX_WDRLS_WORD044 0x9444

#define R_AX_WDRLS_WORD048 0x9448

#define R_AX_WDRLS_WORD04C 0x944C

#define R_AX_WDRLS_WORD050 0x9450

#define R_AX_WDRLS_WORD054 0x9454

#define R_AX_WDRLS_WORD058 0x9458

#define R_AX_WDRLS_WORD05C 0x945C

#define R_AX_WDRLS_WORD060 0x9460

#define R_AX_WDRLS_WORD064 0x9464

#define R_AX_WDRLS_WORD068 0x9468

#define R_AX_WDRLS_WORD06C 0x946C

#define R_AX_WDRLS_WORD070 0x9470

#define R_AX_WDRLS_WORD074 0x9474

#define R_AX_WDRLS_WORD078 0x9478

#define R_AX_WDRLS_WORD07C 0x947C

//
// BBRPT
//

#define R_AX_COM_CFG 0x9600
#define B_AX_1US_CYCNUM_SEL_SH 16
#define B_AX_1US_CYCNUM_SEL_MSK 0x3
#define B_AX_DIS_ACGC_DMA_RPTGEN BIT(1)
#define B_AX_DIS_ACGC_DMA_PHYIF BIT(0)

#define R_AX_BBRPT_COEX_CFG 0x9604
#define B_AX_DFS_THR_SH 8
#define B_AX_DFS_THR_MSK 0xf
#define B_AX_BBRPT_COEX_EN BIT(0)

#define R_AX_BBRPT_WORD008 0x9608

#define R_AX_BBRPT_COM_ERR_IMR_ISR 0x960C
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR BIT(16)
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_WORD010 0x9610

#define R_AX_BBRPT_WORD014 0x9614

#define R_AX_BBRPT_WORD018 0x9618

#define R_AX_BBRPT_WORD01C 0x961C

#define R_AX_CH_INFO 0x9620
#define B_AX_CH_INFO_QID_SH 24
#define B_AX_CH_INFO_QID_MSK 0x3f
#define B_AX_CH_INFO_PRTID_SH 20
#define B_AX_CH_INFO_PRTID_MSK 0x7
#define B_AX_CH_INFO_REQ_SH 18
#define B_AX_CH_INFO_REQ_MSK 0x3
#define B_AX_CH_INFO_SEG_SH 16
#define B_AX_CH_INFO_SEG_MSK 0x3
#define B_AX_CH_INFO_INTVL_SH 12
#define B_AX_CH_INFO_INTVL_MSK 0xf
#define B_AX_GET_CH_INFO_TO_SH 9
#define B_AX_GET_CH_INFO_TO_MSK 0x7
#define B_AX_CH_INFO_PHY BIT(8)
#define B_AX_CH_INFO_BUF_SH 6
#define B_AX_CH_INFO_BUF_MSK 0x3
#define B_AX_CH_INFO_STOP BIT(5)
#define B_AX_CH_INFO_STOP_REQ BIT(4)
#define B_AX_CH_INFO_ON BIT(3)
#define B_AX_CH_INFO_EN BIT(0)

#define R_AX_BBRPT_WORD024 0x9624

#define R_AX_BBRPT_WORD028 0x9628

#define R_AX_BBRPT_CHINFO_ERR_IMR_ISR 0x962C
#define B_AX_BBPRT_CHIF_TO_ERR BIT(23)
#define B_AX_BBPRT_CHIF_NULL_ERR BIT(22)
#define B_AX_BBPRT_CHIF_LEFT2_ERR BIT(21)
#define B_AX_BBPRT_CHIF_LEFT1_ERR BIT(20)
#define B_AX_BBPRT_CHIF_HDRL_ERR BIT(19)
#define B_AX_BBPRT_CHIF_BOVF_ERR BIT(18)
#define B_AX_BBPRT_CHIF_OVF_ERR BIT(17)
#define B_AX_BBPRT_CHIF_BB_TO_ERR BIT(16)
#define B_AX_BBPRT_CHIF_TO_ERR_INT_EN BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_INT_EN BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_INT_EN BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN BIT(0)

#define R_AX_DFS_CFG0 0x9630
#define B_AX_DFS_QID_SH 24
#define B_AX_DFS_QID_MSK 0x3f
#define B_AX_DFS_PRTID_SH 20
#define B_AX_DFS_PRTID_MSK 0x7
#define B_AX_DFS_TIME_TH_SH 10
#define B_AX_DFS_TIME_TH_MSK 0x3
#define B_AX_DFS_NUM_TH_SH 8
#define B_AX_DFS_NUM_TH_MSK 0x3
#define B_AX_DFS_BUF_SH 6
#define B_AX_DFS_BUF_MSK 0x3
#define B_AX_DFS_IN_STOP BIT(5)
#define B_AX_STOP_DFS BIT(4)
#define B_AX_DFS_RPT_EN BIT(0)

#define R_AX_BBRPT_WORD034 0x9634

#define R_AX_BBRPT_WORD038 0x9638

#define R_AX_BBRPT_DFS_ERR_IMR_ISR 0x963C
#define B_AX_BBRPT_DFS_TO_ERR BIT(16)
#define B_AX_BBRPT_DFS_TO_ERR_INT_EN BIT(0)

#define R_AX_BBRPT_WORD040 0x9640

#define R_AX_BBRPT_WORD044 0x9644

#define R_AX_BBRPT_WORD048 0x9648

#define R_AX_BBRPT_WORD04C 0x964C

#define R_AX_BBRPT_WORD050 0x9650

#define R_AX_BBRPT_WORD054 0x9654

#define R_AX_BBRPT_WORD058 0x9658

#define R_AX_BBRPT_WORD05C 0x965C

#define R_AX_LA_CFG 0x9660
#define B_AX_LA_TRIG_TIME_VAL_SH 24
#define B_AX_LA_TRIG_TIME_VAL_MSK 0x7f
#define B_AX_LA_TRIG_TU_SEL_SH 20
#define B_AX_LA_TRIG_TU_SEL_MSK 0xf
#define B_AX_LA_BUF_SEL_SH 16
#define B_AX_LA_BUF_SEL_MSK 0xf
#define B_AX_LA_BUF_BNDY_SH 8
#define B_AX_LA_BUF_BNDY_MSK 0x3f
#define B_AX_LA_TO_VAL_SH 6
#define B_AX_LA_TO_VAL_MSK 0x3
#define B_AX_LA_TO_EN BIT(5)
#define B_AX_LA_RESTART_EN BIT(4)
#define B_AX_LA_TRIG_START BIT(3)
#define B_AX_LA_FEN BIT(0)

#define R_AX_LA_STATUS 0x9664
#define B_AX_LA_SW_FSMST_SH 17
#define B_AX_LA_SW_FSMST_MSK 0x7
#define B_AX_LA_BUF_RNDUP BIT(16)
#define B_AX_LA_BUF_WPTR_SH 0
#define B_AX_LA_BUF_WPTR_MSK 0xffff

#define R_AX_BBRPT_WORD068 0x9668

#define R_AX_LA_ERRFLAG 0x966C
#define B_AX_LA_ISR_DATA_LOSS_ERR BIT(16)
#define B_AX_LA_IMR_DATA_LOSS_ERR BIT(0)

#define R_AX_BBRPT_WORD070 0x9670

#define R_AX_BBRPT_WORD074 0x9674

#define R_AX_BBRPT_WORD078 0x9678

#define R_AX_BBRPT_WORD07C 0x967C

#define R_AX_DBG_CTL_BBRPT 0x9680

#define R_AX_DBG_OUT_BBRPT 0x9684

#define R_AX_BBRPT_WORD088 0x9688

#define R_AX_BBRPT_WORD08C 0x968C

#define R_AX_BBRPT_WORD090 0x9690

#define R_AX_BBRPT_WORD094 0x9694

#define R_AX_BBRPT_WORD098 0x9698

#define R_AX_BBRPT_WORD09C 0x969C

#define R_AX_BBRPT_WORD0A0 0x96A0

#define R_AX_BBRPT_WORD0A4 0x96A4

#define R_AX_BBRPT_WORD0A8 0x96A8

#define R_AX_BBRPT_WORD0AC 0x96AC

#define R_AX_BBRPT_WORD0B0 0x96B0

#define R_AX_BBRPT_WORD0B4 0x96B4

#define R_AX_BBRPT_WORD0B8 0x96B8

#define R_AX_BBRPT_WORD0BC 0x96BC

#define R_AX_BBRPT_WORD0C0 0x96C0

#define R_AX_BBRPT_WORD0C4 0x96C4

#define R_AX_BBRPT_WORD0C8 0x96C8

#define R_AX_BBRPT_WORD0CC 0x96CC

#define R_AX_BBRPT_WORD0D0 0x96D0

#define R_AX_BBRPT_WORD0D4 0x96D4

#define R_AX_BBRPT_WORD0D8 0x96D8

#define R_AX_BBRPT_WORD0DC 0x96DC

#define R_AX_BBRPT_WORD0E0 0x96E0

#define R_AX_BBRPT_WORD0E4 0x96E4

#define R_AX_BBRPT_WORD0E8 0x96E8

#define R_AX_BBRPT_WORD0EC 0x96EC

#define R_AX_BBRPT_WORD0F0 0x96F0

#define R_AX_BBRPT_WORD0F4 0x96F4

#define R_AX_BBRPT_WORD0F8 0x96F8

#define R_AX_BBRPT_WORD0FC 0x96FC

//
// CPUIO
//

#define R_AX_WD_BUF_REQ 0x9800
#define B_AX_WD_BUF_REQ_EXEC BIT(31)
#define B_AX_WD_BUF_REQ_QUOTA_ID_SH 16
#define B_AX_WD_BUF_REQ_QUOTA_ID_MSK 0xff
#define B_AX_WD_BUF_REQ_LEN_SH 0
#define B_AX_WD_BUF_REQ_LEN_MSK 0xffff

#define R_AX_WD_BUF_STATUS 0x9804
#define B_AX_WD_BUF_STAT_DONE BIT(31)
#define B_AX_WD_BUF_STAT_PKTID_SH 0
#define B_AX_WD_BUF_STAT_PKTID_MSK 0xfff

#define R_AX_WD_QUOTA_STATUS 0x9808

#define R_AX_CPUIO_WORD00C 0x980C

#define R_AX_WD_CPUQ_OP_0 0x9810
#define B_AX_WD_CPUQ_OP_EXEC BIT(31)
#define B_AX_WD_CPUQ_OP_CMD_TYPE_SH 24
#define B_AX_WD_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_AX_WD_CPUQ_OP_MACID_SH 16
#define B_AX_WD_CPUQ_OP_MACID_MSK 0xff
#define B_AX_WD_CPUQ_OP_PKTNUM_SH 0
#define B_AX_WD_CPUQ_OP_PKTNUM_MSK 0xff

#define R_AX_WD_CPUQ_OP_1 0x9814
#define B_AX_WD_CPUQ_OP_SRC_PID_SH 22
#define B_AX_WD_CPUQ_OP_SRC_PID_MSK 0x7
#define B_AX_WD_CPUQ_OP_SRC_QID_SH 16
#define B_AX_WD_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_AX_WD_CPUQ_OP_DST_PID_SH 6
#define B_AX_WD_CPUQ_OP_DST_PID_MSK 0x7
#define B_AX_WD_CPUQ_OP_DST_QID_SH 0
#define B_AX_WD_CPUQ_OP_DST_QID_MSK 0x3f

#define R_AX_WD_CPUQ_OP_2 0x9818
#define B_AX_WD_CPUQ_OP_STRT_PKTID_SH 16
#define B_AX_WD_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_AX_WD_CPUQ_OP_END_PKTID_SH 0
#define B_AX_WD_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_AX_WD_CPUQ_OP_STATUS 0x981C
#define B_AX_WD_CPUQ_OP_STAT_DONE BIT(31)
#define B_AX_WD_CPUQ_OP_PKTID_SH 0
#define B_AX_WD_CPUQ_OP_PKTID_MSK 0xfff

#define R_AX_PL_BUF_REQ 0x9820
#define B_AX_PL_BUF_REQ_EXEC BIT(31)
#define B_AX_PL_BUF_REQ_QUOTA_ID_SH 16
#define B_AX_PL_BUF_REQ_QUOTA_ID_MSK 0xf
#define B_AX_PL_BUF_REQ_LEN_SH 0
#define B_AX_PL_BUF_REQ_LEN_MSK 0xffff

#define R_AX_PL_BUF_STATUS 0x9824
#define B_AX_PL_BUF_STAT_DONE BIT(31)
#define B_AX_PL_BUF_STAT_PKTID_SH 0
#define B_AX_PL_BUF_STAT_PKTID_MSK 0xfff

#define R_AX_PL_QUOTA_STATUS 0x9828

#define R_AX_CPUIO_WORD02C 0x982C

#define R_AX_PL_CPUQ_OP_0 0x9830
#define B_AX_PL_CPUQ_OP_EXEC BIT(31)
#define B_AX_PL_CPUQ_OP_CMD_TYPE_SH 24
#define B_AX_PL_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_AX_PL_CPUQ_OP_MACID_SH 16
#define B_AX_PL_CPUQ_OP_MACID_MSK 0xff
#define B_AX_PL_CPUQ_OP_PKTNUM_SH 0
#define B_AX_PL_CPUQ_OP_PKTNUM_MSK 0xff

#define R_AX_PL_CPUQ_OP_1 0x9834
#define B_AX_PL_CPUQ_OP_SRC_PID_SH 22
#define B_AX_PL_CPUQ_OP_SRC_PID_MSK 0x7
#define B_AX_PL_CPUQ_OP_SRC_QID_SH 16
#define B_AX_PL_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_AX_PL_CPUQ_OP_DST_PID_SH 6
#define B_AX_PL_CPUQ_OP_DST_PID_MSK 0x7
#define B_AX_PL_CPUQ_OP_DST_QID_SH 0
#define B_AX_PL_CPUQ_OP_DST_QID_MSK 0x3f

#define R_AX_PL_CPUQ_OP_2 0x9838
#define B_AX_PL_CPUQ_OP_STRT_PKTID_SH 16
#define B_AX_PL_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_AX_PL_CPUQ_OP_END_PKTID_SH 0
#define B_AX_PL_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_AX_PL_CPUQ_OP_STATUS 0x983C
#define B_AX_PL_CPUQ_OP_STAT_DONE BIT(31)
#define B_AX_PL_CPUQ_OP_PKTID_SH 0
#define B_AX_PL_CPUQ_OP_PKTID_MSK 0xfff

#define R_AX_CPUIO_ERR_IMR 0x9840
#define B_AX_PLEQUE_OP_ERR_INT_EN BIT(12)
#define B_AX_PLEBUF_OP_ERR_INT_EN BIT(8)
#define B_AX_WDEQUE_OP_ERR_INT_EN BIT(4)
#define B_AX_WDEBUF_OP_ERR_INT_EN BIT(0)

#define R_AX_CPUIO_ERR_ISR 0x9844
#define B_AX_PLEQUE_OP_ERR BIT(12)
#define B_AX_PLEBUF_OP_ERR BIT(8)
#define B_AX_ERR_WDEQUE_OP_ERR BIT(4)
#define B_AX_ERR_WDEBUF_OP_ERR BIT(0)

#define R_AX_CPUIO_WORD048 0x9848

#define R_AX_CPUIO_WORD04C 0x984C

#define R_AX_CPUIO_WORD050 0x9850

#define R_AX_CPUIO_WORD054 0x9854

#define R_AX_CPUIO_WORD058 0x9858

#define R_AX_CPUIO_WORD05C 0x985C

#define R_AX_CPUIO_WORD060 0x9860

#define R_AX_CPUIO_WORD064 0x9864

#define R_AX_CPUIO_WORD068 0x9868

#define R_AX_CPUIO_WORD06C 0x986C

#define R_AX_CPUIO_WORD070 0x9870

#define R_AX_CPUIO_WORD074 0x9874

#define R_AX_CPUIO_WORD078 0x9878

#define R_AX_CPUIO_WORD07C 0x987C

//
// PKTIN
//

#define R_AX_PKTIN_SETTING 0x9A00
#define B_AX_WD_ADDR_INFO_LENGTH BIT(1)
#define B_AX_PKTIN_CLK_GATING_DIS BIT(0)

#define R_AX_HWAMSDU_CTRL 0x9A04
#define B_AX_MAX_AMSDU_NUM_SH 3
#define B_AX_MAX_AMSDU_NUM_MSK 0x3
#define B_AX_SINGLE_AMSDU BIT(2)
#define B_AX_HWAMSDU_EN BIT(0)

#define R_AX_HWAMSDU_STATUS 0x9A08
#define B_AX_AMSDU_PKT_SIZE_ERR BIT(31)
#define B_AX_AMSDU_EN_ERR BIT(30)
#define B_AX_AMSDU_ADDR_INFO_ERR BIT(29)

#define R_AX_HW_SEQ_0_1 0x9A0C
#define B_AX_HW_SEQ1_SH 16
#define B_AX_HW_SEQ1_MSK 0xfff
#define B_AX_HW_SEQ0_SH 0
#define B_AX_HW_SEQ0_MSK 0xfff

#define R_AX_HW_SEQ_2_3 0x9A10
#define B_AX_HW_SEQ3_SH 16
#define B_AX_HW_SEQ3_MSK 0xfff
#define B_AX_HW_SEQ2_SH 0
#define B_AX_HW_SEQ2_MSK 0xfff

#define R_AX_TXPKTIN_CTRL 0x9A14
#define B_AX_C1P4_TXPKTIN_STS BIT(25)
#define B_AX_C1P3_TXPKTIN_STS BIT(24)
#define B_AX_C1P2_TXPKTIN_STS BIT(23)
#define B_AX_C1P1_TXPKTIN_STS BIT(22)
#define B_AX_C1P0_TXPKTIN_STS BIT(21)
#define B_AX_C0P4_TXPKTIN_STS BIT(20)
#define B_AX_C0P3_TXPKTIN_STS BIT(19)
#define B_AX_C0P2_TXPKTIN_STS BIT(18)
#define B_AX_C0P1_TXPKTIN_STS BIT(17)
#define B_AX_C0P0_TXPKTIN_STS BIT(16)
#define B_AX_TXPKTIN_CTRL_EN BIT(15)
#define B_AX_C1P4_TXPKTIN_EN BIT(9)
#define B_AX_C1P3_TXPKTIN_EN BIT(8)
#define B_AX_C1P2_TXPKTIN_EN BIT(7)
#define B_AX_C1P1_TXPKTIN_EN BIT(6)
#define B_AX_C1P0_TXPKTIN_EN BIT(5)
#define B_AX_C0P4_TXPKTIN_EN BIT(4)
#define B_AX_C0P3_TXPKTIN_EN BIT(3)
#define B_AX_C0P2_TXPKTIN_EN BIT(2)
#define B_AX_C0P1_TXPKTIN_EN BIT(1)
#define B_AX_C0P0_TXPKTIN_EN BIT(0)

#define R_AX_TXPKTIN_DBG_SEL 0x9A18
#define B_AX_TXPKTIN_DBG_SEL_SH 0
#define B_AX_TXPKTIN_DBG_SEL_MSK 0xf

#define R_AX_DBG_DATA 0x9A1C
#define B_AX_PRE_DBG_DMAC_PKTIN_SH 0
#define B_AX_PRE_DBG_DMAC_PKTIN_MSK 0xffffffffL

#define R_AX_PKTIN_ERR_IMR 0x9A20
#define B_AX_PKTIN_GETPKTID_ERR_INT_EN BIT(0)

#define R_AX_PKTIN_ERR_ISR 0x9A24
#define B_AX_PKTIN_GETPKTID_ERR_INT BIT(0)

//
// MPDU_Processor_1
//

#define R_AX_HDR_SHCUT_SETTING 0x9B00
#define B_AX_MAC_MPDU_PROC_EN BIT(2)
#define B_AX_SHCUT_LLC_WR_LOCK BIT(1)
#define B_AX_SHCUT_PARSE_DASA BIT(0)

#define R_AX_SHCUT_LLC_ETH_TYPE0 0x9B04
#define B_AX_SHUT_ETH_TYPE1_SH 16
#define B_AX_SHUT_ETH_TYPE1_MSK 0xffff
#define B_AX_SHUT_ETH_TYPE0_SH 0
#define B_AX_SHUT_ETH_TYPE0_MSK 0xffff

#define R_AX_SHCUT_LLC_ETH_TYPE1 0x9B08
#define B_AX_SHUT_ETH_TYPE2_SH 0
#define B_AX_SHUT_ETH_TYPE2_MSK 0xffff

#define R_AX_SHCUT_LLC_OUI0 0x9B0C
#define B_AX_SHUT_ENABLE_OUI0 BIT(24)
#define B_AX_SHUT_ETH_OUI0_SH 0
#define B_AX_SHUT_ETH_OUI0_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI1 0x9B10
#define B_AX_SHUT_ENABLE_OUI1 BIT(24)
#define B_AX_SHUT_ETH_OUI1_SH 0
#define B_AX_SHUT_ETH_OUI1_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI2 0x9B14
#define B_AX_SHUT_ENABLE_OUI2 BIT(24)
#define B_AX_SHUT_ETH_OUI2_SH 0
#define B_AX_SHUT_ETH_OUI2_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI3 0x9B18
#define B_AX_SHUT_ENABLE_OUI3 BIT(24)
#define B_AX_SHUT_ETH_OUI3_SH 0
#define B_AX_SHUT_ETH_OUI3_MSK 0xffffff

#define R_AX_TX_PTK_CNT 0x9BEC
#define B_AX_TX_PTKOUT_CNT_SH 16
#define B_AX_TX_PTKOUT_CNT_MSK 0xffff
#define B_AX_TX_PKTIN_CNT_SH 0
#define B_AX_TX_PKTIN_CNT_MSK 0xffff

#define R_AX_MPDU_TX_ERR_ISR 0x9BF0
#define B_AX_TX_HDR3_SIZE_ERR BIT(5)
#define B_AX_TX_OFFSET_ERR BIT(4)
#define B_AX_TX_MPDU_SIZE_ZERO_ERR BIT(3)
#define B_AX_TX_NXT_ERRPKTID_ERR BIT(2)
#define B_AX_TX_GET_ERRPKTID_ERR BIT(1)

#define R_AX_MPDU_TX_ERR_IMR 0x9BF4
#define B_AX_TX_HDR3_SIZE_ERR_INT_EN BIT(5)
#define B_AX_TX_OFFSET_ERR_INT_EN BIT(4)
#define B_AX_TX_MPDU_SIZE_ZERO_INT_EN BIT(3)
#define B_AX_TX_NXT_ERRPKTID_INT_EN BIT(2)
#define B_AX_TX_GET_ERRPKTID_INT_EN BIT(1)

#define R_AX_MPDU_TX_DBG 0x9BFC
#define B_AX_MPDU_TX_DBGEN BIT(8)
#define B_AX_MPDU_TX_DLAST BIT(0)

//
// MPDU_Processor_2
//

#define R_AX_MPDU_PROC 0x9C00
#define B_AX_A_ICV_ERR BIT(1)
#define B_AX_APPEND_FCS BIT(0)

#define R_AX_ACTION_FWD0 0x9C04
#define B_AX_FWD_VHT_CBFM_SH 24
#define B_AX_FWD_VHT_CBFM_MSK 0x3
#define B_AX_FWD_HT_CBFM_SH 22
#define B_AX_FWD_HT_CBFM_MSK 0x3
#define B_AX_FWD_CSI_SH 20
#define B_AX_FWD_CSI_MSK 0x3
#define B_AX_FWD_OP_MODE_SH 18
#define B_AX_FWD_OP_MODE_MSK 0x3
#define B_AX_FWD_GID_MGNT_SH 16
#define B_AX_FWD_GID_MGNT_MSK 0x3
#define B_AX_FWD_NCW_SH 14
#define B_AX_FWD_NCW_MSK 0x3
#define B_AX_FWD_DELBA_SH 12
#define B_AX_FWD_DELBA_MSK 0x3
#define B_AX_FWD_ADDBA_RES_SH 10
#define B_AX_FWD_ADDBA_RES_MSK 0x3
#define B_AX_FWD_ADDBA_REQ_SH 8
#define B_AX_FWD_ADDBA_REQ_MSK 0x3
#define B_AX_FWD_DELTS_SH 6
#define B_AX_FWD_DELTS_MSK 0x3
#define B_AX_FWD_ADDTS_RES_SH 4
#define B_AX_FWD_ADDTS_RES_MSK 0x3
#define B_AX_FWD_ADDTS_REQ_SH 2
#define B_AX_FWD_ADDTS_REQ_MSK 0x3
#define B_AX_FWD_CSA_SH 0
#define B_AX_FWD_CSA_MSK 0x3

#define R_AX_ACTION_FWD1 0x9C08
#define B_AX_FWD_ACTN_CTRL3_SH 6
#define B_AX_FWD_ACTN_CTRL3_MSK 0x3
#define B_AX_FWD_ACTN_CTRL2_SH 4
#define B_AX_FWD_ACTN_CTRL2_MSK 0x3
#define B_AX_FWD_ACTN_CTRL1_SH 2
#define B_AX_FWD_ACTN_CTRL1_MSK 0x3
#define B_AX_FWD_ACTN_CTRL0_SH 0
#define B_AX_FWD_ACTN_CTRL0_MSK 0x3

#define R_AX_ACTION_FWD_CTRL0 0x9C0C
#define B_AX_FWD_ACTN_ACTN0_SH 8
#define B_AX_FWD_ACTN_ACTN0_MSK 0xff
#define B_AX_FWD_ACTN_CAT0_SH 0
#define B_AX_FWD_ACTN_CAT0_MSK 0xff

#define R_AX_ACTION_FWD_CTRL1 0x9C0E
#define B_AX_FWD_ACTN_ACTN1_SH 8
#define B_AX_FWD_ACTN_ACTN1_MSK 0xff
#define B_AX_FWD_ACTN_CAT1_SH 0
#define B_AX_FWD_ACTN_CAT1_MSK 0xff

#define R_AX_ACTION_FWD_CTRL2 0x9C10
#define B_AX_FWD_ACTN_ACTN2_SH 8
#define B_AX_FWD_ACTN_ACTN2_MSK 0xff
#define B_AX_FWD_ACTN_CAT2_SH 0
#define B_AX_FWD_ACTN_CAT2_MSK 0xff

#define R_AX_ACTION_FWD_CTRL3 0x9C12
#define B_AX_FWD_ACTN_ACTN3_SH 8
#define B_AX_FWD_ACTN_ACTN3_MSK 0xff
#define B_AX_FWD_ACTN_CAT3_SH 0
#define B_AX_FWD_ACTN_CAT3_MSK 0xff

#define R_AX_TF_FWD 0x9C14
#define B_AX_FWD_TF15_SH 30
#define B_AX_FWD_TF15_MSK 0x3
#define B_AX_FWD_TF14_SH 28
#define B_AX_FWD_TF14_MSK 0x3
#define B_AX_FWD_TF13_SH 26
#define B_AX_FWD_TF13_MSK 0x3
#define B_AX_FWD_TF12_SH 24
#define B_AX_FWD_TF12_MSK 0x3
#define B_AX_FWD_TF11_SH 22
#define B_AX_FWD_TF11_MSK 0x3
#define B_AX_FWD_TF10_SH 20
#define B_AX_FWD_TF10_MSK 0x3
#define B_AX_FWD_TF9_SH 18
#define B_AX_FWD_TF9_MSK 0x3
#define B_AX_FWD_TF8_SH 16
#define B_AX_FWD_TF8_MSK 0x3
#define B_AX_FWD_TF7_SH 14
#define B_AX_FWD_TF7_MSK 0x3
#define B_AX_FWD_TF6_SH 12
#define B_AX_FWD_TF6_MSK 0x3
#define B_AX_FWD_TF5_SH 10
#define B_AX_FWD_TF5_MSK 0x3
#define B_AX_FWD_TF4_SH 8
#define B_AX_FWD_TF4_MSK 0x3
#define B_AX_FWD_TF3_SH 6
#define B_AX_FWD_TF3_MSK 0x3
#define B_AX_FWD_TF2_SH 4
#define B_AX_FWD_TF2_MSK 0x3
#define B_AX_FWD_TF1_SH 2
#define B_AX_FWD_TF1_MSK 0x3
#define B_AX_FWD_TF0_SH 0
#define B_AX_FWD_TF0_MSK 0x3

#define R_AX_HW_RPT_FWD 0x9C18
#define B_AX_FWD_TX_PLD_REL_WCPU_SH 16
#define B_AX_FWD_TX_PLD_REL_WCPU_MSK 0x3
#define B_AX_FWD_DFS_RPT_SH 14
#define B_AX_FWD_DFS_RPT_MSK 0x3
#define B_AX_FWD_TX_PLD_REL_HOST_SH 12
#define B_AX_FWD_TX_PLD_REL_HOST_MSK 0x3
#define B_AX_FWD_TX_RPT_SH 10
#define B_AX_FWD_TX_RPT_MSK 0x3
#define B_AX_FWD_SS2FW_RPT_SH 8
#define B_AX_FWD_SS2FW_RPT_MSK 0x3
#define B_AX_FWD_F2P_TX_CMD_RPT_SH 6
#define B_AX_FWD_F2P_TX_CMD_RPT_MSK 0x3
#define B_AX_FWD_BB_SCOPE_MODE_SH 4
#define B_AX_FWD_BB_SCOPE_MODE_MSK 0x3
#define B_AX_FWD_CH_INFO_SH 2
#define B_AX_FWD_CH_INFO_MSK 0x3
#define B_AX_FWD_PPDU_STAT_SH 0
#define B_AX_FWD_PPDU_STAT_MSK 0x3

#define R_AX_PLD_CAM_CTRL 0x9C1C
#define B_AX_PLD_CAM_EN BIT(7)
#define B_AX_PLD_CAM_ACC BIT(4)
#define B_AX_PLD_CAM_RANGE_SH 0
#define B_AX_PLD_CAM_RANGE_MSK 0xf

#define R_AX_PLD_CAM_ACCESS 0x9C20
#define B_AX_PLD_CAM_POLL BIT(31)
#define B_AX_PLD_CAM_RW BIT(30)
#define B_AX_PLD_CAM_CLR BIT(29)
#define B_AX_PLD_CAM_OFFSET_SH 0
#define B_AX_PLD_CAM_OFFSET_MSK 0xffff

#define R_AX_PLD_CAM_RDATA 0x9C24
#define B_AX_PLD_CAM_RDATA_SH 0
#define B_AX_PLD_CAM_RDATA_MSK 0xffffffffL

#define R_AX_PLD_CAM_WDATA 0x9C28
#define B_PLD_CAM_WDATA_SH 0
#define B_PLD_CAM_WDATA_MSK 0xffffffffL

#define R_AX_CUT_AMSDU_CTRL 0x9C40
#define B_AX_BIT_EN_CUT_AMSDU BIT(30)
#define B_AX_BIT_CUT_AMSDU_CHKLEN_EN BIT(24)
#define B_AX_BIT_CUT_AMSDU_CHKLEN_L_TH_SH 16
#define B_AX_BIT_CUT_AMSDU_CHKLEN_L_TH_MSK 0xff
#define B_AX_BIT_CUT_AMSDU_CHKLEN_H_TH_SH 0
#define B_AX_BIT_CUT_AMSDU_CHKLEN_H_TH_MSK 0xffff

#define R_AX_CUT_AMSDU_CTRL_2 0x9C44
#define B_AX_MSDU_DROP_SEQUENCE_NUMBER_SH 20
#define B_AX_MSDU_DROP_SEQUENCE_NUMBER_MSK 0xfff
#define B_AX_MSDU_DROP BIT(19)
#define B_AX_EXTRA_SHIFT_SH 17
#define B_AX_EXTRA_SHIFT_MSK 0x3

#define R_AX_REG_ERROR_MON 0x9C48
#define B_AX_BIT_MACRX_ERR_5 BIT(21)

#define R_AX_WOW_CTRL 0x9C50
#define B_AX_WOW_HCI BIT(5)
#define B_AX_WOW_DROP BIT(2)
#define B_AX_WOW_WOWEN BIT(1)
#define B_AX_WOW_FORCE_WAKEUP BIT(0)

#define R_AX_MPDU_RX_PKTCNT 0x9CE8
#define B_AX_RX_PKTOUT_CNT_SH 16
#define B_AX_RX_PKTOUT_CNT_MSK 0xffff
#define B_AX_RX_PKTIN_CNT_SH 0
#define B_AX_RX_PKTIN_CNT_MSK 0xffff

#define R_AX_MPDU_DROP_PKTCNT 0x9CEC
#define B_AX_DROP_PKTCNT_SH 0
#define B_AX_DROP_PKTCNT_MSK 0xffff

#define R_AX_MPDU_RX_ERR_ISR 0x9CF0
#define B_AX_RPT_ERR_ISR BIT(3)
#define B_AX_MHDRLEN_ERR_ISR BIT(1)
#define B_AX_GETPKTID_ERR_ISR BIT(0)

#define R_AX_MPDU_RX_ERR_IMR 0x9CF4
#define B_AX_RPT_ERR_INT_EN BIT(3)
#define B_AX_MHDRLEN_ERR_INT_EN BIT(1)
#define B_AX_GETPKTID_ERR_INT_EN BIT(0)

#define R_AX_MPDU_RX_DBG 0x9CF8
#define B_AX_MPDU_RX_CKEN_DIS BIT(16)
#define B_AX_MPDU_RX_DBG_EN BIT(8)
#define B_AX_MPDU_RX_D_LAST_EN BIT(0)

//
// SEC_ENG
//

#define R_AX_SEC_ENG_CTRL 0x9D00
#define B_AX_SEC_ENG_EN BIT(31)
#define B_AX_CCMP_SPP_MIC BIT(30)
#define B_AX_CCMP_SPP_CTR BIT(29)
#define B_AX_SEC_CAM_ACC BIT(28)
#define B_AX_SEC_CAM_CLK BIT(15)
#define B_AX_SEC_ENG_CLK BIT(14)
#define B_AX_RX_ICV_ERR BIT(13)
#define B_AX_TX_PARTIAL_MODE BIT(11)
#define B_AX_CLK_EN_CGCMP BIT(10)
#define B_AX_CLK_EN_WAPI BIT(9)
#define B_AX_CLK_EN_WEP_TKIP BIT(8)
#define B_AX_BMC_MGNT_DEC BIT(5)
#define B_AX_UC_MGNT_DEC BIT(4)
#define B_AX_MC_DEC BIT(3)
#define B_AX_BC_DEC BIT(2)
#define B_AX_SEC_RX_DEC BIT(1)
#define B_AX_SEC_TX_ENC BIT(0)

#define R_AX_SEC_MPDU_PROC 0x9D04
#define B_AX_APPEND_ICV BIT(1)
#define B_AX_APPEND_MIC BIT(0)

#define R_AX_SEC_CAM_ACCESS 0x9D10
#define B_AX_SEC_CAM_POLL BIT(15)
#define B_AX_SEC_CAM_RW BIT(14)
#define B_AX_SEC_CAM_ACC_FAIL BIT(13)
#define B_AX_SEC_CAM_OFFSET_SH 0
#define B_AX_SEC_CAM_OFFSET_MSK 0x3ff

#define R_AX_SEC_CAM_RDATA 0x9D14
#define B_AX_SEC_CAM_RDATA_SH 0
#define B_AX_SEC_CAM_RDATA_MSK 0xffffffffL

#define R_AX_SEC_CAM_WDATA 0x9D18
#define B_AX_SEC_CAM_WDATA_SH 0
#define B_AX_SEC_CAM_WDATA_MSK 0xffffffffL

#define R_AX_SEC_DEBUG 0x9D1C
#define B_AX_NON_SEC_SH 30
#define B_AX_NON_SEC_MSK 0x3
#define B_AX_TX_AMSDU_WAPI_SH 28
#define B_AX_TX_AMSDU_WAPI_MSK 0x3
#define B_AX__TX_AMSDU_RC4_SH 26
#define B_AX__TX_AMSDU_RC4_MSK 0x3
#define B_AX__TX_AMSDU__CCMP_GCMP_SH 24
#define B_AX__TX_AMSDU__CCMP_GCMP_MSK 0x3
#define B_AX_TX_WAPI_SH 22
#define B_AX_TX_WAPI_MSK 0x3
#define B_AX_TX_RC4_SH 20
#define B_AX_TX_RC4_MSK 0x3
#define B_AX_TX_CCMP_GCMP_SH 18
#define B_AX_TX_CCMP_GCMP_MSK 0x3
#define B_AX_RX_WAPI_SH 16
#define B_AX_RX_WAPI_MSK 0x3
#define B_AX_RX_RC4_SH 14
#define B_AX_RX_RC4_MSK 0x3
#define B_AX_RX_CCMP_GCMP_SH 12
#define B_AX_RX_CCMP_GCMP_MSK 0x3
#define B_AX_RX_PARSER_FSM_SH 8
#define B_AX_RX_PARSER_FSM_MSK 0xf
#define B_AX_TX_PARSER_FSM_SH 4
#define B_AX_TX_PARSER_FSM_MSK 0xf
#define B_AX_IMR_ERROR BIT(3)
#define B_AX_RX_HANG_ERROR BIT(2)
#define B_AX_TX_HANG_ERROR BIT(1)
#define B_AX_BYPASS_PKT BIT(0)

#define R_AX_SEC_TX_DEBUG 0x9D20
#define B_AX_TX_HANG BIT(22)
#define B_AX_TX_ENC_CLOCK_SH 6
#define B_AX_TX_ENC_CLOCK_MSK 0xffff
#define B_AX_TX_SEC_TYPE_SH 2
#define B_AX_TX_SEC_TYPE_MSK 0xf
#define B_AX_TX_EXKEY_ERROR BIT(1)
#define B_AX_TX_ENCRYPT BIT(0)

#define R_AX_SEC_RX_DEBUG 0x9D24
#define B_AX_RX_HANG BIT(31)
#define B_AX_RX_ENC_CLOCK_SH 15
#define B_AX_RX_ENC_CLOCK_MSK 0xffff
#define B_AX_RX_SEC_TYPE_SH 11
#define B_AX_RX_SEC_TYPE_MSK 0xf
#define B_AX_RX_MIC_ERROR BIT(10)
#define B_AX_RX_ICV_ERROR BIT(9)
#define B_AX_RX_EXKEY_INDEX_SH 1
#define B_AX_RX_EXKEY_INDEX_MSK 0x7f
#define B_AX_RX_ENCRYPT BIT(0)

#define R_AX_SEC_TRX_PKT_CNT 0x9D28
#define B_AX_TX_PKT_CLR BIT(31)
#define B_AX_TX_PKT_CNT_SH 16
#define B_AX_TX_PKT_CNT_MSK 0x7fff
#define B_AX_RX_PKT_CLR BIT(15)
#define B_AX_RX_PKT_CNT_SH 0
#define B_AX_RX_PKT_CNT_MSK 0x7fff

#define R_AX_SEC_TRX_BLK_CNT 0x9D2C
#define B_AX_TX_BLK_CNT_SH 16
#define B_AX_TX_BLK_CNT_MSK 0xffff
#define B_AX_RX_BLK_CNT_SH 0
#define B_AX_RX_BLK_CNT_MSK 0xffff

//
// STA scheduler
//

#define R_AX_SS_DBG_0 0x9E00
#define B_AX_SS_PARAM_STAT_SH 24
#define B_AX_SS_PARAM_STAT_MSK 0x7f
#define B_AX_SS_PC_STAT_SH 16
#define B_AX_SS_PC_STAT_MSK 0x3f
#define B_AX_SS_SA_STAT_SH 8
#define B_AX_SS_SA_STAT_MSK 0x3f
#define B_AX_SS_SS_INIT_DONE_0 BIT(7)
#define B_AX_SS_LM_STAT_SH 0
#define B_AX_SS_LM_STAT_MSK 0x7f

#define R_AX_SS_DBG_1 0x9E04
#define B_AX_SS_DEL_STAT_SH 28
#define B_AX_SS_DEL_STAT_MSK 0x3
#define B_AX_SS_ADD_STAT_SH 24
#define B_AX_SS_ADD_STAT_MSK 0x3
#define B_AX_SS_ULRU_STAT_SH 16
#define B_AX_SS_ULRU_STAT_MSK 0xf
#define B_AX_SS_DLTX_STAT_SH 8
#define B_AX_SS_DLTX_STAT_MSK 0x1f
#define B_AX_SS_LEN_STAT_SH 0
#define B_AX_SS_LEN_STAT_MSK 0x7f

#define R_AX_SS_DBG_2 0x9E08
#define B_AX_SS_PLEA_STAT_SH 24
#define B_AX_SS_PLEA_STAT_MSK 0xf
#define B_AX_SS_WDEA_STAT_SH 16
#define B_AX_SS_WDEA_STAT_MSK 0xf
#define B_AX_SS_RPTA_STAT_SH 8
#define B_AX_SS_RPTA_STAT_MSK 0x3f
#define B_AX_SS_FWTX_STAT_SH 0
#define B_AX_SS_FWTX_STAT_MSK 0x1f

#define R_AX_SS_DBG_3 0x9E0C
#define B_AX_SS_CLK_GATE_DIS BIT(31)
#define B_AX_SS_HW_ADD_LEN_OVF BIT(26)
#define B_AX_SS_SW_DECR_LEN_UDN BIT(25)
#define B_AX_SS_HW_DECR_LEN_UDN BIT(24)
#define B_AX_SS_ATM_ERR BIT(18)
#define B_AX_SS_DEL_STA_ERR BIT(17)
#define B_AX_SS_ADD_STA_ERR BIT(16)
#define B_AX_SS_LEN_INIT_DONE BIT(10)
#define B_AX_SS_PARAM_INIT_DONE BIT(9)
#define B_AX_SS_LINK_INIT_DONE BIT(8)
#define B_AX_SS_MOD_DBG_SEL_SH 4
#define B_AX_SS_MOD_DBG_SEL_MSK 0x3
#define B_AX_SS_TOP_DBG_SEL_SH 0
#define B_AX_SS_TOP_DBG_SEL_MSK 0xf

#define R_AX_SS_CTRL 0x9E10
#define B_AX_SS_INIT_DONE_1 BIT(31)
#define B_AX_SS_HW_STA_DIS BIT(30)
#define B_AX_SS_WARM_INIT_FLG BIT(29)
#define B_AX_SS_NONEMPTY_SS2FINFO_EN BIT(28)
#define B_AX_SS_RMAC_LENG_MEMORY_DIS BIT(27)
#define B_AX_SS_DELAY_TX_BAND_SEL_SH 24
#define B_AX_SS_DELAY_TX_BAND_SEL_MSK 0x3
#define B_AX_SS_WMM_SEL_3_SH 22
#define B_AX_SS_WMM_SEL_3_MSK 0x3
#define B_AX_SS_WMM_SEL_2_SH 20
#define B_AX_SS_WMM_SEL_2_MSK 0x3
#define B_AX_SS_WMM_SEL_1_SH 18
#define B_AX_SS_WMM_SEL_1_MSK 0x3
#define B_AX_SS_WMM_SEL_0_SH 16
#define B_AX_SS_WMM_SEL_0_MSK 0x3
#define B_AX_SS_HW_LEN_EN BIT(2)
#define B_AX_SS_HW_PARAM_EN BIT(1)
#define B_AX_SS_EN BIT(0)

#define R_AX_SS_DL_QUOTA_CTRL 0x9E14
#define B_AX_SS_QUOTA_MODE_3 BIT(31)
#define B_AX_SS_QUOTA_MODE_2 BIT(30)
#define B_AX_SS_QUOTA_MODE_1 BIT(29)
#define B_AX_SS_QUOTA_MODE_0 BIT(28)
#define B_AX_SS_DL_QUOTA_LOWER_LIMIT_SH 8
#define B_AX_SS_DL_QUOTA_LOWER_LIMIT_MSK 0xff
#define B_AX_SS_DL_QUOTA_INIT_SH 0
#define B_AX_SS_DL_QUOTA_INIT_MSK 0xf

#define R_AX_SS_UL_QUOTA_CTRL 0x9E18
#define B_AX_SS_QUOTA_MODE_UL BIT(31)
#define B_AX_SS_UL_QUOTA_LOWER_LIMIT_SH 8
#define B_AX_SS_UL_QUOTA_LOWER_LIMIT_MSK 0xff
#define B_AX_SS_UL_QUOTA_INIT_SH 0
#define B_AX_SS_UL_QUOTA_INIT_MSK 0xf

#define R_AX_SS_BSR_CTRL 0x9E1C
#define B_AX_SS_BSR_THR_1_SH 16
#define B_AX_SS_BSR_THR_1_MSK 0x3fff
#define B_AX_SS_BSR_THR_0_SH 0
#define B_AX_SS_BSR_THR_0_MSK 0x3fff

#define R_AX_SS_DL_RPT_CRTL 0x9E20
#define B_AX_SS_TXOP_MODE_3 BIT(30)
#define B_AX_SS_TXOP_MODE_2 BIT(22)
#define B_AX_SS_TXOP_MODE_1 BIT(14)
#define B_AX_SS_TWT_MAX_SU_NUM_1_SH 11
#define B_AX_SS_TWT_MAX_SU_NUM_1_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_1_SH 8
#define B_AX_SS_MAX_SU_NUM_1_MSK 0x7
#define B_AX_SS_TXOP_MODE_0 BIT(6)
#define B_AX_SS_TWT_MAX_SU_NUM_0_SH 3
#define B_AX_SS_TWT_MAX_SU_NUM_0_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_0_SH 0
#define B_AX_SS_MAX_SU_NUM_0_MSK 0x7

#define R_AX_SS_UL_RPT_CRTL 0x9E24
#define B_AX_SS_MAX_RU_NUM_UL_SH 16
#define B_AX_SS_MAX_RU_NUM_UL_MSK 0x3
#define B_AX_SS_UL_WMM_SH 8
#define B_AX_SS_UL_WMM_MSK 0x3
#define B_AX_SS_TWT_MAX_SU_NUM_UL_SH 3
#define B_AX_SS_TWT_MAX_SU_NUM_UL_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_UL_SH 0
#define B_AX_SS_MAX_SU_NUM_UL_MSK 0x7

#define R_AX_SS_SEARCH_TO 0x9E28
#define B_AX_SS_REPORT_HANG_TO_SH 16
#define B_AX_SS_REPORT_HANG_TO_MSK 0xff
#define B_AX_SS_SEARCH_HANG_TO_SH 8
#define B_AX_SS_SEARCH_HANG_TO_MSK 0xff
#define B_AX_SS_SEARCH_LIMIT_TO_SH 0
#define B_AX_SS_SEARCH_LIMIT_TO_MSK 0xff

#define R_AX_SS_SEARCH_LVL 0x9E2C
#define B_AX_SS_NEG_CNT_SH 16
#define B_AX_SS_NEG_CNT_MSK 0xff
#define B_AX_SS_NEG_LVL_SH 0
#define B_AX_SS_NEG_LVL_MSK 0xff

#define R_AX_SS_SRAM_DATA 0x9E30
#define B_AX_SS_SRAM_DATA_SH 0
#define B_AX_SS_SRAM_DATA_MSK 0xffffffffL

#define R_AX_SS_SRAM_W_EN 0x9E34
#define B_AX_SS_SRAM_W_EN_SH 0
#define B_AX_SS_SRAM_W_EN_MSK 0xffffffffL

#define R_AX_SS_SRAM_CTRL_0 0x9E38
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_RW BIT(23)
#define B_AX_SS_CMD_SH 20
#define B_AX_SS_CMD_MSK 0x7
#define B_AX_SS_OFFSET_SH 8
#define B_AX_SS_OFFSET_MSK 0x3
#define B_AX_SS_PARAM_SEL_SH 0
#define B_AX_SS_PARAM_SEL_MSK 0x7f

#define R_AX_SS_LINK_INFO 0x9E3C
#define B_AX_SS_STATUS_SH 29
#define B_AX_SS_STATUS_MSK 0x3
#define B_AX_SS_UL BIT(28)
#define B_AX_SS_WMM_SH 26
#define B_AX_SS_WMM_MSK 0x3
#define B_AX_SS_AC_SH 24
#define B_AX_SS_AC_MSK 0x3
#define B_AX_SS_LINK_LEN_SH 16
#define B_AX_SS_LINK_LEN_MSK 0xff
#define B_AX_SS_LINK_TAIL_SH 8
#define B_AX_SS_LINK_TAIL_MSK 0xff
#define B_AX_SS_LINK_HEAD_SH 0
#define B_AX_SS_LINK_HEAD_MSK 0xff

#define R_AX_SS_LINK_ADD 0x9E40
#define B_AX_SS_MACID_2_SH 16
#define B_AX_SS_MACID_2_MSK 0xff
#define B_AX_SS_MACID_1_SH 8
#define B_AX_SS_MACID_1_MSK 0xff
#define B_AX_SS_MACID_0_SH 0
#define B_AX_SS_MACID_0_MSK 0xff

#define R_AX_SS_LINK_DEL 0x9E44

#define R_AX_SS_LINK_SEARCH 0x9E48
#define B_AX_SS_TWT_GROUP_SH 20
#define B_AX_SS_TWT_GROUP_MSK 0xf
#define B_AX_SS_MODE_SEL_SH 16
#define B_AX_SS_MODE_SEL_MSK 0x3

#define R_AX_SS_SRAM_CTRL_1 0x9E4C
#define B_AX_SS_CMD_SEL_SH 26
#define B_AX_SS_CMD_SEL_MSK 0x1f
#define B_AX_SS_VALUE_SH 8
#define B_AX_SS_VALUE_MSK 0xffff
#define B_AX_SS_MACID_SH 0
#define B_AX_SS_MACID_MSK 0x7f

#define R_AX_SS2FINFO_PATH 0x9E50
#define B_AX_SS_UL_REL BIT(31)
#define B_AX_SS_REL_QUEUE_SH 24
#define B_AX_SS_REL_QUEUE_MSK 0x3f
#define B_AX_SS_REL_PORT_SH 16
#define B_AX_SS_REL_PORT_MSK 0x7
#define B_AX_SS_DEST_QUEUE_SH 8
#define B_AX_SS_DEST_QUEUE_MSK 0x3f
#define B_AX_SS_DEST_PORT_SH 0
#define B_AX_SS_DEST_PORT_MSK 0x7

#define R_AX_WMM_LINK_EMPTY 0x9E54
#define B_AX_WMM3_VO_LINK_EMPTY BIT(15)
#define B_AX_WMM3_VI_LINK_EMPTY BIT(14)
#define B_AX_WMM3_BK_LINK_EMPTY BIT(13)
#define B_AX_WMM3_BE_LINK_EMPTY BIT(12)
#define B_AX_WMM2_VO_LINK_EMPTY BIT(11)
#define B_AX_WMM2_VI_LINK_EMPTY BIT(10)
#define B_AX_WMM2_BK_LINK_EMPTY BIT(9)
#define B_AX_WMM2_BE_LINK_EMPTY BIT(8)
#define B_AX_WMM1_VO_LINK_EMPTY BIT(7)
#define B_AX_WMM1_VI_LINK_EMPTY BIT(6)
#define B_AX_WMM1_BK_LINK_EMPTY BIT(5)
#define B_AX_WMM1_BE_LINK_EMPTY BIT(4)
#define B_AX_WMM0_VO_LINK_EMPTY BIT(3)
#define B_AX_WMM0_VI_LINK_EMPTY BIT(2)
#define B_AX_WMM0_BK_LINK_EMPTY BIT(1)
#define B_AX_WMM0_BE_LINK_EMPTY BIT(0)

#define R_AX_SS_DELAYTX_TO 0x9E60
#define B_AX_SS_BEBK_TO_1_SH 24
#define B_AX_SS_BEBK_TO_1_MSK 0xff
#define B_AX_SS_VOVI_TO_1_SH 16
#define B_AX_SS_VOVI_TO_1_MSK 0xff
#define B_AX_SS_BEBK_TO_0_SH 8
#define B_AX_SS_BEBK_TO_0_MSK 0xff
#define B_AX_SS_VOVI_TO_0_SH 0
#define B_AX_SS_VOVI_TO_0_MSK 0xff

#define R_AX_SS_DELAYTX_LEN_THR 0x9E70
#define B_AX_SS_BEBK_LEN_THR_1_SH 24
#define B_AX_SS_BEBK_LEN_THR_1_MSK 0xff
#define B_AX_SS_VOVI_LEN_THR_1_SH 16
#define B_AX_SS_VOVI_LEN_THR_1_MSK 0xff
#define B_AX_SS_BEBK_LEN_THR_0_SH 8
#define B_AX_SS_BEBK_LEN_THR_0_MSK 0xff
#define B_AX_SS_VOVI_LEN_THR_0_SH 0
#define B_AX_SS_VOVI_LEN_THR_0_MSK 0xff

#define R_AX_SS_MU_CTRL 0x9E80
#define B_AX_SS_DLRU_STATE_SH 28
#define B_AX_SS_DLRU_STATE_MSK 0xf
#define B_AX_SS_DLMU_STATE_SH 24
#define B_AX_SS_DLMU_STATE_MSK 0xf
#define B_AX_SS_MU_OPT BIT(2)
#define B_AX_SS_SCORE_THR_SH 0
#define B_AX_SS_SCORE_THR_MSK 0x3

#define R_AX_SS_MU_TBL_0 0x9E84
#define B_AX_SS_MU_MACID_SH 11
#define B_AX_SS_MU_MACID_MSK 0x7f
#define B_AX_SS_TBL_VLD BIT(10)
#define B_AX_SS_SCORE_0_SH 8
#define B_AX_SS_SCORE_0_MSK 0x3
#define B_AX_SS_SCORE_1_SH 6
#define B_AX_SS_SCORE_1_MSK 0x3
#define B_AX_SS_SCORE_2_SH 4
#define B_AX_SS_SCORE_2_MSK 0x3
#define B_AX_SS_SCORE_3_SH 2
#define B_AX_SS_SCORE_3_MSK 0x3
#define B_AX_SS_SCORE_4_SH 0
#define B_AX_SS_SCORE_4_MSK 0x3

#define R_AX_SS_MU_TBL_1 0x9E88

#define R_AX_SS_MU_TBL_2 0x9E8C

#define R_AX_SS_MU_TBL_3 0x9E90

#define R_AX_SS_MU_TBL_4 0x9E94

#define R_AX_SS_MU_TBL_5 0x9E98

#define R_AX_SS_DL_MU_RPT_CRTL 0x9E9C
#define B_AX_SS_TWT_MAX_MU_NUM_1_SH 12
#define B_AX_SS_TWT_MAX_MU_NUM_1_MSK 0xf
#define B_AX_SS_MAX_MU_NUM_1_SH 8
#define B_AX_SS_MAX_MU_NUM_1_MSK 0xf
#define B_AX_SS_TWT_MAX_MU_NUM_0_SH 4
#define B_AX_SS_TWT_MAX_MU_NUM_0_MSK 0xf
#define B_AX_SS_MAX_MU_NUM_0_SH 0
#define B_AX_SS_MAX_MU_NUM_0_MSK 0xf

#define R_AX_SS_RU_CTRL 0x9EA0
#define B_AX_SS_GROUP_VLD_SH 16
#define B_AX_SS_GROUP_VLD_MSK 0xffff
#define B_AX_SS_RU_SEARCH_MODE_SH 0
#define B_AX_SS_RU_SEARCH_MODE_MSK 0x3

#define R_AX_SS_DL_RU_RPT_CRTL 0x9EA4
#define B_AX_SS_TWT_MAX_RU_NUM_1_SH 12
#define B_AX_SS_TWT_MAX_RU_NUM_1_MSK 0xf
#define B_AX_SS_MAX_RU_NUM_1_SH 8
#define B_AX_SS_MAX_RU_NUM_1_MSK 0xf
#define B_AX_SS_TWT_MAX_RU_NUM_0_SH 4
#define B_AX_SS_TWT_MAX_RU_NUM_0_MSK 0xf
#define B_AX_SS_MAX_RU_NUM_0_SH 0
#define B_AX_SS_MAX_RU_NUM_0_MSK 0xf

#define R_AX_SS_MACID_PAUSE_0 0x9EB0
#define B_AX_SS_MACID31_0_PAUSE_SH 0
#define B_AX_SS_MACID31_0_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_1 0x9EB4
#define B_AX_SS_MACID63_32_PAUSE_SH 0
#define B_AX_SS_MACID63_32_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_2 0x9EB8
#define B_AX_SS_MACID95_64_PAUSE_SH 0
#define B_AX_SS_MACID95_64_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_3 0x9EBC
#define B_AX_SS_MACID127_96_PAUSE_SH 0
#define B_AX_SS_MACID127_96_PAUSE_MSK 0xffffffffL

#define R_AX_STA_SCHEDULER_ERR_IMR 0x9EF0
#define B_AX_PLE_B_PKTID_ERR_INT_EN BIT(2)
#define B_AX_RPT_HANG_TIMEOUT_INT_EN BIT(1)
#define B_AX_SEARCH_HANG_TIMEOUT_INT_EN BIT(0)

#define R_AX_STA_SCHEDULER_ERR_ISR 0x9EF4
#define B_AX_PLE_B_PKTID_ERR_ISR BIT(2)
#define B_AX_RPT_HANG_TIMEOUT_ISR BIT(1)
#define B_AX_SEARCH_HANG_TIMEOUT_ISR BIT(0)

#define R_AX_SS_DBG_INFO 0x9EFC
#define B_AX_SS_DBG_INFO_SH 0
#define B_AX_SS_DBG_INFO_MSK 0xffffffffL

//
// Tx Packet Controller
//

#define R_AX_TXPKTCTL_WORD000 0x9F00

#define R_AX_TXPKTCTL_WORD004 0x9F04

#define R_AX_TXPKTCTL_WORD008 0x9F08

#define R_AX_TXPKTCTL_WORD00C 0x9F0C

#define R_AX_B0_CFG 0x9F10
#define B_AX_B0_PATC_OPT_BRKOFF BIT(24)
#define B_AX_B0_ATCPAR_REFTU_VAL_SH 8
#define B_AX_B0_ATCPAR_REFTU_VAL_MSK 0xff
#define B_AX_B0_ATCTMR_REFTU_CYC_SH 4
#define B_AX_B0_ATCTMR_REFTU_CYC_MSK 0x7
#define B_AX_B0_DIS_ACGC BIT(0)

#define R_AX_B0_CTL 0x9F14
#define B_AX_B0_CMDPSR_CTLST_REQPS BIT(7)
#define B_AX_CMDPSR_CTLST_NXTST_SH 0
#define B_AX_CMDPSR_CTLST_NXTST_MSK 0x1f

#define R_AX_TXPKTCTL_WORD018 0x9F18

#define R_AX_TXPKTCTL_ERR_IMR_ISR 0x9F1C
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR BIT(25)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR BIT(24)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR BIT(19)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR BIT(18)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR BIT(17)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR BIT(16)
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN BIT(8)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN BIT(3)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN BIT(2)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN BIT(1)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN BIT(0)

#define R_AX_TPC_B0_CFG 0x9F20
#define B_AX_B1_PATC_OPT_BRKOFF BIT(24)
#define B_AX_B1_ATCPAR_REFTU_VAL_SH 8
#define B_AX_B1_ATCPAR_REFTU_VAL_MSK 0xff
#define B_AX_B1_ATCTMR_REFTU_CYC_SH 4
#define B_AX_B1_ATCTMR_REFTU_CYC_MSK 0x7
#define B_AX_B1_DIS_ACGC BIT(0)

#define R_AX_TPC_B0_CTL 0x9F24
#define B_AX_B1_CMDPSR_CTLST_REQPS BIT(7)
#define B_AX_B1_CMDPSR_CTLST_NXTST_SH 0
#define B_AX_B1_CMDPSR_CTLST_NXTST_MSK 0x1f

#define R_AX_TXPKTCTL_WORD028 0x9F28

#define R_AX_TXPKTCTL_ERR_IMR_ISR_B1 0x9F2C

#define R_AX_DBG_FUN_INTF_CTL 0x9F30
#define B_AX_DFI_ACTIVE BIT(31)
#define B_AX_DFI_TRGSEL_SH 16
#define B_AX_DFI_TRGSEL_MSK 0xf
#define B_AX_DFI_ADDR_SH 0
#define B_AX_DFI_ADDR_MSK 0xffff

#define R_AX_DBG_FUN_INTF_DATA 0x9F34
#define B_AX_DFI_DATA_SH 0
#define B_AX_DFI_DATA_MSK 0xffffffffL

#define R_AX_DBG_CTL_TXPKT 0x9F38
#define B_AX_TPC_DBG1_SEL_SH 16
#define B_AX_TPC_DBG1_SEL_MSK 0xffff
#define B_AX_TPC_DBG0_SEL_SH 0
#define B_AX_TPC_DBG0_SEL_MSK 0xffff

#define R_AX_TPC_DBG_OUT 0x9F3C
#define B_AX_TPC_DBG1_OUT_SH 16
#define B_AX_TPC_DBG1_OUT_MSK 0xffff
#define B_AX_TPC_DBG0_OUT_SH 0
#define B_AX_TPC_DBG0_OUT_MSK 0xffff

#define R_AX_TPC_WORD040 0x9F40

#define R_AX_TPC_WORD044 0x9F44

#define R_AX_TPC_WORD048 0x9F48

#define R_AX_TPC_WORD04C 0x9F4C

#define R_AX_TPC_WORD050 0x9F50

#define R_AX_TPC_WORD054 0x9F54

#define R_AX_TPC_WORD058 0x9F58

#define R_AX_TPC_WORD05C 0x9F5C

#define R_AX_TPC_WORD060 0x9F60

#define R_AX_TPC_WORD064 0x9F64

#define R_AX_TPC_WORD068 0x9F68

#define R_AX_TPC_WORD06C 0x9F6C

#define R_AX_TPC_WORD070 0x9F70

#define R_AX_TPC_WORD074 0x9F74

#define R_AX_TPC_WORD078 0x9F78

#define R_AX_TPC_WORD07C 0x9F7C

//
// HCI common
//

//
// WL_AX_REG_DMAC.xls
//

//
// TOP_OFF
//
#define B_AX_BIST_TMCK BIT(15)

//
// WL_PON
//

//
// COMMON
//

//
// Dispatcher
//

//
// WDE_DLE
//

//
// PLE_DLE
//

//
// WDRLS
//

//
// BBRPT
//
#define B_AX_LA_ISR_DATA_LOSS BIT(16)
#define B_AX_LA_IMR_DATA_LOSS BIT(0)

//
// CPUIO
//

//
// PKTIN
//

//
// MPDU_Processor_1
//

//
// MPDU_Processor_2
//

//
// SEC_ENG
//

//
// STA scheduler
//

//
// Tx Packet Controller
//

//
// HCI common
//

//
// WL_AX_REG_DMAC.xls
//

//
// TOP_OFF
//

#define R_AX_GT0_CTRL_V1 0x7000

#define R_AX_GT0_CNT_V1 0x7004

#define R_AX_GT1_CTRL_V1 0x7008

#define R_AX_GT1_CNT_V1 0x700C

#define R_AX_GT2_CTRL_V1 0x7010

#define R_AX_GT2_CNT_V1 0x7014

#define R_AX_GT3_CTRL_V1 0x7018

#define R_AX_GT3_CNT_V1 0x701C

#define R_AX_TOPOFF_DBG_SEL 0x7020
#define B_AX_TOPOFF_DBG_SEL_SH 0
#define B_AX_TOPOFF_DBG_SEL_MSK 0xf

#define R_AX_SORT_CTRL_V1 0x7024

#define R_AX_GT4_CTRL_V1 0x7040

#define R_AX_GT4_CNT_V1 0x7044

#define R_AX_GT5_CTRL_V1 0x7048

#define R_AX_GT5_CNT_V1 0x704C

#define R_AX_GT6_CTRL_V1 0x7050

#define R_AX_GT6_CNT_V1 0x7054

#define R_AX_GT7_CTRL_V1 0x7058

#define R_AX_GT7_CNT_V1 0x705C

#define R_AX_FWD0IMR_V1 0x7100
#define B_AX_FS_GT7_INT_EN BIT(15)
#define B_AX_FS_GT6_INT_EN BIT(14)
#define B_AX_FS_GT5_INT_EN BIT(13)
#define B_AX_FS_GT4_INT_EN BIT(12)

#define R_AX_FWD0ISR_V1 0x7104
#define B_AX_FS_GT7_INT BIT(15)
#define B_AX_FS_GT6_INT BIT(14)
#define B_AX_FS_GT5_INT BIT(13)
#define B_AX_FS_GT4_INT BIT(12)

#define R_AX_HD0IMR_V1 0x7110

#define R_AX_HD0ISR_V1 0x7114

#define R_AX_H2CREG_DATA0_V1 0x7140

#define R_AX_H2CREG_DATA1_V1 0x7144

#define R_AX_H2CREG_DATA2_V1 0x7148

#define R_AX_H2CREG_DATA3_V1 0x714C

#define R_AX_C2HREG_DATA0_V1 0x7150

#define R_AX_C2HREG_DATA1_V1 0x7154

#define R_AX_C2HREG_DATA2_V1 0x7158

#define R_AX_C2HREG_DATA3_V1 0x715C

#define R_AX_H2CREG_CTRL_V1 0x7160

#define R_AX_C2HREG_CTRL_V1 0x7164

#define R_AX_CPWM_V1 0x7170

#define R_AX_ANACLK_CAL_CTRL_V1 0x7180

#define R_AX_OTP_PARA 0x7190
#define B_AX_OTP_PWE_H_PARA_SH 4
#define B_AX_OTP_PWE_H_PARA_MSK 0x3
#define B_AX_OTP_PWE_L_PARA_SH 0
#define B_AX_OTP_PWE_L_PARA_MSK 0x3

#define R_AX_PARAM_BIST_CTRL_V1 0x7200

#define R_AX_PARAM_MEM_RM_CTRL_V1 0x7204

#define R_AX_PARAM_USB_BIST_RSTN_V1 0x7210
#define B_AX_BIST_RST_N_USB_V1_SH 0
#define B_AX_BIST_RST_N_USB_V1_MSK 0x3fffff

#define R_AX_PARAM_USB_BIST_DONE_V1 0x7214
#define B_AX_BIST_DONE_USB_V1_SH 0
#define B_AX_BIST_DONE_USB_V1_MSK 0x3fffff

#define R_AX_PARAM_USB_BIST_FAIL_V1 0x7218
#define B_AX_BIST_FAIL_USB_V1_SH 0
#define B_AX_BIST_FAIL_USB_V1_MSK 0x3fffff

#define R_AX_PARAM_USB_DRF_PAUSE_V1 0x721C
#define B_AX_BIST_DRF_PAUSE_USB_V1_SH 0
#define B_AX_BIST_DRF_PAUSE_USB_V1_MSK 0x3fffff

#define R_AX_PARAM_PCIE_BIST_RSTN_V1 0x7220
#define B_AX_BIST_RST_N_PCIE_V1_SH 0
#define B_AX_BIST_RST_N_PCIE_V1_MSK 0x7fff

#define R_AX_PARAM_PCIE_BIST_DONE_V1 0x7224
#define B_AX_BIST_DONE_PCIE_V1_SH 0
#define B_AX_BIST_DONE_PCIE_V1_MSK 0x7fff

#define R_AX_PARAM_PCIE_BIST_FAIL_V1 0x7228
#define B_AX_BIST_FAIL_PCIE_V1_SH 0
#define B_AX_BIST_FAIL_PCIE_V1_MSK 0x7fff

#define R_AX_PARAM_PCIE_DRF_PAUSE_V1 0x722C
#define B_AX_BIST_DRF_PAUSE_PCIE_SH 0
#define B_AX_BIST_DRF_PAUSE_PCIE_MSK 0x7fff

#define R_AX_PARAM_SDIO_BIST_RSTN_V1 0x7240

#define R_AX_PARAM_SDIO_BIST_DONE_V1 0x7244

#define R_AX_PARAM_SDIO_BIST_FAIL_V1 0x7248

#define R_AX_PARAM_SDIO_DRF_PAUSE_V1 0x724C

#define R_AX_PARAM_BT0_BIST_RSTN_V1 0x7250

#define R_AX_PARAM_BT0_BIST_DONE_V1 0x7254

#define R_AX_PARAM_BT0_BIST_FAIL_V1 0x7258

#define R_AX_PARAM_BT0_DRF_PAUSE_V1 0x725C

#define R_AX_PARAM_BT1_BIST_RSTN_V1 0x7260
#define B_AX_BIST_RST_N_BT1_V1_SH 0
#define B_AX_BIST_RST_N_BT1_V1_MSK 0x1fff

#define R_AX_PARAM_BT1_BIST_DONE_V1 0x7264
#define B_AX_BIST_DONE_BT1_V1_SH 0
#define B_AX_BIST_DONE_BT1_V1_MSK 0x1fff

#define R_AX_PARAM_BT1_BIST_FAIL_V1 0x7268
#define B_AX_BIST_FAIL_BT1_V1_SH 0
#define B_AX_BIST_FAIL_BT1_V1_MSK 0x1fff

#define R_AX_PARAM_BT1_DRF_PAUSE_V1 0x726C
#define B_AX_BIST_DRF_PAUSE_BT1_V1_SH 0
#define B_AX_BIST_DRF_PAUSE_BT1_V1_MSK 0x1fff

#define R_AX_PARAM_BT_BIST_RPT_V1 0x7274

//
// WL_PON
//

#define R_AX_FWD1IMR_V1 0x7800

#define R_AX_FWD1ISR_V1 0x7804

#define R_AX_FSMIMR_V1 0x7808

#define R_AX_FSMISR_V1 0x780C

#define R_AX_TM_BKP_RES_CTRL_V1 0x7810
#define B_AX_SORTING_ROLE_SEL_V1_SH 12
#define B_AX_SORTING_ROLE_SEL_V1_MSK 0x3
#define B_AX_SORTING_ROLE_ST_V1_SH 8
#define B_AX_SORTING_ROLE_ST_V1_MSK 0xf

#define R_AX_PRE_CHK_CTRL_V1 0x7814

#define R_AX_LPS_WTM_SC_V1 0x7818

#define R_AX_LPS_WTM_CNT_V1 0x781C

#define R_AX_TSF_32K_SEL_V1 0x7820

#define R_AX_HIOE_END_ADDR_V1 0x7840

#define R_AX_HIOE_STR_ADDR_V1 0x7844

#define R_AX_BKP_HIOE_CTRL_V1 0x7848

#define R_AX_RES_HIOE_CTRL_V1 0x784C

#define R_AX_HCI_FUNC_EN_V1 0x7880
#define B_AX_HCI_CR_PROTECT BIT(31)
#define B_AX_HCI_TRXBUF_EN BIT(2)

#define R_AX_OSC_32K_CTRL_V1 0x7894

#define R_AX_32K_CAL_REG0_V1 0x7898

#define R_AX_OSC32K_RCAL_V1 0x789C

#define R_AX_BOOT_DBG_V1 0x78F0

//
// COMMON
//
#define B_AX_H_AXIDMA_EN BIT(14)
#define B_AX_DMAC_SER_PS BIT(13)
#define B_AX_CMAC_SER_PS BIT(12)
#define B_AX_MAC_CKEN BIT(30)
#define B_AX_DMAC_CKEN BIT(29)
#define B_AX_LTR_REQ_FW BIT(18)
#define B_AX_LTR_IDX_FW_SH 16
#define B_AX_LTR_IDX_FW_MSK 0x3
#define B_AX_LTR_WD_NOEMP_CHK_V1 BIT(1)
#define B_AX_LTR_IDLE_IDX_SH 0
#define B_AX_LTR_IDLE_IDX_MSK 0x3
#define B_AX_LTR_ACT_IDX_SH 0
#define B_AX_LTR_ACT_IDX_MSK 0x3
#define B_AX_DMAC_CTRL_INFO_SER_IO BIT(11)
#define B_AX_PLE_EMPTY_QTA_CMAC_DMA_TXRPT BIT(21)
#define B_AX_HCI_BUF_ERR_INT_EN BIT(12)
#define B_AX_BBRPT_ERR_INT_EN BIT(11)
#define B_AX_HCI_BUF_ERR_FLAG BIT(12)
#define B_AX_BBRPT_ERR_FLAG BIT(11)
#define B_AX_BIST_TMCK_W BIT(15)
#define B_AX_BIST_RSTN_N_DMAC_V1_SH 0
#define B_AX_BIST_RSTN_N_DMAC_V1_MSK 0x3fffffff
#define B_AX_BIST_DONE_DMAC_V1_SH 0
#define B_AX_BIST_DONE_DMAC_V1_MSK 0x3fffffff
#define B_AX_BIST_FAIL_DMAC_V1_SH 0
#define B_AX_BIST_FAIL_DMAC_V1_MSK 0x3fffffff
#define B_AX_BIST_DRF_PAUSE_DMAC_V1_SH 0
#define B_AX_BIST_DRF_PAUSE_DMAC_V1_MSK 0x3fffffff

//
// Dispatcher
//
#define B_AX_SER_RX_TO_TH_SH 24
#define B_AX_SER_RX_TO_TH_MSK 0xff
#define B_AX_SER_TX_TO_TH_SH 16
#define B_AX_SER_TX_TO_TH_MSK 0xff
#define B_AX_SER_RX_TO_UNIT_SH 10
#define B_AX_SER_RX_TO_UNIT_MSK 0x3
#define B_AX_SER_TX_TO_UNIT_SH 8
#define B_AX_SER_TX_TO_UNIT_MSK 0x3
#define B_AX_PLE_LAST_OPT_V1 BIT(7)
#define B_AX_WDE_LAST_OPT_V1 BIT(6)
#define B_AX_DDR_GATTING_DISABLE BIT(5)
#define B_AX_DDT_GATTING_DISABLE BIT(4)
#define B_AX_REUSE_SIZE_ERR BIT(31)
#define B_AX_REUSE_EN_ERR BIT(30)
#define B_AX_STF_OQT_UNDERFLOW_ERR BIT(29)
#define B_AX_STF_OQT_OVERFLOW_ERR BIT(28)
#define B_AX_STF_WRFF_UNDERFLOW_ERR BIT(27)
#define B_AX_STF_WRFF_OVERFLOW_ERR BIT(26)
#define B_AX_STF_CMD_UNDERFLOW_ERR BIT(25)
#define B_AX_STF_CMD_OVERFLOW_ERR BIT(24)
#define B_AX_REUSE_SIZE_ZERO_ERR BIT(23)
#define B_AX_REUSE_PKT_CNT_ERR BIT(22)
#define B_AX_CDT_PTR_TIMEOUT_ERR BIT(21)
#define B_AX_CDT_HCI_TIMEOUT_ERR BIT(20)
#define B_AX_HDT_PTR_TIMEOUT_ERR BIT(19)
#define B_AX_HDT_HCI_TIMEOUT_ERR BIT(18)
#define B_AX_CDT_ADDR_INFO_LEN_ERR BIT(17)
#define B_AX_HDT_ADDR_INFO_LEN_ERR BIT(16)
#define B_AX_CDR_DMA_TIMEOUT_ERR BIT(15)
#define B_AX_CDR_RX_TIMEOUT_ERR BIT(14)
#define B_AX_PLE_RESPOSE_ERR BIT(11)
#define B_AX_HDR_DMA_TIMEOUT_ERR BIT(7)
#define B_AX_HDR_RX_TIMEOUT_ERR BIT(6)
#define B_AX_WDE_RESPONSE_ERR BIT(3)
#define B_AX_HR_WRFF_UNDERFLOW_ERR BIT(31)
#define B_AX_HR_WRFF_OVERFLOW_ERR BIT(30)
#define B_AX_HR_CHKSUM_FSM_ERR BIT(29)
#define B_AX_HR_SHIFT_DMA_CFG_ERR BIT(28)
#define B_AX_HR_DMA_PROCESS_ERR BIT(27)
#define B_AX_HR_TOTAL_LEN_UNDER_ERR BIT(26)
#define B_AX_HR_SHIFT_EN_ERR BIT(25)
#define B_AX_HR_AGG_CFG_ERR BIT(24)
#define B_AX_HR_DMA_RD_CNT_DEQ_ERR BIT(23)
#define B_AX_HR_PLD_LEN_ZERO_ERR BIT(22)
#define B_AX_HT_ILL_CH_ERR BIT(20)
#define B_AX_HT_ADDR_INFO_LEN_ERR BIT(18)
#define B_AX_HT_WD_LEN_OVER_ERR BIT(17)
#define B_AX_HT_PLD_CMD_UNDERFLOW_ERR BIT(16)
#define B_AX_HT_PLD_CMD_OVERFLOW_ERR BIT(15)
#define B_AX_HT_WRFF_UNDERFLOW_ERR BIT(14)
#define B_AX_HT_WRFF_OVERFLOW_ERR BIT(13)
#define B_AX_HT_CHKSUM_FSM_ERR BIT(12)
#define B_AX_HT_TXPKTSIZE_ERR BIT(11)
#define B_AX_HT_PRE_SUB_ERR BIT(10)
#define B_AX_HT_WD_CHKSUM_ERR BIT(9)
#define B_AX_HT_CHANNEL_DMA_ERR BIT(8)
#define B_AX_HT_OFFSET_UNMATCH_ERR BIT(7)
#define B_AX_HT_PAYLOAD_UNDER_ERR BIT(6)
#define B_AX_HT_PAYLOAD_OVER_ERR BIT(5)
#define B_AX_HT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_AX_HT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_AX_HT_PKT_FAIL_ERR BIT(2)
#define B_AX_HT_CH_ID_ERR BIT(1)
#define B_AX_HT_EP_CH_DIFF_ERR BIT(0)
#define B_AX_CR_PLD_LEN_ERR BIT(30)
#define B_AX_CR_WRFF_UNDERFLOW_ERR BIT(29)
#define B_AX_CR_WRFF_OVERFLOW_ERR BIT(28)
#define B_AX_CR_SHIFT_DMA_CFG_ERR BIT(27)
#define B_AX_CR_DMA_PROCESS_ERR BIT(26)
#define B_AX_CR_TOTAL_LEN_UNDER_ERR BIT(25)
#define B_AX_CR_SHIFT_EN_ERR BIT(24)
#define B_AX_REUSE_FIFO_B_UNDER_ERR BIT(22)
#define B_AX_REUSE_FIFO_B_OVER_ERR BIT(21)
#define B_AX_REUSE_FIFO_A_UNDER_ERR BIT(20)
#define B_AX_REUSE_FIFO_A_OVER_ERR BIT(19)
#define B_AX_CT_ADDR_INFO_LEN_MISS_ERR BIT(17)
#define B_AX_CT_WD_LEN_OVER_ERR BIT(16)
#define B_AX_CT_F2P_SEQ_ERR BIT(15)
#define B_AX_CT_F2P_QSEL_ERR BIT(14)
#define B_AX_CT_PLD_CMD_UNDERFLOW_ERR BIT(13)
#define B_AX_CT_PLD_CMD_OVERFLOW_ERR BIT(12)
#define B_AX_CT_PRE_SUB_ERR BIT(11)
#define B_AX_CT_WD_CHKSUM_ERR BIT(10)
#define B_AX_CT_CHANNEL_DMA_ERR BIT(9)
#define B_AX_CT_OFFSET_UNMATCH_ERR BIT(8)
#define B_AX_CT_PAYLOAD_CHKSUM_ERR BIT(7)
#define B_AX_CT_PAYLOAD_UNDER_ERR BIT(6)
#define B_AX_CT_PAYLOAD_OVER_ERR BIT(5)
#define B_AX_CT_PERMU_FF_UNDERFLOW_ERR BIT(4)
#define B_AX_CT_PERMU_FF_OVERFLOW_ERR BIT(3)
#define B_AX_CT_CH_ID_ERR BIT(2)
#define B_AX_CT_EP_CH_DIFF_ERR BIT(0)
#define B_AX_CDT_TIMESTAMP_EN BIT(1)
#define B_AX_HDT_H2C_RX_Q_SEL_SH 1
#define B_AX_HDT_H2C_RX_Q_SEL_MSK 0x3
#define B_AX_HDT_REUSE_EN BIT(23)
#define B_AX_HDT_REUSE_OFFSET_SH 16
#define B_AX_HDT_REUSE_OFFSET_MSK 0xf
#define B_AX_AMSDU_HDR_CNV_SPACE_SH 16
#define B_AX_AMSDU_HDR_CNV_SPACE_MSK 0xf
#define B_AX_HR_WRFF_UNDERFLOW_ERR_INT_EN BIT(31)
#define B_AX_HR_WRFF_OVERFLOW_ERR_INT_EN BIT(30)
#define B_AX_HR_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_HR_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_HR_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(26)
#define B_AX_HR_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_HR_AGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_HR_DMA_RD_CNT_DEQ_ERR_INT_EN BIT(23)
#define B_AX_HR_PLD_LEN_ZERO_ERR_INT_EN BIT(22)
#define B_AX_HT_ILL_CH_ERR_INT_EN BIT(20)
#define B_AX_HT_ADDR_INFO_LEN_ERR_INT_EN BIT(18)
#define B_AX_HT_WD_LEN_OVER_ERR_INT_EN BIT(17)
#define B_AX_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(16)
#define B_AX_HT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(15)
#define B_AX_HT_WRFF_UNDERFLOW_ERR_INT_EN BIT(14)
#define B_AX_HT_WRFF_OVERFLOW_ERR_INT_EN BIT(13)
#define B_AX_HT_CHKSUM_FSM_ERR_INT_EN BIT(12)
#define B_AX_HT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_AX_HT_PRE_SUB_ERR_INT_EN BIT(10)
#define B_AX_HT_WD_CHKSUM_ERR_INT_EN BIT(9)
#define B_AX_HT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_AX_HT_OFFSET_UNMATCH_ERR_INT_EN BIT(7)
#define B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_AX_HT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_AX_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_AX_HT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_AX_HT_PKT_FAIL_ERR_INT_EN BIT(2)
#define B_AX_HT_CH_ID_ERR_INT_EN BIT(1)
#define B_AX_HT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_AX_CR_PLD_LEN_ERR_INT_EN BIT(30)
#define B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN BIT(28)
#define B_AX_CR_SHIFT_DMA_CFG_ERR_INT_EN BIT(27)
#define B_AX_CR_DMA_PROCESS_ERR_INT_EN BIT(26)
#define B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN BIT(25)
#define B_AX_CR_SHIFT_EN_ERR_INT_EN BIT(24)
#define B_AX_REUSE_FIFO_B_UNDER_ERR_INT_EN BIT(22)
#define B_AX_REUSE_FIFO_B_OVER_ERR_INT_EN BIT(21)
#define B_AX_REUSE_FIFO_A_UNDER_ERR_INT_EN BIT(20)
#define B_AX_REUSE_FIFO_A_OVER_ERR_INT_EN BIT(19)
#define B_AX_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN BIT(17)
#define B_AX_CT_WD_LEN_OVER_ERR_INT_EN BIT(16)
#define B_AX_CT_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_AX_CT_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_AX_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN BIT(13)
#define B_AX_CT_PLD_CMD_OVERFLOW_ERR_INT_EN BIT(12)
#define B_AX_CT_PRE_SUB_ERR_INT_EN BIT(11)
#define B_AX_CT_WD_CHKSUM_ERR_INT_EN BIT(10)
#define B_AX_CT_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_AX_CT_OFFSET_UNMATCH_ERR_INT_EN BIT(8)
#define B_AX_CT_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN BIT(6)
#define B_AX_CT_PAYLOAD_OVER_ERR_INT_EN BIT(5)
#define B_AX_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN BIT(4)
#define B_AX_CT_PERMU_FF_OVERFLOW_ERR_INT_EN BIT(3)
#define B_AX_CT_CH_ID_ERR_INT_EN BIT(2)
#define B_AX_CT_EP_CH_DIFF_ERR_INT_EN BIT(0)
#define B_AX_REUSE_SIZE_ERR_INT_EN BIT(31)
#define B_AX_REUSE_EN_ERR_INT_EN BIT(30)
#define B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN BIT(29)
#define B_AX_STF_OQT_OVERFLOW_ERR_INT_EN BIT(28)
#define B_AX_STF_WRFF_UNDERFLOW_ERR_INT_EN BIT(27)
#define B_AX_STF_WRFF_OVERFLOW_ERR_INT_EN BIT(26)
#define B_AX_STF_CMD_UNDERFLOW_ERR_INT_EN BIT(25)
#define B_AX_STF_CMD_OVERFLOW_ERR_INT_EN BIT(24)
#define B_AX_REUSE_SIZE_ZERO_ERR_INT_EN BIT(23)
#define B_AX_REUSE_PKT_CNT_ERR_INT_EN BIT(22)
#define B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN BIT(21)
#define B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN BIT(20)
#define B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN BIT(19)
#define B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN BIT(18)
#define B_AX_CDT_ADDR_INFO_LEN_ERR_INT_EN BIT(17)
#define B_AX_HDT_ADDR_INFO_LEN_ERR_INT_EN BIT(16)
#define B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN BIT(15)
#define B_AX_CDR_RX_TIMEOUT_ERR_INT_EN BIT(14)
#define B_AX_PLE_RESPOSE_ERR_INT_EN BIT(11)
#define B_AX_HDR_DMA_TIMEOUT_ERR_INT_EN BIT(7)
#define B_AX_HDR_RX_TIMEOUT_ERR_INT_EN BIT(6)
#define B_AX_WDE_RESPONSE_ERR_INT_EN BIT(3)
#define B_AX_DISPATCHER_DBG_PTR_SEL1_SH 24
#define B_AX_DISPATCHER_DBG_PTR_SEL1_MSK 0xf
#define B_AX_DISPATCHER_DBG_SEL1_SH 16
#define B_AX_DISPATCHER_DBG_SEL1_MSK 0xff
#define B_AX_DISPATCHER_DBG_PTR_SEL0_SH 8
#define B_AX_DISPATCHER_DBG_PTR_SEL0_MSK 0xf
#define B_AX_DISPATCHER_DBG_SEL0_SH 0
#define B_AX_DISPATCHER_DBG_SEL0_MSK 0xff

#define R_AX_DISPATCHER_DISP_DBG 0x8864
#define B_AX_DISPATCHER_DISP_DBG_SH 0
#define B_AX_DISPATCHER_DISP_DBG_MSK 0xffffffffL

#define R_AX_DELAY_MULTI_WP_SRC 0x8868
#define B_AX_DELAY_MULTI_WP_SRC BIT(0)

#define R_AX_HDP_DBG_INFO_0_V1 0x8880
#define B_AX_HCIFF_NON_EMPTY_V1 BIT(3)

#define R_AX_HDP_DBG_INFO_1_V1 0x8884
#define B_AX_PTR_CS_12_HDT_SH 28
#define B_AX_PTR_CS_12_HDT_MSK 0xf
#define B_AX_F2P_PTR_CS_SH 24
#define B_AX_F2P_PTR_CS_MSK 0xf
#define B_AX_PTR_CS_WP_CDT_SH 20
#define B_AX_PTR_CS_WP_CDT_MSK 0xf
#define B_AX_PTR_CS_CDT_SH 16
#define B_AX_PTR_CS_CDT_MSK 0xf
#define B_AX_PTR_CS_C2H_CDT_SH 12
#define B_AX_PTR_CS_C2H_CDT_MSK 0xf
#define B_AX_AXIFF_NON_EMPTY_V1 BIT(11)
#define B_AX_DATA_CS_CDT_SH 8
#define B_AX_DATA_CS_CDT_MSK 0x7
#define B_AX_ADDR_INFO_CS_V1_SH 4
#define B_AX_ADDR_INFO_CS_V1_MSK 0xf
#define B_AX_STF_CS_SH 0
#define B_AX_STF_CS_MSK 0xf

#define R_AX_HDP_DBG_INFO_2_V1 0x8888
#define B_AX_WRFF_EMPTY_HDT BIT(31)
#define B_AX_WRFF_FULL_HDT BIT(30)
#define B_AX_WRFF_PRE_FULL_HDT BIT(29)
#define B_AX_HCIWPFF_FULL BIT(28)
#define B_AX_AXIWPFF_FULL BIT(27)
#define B_AX_HCI_REQ_CH_PG_SH 13
#define B_AX_HCI_REQ_CH_PG_MSK 0x1fff
#define B_AX_TX_FULL_STS_SH 0
#define B_AX_TX_FULL_STS_MSK 0x1fff

#define R_AX_HDP_DBG_INFO_3_V1 0x888C

#define R_AX_HDP_DBG_INFO_4_V1 0x8890

#define R_AX_HDP_DBG_INFO_5_V1 0x8894

#define R_AX_HDP_DBG_INFO_6_V1 0x8898

#define R_AX_HDP_DBG_INFO_7_V1 0x889C
#define B_AX_WRFF_EMPTY_HDR BIT(23)
#define B_AX_WRFF_PRE_FULL_HDR BIT(22)
#define B_AX_WRFF_FULL_HDR BIT(21)
#define B_AX_DMA_ST_HDR_SH 16
#define B_AX_DMA_ST_HDR_MSK 0xf
#define B_AX_RX_ST_HDR_SH 12
#define B_AX_RX_ST_HDR_MSK 0x7
#define B_AX_LENFF_EMPTY_HDR BIT(11)
#define B_AX_LENFF_PRE_FULL_HDR BIT(10)
#define B_AX_LENFF_FULL_HDR BIT(9)
#define B_AX_HR_RXPKT_PROCESS BIT(7)
#define B_AX_HR_HCI_LAST_DMA BIT(6)
#define B_AX_HR_HCI_REQ_SH 4
#define B_AX_HR_HCI_REQ_MSK 0x3
#define B_AX_HR_HCI_EMPTY BIT(3)
#define B_AX_PCIE_BD_VLD_SH 0
#define B_AX_PCIE_BD_VLD_MSK 0x3

#define R_AX_HDP_DBG_INFO_8_V1 0x88A0
#define B_AX_HR_HCI_LENGTH_SH 16
#define B_AX_HR_HCI_LENGTH_MSK 0xffff
#define B_AX_PLE_Q_EMPTY_SH 0
#define B_AX_PLE_Q_EMPTY_MSK 0xffff

#define R_AX_HDP_DBG_INFO_9_V1 0x88A4
#define B_AX_WRFF_PRE_FULL_CDR BIT(31)
#define B_AX_WRFF_FULL_CDR BIT(30)
#define B_AX_WRFF_EMPTY_CDR BIT(29)
#define B_AX_DMA_ST_CDR_SH 24
#define B_AX_DMA_ST_CDR_MSK 0x7
#define B_AX_RX_ST_CDR_SH 20
#define B_AX_RX_ST_CDR_MSK 0x7
#define B_AX_CR_HCI_NEED_RXBD_TAG BIT(19)
#define B_AX_CR_RXPKT_PROCESS BIT(18)
#define B_AX_CR_HCI_LAST_DMA BIT(17)
#define B_AX_CR_HCI_EMPTY BIT(16)
#define B_AX_CR_HCI_REQ_SH 12
#define B_AX_CR_HCI_REQ_MSK 0x7
#define B_AX_AXIDMA_BD_VLD_SH 8
#define B_AX_AXIDMA_BD_VLD_MSK 0x7
#define B_AX_RX_CPU_PORT_SEL BIT(8)
#define B_AX_REMOVE_H2C_RXD BIT(0)
#define B_AX_CDR_BD_MASK_V1_SH 8
#define B_AX_CDR_BD_MASK_V1_MSK 0x7
#define B_AX_CDR_DISABLE_CH2 BIT(18)
#define B_AX_CDR_DISABLE_CH1 BIT(17)
#define B_AX_CDR_DISABLE_CH0 BIT(16)

#define R_AX_TYPE_NEED_RXBD_TAG 0x8924
#define B_AX_TUPE_ENQ_TO_CPU_SH 16
#define B_AX_TUPE_ENQ_TO_CPU_MSK 0xffff
#define B_AX_TYPE_NEED_RXBD_TAG_SH 0
#define B_AX_TYPE_NEED_RXBD_TAG_MSK 0xffff

//
// WDE_DLE
//

#define R_AX_WDE_GLB_CFG 0x8C00
#define B_AX_WDE_DIS_ACGC_FUNC BIT(0)

#define R_AX_WDE_DATCHN_CTL 0x8C18
#define B_AX_WDE_NULLPG_WRPORT BIT(8)

#define R_AX_WDE_FUNC_RSTCTL 0x8C1C
#define B_AX_WDE_GEN_PIF07 BIT(7)
#define B_AX_WDE_GEN_PIF06 BIT(6)
#define B_AX_WDE_GEN_PIF05 BIT(5)
#define B_AX_WDE_GEN_PIF04 BIT(4)
#define B_AX_WDE_GEN_PIF03 BIT(3)
#define B_AX_WDE_GEN_PIF02 BIT(2)
#define B_AX_WDE_GEN_PIF01 BIT(1)
#define B_AX_WDE_GEN_PIF00 BIT(0)

#define R_AX_WDE_DBGERR_LOCKEN 0x8C20
#define B_AX_WDE_LOCKEN_DLEPIF07 BIT(7)
#define B_AX_WDE_LOCKEN_DLEPIF06 BIT(6)
#define B_AX_WDE_LOCKEN_DLEPIF05 BIT(5)
#define B_AX_WDE_LOCKEN_DLEPIF04 BIT(4)
#define B_AX_WDE_LOCKEN_DLEPIF03 BIT(3)
#define B_AX_WDE_LOCKEN_DLEPIF02 BIT(2)
#define B_AX_WDE_LOCKEN_DLEPIF01 BIT(1)
#define B_AX_WDE_LOCKEN_DLEPIF00 BIT(0)

#define R_AX_WDE_DBGERR_STS 0x8C24
#define B_AX_WDE_LOCKON_DLEPIF07 BIT(7)
#define B_AX_WDE_LOCKON_DLEPIF06 BIT(6)
#define B_AX_WDE_LOCKON_DLEPIF05 BIT(5)
#define B_AX_WDE_LOCKON_DLEPIF04 BIT(4)
#define B_AX_WDE_LOCKON_DLEPIF03 BIT(3)
#define B_AX_WDE_LOCKON_DLEPIF02 BIT(2)
#define B_AX_WDE_LOCKON_DLEPIF01 BIT(1)
#define B_AX_WDE_LOCKON_DLEPIF00 BIT(0)

#define R_AX_WDE_ERRFLAG_MSG 0x8C30
#define B_AX_WDE_ERR_FLAG_MSG_SH 0
#define B_AX_WDE_ERR_FLAG_MSG_MSK 0xffffffffL
#define B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 BIT(9)
#define B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 BIT(8)
#define B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 BIT(7)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 BIT(6)
#define B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 BIT(4)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 BIT(3)
#define B_AX_WDE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_AX_WDE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_AX_WDE_DATCHN_CAMREQ_ERR BIT(29)
#define B_AX_WDE_DATCHN_ADRERR_ERR BIT(28)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_V1 BIT(9)
#define B_AX_WDE_GETNPG_PGOFST_ERR_V1 BIT(8)
#define B_AX_WDE_GETNPG_STRPG_ERR_V1 BIT(7)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_V1 BIT(6)
#define B_AX_WDE_BUFRTN_SIZE_ERR_V1 BIT(5)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_V1 BIT(4)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_V1 BIT(3)
#define B_AX_WDE_BUFREQ_SIZELMT_ERR BIT(2)
#define B_AX_WDE_BUFREQ_SIZE0_ERR BIT(1)
#define B_AX_WDE_Q5_MAX_SIZE_SH 16
#define B_AX_WDE_Q5_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q5_MIN_SIZE_SH 0
#define B_AX_WDE_Q5_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q6_MAX_SIZE_SH 16
#define B_AX_WDE_Q6_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q6_MIN_SIZE_SH 0
#define B_AX_WDE_Q6_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q7_MAX_SIZE_SH 16
#define B_AX_WDE_Q7_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q7_MIN_SIZE_SH 0
#define B_AX_WDE_Q7_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q8_MAX_SIZE_SH 16
#define B_AX_WDE_Q8_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q8_MIN_SIZE_SH 0
#define B_AX_WDE_Q8_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q9_MAX_SIZE_SH 16
#define B_AX_WDE_Q9_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q9_MIN_SIZE_SH 0
#define B_AX_WDE_Q9_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q10_MAX_SIZE_SH 16
#define B_AX_WDE_Q10_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q10_MIN_SIZE_SH 0
#define B_AX_WDE_Q10_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q11_MAX_SIZE_SH 16
#define B_AX_WDE_Q11_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q11_MIN_SIZE_SH 0
#define B_AX_WDE_Q11_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q12_MAX_SIZE_SH 16
#define B_AX_WDE_Q12_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q12_MIN_SIZE_SH 0
#define B_AX_WDE_Q12_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q13_MAX_SIZE_SH 16
#define B_AX_WDE_Q13_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q13_MIN_SIZE_SH 0
#define B_AX_WDE_Q13_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q14_MAX_SIZE_SH 16
#define B_AX_WDE_Q14_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q14_MIN_SIZE_SH 0
#define B_AX_WDE_Q14_MIN_SIZE_MSK 0xfff
#define B_AX_WDE_Q15_MAX_SIZE_SH 16
#define B_AX_WDE_Q15_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q15_MIN_SIZE_SH 0
#define B_AX_WDE_Q15_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_WORD0F0 0x8CF0

#define R_AX_WDE_WORD0F4 0x8CF4

#define R_AX_WDE_WORD0F8 0x8CF8

#define R_AX_WDE_WORD0FC 0x8CFC

//
// PLE_DLE
//

#define R_AX_PLE_GLB_CFG 0x9000
#define B_AX_PLE_DIS_ACGC_FUNC BIT(0)

#define R_AX_PLE_DATCHN_CTL 0x9018
#define B_AX_PLE_NULLPG_WRPORT BIT(8)

#define R_AX_PLE_FUNC_RSTCTL 0x901C
#define B_AX_PLE_GEN_PIF07 BIT(7)
#define B_AX_PLE_GEN_PIF06 BIT(6)
#define B_AX_PLE_GEN_PIF05 BIT(5)
#define B_AX_PLE_GEN_PIF04 BIT(4)
#define B_AX_PLE_GEN_PIF03 BIT(3)
#define B_AX_PLE_GEN_PIF02 BIT(2)
#define B_AX_PLE_GEN_PIF01 BIT(1)
#define B_AX_PLE_GEN_PIF00 BIT(0)

#define R_AX_PLE_DBGERR_LOCKEN 0x9020
#define B_AX_PLE_LOCKEN_DLEPIF07 BIT(7)
#define B_AX_PLE_LOCKEN_DLEPIF06 BIT(6)
#define B_AX_PLE_LOCKEN_DLEPIF05 BIT(5)
#define B_AX_PLE_LOCKEN_DLEPIF04 BIT(4)
#define B_AX_PLE_LOCKEN_DLEPIF03 BIT(3)
#define B_AX_PLE_LOCKEN_DLEPIF02 BIT(2)
#define B_AX_PLE_LOCKEN_DLEPIF01 BIT(1)
#define B_AX_PLE_LOCKEN_DLEPIF00 BIT(0)

#define R_AX_PLE_DBGERR_STS 0x9024
#define B_AX_PLE_LOCKON_DLEPIF07 BIT(7)
#define B_AX_PLE_LOCKON_DLEPIF06 BIT(6)
#define B_AX_PLE_LOCKON_DLEPIF05 BIT(5)
#define B_AX_PLE_LOCKON_DLEPIF04 BIT(4)
#define B_AX_PLE_LOCKON_DLEPIF03 BIT(3)
#define B_AX_PLE_LOCKON_DLEPIF02 BIT(2)
#define B_AX_PLE_LOCKON_DLEPIF01 BIT(1)
#define B_AX_PLE_LOCKON_DLEPIF00 BIT(0)

#define R_AX_PLE_ERRFLAG_MSG 0x9030
#define B_AX_PLE_ERR_FLAG_MSG_SH 0
#define B_AX_PLE_ERR_FLAG_MSG_MSK 0xffffffffL
#define B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN BIT(29)
#define B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN BIT(28)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 BIT(9)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 BIT(8)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 BIT(7)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 BIT(6)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 BIT(5)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 BIT(4)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 BIT(3)
#define B_AX_PLE_BUFREQ_SIZELMT_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_SIZE0_INT_EN BIT(1)
#define B_AX_PLE_DATCHN_CAMREQ_ERR BIT(29)
#define B_AX_PLE_DATCHN_ADRERR_ERR BIT(28)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_V1 BIT(9)
#define B_AX_PLE_GETNPG_PGOFST_ERR_V1 BIT(8)
#define B_AX_PLE_GETNPG_STRPG_ERR_V1 BIT(7)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_V1 BIT(6)
#define B_AX_PLE_BUFRTN_SIZE_ERR_V1 BIT(5)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_V1 BIT(4)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_V1 BIT(3)
#define B_AX_PLE_BUFREQ_SIZELMT_ERR BIT(2)
#define B_AX_PLE_BUFREQ_SIZE0_ERR BIT(1)

//
// WDRLS
//
#define B_AX_RLSRPT_BUFREQ_TO_SEL_SH 6
#define B_AX_RLSRPT_BUFREQ_TO_SEL_MSK 0x3

//
// BBRPT
//
#define B_AX_DIS_ACGC_DMA_PHYIF_V1 BIT(1)
#define B_AX_DIS_ACGC_DMA_RPTGEN_V1 BIT(0)

#define R_AX_BBRPT_COM_ERR_IMR 0x9608
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN_V1 BIT(1)
#define B_AX_BBRPT_COM_HANG_EN BIT(0)

#define R_AX_BBRPT_COM_ERR_ISR 0x960C
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_V1 BIT(1)
#define B_AX_BBRPT_COM_HANG_ISR BIT(0)

#define R_AX_BBRPT_CHINFO_ERR_IMR 0x9628

#define R_AX_BBRPT_CHINFO_ERR_ISR 0x962C
#define B_AX_BBPRT_CHIF_TO_ERR_V1 BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_V1 BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_V1 BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_V1 BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_V1 BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_V1 BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_V1 BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_V1 BIT(0)

#define R_AX_BBRPT_DFS_ERR_IMR 0x9638

#define R_AX_BBRPT_DFS_ERR_ISR 0x963C
#define B_AX_BBRPT_DFS_TO_ERR_V1 BIT(0)

#define R_AX_LA_ERRFLAG_IMR 0x9668

//
// CPUIO
//

//
// PKTIN
//
#define B_AX_AMSDU_MAX_FS_NUM_SH 2
#define B_AX_AMSDU_MAX_FS_NUM_MSK 0x7
#define B_AX_AMSDU_FS_ENABLE BIT(1)

//
// MPDU_Processor_1
//
#define B_AX_TX_MAC_MPDU_PROC_EN BIT(2)
#define B_AX_TX_HW_ACK_POLICY_EN BIT(1)
#define B_AX_TX_HW_SEQ_EN BIT(0)
#define B_AX_TX_KSRCH_ERR BIT(9)
#define B_AX_TX_NW_TYPE_ERR BIT(8)
#define B_AX_TX_LLC_PRE_ERR BIT(7)
#define B_AX_TX_ETH_TYPE_ERR BIT(6)
#define B_AX_TX_KSRCH_ERR_EN BIT(9)
#define B_AX_TX_NW_TYPE_ERR_EN BIT(8)
#define B_AX_TX_LLC_PRE_ERR_EN BIT(7)
#define B_AX_TX_ETH_TYPE_ERR_EN BIT(6)

#define R_AX_MPDU_TX_DBG_V1 0x9BF8
#define B_AX_MPDU_TX_DBGEN_V1 BIT(8)
#define B_AX_MPDU_TX_CKEN_DIS BIT(1)
#define B_AX_MPDU_TX_DLAST_V1 BIT(0)

//
// MPDU_Processor_2
//
#define B_AX_RPKT_CQID_SH 24
#define B_AX_RPKT_CQID_MSK 0x3f
#define B_AX_WPKT_CQID_SH 16
#define B_AX_WPKT_CQID_MSK 0x3f
#define B_AX_RPKT_CPID_SH 12
#define B_AX_RPKT_CPID_MSK 0x7
#define B_AX_WPKT_CPID_SH 8
#define B_AX_WPKT_CPID_MSK 0x7
#define B_AX_RXFWD_PRIO_SH 4
#define B_AX_RXFWD_PRIO_MSK 0x3

#define R_AX_RXFWD_SM 0x9C2C
#define B_AX_RXFWD_SM_SH 0
#define B_AX_RXFWD_SM_MSK 0xffffffffL

#define R_AX_RXCTRL_SM 0x9C30
#define B_AX_RXCTRL_SM_SH 0
#define B_AX_RXCTRL_SM_MSK 0xffffffffL

#define R_AX_PROFILE_SM 0x9C38
#define B_AX_PROFILE_SM_SH 0
#define B_AX_PROFILE_SM_MSK 0xffffffffL

#define R_AX_PLDM_SM 0x9C3C
#define B_AX_PLDM_SM_SH 0
#define B_AX_PLDM_SM_MSK 0xffffffffL
#define B_AX_EN_CUT_AMSDU_V1 BIT(31)
#define B_AX_CUT_AMSDU_CHKLEN_EN_V1 BIT(30)
#define B_AX_CA_CHK_ADDRCAM_EN BIT(29)
#define B_AX_CUT_AMSDU_CHKLEN_L_TH_SH 16
#define B_AX_CUT_AMSDU_CHKLEN_L_TH_MSK 0xff
#define B_AX_CUT_AMSDU_CHKLEN_H_TH_SH 0
#define B_AX_CUT_AMSDU_CHKLEN_H_TH_MSK 0xffff
#define B_AX_MSDU_DROP_SN_SH 20
#define B_AX_MSDU_DROP_SN_MSK 0xfff
#define B_AX_MSDU_DROP_SN_CLR BIT(19)

#define R_AX_CUT_AMSDU_ERROR_FLAG 0x9C48
#define B_AX_AMSDU_2_LEN BIT(2)
#define B_AX_AMSDU_2_SMALL BIT(1)
#define B_AX_AMSDU_2_LARGE BIT(0)

#define R_AX_HDR_CNV_CTRL 0x9C60
#define B_AX_HDR_INFO_SH 4
#define B_AX_HDR_INFO_MSK 0x3
#define B_AX_HC_ADDR_HIT_EN BIT(3)
#define B_AX_HDR_CNV BIT(1)
#define B_AX_RX_HDR_CNV_EN BIT(0)

#define R_AX_HDR_CNV_VLAN_0_1 0x9C64
#define B_AX_VLAN_TAG_1_SH 16
#define B_AX_VLAN_TAG_1_MSK 0xffff
#define B_AX_VLAN_TAG_0_SH 0
#define B_AX_VLAN_TAG_0_MSK 0xffff

#define R_AX_HDR_CNV_VLAN_2_3 0x9C68
#define B_AX_VLAN_TAG_3_SH 16
#define B_AX_VLAN_TAG_3_MSK 0xffff
#define B_AX_VLAN_TAG_2_SH 0
#define B_AX_VLAN_TAG_2_MSK 0xffff

#define R_AX_RX_MPDU_PROC_VER 0x9CE0
#define B_AX_RX_MPDU_PROC_VER_SH 0
#define B_AX_RX_MPDU_PROC_VER_MSK 0xffffffffL

#define R_AX_RX_MPDU_PROC_DBG 0x9CE4
#define B_AX_CAMCTRL_DBG_SH 30
#define B_AX_CAMCTRL_DBG_MSK 0x3
#define B_AX_MGPT_DBG_SH 26
#define B_AX_MGPT_DBG_MSK 0xf
#define B_AX_WOWLAN_DBG_SH 21
#define B_AX_WOWLAN_DBG_MSK 0x1f
#define B_AX_PLDM_DBG_SH 16
#define B_AX_PLDM_DBG_MSK 0x1f
#define B_AX_RXFWD_DBG_SH 12
#define B_AX_RXFWD_DBG_MSK 0xf
#define B_AX_CUT_AMSDU_DBG_SH 8
#define B_AX_CUT_AMSDU_DBG_MSK 0xf
#define B_AX_PROFILE_DBG_SH 5
#define B_AX_PROFILE_DBG_MSK 0x7
#define B_AX_RXCTRL_DBG_SH 0
#define B_AX_RXCTRL_DBG_MSK 0x1f
#define B_AX_CAM_RST_CTRL BIT(24)

//
// SEC_ENG
//

#define R_AX_SEC_DEBUG1 0x9D1C
#define B_AX_TX_TIMEOUT_SEL_SH 30
#define B_AX_TX_TIMEOUT_SEL_MSK 0x3
#define B_AX_RX_TIMEOUT_SEL_SH 28
#define B_AX_RX_TIMEOUT_SEL_MSK 0x3
#define B_AX_TX_LAST_PKTID_SH 16
#define B_AX_TX_LAST_PKTID_MSK 0xfff
#define B_AX_RX_LAST_PKTID_SH 4
#define B_AX_RX_LAST_PKTID_MSK 0xfff
#define B_AX_TX_READ_PARSER_FSM_SH 23
#define B_AX_TX_READ_PARSER_FSM_MSK 0x1ff
#define B_AX_TX_WRITE_PARSER_FSM_SH 15
#define B_AX_TX_WRITE_PARSER_FSM_MSK 0xff
#define B_AX_RX_READ_PARSER_FSM_SH 25
#define B_AX_RX_READ_PARSER_FSM_MSK 0x7f
#define B_AX_RX_WRITE_PARSER_FSM_SH 17
#define B_AX_RX_WRITE_PARSER_FSM_MSK 0xff

#define R_AX_SEC_DEBUG2 0x9D28
#define B_AX_DBG_READ_SH 2
#define B_AX_DBG_READ_MSK 0x3fffffff

#define R_AX_SEC_ERROR_FLAG_IMR 0x9D2C
#define B_AX_RX_HANG_IMR BIT(1)
#define B_AX_TX_HANG_IMR BIT(0)

#define R_AX_SEC_ERROR_FLAG 0x9D30
#define B_AX_RX_HANG_ERROR_V1 BIT(1)
#define B_AX_TX_HANG_ERROR_V1 BIT(0)

//
// STA scheduler
//
#define B_AX_SS_PLEA_STAT_V1_SH 24
#define B_AX_SS_PLEA_STAT_V1_MSK 0x1f
#define B_AX_SS_WDEA_STAT_V1_SH 16
#define B_AX_SS_WDEA_STAT_V1_MSK 0x1f
#define B_AX_PRE_CHK_FORCE_VLD BIT(30)
#define B_AX_SS_TOP_DBG_SEL_V1_SH 11
#define B_AX_SS_TOP_DBG_SEL_V1_MSK 0x1f
#define B_AX_SS_AVG_INIT_DONE BIT(7)
#define B_AX_SS_MRT_INIT_DONE BIT(6)
#define B_AX_UL_LINK_EMPTY BIT(16)

#define R_AX_SS_LINK_SRCH_STAT 0x9E58
#define B_AX_SS_SRCH_UD_VAL_UL BIT(24)
#define B_AX_SS_SRCH_UD_VAL_WMM1_VO BIT(23)
#define B_AX_SS_SRCH_UD_VAL_WMM1_VI BIT(22)
#define B_AX_SS_SRCH_UD_VAL_WMM1_BK BIT(21)
#define B_AX_SS_SRCH_UD_VAL_WMM1_BE BIT(20)
#define B_AX_SS_SRCH_UD_VAL_WMM0_VO BIT(19)
#define B_AX_SS_SRCH_UD_VAL_WMM0_VI BIT(18)
#define B_AX_SS_SRCH_UD_VAL_WMM0_BK BIT(17)
#define B_AX_SS_SRCH_UD_VAL_WMM0_BE BIT(16)
#define B_AX_SS_SRCH_STAT_UL BIT(8)
#define B_AX_SS_SRCH_STAT_WMM1_VO BIT(7)
#define B_AX_SS_SRCH_STAT_WMM1_VI BIT(6)
#define B_AX_SS_SRCH_STAT_WMM1_BK BIT(5)
#define B_AX_SS_SRCH_STAT_WMM1_BE BIT(4)
#define B_AX_SS_SRCH_STAT_WMM0_VO BIT(3)
#define B_AX_SS_SRCH_STAT_WMM0_VI BIT(2)
#define B_AX_SS_SRCH_STAT_WMM0_BK BIT(1)
#define B_AX_SS_SRCH_STAT_WMM0_BE BIT(0)

#define R_AX_SSLINK_SRCH_UD 0x9E5C
#define B_AX_SS_SRCH_UD_UL BIT(24)
#define B_AX_SS_SRCH_UD_WMM1_VO BIT(23)
#define B_AX_SS_SRCH_UD_WMM1_VI BIT(22)
#define B_AX_SS_SRCH_UD_WMM1_BK BIT(21)
#define B_AX_SS_SRCH_UD_WMM1_BE BIT(20)
#define B_AX_SS_SRCH_UD_WMM0_VO BIT(19)
#define B_AX_SS_SRCH_UD_WMM0_VI BIT(18)
#define B_AX_SS_SRCH_UD_WMM0_BK BIT(17)
#define B_AX_SS_SRCH_UD_WMM0_BE BIT(16)

#define R_AX_SS_MURU_TBL_CTRL 0x9E78
#define B_AX_SS_TBL_CMD_SH 24
#define B_AX_SS_TBL_CMD_MSK 0x7f
#define B_AX_SS_STA_IDX_SH 16
#define B_AX_SS_STA_IDX_MSK 0xf
#define B_AX_SS_TBL_IDX_SH 0
#define B_AX_SS_TBL_IDX_MSK 0xff

#define R_AX_SS_MURU_TBL_DATA 0x9E7C
#define B_AX_SS_TBL_MACID_SH 16
#define B_AX_SS_TBL_MACID_MSK 0xff
#define B_AX_SS_TBL_DIS_AC_SH 12
#define B_AX_SS_TBL_DIS_AC_MSK 0xf
#define B_AX_SS_TBL_MURU_VLD BIT(11)
#define B_AX_SS_TBL_MURU BIT(10)
#define B_AX_SS_TBL_WDIX_SH 8
#define B_AX_SS_TBL_WDIX_MSK 0x3
#define B_AX_SS_TBL_RATE_IDX_SH 0
#define B_AX_SS_TBL_RATE_IDX_MSK 0xff
#define B_AX_MURT_TABLE_MAX_SH 16
#define B_AX_MURT_TABLE_MAX_MSK 0x1ff
#define B_AX_MU_PING_PONG_EN BIT(9)
#define B_AX_RU_PING_PONG_EN BIT(8)
#define B_AX_SS_MU_SW_SRCH_MODE BIT(5)
#define B_AX_SS_RU_SW_SRCH_MODE BIT(4)
#define B_AX_SS_MU_SEARCH_MODE_SH 2
#define B_AX_SS_MU_SEARCH_MODE_MSK 0x3

#define R_AX_SS_MAL_CTRL 0x9EA8
#define B_AX_SS_MAL_RW BIT(30)
#define B_AX_SS_MAL_MACID_SH 16
#define B_AX_SS_MAL_MACID_MSK 0xff
#define B_AX_SSMAL_W_EN_SH 8
#define B_AX_SSMAL_W_EN_MSK 0xff
#define B_AX_SS_MAL_VAL_SH 0
#define B_AX_SS_MAL_VAL_MSK 0xff

#define R_AX_SS_MAL_RPT 0x9EAC

#define R_AX_SS_BSR_TRIGGER_0 0x9EC0
#define B_AX_SS_MACID31_0_BSR_TRIGGER_SH 0
#define B_AX_SS_MACID31_0_BSR_TRIGGER_MSK 0xffffffffL

#define R_AX_SS_BSR_TRIGGER_1 0x9EC4
#define B_AX_SS_MACID63_32_BSR_TRIGGER_SH 0
#define B_AX_SS_MACID63_32_BSR_TRIGGER_MSK 0xffffffffL

#define R_AX_SS_BSR_TRIGGER_2 0x9EC8
#define B_AX_SS_MACID95_64_BSR_TRIGGER_SH 0
#define B_AX_SS_MACID95_64_BSR_TRIGGER_MSK 0xffffffffL

#define R_AX_SS_BSR_TRIGGER_3 0x9ECC
#define B_AX_SS_MACID127_96_BSR_TRIGGER_SH 0
#define B_AX_SS_MACID127_96_BSR_TRIGGER_MSK 0xffffffffL

#define R_AX_SS_MU_WIDX_0 0x9ED0
#define B_AX_SS_MU_BETA_1_SH 20
#define B_AX_SS_MU_BETA_1_MSK 0x1ff
#define B_AX_SS_MU_ALPHA_1_SH 16
#define B_AX_SS_MU_ALPHA_1_MSK 0xf
#define B_AX_SS_MU_BETA_0_SH 4
#define B_AX_SS_MU_BETA_0_MSK 0x1ff
#define B_AX_SS_MU_ALPHA_0_SH 0
#define B_AX_SS_MU_ALPHA_0_MSK 0xf

#define R_AX_SS_MU_WIDX_1 0x9ED4
#define B_AX_SS_MU_BETA_3_SH 20
#define B_AX_SS_MU_BETA_3_MSK 0x1ff
#define B_AX_SS_MU_ALPHA_3_SH 16
#define B_AX_SS_MU_ALPHA_3_MSK 0xf
#define B_AX_SS_MU_BETA_2_SH 4
#define B_AX_SS_MU_BETA_2_MSK 0x1ff
#define B_AX_SS_MU_ALPHA_2_SH 0
#define B_AX_SS_MU_ALPHA_2_MSK 0xf

#define R_AX_SS_RU_WIDX_0 0x9ED8
#define B_AX_SS_RU_BETA_1_SH 20
#define B_AX_SS_RU_BETA_1_MSK 0x1ff
#define B_AX_SS_RU_ALPHA_1_SH 16
#define B_AX_SS_RU_ALPHA_1_MSK 0xf
#define B_AX_SS_RU_BETA_0_SH 4
#define B_AX_SS_RU_BETA_0_MSK 0x1ff
#define B_AX_SS_RU_ALPHA_0_SH 0
#define B_AX_SS_RU_ALPHA_0_MSK 0xf

#define R_AX_SS_RU_WIDX_1 0x9EDC
#define B_AX_SS_RU_BETA_3_SH 20
#define B_AX_SS_RU_BETA_3_MSK 0x1ff
#define B_AX_SS_RU_ALPHA_3_SH 16
#define B_AX_SS_RU_ALPHA_3_MSK 0xf
#define B_AX_SS_RU_BETA_2_SH 4
#define B_AX_SS_RU_BETA_2_MSK 0x1ff
#define B_AX_SS_RU_ALPHA_2_SH 0
#define B_AX_SS_RU_ALPHA_2_MSK 0xf

#define R_AX_SS_TXTIME_LIM 0x9EE0
#define B_AX_SS_RU_TIME_LIM_SH 16
#define B_AX_SS_RU_TIME_LIM_MSK 0x7ff
#define B_AX_SS_MU_TIME_LIM_SH 0
#define B_AX_SS_MU_TIME_LIM_MSK 0x7ff

#define R_AX_SS_FETCH_DLY_0 0x9EE4
#define B_AX_SS_FETCH_DLY_3_SH 24
#define B_AX_SS_FETCH_DLY_3_MSK 0x7f
#define B_AX_SS_FETCH_DLY_2_SH 16
#define B_AX_SS_FETCH_DLY_2_MSK 0x7f
#define B_AX_SS_FETCH_DLY_1_SH 8
#define B_AX_SS_FETCH_DLY_1_MSK 0x7f
#define B_AX_SS_FETCH_DLY_0_SH 0
#define B_AX_SS_FETCH_DLY_0_MSK 0x7f

#define R_AX_SS_FETCH_DLY_1 0x9EE8
#define B_AX_SS_FETCH_DLY_7_SH 24
#define B_AX_SS_FETCH_DLY_7_MSK 0x7f
#define B_AX_SS_FETCH_DLY_6_SH 16
#define B_AX_SS_FETCH_DLY_6_MSK 0x7f
#define B_AX_SS_FETCH_DLY_5_SH 8
#define B_AX_SS_FETCH_DLY_5_MSK 0x7f
#define B_AX_SS_FETCH_DLY_4_SH 0
#define B_AX_SS_FETCH_DLY_4_MSK 0x7f

#define R_AX_SS_DBG 0x9EF8
#define B_AX_SS_DBG_SH 0
#define B_AX_SS_DBG_MSK 0xffffffffL

//
// Tx Packet Controller
//

#define R_AX_TXPKTCTL_COM_CFG 0x9F00
#define B_AX_WDRLS_REASON4_DSTSEL_SH 16
#define B_AX_WDRLS_REASON4_DSTSEL_MSK 0x3
#define B_AX_WDRLS_REASON3_DSTSEL_SH 14
#define B_AX_WDRLS_REASON3_DSTSEL_MSK 0x3
#define B_AX_WDRLS_REASON2_DSTSEL_SH 12
#define B_AX_WDRLS_REASON2_DSTSEL_MSK 0x3
#define B_AX_WDRLS_REASON1_DSTSEL_SH 10
#define B_AX_WDRLS_REASON1_DSTSEL_MSK 0x3
#define B_AX_WDRLS_REASON0_DSTSEL_SH 8
#define B_AX_WDRLS_REASON0_DSTSEL_MSK 0x3
#define B_AX_COM_FSM_FRZTMR_TUSEL_SH 2
#define B_AX_COM_FSM_FRZTMR_TUSEL_MSK 0x3
#define B_AX_COM_CLKFREQ_SEL_SH 0
#define B_AX_COM_CLKFREQ_SEL_MSK 0x3

#define R_AX_TXPKTCTL_COM_ERRCHK_CFG 0x9F04
#define B_AX_COM_EM_1STCMD_IS_END BIT(0)

#define R_AX_TXPKTCTL_B0_CFG 0x9F40

#define R_AX_TXPKTCTL_B0_CTL 0x9F44
#define B_AX_B0_CTLST_IDLE BIT(1)
#define B_AX_B0_STOP_REQ BIT(0)

#define R_AX_TXPKTCTL_B0_PRELD_CFG0 0x9F48
#define B_AX_B0_PRELD_FEN BIT(31)
#define B_AX_B0_PRELD_USEMAXSZ_SH 16
#define B_AX_B0_PRELD_USEMAXSZ_MSK 0x3ff
#define B_AX_B0_PRELD_CAM_G1ENTNUM_SH 8
#define B_AX_B0_PRELD_CAM_G1ENTNUM_MSK 0x1f
#define B_AX_B0_PRELD_CAM_G0ENTNUM_SH 0
#define B_AX_B0_PRELD_CAM_G0ENTNUM_MSK 0x1f

#define R_AX_TXPKTCTL_B0_PRELD_CFG1 0x9F4C
#define B_AX_B0_PRELD_NXT_TXENDWIN_SH 8
#define B_AX_B0_PRELD_NXT_TXENDWIN_MSK 0xf
#define B_AX_B0_PRELD_NXT_RSVMINSZ_SH 0
#define B_AX_B0_PRELD_NXT_RSVMINSZ_MSK 0xff

#define R_AX_TXPKTCTL_B0_ERRINFO_DBGCTL 0x9F74
#define B_AX_B0_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_B0_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_AX_B0_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_AX_B0_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_AX_B0_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_AX_B0_DBGERR_POP_PKTCMD BIT(3)
#define B_AX_B0_DBGERR_LOCKSTS BIT(1)
#define B_AX_B0_DBGERR_LOCKEN BIT(0)

#define R_AX_TXPKTCTL_B0_ERRFLAG_IMR 0x9F78
#define B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B0_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B0_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B0_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B0_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B0_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B0_IMR_ERR_USRCTL_REINIT BIT(0)

#define R_AX_TXPKTCTL_B0_ERRFLAG_ISR 0x9F7C
#define B_AX_B0_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_AX_B0_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_AX_B0_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B0_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B0_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_AX_B0_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B0_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_AX_B0_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B0_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B0_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B0_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B0_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B0_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_AX_B0_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_AX_B0_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_AX_B0_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_AX_B0_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B0_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B0_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B0_ISR_ERR_USRCTL_REINIT BIT(0)

#define R_AX_TXPKTCTL_B1_CFG 0x9F80

#define R_AX_TXPKTCTL_B1_CTL 0x9F84
#define B_AX_B1_CTLST_IDLE BIT(1)
#define B_AX_B1_STOP_REQ BIT(0)

#define R_AX_TXPKTCTL_B1_PRELD_CFG0 0x9F88
#define B_AX_B1_PRELD_FEN BIT(31)
#define B_AX_B1_PRELD_USEMAXSZ_SH 16
#define B_AX_B1_PRELD_USEMAXSZ_MSK 0x3ff
#define B_AX_B1_PRELD_CAM_G1ENTNUM_SH 8
#define B_AX_B1_PRELD_CAM_G1ENTNUM_MSK 0x1f
#define B_AX_B1_PRELD_CAM_G0ENTNUM_SH 0
#define B_AX_B1_PRELD_CAM_G0ENTNUM_MSK 0x1f

#define R_AX_TXPKTCTL_B1_PRELD_CFG1 0x9F8C
#define B_AX_B1_PRELD_NXT_TXENDWIN_SH 8
#define B_AX_B1_PRELD_NXT_TXENDWIN_MSK 0xf
#define B_AX_B1_PRELD_NXT_RSVMINSZ_SH 0
#define B_AX_B1_PRELD_NXT_RSVMINSZ_MSK 0xff

#define R_AX_TXPKTCTL_B1_ERRINFO_DBGCTL 0x9FB4
#define B_AX_B1_ERR_FLAG_NUM1_VLD BIT(31)
#define B_AX_B1_ERR_FLAG_NUM1_MSTIDX_SH 24
#define B_AX_B1_ERR_FLAG_NUM1_MSTIDX_MSK 0xf
#define B_AX_B1_ERR_FLAG_NUM1_ISRIDX_SH 16
#define B_AX_B1_ERR_FLAG_NUM1_ISRIDX_MSK 0x1f
#define B_AX_B1_DBGERR_POP_PKTCMD BIT(3)
#define B_AX_B1_DBGERR_LOCKSTS BIT(1)
#define B_AX_B1_DBGERR_LOCKEN BIT(0)

#define R_AX_TXPKTCTL_B1_ERRFLAG_IMR 0x9FB8
#define B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B1_IMR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B1_IMR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B1_IMR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B1_IMR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B1_IMR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B1_IMR_ERR_USRCTL_REINIT BIT(0)

#define R_AX_TXPKTCTL_B1_ERRFLAG_ISR 0x9FBC
#define B_AX_B1_ISR_ERR_PRELD_EVT3 BIT(23)
#define B_AX_B1_ISR_ERR_PRELD_EVT2 BIT(22)
#define B_AX_B1_ISR_ERR_PRELD_ENTNUMCFG BIT(21)
#define B_AX_B1_ISR_ERR_PRELD_RLSPKTSZERR BIT(20)
#define B_AX_B1_ISR_ERR_MPDUIF_ERR1 BIT(19)
#define B_AX_B1_ISR_ERR_MPDUIF_DATAERR BIT(18)
#define B_AX_B1_ISR_ERR_MPDUINFO_ERR1 BIT(17)
#define B_AX_B1_ISR_ERR_MPDUINFO_RECFG BIT(16)
#define B_AX_B1_ISR_ERR_CMDPSR_TBLSZ BIT(11)
#define B_AX_B1_ISR_ERR_CMDPSR_FRZTO BIT(10)
#define B_AX_B1_ISR_ERR_CMDPSR_CMDTYPE BIT(9)
#define B_AX_B1_ISR_ERR_CMDPSR_1STCMDERR BIT(8)
#define B_AX_B1_ISR_ERR_USRCTL_EVT7 BIT(7)
#define B_AX_B1_ISR_ERR_USRCTL_EVT6 BIT(6)
#define B_AX_B1_ISR_ERR_USRCTL_EVT5 BIT(5)
#define B_AX_B1_ISR_ERR_USRCTL_EVT4 BIT(4)
#define B_AX_B1_ISR_ERR_USRCTL_RLSBMPLEN BIT(3)
#define B_AX_B1_ISR_ERR_USRCTL_RDNRLSCMD BIT(2)
#define B_AX_B1_ISR_ERR_USRCTL_NOINIT BIT(1)
#define B_AX_B1_ISR_ERR_USRCTL_REINIT BIT(0)

//
// HCI common
//

#define R_AX_RXAGG_0_V1 0x6000

#define R_AX_RXAGG_1_V1 0x6004
#define B_AX_RXAGG_LEN_TH_HIGH_V1_SH 16
#define B_AX_RXAGG_LEN_TH_HIGH_V1_MSK 0x3
#define B_AX_RXAGG_SML_PKT_SIZE_V1_SH 5
#define B_AX_RXAGG_SML_PKT_SIZE_V1_MSK 0x7

#define R_AX_APB_BB 0x6010
#define B_AX_APB_CLR BIT(31)
#define B_AX_AXI_CLR BIT(30)
#define B_AX_RX_LEN_RCLR BIT(6)
#define B_AX_RX_LEN_WCLR BIT(5)
#define B_AX_RX_DATA_FIFO_RST BIT(4)
#define B_AX_PG_256_MODE BIT(2)
#define B_AX_AXI_B2B_MODE BIT(1)
#define B_AX_APB_BB_MODE BIT(0)

#define R_AX_TXBD_APB 0x6014
#define B_AX_AVLPG_FIFO_OVERFLOW BIT(31)
#define B_AX_AVLPG_FIFO_UNDERFLOW BIT(30)
#define B_AX_AXI_RCMD_ERR BIT(9)
#define B_AX_AXI_R_TIMEOUT BIT(8)
#define B_AX_USB_BULK_PG_ERR BIT(1)
#define B_AX_TXBD_APB_TIMEOUT BIT(0)

#define R_AX_HCI_BUF_IMR 0x6018
#define B_AX_HCI_BUF_IMR_SH 0
#define B_AX_HCI_BUF_IMR_MSK 0xffffffffL

#define R_AX_TX_APB 0x601C
#define B_AX_AVLPG_INIT_SW_RST BIT(20)
#define B_AX_AVLPG_FIFO_PTR_CLR BIT(19)
#define B_AX_AXI_RCMD_CLR BIT(16)
#define B_AX_TX_ARB_CLR BIT(12)
#define B_AX_TX_FIFO_PTR_CLR BIT(8)
#define B_AX_TX_APB_TIMEOUT_TH_SH 0
#define B_AX_TX_APB_TIMEOUT_TH_MSK 0xff

#define R_AX_AXI_ARID 0x6024
#define B_AX_AXI_ARID_ERR_EN BIT(31)
#define B_AX_AXI_ARADDR_ERR_EN BIT(30)
#define B_AX_AXI_ARLEN_ERR_RN BIT(29)

#define R_AX_AXI_R_TIMEOUT 0x602C
#define B_AX_AXI_R_TIMEOUT_TH_SH 24
#define B_AX_AXI_R_TIMEOUT_TH_MSK 0xff

#define R_AX_AXI_RTRANS 0x6030
#define B_AX_AXI_RCMD_CNT_SH 16
#define B_AX_AXI_RCMD_CNT_MSK 0xffff
#define B_AX_AXI_RTRANS_CNT_SH 0
#define B_AX_AXI_RTRANS_CNT_MSK 0xffff

#define R_AX_APB 0x6034
#define B_AX_APB_BULK_PG_CNT_SEL_SH 29
#define B_AX_APB_BULK_PG_CNT_SEL_MSK 0x7
#define B_AX_APB_PKT_PG_CNT_SEL_SH 13
#define B_AX_APB_PKT_PG_CNT_SEL_MSK 0x7

#define R_AX_USB_ERR_IND 0x6038
#define B_AX_ERR_USB_BULK_PG_CNT_SEL_SH 20
#define B_AX_ERR_USB_BULK_PG_CNT_SEL_MSK 0x7
#define B_AX_USB_CH6_BULK_PG_ERR BIT(6)
#define B_AX_USB_CH5_BULK_PG_ERR BIT(5)
#define B_AX_USB_CH4_BULK_PG_ERR BIT(4)
#define B_AX_USB_CH3_BULK_PG_ERR BIT(3)
#define B_AX_USB_CH2_BULK_PG_ERR BIT(2)
#define B_AX_USB_CH1_BULK_PG_ERR BIT(1)
#define B_AX_USB_CH0_BULK_PG_ERR BIT(0)

#define R_AX_HCI_BUF 0x6040
#define B_AX_HCI_BUF_DBESEL1_SH 8
#define B_AX_HCI_BUF_DBESEL1_MSK 0x1f
#define B_AX_HCI_BUF_DBESEL0_SH 0
#define B_AX_HCI_BUF_DBESEL0_MSK 0x1f

#define R_AX_AVLPG 0x6050
#define B_AX_AVLPG_TOTAL_DEC1_SH 0
#define B_AX_AVLPG_TOTAL_DEC1_MSK 0xf

//
// WL_AX_REG_DMAC.xls
//

//
// TOP_OFF
//

#define R_AX_I2C_MAILBOX 0x7028
#define B_AX_I2C_M_STATUS_SH 12
#define B_AX_I2C_M_STATUS_MSK 0xf
#define B_AX_I2C_M_BUS_GNT_FW_SH 8
#define B_AX_I2C_M_BUS_GNT_FW_MSK 0x7
#define B_AX_I2C_M_GNT_FW BIT(7)
#define B_AX_I2C_M_SPEED_SH 5
#define B_AX_I2C_M_SPEED_MSK 0x3
#define B_AX_I2C_M_UNLOCK BIT(4)
#define B_AX_I2C_MAILBOX_EN BIT(0)
#define B_AX_FS_I2C_MAILBOX_INT_EN BIT(9)
#define B_AX_FS_I2C_MAILBOX_INT BIT(9)
#define B_AX_BIST_RST_N_USB_V2_SH 0
#define B_AX_BIST_RST_N_USB_V2_MSK 0xfffff
#define B_AX_BIST_DONE_USB_V2_SH 0
#define B_AX_BIST_DONE_USB_V2_MSK 0xfffff
#define B_AX_BIST_FAIL_USB_V2_SH 0
#define B_AX_BIST_FAIL_USB_V2_MSK 0xfffff
#define B_AX_BIST_DRF_PAUSE_USB_V2_SH 0
#define B_AX_BIST_DRF_PAUSE_USB_V2_MSK 0xfffff

#define R_AX_PARAM_HCIBUF_BIST_RSTN 0x7230
#define B_AX_BIST_RST_N_HCIBUF_SH 0
#define B_AX_BIST_RST_N_HCIBUF_MSK 0x3

#define R_AX_PARAM_HCIBUF_BIST_DONE 0x7234
#define B_AX_BIST_DONE_HCIBUF_SH 0
#define B_AX_BIST_DONE_HCIBUF_MSK 0x3

#define R_AX_PARAM_HCIBUF_BIST_FAIL 0x7238
#define B_AX_BIST_FAIL_HCIBUF_SH 0
#define B_AX_BIST_FAIL_HCIBUF_MSK 0x3

#define R_AX_PARAM_HCIBUF_DRF_PAUSE 0x723C
#define B_AX_BIST_DRF_PAUSE_HCIBUF_SH 0
#define B_AX_BIST_DRF_PAUSE_HCIBUF_MSK 0x3

//
// WL_PON
//

//
// COMMON
//

//
// Dispatcher
//

//
// WDE_DLE
//

//
// PLE_DLE
//

//
// WDRLS
//

//
// BBRPT
//

//
// CPUIO
//

//
// PKTIN
//

//
// MPDU_Processor_1
//

//
// MPDU_Processor_2
//

//
// SEC_ENG
//

//
// STA scheduler
//

//
// Tx Packet Controller
//

//
// HCI common
//

//
// WL_AX_Reg_AON.xls
//

//
// AON
//

#define R_AX_SYS_ISO_CTRL 0x0000
#define B_AX_PWC_EV2EF_SH 14
#define B_AX_PWC_EV2EF_MSK 0x3
#define B_AX_PA33V_EN BIT(13)
#define B_AX_PA12V_EN BIT(12)
#define B_AX_UA33V_EN BIT(11)
#define B_AX_UA12V_EN BIT(10)
#define B_AX_ISO_RFDIO BIT(9)
#define B_AX_ISO_EB2CORE BIT(8)
#define B_AX_ISO_DIOE BIT(7)
#define B_AX_ISO_WLPON2PP BIT(6)
#define B_AX_ISO_IP2MAC_WA2PP BIT(5)
#define B_AX_ISO_PD2CORE BIT(4)
#define B_AX_ISO_PA2PCIE BIT(3)
#define B_AX_ISO_UD2CORE BIT(2)
#define B_AX_ISO_UA2USB BIT(1)
#define B_AX_ISO_WD2PP BIT(0)

#define R_AX_SYS_FUNC_EN 0x0002
#define B_AX_FEN_MREGEN BIT(15)
#define B_AX_FEN_HWPDN BIT(14)
#define B_AX_FEN_ELDR BIT(12)
#define B_AX_FEN_DCORE BIT(11)
#define B_AX_FEN_DIOE BIT(9)
#define B_AX_FEN_PCIED BIT(8)
#define B_AX_FEN_PPLL BIT(7)
#define B_AX_FEN_PCIEA BIT(6)
#define B_AX_FEN_USBD BIT(4)
#define B_AX_FEN_UPLL BIT(3)
#define B_AX_FEN_USBA BIT(2)
#define B_AX_FEN_BB_GLB_RSTN BIT(1)
#define B_AX_FEN_BBRSTB BIT(0)

#define R_AX_SYS_PW_CTRL 0x0004
#define B_AX_SOP_ASWRM BIT(31)
#define B_AX_SOP_EASWR BIT(30)
#define B_AX_SOP_PWMM_DSWR BIT(29)
#define B_AX_SOP_EDSWR BIT(28)
#define B_AX_SOP_ACKF BIT(27)
#define B_AX_SOP_ERCK BIT(26)
#define B_AX_SOP_ANA_CLK_DIVISION_2 BIT(25)
#define B_AX_SOP_EXTL BIT(24)
#define B_AX_ROP_SWPR BIT(21)
#define B_AX_DIS_HW_LPLDM BIT(20)
#define B_AX_RDY_SYSPWR BIT(17)
#define B_AX_EN_WLON BIT(16)
#define B_AX_APDM_HPDN BIT(15)
#define B_AX_AFSM_PCIE_SUS_EN BIT(12)
#define B_AX_AFSM_WLSUS_EN BIT(11)
#define B_AX_APFM_SWLPS BIT(10)
#define B_AX_APFM_OFFMAC BIT(9)
#define B_AX_APFN_ONMAC BIT(8)
#define B_AX_CHIP_PDN_EN BIT(7)
#define B_AX_RDY_MACDIS BIT(6)
#define B_AX_SW_AFE_MODE BIT(4)
#define B_AX_PFM_WOWL BIT(3)
#define B_AX_WL_HCI_ALD BIT(1)
#define B_AX_EFUSE_LDALL BIT(0)

#define R_AX_SYS_CLK_CTRL 0x0008
#define B_AX_CPU_IDMEM_CLK_EN BIT(15)
#define B_AX_CPU_CLK_EN BIT(14)
#define B_AX_SYMR_AX_CLK_EN BIT(13)
#define B_AX_MAC_CLK_EN BIT(11)
#define B_AX_EXT_32K_EN BIT(8)
#define B_AX_WL_CLK_TEST BIT(7)
#define B_AX_LOADER_CLK_EN BIT(5)
#define B_AX_ANA_CLK_DIVISION_2 BIT(1)
#define B_AX_CNTD16V_EN BIT(0)

#define R_AX_SYS_WL_EFUSE_CTRL 0x000A
#define B_AX_AUTOLOAD_SUS BIT(5)

#define R_AX_SYS_PAGE_CLK_GATED 0x000C
#define B_AX_DIS_CLK_REGF_GATE BIT(15)
#define B_AX_DIS_CLK_REGE_GATE BIT(14)
#define B_AX_DIS_CLK_REGD_GATE BIT(13)
#define B_AX_DIS_CLK_REGC_GATE BIT(12)
#define B_AX_DIS_CLK_REGB_GATE BIT(11)
#define B_AX_DIS_CLK_REGA_GATE BIT(10)
#define B_AX_DIS_CLK_REG9_GATE BIT(9)
#define B_AX_DIS_CLK_REG8_GATE BIT(8)
#define B_AX_DIS_CLK_REG7_GATE BIT(7)
#define B_AX_DIS_CLK_REG6_GATE BIT(6)
#define B_AX_DIS_CLK_REG5_GATE BIT(5)
#define B_AX_DIS_CLK_REG4_GATE BIT(4)
#define B_AX_DIS_CLK_REG3_GATE BIT(3)
#define B_AX_DIS_CLK_REG2_GATE BIT(2)
#define B_AX_DIS_CLK_REG1_GATE BIT(1)
#define B_AX_DIS_CLK_REG0_GATE BIT(0)

#define R_AX_SYS_SWR_CTRL1 0x0010
#define B_AX_SYM_CTRL_SPSANA_PWMFREQ BIT(11)
#define B_AX_SYM_CTRL_SPS_PWMFREQ BIT(10)
#define B_AX_HW_AUTO_CTRL_EXT_SWR BIT(9)
#define B_AX_USE_INTERNAL_SWR_AND_LDO BIT(8)
#define B_AX_MAC_ID_EN BIT(7)
#define B_AX_OPTION_DIS_XTAL_BG BIT(2)

#define R_AX_ANAPARSW_POW_MAC 0x0014
#define B_AX_POW_LDO15 BIT(2)
#define B_AX_POW_SW_SPSANA BIT(1)
#define B_AX_POW_LDO14_SPSANA BIT(0)

#define R_AX_ANAPARLDO_POW_MAC 0x0015
#define B_AX_R_PD12_N_LDO BIT(5)
#define B_AX_POW_SW_SPSDIG BIT(1)
#define B_AX_POW_LDO14_SPSDIG BIT(0)

#define R_AX_ANAPAR_POW_MAC 0x0016
#define B_AX_POW_PC_LDO_PORT1 BIT(3)
#define B_AX_POW_PC_LDO_PORT0 BIT(2)
#define B_AX_POW_PLL_V1 BIT(1)
#define B_AX_POW_POWER_CUT_POW_LDO BIT(0)

#define R_AX_ANAPAR_POW_XTAL 0x0017
#define B_AX_POW_XTAL BIT(1)
#define B_AX_POW_BG BIT(0)

#define R_AX_RSV_CTRL 0x001C
#define B_AX_HR_AX_DBG_SH 12
#define B_AX_HR_AX_DBG_MSK 0xfff
#define B_AX_R_EN_HRST_PWRON BIT(8)
#define B_AX_LOCK_ALL_EN BIT(7)
#define B_AX_R_DIS_PRST BIT(6)
#define B_AX_WLOCK_1C_BIT6 BIT(5)
#define B_AX_WLOCK_40 BIT(4)
#define B_AX_WLOCK_08 BIT(3)
#define B_AX_WLOCK_04 BIT(2)
#define B_AX_WLOCK_00 BIT(1)
#define B_AX_WLOCK_ALL BIT(0)

#define R_AX_RF_CTRL 0x001F

#define R_AX_AFE_LDO_CTRL 0x0020
#define B_AX_R_SYM_WLPOFF_P4_PC_EN BIT(28)
#define B_AX_R_SYM_WLPOFF_P3_PC_EN BIT(27)
#define B_AX_R_SYM_WLPOFF_P2_PC_EN BIT(26)
#define B_AX_R_SYM_WLPOFF_P1_PC_EN BIT(25)
#define B_AX_R_SYM_WLPOFF_PC_EN BIT(24)
#define B_AX_AON_OFF_PC_EN BIT(23)
#define B_AX_R_SYM_WLPON_P3_PC_EN BIT(21)
#define B_AX_R_SYM_WLPON_P2_PC_EN BIT(20)
#define B_AX_R_SYM_WLPON_P1_PC_EN BIT(19)
#define B_AX_R_SYM_WLPON_PC_EN BIT(18)
#define B_AX_R_SYM_DIS_WPHYBBOFF_PC BIT(10)
#define B_AX_R_SYM_WLBBOFF1_P4_PC_EN BIT(9)
#define B_AX_R_SYM_WLBBOFF1_P3_PC_EN BIT(8)
#define B_AX_R_SYM_WLBBOFF1_P2_PC_EN BIT(7)
#define B_AX_R_SYM_WLBBOFF1_P1_PC_EN BIT(6)
#define B_AX_R_SYM_WLBBOFF_P4_PC_EN BIT(4)
#define B_AX_R_SYM_WLBBOFF_P3_PC_EN BIT(3)
#define B_AX_R_SYM_WLBBOFF_P2_PC_EN BIT(2)
#define B_AX_R_SYM_WLBBOFF_P1_PC_EN BIT(1)
#define B_AX_R_SYM_WLBBOFF_PC_EN BIT(0)

#define R_AX_AFE_CTRL1 0x0024
#define B_AX_WLCPU_CLK_SEL_SH 22
#define B_AX_WLCPU_CLK_SEL_MSK 0x3
#define B_AX_CMAC_CLK_SEL BIT(21)
#define B_AX_PLL_DIV_SEL BIT(20)
#define B_AX_DMEM3_PC_EN BIT(15)
#define B_AX_DMEM2_PC_EN BIT(14)
#define B_AX_DMEM1_PC_EN BIT(13)
#define B_AX_IMEM4_PC_EN BIT(12)
#define B_AX_IMEM3_PC_EN BIT(11)
#define B_AX_IMEM2_PC_EN BIT(10)
#define B_AX_IMEM1_PC_EN BIT(9)
#define B_AX_IMEM0_PC_EN BIT(8)
#define B_AX_R_SYM_WLCMAC1_P4_PC_EN BIT(4)
#define B_AX_R_SYM_WLCMAC1_P3_PC_EN BIT(3)
#define B_AX_R_SYM_WLCMAC1_P2_PC_EN BIT(2)
#define B_AX_R_SYM_WLCMAC1_P1_PC_EN BIT(1)
#define B_AX_R_SYM_WLCMAC1_PC_EN BIT(0)

#define R_AX_SYS_OCP_CTRL 0x0028
#define B_AX_SPS_OCP_DIS BIT(31)
#define B_AX_SPS_OCP_TH_SH 16
#define B_AX_SPS_OCP_TH_MSK 0x7fff
#define B_AX_OCP_WINDOW_SH 0
#define B_AX_OCP_WINDOW_MSK 0xffff

#define R_AX_SYSANA_OCP_CTRL 0x002C
#define B_AX_SPSANA_OCP_DIS BIT(31)
#define B_AX_SPSANA_OCP_TH_SH 16
#define B_AX_SPSANA_OCP_TH_MSK 0x7fff
#define B_AX_OCPANA_WINDOW_SH 0
#define B_AX_OCPANA_WINDOW_MSK 0xffff

#define R_AX_EFUSE_CTRL 0x0030
#define B_AX_EF_MODE_SEL_SH 30
#define B_AX_EF_MODE_SEL_MSK 0x3
#define B_AX_EF_RDY BIT(29)
#define B_AX_EF_COMP_RESULT BIT(28)
#define B_AX_EF_ADDR_SH 16
#define B_AX_EF_ADDR_MSK 0x7ff
#define B_AX_EF_DATA_SH 0
#define B_AX_EF_DATA_MSK 0xffff

#define R_AX_EFUSE_TEST 0x0034
#define B_AX_EF_CRES_SEL BIT(31)
#define B_AX_EF_SCAN_SADR_SH 19
#define B_AX_EF_SCAN_SADR_MSK 0x7ff
#define B_AX_EF_SCAN_EADR_SH 8
#define B_AX_EF_SCAN_EADR_MSK 0x7ff
#define B_AX_EF_SCAN_TRPT BIT(7)
#define B_AX_EF_SCAN_FTHR_SH 0
#define B_AX_EF_SCAN_FTHR_MSK 0x7f

#define R_AX_EFUSE_CTRL_1 0x0038
#define B_AX_EF_PGPD_SH 28
#define B_AX_EF_PGPD_MSK 0x7
#define B_AX_EF_RDT BIT(27)
#define B_AX_EF_VDDQST_SH 24
#define B_AX_EF_VDDQST_MSK 0x7
#define B_AX_EF_PGTS_SH 20
#define B_AX_EF_PGTS_MSK 0xf
#define B_AX_EF_PD_DIS BIT(11)
#define B_AX_EF_POR BIT(10)
#define B_AX_EF_CELL_SEL_SH 8
#define B_AX_EF_CELL_SEL_MSK 0x3

#define R_AX_GPIO_MUXCFG 0x0040
#define B_AX_BOOT_MODE BIT(19)
#define B_AX_WL_EECS_EXT_32K_SEL BIT(18)
#define B_AX_WL_SEC_BONDING_OPT_STS BIT(17)
#define B_AX_SECSIC_SEL BIT(16)
#define B_AX_ENHTP BIT(14)
#define B_AX_ENSIC BIT(12)
#define B_AX_SIC_SWRST BIT(11)
#define B_AX_PO_WIFI_PTA_PINS BIT(10)
#define B_AX_PO_BT_PTA_PINS BIT(9)
#define B_AX_ENUARTTX BIT(8)
#define B_AX_BTMODE_SH 6
#define B_AX_BTMODE_MSK 0x3
#define B_AX_ENBT BIT(5)
#define B_AX_ENUARTRX BIT(2)
#define B_AX_GPIOSEL_SH 0
#define B_AX_GPIOSEL_MSK 0x3

#define R_AX_GPIO_PIN_CTRL 0x0044
#define B_AX_GPIO_MOD_7_TO_0_SH 24
#define B_AX_GPIO_MOD_7_TO_0_MSK 0xff
#define B_AX_GPIO_IO_SEL_7_TO_0_SH 16
#define B_AX_GPIO_IO_SEL_7_TO_0_MSK 0xff
#define B_AX_GPIO_OUT_7_TO_0_SH 8
#define B_AX_GPIO_OUT_7_TO_0_MSK 0xff
#define B_AX_GPIO_IN_7_TO_0_SH 0
#define B_AX_GPIO_IN_7_TO_0_MSK 0xff

#define R_AX_GPIO_INTM 0x0048
#define B_AX_EXTWOL_SEL BIT(17)
#define B_AX_EXTWOL_EN BIT(16)
#define B_AX_GPIOF_INT_MD BIT(15)
#define B_AX_GPIOE_INT_MD BIT(14)
#define B_AX_GPIOD_INT_MD BIT(13)
#define B_AX_GPIOC_INT_MD BIT(12)
#define B_AX_GPIOB_INT_MD BIT(11)
#define B_AX_GPIOA_INT_MD BIT(10)
#define B_AX_GPIO9_INT_MD BIT(9)
#define B_AX_GPIO8_INT_MD BIT(8)
#define B_AX_GPIO7_INT_MD BIT(7)
#define B_AX_GPIO6_INT_MD BIT(6)
#define B_AX_GPIO5_INT_MD BIT(5)
#define B_AX_GPIO4_INT_MD BIT(4)
#define B_AX_GPIO3_INT_MD BIT(3)
#define B_AX_GPIO2_INT_MD BIT(2)
#define B_AX_GPIO1_INT_MD BIT(1)
#define B_AX_GPIO0_INT_MD BIT(0)

#define R_AX_LED_CFG 0x004C
#define B_AX_MAILBOX_1WIRE_GPIO_CFG BIT(31)
#define B_AX_BT_RF_GPIO_CFG BIT(30)
#define B_AX_BT_SDIO_INT_GPIO_CFG BIT(29)
#define B_AX_MAILBOX_3WIRE_GPIO_CFG BIT(28)
#define B_AX_GPIO13_14_WL_CTRL_EN BIT(22)
#define B_AX_LED2DIS BIT(21)
#define B_AX_LED2PL BIT(20)
#define B_AX_LED2SV BIT(19)
#define B_AX_LED2CM_SH 16
#define B_AX_LED2CM_MSK 0x7
#define B_AX_LED0LED1_RD_ONLY_SH 13
#define B_AX_LED0LED1_RD_ONLY_MSK 0x3

#define R_AX_PWR_OPTION_CTRL 0x0050
#define B_AX_DIS_LPS_WT_PDNSUS BIT(24)
#define B_AX_SYSON_DBG_PAD_E2 BIT(11)
#define B_AX_SYSON_LED_PAD_E2 BIT(10)
#define B_AX_SYSON_GPEE_PAD_E2 BIT(9)
#define B_AX_SYSON_PCI_PAD_E2 BIT(8)
#define B_AX_SYSON_WLPC_IDX_SH 6
#define B_AX_SYSON_WLPC_IDX_MSK 0x3
#define B_AX_SYSON_SPS0WWV_WT_SH 4
#define B_AX_SYSON_SPS0WWV_WT_MSK 0x3
#define B_AX_SYSON_SPS0LDO_WT_SH 2
#define B_AX_SYSON_SPS0LDO_WT_MSK 0x3
#define B_AX_SYSON_RCLK_SCALE_SH 0
#define B_AX_SYSON_RCLK_SCALE_MSK 0x3

#define R_AX_CAL_TIMER 0x0054
#define B_AX_UART_TX_SEL_SH 30
#define B_AX_UART_TX_SEL_MSK 0x3
#define B_AX_UART_RX_SEL BIT(29)
#define B_AX_CAL_SCAL_SH 0
#define B_AX_CAL_SCAL_MSK 0xffff

#define R_AX_DBG_CTRL 0x0058
#define B_AX_DBG_SEL1_4BIT_SH 30
#define B_AX_DBG_SEL1_4BIT_MSK 0x3
#define B_AX_DBG_SEL1_16BIT BIT(27)
#define B_AX_DBG_SEL1_SH 16
#define B_AX_DBG_SEL1_MSK 0xff
#define B_AX_DBG_SEL0_4BIT_SH 14
#define B_AX_DBG_SEL0_4BIT_MSK 0x3
#define B_AX_DBG_SEL0_16BIT BIT(11)
#define B_AX_DBG_SEL0_SH 0
#define B_AX_DBG_SEL0_MSK 0xff

#define R_AX_PWR_CUT_CTRL 0x005C
#define B_AX_WLBBPC1_WT_SH 24
#define B_AX_WLBBPC1_WT_MSK 0xff
#define B_AX_WLBBPC0_WT_SH 16
#define B_AX_WLBBPC0_WT_MSK 0xff
#define B_AX_WLMACPC1_WT_SH 12
#define B_AX_WLMACPC1_WT_MSK 0xf
#define B_AX_WLMACPC0_WT_SH 8
#define B_AX_WLMACPC0_WT_MSK 0xf
#define B_AX_WLPONPC1_WT_SH 4
#define B_AX_WLPONPC1_WT_MSK 0xf
#define B_AX_WLPONPC0_WT_SH 0
#define B_AX_WLPONPC0_WT_MSK 0xf

#define R_AX_GPIO_EXT_CTRL 0x0060
#define B_AX_GPIO_MOD_15_TO_8_SH 24
#define B_AX_GPIO_MOD_15_TO_8_MSK 0xff
#define B_AX_GPIO_IO_SEL_15_TO_8_SH 16
#define B_AX_GPIO_IO_SEL_15_TO_8_MSK 0xff
#define B_AX_GPIO_OUT_15_TO_8_SH 8
#define B_AX_GPIO_OUT_15_TO_8_MSK 0xff
#define B_AX_GPIO_IN_15_TO_8_SH 0
#define B_AX_GPIO_IN_15_TO_8_MSK 0xff

#define R_AX_PAD_CTRL1 0x0064
#define B_AX_BT_BQB_GPIO_SEL BIT(27)
#define B_AX_BTGP_GPG3_FEN BIT(26)
#define B_AX_BTGP_GPG2_FEN BIT(25)
#define B_AX_BTGP_JTAG_EN BIT(24)
#define B_AX_XTAL_CLK_EXTARNAL_EN BIT(23)
#define B_AX_BTGP_UART0_EN BIT(22)
#define B_AX_BTGP_UART1_EN BIT(21)
#define B_AX_BTGP_SPI_EN BIT(20)
#define B_AX_BTGP_GPIO_E2 BIT(19)
#define B_AX_BTGP_GPIO_EN BIT(18)
#define B_AX_BTGP_GPIO_SL_SH 16
#define B_AX_BTGP_GPIO_SL_MSK 0x3
#define B_AX_WL_JTAG_EN BIT(15)
#define B_AX_PAD_SDIO_SR BIT(14)
#define B_AX_GPIO14_OUTPUT_PL BIT(13)
#define B_AX_HOST_WAKE_PAD_PULL_EN BIT(12)
#define B_AX_HOST_WAKE_PAD_SL BIT(11)

#define R_AX_WL_BT_PWR_CTRL 0x0068
#define B_AX_ISO_BD2PP BIT(31)
#define B_AX_LDOV12B_EN BIT(30)
#define B_AX_CKEN_BT BIT(29)
#define B_AX_FEN_BT BIT(28)
#define B_AX_BTCPU_BOOTSEL BIT(27)
#define B_AX_SPI_SPEEDUP BIT(26)
#define B_AX_BT_LDO_MODE BIT(25)
#define B_AX_DEVWAKE_PAD_TYPE_SEL BIT(24)
#define B_AX_CLKREQ_PAD_TYPE_SEL BIT(23)
#define B_AX_ISO_BTPON2PP BIT(22)
#define B_AX_BT_HWROF_EN BIT(19)
#define B_AX_BT_FUNC_EN BIT(18)
#define B_AX_BT_HWPDN_SL BIT(17)
#define B_AX_BT_DISN_EN BIT(16)
#define B_AX_BT_PDN_PULL_EN BIT(15)
#define B_AX_WL_PDN_PULL_EN BIT(14)
#define B_AX_EXTERNAL_REQUEST_PL BIT(13)
#define B_AX_GPIO0_2_3_PULL_LOW_EN BIT(12)
#define B_AX_ISO_BA2PP BIT(11)
#define B_AX_BT_AFE_LDO_EN BIT(10)
#define B_AX_BT_AFE_PLL_EN BIT(9)
#define B_AX_WLAN_32K_SEL BIT(6)
#define B_AX_WL_DRV_EXIST_IDX BIT(5)
#define B_AX_DOP_EHPAD BIT(4)
#define B_AX_WL_HWROF_EN BIT(3)
#define B_AX_WL_FUNC_EN BIT(2)
#define B_AX_WL_HWPDN_SL BIT(1)
#define B_AX_WL_HWPDN_EN BIT(0)

#define R_AX_SDM_DEBUG 0x006C
#define B_AX_GPIO_IE_V18 BIT(10)
#define B_AX_PCIE_IE_V18 BIT(9)
#define B_AX_UART_IE_V18 BIT(8)

#define R_AX_SYS_SDIO_CTRL 0x0070
#define B_AX_DBG_GNT_WL_BT BIT(27)
#define B_AX_LTE_MUX_CTRL_PATH BIT(26)
#define B_AX_SDIO_INT_POLARITY BIT(19)
#define B_AX_SDIO_INT BIT(18)
#define B_AX_SDIO_OFF_EN BIT(17)
#define B_AX_SDIO_ON_EN BIT(16)
#define B_AX_PCIE_FORCE_PWR_NGAT BIT(13)
#define B_AX_PCIE_FORCE_IBX_EN_V1 BIT(12)
#define B_AX_PCIE_AUXCLK_GATE BIT(11)
#define B_AX_PCIE_WAIT_TIMEOUT_EVENT BIT(10)
#define B_AX_PCIE_WAIT_TIME BIT(9)
#define B_AX_USBA_FORCE_PWR_NGAT BIT(7)
#define B_AX_USBD_FORCE_PWR_NGAT BIT(6)
#define B_AX_BT_CTRL_USB_PWR BIT(5)
#define B_AX_USB_D_STATE_HOLD BIT(4)
#define B_AX_R_AX_FORCE_DP BIT(3)
#define B_AX_R_AX_DP_MODE BIT(2)
#define B_AX_RES_USB_MASS_STORAGE_DESC BIT(1)
#define B_AX_USB_WAIT_TIME BIT(0)

#define R_AX_HCI_OPT_CTRL 0x0074
#define B_AX_PCIE_CPHY_CCK_XTAL_SEL BIT(20)
#define B_AX_SDIO_DATA_PAD_SMT BIT(19)
#define B_AX_SDIO_PAD_E5 BIT(18)
#define B_AX_NOPWR_CTRL_SEL BIT(13)
#define B_AX_USB_HOST_PWR_OFF_EN BIT(12)
#define B_AX_SYM_LPS_BLOCK_EN BIT(11)
#define B_AX_USB_LPM_ACT_EN BIT(10)
#define B_AX_USB_LPM_NY BIT(9)
#define B_AX_USB2_SUS_DIS BIT(8)
#define B_AX_SDIO_PAD_E_SH 5
#define B_AX_SDIO_PAD_E_MSK 0x7
#define B_AX_USB_LPPLL_EN BIT(4)
#define B_AX_USB1_1_USB2_0_DECISION BIT(3)
#define B_AX_ROP_SW15 BIT(2)
#define B_AX_PCI_CKRDY_OPT BIT(1)
#define B_AX_PCI_VAUX_EN BIT(0)

#define R_AX_HCI_BG_CTRL 0x0078
#define B_AX_IBX_EN_VALUE BIT(15)
#define B_AX_IB_EN_VALUE BIT(14)
#define B_AX_FORCED_IB_EN BIT(4)
#define B_AX_EN_REGBG BIT(3)
#define B_AX_R_AX_BG_LPF BIT(2)
#define B_AX_R_AX_BG_SH 0
#define B_AX_R_AX_BG_MSK 0x3

#define R_AX_HCI_LDO_CTRL 0x007A
#define B_AX_EN_LW_PWR BIT(6)
#define B_AX_EN_REGU BIT(5)
#define B_AX_EN_PC BIT(4)
#define B_AX_R_AX_VADJ_SH 0
#define B_AX_R_AX_VADJ_MSK 0xf

#define R_AX_LDO_SWR_CTRL 0x007C
#define B_AX_DIG_ZCD_HW_AUTO_EN BIT(27)
#define B_AX_DIG_ZCD_REGSEL BIT(26)
#define B_AX_DIG_AUTO_ZCD_IN_CODE_SH 21
#define B_AX_DIG_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_AX_DIG_ZCD_CODE_IN_L_SH 16
#define B_AX_DIG_ZCD_CODE_IN_L_MSK 0x1f
#define B_AX_ANA_ZCD_HW_AUTO_EN BIT(11)
#define B_AX_ANA_ZCD_REGSEL BIT(10)
#define B_AX_ANA_AUTO_ZCD_IN_CODE_SH 5
#define B_AX_ANA_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_AX_ANA_ZCD_CODE_IN_L_SH 0
#define B_AX_ANA_ZCD_CODE_IN_L_MSK 0x1f

#define R_AX_SYS_ISO_CTRL_EXTEND 0x0080
#define B_AX_R_SYM_FEN_WLMACOFF BIT(31)
#define B_AX_CMAC1_FEN BIT(30)
#define B_AX_R_SYM_ISO_DMEM32PP BIT(28)
#define B_AX_R_SYM_ISO_DMEM22PP BIT(27)
#define B_AX_R_SYM_ISO_DMEM12PP BIT(26)
#define B_AX_R_SYM_ISO_IMEM42PP BIT(22)
#define B_AX_R_SYM_ISO_IMEM32PP BIT(21)
#define B_AX_R_SYM_ISO_IMEM22PP BIT(20)
#define B_AX_R_SYM_ISO_IMEM12PP BIT(19)
#define B_AX_R_SYM_ISO_IMEM02PP BIT(18)
#define B_AX_R_SYM_FEN_WLBBGLB_1 BIT(17)
#define B_AX_R_SYM_FEN_WLBBFUN_1 BIT(16)
#define B_AX_R_SYM_ISO_AON_OFF2PP BIT(15)
#define B_AX_R_SYM_PWC_PD12V BIT(12)
#define B_AX_R_SYM_PWC_UD12V BIT(11)
#define B_AX_R_SYM_LDOBTSDIO_EN BIT(9)
#define B_AX_R_SYM_LDOSPDIO_EN BIT(8)
#define B_AX_R_SYM_ISO_BB2PP BIT(7)
#define B_AX_R_SYM_ISO_DENG2PP BIT(6)
#define B_AX_R_SYM_ISO_CMAC12PP BIT(5)
#define B_AX_R_SYM_ISO_BTSDIO2PP BIT(1)
#define B_AX_R_SYM_ISO_SPDIO2PP BIT(0)

#define R_AX_PLATFORM_ENABLE 0x0088
#define B_AX_SYM_WLPLT_MEM_MUX_EN BIT(10)
#define B_AX_WCPU_WARM_EN BIT(9)
#define B_AX_SPIC_EN BIT(8)
#define B_AX_UART_EN BIT(7)
#define B_AX_IDDMA_EN BIT(6)
#define B_AX_IPSEC_EN BIT(5)
#define B_AX_HIOE_EN BIT(4)
#define B_AX_AXIDMA_EN BIT(3)
#define B_AX_APB_WRAP_EN BIT(2)
#define B_AX_WCPU_EN BIT(1)
#define B_AX_PLATFORM_EN BIT(0)

#define R_AX_WLLPS_CTRL 0x0090
#define B_AX_LPSOP_BBOFF BIT(29)
#define B_AX_LPSOP_MACOFF BIT(28)
#define B_AX_LPSOP_MEM_DS BIT(26)
#define B_AX_LPSOP_XTALM_LPS BIT(23)
#define B_AX_LPSOP_XTAL BIT(22)
#define B_AX_LPSOP_ACLK_DIV_2 BIT(21)
#define B_AX_LPSOP_ACLK_SEL BIT(20)
#define B_AX_LPSOP_ASWRM BIT(17)
#define B_AX_LPSOP_ASWR BIT(16)
#define B_AX_LPSOP_DSWR_ADJ_SH 12
#define B_AX_LPSOP_DSWR_ADJ_MSK 0xf
#define B_AX_LPSOP_DSWRSD BIT(10)
#define B_AX_LPSOP_DSWRM BIT(9)
#define B_AX_LPSOP_DSWR BIT(8)
#define B_AX_LPSOP_OLD_ADJ_SH 4
#define B_AX_LPSOP_OLD_ADJ_MSK 0xf
#define B_AX_FORCE_LEAVE_LPS BIT(3)
#define B_AX_LPSOP_OLDSD BIT(2)
#define B_AX_WL_LPS_EN BIT(0)

#define R_AX_WLRESUME_CTRL 0x0094
#define B_AX_LPSROP_CMAC1 BIT(20)
#define B_AX_LPSROP_XTALM BIT(19)
#define B_AX_LPSROP_AFEM BIT(18)
#define B_AX_LPSROP_HIOE BIT(17)
#define B_AX_LPSROP_CPU BIT(16)
#define B_AX_LPSROP_DSWRSD_SEL_SH 4
#define B_AX_LPSROP_DSWRSD_SEL_MSK 0x3

#define R_AX_GPIO_DEBOUNCE_CTRL 0x0098
#define B_AX_WLGP_DBC1EN BIT(15)
#define B_AX_WLGP_DBC1_SH 8
#define B_AX_WLGP_DBC1_MSK 0xf
#define B_AX_WLGP_DBC0EN BIT(7)
#define B_AX_WLGP_DBC0_SH 0
#define B_AX_WLGP_DBC0_MSK 0xf

#define R_AX_SYSON_FSM_MON 0x00A0
#define B_AX_FSM_MON_SEL_SH 24
#define B_AX_FSM_MON_SEL_MSK 0x7
#define B_AX_DOP_ELDO BIT(23)
#define B_AX_FSM_MON_UPD BIT(15)
#define B_AX_FSM_PAR_SH 0
#define B_AX_FSM_PAR_MSK 0x7fff

#define R_AX_PMC_DBG_CTRL1 0x00A8
#define B_AX_PMC_WR_OVF BIT(8)
#define B_AX_WLPMC_ERRINT_SH 0
#define B_AX_WLPMC_ERRINT_MSK 0xff

#define R_AX_SCOREBOARD  0x00AC
#define B_AX_TOGGLE BIT(31)
#define B_AX_DATA_LINE_SH 0
#define B_AX_DATA_LINE_MSK 0x7fffffffL

#define R_AX_DBG_PORT_SEL 0x00C0
#define B_AX_DEBUG_ST_SH 0
#define B_AX_DEBUG_ST_MSK 0xffffffffL

#define R_AX_PAD_CTRL2 0x00C4
#define B_AX_FORCE_CLK_U2 BIT(25)
#define B_AX_FORCE_U2_CK BIT(24)
#define B_AX_FORCE_U3_CK BIT(23)
#define B_AX_USB2_FORCE BIT(22)
#define B_AX_USB3_FORCE BIT(21)
#define B_AX_USB3_USB2_TRANSITION BIT(20)
#define B_AX_USB23_SW_MODE_V1_SH 18
#define B_AX_USB23_SW_MODE_V1_MSK 0x3
#define B_AX_NO_PDN_CHIPOFF_V1 BIT(17)
#define B_AX_RSM_EN_V1 BIT(16)
#define B_AX_MATCH_CNT_SH 8
#define B_AX_MATCH_CNT_MSK 0xff
#define B_AX_LD_B12V_EN BIT(7)
#define B_AX_EECS_IOSEL_V1 BIT(6)
#define B_AX_EECS_DATA_O_V1 BIT(5)
#define B_AX_EECS_DATA_I_V1 BIT(4)
#define B_AX_EESK_IOSEL_V1 BIT(2)
#define B_AX_EESK_DATA_O_V1 BIT(1)
#define B_AX_EESK_DATA_I_V1 BIT(0)

#define R_AX_PMC_DBG_CTRL2 0x00CC
#define B_AX_EFUSE_BURN_GNT_SH 24
#define B_AX_EFUSE_BURN_GNT_MSK 0xff
#define B_AX_DIS_IOWRAP_TIMEOUT BIT(16)
#define B_AX_STOP_WL_PMC BIT(9)
#define B_AX_STOP_SYM_PMC BIT(8)
#define B_AX_BT_ACCESS_WL_PAGE0 BIT(6)
#define B_AX_R_AX_RST_WLPMC BIT(5)
#define B_AX_R_AX_RST_PD12N BIT(4)
#define B_AX_SYSON_DIS_WLR_AX_WRMSK BIT(3)
#define B_AX_SYSON_DIS_PMCR_AX_WRMSK BIT(2)
#define B_AX_SYSON_R_AX_ARB_SH 0
#define B_AX_SYSON_R_AX_ARB_MSK 0x3

#define R_AX_MEM_PWR_CTRL 0x00D0
#define B_AX_MEM_BB_SD BIT(17)
#define B_AX_MEM_BB_DS BIT(16)
#define B_AX_MEM_BT_DS BIT(10)
#define B_AX_MEM_SDIO_LS BIT(9)
#define B_AX_MEM_SDIO_DS BIT(8)
#define B_AX_MEM_USB_LS BIT(7)
#define B_AX_MEM_USB_DS BIT(6)
#define B_AX_MEM_PCI_LS BIT(5)
#define B_AX_MEM_PCI_DS BIT(4)
#define B_AX_MEM_WLMAC_LS BIT(3)
#define B_AX_MEM_WLMAC_DS BIT(2)
#define B_AX_MEM_WLMCU_LS BIT(1)
#define B_AX_MEM_WLMCU_DS BIT(0)

#define R_AX_INDIR_ADR_SDIO 0x00D4
#define B_AX_INDIR_READY_SDIO BIT(17)
#define B_AX_INDIR_R_SDIO BIT(16)
#define B_AX_INDIR_ADR_SDIO_SH 0
#define B_AX_INDIR_ADR_SDIO_MSK 0xffff

#define R_AX_INDIR_DATA_SDIO 0x00D8
#define B_AX_INDIR_DATA_SDIO_SH 0
#define B_AX_INDIR_DATA_SDIO_MSK 0xffffffffL

#define R_AX_USB_SIE_INTF 0x00E0
#define B_AX_USB_REG_SEL BIT(31)
#define B_AX_USB_WRITE_EN BIT(30)
#define B_AX_USB_REG_EN BIT(29)
#define B_AX_USB_SIE_SEL BIT(28)
#define B_AX_USB_REG_STATUS BIT(27)
#define B_AX_USB_PHY_BYTE_SEL BIT(26)
#define B_AX_USB_SIE_INTF_ADDR_SH 16
#define B_AX_USB_SIE_INTF_ADDR_MSK 0x3ff
#define B_AX_USB_SIE_INTF_RD_SH 8
#define B_AX_USB_SIE_INTF_RD_MSK 0xff
#define B_AX_USB_SIE_INTF_WD_SH 0
#define B_AX_USB_SIE_INTF_WD_MSK 0xff

#define R_AX_PCIE_MIO_INTF 0x00E4
#define B_AX_PCIE_MIO_ADDR_PAGE_SH 16
#define B_AX_PCIE_MIO_ADDR_PAGE_MSK 0x3
#define B_AX_PCIE_MIO_BYIOREG BIT(13)
#define B_AX_PCIE_MIO_RE BIT(12)
#define B_AX_PCIE_MIO_WE_SH 8
#define B_AX_PCIE_MIO_WE_MSK 0xf
#define B_AX_PCIE_MIO_ADDR_SH 0
#define B_AX_PCIE_MIO_ADDR_MSK 0xff

#define R_AX_PCIE_MIO_INTD 0x00E8
#define B_AX_PCIE_MIO_DATA_SH 0
#define B_AX_PCIE_MIO_DATA_MSK 0xffffffffL

#define R_AX_WLRF1 0x00EC

#define R_AX_SYS_CFG1 0x00F0
#define B_AX_TRP_ICFG_SH 28
#define B_AX_TRP_ICFG_MSK 0xf
#define B_AX_RF_TYPE_ID BIT(27)
#define B_AX_BD_HCI_SEL BIT(26)
#define B_AX_BD_PKG_SEL BIT(25)
#define B_AX_RTL_ID BIT(23)
#define B_AX_PAD_HWPD_IDN BIT(22)
#define B_AX_TESTMODE BIT(20)
#define B_AX_VENDOR_ID_SH 16
#define B_AX_VENDOR_ID_MSK 0xf
#define B_AX_CHIP_VER_SH 12
#define B_AX_CHIP_VER_MSK 0xf
#define B_AX_BD_MAC3 BIT(11)
#define B_AX_BD_MAC1 BIT(10)
#define B_AX_BD_MAC2 BIT(9)
#define B_AX_SIC_IDLE BIT(8)
#define B_AX_ANA_SPS_OCP_SHUTDN BIT(7)
#define B_AX_DIG_SPS_OCP_SHUTDN BIT(6)
#define B_AX_V15_VLD BIT(5)
#define B_AX_PCIRSTB BIT(4)
#define B_AX_PCLK_VLD BIT(3)
#define B_AX_UCLK_VLD BIT(2)
#define B_AX_ACLK_VLD BIT(1)
#define B_AX_XCLK_VLD BIT(0)

#define R_AX_SYS_STATUS1 0x00F4
#define B_AX_RF_RL_ID_SH 28
#define B_AX_RF_RL_ID_MSK 0xf
#define B_AX_BT_LPS_EN BIT(27)
#define B_AX_WLAN_LPS_EN BIT(26)
#define B_AX_HPHY_ICFG BIT(19)
#define B_AX_SEL_0XC0_SH 16
#define B_AX_SEL_0XC0_MSK 0x3
#define B_AX_HCI_SEL_V4_SH 13
#define B_AX_HCI_SEL_V4_MSK 0x7
#define B_AX_USB_OPERATION_MODE BIT(12)
#define B_AX_BT_PDN BIT(11)
#define B_AX_AUTO_WLPON BIT(10)
#define B_AX_WL_MODE_SH 8
#define B_AX_WL_MODE_MSK 0x3
#define B_AX_PKG_SEL_HCI BIT(6)
#define B_AX_PAD_HCI_SEL_V2_SH 3
#define B_AX_PAD_HCI_SEL_V2_MSK 0x7
#define B_AX_EFS_HCI_SEL_V1_SH 0
#define B_AX_EFS_HCI_SEL_V1_MSK 0x7

#define R_AX_SYS_STATUS2 0x00F8
#define B_AX_SIC_ON_TIMEOUT BIT(22)
#define B_AX_CPU_ON_TIMEOUT BIT(21)
#define B_AX_HCI_ON_TIMEOUT BIT(20)
#define B_AX_SIO_ALDN BIT(19)
#define B_AX_USB_ALDN BIT(18)
#define B_AX_PCI_ALDN BIT(17)
#define B_AX_SYS_ALDN BIT(16)
#define B_AX_EPVID1_SH 8
#define B_AX_EPVID1_MSK 0xff
#define B_AX_EPVID0_SH 0
#define B_AX_EPVID0_MSK 0xff

#define R_AX_SYS_CHIPINFO 0x00FC
#define B_AX_USB2_SEL BIT(31)
#define B_AX_U3PHY_RST_V1 BIT(30)
#define B_AX_U3_TERM_DETECT BIT(29)
#define B_AX_HW_ID_SH 0
#define B_AX_HW_ID_MSK 0xff

#define R_AX_RFE_PINMUX_CTRL 0x0140
#define B_AX__BANDSELN_5G_SEL BIT(31)
#define B_AX__BANDSELN_5G_EN BIT(30)
#define B_AX_BANDSELN_5_6G_SEL BIT(29)
#define B_AX_BANDSELN_5_6G_EN BIT(28)
#define B_AX_PAON_LNAON_6G_S1_SEL BIT(27)
#define B_AX_PAON_LNAON_6G_S1_EN BIT(26)
#define B_AX_PAON_LNAON_6G_S0_SEL BIT(25)
#define B_AX_PAON_LNAON_6G_S0_EN BIT(24)
#define B_AX_PAON_LNAON_5G_S1_SEL BIT(23)
#define B_AX_PAON_LNAON_5G_S1_EN BIT(22)
#define B_AX_PAON_LNAON_5G_S0_SEL BIT(21)
#define B_AX_PAON_LNAON_5G_S0_EN BIT(20)
#define B_AX_PAON_LNAON_2G_S1_SEL BIT(19)
#define B_AX_PAON_LNAON_2G_S1_EN BIT(18)
#define B_AX_PAON_LNAON_2G_S0_SEL BIT(17)
#define B_AX_PAON_LNAON_2G_S0_EN BIT(16)
#define B_AX__BANDSELN_5G_G7G6_SEL BIT(15)
#define B_AX__BANDSELN_5G_G7G6_EN BIT(14)

#define R_AX_RFE_PINMUX_SEL_FUNC 0x0144
#define B_AX_RFE_WLBT_FUNC_8_SEL_EN BIT(8)
#define B_AX_RFE_WLBT_FUNC_7_SEL_EN BIT(7)
#define B_AX_RFE_WLBT_FUNC_6_SEL_EN BIT(6)
#define B_AX_RFE_WLBT_FUNC_5_SEL_EN BIT(5)
#define B_AX_RFE_WLBT_FUNC_4_SEL_EN BIT(4)
#define B_AX_RFE_WLBT_FUNC_3_SEL_EN BIT(3)
#define B_AX_RFE_WLBT_FUNC_2_SEL_EN BIT(2)
#define B_AX_RFE_WLBT_FUNC_1_SEL_EN BIT(1)
#define B_AX_RFE_WLBT_FUNC_0_SEL_EN BIT(0)

#define R_AX_GPIO_EESK_EECS_HIGH_PRI_PINMUX 0x0148
#define B_AX_STD_EECS_PINMUX_HIGH_PRI_EN BIT(17)
#define B_AX_STD_EESK_PINMUX_HIGH_PRI_EN BIT(16)
#define B_AX_STD_GPIO15_PINMUX_HIGH_PRI_EN BIT(15)
#define B_AX_STD_GPIO14_PINMUX_HIGH_PRI_EN BIT(14)
#define B_AX_STD_GPIO13_PINMUX_HIGH_PRI_EN BIT(13)
#define B_AX_STD_GPIO12_PINMUX_HIGH_PRI_EN BIT(12)
#define B_AX_STD_GPIO11_PINMUX_HIGH_PRI_EN BIT(11)
#define B_AX_STD_GPIO10_PINMUX_HIGH_PRI_EN BIT(10)
#define B_AX_STD_GPIO9_PINMUX_HIGH_PRI_EN BIT(9)
#define B_AX_STD_GPIO8_PINMUX_HIGH_PRI_EN BIT(8)
#define B_AX_STD_GPIO7_PINMUX_HIGH_PRI_EN BIT(7)
#define B_AX_STD_GPIO6_PINMUX_HIGH_PRI_EN BIT(6)
#define B_AX_STD_GPIO5_PINMUX_HIGH_PRI_EN BIT(5)
#define B_AX_STD_GPIO4_PINMUX_HIGH_PRI_EN BIT(4)
#define B_AX_STD_GPIO3_PINMUX_HIGH_PRI_EN BIT(3)
#define B_AX_STD_GPIO2_PINMUX_HIGH_PRI_EN BIT(2)
#define B_AX_STD_GPIO1_PINMUX_HIGH_PRI_EN BIT(1)
#define B_AX_STD_GPIO0_PINMUX_HIGH_PRI_EN BIT(0)

#define R_AX_RFE_CTRL 0x014C
#define B_AX_SW_LNAON_6G_S1_SEL_DATA BIT(13)
#define B_AX_SW_PAON_6G_S1_SEL_DATA BIT(12)
#define B_AX_BANDSELP_5G_SEL_DATA BIT(11)
#define B_AX_BANDSELP_5_6G_SEL_DATA BIT(10)
#define B_AX_SW_LNAON_6G_S0_SEL_DATA BIT(9)
#define B_AX_SW_PAON_6G_S0_SEL_DATA BIT(8)
#define B_AX_SW_LNAON_5G_S1_SEL_DATA BIT(7)
#define B_AX_SW_PAON_5G_S1_SEL_DATA BIT(6)
#define B_AX_SW_LNAON_5G_S0_SEL_DATA BIT(5)
#define B_AX_SW_PAON_5G_S0_SEL_DATA BIT(4)
#define B_AX_SW_LNAON_2G_S1_SEL_DATA BIT(3)
#define B_AX_SW_PAON_2G_S1_SEL_DATA BIT(2)
#define B_AX_SW_LNAON_2G_S0_SEL_DATA BIT(1)
#define B_AX_SW_PAON_2G_S0_SEL_DATA BIT(0)

#define R_AX_HALT_H2C_CTRL 0x0160
#define B_AX_HALT_H2C_TRIGGER BIT(0)

#define R_AX_HALT_C2H_CTRL 0x0164
#define B_AX_HALT_C2H_TRIGGER BIT(0)

#define R_AX_HALT_H2C 0x0168
#define B_AX_HALT_H2C_SH 0
#define B_AX_HALT_H2C_MSK 0xffffffffL

#define R_AX_HALT_C2H 0x016C
#define B_AX_HALT_C2H_SH 0
#define B_AX_HALT_C2H_MSK 0xffffffffL

#define R_AX_SYS_CFG5 0x0170
#define B_AX_LPS_STATUS BIT(3)
#define B_AX_HCI_TXDMA_BUSY BIT(2)
#define B_AX_HCI_TXDMA_ALLOW BIT(1)
#define B_AX_FW_CTRL_HCI_TXDMA_EN BIT(0)

#define R_AX_FWS0IMR 0x0190
#define B_AX_FS_HALT_H2C_INT_EN BIT(31)
#define B_AX_FS_FSM_HIOE_TO_EVENT_INT_EN BIT(30)
#define B_AX_FS_HCI_SUS_INT_EN BIT(29)
#define B_AX_FS_HCI_RES_INT_EN BIT(28)
#define B_AX_FS_HCI_RESET_INT_EN BIT(27)
#define B_AX_FS_USB_SCSI_CMD_INT_EN BIT(26)
#define B_AX_FS_ACT2RECOVERY_INT_EN BIT(25)
#define B_AX_FS_GEN1GEN2_SWITCH_INT_EN BIT(24)
#define B_AX_FS_HCI_TXDMA_REQ_INT_EN BIT(23)
#define B_AX_FS_USB_LPMRSM_INT_EN BIT(22)
#define B_AX_FS_USB_LPMINT_INT_EN BIT(21)
#define B_AX_FS_PWMERR_INT_EN BIT(20)
#define B_AX_FS_PDNINT_EN BIT(19)
#define B_AX_FS_SPSA_OCP_INT_EN BIT(18)
#define B_AX_FS_SPSD_OCP_INT_EN BIT(17)
#define B_AX_FS_BT_SB_INT_EN BIT(16)
#define B_AX_FS_GPIOF_INT_EN BIT(15)
#define B_AX_FS_GPIOE_INT_EN BIT(14)
#define B_AX_FS_GPIOD_INT_EN BIT(13)
#define B_AX_FS_GPIOC_INT_EN BIT(12)
#define B_AX_FS_GPIOB_INT_EN BIT(11)
#define B_AX_FS_GPIOA_INT_EN BIT(10)
#define B_AX_FS_GPIO9_INT_EN BIT(9)
#define B_AX_FS_GPIO8_INT_EN BIT(8)
#define B_AX_FS_GPIO7_INT_EN BIT(7)
#define B_AX_FS_GPIO6_INT_EN BIT(6)
#define B_AX_FS_GPIO5_INT_EN BIT(5)
#define B_AX_FS_GPIO4_INT_EN BIT(4)
#define B_AX_FS_GPIO3_INT_EN BIT(3)
#define B_AX_FS_GPIO2_INT_EN BIT(2)
#define B_AX_FS_GPIO1_INT_EN BIT(1)
#define B_AX_FS_GPIO0_INT_EN BIT(0)

#define R_AX_FWS0ISR 0x0194
#define B_AX_FS_HALT_H2C_INT BIT(31)
#define B_AX_FS_FSM_HIOE_TO_EVENT_INT BIT(30)
#define B_AX_FS_HCI_SUS_INT BIT(29)
#define B_AX_FS_HCI_RES_INT BIT(28)
#define B_AX_FS_HCI_RESET_INT BIT(27)
#define B_AX_FS_USB_SCSI_CMD_INT BIT(26)
#define B_AX_FS_ACT2RECOVERY_INT BIT(25)
#define B_AX_FS_GEN1GEN2_SWITCH_INT BIT(24)
#define B_AX_FS_HCI_TXDMA_REQ_INT BIT(23)
#define B_AX_FS_USB_LPMRSM_INT BIT(22)
#define B_AX_FS_USB_LPMINT_INT BIT(21)
#define B_AX_FS_PWMERR_INT BIT(20)
#define B_AX_FS_PDNINT BIT(19)
#define B_AX_FS_SPSA_OCP_INT BIT(18)
#define B_AX_FS_SPSD_OCP_INT BIT(17)
#define B_AX_FS_BT_SB_INT BIT(16)
#define B_AX_FS_GPIOF_INT BIT(15)
#define B_AX_FS_GPIOE_INT BIT(14)
#define B_AX_FS_GPIOD_INT BIT(13)
#define B_AX_FS_GPIOC_INT BIT(12)
#define B_AX_FS_GPIOB_INT BIT(11)
#define B_AX_FS_GPIOA_INT BIT(10)
#define B_AX_FS_GPIO9_INT BIT(9)
#define B_AX_FS_GPIO8_INT BIT(8)
#define B_AX_FS_GPIO7_INT BIT(7)
#define B_AX_FS_GPIO6_INT BIT(6)
#define B_AX_FS_GPIO5_INT BIT(5)
#define B_AX_FS_GPIO4_INT BIT(4)
#define B_AX_FS_GPIO3_INT BIT(3)
#define B_AX_FS_GPIO2_INT BIT(2)
#define B_AX_FS_GPIO1_INT BIT(1)
#define B_AX_FS_GPIO0_INT BIT(0)

#define R_AX_HIMR0 0x01A0
#define B_AX_WDT_TIMEOUT_INT_EN BIT(22)
#define B_AX_HALT_C2H_INT_EN BIT(21)
#define B_AX_RON_INT_EN BIT(20)
#define B_AX_PDNINT_EN BIT(19)
#define B_AX_SPSANA_OCP_INT_EN BIT(18)
#define B_AX_SPS_OCP_INT_EN BIT(17)
#define B_AX_BTON_STS_UPDATE_INT_EN BIT(16)
#define B_AX_GPIOF_INT_EN BIT(15)
#define B_AX_GPIOE_INT_EN BIT(14)
#define B_AX_GPIOD_INT_EN BIT(13)
#define B_AX_GPIOC_INT_EN BIT(12)
#define B_AX_GPIOB_INT_EN BIT(11)
#define B_AX_GPIOA_INT_EN BIT(10)
#define B_AX_GPIO9_INT_EN BIT(9)
#define B_AX_GPIO8_INT_EN BIT(8)
#define B_AX_GPIO7_INT_EN BIT(7)
#define B_AX_GPIO6_INT_EN BIT(6)
#define B_AX_GPIO5_INT_EN BIT(5)
#define B_AX_GPIO4_INT_EN BIT(4)
#define B_AX_GPIO3_INT_EN BIT(3)
#define B_AX_GPIO2_INT_EN BIT(2)
#define B_AX_GPIO1_INT_EN BIT(1)
#define B_AX_GPIO0_INT_EN BIT(0)

#define R_AX_HISR0 0x01A4
#define B_AX_WDT_TIMEOUT_INT BIT(22)
#define B_AX_HALT_C2H_INT BIT(21)
#define B_AX_RON_INT BIT(20)
#define B_AX_PDNINT BIT(19)
#define B_AX_SPSANA_OCP_INT BIT(18)
#define B_AX_SPS_OCP_INT BIT(17)
#define B_AX_BTON_STS_UPDATE_INT BIT(16)
#define B_AX_GPIOF_INT BIT(15)
#define B_AX_GPIOE_INT BIT(14)
#define B_AX_GPIOD_INT BIT(13)
#define B_AX_GPIOC_INT BIT(12)
#define B_AX_GPIOB_INT BIT(11)
#define B_AX_GPIOA_INT BIT(10)
#define B_AX_GPIO9_INT BIT(9)
#define B_AX_GPIO8_INT BIT(8)
#define B_AX_GPIO7_INT BIT(7)
#define B_AX_GPIO6_INT BIT(6)
#define B_AX_GPIO5_INT BIT(5)
#define B_AX_GPIO4_INT BIT(4)
#define B_AX_GPIO3_INT BIT(3)
#define B_AX_GPIO2_INT BIT(2)
#define B_AX_GPIO1_INT BIT(1)
#define B_AX_GPIO0_INT BIT(0)

#define R_AX_IO_HANG_CTRL  0x01D0
#define B_AX_IO_HANG_EN BIT(7)
#define B_AX_IO_HANG_THD_SH 0
#define B_AX_IO_HANG_THD_MSK 0x7f

#define R_AX_WCPU_FW_CTRL 0x01E0
#define B_AX_WCPU_ROM_CUT_REQ BIT(30)
#define B_AX_FW_ENV_SH 28
#define B_AX_FW_ENV_MSK 0x3
#define B_AX_WCPU_ROM_CUT_SH 8
#define B_AX_WCPU_ROM_CUT_MSK 0xff
#define B_AX_WCPU_FWDL_STS_SH 5
#define B_AX_WCPU_FWDL_STS_MSK 0x7
#define B_AX_FW_RAM_RUN_IND BIT(4)
#define B_AX_FWDL_PATH_RDY BIT(2)
#define B_AX_H2C_PATH_RDY BIT(1)
#define B_AX_WCPU_FWDL_EN BIT(0)
#define B_AX_WDT_PLT_RST_EN BIT(16)

#define R_AX_BOOT_REASON 0x01E6
#define B_AX_BOOT_REASON_SH 0
#define B_AX_BOOT_REASON_MSK 0x7

#define R_AX_RPWM 0x01E4
#define B_AX_RPWM_TOGGLE BIT(15)
#define B_AX_RPWM_VAL_SH 0
#define B_AX_RPWM_VAL_MSK 0x7fff

#define R_AX_LDM 0x01E8
#define B_AX_EN_32K BIT(31)
#define B_AX_LDM_SH 0
#define B_AX_LDM_MSK 0x7fffffffL

#define R_AX_UDM0 0x01F0
#define B_AX_UDM0_SH 0
#define B_AX_UDM0_MSK 0xffffffffL

#define R_AX_UDM1 0x01F4
#define B_AX_UDM1_SH 0
#define B_AX_UDM1_MSK 0xffffffffL

#define R_AX_UDM2 0x01F8
#define B_AX_UDM2_SH 0
#define B_AX_UDM2_MSK 0xffffffffL

#define R_AX_UDM3 0x01FC
#define B_AX_UDM3_SH 0
#define B_AX_UDM3_MSK 0xffffffffL

#define R_AX_SPSLDO_ON_CTRL0 0x0200
#define B_AX_PFMCMP_IQ BIT(31)
#define B_AX_OFF_END_SEL BIT(29)
#define B_AX_POW_MINOFF_L BIT(28)
#define B_AX_COT_I_L_SH 26
#define B_AX_COT_I_L_MSK 0x3
#define B_AX_VREFPFM_L_SH 22
#define B_AX_VREFPFM_L_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS BIT(21)
#define B_AX_ZCD_SDZ_L_SH 19
#define B_AX_ZCD_SDZ_L_MSK 0x3
#define B_AX_REG_ZCDC_H_SH 17
#define B_AX_REG_ZCDC_H_MSK 0x3
#define B_AX_POW_ZCD_L BIT(16)
#define B_AX_OCP_L1_SH 13
#define B_AX_OCP_L1_MSK 0x7
#define B_AX_POWOCP_L1 BIT(12)
#define B_AX_SAW_FREQ_L_SH 8
#define B_AX_SAW_FREQ_L_MSK 0xf
#define B_AX_REG_BYPASS_L BIT(7)
#define B_AX_FPWM_L1 BIT(6)
#define B_AX_STD_L1_SH 4
#define B_AX_STD_L1_MSK 0x3
#define B_AX_VOL_L1_SH 0
#define B_AX_VOL_L1_MSK 0xf

#define R_AX_SPSLDO_ON_CTRL1 0x0204
#define B_AX_SN_N_L_SH 28
#define B_AX_SN_N_L_MSK 0xf
#define B_AX_SP_N_L_SH 24
#define B_AX_SP_N_L_MSK 0xf
#define B_AX_SN_P_L_SH 20
#define B_AX_SN_P_L_MSK 0xf
#define B_AX_SP_P_L_SH 16
#define B_AX_SP_P_L_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H BIT(15)
#define B_AX_REG_MODE_PREDRIVER BIT(14)
#define B_AX_REG_ADJSLDO_L_SH 10
#define B_AX_REG_ADJSLDO_L_MSK 0xf
#define B_AX_REG_LDOR_L BIT(9)
#define B_AX_PWM_FORCE BIT(8)
#define B_AX_PFM_PD_RST BIT(7)
#define B_AX_VC_PFM_RSTB BIT(6)
#define B_AX_PFM_IN_SEL BIT(5)
#define B_AX_VC_RSTB BIT(4)
#define B_AX_FPWMDELAY BIT(3)
#define B_AX_ENFPWMDELAY_H BIT(2)
#define B_AX_REG_MOS_HALF_L BIT(1)
#define B_AX_CURRENT_SENSE_MOS BIT(0)
#define B_AX_SPS_PFM_ZCDC_H_PFM_SH 4
#define B_AX_SPS_PFM_ZCDC_H_PFM_MSK 0x3
#define B_AX_SPS_PFM_OCP_L_PFM_SH 0
#define B_AX_SPS_PFM_OCP_L_PFM_MSK 0x7

#define R_AX_LDO_AON_CTRL0 0x0218
#define B_AX_CK12M_EN BIT(11)
#define B_AX_CK12M_SEL BIT(10)
#define B_AX_EN_SLEEP BIT(8)
#define B_AX_LDOH12_V12ADJ_L_SH 4
#define B_AX_LDOH12_V12ADJ_L_MSK 0xf
#define B_AX_LDOE25_V12ADJ_L_SH 0
#define B_AX_LDOE25_V12ADJ_L_MSK 0xf

#define R_AX_SPSANA_ON_CTRL0 0x0220
#define B_AX_REG_EXTERNAL_CLK_SEL_L BIT(30)

#define R_AX_SPSANA_ON_CTRL1 0x0224
#define B_AX_SPS_ANA_PFM_ZCDC_H_SH 4
#define B_AX_SPS_ANA_PFM_ZCDC_H_MSK 0x3
#define B_AX_SPS_ANA_PFM_OCP_L_SH 0
#define B_AX_SPS_ANA_PFM_OCP_L_MSK 0x7

#define R_AX_AFE_ON_CTRL0 0x0240
#define B_AX_REG_LPF_R3_SH 29
#define B_AX_REG_LPF_R3_MSK 0x7
#define B_AX_REG_LPF_R2_SH 24
#define B_AX_REG_LPF_R2_MSK 0x1f
#define B_AX_REG_LPF_C3_SH 21
#define B_AX_REG_LPF_C3_MSK 0x7
#define B_AX_REG_LPF_C2_SH 18
#define B_AX_REG_LPF_C2_MSK 0x7
#define B_AX_REG_LPF_C1_SH 15
#define B_AX_REG_LPF_C1_MSK 0x7
#define B_AX_REG_LDO_SEL_SH 13
#define B_AX_REG_LDO_SEL_MSK 0x3
#define B_AX_REG_CP_ICPX2 BIT(12)
#define B_AX_REG_CP_ICP_SEL_FAST_SH 9
#define B_AX_REG_CP_ICP_SEL_FAST_MSK 0x7
#define B_AX_REG_CP_ICP_SEL_SH 6
#define B_AX_REG_CP_ICP_SEL_MSK 0x7
#define B_AX_REG_IB_PI_SH 4
#define B_AX_REG_IB_PI_MSK 0x3
#define B_AX_LDO2PWRCUT BIT(3)
#define B_AX_VPULSE_LDO BIT(2)
#define B_AX_LDO_VSEL_SH 0
#define B_AX_LDO_VSEL_MSK 0x3

#define R_AX_AFE_ON_CTRL1 0x0244
#define B_AX_REG_CK_MON_SEL_SH 29
#define B_AX_REG_CK_MON_SEL_MSK 0x7
#define B_AX_REG_CK_MON_EN BIT(28)
#define B_AX_REG_XTAL_FREQ_SEL BIT(27)
#define B_AX_REG_XTAL_EDGE_SEL BIT(26)
#define B_AX_REG_VCO_KVCO BIT(25)
#define B_AX_REG_SDM_EDGE_SEL BIT(24)
#define B_AX_REG_SDM_CK_SEL BIT(23)
#define B_AX_REG_SDM_CK_GATED BIT(22)
#define B_AX_REG_PFD_RESET_GATED BIT(21)
#define B_AX_REG_LPF_R3_FAST_SH 16
#define B_AX_REG_LPF_R3_FAST_MSK 0x1f
#define B_AX_REG_LPF_R2_FAST_SH 11
#define B_AX_REG_LPF_R2_FAST_MSK 0x1f
#define B_AX_REG_LPF_C3_FAST_SH 8
#define B_AX_REG_LPF_C3_FAST_MSK 0x7
#define B_AX_REG_LPF_C2_FAST_SH 5
#define B_AX_REG_LPF_C2_FAST_MSK 0x7
#define B_AX_REG_LPF_C1_FAST_SH 2
#define B_AX_REG_LPF_C1_FAST_MSK 0x7
#define B_AX_REG_LPF_R3__SH 0
#define B_AX_REG_LPF_R3__MSK 0x3

#define R_AX_AFE_ON_CTRL2 0x0248
#define B_AX_AGPIO_DRV_SH 30
#define B_AX_AGPIO_DRV_MSK 0x3
#define B_AX_AGPIO_GPO BIT(29)
#define B_AX_AGPIO_GPE BIT(28)
#define B_AX_SEL_CLK BIT(27)
#define B_AX_LS_XTAL_SEL_SH 23
#define B_AX_LS_XTAL_SEL_MSK 0xf
#define B_AX_LS_SDM_ORDER BIT(22)
#define B_AX_LS_DELAY_PH BIT(21)
#define B_AX_DIVIDER_SEL BIT(20)
#define B_AX_PCODE_SH 15
#define B_AX_PCODE_MSK 0x1f
#define B_AX_NCODE_SH 7
#define B_AX_NCODE_MSK 0xff
#define B_AX_REG_BEACON BIT(6)
#define B_AX_REG_MBIASE BIT(5)
#define B_AX_REG_FAST_SEL_SH 3
#define B_AX_REG_FAST_SEL_MSK 0x3
#define B_AX_REG_CK480M_EN BIT(2)
#define B_AX_REG_CK320M_EN BIT(1)
#define B_AX_REG_CK_5M_EN BIT(0)

#define R_AX_AFE_ON_CTRL3 0x024C
#define B_AX_REG_CK640M_EN BIT(0)

#define R_AX_WLAN_XTAL_SI_CONFIG 0x0274

#define R_AX_XTAL_ON_CTRL0 0x0280
#define B_AX_XTAL_SC_LPS BIT(31)
#define B_AX_XTAL_SC_INIT_SH 24
#define B_AX_XTAL_SC_INIT_MSK 0x7f
#define B_AX_XTAL_SC_XO_SH 17
#define B_AX_XTAL_SC_XO_MSK 0x7f
#define B_AX_XTAL_SC_XI_SH 10
#define B_AX_XTAL_SC_XI_MSK 0x7f
#define B_AX_XTAL_GMN_SH 5
#define B_AX_XTAL_GMN_MSK 0x1f
#define B_AX_XTAL_GMP_SH 0
#define B_AX_XTAL_GMP_MSK 0x1f

#define R_AX_XTAL_ON_CTRL1 0x0284
#define B_AX_XTAL_VREF_SEL_SH 29
#define B_AX_XTAL_VREF_SEL_MSK 0x7
#define B_AX_XTAL_LPS_DIVISOR BIT(28)
#define B_AX_XTAL_CKDIGI_SEL BIT(27)
#define B_AX_EN_XTAL_SCHMITT BIT(26)
#define B_AX_XTAL_SEL_TOK_SH 23
#define B_AX_XTAL_SEL_TOK_MSK 0x7
#define B_AX_EN_XTAL_LPS_CLK BIT(22)
#define B_AX_XTAL_AAC_OPCUR_SH 20
#define B_AX_XTAL_AAC_OPCUR_MSK 0x3
#define B_AX_XTAL_LDO_VREF_SH 17
#define B_AX_XTAL_LDO_VREF_MSK 0x7
#define B_AX_EN_XTAL_DRV_BT BIT(16)
#define B_AX_EN_XTAL_DRV_CPHY BIT(15)
#define B_AX_EN_XTAL_DRV_IQK_BCN BIT(14)
#define B_AX_EN_XTAL_DRV_LPS BIT(13)
#define B_AX_EN_XTAL_DRV_DIGI BIT(12)
#define B_AX_EN_XTAL_DRV_USB BIT(11)
#define B_AX_EN_XTAL_DRV_AFE BIT(10)
#define B_AX_XTAL_DRV_RF2N_RELAY BIT(9)
#define B_AX_XTAL_DRV_RF2P_RELAY BIT(8)
#define B_AX_EN_XTAL_DRV_RF2 BIT(7)
#define B_AX_EN_XTAL_DRV_RF1 BIT(6)
#define B_AX_XTAL_SC_LPS__SH 0
#define B_AX_XTAL_SC_LPS__MSK 0x3f

#define R_AX_XTAL_ON_CTRL2 0x0288
#define B_AX_XTAL_CFIX_SH 4
#define B_AX_XTAL_CFIX_MSK 0x3
#define B_AX_AAC_MODE_SH 2
#define B_AX_AAC_MODE_MSK 0x3
#define B_AX_XTAL_VREF_SEL__SH 0
#define B_AX_XTAL_VREF_SEL__MSK 0x3

#define R_AX_SYM_ANAPAR_XTAL_MODE_DECODER 0x02A0
#define B_AX_WIFI_FORCE_XTAL_HPMODE BIT(31)
#define B_AX_XTAL_LDO_LPS_SH 21
#define B_AX_XTAL_LDO_LPS_MSK 0x7
#define B_AX_XTAL_WAIT_CYC_SH 15
#define B_AX_XTAL_WAIT_CYC_MSK 0x3f
#define B_AX_XTAL_LDO_OK_SH 12
#define B_AX_XTAL_LDO_OK_MSK 0x7
#define B_AX_XTAL_MD_LPOW BIT(11)
#define B_AX_XTAL_OV_RATIO_SH 9
#define B_AX_XTAL_OV_RATIO_MSK 0x3
#define B_AX_XTAL_OV_UNIT_SH 6
#define B_AX_XTAL_OV_UNIT_MSK 0x7
#define B_AX_XTAL_MODE_MANUAL_SH 4
#define B_AX_XTAL_MODE_MANUAL_MSK 0x3
#define B_AX_XTAL_MANU_SEL BIT(3)
#define B_AX_XTAL_POW_XTAL_LPS BIT(2)
#define B_AX_XTAL_MODE BIT(1)
#define B_AX_RESET_N_ BIT(0)

#define R_AX_XTAL_XAAC_RO_DATA 0x02A4
#define B_AX_WL_XTAL_CLK_CHANGE_OK BIT(20)
#define B_AX_WL_XTAL_CLK_VALID BIT(19)
#define B_AX_XTAL_MODE_DBG BIT(18)
#define B_AX_XTAL_LDO_OPMUX BIT(17)
#define B_AX_WL_XTAL_LDO_VREF_OK_SH 14
#define B_AX_WL_XTAL_LDO_VREF_OK_MSK 0x7
#define B_AX_WL_XTAL_MODE_READY BIT(13)
#define B_AX_WL_XTAL_LPS_STATE BIT(12)
#define B_AX_WL_XTAL_STATE BIT(11)
#define B_AX_WL_XTAL_FASTSET BIT(10)
#define B_AX_WL_EN_LPS_MODE BIT(9)
#define B_AX_WL_EN_NM_MODE BIT(8)
#define B_AX_WL_EN_HP_MODE BIT(7)
#define B_AX_XTAL_MODE_DEC_SH 5
#define B_AX_XTAL_MODE_DEC_MSK 0x3
#define B_AX_XMD_STATE_SH 0
#define B_AX_XMD_STATE_MSK 0x1f

#define R_AX_WLRF_CTRL 0x02F0
#define B_AX_WLRF1_CTRL_7 BIT(15)
#define B_AX_WLRF1_CTRL_6 BIT(14)
#define B_AX_WLRF1_CTRL_5 BIT(13)
#define B_AX_WLRF1_CTRL_4 BIT(12)
#define B_AX_WLRF1_CTRL_3 BIT(11)
#define B_AX_WLRF1_CTRL_2 BIT(10)
#define B_AX_WLRF1_CTRL_1 BIT(9)
#define B_AX_WLRF1_CTRL_0 BIT(8)
#define B_AX_WLRF_CTRL_7 BIT(7)
#define B_AX_WLRF_CTRL_6 BIT(6)
#define B_AX_WLRF_CTRL_5 BIT(5)
#define B_AX_WLRF_CTRL_4 BIT(4)
#define B_AX_WLRF_CTRL_3 BIT(3)
#define B_AX_WLRF_CTRL_2 BIT(2)
#define B_AX_WLRF_CTRL_1 BIT(1)
#define B_AX_WLRF_CTRL_0 BIT(0)

#define R_AX_SPSLDO_ON_CTRL0_F 0x0300
#define B_AX_PFMCMP_IQ_F BIT(31)
#define B_AX_OFF_END_SEL_F BIT(29)
#define B_AX_POW_MINOFF_L_F BIT(28)
#define B_AX_COT_I_L_F_SH 26
#define B_AX_COT_I_L_F_MSK 0x3
#define B_AX_VREFPFM_L_F_SH 22
#define B_AX_VREFPFM_L_F_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS_F BIT(21)
#define B_AX_ZCD_SDZ_L_F_SH 19
#define B_AX_ZCD_SDZ_L_F_MSK 0x3
#define B_AX_REG_ZCDC_H_F_SH 17
#define B_AX_REG_ZCDC_H_F_MSK 0x3
#define B_AX_POW_ZCD_L_F BIT(16)
#define B_AX_OCP_L1_F_SH 13
#define B_AX_OCP_L1_F_MSK 0x7
#define B_AX_POWOCP_L1_F BIT(12)
#define B_AX_SAW_FREQ_L_F_SH 8
#define B_AX_SAW_FREQ_L_F_MSK 0xf
#define B_AX_REG_BYPASS_L_F BIT(7)
#define B_AX_FPWM_L1_F BIT(6)
#define B_AX_STD_L1_F_SH 4
#define B_AX_STD_L1_F_MSK 0x3
#define B_AX_VOL_L1_F_SH 0
#define B_AX_VOL_L1_F_MSK 0xf

#define R_AX_SPSLDO_ON_CTRL1_F 0x0304
#define B_AX_SN_N_L_F_SH 28
#define B_AX_SN_N_L_F_MSK 0xf
#define B_AX_SP_N_L_F_SH 24
#define B_AX_SP_N_L_F_MSK 0xf
#define B_AX_SN_P_L_F_SH 20
#define B_AX_SN_P_L_F_MSK 0xf
#define B_AX_SP_P_L_F_SH 16
#define B_AX_SP_P_L_F_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H_F BIT(15)
#define B_AX_REG_MODE_PREDRIVER_F BIT(14)
#define B_AX_REG_ADJSLDO_L_F_SH 10
#define B_AX_REG_ADJSLDO_L_F_MSK 0xf
#define B_AX_REG_LDOR_L_F BIT(9)
#define B_AX_PWM_FORCE_F BIT(8)
#define B_AX_PFM_PD_RST_F BIT(7)
#define B_AX_VC_PFM_RSTB_F BIT(6)
#define B_AX_PFM_IN_SEL_F BIT(5)
#define B_AX_VC_RSTB_F BIT(4)
#define B_AX_FPWMDELAY_F BIT(3)
#define B_AX_ENFPWMDELAY_H_F BIT(2)
#define B_AX_REG_MOS_HALF_L_F BIT(1)
#define B_AX_CURRENT_SENSE_MOS_F BIT(0)

#define R_AX_SPSLDO_OFF_CTRL0_F 0x0308
#define B_AX_SDZN_L_F_SH 30
#define B_AX_SDZN_L_F_MSK 0x3
#define B_AX_REG_AUTOZCD_L_F BIT(29)
#define B_AX_REG_VOFB_SEL_F BIT(28)
#define B_AX_TBOX_L1_F_SH 26
#define B_AX_TBOX_L1_F_MSK 0x3
#define B_AX_ENOCPMUX_L_F BIT(25)
#define B_AX_FORCE_LDOS_F BIT(24)
#define B_AX_VO_DISCHG_F BIT(23)
#define B_AX_LDO_OC_CLAMP_F BIT(22)
#define B_AX_MINOFF_LIQ_F BIT(21)
#define B_AX_MINON_LIQ_F BIT(20)
#define B_AX_POW_AUTO_L_F BIT(19)
#define B_AX_ARENB_H_F BIT(18)
#define B_AX_NO_OFFTIME_L_F BIT(17)
#define B_AX_EN_ON_END_L_F BIT(16)
#define B_AX_ENCOT_L_F BIT(15)
#define B_AX_REG_CLK_SEL_F_SH 13
#define B_AX_REG_CLK_SEL_F_MSK 0x3
#define B_AX_REG_TYPE_L_F BIT(12)
#define B_AX_R3_L1_F_SH 10
#define B_AX_R3_L1_F_MSK 0x3
#define B_AX_R2_L1_F_SH 8
#define B_AX_R2_L1_F_MSK 0x3
#define B_AX_R1_L1_F_SH 6
#define B_AX_R1_L1_F_MSK 0x3
#define B_AX_C3_L1_F_SH 4
#define B_AX_C3_L1_F_MSK 0x3
#define B_AX_C2_L1_F_SH 2
#define B_AX_C2_L1_F_MSK 0x3
#define B_AX_C1_L1_F_SH 0
#define B_AX_C1_L1_F_MSK 0x3

#define R_AX_SPSLDO_OFF_CTRL1_F 0x030C
#define B_AX_REG_NMOS_OFF_L_F BIT(5)
#define B_AX_REG_MUX_PI_L_F BIT(4)
#define B_AX_REG_PWM_CTRL_L_F BIT(3)
#define B_AX_ENSR_L_F BIT(2)
#define B_AX_SDZP_L_F_SH 0
#define B_AX_SDZP_L_F_MSK 0x3

#define R_AX_SPSANA_ON_CTRL0_F 0x0310
#define B_AX_REG_EXTERNAL_CLK_SEL_L_F BIT(30)

#define R_AX_SPSANA_ON_CTRL1_F 0x0314

#define R_AX_SPSANA_OFF_CTRL0_F 0x0318

#define R_AX_SPSANA_OFF_CTRL1_F 0x031C

#define R_AX_LDO_AON_CTRL0_F 0x0320
#define B_AX_CK12M_EN_F BIT(11)
#define B_AX_CK12M_SEL_F BIT(10)
#define B_AX_EN_SLEEP_F BIT(8)
#define B_AX_LDOH12_V12ADJ_L_F_SH 4
#define B_AX_LDOH12_V12ADJ_L_F_MSK 0xf
#define B_AX_LDOE25_V12ADJ_L_F_SH 0
#define B_AX_LDOE25_V12ADJ_L_F_MSK 0xf

#define R_AX_ANAPAR_POW_MAC_F 0x0324
#define B_AX_POW_PC_LDO_PORT1_F BIT(3)
#define B_AX_POW_PC_LDO_PORT0_F BIT(2)
#define B_AX_POW_PLL_V1_F BIT(1)
#define B_AX_POW_POWER_CUT_POW_LDO_F BIT(0)

#define R_AX_AFE_ON_CTRL0_F 0x0328
#define B_AX_REG_LPF_R3_F_SH 29
#define B_AX_REG_LPF_R3_F_MSK 0x7
#define B_AX_REG_LPF_R2_F_SH 24
#define B_AX_REG_LPF_R2_F_MSK 0x1f
#define B_AX_REG_LPF_C3_F_SH 21
#define B_AX_REG_LPF_C3_F_MSK 0x7
#define B_AX_REG_LPF_C2_F_SH 18
#define B_AX_REG_LPF_C2_F_MSK 0x7
#define B_AX_REG_LPF_C1_F_SH 15
#define B_AX_REG_LPF_C1_F_MSK 0x7
#define B_AX_REG_LDO_SEL_F_SH 13
#define B_AX_REG_LDO_SEL_F_MSK 0x3
#define B_AX_REG_CP_ICPX2_F BIT(12)
#define B_AX_REG_CP_ICP_SEL_FAST_F_SH 9
#define B_AX_REG_CP_ICP_SEL_FAST_F_MSK 0x7
#define B_AX_REG_CP_ICP_SEL_F_SH 6
#define B_AX_REG_CP_ICP_SEL_F_MSK 0x7
#define B_AX_REG_IB_PI_F_SH 4
#define B_AX_REG_IB_PI_F_MSK 0x3
#define B_AX_LDO2PWRCUT_F BIT(3)
#define B_AX_VPULSE_LDO_F BIT(2)
#define B_AX_LDO_VSEL_F_SH 0
#define B_AX_LDO_VSEL_F_MSK 0x3

#define R_AX_AFE_ON_CTRL1_F 0x032C
#define B_AX_REG_CK_MON_SEL_F_SH 29
#define B_AX_REG_CK_MON_SEL_F_MSK 0x7
#define B_AX_REG_CK_MON_EN_F BIT(28)
#define B_AX_REG_XTAL_FREQ_SEL_F BIT(27)
#define B_AX_REG_XTAL_EDGE_SEL_F BIT(26)
#define B_AX_REG_VCO_KVCO_F BIT(25)
#define B_AX_REG_SDM_EDGE_SEL_F BIT(24)
#define B_AX_REG_SDM_CK_SEL_F BIT(23)
#define B_AX_REG_SDM_CK_GATED_F BIT(22)
#define B_AX_REG_PFD_RESET_GATED_F BIT(21)
#define B_AX_REG_LPF_R3_FAST_F_SH 16
#define B_AX_REG_LPF_R3_FAST_F_MSK 0x1f
#define B_AX_REG_LPF_R2_FAST_F_SH 11
#define B_AX_REG_LPF_R2_FAST_F_MSK 0x1f
#define B_AX_REG_LPF_C3_FAST_F_SH 8
#define B_AX_REG_LPF_C3_FAST_F_MSK 0x7
#define B_AX_REG_LPF_C2_FAST_F_SH 5
#define B_AX_REG_LPF_C2_FAST_F_MSK 0x7
#define B_AX_REG_LPF_C1_FAST_F_SH 2
#define B_AX_REG_LPF_C1_FAST_F_MSK 0x7
#define B_AX_REG_LPF_R3_F__SH 0
#define B_AX_REG_LPF_R3_F__MSK 0x3

#define R_AX_AFE_ON_CTRL2_F 0x0330
#define B_AX_AGPIO_DRV_F_SH 30
#define B_AX_AGPIO_DRV_F_MSK 0x3
#define B_AX_AGPIO_GPO_F BIT(29)
#define B_AX_AGPIO_GPE_F BIT(28)
#define B_AX_SEL_CLK_F BIT(27)
#define B_AX_LS_XTAL_SEL_F_SH 23
#define B_AX_LS_XTAL_SEL_F_MSK 0xf
#define B_AX_LS_SDM_ORDER_F BIT(22)
#define B_AX_LS_DELAY_PH_F BIT(21)
#define B_AX_DIVIDER_SEL_F BIT(20)
#define B_AX_PCODE_F_SH 15
#define B_AX_PCODE_F_MSK 0x1f
#define B_AX_NCODE_F_SH 7
#define B_AX_NCODE_F_MSK 0xff
#define B_AX_REG_BEACON_F BIT(6)
#define B_AX_REG_MBIASE_F BIT(5)
#define B_AX_REG_FAST_SEL_F_SH 3
#define B_AX_REG_FAST_SEL_F_MSK 0x3
#define B_AX_REG_CK480M_EN_F BIT(2)
#define B_AX_REG_CK320M_EN_F BIT(1)
#define B_AX_REG_CK_5M_EN_F BIT(0)

#define R_AX_AFE_ON_CTRL3_F 0x0334
#define B_AX_REG_CK640M_EN_F BIT(0)

#define R_AX_AFE_OFF_CTRL0_F 0x0338
#define B_AX_S1_AD0_LDO2PWRCUT_F BIT(31)
#define B_AX_S1_AD_SEL_Q_F_SH 27
#define B_AX_S1_AD_SEL_Q_F_MSK 0xf
#define B_AX_S1_AD_SEL_I_F_SH 23
#define B_AX_S1_AD_SEL_I_F_MSK 0xf
#define B_AX_S0_DA1_LDO_VSEL_F_SH 21
#define B_AX_S0_DA1_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_DA1_LDO2PWRCUT_F BIT(20)
#define B_AX_S0_DA0_LDO_VSEL_F_SH 18
#define B_AX_S0_DA0_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_DA0_LDO2PWRCUT_F BIT(17)
#define B_AX_S0_AD2_LDO_VSEL_F_SH 15
#define B_AX_S0_AD2_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_AD2_LDO2PWRCUT_F BIT(14)
#define B_AX_S0_AD1_LDO_VSEL_F_SH 12
#define B_AX_S0_AD1_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_AD1_LDO2PWRCUT_F BIT(11)
#define B_AX_S0_AD0_LDO_VSEL_F_SH 9
#define B_AX_S0_AD0_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_AD0_LDO2PWRCUT_F BIT(8)
#define B_AX_S0_AD_SEL_Q_F_SH 4
#define B_AX_S0_AD_SEL_Q_F_MSK 0xf
#define B_AX_S0_AD_SEL_I_F_SH 0
#define B_AX_S0_AD_SEL_I_F_MSK 0xf

#define R_AX_AFE_OFF_CTRL1_F 0x033C
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_F__SH 24
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_F__MSK 0x3
#define B_AX_S1_DAI2V_LDO2PWRCUT_F BIT(23)
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_F_SH 21
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_F_MSK 0x3
#define B_AX_S0_DAI2V_LDO2PWRCUT_F BIT(20)
#define B_AX_S0_RXBB__LDO_VSEL_F__SH 18
#define B_AX_S0_RXBB__LDO_VSEL_F__MSK 0x3
#define B_AX_S0_RXBB__LDO2PWRCUT_F_ BIT(17)
#define B_AX_S0_RXBB__LDO_VSEL_F_SH 15
#define B_AX_S0_RXBB__LDO_VSEL_F_MSK 0x3
#define B_AX_S0_RXBB_LDO2PWRCUT_F BIT(14)
#define B_AX_S1_DA1_LDO_VSEL_F_SH 12
#define B_AX_S1_DA1_LDO_VSEL_F_MSK 0x3
#define B_AX_S1_DA1_LDO2PWRCUT_F BIT(11)
#define B_AX_S1_DA0_LDO_VSEL_F_SH 9
#define B_AX_S1_DA0_LDO_VSEL_F_MSK 0x3
#define B_AX_S1_DA0_LDO2PWRCUT_F BIT(8)
#define B_AX_S1_AD2_LDO_VSEL_F_SH 6
#define B_AX_S1_AD2_LDO_VSEL_F_MSK 0x3
#define B_AX_S1_AD2_LDO2PWRCUT_F BIT(5)
#define B_AX_S1_AD1_LDO_VSEL_F_SH 3
#define B_AX_S1_AD1_LDO_VSEL_F_MSK 0x3
#define B_AX_S1_AD1_LDO2PWRCUT_F BIT(2)
#define B_AX_S1_AD0_LDO_VSEL_F_SH 0
#define B_AX_S1_AD0_LDO_VSEL_F_MSK 0x3

#define R_AX_ANAPAR_POW_XTAL_F 0x0340
#define B_AX_POW_XTAL_F BIT(1)
#define B_AX_POW_BG_F BIT(0)

#define R_AX_XTAL_ON_CTRL0_F 0x0344
#define B_AX_XTAL_SC_LPS_F BIT(31)
#define B_AX_XTAL_SC_INIT_F_SH 24
#define B_AX_XTAL_SC_INIT_F_MSK 0x7f
#define B_AX_XTAL_SC_XO_F_SH 17
#define B_AX_XTAL_SC_XO_F_MSK 0x7f
#define B_AX_XTAL_SC_XI_F_SH 10
#define B_AX_XTAL_SC_XI_F_MSK 0x7f
#define B_AX_XTAL_GMN_F_SH 5
#define B_AX_XTAL_GMN_F_MSK 0x1f
#define B_AX_XTAL_GMP_F_SH 0
#define B_AX_XTAL_GMP_F_MSK 0x1f

#define R_AX_XTAL_ON_CTRL1_F 0x0348
#define B_AX_XTAL_VREF_SEL_F_SH 29
#define B_AX_XTAL_VREF_SEL_F_MSK 0x7
#define B_AX_XTAL_LPS_DIVISOR_F BIT(28)
#define B_AX_XTAL_CKDIGI_SEL_F BIT(27)
#define B_AX_EN_XTAL_SCHMITT_F BIT(26)
#define B_AX_XTAL_SEL_TOK_F_SH 23
#define B_AX_XTAL_SEL_TOK_F_MSK 0x7
#define B_AX_EN_XTAL_LPS_CLK_F BIT(22)
#define B_AX_XTAL_AAC_OPCUR_F_SH 20
#define B_AX_XTAL_AAC_OPCUR_F_MSK 0x3
#define B_AX_XTAL_LDO_VREF_F_SH 17
#define B_AX_XTAL_LDO_VREF_F_MSK 0x7
#define B_AX_EN_XTAL_DRV_BT_F BIT(16)
#define B_AX_EN_XTAL_DRV_CPHY_F BIT(15)
#define B_AX_EN_XTAL_DRV_IQK_BCN_F BIT(14)
#define B_AX_EN_XTAL_DRV_LPS_F BIT(13)
#define B_AX_EN_XTAL_DRV_DIGI_F BIT(12)
#define B_AX_EN_XTAL_DRV_USB_F BIT(11)
#define B_AX_EN_XTAL_DRV_AFE_F BIT(10)
#define B_AX_XTAL_DRV_RF2N_RELAY_F BIT(9)
#define B_AX_XTAL_DRV_RF2P_RELAY_F BIT(8)
#define B_AX_EN_XTAL_DRV_RF2_F BIT(7)
#define B_AX_EN_XTAL_DRV_RF1_F BIT(6)
#define B_AX_XTAL_SC_LPS_F__SH 0
#define B_AX_XTAL_SC_LPS_F__MSK 0x3f

#define R_AX_XTAL_ON_CTRL2_F 0x034C
#define B_AX_XTAL_CFIX_F_SH 4
#define B_AX_XTAL_CFIX_F_MSK 0x3
#define B_AX_AAC_MODE_F_SH 2
#define B_AX_AAC_MODE_F_MSK 0x3
#define B_AX_XTAL_VREF_SEL_F__SH 0
#define B_AX_XTAL_VREF_SEL_F__MSK 0x3

#define R_AX_XTAL_OFF_CTRL0_F 0x0350
#define B_AX_XTAL_PK_SEL_OFFSET_F BIT(31)
#define B_AX_XTAL_MANU_PK_SEL_F_SH 29
#define B_AX_XTAL_MANU_PK_SEL_F_MSK 0x3
#define B_AX_XTAL_AACK_PK_MANU_F BIT(28)
#define B_AX_EN_XTAL_AAC_PKDET_F BIT(27)
#define B_AX_EN_XTAL_AAC_GM_F BIT(26)
#define B_AX_XTAL_LDO_OPVB_SEL_F BIT(25)
#define B_AX_XTAL_LDO_NC_F BIT(24)
#define B_AX_XTAL_LPMODE_F BIT(23)
#define B_AX_XTAL_DELAY_DIGI_F BIT(22)
#define B_AX_XTAL_DELAY_USB_F BIT(21)
#define B_AX_XTAL_DELAY_AFE_F BIT(20)
#define B_AX_XTAL_DRV_BT_F_SH 18
#define B_AX_XTAL_DRV_BT_F_MSK 0x3
#define B_AX_XTAL_DRV_DIGI_F_SH 16
#define B_AX_XTAL_DRV_DIGI_F_MSK 0x3
#define B_AX_XTAL_DRV_USB_F_SH 14
#define B_AX_XTAL_DRV_USB_F_MSK 0x3
#define B_AX_XTAL_DRV_AFE_F_SH 12
#define B_AX_XTAL_DRV_AFE_F_MSK 0x3
#define B_AX_XTAL_DRV_RF2_RELAY_F_SH 10
#define B_AX_XTAL_DRV_RF2_RELAY_F_MSK 0x3
#define B_AX_XTAL_DRV_RF2_F_SH 8
#define B_AX_XTAL_DRV_RF2_F_MSK 0x3
#define B_AX_XTAL_DRV_RF1_F_SH 6
#define B_AX_XTAL_DRV_RF1_F_MSK 0x3
#define B_AX_XTAL_DRV_RF_LATCH_F BIT(5)
#define B_AX_XTAL_GM_SEP_F BIT(4)
#define B_AX_XQSEL_RF_AWAKE_F BIT(3)
#define B_AX_XQSEL_RF_INITIAL_F BIT(2)
#define B_AX_XQSEL_F BIT(1)
#define B_AX_GATED_XTAL_OK0_F BIT(0)

#define R_AX_XTAL_OFF_CTRL1_F 0x0354
#define B_AX_XTAL_SRC_CPHY_F_SH 28
#define B_AX_XTAL_SRC_CPHY_F_MSK 0x7
#define B_AX_XTAL_SRC_IQK_BCN_F_SH 25
#define B_AX_XTAL_SRC_IQK_BCN_F_MSK 0x7
#define B_AX_XTAL_SRC_BT_F_SH 22
#define B_AX_XTAL_SRC_BT_F_MSK 0x7
#define B_AX_XTAL_SRC_RF_F_SH 19
#define B_AX_XTAL_SRC_RF_F_MSK 0x7
#define B_AX_XTAL_DRV_CPHY_F_SH 17
#define B_AX_XTAL_DRV_CPHY_F_MSK 0x3
#define B_AX_XTAL_LDO_VREF_UP_F_SH 14
#define B_AX_XTAL_LDO_VREF_UP_F_MSK 0x7
#define B_AX_XTAL_EN_LNBUF_F BIT(13)
#define B_AX_XTAL__AAC_TIE_MID_F BIT(12)
#define B_AX_XTAL_AAC_IOFFSET_F_SH 10
#define B_AX_XTAL_AAC_IOFFSET_F_MSK 0x3
#define B_AX_XTAL_AAC_CAP_F_SH 8
#define B_AX_XTAL_AAC_CAP_F_MSK 0x3
#define B_AX_XTAL_PDSW_F_SH 6
#define B_AX_XTAL_PDSW_F_MSK 0x3
#define B_AX_XTAL_LPS_BUF_VB_F_SH 4
#define B_AX_XTAL_LPS_BUF_VB_F_MSK 0x3
#define B_AX_XTAL_PDCK_MANU_F BIT(3)
#define B_AX_XTAL_PDCK_OK_MANU_F BIT(2)
#define B_AX_EN_XTAL_PDCK_VREF_F BIT(1)
#define B_AX_XTAL_SEL_PWR_F BIT(0)

#define R_AX_XTAL_ACCK 0x0358
#define B_AX_PKDET_OUT BIT(31)
#define B_AX_AAC_MODE_SEL_SH 6
#define B_AX_AAC_MODE_SEL_MSK 0x3
#define B_AX_XAAC_OK BIT(5)
#define B_AX_XAAC_GM_OFFSET__SH 0
#define B_AX_XAAC_GM_OFFSET__MSK 0x1f

#define R_AX_PDCK_RESULT 0x035C
#define B_AX_PDCK_BUST_RESULT BIT(6)
#define B_AX_PDCK_RDY_RESULT BIT(5)
#define B_AX_PDCK_VREF_RESULT_SH 0
#define B_AX_PDCK_VREF_RESULT_MSK 0x1f

#define R_AX_PDCK_CTRL 0x0384
#define B_AX_PDCK_BUSY_O BIT(22)
#define B_AX_PDCK_RDY_O BIT(21)
#define B_AX_PDCK_VREF_O_SH 16
#define B_AX_PDCK_VREF_O_MSK 0x1f
#define B_AX_PDCK_WL_RDY BIT(13)
#define B_AX_PDCK_WL_BUSY BIT(12)
#define B_AX_PDCK_BT_GNT BIT(11)
#define B_AX_PDCK_WL_GNT BIT(10)
#define B_AX_PDCK_BT_REQ BIT(9)
#define B_AX_PDCK_WL_REQ BIT(8)
#define B_AX_PDCK_SRC_SEL BIT(7)
#define B_AX_PDCK_BUSY BIT(6)
#define B_AX_PDCK_RDY BIT(5)
#define B_AX_PDCK_VREF_SH 0
#define B_AX_PDCK_VREF_MSK 0x1f

#define R_AX_SYM_OSC32K_CTRL 0x0390
#define B_AX_OSC32K_CAL_SEL BIT(11)
#define B_AX_SYM_OSC32K_SEL BIT(10)
#define B_AX_SYM_OSC32K_OUTSEL BIT(9)
#define B_AX_SYM_OSC32K_SELLDOVREF BIT(8)
#define B_AX_SYM_OSC32K_RCAL_SH 0
#define B_AX_SYM_OSC32K_RCAL_MSK 0x3f

#define R_AX_IC_PWR_STATE 0x03F0
#define B_AX_WHOLE_SYS_PWR_STE_SH 16
#define B_AX_WHOLE_SYS_PWR_STE_MSK 0x3ff
#define B_AX_WLMAC_PWR_STE_SH 8
#define B_AX_WLMAC_PWR_STE_MSK 0x3
#define B_AX_UART_HCISYS_PWR_STE_SH 6
#define B_AX_UART_HCISYS_PWR_STE_MSK 0x3
#define B_AX_SDIO_HCISYS_PWR_STE_SH 4
#define B_AX_SDIO_HCISYS_PWR_STE_MSK 0x3
#define B_AX_USB_HCISYS_PWR_STE_SH 2
#define B_AX_USB_HCISYS_PWR_STE_MSK 0x3
#define B_AX_PCIE_HCISYS_PWR_STE_SH 0
#define B_AX_PCIE_HCISYS_PWR_STE_MSK 0x3

#define R_AX_SPSLDO_OFF_CTRL0 0x0400
#define B_AX_SDZN_L_SH 30
#define B_AX_SDZN_L_MSK 0x3
#define B_AX_REG_AUTOZCD_L BIT(29)
#define B_AX_REG_VOFB_SEL BIT(28)
#define B_AX_TBOX_L1_SH 26
#define B_AX_TBOX_L1_MSK 0x3
#define B_AX_ENOCPMUX_L BIT(25)
#define B_AX_FORCE_LDOS BIT(24)
#define B_AX_VO_DISCHG BIT(23)
#define B_AX_LDO_OC_CLAMP BIT(22)
#define B_AX_MINOFF_LIQ BIT(21)
#define B_AX_MINON_LIQ BIT(20)
#define B_AX_POW_AUTO_L BIT(19)
#define B_AX_ARENB_H BIT(18)
#define B_AX_NO_OFFTIME_L BIT(17)
#define B_AX_EN_ON_END_L BIT(16)
#define B_AX_ENCOT_L BIT(15)
#define B_AX_REG_CLK_SEL_SH 13
#define B_AX_REG_CLK_SEL_MSK 0x3
#define B_AX_REG_TYPE_L BIT(12)
#define B_AX_R3_L1_SH 10
#define B_AX_R3_L1_MSK 0x3
#define B_AX_R2_L1_SH 8
#define B_AX_R2_L1_MSK 0x3
#define B_AX_R1_L1_SH 6
#define B_AX_R1_L1_MSK 0x3
#define B_AX_C3_L1_SH 4
#define B_AX_C3_L1_MSK 0x3
#define B_AX_C2_L1_SH 2
#define B_AX_C2_L1_MSK 0x3
#define B_AX_C1_L1_SH 0
#define B_AX_C1_L1_MSK 0x3

#define R_AX_SPSLDO_OFF_CTRL1 0x0404
#define B_AX_REG_NMOS_OFF_L BIT(5)
#define B_AX_REG_MUX_PI_L BIT(4)
#define B_AX_REG_PWM_CTRL_L BIT(3)
#define B_AX_ENSR_L BIT(2)
#define B_AX_SDZP_L_SH 0
#define B_AX_SDZP_L_MSK 0x3

#define R_AX_SPSANA_OFF_CTRL0 0x0420

#define R_AX_SPSANA_OFF_CTRL1 0x0424

#define R_AX_AFE_OFF_CTRL0 0x0440
#define B_AX_S1_AD0_LDO2PWRCUT BIT(31)
#define B_AX_S1_AD_SEL_Q_SH 27
#define B_AX_S1_AD_SEL_Q_MSK 0xf
#define B_AX_S1_AD_SEL_I_SH 23
#define B_AX_S1_AD_SEL_I_MSK 0xf
#define B_AX_S0_DA1_LDO_VSEL_SH 21
#define B_AX_S0_DA1_LDO_VSEL_MSK 0x3
#define B_AX_S0_DA1_LDO2PWRCUT BIT(20)
#define B_AX_S0_DA0_LDO_VSEL_SH 18
#define B_AX_S0_DA0_LDO_VSEL_MSK 0x3
#define B_AX_S0_DA0_LDO2PWRCUT BIT(17)
#define B_AX_S0_AD2_LDO_VSEL_SH 15
#define B_AX_S0_AD2_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD2_LDO2PWRCUT BIT(14)
#define B_AX_S0_AD1_LDO_VSEL_SH 12
#define B_AX_S0_AD1_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD1_LDO2PWRCUT BIT(11)
#define B_AX_S0_AD0_LDO_VSEL_SH 9
#define B_AX_S0_AD0_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD0_LDO2PWRCUT BIT(8)
#define B_AX_S0_AD_SEL_Q_SH 4
#define B_AX_S0_AD_SEL_Q_MSK 0xf
#define B_AX_S0_AD_SEL_I_SH 0
#define B_AX_S0_AD_SEL_I_MSK 0xf

#define R_AX_AFE_OFF_CTRL1 0x0444
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_SH 24
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_MSK 0x3
#define B_AX_S1_DAI2V_LDO2PWRCUT BIT(23)
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL__SH 21
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL__MSK 0x3
#define B_AX_S0_DAI2V_LDO2PWRCUT BIT(20)
#define B_AX_S0_RXBB__LDO_VSEL_SH 18
#define B_AX_S0_RXBB__LDO_VSEL_MSK 0x3
#define B_AX_S0_RXBB__LDO2PWRCUT BIT(17)
#define B_AX_S0_RXBB__LDO_VSEL__SH 15
#define B_AX_S0_RXBB__LDO_VSEL__MSK 0x3
#define B_AX_S0_RXBB_LDO2PWRCUT BIT(14)
#define B_AX_S1_DA1_LDO_VSEL_SH 12
#define B_AX_S1_DA1_LDO_VSEL_MSK 0x3
#define B_AX_S1_DA1_LDO2PWRCUT BIT(11)
#define B_AX_S1_DA0_LDO_VSEL_SH 9
#define B_AX_S1_DA0_LDO_VSEL_MSK 0x3
#define B_AX_S1_DA0_LDO2PWRCUT BIT(8)
#define B_AX_S1_AD2_LDO_VSEL_SH 6
#define B_AX_S1_AD2_LDO_VSEL_MSK 0x3
#define B_AX_S1_AD2_LDO2PWRCUT BIT(5)
#define B_AX_S1_AD1_LDO_VSEL_SH 3
#define B_AX_S1_AD1_LDO_VSEL_MSK 0x3
#define B_AX_S1_AD1_LDO2PWRCUT BIT(2)
#define B_AX_S1_AD0_LDO_VSEL_SH 0
#define B_AX_S1_AD0_LDO_VSEL_MSK 0x3

#define R_AX_XTAL_OFF_CTRL0 0x0480
#define B_AX_XTAL_PK_SEL_OFFSET BIT(31)
#define B_AX_XTAL_MANU_PK_SEL_SH 29
#define B_AX_XTAL_MANU_PK_SEL_MSK 0x3
#define B_AX_XTAL_AACK_PK_MANU BIT(28)
#define B_AX_EN_XTAL_AAC_PKDET BIT(27)
#define B_AX_EN_XTAL_AAC_GM BIT(26)
#define B_AX_XTAL_LDO_OPVB_SEL BIT(25)
#define B_AX_XTAL_LDO_NC BIT(24)
#define B_AX_XTAL_LPMODE BIT(23)
#define B_AX_XTAL_DELAY_DIGI BIT(22)
#define B_AX_XTAL_DELAY_USB BIT(21)
#define B_AX_XTAL_DELAY_AFE BIT(20)
#define B_AX_XTAL_DRV_BT_SH 18
#define B_AX_XTAL_DRV_BT_MSK 0x3
#define B_AX_XTAL_DRV_DIGI_SH 16
#define B_AX_XTAL_DRV_DIGI_MSK 0x3
#define B_AX_XTAL_DRV_USB_SH 14
#define B_AX_XTAL_DRV_USB_MSK 0x3
#define B_AX_XTAL_DRV_AFE_SH 12
#define B_AX_XTAL_DRV_AFE_MSK 0x3
#define B_AX_XTAL_DRV_RF2_RELAY_SH 10
#define B_AX_XTAL_DRV_RF2_RELAY_MSK 0x3
#define B_AX_XTAL_DRV_RF2_SH 8
#define B_AX_XTAL_DRV_RF2_MSK 0x3
#define B_AX_XTAL_DRV_RF1_SH 6
#define B_AX_XTAL_DRV_RF1_MSK 0x3
#define B_AX_XTAL_DRV_RF_LATCH BIT(5)
#define B_AX_XTAL_GM_SEP BIT(4)
#define B_AX_XQSEL_RF_AWAKE BIT(3)
#define B_AX_XQSEL_RF_INITIAL BIT(2)
#define B_AX_XQSEL BIT(1)
#define B_AX_GATED_XTAL_OK0 BIT(0)

#define R_AX_XTAL_OFF_CTRL1 0x0484
#define B_AX_XTAL_SRC_CPHY_SH 28
#define B_AX_XTAL_SRC_CPHY_MSK 0x7
#define B_AX_XTAL_SRC_IQK_BCN_SH 25
#define B_AX_XTAL_SRC_IQK_BCN_MSK 0x7
#define B_AX_XTAL_SRC_BT_SH 22
#define B_AX_XTAL_SRC_BT_MSK 0x7
#define B_AX_XTAL_SRC_RF_SH 19
#define B_AX_XTAL_SRC_RF_MSK 0x7
#define B_AX_XTAL_DRV_CPHY_SH 17
#define B_AX_XTAL_DRV_CPHY_MSK 0x3
#define B_AX_XTAL_LDO_VREF_UP_SH 14
#define B_AX_XTAL_LDO_VREF_UP_MSK 0x7
#define B_AX_XTAL_EN_LNBUF BIT(13)
#define B_AX_XTAL__AAC_TIE_MID BIT(12)
#define B_AX_XTAL_AAC_IOFFSET_SH 10
#define B_AX_XTAL_AAC_IOFFSET_MSK 0x3
#define B_AX_XTAL_AAC_CAP_SH 8
#define B_AX_XTAL_AAC_CAP_MSK 0x3
#define B_AX_XTAL_PDSW_SH 6
#define B_AX_XTAL_PDSW_MSK 0x3
#define B_AX_XTAL_LPS_BUF_VB_SH 4
#define B_AX_XTAL_LPS_BUF_VB_MSK 0x3
#define B_AX_XTAL_PDCK_MANU BIT(3)
#define B_AX_XTAL_PDCK_OK_MANU BIT(2)
#define B_AX_EN_XTAL_PDCK_VREF BIT(1)
#define B_AX_XTAL_SEL_PWR BIT(0)

#define R_AX_SYM_ANAPAR_XTAL_AAC_0 0x04A0
#define B_AX_XAAC_LPOW BIT(31)
#define B_AX_AAC_MODE__SH 29
#define B_AX_AAC_MODE__MSK 0x3
#define B_AX_EN_XTAL_AAC_TRIG BIT(28)
#define B_AX_EN_XTAL_AAC BIT(27)
#define B_AX_EN_XTAL_AAC_DIGI BIT(26)
#define B_AX_GM_MANUAL_SH 21
#define B_AX_GM_MANUAL_MSK 0x1f
#define B_AX_GM_STUP_SH 16
#define B_AX_GM_STUP_MSK 0x1f
#define B_AX_XTAL_CK_SET_SH 13
#define B_AX_XTAL_CK_SET_MSK 0x7
#define B_AX_GM_INIT_SH 8
#define B_AX_GM_INIT_MSK 0x1f
#define B_AX_GM_STEP BIT(7)
#define B_AX_XAAC_GM_OFFSET_SH 2
#define B_AX_XAAC_GM_OFFSET_MSK 0x1f
#define B_AX_OFFSET_PLUS BIT(1)
#define B_AX_RESET_N_AAC BIT(0)

#define R_AX_SYM_ANAPAR_XTAL_AAC_1 0x04A4
#define B_AX_PK_END_AR_SH 2
#define B_AX_PK_END_AR_MSK 0x3
#define B_AX_PK_START_AR_SH 0
#define B_AX_PK_START_AR_MSK 0x3

#define R_AX_XAAC_XAACK_RO_DATA 0x04A8
#define B_AX_XAACK_DBG_SH 20
#define B_AX_XAACK_DBG_MSK 0x7
#define B_AX_XAACK_STATE_SH 16
#define B_AX_XAACK_STATE_MSK 0xf
#define B_AX_XAAC_DONE_SH 0
#define B_AX_XAAC_DONE_MSK 0xffff

#define R_AX_SYM_ANAPAR_XTAL_PDCK 0x04C0
#define B_AX_PDCK_LPOW BIT(22)
#define B_AX_PDCK_VREF_SEL_SH 17
#define B_AX_PDCK_VREF_SEL_MSK 0x1f
#define B_AX_PDCK_UNIT_SH 15
#define B_AX_PDCK_UNIT_MSK 0x3
#define B_AX_PDCK_VREF_INIT_SH 10
#define B_AX_PDCK_VREF_INIT_MSK 0x1f
#define B_AX_PDCK_VREF_MANUAL_SH 5
#define B_AX_PDCK_VREF_MANUAL_MSK 0x1f
#define B_AX_PDCK_WAIT_CYC_SH 3
#define B_AX_PDCK_WAIT_CYC_MSK 0x3
#define B_AX_PDCK_SEARCH_MODE BIT(2)
#define B_AX_PDCK_DIGI BIT(1)
#define B_AX_PDCK_EN BIT(0)
#define B_AX_PSPHY_GPIO_MODE BIT(1)
#define B_AX_WPHY_SCAN_MODE BIT(0)

//
// AON_C
//

#define R_AX_SEC_CTRL 0x0C00
#define B_AX_SEC_IDMEM_SIZE_CONFIG_SH 16
#define B_AX_SEC_IDMEM_SIZE_CONFIG_MSK 0x3
#define B_AX_SEC_BT_SEC1_DIS BIT(15)
#define B_AX_SEC_BT_SEC0_DIS BIT(14)
#define B_AX_DBG_LV_SH 11
#define B_AX_DBG_LV_MSK 0x7
#define B_AX_DBG_PATH_SH 8
#define B_AX_DBG_PATH_MSK 0x7
#define B_AX_SEC_UART_RX_EN BIT(4)
#define B_AX_SEC_UART_TX_EN BIT(3)
#define B_AX_SEC_JTAG_EN BIT(2)
#define B_AX_SEC_SIC_EN BIT(1)
#define B_AX_SEC_SEC_DIS BIT(0)

#define R_AX_FILTER_MODEL_ADDR 0x0C04
#define B_AX_SEC_FILTER_MODEL_ADDR_SH 0
#define B_AX_SEC_FILTER_MODEL_ADDR_MSK 0xffffffffL

#define R_AX_EFUSE_CTRL_S 0x0C30
#define B_AX_EF_MODE_SEL_S_SH 30
#define B_AX_EF_MODE_SEL_S_MSK 0x3
#define B_AX_EF_RDY_S BIT(29)
#define B_AX_EF_ADDR_S_SH 16
#define B_AX_EF_ADDR_S_MSK 0x7ff
#define B_AX_EF_DATA_S_SH 0
#define B_AX_EF_DATA_S_MSK 0xffff

#define R_AX_EFUSE_TEST_S 0x0C34
#define B_AX_EF_CRES_SEL_S BIT(31)
#define B_AX_EF_SCAN_SADR_S_SH 19
#define B_AX_EF_SCAN_SADR_S_MSK 0x7ff
#define B_AX_EF_SCAN_EADR_S_SH 8
#define B_AX_EF_SCAN_EADR_S_MSK 0x7ff
#define B_AX_EF_SCAN_TRPT_S BIT(7)
#define B_AX_EF_SCAN_FTHR_S_SH 0
#define B_AX_EF_SCAN_FTHR_S_MSK 0x7f

//
// WL_AX_Reg_AON.xls
//

//
// AON
//
#define B_AX_SOP_OFF_CAPC_EN BIT(23)
#define B_AX_DIS_WLBT_PDNSUSEN_SOPC BIT(18)
#define B_AX_PSUS_OFF_CAPC_EN BIT(14)
#define B_AX_AUTOLOAD_DIS BIT(4)
#define B_AX_PINMUX_PTA_EN BIT(10)
#define B_AX_WL_BT_PTA_SEC BIT(9)
#define B_AX_LED2_EN BIT(22)
#define B_AX_BTGP_UART0_SEL BIT(27)
#define B_AX_BTGPDBG_EN BIT(17)
#define B_AX_BTGP_I2C_EN BIT(16)
#define B_AX_PCIE_DIS_L2_CTRL_LDO_HCI BIT(15)
#define B_AX_PCIE_DIS_WLSUS_AFT_PDN BIT(14)
#define B_AX_PCIE_CALIB_EN BIT(12)
#define B_AX_LPSOP_OFF_CAPC_EN BIT(27)
#define B_AX_DIS_WLBT_LPSEN_LOPC BIT(1)
#define B_AX_HALT_C2H_ERROR_SENARIO_SH 28
#define B_AX_HALT_C2H_ERROR_SENARIO_MSK 0xf
#define B_AX_ERROR_CODE_SH 0
#define B_AX_ERROR_CODE_MSK 0xffff
#define B_AX_UDM0_SEND2RA_CNT_SH 28
#define B_AX_UDM0_SEND2RA_CNT_MSK 0xf
#define B_AX_UDM0_TX_RPT_CNT_SH 24
#define B_AX_UDM0_TX_RPT_CNT_MSK 0xf
#define B_AX_UDM0_FS_CODE_SH 8
#define B_AX_UDM0_FS_CODE_MSK 0xffff
#define B_AX_NULL_POINTER_INDC BIT(7)
#define B_AX_ROM_ASSERT_INDC BIT(6)
#define B_AX_RAM_ASSERT_INDC BIT(5)
#define B_AX_FW_IMAGE_TYPE BIT(4)
#define B_AX_UDM0_TRAP_LOOP_CTRL BIT(2)
#define B_AX_UDM0_SEND_HALTC2H_CTRL BIT(1)
#define B_AX_UDM0_DBG_MODE_CTRL BIT(0)
#define B_AX_UDM1_ERROR_ADDR_SH 0
#define B_AX_UDM1_ERROR_ADDR_MSK 0xffffffffL
#define B_AX_UDM2_EPC_RA_SH 0
#define B_AX_UDM2_EPC_RA_MSK 0xffffffffL

#define R_AX_SPS_DIG_ON_CTRL0 0x0200

#define R_AX_SPS_DIG_ON_CTRL1 0x0204

#define R_AX_SPS_ANA_ON_CTRL0 0x0220

#define R_AX_SPS_ANA_ON_CTRL1 0x0224

#define R_AX_GPIO0_7_FUNC_SEL 0x02D0
#define B_AX_PINMUX_GPIO7_FUNC_SEL_SH 28
#define B_AX_PINMUX_GPIO7_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO6_FUNC_SEL_SH 24
#define B_AX_PINMUX_GPIO6_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO5_FUNC_SEL_SH 20
#define B_AX_PINMUX_GPIO5_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO4_FUNC_SEL_SH 16
#define B_AX_PINMUX_GPIO4_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO3_FUNC_SEL_SH 12
#define B_AX_PINMUX_GPIO3_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO2_FUNC_SEL_SH 8
#define B_AX_PINMUX_GPIO2_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO1_FUNC_SEL_SH 4
#define B_AX_PINMUX_GPIO1_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO0_FUNC_SEL_SH 0
#define B_AX_PINMUX_GPIO0_FUNC_SEL_MSK 0xf

#define R_AX_GPIO8_15_FUNC_SEL 0x02D4
#define B_AX_PINMUX_GPIO15_FUNC_SEL_SH 28
#define B_AX_PINMUX_GPIO15_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO14_FUNC_SEL_SH 24
#define B_AX_PINMUX_GPIO14_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO13_FUNC_SEL_SH 20
#define B_AX_PINMUX_GPIO13_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO12_FUNC_SEL_SH 16
#define B_AX_PINMUX_GPIO12_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO11_FUNC_SEL_SH 12
#define B_AX_PINMUX_GPIO11_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO10_FUNC_SEL_SH 8
#define B_AX_PINMUX_GPIO10_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO9_FUNC_SEL_SH 4
#define B_AX_PINMUX_GPIO9_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO8_FUNC_SEL_SH 0
#define B_AX_PINMUX_GPIO8_FUNC_SEL_MSK 0xf

#define R_AX_EECS_EESK_FUNC_SEL 0x02D8
#define B_AX_PINMUX_LED1_FUNC_SEL_SH 8
#define B_AX_PINMUX_LED1_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_EESK_FUNC_SEL_SH 4
#define B_AX_PINMUX_EESK_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_EECS_FUNC_SEL_SH 0
#define B_AX_PINMUX_EECS_FUNC_SEL_MSK 0xf

#define R_AX_GPIO0_15_EECS_EESK_LED1_PULL_HIGH_EN 0x02E0
#define B_AX_LED1_PULL_HIGH_EN BIT(18)
#define B_AX_EESK_PULL_HIGH_EN BIT(17)
#define B_AX_EECS_PULL_HIGH_EN BIT(16)
#define B_AX_GPIO15_PULL_HIGH_EN BIT(15)
#define B_AX_GPIO14_PULL_HIGH_EN BIT(14)
#define B_AX_GPIO13_PULL_HIGH_EN BIT(13)
#define B_AX_GPIO12_PULL_HIGH_EN BIT(12)
#define B_AX_GPIO11_PULL_HIGH_EN BIT(11)
#define B_AX_GPIO10_PULL_HIGH_EN BIT(10)
#define B_AX_GPIO9_PULL_HIGH_EN BIT(9)
#define B_AX_GPIO8_PULL_HIGH_EN BIT(8)
#define B_AX_GPIO7_PULL_HIGH_EN BIT(7)
#define B_AX_GPIO6_PULL_HIGH_EN BIT(6)
#define B_AX_GPIO5_PULL_HIGH_EN BIT(5)
#define B_AX_GPIO4_PULL_HIGH_EN BIT(4)
#define B_AX_GPIO3_PULL_HIGH_EN BIT(3)
#define B_AX_GPIO2_PULL_HIGH_EN BIT(2)
#define B_AX_GPIO1_PULL_HIGH_EN BIT(1)
#define B_AX_GPIO0_PULL_HIGH_EN BIT(0)

#define R_AX_GPIO0_15_EECS_EESK_LED1_PULL_LOW_EN 0x02E4
#define B_AX_LED1_PULL_LOW_EN BIT(18)
#define B_AX_EESK_PULL_LOW_EN BIT(17)
#define B_AX_EECS_PULL_LOW_EN BIT(16)
#define B_AX_GPIO15_PULL_LOW_EN BIT(15)
#define B_AX_GPIO14_PULL_LOW_EN BIT(14)
#define B_AX_GPIO13_PULL_LOW_EN BIT(13)
#define B_AX_GPIO12_PULL_LOW_EN BIT(12)
#define B_AX_GPIO11_PULL_LOW_EN BIT(11)
#define B_AX_GPIO10_PULL_LOW_EN BIT(10)
#define B_AX_GPIO9_PULL_LOW_EN BIT(9)
#define B_AX_GPIO8_PULL_LOW_EN BIT(8)
#define B_AX_GPIO7_PULL_LOW_EN BIT(7)
#define B_AX_GPIO6_PULL_LOW_EN BIT(6)
#define B_AX_GPIO5_PULL_LOW_EN BIT(5)
#define B_AX_GPIO4_PULL_LOW_EN BIT(4)
#define B_AX_GPIO3_PULL_LOW_EN BIT(3)
#define B_AX_GPIO2_PULL_LOW_EN BIT(2)
#define B_AX_GPIO1_PULL_LOW_EN BIT(1)
#define B_AX_GPIO0_PULL_LOW_EN BIT(0)

#define R_AX_GPIO0_15_EECS_EESK_LED1_E2_EN 0x02E8
#define B_AX_LED1_PAD_E2 BIT(18)
#define B_AX_EESK_PAD_E2 BIT(17)
#define B_AX_EECS_PAD_E2 BIT(16)
#define B_AX_SYSON_GPIO15_PAD_E2 BIT(15)
#define B_AX_SYSON_GPIO14_PAD_E2 BIT(14)
#define B_AX_SYSON_GPIO13_PAD_E2 BIT(13)
#define B_AX_SYSON_GPIO12_PAD_E2 BIT(12)
#define B_AX_SYSON_GPIO11_PAD_E2 BIT(11)
#define B_AX_SYSON_GPIO10_PAD_E2 BIT(10)
#define B_AX_SYSON_GPIO9_PAD_E2 BIT(9)
#define B_AX_SYSON_GPIO8_PAD_E2 BIT(8)
#define B_AX_SYSON_GPIO7_PAD_E2 BIT(7)
#define B_AX_SYSON_GPIO6_PAD_E2 BIT(6)
#define B_AX_SYSON_GPIO5_PAD_E2 BIT(5)
#define B_AX_SYSON_GPIO4_PAD_E2 BIT(4)
#define B_AX_SYSON_GPIO3_PAD_E2 BIT(3)
#define B_AX_SYSON_GPIO2_PAD_E2 BIT(2)
#define B_AX_SYSON_GPIO1_PAD_E2 BIT(1)
#define B_AX_SYSON_GPIO0_PAD_E2 BIT(0)

#define R_AX_GPIO0_15_EECS_EESK_LED1_SMT_EN 0x02EC
#define B_AX_LED1_PAD_SMT_CTRL BIT(18)
#define B_AX_EESK_PAD_SMT_CTRL BIT(17)
#define B_AX_EECS_PAD_SMT_CTRL BIT(16)
#define B_AX_GPIO15_PAD_SMT_CTRL BIT(15)
#define B_AX_GPIO14_PAD_SMT_CTRL BIT(14)
#define B_AX_GPIO13_PAD_SMT_CTRL BIT(13)
#define B_AX_GPIO12_PAD_SMT_CTRL BIT(12)
#define B_AX_GPIO11_PAD_SMT_CTRL BIT(11)
#define B_AX_GPIO10_PAD_SMT_CTRL BIT(10)
#define B_AX_GPIO9_PAD_SMT_CTRL BIT(9)
#define B_AX_GPIO8_PAD_SMT_CTRL BIT(8)
#define B_AX_GPIO7_PAD_SMT_CTRL BIT(7)
#define B_AX_GPIO6_PAD_SMT_CTRL BIT(6)
#define B_AX_GPIO5_PAD_SMT_CTRL BIT(5)
#define B_AX_GPIO4_PAD_SMT_CTRL BIT(4)
#define B_AX_GPIO3_PAD_SMT_CTRL BIT(3)
#define B_AX_GPIO2_PAD_SMT_CTRL BIT(2)
#define B_AX_GPIO1_PAD_SMT_CTRL BIT(1)
#define B_AX_GPIO0_PAD_SMT_CTRL BIT(0)

//
// AON_C
//
#define B_AX_SEC_FWDL_TIME_V0 BIT(8)
#define B_AX_SEC_AUTH_DONE_V0 BIT(7)

//
// WL_AX_Reg_AON.xls
//

//
// AON
//
#define B_AX_OTP_B_PWC_RPT BIT(15)
#define B_AX_OTP_S_PWC_RPT BIT(14)
#define B_AX_OTP_ISO_RPT BIT(13)
#define B_AX_AUTOLOAD_DIS_A_DIE BIT(6)
#define B_AX_PWC_EV2EF_V1_SH 6
#define B_AX_PWC_EV2EF_V1_MSK 0x3

#define R_AX_SYS_ADIE_PAD_PWR_CTRL 0x0018
#define B_AX_SYM_PADPDN_WL_PTA_1P3 BIT(6)
#define B_AX_SYM_PADPDN_WL_RFC_1P3 BIT(5)

#define R_AX_AFE_LDO_VPULSE_CTRL 0x001A
#define B_AX_SYM_VPULSE_LDO_XBUF BIT(9)
#define B_AX_SYM_VPULSE_LDO_S1_ADDA BIT(3)
#define B_AX_SYM_VPULSE_LDO_S0_ADDA BIT(2)
#define B_AX_SYM_VPULSE_LDO_PLL BIT(0)

#define R_AX_EFUSE_CTRL_1_V1 0x0038
#define B_AX_EF_ENT BIT(31)
#define B_AX_EF_BURST BIT(19)
#define B_AX_EF_TEST_SEL_SH 16
#define B_AX_EF_TEST_SEL_MSK 0x7
#define B_AX_EF_TROW_EN BIT(15)
#define B_AX_EF_ERR_FLAG BIT(14)
#define B_AX_EF_DSB_EN BIT(11)
#define B_AX_BT_OTP_PWC_DIS BIT(28)
#define B_AX_WDT_WAKE_PCIE_EN BIT(10)
#define B_AX_WDT_WAKE_USB_EN BIT(9)
#define B_AX_REG_BG_H BIT(30)

#define R_AX_SPS_DIG_ON_CTRL2 0x0208
#define B_AX_REG_BG_CURRENT_L_SH 3
#define B_AX_REG_BG_CURRENT_L_MSK 0x3
#define B_AX_REG_BG_ANA_L BIT(2)
#define B_AX_REG_BG_DIG_L BIT(1)
#define B_AX_REG_VC_CLAMP_SEL_L BIT(0)

#define R_AX_SPS_DIG_ON_CTRL4 0x0210
#define B_AX_AONLDO_VOSEL_H_SH 4
#define B_AX_AONLDO_VOSEL_H_MSK 0xf
#define B_AX_LV_POR_VREF_SEL BIT(1)
#define B_AX_AONLDO_VREF_SEL BIT(0)
#define B_AX_PFMCMP_IQ_ANA BIT(31)
#define B_AX__REG_BG_H_ANA BIT(30)
#define B_AX_OFF_END_SEL_ANA BIT(29)
#define B_AX_POW_MINOFF_L_ANA BIT(28)
#define B_AX_COT_I_L_ANA_SH 26
#define B_AX_COT_I_L_ANA_MSK 0x3
#define B_AX_VREFPFM_L_ANA_SH 22
#define B_AX_VREFPFM_L_ANA_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS_ANA BIT(21)
#define B_AX_ZCD_SDZ_L_ANA_SH 19
#define B_AX_ZCD_SDZ_L_ANA_MSK 0x3
#define B_AX_REG_ZCDC_H_ANA_SH 17
#define B_AX_REG_ZCDC_H_ANA_MSK 0x3
#define B_AX_POW_ZCD_L_ANA BIT(16)
#define B_AX_OCP_L1_ANA_SH 13
#define B_AX_OCP_L1_ANA_MSK 0x7
#define B_AX_POWOCP_L1_ANA BIT(12)
#define B_AX_SAW_FREQ_L_ANA_SH 8
#define B_AX_SAW_FREQ_L_ANA_MSK 0xf
#define B_AX_REG_BYPASS_L_ANA BIT(7)
#define B_AX_FPWM_L1_ANA BIT(6)
#define B_AX_STD_L1_ANA_SH 4
#define B_AX_STD_L1_ANA_MSK 0x3
#define B_AX_VOL_L1_ANA_SH 0
#define B_AX_VOL_L1_ANA_MSK 0xf
#define B_AX_SN_N_L_ANA_SH 28
#define B_AX_SN_N_L_ANA_MSK 0xf
#define B_AX_SP_N_L_ANA_SH 24
#define B_AX_SP_N_L_ANA_MSK 0xf
#define B_AX_SN_P_L_ANA_SH 20
#define B_AX_SN_P_L_ANA_MSK 0xf
#define B_AX_SP_P_L_ANA_SH 16
#define B_AX_SP_P_L_ANA_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H_ANA BIT(15)
#define B_AX_REG_MODE_PREDRIVER_ANA BIT(14)
#define B_AX_REG_ADJSLDO_L_ANA_SH 10
#define B_AX_REG_ADJSLDO_L_ANA_MSK 0xf
#define B_AX_REG_LDOR_L_ANA BIT(9)
#define B_AX_PWM_FORCE_ANA BIT(8)
#define B_AX_PFM_PD_RST_ANA BIT(7)
#define B_AX_VC_PFM_RSTB_ANA BIT(6)
#define B_AX_PFM_IN_SEL_ANA BIT(5)
#define B_AX_VC_RSTB_ANA BIT(4)
#define B_AX_FPWMDELAY_ANA BIT(3)
#define B_AX_ENFPWMDELAY_H_ANA BIT(2)
#define B_AX_REG_MOS_HALF_L_ANA BIT(1)
#define B_AX_CURRENT_SENSE_MOS_ANA BIT(0)

#define R_AX_SPS_ANA_ON_CTRL2 0x0228
#define B_AX_ZCD_IOFFSET_B_ANA_SH 13
#define B_AX_ZCD_IOFFSET_B_ANA_MSK 0x3
#define B_AX_R2_L1_ANA_SH 10
#define B_AX_R2_L1_ANA_MSK 0x3
#define B_AX_C3_L1_ANA_SH 8
#define B_AX_C3_L1_ANA_MSK 0x3
#define B_AX_C1_L1_ANA_SH 6
#define B_AX_C1_L1_ANA_MSK 0x3
#define B_AX_EXTERNAL_CLK_SEL BIT(5)
#define B_AX_REG_BG_CURRENT_L_ANA_SH 3
#define B_AX_REG_BG_CURRENT_L_ANA_MSK 0x3
#define B_AX_REG_BG_ANA_L_ANA BIT(2)
#define B_AX_REG_BG_DIG_L_ANA BIT(1)
#define B_AX_REG_VC_CLAMP_SEL_L_ANA BIT(0)

#define R_AX_SPS_ANA_ON_CTRL4 0x0230
#define B_AX_SPS_ANA_PFM_ZCDC_H_ANA_SH 4
#define B_AX_SPS_ANA_PFM_ZCDC_H_ANA_MSK 0x3
#define B_AX_SPS_ANA_PFM_OCP_L_ANA_SH 0
#define B_AX_SPS_ANA_PFM_OCP_L_ANA_MSK 0x7
#define B_AX_EN_PC_LDO BIT(2)
#define B_AX_REG_LPF_R3_H_SH 0
#define B_AX_REG_LPF_R3_H_MSK 0x3
#define B_AX_REG_VC_TH BIT(3)
#define B_AX_REG_VC_TL BIT(2)
#define B_AX_REG_CK40M_EN BIT(1)

#define R_AX_WLAN_XTAL_SI_CTRL 0x0270
#define B_AX_WL_XTAL_SI_CMD_POLL BIT(31)
#define B_AX_BT_XTAL_SI_ERR_FLAG BIT(30)
#define B_AX_WL_XTAL_GNT BIT(29)
#define B_AX_BT_XTAL_GNT BIT(28)
#define B_AX_WL_XTAL_SI_MODE_SH 24
#define B_AX_WL_XTAL_SI_MODE_MSK 0x3
#define B_AX_WL_XTAL_SI_BITMASK_SH 16
#define B_AX_WL_XTAL_SI_BITMASK_MSK 0xff
#define B_AX_WL_XTAL_SI_DATA_SH 8
#define B_AX_WL_XTAL_SI_DATA_MSK 0xff
#define B_AX_WL_XTAL_SI_ADDR_SH 0
#define B_AX_WL_XTAL_SI_ADDR_MSK 0xff

#define R_AX_WLAN_XTAL_SI_CONFIG 0x0274
#define B_AX_XTAL_SI_RST BIT(31)
#define B_AX_XTAL_SI_CLK_DIV2 BIT(1)
#define B_AX_XTAL_SI_ADDR_NOT_CHK BIT(0)
#define B_AX_XBUF_SEL_TOK_L_SH 30
#define B_AX_XBUF_SEL_TOK_L_MSK 0x3
#define B_AX_XBUF_LPS_BUF_VB_SH 28
#define B_AX_XBUF_LPS_BUF_VB_MSK 0x3
#define B_AX_XBUF_EN_LNBUF BIT(27)
#define B_AX_XBUF_LDO_VREF_SH 25
#define B_AX_XBUF_LDO_VREF_MSK 0x3
#define B_AX_XBUF_LDO_PCUT_MODE BIT(24)
#define B_AX_XBUF_DELAY_CPHY BIT(23)
#define B_AX_XBUF_DELAY_DHC BIT(22)
#define B_AX_XBUF_DELAY_USB BIT(21)
#define B_AX_XBUF_DELAY_BT_AFE BIT(20)
#define B_AX_XBUF_DELAY_WL_AFE BIT(19)
#define B_AX_XBUF_DRV_DIGI_SH 17
#define B_AX_XBUF_DRV_DIGI_MSK 0x3
#define B_AX_XBUF_DRV_CPHY_SH 15
#define B_AX_XBUF_DRV_CPHY_MSK 0x3
#define B_AX_XBUF_DRV_DHC_SH 13
#define B_AX_XBUF_DRV_DHC_MSK 0x3
#define B_AX_XBUF_DRV_USB_SH 11
#define B_AX_XBUF_DRV_USB_MSK 0x3
#define B_AX_XBUF_DRV_BT_AFE_SH 9
#define B_AX_XBUF_DRV_BT_AFE_MSK 0x3
#define B_AX_XBUF_DRV_WL_AFE_SH 7
#define B_AX_XBUF_DRV_WL_AFE_MSK 0x3
#define B_AX_EN_XBUF_DRV_LPS BIT(6)
#define B_AX_EN_XBUF_DRV_DIGI BIT(5)
#define B_AX_EN_XBUF_DRV_CPHY BIT(4)
#define B_AX_EN_XBUF_DRV_DHC BIT(3)
#define B_AX_EN_XBUF_DRV_USB BIT(2)
#define B_AX_EN_XBUF_DRV_BT_AFE BIT(1)
#define B_AX_EN_XBUF_DRV_WL_AFE BIT(0)
#define B_AX_XBUF_LPS_DIVISOR BIT(1)
#define B_AX_XBUF_SEL_TOK_H BIT(0)
#define B_AX_BYPASS_ADIE_PWR_READY BIT(30)
#define B_AX_BYPASS_XTAL_CHG_OK BIT(29)
#define B_AX_FORCE_HW_EN33V_ADIE_0 BIT(27)
#define B_AX_DISABLE_HW_EN33V_ADIE_0 BIT(26)
#define B_AX_XTAL_MODE_FINAL BIT(18)
#define B_AX_XTAL_CLK_CHANGE_OK BIT(8)
#define B_AX_AFC_BUS BIT(23)
#define B_AX_AFC_REG_SETTING BIT(21)
#define B_AX_AFC_DBG BIT(20)
#define B_AX_AFC_AFEDIG BIT(17)
#define B_AX_WLRF1_CTRL_SH 8
#define B_AX_WLRF1_CTRL_MSK 0xff
#define B_AX_WLRF_CTRL_SH 0
#define B_AX_WLRF_CTRL_MSK 0xff
#define B_AX_GATED_STUP_OK BIT(6)

#define R_AX_SPS_DIG_OFF_CTRL0 0x0400

#define R_AX_SPS_DIG_OFF_CTRL1 0x0404

#define R_AX_SPS_ANA_OFF_CTRL0 0x0420
#define B_AX_SDZN_L_ANA_SH 30
#define B_AX_SDZN_L_ANA_MSK 0x3
#define B_AX_REG_AUTOZCD_L_ANA BIT(29)
#define B_AX_REG_VOFB_SEL_ANA BIT(28)
#define B_AX_TBOX_L1_ANA_SH 26
#define B_AX_TBOX_L1_ANA_MSK 0x3
#define B_AX_ENOCPMUX_L_ANA BIT(25)
#define B_AX_FORCE_LDOS_ANA BIT(24)
#define B_AX_VO_DISCHG_ANA BIT(23)
#define B_AX_LDO_OC_CLAMP_ANA BIT(22)
#define B_AX_MINOFF_LIQ_ANA BIT(21)
#define B_AX_MINON_LIQ_ANA BIT(20)
#define B_AX_POW_AUTO_L_ANA BIT(19)
#define B_AX_ARENB_H_ANA BIT(18)
#define B_AX_NO_OFFTIME_L_ANA BIT(17)
#define B_AX_EN_ON_END_L_ANA BIT(16)
#define B_AX_ENCOT_L_ANA BIT(15)
#define B_AX_REG_CLK_SEL_ANA_SH 13
#define B_AX_REG_CLK_SEL_ANA_MSK 0x3
#define B_AX_REG_TYPE_L_ANA BIT(12)
#define B_AX_R3_L1_ANA_SH 10
#define B_AX_R3_L1_ANA_MSK 0x3
#define B_AX_R1_L1_ANA_SH 6
#define B_AX_R1_L1_ANA_MSK 0x3
#define B_AX_C2_L1_ANA_SH 2
#define B_AX_C2_L1_ANA_MSK 0x3

#define R_AX_SPS_ANA_OFF_CTRL1 0x0424
#define B_AX_REG_NMOS_OFF_L_ANA BIT(5)
#define B_AX_REG_MUX_PI_L_ANA BIT(4)
#define B_AX_REG_PWM_CTRL_L_ANA BIT(3)
#define B_AX_ENSR_L_ANA BIT(2)
#define B_AX_SDZP_L_ANA_SH 0
#define B_AX_SDZP_L_ANA_MSK 0x3
#define B_AX_S1_AD_SEL_Q_V1_SH 28
#define B_AX_S1_AD_SEL_Q_V1_MSK 0xf
#define B_AX_S1_AD_SEL_I_V1_SH 24
#define B_AX_S1_AD_SEL_I_V1_MSK 0xf
#define B_AX_S0_AD_SEL_Q_V1_SH 20
#define B_AX_S0_AD_SEL_Q_V1_MSK 0xf
#define B_AX_S0_AD_SEL_I_V1_SH 16
#define B_AX_S0_AD_SEL_I_V1_MSK 0xf
#define B_AX_VPULSE_BG BIT(13)
#define B_AX_BK_BG BIT(12)
#define B_AX_S1_LDO_VSEL_SH 24
#define B_AX_S1_LDO_VSEL_MSK 0x3
#define B_AX_S1_LDO2PWRCUT BIT(23)
#define B_AX_S0_LDO_VSEL_SH 21
#define B_AX_S0_LDO_VSEL_MSK 0x3
#define B_AX_S0_LDO2PWRCUT BIT(20)

#define R_AX_SCAN_MODE_TEST 0x04F0

//
// AON_C
//
#define B_AX_SEC_FWDL_TIME BIT(9)
#define B_AX_SEC_AUTH_DONE BIT(8)

//
// WL_AX_Reg_AON.xls
//

//
// AON
//
#define B_AX_XTAL_OFF_A_DIE BIT(22)
#define B_AX_DIS_HW_LPURLDO BIT(19)
#define B_AX_R_SYM_DIS_PCIE_FLR BIT(9)
#define B_AX_DMEM6_PC_EN BIT(18)
#define B_AX_DMEM5_PC_EN BIT(17)
#define B_AX_DMEM4_PC_EN BIT(16)
#define B_AX_EF_DLY_SEL_SH 0
#define B_AX_EF_DLY_SEL_MSK 0xf
#define B_AX_SDM_SRC_SEL BIT(12)
#define B_AX_DUAL_HOST_WAKE_BT_EN BIT(29)
#define B_AX_MCM_FLASH_EN BIT(28)
#define B_AX_DUAL_BT_FUNC_EN BIT(27)
#define B_AX_SDIO_CMD_SW_RST BIT(20)
#define B_AX_L1OFF_TO_L0_RESUME_EVT BIT(8)
#define B_AX_USBMAC_ANACLK_SW BIT(21)
#define B_AX_HCI_LA_ADDR_MAP BIT(16)
#define B_AX_HCI_LA_GLO_RST BIT(15)
#define B_AX_USB3_SUS_DIS BIT(14)
#define B_AX_R_SYM_ISO_DMEM62PP BIT(29)
#define B_AX_R_SYM_ISO_DMEM52PP BIT(28)
#define B_AX_R_SYM_ISO_DMEM42PP BIT(27)
#define B_AX_R_SYM_ISO_DMEM32PP_V1 BIT(26)
#define B_AX_R_SYM_ISO_DMEM22PP_V1 BIT(25)
#define B_AX_R_SYM_ISO_DMEM12PP_V1 BIT(24)
#define B_AX_R_SYM_PWC_HCILA BIT(13)
#define B_AX_R_SYM_PWC_BTBRG BIT(10)
#define B_AX_R_SYM_ISO_HCILA BIT(4)
#define B_AX_R_SYM_ISO_BTBRG2PP BIT(2)
#define B_AX_PCIE_MIO_ADDR_PAGE_V1_SH 16
#define B_AX_PCIE_MIO_ADDR_PAGE_V1_MSK 0x1f

#define R_AX_USER_DEFINED_0 0x0100
#define B_AX_USER_DEFINED_0_SH 0
#define B_AX_USER_DEFINED_0_MSK 0xffffffffL

#define R_AX_USER_DEFINED_1 0x0104
#define B_AX_USER_DEFINED_1_SH 0
#define B_AX_USER_DEFINED_1_MSK 0xffffffffL

#define R_AX_USER_DEFINED_2 0x0108
#define B_AX_USER_DEFINED_2_SH 0
#define B_AX_USER_DEFINED_2_MSK 0xffffffffL

#define R_AX_USER_DEFINED_3 0x010C
#define B_AX_USER_DEFINED_3_SH 0
#define B_AX_USER_DEFINED_3_MSK 0xffffffffL

#define R_AX_GPIO_EXT_INTM 0x0148
#define B_AX_GPIO18_INT_MD BIT(2)
#define B_AX_GPIO17_INT_MD BIT(1)
#define B_AX_GPIO16_INT_MD BIT(0)

#define R_AX_GPIO_16_TO_18_EXT_CTRL 0x0150
#define B_AX_GPIO_MOD_18_TO_16_SH 24
#define B_AX_GPIO_MOD_18_TO_16_MSK 0x7
#define B_AX_GPIO_IO_SEL_18_TO_16_SH 16
#define B_AX_GPIO_IO_SEL_18_TO_16_MSK 0x7
#define B_AX_GPIO_OUT_18_TO_16_SH 8
#define B_AX_GPIO_OUT_18_TO_16_MSK 0x7
#define B_AX_GPIO_IN_18_TO_16_SH 0
#define B_AX_GPIO_IN_18_TO_16_MSK 0x7
#define B_AX_SYM_DIS_HC_ACCESS_MAC BIT(8)

#define R_AX_FW_DEBUG_USE_ONLY_0 0x0180
#define B_AX_FW_DEBUG_USE_ONLY_0_SH 0
#define B_AX_FW_DEBUG_USE_ONLY_0_MSK 0xffffffffL

#define R_AX_FW_DEBUG_USE_ONLY_1 0x0184
#define B_AX_FW_DEBUG_USE_ONLY_1_SH 0
#define B_AX_FW_DEBUG_USE_ONLY_1_MSK 0xffffffffL

#define R_AX_FW_DEBUG_USE_ONLY_2 0x0188
#define B_AX_FW_DEBUG_USE_ONLY_2_SH 0
#define B_AX_FW_DEBUG_USE_ONLY_2_MSK 0xffffffffL

#define R_AX_FW_DEBUG_USE_ONLY_3 0x018C
#define B_AX_FW_DEBUG_USE_ONLY_3_SH 0
#define B_AX_FW_DEBUG_USE_ONLY_3_MSK 0xffffffffL

#define R_AX_FWS1IMR 0x0198
#define B_AX_AON_PCIE_FLR_INT_EN BIT(19)
#define B_AX_PCIE_ERR_INDIC_INT_EN BIT(18)
#define B_AX_SDIO_ERR_INDIC_INT_EN BIT(17)
#define B_AX_USB_ERR_INDIC_INT_EN BIT(16)
#define B_AX_FS_GPIO18_INT_EN BIT(2)
#define B_AX_FS_GPIO17_INT_EN BIT(1)
#define B_AX_FS_GPIO16_INT_EN BIT(0)

#define R_AX_FWS1ISR 0x019C
#define B_AX_AON_PCIE_FLR_INT BIT(19)
#define B_AX_PCIE_ERR_INDIC BIT(18)
#define B_AX_SDIO_ERR_INDIC BIT(17)
#define B_AX_USB_ERR_INDIC BIT(16)
#define B_AX_FS_GPIO18_INT BIT(2)
#define B_AX_FS_GPIO17_INT BIT(1)
#define B_AX_FS_GPIO16_INT BIT(0)
#define B_AX_WDT_TIMEOUT_INT_EN BIT(22)
#define B_AX_WDT_TIMEOUT_INT BIT(22)

#define R_AX_HIMR1 0x01A8
#define B_AX_GPIO18_INT_EN BIT(2)
#define B_AX_GPIO17_INT_EN BIT(1)
#define B_AX_GPIO16_INT_EN BIT(0)

#define R_AX_HISR1 0x01AC
#define B_AX_GPIO18_INT BIT(2)
#define B_AX_GPIO17_INT BIT(1)
#define B_AX_GPIO16_INT BIT(0)

#define R_AX_DRV_FW_HSK_0 0x01B0
#define B_AX_DRV_FW_HSK_0_SH 0
#define B_AX_DRV_FW_HSK_0_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_1 0x01B4
#define B_AX_DRV_FW_HSK_1_SH 0
#define B_AX_DRV_FW_HSK_1_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_2 0x01B8
#define B_AX_DRV_FW_HSK_2_SH 0
#define B_AX_DRV_FW_HSK_2_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_3 0x01BC
#define B_AX_DRV_FW_HSK_3_SH 0
#define B_AX_DRV_FW_HSK_3_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_4 0x01C0
#define B_AX_DRV_FW_HSK_4_SH 0
#define B_AX_DRV_FW_HSK_4_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_5 0x01C4
#define B_AX_DRV_FW_HSK_5_SH 0
#define B_AX_DRV_FW_HSK_5_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_6 0x01C8
#define B_AX_DRV_FW_HSK_6_SH 0
#define B_AX_DRV_FW_HSK_6_MSK 0xffffffffL

#define R_AX_DRV_FW_HSK_7 0x01CC
#define B_AX_DRV_FW_HSK_7_SH 0
#define B_AX_DRV_FW_HSK_7_MSK 0xffffffffL
#define B_AX_AHB_AUTO_FIX_HANG_EN BIT(23)
#define B_AX_AHB_AUTO_FIX_HANG_THD_SH 16
#define B_AX_AHB_AUTO_FIX_HANG_THD_MSK 0x7f
#define B_AX_APB_AUTO_FIX_HANG_EN BIT(15)
#define B_AX_APB_AUTO_FIX_HANG_THD_SH 0
#define B_AX_APB_AUTO_FIX_HANG_THD_MSK 0x7fff
#define B_AX_BG_VR1200_TUNE_SH 12
#define B_AX_BG_VR1200_TUNE_MSK 0x7
#define B_AX_BG_R2_TUNE_SH 9
#define B_AX_BG_R2_TUNE_MSK 0x7
#define B_AX_BG_R1_TUNE_SH 6
#define B_AX_BG_R1_TUNE_MSK 0x7
#define B_AX_REG_PASS_H BIT(5)
#define B_AX_REG_REG_SWR_ZCD_CTRL_SH 1
#define B_AX_REG_REG_SWR_ZCD_CTRL_MSK 0x3
#define B_AX_SPS_VPFM_SW_CTRL BIT(7)
#define B_AX_DIS_SWR_PRE_PWM BIT(6)
#define B_AX_ITAIL_HALF_EN_L BIT(23)
#define B_AX_STANDBY_L BIT(22)
#define B_AX_EN_DIODE_L BIT(21)
#define B_AX_VOADJ_L_SH 17
#define B_AX_VOADJ_L_MSK 0xf
#define B_AX_PD_REGU_L BIT(16)
#define B_AX_PWM_VREF_SEL_SH 26
#define B_AX_PWM_VREF_SEL_MSK 0x3
#define B_AX_SWR_ZCD_CTRL_SH 24
#define B_AX_SWR_ZCD_CTRL_MSK 0x3
#define B_AX_BG_VR1200_TUNE_ANA_SH 21
#define B_AX_BG_VR1200_TUNE_ANA_MSK 0x7
#define B_AX_BG_R2_TUNE_ANA_SH 18
#define B_AX_BG_R2_TUNE_ANA_MSK 0x7
#define B_AX_BG_R1_TUNE_ANA_SH 15
#define B_AX_BG_R1_TUNE_ANA_MSK 0x7
#define B_AX_PRSS_H BIT(12)
#define B_AX_ADIE_EN BIT(27)
#define B_AX_ADIE_CTRL_BY_SW BIT(26)
#define B_AX_PINMUX_GPIO18_FUNC_SEL_SH 8
#define B_AX_PINMUX_GPIO18_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO17_FUNC_SEL_SH 4
#define B_AX_PINMUX_GPIO17_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO16_FUNC_SEL_SH 0
#define B_AX_PINMUX_GPIO16_FUNC_SEL_MSK 0xf

#define R_AX_LED1_FUNC_SEL 0x02DC
#define B_AX_PINMUX_LED1_FUNC_SEL_V1_SH 28
#define B_AX_PINMUX_LED1_FUNC_SEL_V1_MSK 0xf
#define B_AX_PINMUX_EESK_FUNC_SEL_V1_SH 24
#define B_AX_PINMUX_EESK_FUNC_SEL_V1_MSK 0xf
#define B_AX_PINMUX_EECS_FUNC_SEL_V1_SH 20
#define B_AX_PINMUX_EECS_FUNC_SEL_V1_MSK 0xf
#define B_AX_LED1_PULL_HIGH_EN_V1 BIT(31)
#define B_AX_EESK_PULL_HIGH_EN_V1 BIT(30)
#define B_AX_EECS_PULL_HIGH_EN_V1 BIT(29)
#define B_AX_GPIO18_PULL_HIGH_EN BIT(18)
#define B_AX_GPIO17_PULL_HIGH_EN BIT(17)
#define B_AX_GPIO16_PULL_HIGH_EN BIT(16)
#define B_AX_LED1_PULL_LOW_EN_V1 BIT(31)
#define B_AX_EESK_PULL_LOW_EN_V1 BIT(30)
#define B_AX_EECS_PULL_LOW_EN_V1 BIT(29)
#define B_AX_GPIO18_PULL_LOW_EN BIT(18)
#define B_AX_GPIO17_PULL_LOW_EN BIT(17)
#define B_AX_GPIO16_PULL_LOW_EN BIT(16)
#define B_AX_LED1_PAD_E2_V1 BIT(31)
#define B_AX_EESK_PAD_E_V1 BIT(30)
#define B_AX_EECS_PAD_E2_V1 BIT(29)
#define B_AX_SYSON_GPIO18_PAD_E2 BIT(18)
#define B_AX_SYSON_GPIO17_PAD_E2 BIT(17)
#define B_AX_SYSON_GPIO16_PAD_E2 BIT(16)
#define B_AX_LED1_PAD_SMT_CTRL_V1 BIT(31)
#define B_AX_EESK_PAD_SMT_CTRL_V1 BIT(30)
#define B_AX_EECS_PAD_SMT_CTRL_V1 BIT(29)
#define B_AX_GPIO18_PAD_SMT_CTRL BIT(18)
#define B_AX_GPIO17_PAD_SMT_CTRL BIT(17)
#define B_AX_GPIO16_PAD_SMT_CTRL BIT(16)

#define R_AX_SPS_DIG_ON_CTRL0_F 0x0300
#define B_AX_REG_BG_H_F BIT(30)

#define R_AX_SPS_DIG_ON_CTRL1_F 0x0304

#define R_AX_SPS_DIG_ON_OFF_CTRL2_F 0x0308
#define B_AX_REG_NMOS_OFF_L_T BIT(21)
#define B_AX_REG_MUX_PI_L_T BIT(20)
#define B_AX_REG_PWM_CTRL_L_T BIT(19)
#define B_AX_ENSR_L_T BIT(18)
#define B_AX_SDZP_L_T_SH 16
#define B_AX_SDZP_L_T_MSK 0x3
#define B_AX_BG_VR1200_TUNE_F_SH 12
#define B_AX_BG_VR1200_TUNE_F_MSK 0x7
#define B_AX_BG_R2_TUNE_F_SH 9
#define B_AX_BG_R2_TUNE_F_MSK 0x7
#define B_AX_BG_R1_TUNE_F_SH 6
#define B_AX_BG_R1_TUNE_F_MSK 0x7
#define B_AX_REG_PASS_H_F BIT(5)
#define B_AX_REG_BG_CURRENT_L_F_SH 3
#define B_AX_REG_BG_CURRENT_L_F_MSK 0x3
#define B_AX_REG_REG_SWR_ZCD_CTRL_F_SH 1
#define B_AX_REG_REG_SWR_ZCD_CTRL_F_MSK 0x3
#define B_AX_REG_VC_CLAMP_SEL_L_F BIT(0)

#define R_AX_SPS_DIG_OFF_CTRL0_F 0x030C

#define R_AX_SPS_ANA_ON_CTRL0_F 0x0310
#define B_AX_PFMCMP_IQ_ANA_F BIT(31)
#define B_AX__REG_BG_H_ANA_F BIT(30)
#define B_AX_OFF_END_SEL_ANA_F BIT(29)
#define B_AX_POW_MINOFF_L_ANA_F BIT(28)
#define B_AX_COT_I_L_ANA_F_SH 26
#define B_AX_COT_I_L_ANA_F_MSK 0x3
#define B_AX_VREFPFM_L_ANA_F_SH 22
#define B_AX_VREFPFM_L_ANA_F_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS_ANA_F BIT(21)
#define B_AX_ZCD_SDZ_L_ANA_F_SH 19
#define B_AX_ZCD_SDZ_L_ANA_F_MSK 0x3
#define B_AX_REG_ZCDC_H_ANA_F_SH 17
#define B_AX_REG_ZCDC_H_ANA_F_MSK 0x3
#define B_AX_POW_ZCD_L_ANA_F BIT(16)
#define B_AX_OCP_L1_ANA_F_SH 13
#define B_AX_OCP_L1_ANA_F_MSK 0x7
#define B_AX_POWOCP_L1_ANA_F BIT(12)
#define B_AX_SAW_FREQ_L_ANA_F_SH 8
#define B_AX_SAW_FREQ_L_ANA_F_MSK 0xf
#define B_AX_REG_BYPASS_L_ANA_F BIT(7)
#define B_AX_FPWM_L1_ANA_F BIT(6)
#define B_AX_STD_L1_ANA_F_SH 4
#define B_AX_STD_L1_ANA_F_MSK 0x3
#define B_AX_VOL_L1_ANA_F_SH 0
#define B_AX_VOL_L1_ANA_F_MSK 0xf

#define R_AX_SPS_ANA_ON_CTRL1_F 0x0314
#define B_AX_SN_N_L_ANA_F_SH 28
#define B_AX_SN_N_L_ANA_F_MSK 0xf
#define B_AX_SP_N_L_ANA_F_SH 24
#define B_AX_SP_N_L_ANA_F_MSK 0xf
#define B_AX_SN_P_L_ANA_F_SH 20
#define B_AX_SN_P_L_ANA_F_MSK 0xf
#define B_AX_SP_P_L_ANA_F_SH 16
#define B_AX_SP_P_L_ANA_F_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H_ANA_F BIT(15)
#define B_AX_REG_MODE_PREDRIVER_ANA_F BIT(14)
#define B_AX_REG_ADJSLDO_L_ANA_F_SH 10
#define B_AX_REG_ADJSLDO_L_ANA_F_MSK 0xf
#define B_AX_REG_LDOR_L_ANA_F BIT(9)
#define B_AX_PWM_FORCE_ANA_F BIT(8)
#define B_AX_PFM_PD_RST_ANA_F BIT(7)
#define B_AX_VC_PFM_RSTB_ANA_F BIT(6)
#define B_AX_PFM_IN_SEL_ANA_F BIT(5)
#define B_AX_VC_RSTB_ANA_F BIT(4)
#define B_AX_FPWMDELAY_ANA_F BIT(3)
#define B_AX_ENFPWMDELAY_H_ANA_F BIT(2)
#define B_AX_REG_MOS_HALF_L_ANA_F BIT(1)
#define B_AX_CURRENT_SENSE_MOS_ANA_F BIT(0)

#define R_AX_SPS_ANA_ON_CTRL2_F 0x0318
#define B_AX_PWM_VREF_SEL_F_SH 26
#define B_AX_PWM_VREF_SEL_F_MSK 0x3
#define B_AX_SWR_ZCD_CTRL_F_SH 24
#define B_AX_SWR_ZCD_CTRL_F_MSK 0x3
#define B_AX_BG_VR1200_TUNE_ANA_F_SH 21
#define B_AX_BG_VR1200_TUNE_ANA_F_MSK 0x7
#define B_AX_BG_R2_TUNE_ANA_F_SH 18
#define B_AX_BG_R2_TUNE_ANA_F_MSK 0x7
#define B_AX_BG_R1_TUNE_ANA_F_SH 15
#define B_AX_BG_R1_TUNE_ANA_F_MSK 0x7
#define B_AX_ZCD_IOFFSET_B_ANA_F_SH 13
#define B_AX_ZCD_IOFFSET_B_ANA_F_MSK 0x3
#define B_AX_PRSS_H_F BIT(12)
#define B_AX_R2_L1_ANA_F_SH 10
#define B_AX_R2_L1_ANA_F_MSK 0x3
#define B_AX_C3_L1_ANA_F_SH 8
#define B_AX_C3_L1_ANA_F_MSK 0x3
#define B_AX_C1_L1_ANA_F_SH 6
#define B_AX_C1_L1_ANA_F_MSK 0x3
#define B_AX_EXTERNAL_CLK_SEL_F BIT(5)
#define B_AX_REG_BG_CURRENT_L_ANA_F_SH 3
#define B_AX_REG_BG_CURRENT_L_ANA_F_MSK 0x3
#define B_AX_REG_BG_ANA_L_ANA_F BIT(2)
#define B_AX_REG_BG_DIG_L_ANA_F BIT(1)
#define B_AX_REG_VC_CLAMP_SEL_L_ANA_F BIT(0)

#define R_AX_SPS_ANA_OFF_CTRL0_F 0x031C
#define B_AX_SDZN_L_ANA_F_SH 30
#define B_AX_SDZN_L_ANA_F_MSK 0x3
#define B_AX_REG_AUTOZCD_L_ANA_F BIT(29)
#define B_AX_REG_VOFB_SEL_ANA_F BIT(28)
#define B_AX_TBOX_L1_ANA_F_SH 26
#define B_AX_TBOX_L1_ANA_F_MSK 0x3
#define B_AX_ENOCPMUX_L_ANA_F BIT(25)
#define B_AX_FORCE_LDOS_ANA_F BIT(24)
#define B_AX_VO_DISCHG_ANA_F BIT(23)
#define B_AX_LDO_OC_CLAMP_ANA_F BIT(22)
#define B_AX_MINOFF_LIQ_ANA_F BIT(21)
#define B_AX_MINON_LIQ_ANA_F BIT(20)
#define B_AX_POW_AUTO_L_ANA_F BIT(19)
#define B_AX_ARENB_H_ANA_F BIT(18)
#define B_AX_NO_OFFTIME_L_ANA_F BIT(17)
#define B_AX_EN_ON_END_L_ANA_F BIT(16)
#define B_AX_ENCOT_L_ANA_F BIT(15)
#define B_AX_REG_CLK_SEL_ANA_F_SH 13
#define B_AX_REG_CLK_SEL_ANA_F_MSK 0x3
#define B_AX_REG_TYPE_L_ANA_F BIT(12)
#define B_AX_R3_L1_ANA_F_SH 10
#define B_AX_R3_L1_ANA_F_MSK 0x3
#define B_AX_R1_L1_ANA_F_SH 6
#define B_AX_R1_L1_ANA_F_MSK 0x3
#define B_AX_C2_L1_ANA_F_SH 2
#define B_AX_C2_L1_ANA_F_MSK 0x3
#define B_AX_MODE_L_SPS_F BIT(25)
#define B_AX_MODE_L_SPSANA_F BIT(24)
#define B_AX_ITAIL_HALF_EN_L_F BIT(23)
#define B_AX_STANDBY_L_F BIT(22)
#define B_AX_EN_DIODE_L_F BIT(21)
#define B_AX_VOADJ_L_F_SH 17
#define B_AX_VOADJ_L_F_MSK 0xf
#define B_AX_PD_REGU_L_F BIT(16)
#define B_AX_AONLDO_VOSEL_H_F_SH 4
#define B_AX_AONLDO_VOSEL_H_F_MSK 0xf
#define B_AX_LV_POR_VREF_SEL_F BIT(1)
#define B_AX_AONLDO_VREF_SEL_F BIT(0)

#define R_AX_POW_MAC_SPS_ANA_OFF_CTRL_F 0x0324
#define B_AX_REG_NMOS_OFF_L_ANA_F BIT(21)
#define B_AX_REG_MUX_PI_L_ANA_F BIT(20)
#define B_AX_REG_PWM_CTRL_L_ANA_F BIT(19)
#define B_AX_ENSR_L_ANA_F BIT(18)
#define B_AX_SDZP_L_ANA_F_SH 16
#define B_AX_SDZP_L_ANA_F_MSK 0x3
#define B_AX_EN_PC_LDO_F BIT(2)
#define B_AX_REG_LPF_R3_H_F_SH 0
#define B_AX_REG_LPF_R3_H_F_MSK 0x3
#define B_AX_REG_VC_TH_F BIT(3)
#define B_AX_REG_VC_TL_F BIT(2)
#define B_AX_REG_CK40M_EN_F BIT(1)
#define B_AX_S1_AD_SEL_Q_V1_F_SH 28
#define B_AX_S1_AD_SEL_Q_V1_F_MSK 0xf
#define B_AX_S1_AD_SEL_I_V1_F_SH 24
#define B_AX_S1_AD_SEL_I_V1_F_MSK 0xf
#define B_AX_S0_AD_SEL_Q_V1_F_SH 20
#define B_AX_S0_AD_SEL_Q_V1_F_MSK 0xf
#define B_AX_S0_AD_SEL_I_V1_F_SH 16
#define B_AX_S0_AD_SEL_I_V1_F_MSK 0xf
#define B_AX_VPULSE_BG_F BIT(13)
#define B_AX_BK_BG_F BIT(12)
#define B_AX_S1_LDO_VSEL_F_SH 24
#define B_AX_S1_LDO_VSEL_F_MSK 0x3
#define B_AX_S1_LDO2PWRCUT_F BIT(23)
#define B_AX_S0_LDO_VSEL_F_SH 21
#define B_AX_S0_LDO_VSEL_F_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_F BIT(20)
#define B_AX_XBUF_SEL_TOK_L_F_SH 30
#define B_AX_XBUF_SEL_TOK_L_F_MSK 0x3
#define B_AX_XBUF_LPS_BUF_VB_F_SH 28
#define B_AX_XBUF_LPS_BUF_VB_F_MSK 0x3
#define B_AX_XBUF_EN_LNBUF_F BIT(27)
#define B_AX_XBUF_LDO_VREF_F_SH 25
#define B_AX_XBUF_LDO_VREF_F_MSK 0x3
#define B_AX_XBUF_LDO_PCUT_MODE_F BIT(24)
#define B_AX_XBUF_DELAY_CPHY_F BIT(23)
#define B_AX_XBUF_DELAY_DHC_F BIT(22)
#define B_AX_XBUF_DELAY_USB_F BIT(21)
#define B_AX_XBUF_DELAY_BT_AFE_F BIT(20)
#define B_AX_XBUF_DELAY_WL_AFE_F BIT(19)
#define B_AX_XBUF_DRV_DIGI_F_SH 17
#define B_AX_XBUF_DRV_DIGI_F_MSK 0x3
#define B_AX_XBUF_DRV_CPHY_F_SH 15
#define B_AX_XBUF_DRV_CPHY_F_MSK 0x3
#define B_AX_XBUF_DRV_DHC_F_SH 13
#define B_AX_XBUF_DRV_DHC_F_MSK 0x3
#define B_AX_XBUF_DRV_USB_F_SH 11
#define B_AX_XBUF_DRV_USB_F_MSK 0x3
#define B_AX_XBUF_DRV_BT_AFE_F_SH 9
#define B_AX_XBUF_DRV_BT_AFE_F_MSK 0x3
#define B_AX_XBUF_DRV_WL_AFE_F_SH 7
#define B_AX_XBUF_DRV_WL_AFE_F_MSK 0x3
#define B_AX_EN_XBUF_DRV_LPS_F BIT(6)
#define B_AX_EN_XBUF_DRV_DIGI_F BIT(5)
#define B_AX_EN_XBUF_DRV_CPHY_F BIT(4)
#define B_AX_EN_XBUF_DRV_DHC_F BIT(3)
#define B_AX_EN_XBUF_DRV_USB_F BIT(2)
#define B_AX_EN_XBUF_DRV_BT_AFE_F BIT(1)
#define B_AX_EN_XBUF_DRV_WL_AFE_F BIT(0)
#define B_AX_XBUF_LPS_DIVISOR_F BIT(1)
#define B_AX_XBUF_SEL_TOK_H_F BIT(0)

#define R_AX_SEC_SIGNAL 0x0394
#define B_AX_BTGP_BTSPIEN_ALL BIT(6)
#define B_AX_BTGP_GJTAGEN_ALL BIT(5)
#define B_AX_WLGP_UART_RXEN_ALL BIT(4)
#define B_AX_WLGP_UART_TXEN_ALL BIT(3)
#define B_AX_WLGP_GJTAGEN_ALL BIT(2)
#define B_AX_SIC_EN_ALL BIT(1)

#define R_AX_DBG_GNT_WL_BT_INFO 0x03F4
#define B_AX_DBG_WLAN_ACT_0_SEL BIT(5)
#define B_AX_DBG_GNT_BB_SEL BIT(4)
#define B_AX_DBG_GNT_WL_S1 BIT(3)
#define B_AX_DBG_GNT_BT_S1 BIT(2)
#define B_AX_DBG_GNT_WL_S0 BIT(1)
#define B_AX_DBG_GNT_BT_S0 BIT(0)

#define R_AX_WLCPU_PORT_PC_SET 0x03F8
#define B_AX_WLCPU_PORT_PC_SET BIT(0)

#define R_AX_WLCPU_PORT_PC 0x03FC
#define B_AX_WLCPU_PORT_PC_SH 0
#define B_AX_WLCPU_PORT_PC_MSK 0xffffffffL
#define B_AX_WPHY_SCAN_INNER_SYNC_MODE BIT(4)
#define B_AX_WPHY_SCAN_MLD_PHASE_SH 2
#define B_AX_WPHY_SCAN_MLD_PHASE_MSK 0x3

#define R_AX_DBG_SYS_CFG 0x0500
#define B_AX_DBG_SYS_CFG_SH 0
#define B_AX_DBG_SYS_CFG_MSK 0xffffffffL

#define R_AX_DBG_WOW 0x0504
#define B_AX_DBG_WOW_CPU_IO_RX_EN BIT(8)
#define B_AX_DBG_WOW_REASON_SH 0
#define B_AX_DBG_WOW_REASON_MSK 0xff

#define R_AX_UDM5 0x0508
#define B_AX_UDM5_SH 0
#define B_AX_UDM5_MSK 0xffffffffL

#define R_AX_UDM6 0x050C
#define B_AX_UDM6_SH 0
#define B_AX_UDM6_MSK 0xffffffffL

#define R_AX_UDM7 0x0510
#define B_AX_UDM7_SH 0
#define B_AX_UDM7_MSK 0xffffffffL

#define R_AX_UDM8 0x0514
#define B_AX_UDM8_SH 0
#define B_AX_UDM8_MSK 0xffffffffL

#define R_AX_UDM9 0x0518
#define B_AX_UDM9_SH 0
#define B_AX_UDM9_MSK 0xffffffffL

#define R_AX_UDM10 0x051C
#define B_AX_UDM10_SH 0
#define B_AX_UDM10_MSK 0xffffffffL

#define R_AX_UDM11 0x0520
#define B_AX_UDM11_SH 0
#define B_AX_UDM11_MSK 0xffffffffL

#define R_AX_UDM12 0x0524
#define B_AX_UDM12_SH 0
#define B_AX_UDM12_MSK 0xffffffffL

#define R_AX_UDM13 0x0528
#define B_AX_UDM13_SH 0
#define B_AX_UDM13_MSK 0xffffffffL

#define R_AX_UDM14 0x052C
#define B_AX_UDM14_SH 0
#define B_AX_UDM14_MSK 0xffffffffL

#define R_AX_UDM15 0x0530
#define B_AX_UDM15_SH 0
#define B_AX_UDM15_MSK 0xffffffffL

#define R_AX_UDM16 0x0534
#define B_AX_UDM16_SH 0
#define B_AX_UDM16_MSK 0xffffffffL

#define R_AX_UDM17 0x0538
#define B_AX_UDM17_SH 0
#define B_AX_UDM17_MSK 0xffffffffL

#define R_AX_UDM18 0x053C
#define B_AX_UDM18_SH 0
#define B_AX_UDM18_MSK 0xffffffffL

//
// AON_C
//
#define B_AX_SEC_IDMEM_SIZE_CONFIG_V1_SH 16
#define B_AX_SEC_IDMEM_SIZE_CONFIG_V1_MSK 0x7

//
// WL_AX_Reg_AON.xls
//

//
// AON
//
#define B_AX_PWC_EV2EF_B BIT(15)
#define B_AX_PWC_EV2EF_S BIT(14)
#define B_AX_CMAC_CLK_SEL_V1 BIT(24)
#define B_AX_PLL_DIV_SEL_V1_SH 20
#define B_AX_PLL_DIV_SEL_V1_MSK 0x3
#define B_AX_WLBB_PWC_DLY_SH 20
#define B_AX_WLBB_PWC_DLY_MSK 0xf
#define B_AX_WLMAC_PWC_DLY_SH 16
#define B_AX_WLMAC_PWC_DLY_MSK 0xf
#define B_AX_WLPON_PWC_DLY_SH 12
#define B_AX_WLPON_PWC_DLY_MSK 0xf
#define B_AX_BT_MAILBOX_MST_EN BIT(21)
#define B_AX_LDO_OPIQ_SEL_SH 8
#define B_AX_LDO_OPIQ_SEL_MSK 0xf
#define B_AX_EN_POWMOS BIT(7)
#define B_AX_R_SYM_ISO_P12PP BIT(6)
#define B_AX_R_SYM_ISO_P02PP BIT(3)
#define B_AX_OPT1_ADIE BIT(9)
#define B_AX_REG_OVP_SEL_SH 16
#define B_AX_REG_OVP_SEL_MSK 0x7
#define B_AX_REG_OVP_L BIT(15)
#define B_AX_REG_OTP_PC33_VODIS BIT(9)
#define B_AX__SWR_PFM_VREF_SEL BIT(30)
#define B_AX_ANA_OVP_EN BIT(31)
#define B_AX_ANA_REG_OVP_L_SH 28
#define B_AX_ANA_REG_OVP_L_MSK 0x7
#define B_AX_PWM_VREF_SEL_135_SH 9
#define B_AX_PWM_VREF_SEL_135_MSK 0x3
#define B_AX__SWR_PFM_VREF_SEL_135 BIT(8)

#define R_AX_SPS_ANALDO_ON_CTRL 0x0238
#define B_AX_FORCE_DIODE_ANALDO BIT(13)
#define B_AX_REG_DMYLOAD_ANALDO_SH 10
#define B_AX_REG_DMYLOAD_ANALDO_MSK 0x3
#define B_AX_ITAIL_HALF_EN_ANALDO BIT(9)
#define B_AX_STBY_ANALDO_SH 7
#define B_AX_STBY_ANALDO_MSK 0x3
#define B_AX_EN_DIODE_ANALDO BIT(6)
#define B_AX_VOL_ANALDO_SH 2
#define B_AX_VOL_ANALDO_MSK 0xf
#define B_AX_REG_PD_ANALDO BIT(1)
#define B_AX_REG_EN_PC_ANALDO BIT(0)

#define R_AX_SPS_DIG_ON_CTRL2_V1_F 0x0308
#define B_AX_REG_OVP_SEL_V1_F_SH 16
#define B_AX_REG_OVP_SEL_V1_F_MSK 0x7
#define B_AX_REG_OVP_L_V1_F BIT(15)
#define B_AX_BG_VR1200_TUNE_V1_F_SH 12
#define B_AX_BG_VR1200_TUNE_V1_F_MSK 0x7
#define B_AX_BG_R2_TUNE_V1_F_SH 9
#define B_AX_BG_R2_TUNE_V1_F_MSK 0x7
#define B_AX_BG_R1_TUNE_V1_F_SH 6
#define B_AX_BG_R1_TUNE_V1_F_MSK 0x7
#define B_AX_REG_PASS_H_V1_F BIT(5)
#define B_AX_REG_BG_CURRENT_L_V1_F_SH 3
#define B_AX_REG_BG_CURRENT_L_V1_F_MSK 0x3
#define B_AX_REG_REG_SWR_ZCD_CTRL_V1_F_SH 1
#define B_AX_REG_REG_SWR_ZCD_CTRL_V1_F_MSK 0x3
#define B_AX_REG_VC_CLAMP_SEL_L_V1_F BIT(0)

#define R_AX_LDO_AON_CTRL0_V1_F 0x0318
#define B_AX_REG_OTP_PC33_VODIS_F BIT(9)

#define R_AX_SPS_ANA_ON_CTRL0_V1_F 0x0320
#define B_AX_PFMCMP_IQ_ANA_V1_F BIT(31)
#define B_AX__SWR_PFM_VREF_SEL_V1_F BIT(30)
#define B_AX_OFF_END_SEL_ANA_V1_F BIT(29)
#define B_AX_POW_MINOFF_L_ANA_V1_F BIT(28)
#define B_AX_COT_I_L_ANA_V1_F_SH 26
#define B_AX_COT_I_L_ANA_V1_F_MSK 0x3
#define B_AX_VREFPFM_L_ANA_V1_F_SH 22
#define B_AX_VREFPFM_L_ANA_V1_F_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS_ANA_V1_F BIT(21)
#define B_AX_ZCD_SDZ_L_ANA_V1_F_SH 19
#define B_AX_ZCD_SDZ_L_ANA_V1_F_MSK 0x3
#define B_AX_REG_ZCDC_H_ANA_V1_F_SH 17
#define B_AX_REG_ZCDC_H_ANA_V1_F_MSK 0x3
#define B_AX_POW_ZCD_L_ANA_V1_F BIT(16)
#define B_AX_OCP_L1_ANA_V1_F_SH 13
#define B_AX_OCP_L1_ANA_V1_F_MSK 0x7
#define B_AX_POWOCP_L1_ANA_V1_F BIT(12)
#define B_AX_SAW_FREQ_L_ANA_V1_F_SH 8
#define B_AX_SAW_FREQ_L_ANA_V1_F_MSK 0xf
#define B_AX_REG_BYPASS_L_ANA_V1_F BIT(7)
#define B_AX_FPWM_L1_ANA_V1_F BIT(6)
#define B_AX_STD_L1_ANA_V1_F_SH 4
#define B_AX_STD_L1_ANA_V1_F_MSK 0x3
#define B_AX_VOL_L1_ANA_V1_F_SH 0
#define B_AX_VOL_L1_ANA_V1_F_MSK 0xf

#define R_AX_SPS_ANA_ON_CTRL1_V1_F 0x0324
#define B_AX_SN_N_L_ANA_V1_F_SH 28
#define B_AX_SN_N_L_ANA_V1_F_MSK 0xf
#define B_AX_SP_N_L_ANA_V1_F_SH 24
#define B_AX_SP_N_L_ANA_V1_F_MSK 0xf
#define B_AX_SN_P_L_ANA_V1_F_SH 20
#define B_AX_SN_P_L_ANA_V1_F_MSK 0xf
#define B_AX_SP_P_L_ANA_V1_F_SH 16
#define B_AX_SP_P_L_ANA_V1_F_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H_ANA_V1_F BIT(15)
#define B_AX_REG_MODE_PREDRIVER_ANA_V1_F BIT(14)
#define B_AX_REG_ADJSLDO_L_ANA_V1_F_SH 10
#define B_AX_REG_ADJSLDO_L_ANA_V1_F_MSK 0xf
#define B_AX_REG_LDOR_L_ANA_V1_F BIT(9)
#define B_AX_PWM_FORCE_ANA_V1_F BIT(8)
#define B_AX_PFM_PD_RST_ANA_V1_F BIT(7)
#define B_AX_VC_PFM_RSTB_ANA_V1_F BIT(6)
#define B_AX_PFM_IN_SEL_ANA_V1_F BIT(5)
#define B_AX_VC_RSTB_ANA_V1_F BIT(4)
#define B_AX_FPWMDELAY_ANA_V1_F BIT(3)
#define B_AX_ENFPWMDELAY_H_ANA_V1_F BIT(2)
#define B_AX_REG_MOS_HALF_L_ANA_V1_F BIT(1)
#define B_AX_CURRENT_SENSE_MOS_ANA_V1_F BIT(0)

#define R_AX_SPS_ANA_ON_CTRL2_V1_F 0x0328
#define B_AX_ANA_OVP_EN_V1_F BIT(31)
#define B_AX_ANA_REG_OVP_L_V1_F_SH 28
#define B_AX_ANA_REG_OVP_L_V1_F_MSK 0x7
#define B_AX_PWM_VREF_SEL_V1_F_SH 26
#define B_AX_PWM_VREF_SEL_V1_F_MSK 0x3
#define B_AX_SWR_ZCD_CTRL_V1_F_SH 24
#define B_AX_SWR_ZCD_CTRL_V1_F_MSK 0x3
#define B_AX_BG_VR1200_TUNE_ANA_V1_F_SH 21
#define B_AX_BG_VR1200_TUNE_ANA_V1_F_MSK 0x7
#define B_AX_BG_R2_TUNE_ANA_V1_F_SH 18
#define B_AX_BG_R2_TUNE_ANA_V1_F_MSK 0x7
#define B_AX_BG_R1_TUNE_ANA_V1_F_SH 15
#define B_AX_BG_R1_TUNE_ANA_V1_F_MSK 0x7
#define B_AX_ZCD_IOFFSET_B_ANA_V1_F_SH 13
#define B_AX_ZCD_IOFFSET_B_ANA_V1_F_MSK 0x3
#define B_AX_PRSS_H_V1_F BIT(12)
#define B_AX_R2_L1_ANA_V1_F_SH 10
#define B_AX_R2_L1_ANA_V1_F_MSK 0x3
#define B_AX_C3_L1_ANA_V1_F_SH 8
#define B_AX_C3_L1_ANA_V1_F_MSK 0x3
#define B_AX_C1_L1_ANA_V1_F_SH 6
#define B_AX_C1_L1_ANA_V1_F_MSK 0x3
#define B_AX_EXTERNAL_CLK_SEL_V1_F BIT(5)
#define B_AX_REG_BG_CURRENT_L_ANA_V1_F_SH 3
#define B_AX_REG_BG_CURRENT_L_ANA_V1_F_MSK 0x3
#define B_AX_REG_BG_ANA_L_ANA_V1_F BIT(2)
#define B_AX_REG_BG_DIG_L_ANA_V1_F BIT(1)
#define B_AX_REG_VC_CLAMP_SEL_L_ANA_V1_F BIT(0)

#define R_AX_SPS_ANALDO_ON_CTRL_V1_F 0x0338
#define B_AX_FORCE_DIODE_ANALDO_V1_F BIT(13)
#define B_AX_REG_DMYLOAD_ANALDO_V1_F_SH 10
#define B_AX_REG_DMYLOAD_ANALDO_V1_F_MSK 0x3
#define B_AX_ITAIL_HALF_EN_ANALDO_V1_F BIT(9)
#define B_AX_STBY_ANALDO_V1_F_SH 7
#define B_AX_STBY_ANALDO_V1_F_MSK 0x3
#define B_AX_EN_DIODE_ANALDO_V1_F BIT(6)
#define B_AX_VOL_ANALDO_V1_F_SH 2
#define B_AX_VOL_ANALDO_V1_F_MSK 0xf
#define B_AX_REG_PD_ANALDO_V1_F BIT(1)
#define B_AX_REG_EN_PC_ANALDO_V1_F BIT(0)

#define R_AX_AFE_ON_CTRL0_V1_F 0x0340
#define B_AX_REG_LPF_R3_V1_F_SH 29
#define B_AX_REG_LPF_R3_V1_F_MSK 0x7
#define B_AX_REG_LPF_R2_V1_F_SH 24
#define B_AX_REG_LPF_R2_V1_F_MSK 0x1f
#define B_AX_REG_LPF_C3_V1_F_SH 21
#define B_AX_REG_LPF_C3_V1_F_MSK 0x7
#define B_AX_REG_LPF_C2_V1_F_SH 18
#define B_AX_REG_LPF_C2_V1_F_MSK 0x7
#define B_AX_REG_LPF_C1_V1_F_SH 15
#define B_AX_REG_LPF_C1_V1_F_MSK 0x7
#define B_AX_REG_LDO_SEL_V1_F_SH 13
#define B_AX_REG_LDO_SEL_V1_F_MSK 0x3
#define B_AX_REG_CP_ICPX2_V1_F BIT(12)
#define B_AX_REG_CP_ICP_SEL_FAST_V1_F_SH 9
#define B_AX_REG_CP_ICP_SEL_FAST_V1_F_MSK 0x7
#define B_AX_REG_CP_ICP_SEL_V1_F_SH 6
#define B_AX_REG_CP_ICP_SEL_V1_F_MSK 0x7
#define B_AX_REG_IB_PI_V1_F_SH 4
#define B_AX_REG_IB_PI_V1_F_MSK 0x3
#define B_AX_EN_PC_LDO_V1_F BIT(2)
#define B_AX_LDO_VSEL_V1_F_SH 0
#define B_AX_LDO_VSEL_V1_F_MSK 0x3

#define R_AX_AFE_ON_CTRL1_V1_F 0x0344
#define B_AX_REG_CK_MON_SEL_V1_F_SH 29
#define B_AX_REG_CK_MON_SEL_V1_F_MSK 0x7
#define B_AX_REG_CK_MON_EN_V1_F BIT(28)
#define B_AX_REG_XTAL_FREQ_SEL_V1_F BIT(27)
#define B_AX_REG_XTAL_EDGE_SEL_V1_F BIT(26)
#define B_AX_REG_VCO_KVCO_V1_F BIT(25)
#define B_AX_REG_SDM_EDGE_SEL_V1_F BIT(24)
#define B_AX_REG_SDM_CK_SEL_V1_F BIT(23)
#define B_AX_REG_SDM_CK_GATED_V1_F BIT(22)
#define B_AX_REG_PFD_RESET_GATED_V1_F BIT(21)
#define B_AX_REG_LPF_R3_FAST_V1_F_SH 16
#define B_AX_REG_LPF_R3_FAST_V1_F_MSK 0x1f
#define B_AX_REG_LPF_R2_FAST_V1_F_SH 11
#define B_AX_REG_LPF_R2_FAST_V1_F_MSK 0x1f
#define B_AX_REG_LPF_C3_FAST_V1_F_SH 8
#define B_AX_REG_LPF_C3_FAST_V1_F_MSK 0x7
#define B_AX_REG_LPF_C2_FAST_V1_F_SH 5
#define B_AX_REG_LPF_C2_FAST_V1_F_MSK 0x7
#define B_AX_REG_LPF_C1_FAST_V1_F_SH 2
#define B_AX_REG_LPF_C1_FAST_V1_F_MSK 0x7
#define B_AX_REG_LPF_R3_H_V1_F_SH 0
#define B_AX_REG_LPF_R3_H_V1_F_MSK 0x3

#define R_AX_AFE_ON_CTRL2_V1_F 0x0348
#define B_AX_AGPIO_DRV_V1_F_SH 30
#define B_AX_AGPIO_DRV_V1_F_MSK 0x3
#define B_AX_AGPIO_GPO_V1_F BIT(29)
#define B_AX_AGPIO_GPE_V1_F BIT(28)
#define B_AX_SEL_CLK_V1_F BIT(27)
#define B_AX_LS_XTAL_SEL_V1_F_SH 23
#define B_AX_LS_XTAL_SEL_V1_F_MSK 0xf
#define B_AX_LS_SDM_ORDER_V1_F BIT(22)
#define B_AX_LS_DELAY_PH_V1_F BIT(21)
#define B_AX_DIVIDER_SEL_V1_F BIT(20)
#define B_AX_PCODE_V1_F_SH 15
#define B_AX_PCODE_V1_F_MSK 0x1f
#define B_AX_NCODE_V1_F_SH 7
#define B_AX_NCODE_V1_F_MSK 0xff
#define B_AX_REG_BEACON_V1_F BIT(6)
#define B_AX_REG_MBIASE_V1_F BIT(5)
#define B_AX_REG_FAST_SEL_V1_F_SH 3
#define B_AX_REG_FAST_SEL_V1_F_MSK 0x3
#define B_AX_REG_CK480M_EN_V1_F BIT(2)
#define B_AX_REG_CK320M_EN_V1_F BIT(1)
#define B_AX_REG_CK_5M_EN_V1_F BIT(0)

#define R_AX_AFE_ON_CTRL3_V1_F 0x034C
#define B_AX_REG_VC_TH_V1_F BIT(3)
#define B_AX_REG_VC_TL_V1_F BIT(2)
#define B_AX_REG_CK40M_EN_V1_F BIT(1)
#define B_AX_REG_CK640M_EN_V1_F BIT(0)

#define R_AX_ANAPAR_POW_MAC_V1_F 0x0350
#define B_AX_POW_PC_LDO_PORT1_V1_F BIT(19)
#define B_AX_POW_PC_LDO_PORT0_V1_F BIT(18)
#define B_AX_POW_PLL_V1_V1_F BIT(17)
#define B_AX_POW_POWER_CUT_POW_LDO_V1_F BIT(16)
#define B_AX_POW_XTAL_V1_F BIT(2)
#define B_AX_XTAL_POW_XTAL_LPS_V1_F BIT(1)
#define B_AX_POW_BG_V1_F BIT(0)

#define R_AX_XTAL_ON_CTRL0_V1_F 0x0358
#define B_AX_XBUF_SEL_TOK_L_V1_F_SH 30
#define B_AX_XBUF_SEL_TOK_L_V1_F_MSK 0x3
#define B_AX_XBUF_LPS_BUF_VB_V1_F_SH 28
#define B_AX_XBUF_LPS_BUF_VB_V1_F_MSK 0x3
#define B_AX_XBUF_EN_LNBUF_V1_F BIT(27)
#define B_AX_XBUF_LDO_VREF_V1_F_SH 25
#define B_AX_XBUF_LDO_VREF_V1_F_MSK 0x3
#define B_AX_XBUF_LDO_PCUT_MODE_V1_F BIT(24)
#define B_AX_XBUF_DELAY_CPHY_V1_F BIT(23)
#define B_AX_XBUF_DELAY_DHC_V1_F BIT(22)
#define B_AX_XBUF_DELAY_USB_V1_F BIT(21)
#define B_AX_XBUF_DELAY_BT_AFE_V1_F BIT(20)
#define B_AX_XBUF_DELAY_WL_AFE_V1_F BIT(19)
#define B_AX_XBUF_DRV_DIGI_V1_F_SH 17
#define B_AX_XBUF_DRV_DIGI_V1_F_MSK 0x3
#define B_AX_XBUF_DRV_CPHY_V1_F_SH 15
#define B_AX_XBUF_DRV_CPHY_V1_F_MSK 0x3
#define B_AX_XBUF_DRV_DHC_V1_F_SH 13
#define B_AX_XBUF_DRV_DHC_V1_F_MSK 0x3
#define B_AX_XBUF_DRV_USB_V1_F_SH 11
#define B_AX_XBUF_DRV_USB_V1_F_MSK 0x3
#define B_AX_XBUF_DRV_BT_AFE_V1_F_SH 9
#define B_AX_XBUF_DRV_BT_AFE_V1_F_MSK 0x3
#define B_AX_XBUF_DRV_WL_AFE_V1_F_SH 7
#define B_AX_XBUF_DRV_WL_AFE_V1_F_MSK 0x3
#define B_AX_EN_XBUF_DRV_LPS_V1_F BIT(6)
#define B_AX_EN_XBUF_DRV_DIGI_V1_F BIT(5)
#define B_AX_EN_XBUF_DRV_CPHY_V1_F BIT(4)
#define B_AX_EN_XBUF_DRV_DHC_V1_F BIT(3)
#define B_AX_EN_XBUF_DRV_USB_V1_F BIT(2)
#define B_AX_EN_XBUF_DRV_BT_AFE_V1_F BIT(1)
#define B_AX_EN_XBUF_DRV_WL_AFE_V1_F BIT(0)

#define R_AX_XTAL_ON_CTRL1_V1_F 0x035C
#define B_AX_XBUF_LPS_DIVISOR_V1_F BIT(1)
#define B_AX_XBUF_SEL_TOK_H_V1_F BIT(0)

#define R_AX_SPS_DIG_OFF_CTRL0_V1_F 0x0360
#define B_AX_SDZN_L_V1_F_SH 30
#define B_AX_SDZN_L_V1_F_MSK 0x3
#define B_AX_REG_AUTOZCD_L_V1_F BIT(29)
#define B_AX_REG_VOFB_SEL_V1_F BIT(28)
#define B_AX_TBOX_L1_V1_F_SH 26
#define B_AX_TBOX_L1_V1_F_MSK 0x3
#define B_AX_ENOCPMUX_L_V1_F BIT(25)
#define B_AX_FORCE_LDOS_V1_F BIT(24)
#define B_AX_VO_DISCHG_V1_F BIT(23)
#define B_AX_LDO_OC_CLAMP_V1_F BIT(22)
#define B_AX_MINOFF_LIQ_V1_F BIT(21)
#define B_AX_MINON_LIQ_V1_F BIT(20)
#define B_AX_POW_AUTO_L_V1_F BIT(19)
#define B_AX_ARENB_H_V1_F BIT(18)
#define B_AX_NO_OFFTIME_L_V1_F BIT(17)
#define B_AX_EN_ON_END_L_V1_F BIT(16)
#define B_AX_ENCOT_L_V1_F BIT(15)
#define B_AX_REG_CLK_SEL_V1_F_SH 13
#define B_AX_REG_CLK_SEL_V1_F_MSK 0x3
#define B_AX_REG_TYPE_L_V1_F BIT(12)
#define B_AX_R3_L1_V1_F_SH 10
#define B_AX_R3_L1_V1_F_MSK 0x3
#define B_AX_R2_L1_V1_F_SH 8
#define B_AX_R2_L1_V1_F_MSK 0x3
#define B_AX_R1_L1_V1_F_SH 6
#define B_AX_R1_L1_V1_F_MSK 0x3
#define B_AX_C3_L1_V1_F_SH 4
#define B_AX_C3_L1_V1_F_MSK 0x3
#define B_AX_C2_L1_V1_F_SH 2
#define B_AX_C2_L1_V1_F_MSK 0x3
#define B_AX_C1_L1_V1_F_SH 0
#define B_AX_C1_L1_V1_F_MSK 0x3

#define R_AX_SPS_DIG_OFF_CTRL1_V1_F 0x0364
#define B_AX_REG_NMOS_OFF_L_V1_F BIT(5)
#define B_AX_REG_MUX_PI_L_V1_F BIT(4)
#define B_AX_REG_PWM_CTRL_L_V1_F BIT(3)
#define B_AX_ENSR_L_V1_F BIT(2)
#define B_AX_SDZP_L_V1_F_SH 0
#define B_AX_SDZP_L_V1_F_MSK 0x3

#define R_AX_SPS_ANA_OFF_CTRL0_V1_F 0x0368
#define B_AX_SDZN_L_ANA_V1_F_SH 30
#define B_AX_SDZN_L_ANA_V1_F_MSK 0x3
#define B_AX_REG_AUTOZCD_L_ANA_V1_F BIT(29)
#define B_AX_REG_VOFB_SEL_ANA_V1_F BIT(28)
#define B_AX_TBOX_L1_ANA_V1_F_SH 26
#define B_AX_TBOX_L1_ANA_V1_F_MSK 0x3
#define B_AX_ENOCPMUX_L_ANA_V1_F BIT(25)
#define B_AX_FORCE_LDOS_ANA_V1_F BIT(24)
#define B_AX_VO_DISCHG_ANA_V1_F BIT(23)
#define B_AX_LDO_OC_CLAMP_ANA_V1_F BIT(22)
#define B_AX_MINOFF_LIQ_ANA_V1_F BIT(21)
#define B_AX_MINON_LIQ_ANA_V1_F BIT(20)
#define B_AX_POW_AUTO_L_ANA_V1_F BIT(19)
#define B_AX_ARENB_H_ANA_V1_F BIT(18)
#define B_AX_NO_OFFTIME_L_ANA_V1_F BIT(17)
#define B_AX_EN_ON_END_L_ANA_V1_F BIT(16)
#define B_AX_ENCOT_L_ANA_V1_F BIT(15)
#define B_AX_REG_CLK_SEL_ANA_V1_F_SH 13
#define B_AX_REG_CLK_SEL_ANA_V1_F_MSK 0x3
#define B_AX_REG_TYPE_L_ANA_V1_F BIT(12)
#define B_AX_R3_L1_ANA_V1_F_SH 10
#define B_AX_R3_L1_ANA_V1_F_MSK 0x3
#define B_AX_R1_L1_ANA_V1_F_SH 6
#define B_AX_R1_L1_ANA_V1_F_MSK 0x3
#define B_AX_C2_L1_ANA_V1_F_SH 2
#define B_AX_C2_L1_ANA_V1_F_MSK 0x3

#define R_AX_SPS_ANA_OFF_CTRL1_V1_F 0x036C
#define B_AX_REG_NMOS_OFF_L_ANA_V1_F BIT(5)
#define B_AX_REG_MUX_PI_L_ANA_V1_F BIT(4)
#define B_AX_REG_PWM_CTRL_L_ANA_V1_F BIT(3)
#define B_AX_ENSR_L_ANA_V1_F BIT(2)
#define B_AX_SDZP_L_ANA_V1_F_SH 0
#define B_AX_SDZP_L_ANA_V1_F_MSK 0x3

#define R_AX_AFE_OFF_CTRL0_V1_F 0x0370
#define B_AX_S1_AD_SEL_Q_V1_V1_F_SH 28
#define B_AX_S1_AD_SEL_Q_V1_V1_F_MSK 0xf
#define B_AX_S1_AD_SEL_I_V1_V1_F_SH 24
#define B_AX_S1_AD_SEL_I_V1_V1_F_MSK 0xf
#define B_AX_S0_AD_SEL_Q_V1_V1_F_SH 20
#define B_AX_S0_AD_SEL_Q_V1_V1_F_MSK 0xf
#define B_AX_S0_AD_SEL_I_V1_V1_F_SH 16
#define B_AX_S0_AD_SEL_I_V1_V1_F_MSK 0xf
#define B_AX_VPULSE_BG_V1_F BIT(13)
#define B_AX_BK_BG_V1_F BIT(12)

#define R_AX_AFE_OFF_CTRL1_V1_F 0x0374
#define B_AX_S1_LDO_VSEL_V1_F_SH 24
#define B_AX_S1_LDO_VSEL_V1_F_MSK 0x3
#define B_AX_S1_LDO2PWRCUT_V1_F BIT(23)
#define B_AX_S0_LDO_VSEL_V1_F_SH 21
#define B_AX_S0_LDO_VSEL_V1_F_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_V1_F BIT(20)

#define R_AX_AIP_DEBUG_F 0x0398
#define B_AX_SSOVER_L_SPSANA_F BIT(3)
#define B_AX_SSOVER_L_SPS_F BIT(2)
#define B_AX_MODE_L_SPSANA_V1_F BIT(1)
#define B_AX_MODE_L_SPS_V1_F BIT(0)

//
// AON_C
//

//
// WL_AX_Reg_AON.xls
//

//
// AON
//
#define B_AX_REG_LDO_GM_V1_SH 8
#define B_AX_REG_LDO_GM_V1_MSK 0xf

#define R_AX_GPIO_16_EXT_CTRL_V1 0x0150
#define B_AX_GPIO_MOD_16_V1 BIT(24)
#define B_AX_GPIO_IO_SEL_16_V1 BIT(16)
#define B_AX_GPIO_OUT_16_V1 BIT(8)
#define B_AX_GPIO_IN_16_V1 BIT(0)
#define B_AX_BG_VR1200_TUNE_A_BLOCK_SH 11
#define B_AX_BG_VR1200_TUNE_A_BLOCK_MSK 0x7
#define B_AX_BG_R2_TUEN_A_BLOCK_SH 8
#define B_AX_BG_R2_TUEN_A_BLOCK_MSK 0x7
#define B_AX_BG_R1_TUNE_A_BLOCK_SH 5
#define B_AX_BG_R1_TUNE_A_BLOCK_MSK 0x7
#define B_AX_AONLDO_VREF_SEL_A_BLOCK BIT(4)
#define B_AX_AONLDO_VOSEL_H_A_BLOCK_SH 0
#define B_AX_AONLDO_VOSEL_H_A_BLOCK_MSK 0xf

#define R_AX_XTAL_ON_CTRL3 0x028C
#define B_AX_XTAL_SC_INIT_A_BLOCK_SH 24
#define B_AX_XTAL_SC_INIT_A_BLOCK_MSK 0x7f
#define B_AX_XTAL_SC_LPS_A_BLOCK_SH 16
#define B_AX_XTAL_SC_LPS_A_BLOCK_MSK 0x7f
#define B_AX_XTAL_SC_XO_A_BLOCK_SH 8
#define B_AX_XTAL_SC_XO_A_BLOCK_MSK 0x7f
#define B_AX_XTAL_SC_XI_A_BLOCK_SH 0
#define B_AX_XTAL_SC_XI_A_BLOCK_MSK 0x7f

#define R_AX_XTAL_ON_CTRL4 0x0290
#define B_AX_XPDCK_VREF_SEL_A_BLOCK_SH 19
#define B_AX_XPDCK_VREF_SEL_A_BLOCK_MSK 0x1f
#define B_AX_XTAL_MODE_MANUAL_A_BLOCK_SH 17
#define B_AX_XTAL_MODE_MANUAL_A_BLOCK_MSK 0x3
#define B_AX_XTAL_MANU_SEL_A_BLOCK BIT(16)
#define B_AX_XTAL_VREF_SEL_A_BLOCK_SH 11
#define B_AX_XTAL_VREF_SEL_A_BLOCK_MSK 0x1f
#define B_AX_XTAL_SEL_TOK_A_BLOCK_SH 8
#define B_AX_XTAL_SEL_TOK_A_BLOCK_MSK 0x7
#define B_AX_XTAL_EN_BDRF_A_BLOCK BIT(7)
#define B_AX_XTAL_LDO_NC_A_BLOCK BIT(6)
#define B_AX_EN_XTAL_SCHMITT_A_BLOCK BIT(5)
#define B_AX_XTAL_CKDIGI_SEL_A_BLOCK BIT(4)
#define B_AX_XTAL_AAC_MODE_A_BLOCK_SH 2
#define B_AX_XTAL_AAC_MODE_A_BLOCK_MSK 0x3
#define B_AX_XTAL_CFIX_A_BLOCK_SH 0
#define B_AX_XTAL_CFIX_A_BLOCK_MSK 0x3
#define B_AX_PINMUX_GPIO16_FUNC_SEL_V1_SH 12
#define B_AX_PINMUX_GPIO16_FUNC_SEL_V1_MSK 0xf

#define R_AX_GPIO0_16_EECS_EESK_LED1_PULL_HIGH_EN 0x02E0
#define B_AX_GPIO16_PULL_HIGH_EN_V1 BIT(19)

#define R_AX_GPIO0_16_EECS_EESK_LED1_PULL_LOW_EN 0x02E4
#define B_AX_GPIO16_PULL_LOW_EN_V1 BIT(19)

#define R_AX_GPIO0_16_EECS_EESK_LED1_E2_EN 0x02E8
#define B_AX_SYSON_GPIO16_PAD_E2_V1 BIT(19)

#define R_AX_GPIO0_16_EECS_EESK_LED1_SMT_EN 0x02EC
#define B_AX_GPIO16_PAD_SMT_CTRL_V1 BIT(19)
#define B_AX_OCP_L1_ANA_F_V1_F_SH 13
#define B_AX_OCP_L1_ANA_F_V1_F_MSK 0x7
#define B_AX_REG_LPF_C1_FAST_V1_V1_F_SH 2
#define B_AX_REG_LPF_C1_FAST_V1_V1_F_MSK 0x7
#define B_AX_POW_BG_V1 BIT(0)
#define B_AX_S0_AD_OP_SEL_Q__V1_F_SH 26
#define B_AX_S0_AD_OP_SEL_Q__V1_F_MSK 0x3
#define B_AX_S0_AD_OP_SEL_I__V1_F_SH 24
#define B_AX_S0_AD_OP_SEL_I__V1_F_MSK 0x3
#define B_AX_S0_LDO_VSEL_I2V_V1_F_SH 18
#define B_AX_S0_LDO_VSEL_I2V_V1_F_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_I2V_V1_F BIT(17)
#define B_AX_S0_LDO_VSEL_BUF_V1_F_SH 15
#define B_AX_S0_LDO_VSEL_BUF_V1_F_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_BUF_V1_F BIT(14)
#define B_AX_S0_LDO_VSEL_AD_V1_F_SH 12
#define B_AX_S0_LDO_VSEL_AD_V1_F_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_AD_V1_F BIT(11)
#define B_AX_S0_AD_OP_SEL_Q__SH 26
#define B_AX_S0_AD_OP_SEL_Q__MSK 0x3
#define B_AX_S0_AD_OP_SEL_I__SH 24
#define B_AX_S0_AD_OP_SEL_I__MSK 0x3
#define B_AX_S0_LDO_VSEL_I2V_SH 18
#define B_AX_S0_LDO_VSEL_I2V_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_I2V BIT(17)
#define B_AX_S0_LDO_VSEL_BUF_SH 15
#define B_AX_S0_LDO_VSEL_BUF_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_BUF BIT(14)
#define B_AX_S0_LDO_VSEL_AD_SH 12
#define B_AX_S0_LDO_VSEL_AD_MSK 0x3
#define B_AX_S0_LDO2PWRCUT_AD BIT(11)

//
// AON_C
//

//
// WL_AX_Reg_AON.xls
//

//
// AON
//

//
// AON_C
//

//
// WL_AX_Reg_CMAC_0.xls
//

//
// COMMON
//

#define R_AX_CMAC_FUNC_EN 0xC000
#define R_AX_CMAC_FUNC_EN_C1 0xE000
#define B_AX_CMAC_CRPRT BIT(31)
#define B_AX_CMAC_EN BIT(30)
#define B_AX_CMAC_TXEN BIT(29)
#define B_AX_CMAC_RXEN BIT(28)
#define B_AX_FORCE_CMACREG_GCKEN BIT(15)
#define B_AX_PHYINTF_EN BIT(5)
#define B_AX_CMAC_DMA_EN BIT(4)
#define B_AX_PTCLTOP_EN BIT(3)
#define B_AX_SCHEDULER_EN BIT(2)
#define B_AX_TMAC_EN BIT(1)
#define B_AX_RMAC_EN BIT(0)

#define R_AX_CK_EN 0xC004
#define R_AX_CK_EN_C1 0xE004
#define B_AX_CMAC_CKEN BIT(30)
#define B_AX_PHYINTF_CKEN BIT(5)
#define B_AX_CMAC_DMA_CKEN BIT(4)
#define B_AX_PTCLTOP_CKEN BIT(3)
#define B_AX_SCHEDULER_CKEN BIT(2)
#define B_AX_TMAC_CKEN BIT(1)
#define B_AX_RMAC_CKEN BIT(0)

#define R_AX_WMAC_RFMOD 0xC010
#define R_AX_WMAC_RFMOD_C1 0xE010
#define B_AX_CMAC_ASSERTION BIT(31)
#define B_AX_WMAC_RFMOD_SH 0
#define B_AX_WMAC_RFMOD_MSK 0x3

#define R_AX_R_BIST_CTRL 0xC040
#define R_AX_R_BIST_CTRL_C1 0xE040
#define B_AX_R_BIST_DYN_READ_EN BIT(14)
#define B_AX_R_BIST_LOOP_MODE BIT(13)
#define B_AX_R_BIST_LVDRF_CLKDIS BIT(12)
#define B_AX_R_BIST_DRF_RESUME BIT(3)
#define B_AX_R_BIST_DRF_MODE BIT(2)
#define B_AX_R_BIST_MODE BIT(1)
#define B_AX_R_BIST_RSTN_ALL BIT(0)

#define R_AX_SYM_MEM_RM_CTRL 0xC044
#define R_AX_SYM_MEM_RM_CTRL_C1 0xE044
#define B_AX_R_SYM_MEM_RMV_FABDBG_SH 30
#define B_AX_R_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_AX_R_SYM_MEM_RMV_SIGN BIT(29)
#define B_AX_R_SYM_MEM_RMV_2PRF BIT(27)
#define B_AX_R_SYM_MEM_RMV_1PRF BIT(26)
#define B_AX_R_SYM_MEM_RMV_1PSR BIT(25)
#define B_AX_R_SYM_MEM_RMV_ROM BIT(24)
#define B_AX_R_SYM_MEM_RME_WL_SH 4
#define B_AX_R_SYM_MEM_RME_WL_MSK 0xf

#define R_AX_GID_POSITION0 0xC070
#define R_AX_GID_POSITION0_C1 0xE070
#define B_AX_GID_15_POSITION_SH 30
#define B_AX_GID_15_POSITION_MSK 0x3
#define B_AX_GID_14_POSITION_SH 28
#define B_AX_GID_14_POSITION_MSK 0x3
#define B_AX_GID_13_POSITION_SH 26
#define B_AX_GID_13_POSITION_MSK 0x3
#define B_AX_GID_12_POSITION_SH 24
#define B_AX_GID_12_POSITION_MSK 0x3
#define B_AX_GID_11_POSITION_SH 22
#define B_AX_GID_11_POSITION_MSK 0x3
#define B_AX_GID_10_POSITION_SH 20
#define B_AX_GID_10_POSITION_MSK 0x3
#define B_AX_GID_9_POSITION_SH 18
#define B_AX_GID_9_POSITION_MSK 0x3
#define B_AX_GID_8_POSITION_SH 16
#define B_AX_GID_8_POSITION_MSK 0x3
#define B_AX_GID_7_POSITION_SH 14
#define B_AX_GID_7_POSITION_MSK 0x3
#define B_AX_GID_6_POSITION_SH 12
#define B_AX_GID_6_POSITION_MSK 0x3
#define B_AX_GID_5_POSITION_SH 10
#define B_AX_GID_5_POSITION_MSK 0x3
#define B_AX_GID_4_POSITION_SH 8
#define B_AX_GID_4_POSITION_MSK 0x3
#define B_AX_GID_3_POSITION_SH 6
#define B_AX_GID_3_POSITION_MSK 0x3
#define B_AX_GID_2_POSITION_SH 4
#define B_AX_GID_2_POSITION_MSK 0x3
#define B_AX_GID_1_POSITION_SH 2
#define B_AX_GID_1_POSITION_MSK 0x3
#define B_AX_GID_0_POSITION_SH 0
#define B_AX_GID_0_POSITION_MSK 0x3

#define R_AX_GID_POSITION1 0xC074
#define R_AX_GID_POSITION1_C1 0xE074
#define B_AX_GID_31_POSITION_SH 30
#define B_AX_GID_31_POSITION_MSK 0x3
#define B_AX_GID_30_POSITION_SH 28
#define B_AX_GID_30_POSITION_MSK 0x3
#define B_AX_GID_29_POSITION_SH 26
#define B_AX_GID_29_POSITION_MSK 0x3
#define B_AX_GID_28_POSITION_SH 24
#define B_AX_GID_28_POSITION_MSK 0x3
#define B_AX_GID_27_POSITION_SH 22
#define B_AX_GID_27_POSITION_MSK 0x3
#define B_AX_GID_26_POSITION_SH 20
#define B_AX_GID_26_POSITION_MSK 0x3
#define B_AX_GID_25_POSITION_SH 18
#define B_AX_GID_25_POSITION_MSK 0x3
#define B_AX_GID_24_POSITION_SH 16
#define B_AX_GID_24_POSITION_MSK 0x3
#define B_AX_GID_23_POSITION_SH 14
#define B_AX_GID_23_POSITION_MSK 0x3
#define B_AX_GID_22_POSITION_SH 12
#define B_AX_GID_22_POSITION_MSK 0x3
#define B_AX_GID_21_POSITION_SH 10
#define B_AX_GID_21_POSITION_MSK 0x3
#define B_AX_GID_20_POSITION_SH 8
#define B_AX_GID_20_POSITION_MSK 0x3
#define B_AX_GID_19_POSITION_SH 6
#define B_AX_GID_19_POSITION_MSK 0x3
#define B_AX_GID_18_POSITION_SH 4
#define B_AX_GID_18_POSITION_MSK 0x3
#define B_AX_GID_17_POSITION_SH 2
#define B_AX_GID_17_POSITION_MSK 0x3
#define B_AX_GID_16_POSITION_SH 0
#define B_AX_GID_16_POSITION_MSK 0x3

#define R_AX_GID_POSITION2 0xC078
#define R_AX_GID_POSITION2_C1 0xE078
#define B_AX_GID_47_POSITION_SH 30
#define B_AX_GID_47_POSITION_MSK 0x3
#define B_AX_GID_46_POSITION_SH 28
#define B_AX_GID_46_POSITION_MSK 0x3
#define B_AX_GID_45_POSITION_SH 26
#define B_AX_GID_45_POSITION_MSK 0x3
#define B_AX_GID_44_POSITION_SH 24
#define B_AX_GID_44_POSITION_MSK 0x3
#define B_AX_GID_43_POSITION_SH 22
#define B_AX_GID_43_POSITION_MSK 0x3
#define B_AX_GID_42_POSITION_SH 20
#define B_AX_GID_42_POSITION_MSK 0x3
#define B_AX_GID_41_POSITION_SH 18
#define B_AX_GID_41_POSITION_MSK 0x3
#define B_AX_GID_40_POSITION_SH 16
#define B_AX_GID_40_POSITION_MSK 0x3
#define B_AX_GID_39_POSITION_SH 14
#define B_AX_GID_39_POSITION_MSK 0x3
#define B_AX_GID_38_POSITION_SH 12
#define B_AX_GID_38_POSITION_MSK 0x3
#define B_AX_GID_37_POSITION_SH 10
#define B_AX_GID_37_POSITION_MSK 0x3
#define B_AX_GID_36_POSITION_SH 8
#define B_AX_GID_36_POSITION_MSK 0x3
#define B_AX_GID_35_POSITION_SH 6
#define B_AX_GID_35_POSITION_MSK 0x3
#define B_AX_GID_34_POSITION_SH 4
#define B_AX_GID_34_POSITION_MSK 0x3
#define B_AX_GID_33_POSITION_SH 2
#define B_AX_GID_33_POSITION_MSK 0x3
#define B_AX_GID_32_POSITION_SH 0
#define B_AX_GID_32_POSITION_MSK 0x3

#define R_AX_GID_POSITION3 0xC07C
#define R_AX_GID_POSITION3_C1 0xE07C
#define B_AX_GID_63_POSITION_SH 30
#define B_AX_GID_63_POSITION_MSK 0x3
#define B_AX_GID_62_POSITION_SH 28
#define B_AX_GID_62_POSITION_MSK 0x3
#define B_AX_GID_61_POSITION_SH 26
#define B_AX_GID_61_POSITION_MSK 0x3
#define B_AX_GID_60_POSITION_SH 24
#define B_AX_GID_60_POSITION_MSK 0x3
#define B_AX_GID_59_POSITION_SH 22
#define B_AX_GID_59_POSITION_MSK 0x3
#define B_AX_GID_58_POSITION_SH 20
#define B_AX_GID_58_POSITION_MSK 0x3
#define B_AX_GID_57_POSITION_SH 18
#define B_AX_GID_57_POSITION_MSK 0x3
#define B_AX_GID_56_POSITION_SH 16
#define B_AX_GID_56_POSITION_MSK 0x3
#define B_AX_GID_55_POSITION_SH 14
#define B_AX_GID_55_POSITION_MSK 0x3
#define B_AX_GID_54_POSITION_SH 12
#define B_AX_GID_54_POSITION_MSK 0x3
#define B_AX_GID_53_POSITION_SH 10
#define B_AX_GID_53_POSITION_MSK 0x3
#define B_AX_GID_52_POSITION_SH 8
#define B_AX_GID_52_POSITION_MSK 0x3
#define B_AX_GID_51_POSITION_SH 6
#define B_AX_GID_51_POSITION_MSK 0x3
#define B_AX_GID_50_POSITION_SH 4
#define B_AX_GID_50_POSITION_MSK 0x3
#define B_AX_GID_49_POSITION_SH 2
#define B_AX_GID_49_POSITION_MSK 0x3
#define B_AX_GID_48_POSITION_SH 0
#define B_AX_GID_48_POSITION_MSK 0x3

#define R_AX_GID_POSITION_EN0 0xC080
#define R_AX_GID_POSITION_EN0_C1 0xE080
#define B_AX_GID_31_POSITION_EN BIT(31)
#define B_AX_GID_30_POSITION_EN BIT(30)
#define B_AX_GID_29_POSITION_EN BIT(29)
#define B_AX_GID_28_POSITION_EN BIT(28)
#define B_AX_GID_27_POSITION_EN BIT(27)
#define B_AX_GID_26_POSITION_EN BIT(26)
#define B_AX_GID_25_POSITION_EN BIT(25)
#define B_AX_GID_24_POSITION_EN BIT(24)
#define B_AX_GID_23_POSITION_EN BIT(23)
#define B_AX_GID_22_POSITION_EN BIT(22)
#define B_AX_GID_21_POSITION_EN BIT(21)
#define B_AX_GID_20_POSITION_EN BIT(20)
#define B_AX_GID_19_POSITION_EN BIT(19)
#define B_AX_GID_18_POSITION_EN BIT(18)
#define B_AX_GID_17_POSITION_EN BIT(17)
#define B_AX_GID_16_POSITION_EN BIT(16)
#define B_AX_GID_15_POSITION_EN BIT(15)
#define B_AX_GID_14_POSITION_EN BIT(14)
#define B_AX_GID_13_POSITION_EN BIT(13)
#define B_AX_GID_12_POSITION_EN BIT(12)
#define B_AX_GID_11_POSITION_EN BIT(11)
#define B_AX_GID_10_POSITION_EN BIT(10)
#define B_AX_GID_9_POSITION_EN BIT(9)
#define B_AX_GID_8_POSITION_EN BIT(8)
#define B_AX_GID_7_POSITION_EN BIT(7)
#define B_AX_GID_6_POSITION_EN BIT(6)
#define B_AX_GID_5_POSITION_EN BIT(5)
#define B_AX_GID_4_POSITION_EN BIT(4)
#define B_AX_GID_3_POSITION_EN BIT(3)
#define B_AX_GID_2_POSITION_EN BIT(2)
#define B_AX_GID_1_POSITION_EN BIT(1)
#define B_AX_GID_0_POSITION_EN BIT(0)

#define R_AX_GID_POSITION_EN1 0xC084
#define R_AX_GID_POSITION_EN1_C1 0xE084
#define B_AX_GID_63_POSITION_EN BIT(31)
#define B_AX_GID_62_POSITION_EN BIT(30)
#define B_AX_GID_61_POSITION_EN BIT(29)
#define B_AX_GID_60_POSITION_EN BIT(28)
#define B_AX_GID_59_POSITION_EN BIT(27)
#define B_AX_GID_58_POSITION_EN BIT(26)
#define B_AX_GID_57_POSITION_EN BIT(25)
#define B_AX_GID_56_POSITION_EN BIT(24)
#define B_AX_GID_55_POSITION_EN BIT(23)
#define B_AX_GID_54_POSITION_EN BIT(22)
#define B_AX_GID_53_POSITION_EN BIT(21)
#define B_AX_GID_52_POSITION_EN BIT(20)
#define B_AX_GID_51_POSITION_EN BIT(19)
#define B_AX_GID_50_POSITION_EN BIT(18)
#define B_AX_GID_49_POSITION_EN BIT(17)
#define B_AX_GID_48_POSITION_EN BIT(16)
#define B_AX_GID_47_POSITION_EN BIT(15)
#define B_AX_GID_46_POSITION_EN BIT(14)
#define B_AX_GID_45_POSITION_EN BIT(13)
#define B_AX_GID_44_POSITION_EN BIT(12)
#define B_AX_GID_43_POSITION_EN BIT(11)
#define B_AX_GID_42_POSITION_EN BIT(10)
#define B_AX_GID_41_POSITION_EN BIT(9)
#define B_AX_GID_40_POSITION_EN BIT(8)
#define B_AX_GID_39_POSITION_EN BIT(7)
#define B_AX_GID_38_POSITION_EN BIT(6)
#define B_AX_GID_37_POSITION_EN BIT(5)
#define B_AX_GID_36_POSITION_EN BIT(4)
#define B_AX_GID_35_POSITION_EN BIT(3)
#define B_AX_GID_34_POSITION_EN BIT(2)
#define B_AX_GID_33_POSITION_EN BIT(1)
#define B_AX_GID_32_POSITION_EN BIT(0)

#define R_AX_TX_SUB_CARRIER_VALUE 0xC088
#define R_AX_TX_SUB_CARRIER_VALUE_C1 0xE088
#define B_AX_TXSC_80M_SH 8
#define B_AX_TXSC_80M_MSK 0xf
#define B_AX_TXSC_40M_SH 4
#define B_AX_TXSC_40M_MSK 0xf
#define B_AX_TXSC_20M_SH 0
#define B_AX_TXSC_20M_MSK 0xf

#define R_AX_PTCL_RRSR0 0xC08C
#define R_AX_PTCL_RRSR0_C1 0xE08C
#define B_AX_RRSR_HE_SH 24
#define B_AX_RRSR_HE_MSK 0xff
#define B_AX_RRSR_VHT_SH 16
#define B_AX_RRSR_VHT_MSK 0xff
#define B_AX_RRSR_HT_SH 8
#define B_AX_RRSR_HT_MSK 0xff
#define B_AX_RRSR_OFDM_SH 0
#define B_AX_RRSR_OFDM_MSK 0xff

#define R_AX_PTCL_RRSR1 0xC090
#define R_AX_PTCL_RRSR1_C1 0xE090
#define B_AX_RRSR_RATE_EN_SH 8
#define B_AX_RRSR_RATE_EN_MSK 0xf
#define B_AX_RSC_SH 6
#define B_AX_RSC_MSK 0x3
#define B_AX_RRSR_CCK_SH 0
#define B_AX_RRSR_CCK_MSK 0xf

#define R_AX_FWC00IMR 0xC100
#define R_AX_FWC00IMR_C1 0xE100
#define B_AX_FS_SND_RDY_INT_EN BIT(29)
#define B_AX_FS_RP_END_INT_EN BIT(28)
#define B_AX_FS_RXBCN_TO_CNT_INT_EN BIT(27)
#define B_AX_FS_RXBCN_HIT_INT_EN BIT(26)
#define B_AX_FS_RX_MATCH_RTT_INT_EN BIT(25)
#define B_AX_FS_BCNQ_LOCK_INT_EN BIT(24)
#define B_AX_FS_P2P1_CTWEND_INT_EN BIT(23)
#define B_AX_FS_P2P1_TSF32_TOGGLE_INT_EN BIT(22)
#define B_AX_FS_P2P1_RFON_INT_EN BIT(21)
#define B_AX_FS_P2P1_RFOFF_INT_EN BIT(20)
#define B_AX_FS_P2P0_CTWEND_INT_EN BIT(19)
#define B_AX_FS_P2P0_TSF32_TOGGLE_INT_EN BIT(18)
#define B_AX_FS_P2P0_RFON_INT_EN BIT(17)
#define B_AX_FS_P2P0_RFOFF_INT_EN BIT(16)
#define B_AX_FS_MACID_PWRCHANGE3_INT_EN BIT(15)
#define B_AX_FS_MACID_PWRCHANGE2_INT_EN BIT(14)
#define B_AX_FS_MACID_PWRCHANGE1_INT_EN BIT(13)
#define B_AX_FS_MACID_PWRCHANGE0_INT_EN BIT(12)
#define B_AX_FS_RXFTMREQ_INT_EN BIT(11)
#define B_AX_FS_RXFTM_INT_EN BIT(10)
#define B_AX_FS_FTM_PTT_EN BIT(9)
#define B_AX_FS_TXFTM_INT_EN BIT(8)
#define B_AX_FS_SOUND_DONE_INT_EN BIT(7)
#define B_AX_FS_RXDONE_INT_EN BIT(6)
#define B_AX_FS_PSTIMER_5_INT_EN BIT(5)
#define B_AX_FS_PSTIMER_4_INT_EN BIT(4)
#define B_AX_FS_PSTIMER_3_INT_EN BIT(3)
#define B_AX_FS_PSTIMER_2_INT_EN BIT(2)
#define B_AX_FS_PSTIMER_1_INT_EN BIT(1)
#define B_AX_FS_PSTIMER_0_INT_EN BIT(0)

#define R_AX_FWC00ISR 0xC104
#define R_AX_FWC00ISR_C1 0xE104
#define B_AX_FS_SND_RDY_INT BIT(29)
#define B_AX_FS_RP_END_INT BIT(28)
#define B_AX_FS_RXBCN_TO_CNT_INT BIT(27)
#define B_AX_FS_RXBCN_HIT_INT BIT(26)
#define B_AX_FS_RX_MATCH_RTT_INT BIT(25)
#define B_AX_FS_BCNQ_LOCK_INT BIT(24)
#define B_AX_FS_P2P1_CTWEND_INT BIT(23)
#define B_AX_FS_P2P1_TSF32_TOGGLE_INT BIT(22)
#define B_AX_FS_P2P1_RFON_INT BIT(21)
#define B_AX_FS_P2P1_RFOFF_INT BIT(20)
#define B_AX_FS_P2P0_CTWEND_INT BIT(19)
#define B_AX_FS_P2P0_TSF32_TOGGLE_INT BIT(18)
#define B_AX_FS_P2P0_RFON_INT BIT(17)
#define B_AX_FS_P2P0_RFOFF_INT BIT(16)
#define B_AX_FS_MACID_PWRCHANGE3_INT BIT(15)
#define B_AX_FS_MACID_PWRCHANGE2_INT BIT(14)
#define B_AX_FS_MACID_PWRCHANGE1_INT BIT(13)
#define B_AX_FS_MACID_PWRCHANGE0_INT BIT(12)
#define B_AX_FS_RXFTMREQ_INT BIT(11)
#define B_AX_FS_RXFTM_INT BIT(10)
#define B_AX_FS_FTM_PTT_INT BIT(9)
#define B_AX_FS_TXFTM_INT BIT(8)
#define B_AX_FS_SOUND_DONE_INT BIT(7)
#define B_AX_FS_RXDONE_INT BIT(6)
#define B_AX_FS_PSTIMER_5_INT BIT(5)
#define B_AX_FS_PSTIMER_4_INT BIT(4)
#define B_AX_FS_PSTIMER_3_INT BIT(3)
#define B_AX_FS_PSTIMER_2_INT BIT(2)
#define B_AX_FS_PSTIMER_1_INT BIT(1)
#define B_AX_FS_PSTIMER_0_INT BIT(0)

#define R_AX_FWC01IMR 0xC108
#define R_AX_FWC01IMR_C1 0xE108
#define B_AX_FS_P0_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P0_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P0_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P0_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P0_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P0_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P0_EOSP_INT_EN BIT(16)
#define B_AX_FS_P0_TXPKTIN_EN BIT(15)
#define B_AX_FS_P0_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P0_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P0_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P0_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P0_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P0_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P0_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P0MB0_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB0_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB0_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB0_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB0_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB0_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC01ISR 0xC10C
#define R_AX_FWC01ISR_C1 0xE10C
#define B_AX_FS_P0_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P0_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P0_RXMTF0_INT BIT(20)
#define B_AX_FS_P0_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P0_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P0_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P0_EOSP_INT BIT(16)
#define B_AX_FS_P0_TXPKTIN_INT BIT(15)
#define B_AX_FS_P0_TX_NULL1_INT BIT(14)
#define B_AX_FS_P0_TX_NULL0_INT BIT(13)
#define B_AX_FS_P0_RX_UMD0_INT BIT(12)
#define B_AX_FS_P0_RX_UMD1_INT BIT(11)
#define B_AX_FS_P0_RX_BMD0_INT BIT(10)
#define B_AX_FS_P0_RX_BMD1_INT BIT(9)
#define B_AX_FS_P0_RXBCNOK_INT BIT(8)
#define B_AX_FS_P0MB0_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB0_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB0_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB0_TBTT_INT BIT(2)
#define B_AX_FS_P0MB0_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB0_BCNERLY_INT BIT(0)

#define R_AX_FWC02IMR 0xC110
#define R_AX_FWC02IMR_C1 0xE110
#define B_AX_FS_P1_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P1_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P1_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P1_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P1_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P1_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P1_EOSP_INT_EN BIT(16)
#define B_AX_FS_P1_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P1_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P1_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P1_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P1_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P1_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P1_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P1_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P1_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P1_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P1_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P1_TBTT_INT_EN BIT(2)
#define B_AX_FS_P1_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P1_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC02ISR 0xC114
#define R_AX_FWC02ISR_C1 0xE114
#define B_AX_FS_P1_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P1_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P1_RXMTF0_INT BIT(20)
#define B_AX_FS_P1_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P1_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P1_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P1_EOSP_INT BIT(16)
#define B_AX_FS_P1_TXPKTIN_INT BIT(15)
#define B_AX_FS_P1_TX_NULL1_INT BIT(14)
#define B_AX_FS_P1_TX_NULL0_INT BIT(13)
#define B_AX_FS_P1_RX_UMD0_INT BIT(12)
#define B_AX_FS_P1_RX_UMD1_INT BIT(11)
#define B_AX_FS_P1_RX_BMD0_INT BIT(10)
#define B_AX_FS_P1_RX_BMD1_INT BIT(9)
#define B_AX_FS_P1_RXBCNOK_INT BIT(8)
#define B_AX_FS_P1_TXBCNERR_INT BIT(5)
#define B_AX_FS_P1_TXBCNOK_INT BIT(4)
#define B_AX_FS_P1_HIQWND_INT BIT(3)
#define B_AX_FS_P1_TBTT_INT BIT(2)
#define B_AX_FS_P1_TBTTERLY_INT BIT(1)
#define B_AX_FS_P1_BCNERLY_INT BIT(0)

#define R_AX_FWC03IMR 0xC118
#define R_AX_FWC03IMR_C1 0xE118
#define B_AX_FS_P2_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P2_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P2_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P2_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P2_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P2_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P2_EOSP_INT_EN BIT(16)
#define B_AX_FS_P2_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P2_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P2_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P2_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P2_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P2_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P2_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P2_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P2_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P2_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P2_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P2_TBTT_INT_EN BIT(2)
#define B_AX_FS_P2_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P2_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC03ISR 0xC11C
#define R_AX_FWC03ISR_C1 0xE11C
#define B_AX_FS_P2_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P2_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P2_RXMTF0_INT BIT(20)
#define B_AX_FS_P2_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P2_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P2_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P2_EOSP_INT BIT(16)
#define B_AX_FS_P2_TXPKTIN_INT BIT(15)
#define B_AX_FS_P2_TX_NULL1_INT BIT(14)
#define B_AX_FS_P2_TX_NULL0_INT BIT(13)
#define B_AX_FS_P2_RX_UMD0_INT BIT(12)
#define B_AX_FS_P2_RX_UMD1_INT BIT(11)
#define B_AX_FS_P2_RX_BMD0_INT BIT(10)
#define B_AX_FS_P2_RX_BMD1_INT BIT(9)
#define B_AX_FS_P2_RXBCNOK_INT BIT(8)
#define B_AX_FS_P2_TXBCNERR_INT BIT(5)
#define B_AX_FS_P2_TXBCNOK_INT BIT(4)
#define B_AX_FS_P2_HIQWND_INT BIT(3)
#define B_AX_FS_P2_TBTT_INT BIT(2)
#define B_AX_FS_P2_TBTTERLY_INT BIT(1)
#define B_AX_FS_P2_BCNERLY_INT BIT(0)

#define R_AX_FWC04IMR 0xC120
#define R_AX_FWC04IMR_C1 0xE120
#define B_AX_FS_P3_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P3_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P3_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P3_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P3_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P3_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P3_EOSP_INT_EN BIT(16)
#define B_AX_FS_P3_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P3_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P3_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P3_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P3_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P3_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P3_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P3_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P3_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P3_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P3_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P3_TBTT_INT_EN BIT(2)
#define B_AX_FS_P3_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P3_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC04ISR 0xC124
#define R_AX_FWC04ISR_C1 0xE124
#define B_AX_FS_P3_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P3_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P3_RXMTF0_INT BIT(20)
#define B_AX_FS_P3_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P3_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P3_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P3_EOSP_INT BIT(16)
#define B_AX_FS_P3_TXPKTIN_INT BIT(15)
#define B_AX_FS_P3_TX_NULL1_INT BIT(14)
#define B_AX_FS_P3_TX_NULL0_INT BIT(13)
#define B_AX_FS_P3_RX_UMD0_INT BIT(12)
#define B_AX_FS_P3_RX_UMD1_INT BIT(11)
#define B_AX_FS_P3_RX_BMD0_INT BIT(10)
#define B_AX_FS_P3_RX_BMD1_INT BIT(9)
#define B_AX_FS_P3_RXBCNOK_INT BIT(8)
#define B_AX_FS_P3_TXBCNERR_INT BIT(5)
#define B_AX_FS_P3_TXBCNOK_INT BIT(4)
#define B_AX_FS_P3_HIQWND_INT BIT(3)
#define B_AX_FS_P3_TBTT_INT BIT(2)
#define B_AX_FS_P3_TBTTERLY_INT BIT(1)
#define B_AX_FS_P3_BCNERLY_INT BIT(0)

#define R_AX_FWC05IMR 0xC128
#define R_AX_FWC05IMR_C1 0xE128
#define B_AX_FS_P4_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P4_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P4_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P4_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P4_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P4_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P4_EOSP_INT_EN BIT(16)
#define B_AX_FS_P4_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P4_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P4_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P4_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P4_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P4_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P4_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P4_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P4_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P4_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P4_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P4_TBTT_INT_EN BIT(2)
#define B_AX_FS_P4_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P4_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC05ISR 0xC12C
#define R_AX_FWC05ISR_C1 0xE12C
#define B_AX_FS_P4_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P4_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P4_RXMTF0_INT BIT(20)
#define B_AX_FS_P4_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P4_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P4_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P4_EOSP_INT BIT(16)
#define B_AX_FS_P4_TXPKTIN_INT BIT(15)
#define B_AX_FS_P4_TX_NULL1_INT BIT(14)
#define B_AX_FS_P4_TX_NULL0_INT BIT(13)
#define B_AX_FS_P4_RX_UMD0_INT BIT(12)
#define B_AX_FS_P4_RX_UMD1_INT BIT(11)
#define B_AX_FS_P4_RX_BMD0_INT BIT(10)
#define B_AX_FS_P4_RX_BMD1_INT BIT(9)
#define B_AX_FS_P4_RXBCNOK_INT BIT(8)
#define B_AX_FS_P4_TXBCNERR_INT BIT(5)
#define B_AX_FS_P4_TXBCNOK_INT BIT(4)
#define B_AX_FS_P4_HIQWND_INT BIT(3)
#define B_AX_FS_P4_TBTT_INT BIT(2)
#define B_AX_FS_P4_TBTTERLY_INT BIT(1)
#define B_AX_FS_P4_BCNERLY_INT BIT(0)

#define R_AX_FWC06IMR 0xC130
#define R_AX_FWC06IMR_C1 0xE130
#define B_AX_FS_P0MB4_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB4_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB4_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB4_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB4_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB4_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB3_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB3_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB3_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB3_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB3_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB3_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB2_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB2_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB2_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB2_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB2_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB2_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB1_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB1_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB1_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB1_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB1_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB1_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC06ISR 0xC134
#define R_AX_FWC06ISR_C1 0xE134
#define B_AX_FS_P0MB4_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB4_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB4_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB4_TBTT_INT BIT(26)
#define B_AX_FS_P0MB4_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB4_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB3_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB3_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB3_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB3_TBTT_INT BIT(18)
#define B_AX_FS_P0MB3_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB3_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB2_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB2_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB2_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB2_TBTT_INT BIT(10)
#define B_AX_FS_P0MB2_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB2_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB1_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB1_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB1_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB1_TBTT_INT BIT(2)
#define B_AX_FS_P0MB1_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB1_BCNERLY_INT BIT(0)

#define R_AX_FWC07IMR 0xC138
#define R_AX_FWC07IMR_C1 0xE138
#define B_AX_FS_P0MB8_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB8_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB8_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB8_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB8_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB8_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB7_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB7_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB7_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB7_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB7_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB7_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB6_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB6_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB6_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB6_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB6_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB6_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB5_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB5_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB5_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB5_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB5_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB5_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC07ISR 0xC13C
#define R_AX_FWC07ISR_C1 0xE13C
#define B_AX_FS_P0MB8_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB8_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB8_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB8_TBTT_INT BIT(26)
#define B_AX_FS_P0MB8_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB8_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB7_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB7_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB7_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB7_TBTT_INT BIT(18)
#define B_AX_FS_P0MB7_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB7_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB6_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB6_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB6_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB6_TBTT_INT BIT(10)
#define B_AX_FS_P0MB6_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB6_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB5_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB5_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB5_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB5_TBTT_INT BIT(2)
#define B_AX_FS_P0MB5_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB5_BCNERLY_INT BIT(0)

#define R_AX_FWC08IMR 0xC140
#define R_AX_FWC08IMR_C1 0xE140
#define B_AX_FS_P0MB12_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB12_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB12_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB12_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB12_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB12_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB11_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB11_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB11_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB11_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB11_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB11_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB10_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB10_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB10_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB10_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB10_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB10_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB9_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB9_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB9_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB9_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB9_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB9_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC08ISR 0xC144
#define R_AX_FWC08ISR_C1 0xE144
#define B_AX_FS_P0MB12_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB12_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB12_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB12_TBTT_INT BIT(26)
#define B_AX_FS_P0MB12_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB12_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB11_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB11_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB11_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB11_TBTT_INT BIT(18)
#define B_AX_FS_P0MB11_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB11_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB10_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB10_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB10_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB10_TBTT_INT BIT(10)
#define B_AX_FS_P0MB10_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB10_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB9_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB9_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB9_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB9_TBTT_INT BIT(2)
#define B_AX_FS_P0MB9_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB9_BCNERLY_INT BIT(0)

#define R_AX_FWC09IMR 0xC148
#define R_AX_FWC09IMR_C1 0xE148
#define B_AX_FS_P0MB15_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB15_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB15_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB15_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB15_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB15_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB14_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB14_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB14_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB14_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB14_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB14_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB13_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB13_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB13_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB13_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB13_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB13_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC09ISR 0xC14C
#define R_AX_FWC09ISR_C1 0xE14C
#define B_AX_FS_P0MB15_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB15_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB15_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB15_TBTT_INT BIT(18)
#define B_AX_FS_P0MB15_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB15_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB14_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB14_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB14_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB14_TBTT_INT BIT(10)
#define B_AX_FS_P0MB14_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB14_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB13_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB13_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB13_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB13_TBTT_INT BIT(2)
#define B_AX_FS_P0MB13_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB13_BCNERLY_INT BIT(0)

#define R_AX_FWC0AIMR 0xC150
#define R_AX_FWC0AIMR_C1 0xE150
#define B_AX_FS_PPS1_CTWEND_INT_EN BIT(15)
#define B_AX_FS_PPS1_TSF32_TOGL_INT_EN BIT(14)
#define B_AX_FS_PPS1_PON_ERLY_INT_EN BIT(13)
#define B_AX_FS_PPS1_POF_ERLY_INT_EN BIT(12)
#define B_AX_FS_PPS1_PON_INT_EN BIT(11)
#define B_AX_FS_PPS1_POF_INT_EN BIT(10)
#define B_AX_FS_PPS0_CTWEND_INT_EN BIT(5)
#define B_AX_FS_PPS0_TSF32_TOGL_INT_EN BIT(4)
#define B_AX_FS_PPS0_PON_ERLY_INT_EN BIT(3)
#define B_AX_FS_PPS0_POF_ERLY_INT_EN BIT(2)
#define B_AX_FS_PPS0_PON_INT_EN BIT(1)
#define B_AX_FS_PPS0_POF_INT_EN BIT(0)

#define R_AX_FWC0AISR 0xC154
#define R_AX_FWC0AISR_C1 0xE154
#define B_AX_FS_PPS1_CTWEND_INT BIT(15)
#define B_AX_FS_PPS1_TSF32_TOGL_INT BIT(14)
#define B_AX_FS_PPS1_PON_ERLY_INT BIT(13)
#define B_AX_FS_PPS1_POF_ERLY_INT BIT(12)
#define B_AX_FS_PPS1_PON_INT BIT(11)
#define B_AX_FS_PPS1_POF_INT BIT(10)
#define B_AX_FS_PPS0_CTWEND_INT BIT(5)
#define B_AX_FS_PPS0_TSF32_TOGL_INT BIT(4)
#define B_AX_FS_PPS0_PON_ERLY_INT BIT(3)
#define B_AX_FS_PPS0_POF_ERLY_INT BIT(2)
#define B_AX_FS_PPS0_PON_INT BIT(1)
#define B_AX_FS_PPS0_POF_INT BIT(0)

#define R_AX_CMAC_ERR_IMR 0xC160
#define R_AX_CMAC_ERR_IMR_C1 0xE160
#define B_AX_WMAC_TX_ERR_IND_EN BIT(7)
#define B_AX_WMAC_RX_ERR_IND_EN BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND_EN BIT(5)
#define B_AX_PHYINTF_ERR_IND_EN BIT(4)
#define B_AX_DMA_TOP_ERR_IND_EN BIT(3)
#define B_AX_PTCL_TOP_ERR_IND_EN BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND_EN BIT(0)

#define R_AX_CMAC_ERR_ISR 0xC164
#define R_AX_CMAC_ERR_ISR_C1 0xE164
#define B_AX_WMAC_TX_ERR_IND BIT(7)
#define B_AX_WMAC_RX_ERR_IND BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND BIT(5)
#define B_AX_PHYINTF_ERR_IND BIT(4)
#define B_AX_DMA_TOP_ERR_IND BIT(3)
#define B_AX_PTCL_TOP_ERR_IND BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND BIT(0)

#define R_AX_HC00IMR 0xC180
#define R_AX_HC00IMR_C1 0xE180
#define B_AX_TBTT_B0P4_INT_EN BIT(16)
#define B_AX_TBTT_B0P3_INT_EN BIT(15)
#define B_AX_TBTT_B0P2_INT_EN BIT(14)
#define B_AX_TBTT_B0P1_INT_EN BIT(13)
#define B_AX_TBTT_B0P0_INT_EN BIT(12)
#define B_AX_PKT_INFO_ERR_INT_EN BIT(11)
#define B_AX_BB_STOPRX_INT_EN BIT(10)
#define B_AX_TXERR_INT_EN BIT(9)
#define B_AX_RXERR_INT_EN BIT(8)
#define B_AX_P2P1_TSF32_TOGG_INT_EN BIT(7)
#define B_AX_P2P0_TSF32_TOGG_INT_EN BIT(6)
#define B_AX_PWR_127TO96_INT_EN BIT(5)
#define B_AX_PWR_95TO64_INT_EN BIT(4)
#define B_AX_PWR_63TO32_INT_EN BIT(3)
#define B_AX_PWR_31TO0_INT_EN BIT(2)
#define B_AX_PSTIMER_5_INT_EN BIT(1)
#define B_AX_PSTIMER_4_INT_EN BIT(0)

#define R_AX_HC00ISR 0xC184
#define R_AX_HC00ISR_C1 0xE184
#define B_AX_TBTT_B0P4_INT BIT(16)
#define B_AX_TBTT_B0P3_INT BIT(15)
#define B_AX_TBTT_B0P2_INT BIT(14)
#define B_AX_TBTT_B0P1_INT BIT(13)
#define B_AX_TBTT_B0P0_INT BIT(12)
#define B_AX_PKT_INFO_ERR_INT BIT(11)
#define B_AX_BB_STOPRX_INT BIT(10)
#define B_AX_TXERR_INT BIT(9)
#define B_AX_RXERR_INT BIT(8)
#define B_AX_P2P1_TSF32_TOGG_INT BIT(7)
#define B_AX_P2P0_TSF32_TOGG_INT BIT(6)
#define B_AX_PWR_127TO96_INT BIT(5)
#define B_AX_PWR_95TO64_INT BIT(4)
#define B_AX_PWR_63TO32_INT BIT(3)
#define B_AX_PWR_31TO0_INT BIT(2)
#define B_AX_PSTIMER_5_INT BIT(1)
#define B_AX_PSTIMER_4_INT BIT(0)

//
// SCH
//

#define R_AX_PPS0_CTRL 0xC200
#define R_AX_PPS0_CTRL_C1 0xE200
#define B_AX_PPS0_PWR_RST1 BIT(31)
#define B_AX_PPS0_PWR_RST0 BIT(30)
#define B_AX_PPS0_CTWIN_SH 16
#define B_AX_PPS0_CTWIN_MSK 0xfff
#define B_AX_PPS0_TXOP_BRK_EN BIT(15)
#define B_AX_PPS0_AGG_BRK_EN BIT(14)
#define B_AX_PPS0_POF_AND_EN BIT(13)
#define B_AX_PPS0_PSWIND_EN BIT(12)
#define B_AX_PPS0_TSFB32_RST_EN BIT(11)
#define B_AX_PPS0_PORT_SEL_SH 8
#define B_AX_PPS0_PORT_SEL_MSK 0x7
#define B_AX_PPS0_ALLSLEEP_EN BIT(7)
#define B_AX_PPS0_OFF_DISTX_EN BIT(6)
#define B_AX_PPS0_CTWIN_EN BIT(5)
#define B_AX_PPS0_BCNAREA_EN BIT(4)
#define B_AX_PPS0_WITHBCNERY BIT(3)
#define B_AX_PPS0_POF1_EN BIT(2)
#define B_AX_PPS0_POF0_EN BIT(1)
#define B_AX_PPS0_PWR_MGT_EN BIT(0)

#define R_AX_PPS0_SPEC_STATE 0xC204
#define R_AX_PPS0_SPEC_STATE_C1 0xE204
#define B_AX_PPS0_SPEC_POW_STATE BIT(7)
#define B_AX_PPS0_SPEC_CTWIN_ON BIT(6)
#define B_AX_PPS0_SPEC_BCNAREA_ON BIT(5)
#define B_AX_PPS0_SPEC_BCNERLY BIT(4)
#define B_AX_PPS0_SPEC_POF1_OFF_PERD BIT(3)
#define B_AX_PPS0_SPEC_FORCE_DOZE1 BIT(2)
#define B_AX_PPS0_SPEC_POF0_OFF_PERD BIT(1)
#define B_AX_PPS0_SPEC_FORCE_DOZE0 BIT(0)

#define R_AX_PPS0_STATE 0xC205
#define R_AX_PPS0_STATE_C1 0xE205
#define B_AX_PPS0_POW_STATE BIT(7)
#define B_AX_PPS0_CTWIN_ON BIT(6)
#define B_AX_PPS0_BCNAREA_ON BIT(5)
#define B_AX_PPS0_BCNERLY BIT(4)
#define B_AX_PPS0_POF1_OFF_PERD BIT(3)
#define B_AX_PPS0_FORCE_DOZE1 BIT(2)
#define B_AX_PPS0_POF0_OFF_PERD BIT(1)
#define B_AX_PPS0_FORCE_DOZE0 BIT(0)

#define R_AX_PPS0_PAUSE_CTRL0 0xC206
#define R_AX_PPS0_PAUSE_CTRL0_C1 0xE206
#define B_AX_PPS0_POF_STOP_TX_HANG BIT(15)
#define B_AX_PPS0_MGQ_PAUSE_EN BIT(11)
#define B_AX_PPS0_HIQ_PAUSE_EN BIT(10)
#define B_AX_PPS0_BCNQ_PAUSE_EN BIT(9)
#define B_AX_PPS0_MACID_PAUSE_EN BIT(8)
#define B_AX_PPS0_PAUSE_MACID_SH 0
#define B_AX_PPS0_PAUSE_MACID_MSK 0xff

#define R_AX_PPS0_PAUSE_CTRL1 0xC208
#define R_AX_PPS0_PAUSE_CTRL1_C1 0xE208
#define B_AX_PPS0_POWON_DISTX_SH 16
#define B_AX_PPS0_POWON_DISTX_MSK 0xffff
#define B_AX_PPS0_POWOFF_DISTX_SH 0
#define B_AX_PPS0_POWOFF_DISTX_MSK 0xffff

#define R_AX_PPS0_PAUSE_CTRL2 0xC20C
#define R_AX_PPS0_PAUSE_CTRL2_C1 0xE20C
#define B_AX_PPS0_POWOFF_ERLY_SH 16
#define B_AX_PPS0_POWOFF_ERLY_MSK 0xffff
#define B_AX_PPS0_POWON_ERLY_SH 0
#define B_AX_PPS0_POWON_ERLY_MSK 0xffff

#define R_AX_PPS0_POF0_PARAM0 0xC210
#define R_AX_PPS0_POF0_PARAM0_C1 0xE210
#define B_AX_PPS0_POF0_DUR_SH 0
#define B_AX_PPS0_POF0_DUR_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM1 0xC214
#define R_AX_PPS0_POF0_PARAM1_C1 0xE214
#define B_AX_PPS0_POF0_ITVL_SH 0
#define B_AX_PPS0_POF0_ITVL_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM2 0xC218
#define R_AX_PPS0_POF0_PARAM2_C1 0xE218
#define B_AX_PPS0_POF0_START_SH 0
#define B_AX_PPS0_POF0_START_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM3 0xC21C
#define R_AX_PPS0_POF0_PARAM3_C1 0xE21C
#define B_AX_PPS0_POF0_CUR_CNT_SH 8
#define B_AX_PPS0_POF0_CUR_CNT_MSK 0xff
#define B_AX_PPS0_POF0_CNT_SH 0
#define B_AX_PPS0_POF0_CNT_MSK 0xff

#define R_AX_PPS0_POF1_PARAM0 0xC220
#define R_AX_PPS0_POF1_PARAM0_C1 0xE220
#define B_AX_PPS0_POF1_DUR_SH 0
#define B_AX_PPS0_POF1_DUR_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM1 0xC224
#define R_AX_PPS0_POF1_PARAM1_C1 0xE224
#define B_AX_PPS0_POF1_ITVL_SH 0
#define B_AX_PPS0_POF1_ITVL_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM2 0xC228
#define R_AX_PPS0_POF1_PARAM2_C1 0xE228
#define B_AX_PPS0_POF1_START_SH 0
#define B_AX_PPS0_POF1_START_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM3 0xC22C
#define R_AX_PPS0_POF1_PARAM3_C1 0xE22C
#define B_AX_PPS0_POF1_CUR_CNT_SH 8
#define B_AX_PPS0_POF1_CUR_CNT_MSK 0xff
#define B_AX_PPS0_POF1_CNT_SH 0
#define B_AX_PPS0_POF1_CNT_MSK 0xff

#define R_AX_PPS0_CURR_DOZE0 0xC230
#define R_AX_PPS0_CURR_DOZE0_C1 0xE230
#define B_AX_PPS0_POF0_CURR_DOZE_SH 0
#define B_AX_PPS0_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS0_CURR_DOZE1 0xC234
#define R_AX_PPS0_CURR_DOZE1_C1 0xE234
#define B_AX_PPS0_POF1_CURR_DOZE_SH 0
#define B_AX_PPS0_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS1_CTRL 0xC240
#define R_AX_PPS1_CTRL_C1 0xE240
#define B_AX_PPS1_PWR_RST1 BIT(31)
#define B_AX_PPS1_PWR_RST0 BIT(30)
#define B_AX_PPS1_CTWIN_SH 16
#define B_AX_PPS1_CTWIN_MSK 0xfff
#define B_AX_PPS1_TXOP_BRK_EN BIT(15)
#define B_AX_PPS1_AGG_BRK_EN BIT(14)
#define B_AX_PPS1_POF_AND_EN BIT(13)
#define B_AX_PPS1_PSWIND_EN BIT(12)
#define B_AX_PPS1_TSFB32_RST_EN BIT(11)
#define B_AX_PPS1_PORT_SEL_SH 8
#define B_AX_PPS1_PORT_SEL_MSK 0x7
#define B_AX_PPS1_ALLSLEEP_EN BIT(7)
#define B_AX_PPS1_OFF_DISTX_EN BIT(6)
#define B_AX_PPS1_CTWIN_EN BIT(5)
#define B_AX_PPS1_BCNAREA_EN BIT(4)
#define B_AX_PPS1_WITHBCNERY BIT(3)
#define B_AX_PPS1_POF1_EN BIT(2)
#define B_AX_PPS1_POF0_EN BIT(1)
#define B_AX_PPS1_PWR_MGT_EN BIT(0)

#define R_AX_PPS1_SPEC_STATE 0xC244
#define R_AX_PPS1_SPEC_STATE_C1 0xE244
#define B_AX_PPS1_SPEC_POW_STATE BIT(7)
#define B_AX_PPS1_SPEC_CTWIN_ON BIT(6)
#define B_AX_PPS1_SPEC_BCNAREA_ON BIT(5)
#define B_AX_PPS1_SPEC_BCNERLY BIT(4)
#define B_AX_PPS1_SPEC_POF1_OFF_PERD BIT(3)
#define B_AX_PPS1_SPEC_FORCE_DOZE1 BIT(2)
#define B_AX_PPS1_SPEC_POF0_OFF_PERD BIT(1)
#define B_AX_PPS1_SPEC_FORCE_DOZE0 BIT(0)

#define R_AX_PPS1_STATE 0xC245
#define R_AX_PPS1_STATE_C1 0xE245
#define B_AX_PPS1_POW_STATE BIT(7)
#define B_AX_PPS1_CTWIN_ON BIT(6)
#define B_AX_PPS1_BCNAREA_ON BIT(5)
#define B_AX_PPS1_BCNERLY BIT(4)
#define B_AX_PPS1_POF1_OFF_PERD BIT(3)
#define B_AX_PPS1_FORCE_DOZE1 BIT(2)
#define B_AX_PPS1_POF0_OFF_PERD BIT(1)
#define B_AX_PPS1_FORCE_DOZE0 BIT(0)

#define R_AX_PPS1_PAUSE_CTRL0 0xC246
#define R_AX_PPS1_PAUSE_CTRL0_C1 0xE246
#define B_AX_PPS1_POF_STOP_TX_HANG BIT(15)
#define B_AX_PPS1_MGQ_PAUSE_EN BIT(11)
#define B_AX_PPS1_HIQ_PAUSE_EN BIT(10)
#define B_AX_PPS1_BCNQ_PAUSE_EN BIT(9)
#define B_AX_PPS1_MACID_PAUSE_EN BIT(8)
#define B_AX_PPS1_PAUSE_MACID_SH 0
#define B_AX_PPS1_PAUSE_MACID_MSK 0xff

#define R_AX_PPS1_PAUSE_CTRL1 0xC248
#define R_AX_PPS1_PAUSE_CTRL1_C1 0xE248
#define B_AX_PPS1_POWON_DISTX_SH 16
#define B_AX_PPS1_POWON_DISTX_MSK 0xffff
#define B_AX_PPS1_POWOFF_DISTX_SH 0
#define B_AX_PPS1_POWOFF_DISTX_MSK 0xffff

#define R_AX_PPS1_PAUSE_CTRL2 0xC24C
#define R_AX_PPS1_PAUSE_CTRL2_C1 0xE24C
#define B_AX_PPS1_POWOFF_ERLY_SH 16
#define B_AX_PPS1_POWOFF_ERLY_MSK 0xffff
#define B_AX_PPS1_POWON_ERLY_SH 0
#define B_AX_PPS1_POWON_ERLY_MSK 0xffff

#define R_AX_PPS1_POF0_PARAM0 0xC250
#define R_AX_PPS1_POF0_PARAM0_C1 0xE250
#define B_AX_PPS1_POF0_DUR_SH 0
#define B_AX_PPS1_POF0_DUR_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM1 0xC254
#define R_AX_PPS1_POF0_PARAM1_C1 0xE254
#define B_AX_PPS1_POF0_ITVL_SH 0
#define B_AX_PPS1_POF0_ITVL_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM2 0xC258
#define R_AX_PPS1_POF0_PARAM2_C1 0xE258
#define B_AX_PPS1_POF0_START_SH 0
#define B_AX_PPS1_POF0_START_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM3 0xC25C
#define R_AX_PPS1_POF0_PARAM3_C1 0xE25C
#define B_AX_PPS1_POF0_CUR_CNT_SH 8
#define B_AX_PPS1_POF0_CUR_CNT_MSK 0xff
#define B_AX_PPS1_POF0_CNT_SH 0
#define B_AX_PPS1_POF0_CNT_MSK 0xff

#define R_AX_PPS1_POF1_PARAM0 0xC260
#define R_AX_PPS1_POF1_PARAM0_C1 0xE260
#define B_AX_PPS1_POF1_DUR_SH 0
#define B_AX_PPS1_POF1_DUR_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM1 0xC264
#define R_AX_PPS1_POF1_PARAM1_C1 0xE264
#define B_AX_PPS1_POF1_ITVL_SH 0
#define B_AX_PPS1_POF1_ITVL_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM2 0xC268
#define R_AX_PPS1_POF1_PARAM2_C1 0xE268
#define B_AX_PPS1_POF1_START_SH 0
#define B_AX_PPS1_POF1_START_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM3 0xC26C
#define R_AX_PPS1_POF1_PARAM3_C1 0xE26C
#define B_AX_PPS1_POF1_CUR_CNT_SH 8
#define B_AX_PPS1_POF1_CUR_CNT_MSK 0xff
#define B_AX_PPS1_POF1_CNT_SH 0
#define B_AX_PPS1_POF1_CNT_MSK 0xff

#define R_AX_PPS1_CURR_DOZE0 0xC270
#define R_AX_PPS1_CURR_DOZE0_C1 0xE270
#define B_AX_PPS1_POF0_CURR_DOZE_SH 0
#define B_AX_PPS1_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS1_CURR_DOZE1 0xC274
#define R_AX_PPS1_CURR_DOZE1_C1 0xE274
#define B_AX_PPS1_POF1_CURR_DOZE_SH 0
#define B_AX_PPS1_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PORT_0_TSF_SYNC 0xC2A0
#define R_AX_PORT_0_TSF_SYNC_C1 0xE2A0
#define B_AX_P0_SYNC_NOW_P BIT(30)
#define B_AX_P0_SYNC_ONCE_P BIT(29)
#define B_AX_P0_AUTO_SYNC BIT(28)
#define B_AX_P0_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P0_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P0_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P0_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_1_TSF_SYNC 0xC2A4
#define R_AX_PORT_1_TSF_SYNC_C1 0xE2A4
#define B_AX_P1_SYNC_NOW_P BIT(30)
#define B_AX_P1_SYNC_ONCE_P BIT(29)
#define B_AX_P1_AUTO_SYNC BIT(28)
#define B_AX_P1_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P1_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P1_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P1_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_2_TSF_SYNC 0xC2A8
#define R_AX_PORT_2_TSF_SYNC_C1 0xE2A8
#define B_AX_P2_SYNC_NOW_P BIT(30)
#define B_AX_P2_SYNC_ONCE_P BIT(29)
#define B_AX_P2_AUTO_SYNC BIT(28)
#define B_AX_P2_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P2_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P2_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P2_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_3_TSF_SYNC 0xC2AC
#define R_AX_PORT_3_TSF_SYNC_C1 0xE2AC
#define B_AX_P3_SYNC_NOW_P BIT(30)
#define B_AX_P3_SYNC_ONCE_P BIT(29)
#define B_AX_P3_AUTO_SYNC BIT(28)
#define B_AX_P3_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P3_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P3_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P3_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_4_TSF_SYNC 0xC2B0
#define R_AX_PORT_4_TSF_SYNC_C1 0xE2B0
#define B_AX_P4_SYNC_NOW_P BIT(30)
#define B_AX_P4_SYNC_ONCE_P BIT(29)
#define B_AX_P4_AUTO_SYNC BIT(28)
#define B_AX_P4_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P4_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P4_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P4_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_MACID_SLEEP_0 0xC2C0
#define R_AX_MACID_SLEEP_0_C1 0xE2C0
#define B_AX_MACID31_0_SLEEP_SH 0
#define B_AX_MACID31_0_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_1 0xC2C4
#define R_AX_MACID_SLEEP_1_C1 0xE2C4
#define B_AX_MACID63_32_SLEEP_SH 0
#define B_AX_MACID63_32_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_2 0xC2C8
#define R_AX_MACID_SLEEP_2_C1 0xE2C8
#define B_AX_MACID95_64_SLEEP_SH 0
#define B_AX_MACID95_64_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_3 0xC2CC
#define R_AX_MACID_SLEEP_3_C1 0xE2CC
#define B_AX_MACID127_96_SLEEP_SH 0
#define B_AX_MACID127_96_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_4 0xC2D0
#define R_AX_MACID_SLEEP_4_C1 0xE2D0

#define R_AX_MACID_SLEEP_5 0xC2D4
#define R_AX_MACID_SLEEP_5_C1 0xE2D4

#define R_AX_MACID_SLEEP_6 0xC2D8
#define R_AX_MACID_SLEEP_6_C1 0xE2D8

#define R_AX_MACID_SLEEP_7 0xC2DC
#define R_AX_MACID_SLEEP_7_C1 0xE2DC

#define R_AX_CMAC_MACID_DROP_0 0xC2E0
#define R_AX_CMAC_MACID_DROP_0_C1 0xE2E0
#define B_AX_CMAC_MACID31_0_DROP_SH 0
#define B_AX_CMAC_MACID31_0_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_1 0xC2E4
#define R_AX_CMAC_MACID_DROP_1_C1 0xE2E4
#define B_AX_CMAC_MACID63_32_DROP_SH 0
#define B_AX_CMAC_MACID63_32_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_2 0xC2E8
#define R_AX_CMAC_MACID_DROP_2_C1 0xE2E8
#define B_AX_CMAC_MACID95_64_DROP_SH 0
#define B_AX_CMAC_MACID95_64_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_3 0xC2EC
#define R_AX_CMAC_MACID_DROP_3_C1 0xE2EC
#define B_AX_CMAC_MACID127_96_DROP_SH 0
#define B_AX_CMAC_MACID127_96_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_4 0xC2F0
#define R_AX_CMAC_MACID_DROP_4_C1 0xE2F0

#define R_AX_CMAC_MACID_DROP_5 0xC2F4
#define R_AX_CMAC_MACID_DROP_5_C1 0xE2F4

#define R_AX_CMAC_MACID_DROP_6 0xC2F8
#define R_AX_CMAC_MACID_DROP_6_C1 0xE2F8

#define R_AX_CMAC_MACID_DROP_7 0xC2FC
#define R_AX_CMAC_MACID_DROP_7_C1 0xE2FC

#define R_AX_EDCA_BE_PARAM_0 0xC300
#define R_AX_EDCA_BE_PARAM_0_C1 0xE300
#define B_AX_BE_0_TXOPLMT_SH 16
#define B_AX_BE_0_TXOPLMT_MSK 0x7ff
#define B_AX_BE_0_CW_SH 8
#define B_AX_BE_0_CW_MSK 0xff
#define B_AX_BE_0_AIFS_SH 0
#define B_AX_BE_0_AIFS_MSK 0xff

#define R_AX_EDCA_BK_PARAM_0 0xC304
#define R_AX_EDCA_BK_PARAM_0_C1 0xE304
#define B_AX_BK_0_TXOPLMT_SH 16
#define B_AX_BK_0_TXOPLMT_MSK 0x7ff
#define B_AX_BK_0_CW_SH 8
#define B_AX_BK_0_CW_MSK 0xff
#define B_AX_BK_0_AIFS_SH 0
#define B_AX_BK_0_AIFS_MSK 0xff

#define R_AX_EDCA_VI_PARAM_0 0xC308
#define R_AX_EDCA_VI_PARAM_0_C1 0xE308
#define B_AX_VI_0_TXOPLMT_SH 16
#define B_AX_VI_0_TXOPLMT_MSK 0x7ff
#define B_AX_VI_0_CW_SH 8
#define B_AX_VI_0_CW_MSK 0xff
#define B_AX_VI_0_AIFS_SH 0
#define B_AX_VI_0_AIFS_MSK 0xff

#define R_AX_EDCA_VO_PARAM_0 0xC30C
#define R_AX_EDCA_VO_PARAM_0_C1 0xE30C
#define B_AX_VO_0_TXOPLMT_SH 16
#define B_AX_VO_0_TXOPLMT_MSK 0x7ff
#define B_AX_VO_0_CW_SH 8
#define B_AX_VO_0_CW_MSK 0xff
#define B_AX_VO_0_AIFS_SH 0
#define B_AX_VO_0_AIFS_MSK 0xff

#define R_AX_EDCA_BE_PARAM_1 0xC310
#define R_AX_EDCA_BE_PARAM_1_C1 0xE310
#define B_AX_BE_1_TXOPLMT_SH 16
#define B_AX_BE_1_TXOPLMT_MSK 0x7ff
#define B_AX_BE_1_CW_SH 8
#define B_AX_BE_1_CW_MSK 0xff
#define B_AX_BE_1_AIFS_SH 0
#define B_AX_BE_1_AIFS_MSK 0xff

#define R_AX_EDCA_BK_PARAM_1 0xC314
#define R_AX_EDCA_BK_PARAM_1_C1 0xE314
#define B_AX_BK_1_TXOPLMT_SH 16
#define B_AX_BK_1_TXOPLMT_MSK 0x7ff
#define B_AX_BK_1_CW_SH 8
#define B_AX_BK_1_CW_MSK 0xff
#define B_AX_BK_1_AIFS_SH 0
#define B_AX_BK_1_AIFS_MSK 0xff

#define R_AX_EDCA_VI_PARAM_1 0xC318
#define R_AX_EDCA_VI_PARAM_1_C1 0xE318
#define B_AX_VI_1_TXOPLMT_SH 16
#define B_AX_VI_1_TXOPLMT_MSK 0x7ff
#define B_AX_VI_1_CW_SH 8
#define B_AX_VI_1_CW_MSK 0xff
#define B_AX_VI_1_AIFS_SH 0
#define B_AX_VI_1_AIFS_MSK 0xff

#define R_AX_EDCA_VO_PARAM_1 0xC31C
#define R_AX_EDCA_VO_PARAM_1_C1 0xE31C
#define B_AX_VO_1_TXOPLMT_SH 16
#define B_AX_VO_1_TXOPLMT_MSK 0x7ff
#define B_AX_VO_1_CW_SH 8
#define B_AX_VO_1_CW_MSK 0xff
#define B_AX_VO_1_AIFS_SH 0
#define B_AX_VO_1_AIFS_MSK 0xff

#define R_AX_EDCA_MGQ_PARAM 0xC320
#define R_AX_EDCA_MGQ_PARAM_C1 0xE320
#define B_AX_CPUMGQ_CW_SH 24
#define B_AX_CPUMGQ_CW_MSK 0xff
#define B_AX_CPUMGQ_AIFS_SH 16
#define B_AX_CPUMGQ_AIFS_MSK 0xff
#define B_AX_MGQ_CW_SH 8
#define B_AX_MGQ_CW_MSK 0xff
#define B_AX_MGQ_AIFS_SH 0
#define B_AX_MGQ_AIFS_MSK 0xff

#define R_AX_EDCA_BCNQ_PARAM 0xC324
#define R_AX_EDCA_BCNQ_PARAM_C1 0xE324
#define B_AX_BCNQ_CW_SH 24
#define B_AX_BCNQ_CW_MSK 0xff
#define B_AX_BCNQ_AIFS_SH 16
#define B_AX_BCNQ_AIFS_MSK 0xff
#define B_AX_PIFS_SH 8
#define B_AX_PIFS_MSK 0xff
#define B_AX_FORCE_BCN_IFS_SH 0
#define B_AX_FORCE_BCN_IFS_MSK 0xff

#define R_AX_EDCA_ULQ_PARAM 0xC328
#define R_AX_EDCA_ULQ_PARAM_C1 0xE328
#define B_AX_ULQ_TXOPLMT_SH 16
#define B_AX_ULQ_TXOPLMT_MSK 0x7ff
#define B_AX_ULQ_CW_SH 8
#define B_AX_ULQ_CW_MSK 0xff
#define B_AX_ULQ_AIFS_SH 0
#define B_AX_ULQ_AIFS_MSK 0xff

#define R_AX_EDCA_TWT_PARAM_0 0xC32C
#define R_AX_EDCA_TWT_PARAM_0_C1 0xE32C
#define B_AX_TWT_0_TXOPLMT_SH 16
#define B_AX_TWT_0_TXOPLMT_MSK 0x7ff
#define B_AX_TWT_0_CW_SH 8
#define B_AX_TWT_0_CW_MSK 0xff
#define B_AX_TWT_0_AIFS_SH 0
#define B_AX_TWT_0_AIFS_MSK 0xff

#define R_AX_EDCA_TWT_PARAM_1 0xC330
#define R_AX_EDCA_TWT_PARAM_1_C1 0xE330
#define B_AX_TWT_1_TXOPLMT_SH 16
#define B_AX_TWT_1_TXOPLMT_MSK 0x7ff
#define B_AX_TWT_1_CW_SH 8
#define B_AX_TWT_1_CW_MSK 0xff
#define B_AX_TWT_1_AIFS_SH 0
#define B_AX_TWT_1_AIFS_MSK 0xff

#define R_AX_SLOTTIME_CFG 0xC334
#define R_AX_SLOTTIME_CFG_C1 0xE334
#define B_AX_SLOT_TIME_SH 0
#define B_AX_SLOT_TIME_MSK 0xff

#define R_AX_PREBKF_CFG_0 0xC338
#define R_AX_PREBKF_CFG_0_C1 0xE338
#define B_AX_100NS_TIME_SH 24
#define B_AX_100NS_TIME_MSK 0x1f
#define B_AX_RX_AIR_END_TIME_SH 16
#define B_AX_RX_AIR_END_TIME_MSK 0x7f
#define B_AX_MACTX_LATENCY_SH 8
#define B_AX_MACTX_LATENCY_MSK 0x7
#define B_AX_PREBKF_TIME_SH 0
#define B_AX_PREBKF_TIME_MSK 0x1f

#define R_AX_PREBKF_CFG_1 0xC33C
#define R_AX_PREBKF_CFG_1_C1 0xE33C
#define B_AX_SIFS_TIMEOUT_TB_AGGR_SH 24
#define B_AX_SIFS_TIMEOUT_TB_AGGR_MSK 0x7f
#define B_AX_SIFS_PREBKF_SH 16
#define B_AX_SIFS_PREBKF_MSK 0xff
#define B_AX_SIFS_TIMEOUT_T2_SH 8
#define B_AX_SIFS_TIMEOUT_T2_MSK 0x7f
#define B_AX_SIFS_MACTXEN_T1_SH 0
#define B_AX_SIFS_MACTXEN_T1_MSK 0x7f

#define R_AX_CCA_CFG_0 0xC340
#define R_AX_CCA_CFG_0_C1 0xE340
#define B_AX_R_SIFS_AGGR_TIME_SH 24
#define B_AX_R_SIFS_AGGR_TIME_MSK 0x7f
#define B_AX_BTCCA_BRK_TXOP_EN BIT(9)
#define B_AX_NAV_BRK_TXOP_EN BIT(8)
#define B_AX_TX_NAV_EN BIT(7)
#define B_AX_BCN_IGNORE_EDCCA BIT(6)
#define B_AX_BTCCA_EN BIT(5)
#define B_AX_EDCCA_EN BIT(4)
#define B_AX_SEC80_EN BIT(3)
#define B_AX_SEC40_EN BIT(2)
#define B_AX_SEC20_EN BIT(1)
#define B_AX_CCA_EN BIT(0)

#define R_AX_MISC_0 0xC344
#define R_AX_MISC_0_C1 0xE344
#define B_AX_CMAC_SHARE_DBG_SEL_SH 16
#define B_AX_CMAC_SHARE_DBG_SEL_MSK 0xf
#define B_AX_RST_FREERUN_P BIT(15)
#define B_AX_EN_FREERUN BIT(8)
#define B_AX_TXOP_RESP_EN BIT(1)
#define B_AX_EN_TBTT_AREA_FOR_AX_BB BIT(0)

#define R_AX_CTN_TXEN 0xC348
#define R_AX_CTN_TXEN_C1 0xE348
#define B_AX_CTN_TXEN_TWT_1 BIT(15)
#define B_AX_CTN_TXEN_TWT_0 BIT(14)
#define B_AX_CTN_TXEN_ULQ BIT(13)
#define B_AX_CTN_TXEN_BCNQ BIT(12)
#define B_AX_CTN_TXEN_HGQ BIT(11)
#define B_AX_CTN_TXEN_CPUMGQ BIT(10)
#define B_AX_CTN_TXEN_MGQ1 BIT(9)
#define B_AX_CTN_TXEN_MGQ BIT(8)
#define B_AX_CTN_TXEN_VO_1 BIT(7)
#define B_AX_CTN_TXEN_VI_1 BIT(6)
#define B_AX_CTN_TXEN_BK_1 BIT(5)
#define B_AX_CTN_TXEN_BE_1 BIT(4)
#define B_AX_CTN_TXEN_VO_0 BIT(3)
#define B_AX_CTN_TXEN_VI_0 BIT(2)
#define B_AX_CTN_TXEN_BK_0 BIT(1)
#define B_AX_CTN_TXEN_BE_0 BIT(0)

#define R_AX_CTN_CFG_0 0xC34C
#define R_AX_CTN_CFG_0_C1 0xE34C
#define B_AX_SR_TX_EN BIT(2)
#define B_AX_NAV_BLK_HGQ BIT(1)
#define B_AX_NAV_BLK_MGQ BIT(0)

#define R_AX_MUEDCA_BE_PARAM_0 0xC350
#define R_AX_MUEDCA_BE_PARAM_0_C1 0xE350
#define B_AX_MUEDCA_BE_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_BE_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_BE_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_BE_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_BE_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_BE_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_BK_PARAM_0 0xC354
#define R_AX_MUEDCA_BK_PARAM_0_C1 0xE354
#define B_AX_MUEDCA_BK_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_BK_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_BK_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_BK_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_BK_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_BK_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_VI_PARAM_0 0xC358
#define R_AX_MUEDCA_VI_PARAM_0_C1 0xE358
#define B_AX_MUEDCA_VI_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_VI_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_VI_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_VI_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_VI_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_VI_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_VO_PARAM_0 0xC35C
#define R_AX_MUEDCA_VO_PARAM_0_C1 0xE35C
#define B_AX_MUEDCA_VO_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_VO_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_VO_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_VO_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_VO_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_VO_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_EN 0xC370
#define R_AX_MUEDCA_EN_C1 0xE370
#define B_AX_MUEDCA_WMM_SEL BIT(8)
#define B_AX_SET_MUEDCATIMER_TF_1 BIT(5)
#define B_AX_SET_MUEDCATIMER_TF_0 BIT(4)
#define B_AX_MUEDCA_EN_0 BIT(0)

#define R_AX_RAND_SCR_BIT 0xC374
#define R_AX_RAND_SCR_BIT_C1 0xE374
#define B_AX_RAND_SCBITS_SH 0
#define B_AX_RAND_SCBITS_MSK 0x7fffff

#define R_AX_RANDOM_CFG 0xC378
#define R_AX_RANDOM_CFG_C1 0xE378
#define B_AX_RAND_SET_SH 0
#define B_AX_RAND_SET_MSK 0xffffff

#define R_AX_MUEDCATIMER_0 0xC380
#define R_AX_MUEDCATIMER_0_C1 0xE380
#define B_AX_MUEDCATIMER_BK_0_SH 16
#define B_AX_MUEDCATIMER_BK_0_MSK 0xffff
#define B_AX_MUEDCATIMER_BE_0_SH 0
#define B_AX_MUEDCATIMER_BE_0_MSK 0xffff

#define R_AX_MUEDCATIMER_1 0xC384
#define R_AX_MUEDCATIMER_1_C1 0xE384
#define B_AX_MUEDCATIMER_VO_0_SH 16
#define B_AX_MUEDCATIMER_VO_0_MSK 0xffff
#define B_AX_MUEDCATIMER_VI_0_SH 0
#define B_AX_MUEDCATIMER_VI_0_MSK 0xffff

#define R_AX_CCA_CONTROL 0xC390
#define R_AX_CCA_CONTROL_C1 0xE390
#define B_AX_TB_CHK_TX_NAV BIT(31)
#define B_AX_TB_CHK_BASIC_NAV BIT(30)
#define B_AX_TB_CHK_BTCCA BIT(29)
#define B_AX_TB_CHK_EDCCA BIT(28)
#define B_AX_TB_CHK_CCA_S80 BIT(27)
#define B_AX_TB_CHK_CCA_S40 BIT(26)
#define B_AX_TB_CHK_CCA_S20 BIT(25)
#define B_AX_TB_CHK_CCA_P20 BIT(24)
#define B_AX_SIFS_CHK_BTCCA BIT(21)
#define B_AX_SIFS_CHK_EDCCA BIT(20)
#define B_AX_SIFS_CHK_CCA_S80 BIT(19)
#define B_AX_SIFS_CHK_CCA_S40 BIT(18)
#define B_AX_SIFS_CHK_CCA_S20 BIT(17)
#define B_AX_SIFS_CHK_CCA_P20 BIT(16)
#define B_AX_CTN_CHK_TXNAV BIT(8)
#define B_AX_CTN_CHK_INTRA_NAV BIT(7)
#define B_AX_CTN_CHK_BASIC_NAV BIT(6)
#define B_AX_CTN_CHK_BTCCA BIT(5)
#define B_AX_CTN_CHK_EDCCA BIT(4)
#define B_AX_CTN_CHK_CCA_S80 BIT(3)
#define B_AX_CTN_CHK_CCA_S40 BIT(2)
#define B_AX_CTN_CHK_CCA_S20 BIT(1)
#define B_AX_CTN_CHK_CCA_P20 BIT(0)

#define R_AX_CCA_CONTROL_2 0xC394
#define R_AX_CCA_CONTROL_2_C1 0xE394
#define B_AX_SR_CTN_CHK_TX_NAV BIT(7)
#define B_AX_SR_CTN_CHK__NAV BIT(6)
#define B_AX_SR_CTN_CHK_BTCCA BIT(5)
#define B_AX_SR_CTN_CHK_EDCCA BIT(4)
#define B_AX_SR_CTN_CHK_CCA_S80 BIT(3)
#define B_AX_SR_CTN_CHK_CCA_S40 BIT(2)
#define B_AX_SR_CTN_CHK_CCA_S20 BIT(1)

#define R_AX_SCHEDULE_ERR_IMR 0xC3E8
#define R_AX_SCHEDULE_ERR_IMR_C1 0xE3E8
#define B_AX_SORT_NON_IDLE_ERR_INT_EN BIT(1)
#define B_AX_FSM_TIMEOUT_ERR_INT_EN BIT(0)

#define R_AX_SCHEDULE_ERR_ISR 0xC3EC
#define R_AX_SCHEDULE_ERR_ISR_C1 0xE3EC
#define B_AX_SORT_NON_IDLE_ERR_INT BIT(1)
#define B_AX_FSM_TIMEOUT_ERR_INT BIT(0)

#define R_AX_SCH_DBG_SEL 0xC3F4
#define R_AX_SCH_DBG_SEL_C1 0xE3F4
#define B_AX_SCH_DBG_EN BIT(16)
#define B_AX_SCH_CFG_CMD_SEL_SH 8
#define B_AX_SCH_CFG_CMD_SEL_MSK 0xff
#define B_AX_SCH_DBG_SEL_SH 0
#define B_AX_SCH_DBG_SEL_MSK 0xff

#define R_AX_SCH_DBG 0xC3F8
#define R_AX_SCH_DBG_C1 0xE3F8
#define B_AX_SCHEDULER_DBG_SH 0
#define B_AX_SCHEDULER_DBG_MSK 0xffffffffL

#define R_AX_SCH_EXT_CTRL 0xC3FC
#define R_AX_SCH_EXT_CTRL_C1 0xE3FC

#define R_AX_PORT_CFG_P0 0xC400
#define R_AX_PORT_CFG_P0_C1 0xE400
#define B_AX_PROHIB_END_CAL_EN_P0 BIT(17)
#define B_AX_BRK_SETUP_P0 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P0 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P0 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P0 BIT(13)
#define B_AX_BCNTX_EN_P0 BIT(12)
#define B_AX_NET_TYPE_P0_SH 10
#define B_AX_NET_TYPE_P0_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P0 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P0 BIT(8)
#define B_AX_BCNERR_CNT_EN_P0 BIT(7)
#define B_AX_BCN_AGRES_P0 BIT(6)
#define B_AX_TSFTR_RST_P0 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P0 BIT(4)
#define B_AX_TSF_UDT_EN_P0 BIT(3)
#define B_AX_PORT_FUNC_EN_P0 BIT(2)
#define B_AX_TXBCN_RPT_EN_P0 BIT(1)
#define B_AX_RXBCN_RPT_EN_P0 BIT(0)

#define R_AX_TBTT_PROHIB_P0 0xC404
#define R_AX_TBTT_PROHIB_P0_C1 0xE404
#define B_AX_TBTT_HOLD_P0_SH 16
#define B_AX_TBTT_HOLD_P0_MSK 0xfff
#define B_AX_TBTT_SETUP_P0_SH 0
#define B_AX_TBTT_SETUP_P0_MSK 0xff

#define R_AX_BCN_AREA_P0 0xC408
#define R_AX_BCN_AREA_P0_C1 0xE408
#define B_AX_BCN_MSK_AREA_P0_SH 16
#define B_AX_BCN_MSK_AREA_P0_MSK 0xfff
#define B_AX_BCN_CTN_AREA_P0_SH 0
#define B_AX_BCN_CTN_AREA_P0_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P0 0xC40C
#define R_AX_BCNERLYINT_CFG_P0_C1 0xE40C
#define B_AX_BCNERLY_P0_SH 0
#define B_AX_BCNERLY_P0_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P0 0xC40E
#define R_AX_TBTTERLYINT_CFG_P0_C1 0xE40E
#define B_AX_TBTTERLY_P0_SH 0
#define B_AX_TBTTERLY_P0_MSK 0xfff

#define R_AX_TBTT_AGG_P0 0xC412
#define R_AX_TBTT_AGG_P0_C1 0xE412
#define B_AX_TBTT_AGG_NUM_P0_SH 8
#define B_AX_TBTT_AGG_NUM_P0_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P0 0xC414
#define R_AX_BCN_SPACE_CFG_P0_C1 0xE414
#define B_AX_SUB_BCN_SPACE_P0_SH 16
#define B_AX_SUB_BCN_SPACE_P0_MSK 0xff
#define B_AX_BCN_SPACE_P0_SH 0
#define B_AX_BCN_SPACE_P0_MSK 0xffff

#define R_AX_BCN_FORCETX_P0 0xC418
#define R_AX_BCN_FORCETX_P0_C1 0xE418
#define B_AX_FORCE_BCN_CURRCNT_P0_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P0_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P0_SH 8
#define B_AX_FORCE_BCN_NUM_P0_MSK 0xff
#define B_AX_BCN_MAX_ERR_P0_SH 0
#define B_AX_BCN_MAX_ERR_P0_MSK 0xff

#define R_AX_BCN_ERR_CNT_P0 0xC420
#define R_AX_BCN_ERR_CNT_P0_C1 0xE420
#define B_AX_BCN_ERR_CNT_SUM_P0_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P0_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P0_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P0_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P0_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P0 0xC424
#define R_AX_BCN_ERR_FLAG_P0_C1 0xE424
#define B_AX_BCN_ERR_FLAG_OTHERS_P0 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P0 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P0 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P0 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P0 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P0 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P0 BIT(0)

#define R_AX_DTIM_CTRL_P0 0xC426
#define R_AX_DTIM_CTRL_P0_C1 0xE426
#define B_AX_DTIM_NUM_P0_SH 8
#define B_AX_DTIM_NUM_P0_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0_SH 0
#define B_AX_DTIM_CURRCNT_P0_MSK 0xff

#define R_AX_TBTT_SHIFT_P0 0xC428
#define R_AX_TBTT_SHIFT_P0_C1 0xE428
#define B_AX_TBTT_SHIFT_OFST_P0_SH 0
#define B_AX_TBTT_SHIFT_OFST_P0_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P0 0xC434
#define R_AX_BCN_CNT_TMR_P0_C1 0xE434
#define B_AX_BCN_CNT_TMR_P0_SH 0
#define B_AX_BCN_CNT_TMR_P0_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P0 0xC438
#define R_AX_TSFTR_LOW_P0_C1 0xE438
#define B_AX_TSFTR_LOW_P0_SH 0
#define B_AX_TSFTR_LOW_P0_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P0 0xC43C
#define R_AX_TSFTR_HIGH_P0_C1 0xE43C
#define B_AX_TSFTR_HIGH_P0_SH 0
#define B_AX_TSFTR_HIGH_P0_MSK 0xffffffffL

#define R_AX_PORT_CFG_P1 0xC440
#define R_AX_PORT_CFG_P1_C1 0xE440
#define B_AX_PROHIB_END_CAL_EN_P1 BIT(17)
#define B_AX_BRK_SETUP_P1 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P1 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P1 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P1 BIT(13)
#define B_AX_BCNTX_EN_P1 BIT(12)
#define B_AX_NET_TYPE_P1_SH 10
#define B_AX_NET_TYPE_P1_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P1 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P1 BIT(8)
#define B_AX_BCNERR_CNT_EN_P1 BIT(7)
#define B_AX_BCN_AGRES_P1 BIT(6)
#define B_AX_TSFTR_RST_P1 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P1 BIT(4)
#define B_AX_TSF_UDT_EN_P1 BIT(3)
#define B_AX_PORT_FUNC_EN_P1 BIT(2)
#define B_AX_TXBCN_RPT_EN_P1 BIT(1)
#define B_AX_RXBCN_RPT_EN_P1 BIT(0)

#define R_AX_TBTT_PROHIB_P1 0xC444
#define R_AX_TBTT_PROHIB_P1_C1 0xE444
#define B_AX_TBTT_HOLD_P1_SH 16
#define B_AX_TBTT_HOLD_P1_MSK 0xfff
#define B_AX_TBTT_SETUP_P1_SH 0
#define B_AX_TBTT_SETUP_P1_MSK 0xff

#define R_AX_BCN_AREA_P1 0xC448
#define R_AX_BCN_AREA_P1_C1 0xE448
#define B_AX_BCN_MSK_AREA_P1_SH 16
#define B_AX_BCN_MSK_AREA_P1_MSK 0xfff
#define B_AX_BCN_CTN_AREA_P1_SH 0
#define B_AX_BCN_CTN_AREA_P1_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P1 0xC44C
#define R_AX_BCNERLYINT_CFG_P1_C1 0xE44C
#define B_AX_BCNERLY_P1_SH 0
#define B_AX_BCNERLY_P1_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P1 0xC44E
#define R_AX_TBTTERLYINT_CFG_P1_C1 0xE44E
#define B_AX_TBTTERLY_P1_SH 0
#define B_AX_TBTTERLY_P1_MSK 0xfff

#define R_AX_TBTT_AGG_P1 0xC452
#define R_AX_TBTT_AGG_P1_C1 0xE452
#define B_AX_TBTT_AGG_NUM_P1_SH 8
#define B_AX_TBTT_AGG_NUM_P1_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P1 0xC454
#define R_AX_BCN_SPACE_CFG_P1_C1 0xE454
#define B_AX_BCN_SPACE_P1_SH 0
#define B_AX_BCN_SPACE_P1_MSK 0xffff

#define R_AX_BCN_FORCETX_P1 0xC458
#define R_AX_BCN_FORCETX_P1_C1 0xE458
#define B_AX_FORCE_BCN_CURRCNT_P1_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P1_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P1_SH 8
#define B_AX_FORCE_BCN_NUM_P1_MSK 0xff
#define B_AX_BCN_MAX_ERR_P1_SH 0
#define B_AX_BCN_MAX_ERR_P1_MSK 0xff

#define R_AX_BCN_ERR_CNT_P1 0xC460
#define R_AX_BCN_ERR_CNT_P1_C1 0xE460
#define B_AX_BCN_ERR_CNT_SUM_P1_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P1_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P1_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P1_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P1_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P1 0xC464
#define R_AX_BCN_ERR_FLAG_P1_C1 0xE464
#define B_AX_BCN_ERR_FLAG_OTHERS_P1 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P1 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P1 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P1 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P1 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P1 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P1 BIT(0)

#define R_AX_DTIM_CTRL_P1 0xC466
#define R_AX_DTIM_CTRL_P1_C1 0xE466
#define B_AX_DTIM_NUM_P1_SH 8
#define B_AX_DTIM_NUM_P1_MSK 0xff
#define B_AX_DTIM_CURRCNT_P1_SH 0
#define B_AX_DTIM_CURRCNT_P1_MSK 0xff

#define R_AX_TBTT_SHIFT_P1 0xC468
#define R_AX_TBTT_SHIFT_P1_C1 0xE468
#define B_AX_TBTT_SHIFT_OFST_P1_SH 0
#define B_AX_TBTT_SHIFT_OFST_P1_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P1 0xC474
#define R_AX_BCN_CNT_TMR_P1_C1 0xE474
#define B_AX_BCN_CNT_TMR_P1_SH 0
#define B_AX_BCN_CNT_TMR_P1_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P1 0xC478
#define R_AX_TSFTR_LOW_P1_C1 0xE478
#define B_AX_TSFTR_LOW_P1_SH 0
#define B_AX_TSFTR_LOW_P1_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P1 0xC47C
#define R_AX_TSFTR_HIGH_P1_C1 0xE47C
#define B_AX_TSFTR_HIGH_P1_SH 0
#define B_AX_TSFTR_HIGH_P1_MSK 0xffffffffL

#define R_AX_PORT_CFG_P2 0xC480
#define R_AX_PORT_CFG_P2_C1 0xE480
#define B_AX_PROHIB_END_CAL_EN_P2 BIT(17)
#define B_AX_BRK_SETUP_P2 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P2 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P2 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P2 BIT(13)
#define B_AX_BCNTX_EN_P2 BIT(12)
#define B_AX_NET_TYPE_P2_SH 10
#define B_AX_NET_TYPE_P2_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P2 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P2 BIT(8)
#define B_AX_BCNERR_CNT_EN_P2 BIT(7)
#define B_AX_BCN_AGRES_P2 BIT(6)
#define B_AX_TSFTR_RST_P2 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P2 BIT(4)
#define B_AX_TSF_UDT_EN_P2 BIT(3)
#define B_AX_PORT_FUNC_EN_P2 BIT(2)
#define B_AX_TXBCN_RPT_EN_P2 BIT(1)
#define B_AX_RXBCN_RPT_EN_P2 BIT(0)

#define R_AX_BCN_AREA_P2 0xC488
#define R_AX_BCN_AREA_P2_C1 0xE488
#define B_AX_BCN_MSK_AREA_P2_SH 16
#define B_AX_BCN_MSK_AREA_P2_MSK 0xfff
#define B_AX_BCN_CTN_AREA_P2_SH 0
#define B_AX_BCN_CTN_AREA_P2_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P2 0xC48C
#define R_AX_BCNERLYINT_CFG_P2_C1 0xE48C
#define B_AX_BCNERLY_P2_SH 0
#define B_AX_BCNERLY_P2_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P2 0xC48E
#define R_AX_TBTTERLYINT_CFG_P2_C1 0xE48E
#define B_AX_TBTTERLY_P2_SH 0
#define B_AX_TBTTERLY_P2_MSK 0xfff

#define R_AX_TBTT_AGG_P2 0xC492
#define R_AX_TBTT_AGG_P2_C1 0xE492
#define B_AX_TBTT_AGG_NUM_P2_SH 8
#define B_AX_TBTT_AGG_NUM_P2_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P2 0xC494
#define R_AX_BCN_SPACE_CFG_P2_C1 0xE494
#define B_AX_BCN_SPACE_P2_SH 0
#define B_AX_BCN_SPACE_P2_MSK 0xffff

#define R_AX_BCN_FORCETX_P2 0xC498
#define R_AX_BCN_FORCETX_P2_C1 0xE498
#define B_AX_FORCE_BCN_CURRCNT_P2_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P2_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P2_SH 8
#define B_AX_FORCE_BCN_NUM_P2_MSK 0xff
#define B_AX_BCN_MAX_ERR_P2_SH 0
#define B_AX_BCN_MAX_ERR_P2_MSK 0xff

#define R_AX_BCN_ERR_CNT_P2 0xC4A0
#define R_AX_BCN_ERR_CNT_P2_C1 0xE4A0
#define B_AX_BCN_ERR_CNT_SUM_P2_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P2_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P2_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P2_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P2_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P2 0xC4A4
#define R_AX_BCN_ERR_FLAG_P2_C1 0xE4A4
#define B_AX_BCN_ERR_FLAG_OTHERS_P2 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P2 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P2 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P2 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P2 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P2 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P2 BIT(0)

#define R_AX_DTIM_CTRL_P2 0xC4A6
#define R_AX_DTIM_CTRL_P2_C1 0xE4A6
#define B_AX_DTIM_NUM_P2_SH 8
#define B_AX_DTIM_NUM_P2_MSK 0xff
#define B_AX_DTIM_CURRCNT_P2_SH 0
#define B_AX_DTIM_CURRCNT_P2_MSK 0xff

#define R_AX_TBTT_SHIFT_P2 0xC4A8
#define R_AX_TBTT_SHIFT_P2_C1 0xE4A8
#define B_AX_TBTT_SHIFT_OFST_P2_SH 0
#define B_AX_TBTT_SHIFT_OFST_P2_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P2 0xC4B4
#define R_AX_BCN_CNT_TMR_P2_C1 0xE4B4
#define B_AX_BCN_CNT_TMR_P2_SH 0
#define B_AX_BCN_CNT_TMR_P2_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P2 0xC4B8
#define R_AX_TSFTR_LOW_P2_C1 0xE4B8
#define B_AX_TSFTR_LOW_P2_SH 0
#define B_AX_TSFTR_LOW_P2_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P2 0xC4BC
#define R_AX_TSFTR_HIGH_P2_C1 0xE4BC
#define B_AX_TSFTR_HIGH_P2_SH 0
#define B_AX_TSFTR_HIGH_P2_MSK 0xffffffffL

#define R_AX_PORT_CFG_P3 0xC4C0
#define R_AX_PORT_CFG_P3_C1 0xE4C0
#define B_AX_PROHIB_END_CAL_EN_P3 BIT(17)
#define B_AX_BRK_SETUP_P3 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P3 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P3 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P3 BIT(13)
#define B_AX_BCNTX_EN_P3 BIT(12)
#define B_AX_NET_TYPE_P3_SH 10
#define B_AX_NET_TYPE_P3_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P3 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P3 BIT(8)
#define B_AX_BCNERR_CNT_EN_P3 BIT(7)
#define B_AX_BCN_AGRES_P3 BIT(6)
#define B_AX_TSFTR_RST_P3 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P3 BIT(4)
#define B_AX_TSF_UDT_EN_P3 BIT(3)
#define B_AX_PORT_FUNC_EN_P3 BIT(2)
#define B_AX_TXBCN_RPT_EN_P3 BIT(1)
#define B_AX_RXBCN_RPT_EN_P3 BIT(0)

#define R_AX_BCN_AREA_P3 0xC4C8
#define R_AX_BCN_AREA_P3_C1 0xE4C8
#define B_AX_BCN_MSK_AREA_P3_SH 16
#define B_AX_BCN_MSK_AREA_P3_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P3 0xC4CC
#define R_AX_BCNERLYINT_CFG_P3_C1 0xE4CC
#define B_AX_BCNERLY_P3_SH 0
#define B_AX_BCNERLY_P3_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P3 0xC4CE
#define R_AX_TBTTERLYINT_CFG_P3_C1 0xE4CE
#define B_AX_TBTTERLY_P3_SH 0
#define B_AX_TBTTERLY_P3_MSK 0xfff

#define R_AX_TBTT_AGG_P3 0xC4D2
#define R_AX_TBTT_AGG_P3_C1 0xE4D2
#define B_AX_TBTT_AGG_NUM_P3_SH 8
#define B_AX_TBTT_AGG_NUM_P3_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P3 0xC4D4
#define R_AX_BCN_SPACE_CFG_P3_C1 0xE4D4
#define B_AX_BCN_SPACE_P3_SH 0
#define B_AX_BCN_SPACE_P3_MSK 0xffff

#define R_AX_BCN_FORCETX_P3 0xC4D8
#define R_AX_BCN_FORCETX_P3_C1 0xE4D8
#define B_AX_FORCE_BCN_CURRCNT_P3_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P3_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P3_SH 8
#define B_AX_FORCE_BCN_NUM_P3_MSK 0xff
#define B_AX_BCN_MAX_ERR_P3_SH 0
#define B_AX_BCN_MAX_ERR_P3_MSK 0xff

#define R_AX_BCN_ERR_CNT_P3 0xC4E0
#define R_AX_BCN_ERR_CNT_P3_C1 0xE4E0
#define B_AX_BCN_ERR_CNT_SUM_P3_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P3_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P3_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P3_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P3_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P3 0xC4E4
#define R_AX_BCN_ERR_FLAG_P3_C1 0xE4E4
#define B_AX_BCN_ERR_FLAG_OTHERS_P3 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P3 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P3 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P3 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P3 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P3 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P3 BIT(0)

#define R_AX_DTIM_CTRL_P3 0xC4E6
#define R_AX_DTIM_CTRL_P3_C1 0xE4E6
#define B_AX_DTIM_NUM_P3_SH 8
#define B_AX_DTIM_NUM_P3_MSK 0xff
#define B_AX_DTIM_CURRCNT_P3_SH 0
#define B_AX_DTIM_CURRCNT_P3_MSK 0xff

#define R_AX_TBTT_SHIFT_P3 0xC4E8
#define R_AX_TBTT_SHIFT_P3_C1 0xE4E8
#define B_AX_TBTT_SHIFT_OFST_P3_SH 0
#define B_AX_TBTT_SHIFT_OFST_P3_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P3 0xC4F4
#define R_AX_BCN_CNT_TMR_P3_C1 0xE4F4
#define B_AX_BCN_CNT_TMR_P3_SH 0
#define B_AX_BCN_CNT_TMR_P3_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P3 0xC4F8
#define R_AX_TSFTR_LOW_P3_C1 0xE4F8
#define B_AX_TSFTR_LOW_P3_SH 0
#define B_AX_TSFTR_LOW_P3_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P3 0xC4FC
#define R_AX_TSFTR_HIGH_P3_C1 0xE4FC
#define B_AX_TSFTR_HIGH_P3_SH 0
#define B_AX_TSFTR_HIGH_P3_MSK 0xffffffffL

#define R_AX_PORT_CFG_P4 0xC500
#define R_AX_PORT_CFG_P4_C1 0xE500
#define B_AX_PROHIB_END_CAL_EN_P4 BIT(17)
#define B_AX_BRK_SETUP_P4 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P4 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P4 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P4 BIT(13)
#define B_AX_BCNTX_EN_P4 BIT(12)
#define B_AX_NET_TYPE_P4_SH 10
#define B_AX_NET_TYPE_P4_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P4 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P4 BIT(8)
#define B_AX_BCNERR_CNT_EN_P4 BIT(7)
#define B_AX_BCN_AGRES_P4 BIT(6)
#define B_AX_TSFTR_RST_P4 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P4 BIT(4)
#define B_AX_TSF_UDT_EN_P4 BIT(3)
#define B_AX_PORT_FUNC_EN_P4 BIT(2)
#define B_AX_TXBCN_RPT_EN_P4 BIT(1)
#define B_AX_RXBCN_RPT_EN_P4 BIT(0)

#define R_AX_BCN_AREA_P4 0xC508
#define R_AX_BCN_AREA_P4_C1 0xE508
#define B_AX_BCN_MSK_AREA_P4_SH 16
#define B_AX_BCN_MSK_AREA_P4_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P4 0xC50C
#define R_AX_BCNERLYINT_CFG_P4_C1 0xE50C
#define B_AX_BCNERLY_P4_SH 0
#define B_AX_BCNERLY_P4_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P4 0xC50E
#define R_AX_TBTTERLYINT_CFG_P4_C1 0xE50E
#define B_AX_TBTTERLY_P4_SH 0
#define B_AX_TBTTERLY_P4_MSK 0xfff

#define R_AX_TBTT_AGG_P4 0xC512
#define R_AX_TBTT_AGG_P4_C1 0xE512
#define B_AX_TBTT_AGG_NUM_P4_SH 8
#define B_AX_TBTT_AGG_NUM_P4_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P4 0xC514
#define R_AX_BCN_SPACE_CFG_P4_C1 0xE514
#define B_AX_BCN_SPACE_P4_SH 0
#define B_AX_BCN_SPACE_P4_MSK 0xffff

#define R_AX_BCN_FORCETX_P4 0xC518
#define R_AX_BCN_FORCETX_P4_C1 0xE518
#define B_AX_FORCE_BCN_CURRCNT_P4_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P4_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P4_SH 8
#define B_AX_FORCE_BCN_NUM_P4_MSK 0xff
#define B_AX_BCN_MAX_ERR_P4_SH 0
#define B_AX_BCN_MAX_ERR_P4_MSK 0xff

#define R_AX_BCN_ERR_CNT_P4 0xC520
#define R_AX_BCN_ERR_CNT_P4_C1 0xE520
#define B_AX_BCN_ERR_CNT_SUM_P4_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P4_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P4_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P4_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P4_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P4 0xC524
#define R_AX_BCN_ERR_FLAG_P4_C1 0xE524
#define B_AX_BCN_ERR_FLAG_OTHERS_P4 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P4 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P4 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P4 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P4 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P4 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P4 BIT(0)

#define R_AX_DTIM_CTRL_P4 0xC526
#define R_AX_DTIM_CTRL_P4_C1 0xE526
#define B_AX_DTIM_NUM_P4_SH 8
#define B_AX_DTIM_NUM_P4_MSK 0xff
#define B_AX_DTIM_CURRCNT_P4_SH 0
#define B_AX_DTIM_CURRCNT_P4_MSK 0xff

#define R_AX_TBTT_SHIFT_P4 0xC528
#define R_AX_TBTT_SHIFT_P4_C1 0xE528
#define B_AX_TBTT_SHIFT_OFST_P4_SH 0
#define B_AX_TBTT_SHIFT_OFST_P4_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P4 0xC534
#define R_AX_BCN_CNT_TMR_P4_C1 0xE534
#define B_AX_BCN_CNT_TMR_P4_SH 0
#define B_AX_BCN_CNT_TMR_P4_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P4 0xC538
#define R_AX_TSFTR_LOW_P4_C1 0xE538
#define B_AX_TSFTR_LOW_P4_SH 0
#define B_AX_TSFTR_LOW_P4_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P4 0xC53C
#define R_AX_TSFTR_HIGH_P4_C1 0xE53C
#define B_AX_TSFTR_HIGH_P4_SH 0
#define B_AX_TSFTR_HIGH_P4_MSK 0xffffffffL

#define R_AX_DTIM_NUM0 0xC540
#define R_AX_DTIM_NUM0_C1 0xE540
#define B_AX_DTIM_NUM_P0MB3_SH 24
#define B_AX_DTIM_NUM_P0MB3_MSK 0xff
#define B_AX_DTIM_NUM_P0MB2_SH 16
#define B_AX_DTIM_NUM_P0MB2_MSK 0xff
#define B_AX_DTIM_NUM_P0MB1_SH 8
#define B_AX_DTIM_NUM_P0MB1_MSK 0xff

#define R_AX_DTIM_NUM1 0xC544
#define R_AX_DTIM_NUM1_C1 0xE544
#define B_AX_DTIM_NUM_P0MB7_SH 24
#define B_AX_DTIM_NUM_P0MB7_MSK 0xff
#define B_AX_DTIM_NUM_P0MB6_SH 16
#define B_AX_DTIM_NUM_P0MB6_MSK 0xff
#define B_AX_DTIM_NUM_P0MB5_SH 8
#define B_AX_DTIM_NUM_P0MB5_MSK 0xff
#define B_AX_DTIM_NUM_P0MB4_SH 0
#define B_AX_DTIM_NUM_P0MB4_MSK 0xff

#define R_AX_DTIM_NUM2 0xC548
#define R_AX_DTIM_NUM2_C1 0xE548
#define B_AX_DTIM_NUM_P0MB11_SH 24
#define B_AX_DTIM_NUM_P0MB11_MSK 0xff
#define B_AX_DTIM_NUM_P0MB10_SH 16
#define B_AX_DTIM_NUM_P0MB10_MSK 0xff
#define B_AX_DTIM_NUM_P0MB9_SH 8
#define B_AX_DTIM_NUM_P0MB9_MSK 0xff
#define B_AX_DTIM_NUM_P0MB8_SH 0
#define B_AX_DTIM_NUM_P0MB8_MSK 0xff

#define R_AX_DTIM_NUM3 0xC54C
#define R_AX_DTIM_NUM3_C1 0xE54C
#define B_AX_DTIM_NUM_P0MB15_SH 24
#define B_AX_DTIM_NUM_P0MB15_MSK 0xff
#define B_AX_DTIM_NUM_P0MB14_SH 16
#define B_AX_DTIM_NUM_P0MB14_MSK 0xff
#define B_AX_DTIM_NUM_P0MB13_SH 8
#define B_AX_DTIM_NUM_P0MB13_MSK 0xff
#define B_AX_DTIM_NUM_P0MB12_SH 0
#define B_AX_DTIM_NUM_P0MB12_MSK 0xff

#define R_AX_DTIM_CURRCNT0 0xC550
#define R_AX_DTIM_CURRCNT0_C1 0xE550
#define B_AX_DTIM_CURRCNT_P0MB3_SH 24
#define B_AX_DTIM_CURRCNT_P0MB3_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB2_SH 16
#define B_AX_DTIM_CURRCNT_P0MB2_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB1_SH 8
#define B_AX_DTIM_CURRCNT_P0MB1_MSK 0xff

#define R_AX_DTIM_CURRCNT1 0xC554
#define R_AX_DTIM_CURRCNT1_C1 0xE554
#define B_AX_DTIM_CURRCNT_P0MB7_SH 24
#define B_AX_DTIM_CURRCNT_P0MB7_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB6_SH 16
#define B_AX_DTIM_CURRCNT_P0MB6_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB5_SH 8
#define B_AX_DTIM_CURRCNT_P0MB5_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB4_SH 0
#define B_AX_DTIM_CURRCNT_P0MB4_MSK 0xff

#define R_AX_DTIM_CURRCNT2 0xC558
#define R_AX_DTIM_CURRCNT2_C1 0xE558
#define B_AX_DTIM_CURRCNT_P0MB11_SH 24
#define B_AX_DTIM_CURRCNT_P0MB11_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB10_SH 16
#define B_AX_DTIM_CURRCNT_P0MB10_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB9_SH 8
#define B_AX_DTIM_CURRCNT_P0MB9_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB8_SH 0
#define B_AX_DTIM_CURRCNT_P0MB8_MSK 0xff

#define R_AX_DTIM_CURRCNT3 0xC55C
#define R_AX_DTIM_CURRCNT3_C1 0xE55C
#define B_AX_DTIM_CURRCNT_P0MB15_SH 24
#define B_AX_DTIM_CURRCNT_P0MB15_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB14_SH 16
#define B_AX_DTIM_CURRCNT_P0MB14_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB13_SH 8
#define B_AX_DTIM_CURRCNT_P0MB13_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB12_SH 0
#define B_AX_DTIM_CURRCNT_P0MB12_MSK 0xff

#define R_AX_BCN_DROP_ALL0 0xC560
#define R_AX_BCN_DROP_ALL0_C1 0xE560
#define B_AX_BCN_DROP_ALL_P4 BIT(4)
#define B_AX_BCN_DROP_ALL_P3 BIT(3)
#define B_AX_BCN_DROP_ALL_P2 BIT(2)
#define B_AX_BCN_DROP_ALL_P1 BIT(1)
#define B_AX_BCN_DROP_ALL_P0 BIT(0)

#define R_AX_BCN_DROP_ALL0_P0MB 0xC564
#define R_AX_BCN_DROP_ALL0_P0MB_C1 0xE564
#define B_AX_BCN_DROP_ALL_P0MB15 BIT(15)
#define B_AX_BCN_DROP_ALL_P0MB14 BIT(14)
#define B_AX_BCN_DROP_ALL_P0MB13 BIT(13)
#define B_AX_BCN_DROP_ALL_P0MB12 BIT(12)
#define B_AX_BCN_DROP_ALL_P0MB11 BIT(11)
#define B_AX_BCN_DROP_ALL_P0MB10 BIT(10)
#define B_AX_BCN_DROP_ALL_P0MB9 BIT(9)
#define B_AX_BCN_DROP_ALL_P0MB8 BIT(8)
#define B_AX_BCN_DROP_ALL_P0MB7 BIT(7)
#define B_AX_BCN_DROP_ALL_P0MB6 BIT(6)
#define B_AX_BCN_DROP_ALL_P0MB5 BIT(5)
#define B_AX_BCN_DROP_ALL_P0MB4 BIT(4)
#define B_AX_BCN_DROP_ALL_P0MB3 BIT(3)
#define B_AX_BCN_DROP_ALL_P0MB2 BIT(2)
#define B_AX_BCN_DROP_ALL_P0MB1 BIT(1)

#define R_AX_MBSSID_CTRL 0xC568
#define R_AX_MBSSID_CTRL_C1 0xE568
#define B_AX_P0MB_NUM_SH 16
#define B_AX_P0MB_NUM_MSK 0xf
#define B_AX_P0MB15_EN BIT(15)
#define B_AX_P0MB14_EN BIT(14)
#define B_AX_P0MB13_EN BIT(13)
#define B_AX_P0MB12_EN BIT(12)
#define B_AX_P0MB11_EN BIT(11)
#define B_AX_P0MB10_EN BIT(10)
#define B_AX_P0MB9_EN BIT(9)
#define B_AX_P0MB8_EN BIT(8)
#define B_AX_P0MB7_EN BIT(7)
#define B_AX_P0MB6_EN BIT(6)
#define B_AX_P0MB5_EN BIT(5)
#define B_AX_P0MB4_EN BIT(4)
#define B_AX_P0MB3_EN BIT(3)
#define B_AX_P0MB2_EN BIT(2)
#define B_AX_P0MB1_EN BIT(1)

#define R_AX_RXTSF_OFST 0xC570
#define R_AX_RXTSF_OFST_C1 0xE570
#define B_AX_RXTSF_OFST_OFDM_SH 8
#define B_AX_RXTSF_OFST_OFDM_MSK 0xff
#define B_AX_RXTSF_OFST_CCK_SH 0
#define B_AX_RXTSF_OFST_CCK_MSK 0xff

#define R_AX_RXBCN_TIME_CTRL 0xC574
#define R_AX_RXBCN_TIME_CTRL_C1 0xE574
#define B_AX_RXBCN_TIME_PORT_SH 28
#define B_AX_RXBCN_TIME_PORT_MSK 0x7
#define B_AX_RXBCN_TIME_VLD BIT(17)
#define B_AX_RXBCN_TIME_UDFW BIT(16)
#define B_AX_RXBCN_TIME_DIFF_SH 0
#define B_AX_RXBCN_TIME_DIFF_MSK 0xffff

#define R_AX_RXBCN_TIME_SYNC 0xC578
#define R_AX_RXBCN_TIME_SYNC_C1 0xE578
#define B_AX_RXBCN_TIME_SYNC_SH 0
#define B_AX_RXBCN_TIME_SYNC_MSK 0xffffffffL

#define R_AX_TBTT_TSF_INFO 0xC57C
#define R_AX_TBTT_TSF_INFO_C1 0xE57C
#define B_AX_TBTT_TSF_INFO_SH 0
#define B_AX_TBTT_TSF_INFO_MSK 0xffffffffL

#define R_AX_P0MB_HGQ_WINDOW_CFG_0 0xC590
#define R_AX_P0MB_HGQ_WINDOW_CFG_0_C1 0xE590
#define B_AX_HGQWND_3_SH 24
#define B_AX_HGQWND_3_MSK 0xff
#define B_AX_HGQWND_2_SH 16
#define B_AX_HGQWND_2_MSK 0xff
#define B_AX_HGQWND_1_SH 8
#define B_AX_HGQWND_1_MSK 0xff
#define B_AX_HGQWND_0_SH 0
#define B_AX_HGQWND_0_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_1 0xC594
#define R_AX_P0MB_HGQ_WINDOW_CFG_1_C1 0xE594
#define B_AX_HGQWND_7_SH 24
#define B_AX_HGQWND_7_MSK 0xff
#define B_AX_HGQWND_6_SH 16
#define B_AX_HGQWND_6_MSK 0xff
#define B_AX_HGQWND_5_SH 8
#define B_AX_HGQWND_5_MSK 0xff
#define B_AX_HGQWND_4_SH 0
#define B_AX_HGQWND_4_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_2 0xC598
#define R_AX_P0MB_HGQ_WINDOW_CFG_2_C1 0xE598
#define B_AX_HGQWND_11_SH 24
#define B_AX_HGQWND_11_MSK 0xff
#define B_AX_HGQWND_10_SH 16
#define B_AX_HGQWND_10_MSK 0xff
#define B_AX_HGQWND_9_SH 8
#define B_AX_HGQWND_9_MSK 0xff
#define B_AX_HGQWND_8_SH 0
#define B_AX_HGQWND_8_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_3 0xC59C
#define R_AX_P0MB_HGQ_WINDOW_CFG_3_C1 0xE59C
#define B_AX_HGQWND_15_SH 24
#define B_AX_HGQWND_15_MSK 0xff
#define B_AX_HGQWND_14_SH 16
#define B_AX_HGQWND_14_MSK 0xff
#define B_AX_HGQWND_13_SH 8
#define B_AX_HGQWND_13_MSK 0xff
#define B_AX_HGQWND_12_SH 0
#define B_AX_HGQWND_12_MSK 0xff

#define R_AX_PORT_HGQ_WINDOW_CFG 0xC5A0
#define R_AX_PORT_HGQ_WINDOW_CFG_C1 0xE5A0
#define B_AX_HGQWND_19_SH 24
#define B_AX_HGQWND_19_MSK 0xff
#define B_AX_HGQWND_18_SH 16
#define B_AX_HGQWND_18_MSK 0xff
#define B_AX_HGQWND_17_SH 8
#define B_AX_HGQWND_17_MSK 0xff
#define B_AX_HGQWND_16_SH 0
#define B_AX_HGQWND_16_MSK 0xff

#define R_AX_EN_HGQ_NOLIMIT 0xC5A4
#define R_AX_EN_HGQ_NOLIMIT_C1 0xE5A4
#define B_AX_HIQ_NO_LMT_EN_P4 BIT(19)
#define B_AX_HIQ_NO_LMT_EN_P3 BIT(18)
#define B_AX_HIQ_NO_LMT_EN_P2 BIT(17)
#define B_AX_HIQ_NO_LMT_EN_P1 BIT(16)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP15 BIT(15)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP14 BIT(14)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP13 BIT(13)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP12 BIT(12)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP11 BIT(11)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP10 BIT(10)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP9 BIT(9)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP8 BIT(8)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP7 BIT(7)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP6 BIT(6)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP5 BIT(5)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP4 BIT(4)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP3 BIT(3)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP2 BIT(2)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP1 BIT(1)
#define B_AX_HIQ_NO_LMT_EN_P0_ROOT BIT(0)

#define R_AX_LPS_RX_PERIOD_CTRL 0xC5B8
#define R_AX_LPS_RX_PERIOD_CTRL_C1 0xE5B8
#define B_AX_RXBCN_PERIOD_SH 16
#define B_AX_RXBCN_PERIOD_MSK 0xff
#define B_AX_CAT_PERIOD_SH 8
#define B_AX_CAT_PERIOD_MSK 0xff
#define B_AX_LPS_RX_CTRL_EN BIT(3)
#define B_AX_LPS_PORT_SEL_SH 0
#define B_AX_LPS_PORT_SEL_MSK 0x7

#define R_AX_LPS_BCN_CNT 0xC5BC
#define R_AX_LPS_BCN_CNT_C1 0xE5BC
#define B_AX_BCN_TO_ACC_CNT_SH 24
#define B_AX_BCN_TO_ACC_CNT_MSK 0xff
#define B_AX_BCN_OK_ACC_CNT_SH 16
#define B_AX_BCN_OK_ACC_CNT_MSK 0xff
#define B_AX_BCN_TO_CNT_THD_SH 8
#define B_AX_BCN_TO_CNT_THD_MSK 0xff
#define B_AX_BCN_TO_CNT_SH 0
#define B_AX_BCN_TO_CNT_MSK 0xff

#define R_AX_FREERUN_CNT_LOW 0xC5C0
#define R_AX_FREERUN_CNT_LOW_C1 0xE5C0
#define B_AX_FREERUN_CNT_LOW_SH 0
#define B_AX_FREERUN_CNT_LOW_MSK 0xffffffffL

#define R_AX_FREERUN_CNT_HIGH 0xC5C4
#define R_AX_FREERUN_CNT_HIGH_C1 0xE5C4
#define B_AX_FREERUN_CNT_HIGH_SH 0
#define B_AX_FREERUN_CNT_HIGH_MSK 0xffffffffL

#define R_AX_PSTIMER0 0xC5CC
#define R_AX_PSTIMER0_C1 0xE5CC
#define B_AX_PSTIMER0_VAL_SH 0
#define B_AX_PSTIMER0_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER1 0xC5D0
#define R_AX_PSTIMER1_C1 0xE5D0
#define B_AX_PSTIMER1_VAL_SH 0
#define B_AX_PSTIMER1_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER2 0xC5D4
#define R_AX_PSTIMER2_C1 0xE5D4
#define B_AX_PSTIMER2_VAL_SH 0
#define B_AX_PSTIMER2_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER3 0xC5D8
#define R_AX_PSTIMER3_C1 0xE5D8
#define B_AX_PSTIMER3_VAL_SH 0
#define B_AX_PSTIMER3_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER4 0xC5DC
#define R_AX_PSTIMER4_C1 0xE5DC
#define B_AX_PSTIMER4_VAL_SH 0
#define B_AX_PSTIMER4_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER5 0xC5E0
#define R_AX_PSTIMER5_C1 0xE5E0
#define B_AX_PSTIMER5_VAL_SH 0
#define B_AX_PSTIMER5_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER_CTRL 0xC5E4
#define R_AX_PSTIMER_CTRL_C1 0xE5E4
#define B_AX_PSTIMER5_EN BIT(23)
#define B_AX_PSTIMER5_SEL_SH 20
#define B_AX_PSTIMER5_SEL_MSK 0x7
#define B_AX_PSTIMER4_EN BIT(19)
#define B_AX_PSTIMER4_SEL_SH 16
#define B_AX_PSTIMER4_SEL_MSK 0x7
#define B_AX_PSTIMER3_EN BIT(15)
#define B_AX_PSTIMER3_SEL_SH 12
#define B_AX_PSTIMER3_SEL_MSK 0x7
#define B_AX_PSTIMER2_EN BIT(11)
#define B_AX_PSTIMER2_SEL_SH 8
#define B_AX_PSTIMER2_SEL_MSK 0x7
#define B_AX_PSTIMER1_EN BIT(7)
#define B_AX_PSTIMER1_SEL_SH 4
#define B_AX_PSTIMER1_SEL_MSK 0x7
#define B_AX_PSTIMER0_EN BIT(3)
#define B_AX_PSTIMER0_SEL_SH 0
#define B_AX_PSTIMER0_SEL_MSK 0x7

#define R_AX_TIMER_COMPARE 0xC5E8
#define R_AX_TIMER_COMPARE_C1 0xE5E8
#define B_AX_X_COMP_Y_TSFT_P BIT(7)
#define B_AX_Y_COMP_SEL_SH 4
#define B_AX_Y_COMP_SEL_MSK 0x7
#define B_AX_X_COMP_Y_OVER BIT(3)
#define B_AX_X_COMP_SEL_SH 0
#define B_AX_X_COMP_SEL_MSK 0x7

#define R_AX_TIMER_COMPARE_VALUE_LOW 0xC5EC
#define R_AX_TIMER_COMPARE_VALUE_LOW_C1 0xE5EC
#define B_AX_X_COMP_Y_VAL_LOW_SH 0
#define B_AX_X_COMP_Y_VAL_LOW_MSK 0xffffffffL

#define R_AX_TIMER_COMPARE_VALUE_HIGH 0xC5F0
#define R_AX_TIMER_COMPARE_VALUE_HIGH_C1 0xE5F0
#define B_AX_X_COMP_Y_VAL_HIGH_SH 0
#define B_AX_X_COMP_Y_VAL_HIGH_MSK 0xffffffffL

//
// PTCL
//

#define R_AX_PTCL_COMMON_SETTING_0 0xC600
#define R_AX_PTCL_COMMON_SETTING_0_C1 0xE600
#define B_AX_PCIE_MODE_SH 14
#define B_AX_PCIE_MODE_MSK 0x3
#define B_AX_CPUMGQ_LIFETIME_EN BIT(8)
#define B_AX_MGQ_LIFETIME_EN BIT(7)
#define B_AX_LIFETIME_EN BIT(6)
#define B_AX_PTCL_TRIGGER_SS_EN_UL BIT(4)
#define B_AX_PTCL_TRIGGER_SS_EN_1 BIT(3)
#define B_AX_PTCL_TRIGGER_SS_EN_0 BIT(2)
#define B_AX_CMAC_TX_MODE_1 BIT(1)
#define B_AX_CMAC_TX_MODE_0 BIT(0)

#define R_AX_AGG_BK_0 0xC604
#define R_AX_AGG_BK_0_C1 0xE604
#define B_AX_EN_SAMPDU_TXIME_TWT_CHECK BIT(11)
#define B_AX_DIS_SAMPDU_TXIME_P2P_CHECK BIT(10)
#define B_AX_DIS_SAMPDU_TXIME_BCN_CHECK BIT(9)
#define B_AX_DIS_UL_SEQ_ABORT_CHECK BIT(8)
#define B_AX_DIS_SND_STS_CHECK BIT(7)
#define B_AX_NAV_PAUS_PHB_EN BIT(6)
#define B_AX_TXOP_SHT_PHB_EN BIT(5)
#define B_AX_AGG_BRK_PHB_EN BIT(4)
#define B_AX_DIS_SSN_CHK BIT(3)
#define B_AX_WDBK_CFG BIT(2)
#define B_AX_EN_RTY_BK BIT(1)
#define B_AX_EN_RTY_BK_COD BIT(0)

#define R_AX_TX_CTRL 0xC608
#define R_AX_TX_CTRL_C1 0xE608
#define B_AX_DROP_CHK_MAX_NUM_SH 24
#define B_AX_DROP_CHK_MAX_NUM_MSK 0xff
#define B_AX_DROP_CHK_TIMEOUT_SH 20
#define B_AX_DROP_CHK_TIMEOUT_MSK 0xf
#define B_AX_FWD_SRCH_TIMEOUT_SH 16
#define B_AX_FWD_SRCH_TIMEOUT_MSK 0xf
#define B_AX_PTCL_STOP_WMM BIT(7)
#define B_AX_TXOP_DELAY_TX_SH 0
#define B_AX_TXOP_DELAY_TX_MSK 0x1f

#define R_AX_TB_PPDU_CTRL 0xC60C
#define R_AX_TB_PPDU_CTRL_C1 0xE60C
#define B_AX_TB_PPDU_BK_DIS BIT(15)
#define B_AX_TB_PPDU_BE_DIS BIT(14)
#define B_AX_TB_PPDU_VI_DIS BIT(13)
#define B_AX_TB_PPDU_VO_DIS BIT(12)
#define B_AX_TB_BYPASS_TXPWR BIT(2)
#define B_AX_SW_PREFER_AC_SH 0
#define B_AX_SW_PREFER_AC_MSK 0x3

#define R_AX_AMPDU_AGG_LIMIT 0xC610
#define R_AX_AMPDU_AGG_LIMIT_C1 0xE610
#define B_AX_AMPDU_MAX_TIME_SH 24
#define B_AX_AMPDU_MAX_TIME_MSK 0xff
#define B_AX_RA_TRY_RATE_AGG_LMT_SH 16
#define B_AX_RA_TRY_RATE_AGG_LMT_MSK 0xff
#define B_AX_RTS_MAX_AGG_NUM_SH 8
#define B_AX_RTS_MAX_AGG_NUM_MSK 0xff
#define B_AX_MAX_AGG_NUM_SH 0
#define B_AX_MAX_AGG_NUM_MSK 0xff

#define R_AX_AGG_LEN_HT_0 0xC614
#define R_AX_AGG_LEN_HT_0_C1 0xE614
#define B_AX_AMPDU_MAX_LEN_HT_SH 16
#define B_AX_AMPDU_MAX_LEN_HT_MSK 0xffff
#define B_AX_RTS_TXTIME_TH_SH 8
#define B_AX_RTS_TXTIME_TH_MSK 0xff
#define B_AX_RTS_LEN_TH_SH 0
#define B_AX_RTS_LEN_TH_MSK 0xff

#define R_AX_AGG_LEN_VHT_0 0xC618
#define R_AX_AGG_LEN_VHT_0_C1 0xE618
#define B_AX_AMPDU_MAX_LEN_VHT_SH 0
#define B_AX_AMPDU_MAX_LEN_VHT_MSK 0xfffff

#define R_AX_AGG_LEN_HE_0 0xC61C
#define R_AX_AGG_LEN_HE_0_C1 0xE61C
#define B_AX_AMPDU_MAX_LEN_HE_SH 0
#define B_AX_AMPDU_MAX_LEN_HE_MSK 0x7fffff

#define R_AX_SPECIAL_TX_SETTING 0xC620
#define R_AX_SPECIAL_TX_SETTING_C1 0xE620
#define B_AX_TRI_PADDING_EXTEND BIT(31)
#define B_AX_BW_SIGTA_SH 28
#define B_AX_BW_SIGTA_MSK 0x3
#define B_AX_USE_DATA_BW BIT(27)
#define B_AX_BMC_NAV_PROTECT BIT(26)
#define B_AX_STBC_CFEND_SH 18
#define B_AX_STBC_CFEND_MSK 0x3
#define B_AX_STBC_CFEND_RATE_SH 9
#define B_AX_STBC_CFEND_RATE_MSK 0x1ff
#define B_AX_BASIC_CFEND_RATE_SH 0
#define B_AX_BASIC_CFEND_RATE_MSK 0x1ff

#define R_AX_SIFS_SETTING 0xC624
#define R_AX_SIFS_SETTING_C1 0xE624
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_SH 24
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_MSK 0xff
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_TWW_SH 18
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_TWW_MSK 0x3f
#define B_AX_HW_CTS2SELF_EN BIT(16)
#define B_AX_SPEC_SIFS_OFDM_PTCL_SH 8
#define B_AX_SPEC_SIFS_OFDM_PTCL_MSK 0xff
#define B_AX_SPEC_SIFS_CCK_PTCL_SH 0
#define B_AX_SPEC_SIFS_CCK_PTCL_MSK 0xff

#define R_AX_TXRATE_CHK 0xC628
#define R_AX_TXRATE_CHK_C1 0xE628
#define B_AX_LATENCY_PADDING_PKT_TH_SH 24
#define B_AX_LATENCY_PADDING_PKT_TH_MSK 0xff
#define B_AX_PLCP_FETCH_BUFF_SH 16
#define B_AX_PLCP_FETCH_BUFF_MSK 0xff
#define B_AX_DEFT_RATE_SH 7
#define B_AX_DEFT_RATE_MSK 0x1ff
#define B_AX_BAND_MODE BIT(4)
#define B_AX_MAX_TXNSS_SH 2
#define B_AX_MAX_TXNSS_MSK 0x3
#define B_AX_RTS_LIMIT_IN_OFDM6 BIT(1)
#define B_AX_CHECK_CCK_EN BIT(0)

#define R_AX_TXCNT 0xC62C
#define R_AX_TXCNT_C1 0xE62C
#define B_AX_ADD_TXCNT_BY BIT(31)
#define B_AX_S_TXCNT_LMT_SH 24
#define B_AX_S_TXCNT_LMT_MSK 0x3f
#define B_AX_L_TXCNT_LMT_SH 16
#define B_AX_L_TXCNT_LMT_MSK 0x3f

#define R_AX_LIFETIME_0 0xC630
#define R_AX_LIFETIME_0_C1 0xE630
#define B_AX_PKT_LIFETIME_2_SH 16
#define B_AX_PKT_LIFETIME_2_MSK 0xffff
#define B_AX_PKT_LIFETIME_1_SH 0
#define B_AX_PKT_LIFETIME_1_MSK 0xffff

#define R_AX_LIFETIME_1 0xC634
#define R_AX_LIFETIME_1_C1 0xE634
#define B_AX_PKT_LIFETIME_4_SH 16
#define B_AX_PKT_LIFETIME_4_MSK 0xffff
#define B_AX_PKT_LIFETIME_3_SH 0
#define B_AX_PKT_LIFETIME_3_MSK 0xffff

#define R_AX_LIFETIME_2 0xC638
#define R_AX_LIFETIME_2_C1 0xE638
#define B_AX_CPUMGQ_LIFETIME_SH 16
#define B_AX_CPUMGQ_LIFETIME_MSK 0xffff
#define B_AX_MGQ_LIFETIME_SH 0
#define B_AX_MGQ_LIFETIME_MSK 0xffff

#define R_AX_MBSSID_DROP_0 0xC63C
#define R_AX_MBSSID_DROP_0_C1 0xE63C
#define B_AX_GI_LTF_FB_SEL BIT(30)
#define B_AX_RATE_SEL_SH 24
#define B_AX_RATE_SEL_MSK 0x3f
#define B_AX_PORT_DROP_4_0_SH 16
#define B_AX_PORT_DROP_4_0_MSK 0x1f
#define B_AX_MBSSID_DROP_15_0_SH 0
#define B_AX_MBSSID_DROP_15_0_MSK 0xffff

#define R_AX_ARFR_WT_0 0xC640
#define R_AX_ARFR_WT_0_C1 0xE640
#define B_AX_RATE7_WEIGHTING_SH 28
#define B_AX_RATE7_WEIGHTING_MSK 0xf
#define B_AX_RATE6_WEIGHTING_SH 24
#define B_AX_RATE6_WEIGHTING_MSK 0xf
#define B_AX_RATE5_WEIGHTING_SH 20
#define B_AX_RATE5_WEIGHTING_MSK 0xf
#define B_AX_RATE4_WEIGHTING_SH 16
#define B_AX_RATE4_WEIGHTING_MSK 0xf
#define B_AX_RATE3_WEIGHTING_SH 12
#define B_AX_RATE3_WEIGHTING_MSK 0xf
#define B_AX_RATE2_WEIGHTING_SH 8
#define B_AX_RATE2_WEIGHTING_MSK 0xf
#define B_AX_RATE1_WEIGHTING_SH 4
#define B_AX_RATE1_WEIGHTING_MSK 0xf
#define B_AX_RATE0_WEIGHTING_SH 0
#define B_AX_RATE0_WEIGHTING_MSK 0xf

#define R_AX_DARF_TC 0xC648
#define R_AX_DARF_TC_C1 0xE648
#define B_AX_DARF_TC9_SH 28
#define B_AX_DARF_TC9_MSK 0xf
#define B_AX_DARF_TC8_SH 24
#define B_AX_DARF_TC8_MSK 0xf
#define B_AX_DARF_TC7_SH 20
#define B_AX_DARF_TC7_MSK 0xf
#define B_AX_DARF_TC6_SH 16
#define B_AX_DARF_TC6_MSK 0xf
#define B_AX_DARF_TC5_SH 12
#define B_AX_DARF_TC5_MSK 0xf
#define B_AX_DARF_TC4_SH 8
#define B_AX_DARF_TC4_MSK 0xf
#define B_AX_DARF_TC3_SH 4
#define B_AX_DARF_TC3_MSK 0xf
#define B_AX_DARF_TC2_SH 0
#define B_AX_DARF_TC2_MSK 0xf

#define R_AX_DARF1_TC 0xC64C
#define R_AX_DARF1_TC_C1 0xE64C
#define B_AX_DARF1_TC9_SH 28
#define B_AX_DARF1_TC9_MSK 0xf
#define B_AX_DARF1_TC8_SH 24
#define B_AX_DARF1_TC8_MSK 0xf
#define B_AX_DARF1_TC7_SH 20
#define B_AX_DARF1_TC7_MSK 0xf
#define B_AX_DARF1_TC6_SH 16
#define B_AX_DARF1_TC6_MSK 0xf
#define B_AX_DARF1_TC5_SH 12
#define B_AX_DARF1_TC5_MSK 0xf
#define B_AX_DARF1_TC4_SH 8
#define B_AX_DARF1_TC4_MSK 0xf
#define B_AX_DARF1_TC3_SH 4
#define B_AX_DARF1_TC3_MSK 0xf
#define B_AX_DARF1_TC2_SH 0
#define B_AX_DARF1_TC2_MSK 0xf

#define R_AX_RARF_TC 0xC650
#define R_AX_RARF_TC_C1 0xE650
#define B_AX_RARF_TC9_SH 28
#define B_AX_RARF_TC9_MSK 0xf
#define B_AX_RARF_TC8_SH 24
#define B_AX_RARF_TC8_MSK 0xf
#define B_AX_RARF_TC7_SH 20
#define B_AX_RARF_TC7_MSK 0xf
#define B_AX_RARF_TC6_SH 16
#define B_AX_RARF_TC6_MSK 0xf
#define B_AX_RARF_TC5_SH 12
#define B_AX_RARF_TC5_MSK 0xf
#define B_AX_RARF_TC4_SH 8
#define B_AX_RARF_TC4_MSK 0xf
#define B_AX_RARF_TC3_SH 4
#define B_AX_RARF_TC3_MSK 0xf
#define B_AX_RARF_TC2_SH 0
#define B_AX_RARF_TC2_MSK 0xf

#define R_AX_PTCL_ATM 0xC654
#define R_AX_PTCL_ATM_C1 0xE654
#define B_AX_CHNL_REF_RX_BASIC_NAV BIT(31)
#define B_AX_CHNL_REF_RX_INTRA_NAV BIT(30)
#define B_AX_CHNL_REF_DATA_ON BIT(29)
#define B_AX_CHNL_REF_EDCCA_P20 BIT(28)
#define B_AX_CHNL_REF_CCA_P20 BIT(27)
#define B_AX_CHNL_REF_CCA_S20 BIT(26)
#define B_AX_CHNL_REF_CCA_S40 BIT(25)
#define B_AX_CHNL_REF_CCA_S80 BIT(24)
#define B_AX_CHNL_REF_PHY_TXON BIT(23)
#define B_AX_RST_CHNL_BUSY BIT(19)
#define B_AX_RST_CHNL_IDLE BIT(18)
#define B_AX_CHNL_INFO_EN BIT(17)
#define B_AX_ATM_AIRTIME_EN BIT(16)
#define B_AX_ATM_TF_UD BIT(12)
#define B_AX_ATM_SR_UD_1_SH 10
#define B_AX_ATM_SR_UD_1_MSK 0x3
#define B_AX_ATM_SR_UD_0_SH 8
#define B_AX_ATM_SR_UD_0_MSK 0x3
#define B_AX_ATM_TB_UD_1_SH 6
#define B_AX_ATM_TB_UD_1_MSK 0x3
#define B_AX_ATM_TB_UD_0_SH 4
#define B_AX_ATM_TB_UD_0_MSK 0x3
#define B_AX_ATM_TX_UD_1_SH 2
#define B_AX_ATM_TX_UD_1_MSK 0x3
#define B_AX_ATM_TX_UD_0_SH 0
#define B_AX_ATM_TX_UD_0_MSK 0x3

#define R_AX_CHNL_IDLE_TIME_0 0xC658
#define R_AX_CHNL_IDLE_TIME_0_C1 0xE658
#define B_AX_CHNL_IDLE_TIME_SH 0
#define B_AX_CHNL_IDLE_TIME_MSK 0xffffffffL

#define R_AX_CHNL_BUSY_TIME_0 0xC65C
#define R_AX_CHNL_BUSY_TIME_0_C1 0xE65C
#define B_AX_CHNL_BUSY_TIME_SH 0
#define B_AX_CHNL_BUSY_TIME_MSK 0xffffffffL

#define R_AX_PTCLRPT_FULL_HDL 0xC660
#define R_AX_PTCLRPT_FULL_HDL_C1 0xE660
#define B_AX_RPT_LATCH_PHY_TIME_SH 12
#define B_AX_RPT_LATCH_PHY_TIME_MSK 0xf
#define B_AX_F2PCMD_FWWD_RLS_MODE BIT(9)
#define B_AX_F2PCMD_RPT_EN BIT(8)
#define B_AX_BCN_RPT_PATH_SH 6
#define B_AX_BCN_RPT_PATH_MSK 0x3
#define B_AX_SPE_RPT_PATH_SH 4
#define B_AX_SPE_RPT_PATH_MSK 0x3
#define B_AX_TX_RPT_PATH_SH 2
#define B_AX_TX_RPT_PATH_MSK 0x3
#define B_AX_F2PCMDRPT_FULL_DROP BIT(1)
#define B_AX_NON_F2PCMDRPT_FULL_DROP BIT(0)

#define R_AX_PTCL_TXOP_BK 0xC670
#define R_AX_PTCL_TXOP_BK_C1 0xE670
#define B_AX_TXOP_BK_EN_SH 16
#define B_AX_TXOP_BK_EN_MSK 0x7f
#define B_AX_TXOP_BK_PKT_NUM_SH 8
#define B_AX_TXOP_BK_PKT_NUM_MSK 0xff
#define B_AX_TXOP_BK_TX_TIME_SH 0
#define B_AX_TXOP_BK_TX_TIME_MSK 0xff

#define R_AX_PTCL_NAV_PROT_LEN 0xC674
#define R_AX_PTCL_NAV_PROT_LEN_C1 0xE674
#define B_AX_SPEC_MBA_HE_PTCL_SH 16
#define B_AX_SPEC_MBA_HE_PTCL_MSK 0xffff
#define B_AX_NAV_PROT_LEN_SH 0
#define B_AX_NAV_PROT_LEN_MSK 0xffff

#define R_AX_PROT 0xC678
#define R_AX_PROT_C1 0xE678
#define B_AX_NAV_OVER_TXOP_EN BIT(16)
#define B_AX_NAV_PROT_LEN_CTN_MODE_SH 0
#define B_AX_NAV_PROT_LEN_CTN_MODE_MSK 0xffff

#define R_AX_BT_PLT 0xC67C
#define R_AX_BT_PLT_C1 0xE67C
#define B_AX_BT_PLT_PKT_CNT_SH 16
#define B_AX_BT_PLT_PKT_CNT_MSK 0xffff
#define B_AX_BT_PLT_RST BIT(9)
#define B_AX_PLT_EN BIT(8)
#define B_AX_RX_PLT_GNT_LTE_RX BIT(7)
#define B_AX_RX_PLT_GNT_BT_RX BIT(6)
#define B_AX_RX_PLT_GNT_BT_TX BIT(5)
#define B_AX_RX_PLT_GNT_WL BIT(4)
#define B_AX_TX_PLT_GNT_LTE_RX BIT(3)
#define B_AX_TX_PLT_GNT_BT_RX BIT(2)
#define B_AX_TX_PLT_GNT_BT_TX BIT(1)
#define B_AX_TX_PLT_GNT_WL BIT(0)

#define R_AX_TWTQ_CTRL1 0xC680
#define R_AX_TWTQ_CTRL1_C1 0xE680
#define B_AX_TWTQ_ULTRHD_SH 16
#define B_AX_TWTQ_ULTRHD_MSK 0xffff
#define B_AX_TWTQ_TXOPTRHD_SH 0
#define B_AX_TWTQ_TXOPTRHD_MSK 0xffff

#define R_AX_TWTQ_CTRL2 0xC684
#define R_AX_TWTQ_CTRL2_C1 0xE684
#define B_AX_TWTQ_AGGTRHD_SH 0
#define B_AX_TWTQ_AGGTRHD_MSK 0xffff

#define R_AX_BCNQ_CTRL 0xC690
#define R_AX_BCNQ_CTRL_C1 0xE690
#define B_AX_BCNQ_LOCK_STUS BIT(31)
#define B_AX_BCNQ_LOCK BIT(0)

#define R_AX_PTCL_BSS_COLOR_0 0xC6A0
#define R_AX_PTCL_BSS_COLOR_0_C1 0xE6A0
#define B_AX_BSS_COLOB_AX_PORT_3_SH 24
#define B_AX_BSS_COLOB_AX_PORT_3_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_2_SH 16
#define B_AX_BSS_COLOB_AX_PORT_2_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_1_SH 8
#define B_AX_BSS_COLOB_AX_PORT_1_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_0_SH 0
#define B_AX_BSS_COLOB_AX_PORT_0_MSK 0x3f

#define R_AX_PTCL_BSS_COLOR_1 0xC6A4
#define R_AX_PTCL_BSS_COLOR_1_C1 0xE6A4
#define B_AX_BSS_COLOB_AX_PORT_4_SH 0
#define B_AX_BSS_COLOB_AX_PORT_4_MSK 0x3f

#define R_AX_PTCL_F2P_TX_SETTING 0xC6B0
#define R_AX_PTCL_F2P_TX_SETTING_C1 0xE6B0
#define B_AX_TF_MURTS_TXTIME_SH 8
#define B_AX_TF_MURTS_TXTIME_MSK 0xff
#define B_AX_TF_DATA_TF_LENGTH_SH 0
#define B_AX_TF_DATA_TF_LENGTH_MSK 0xff

#define R_AX_PTCL_IMR0 0xC6C0
#define R_AX_PTCL_IMR0_C1 0xE6C0
#define B_AX_F2PCMD_PKTID_ERR_INT_EN BIT(31)
#define B_AX_F2PCMD_RD_PKTID_ERR_INT_EN BIT(30)
#define B_AX_F2PCMD_ASSIGN_PKTID_ERR_INT_EN BIT(29)
#define B_AX_F2PCMD_USER_ALLC_ERR_INT_EN BIT(28)
#define B_AX_RX_SPF_U0_PKTID_ERR_INT_EN BIT(27)
#define B_AX_TX_SPF_U1_PKTID_ERR_INT_EN BIT(26)
#define B_AX_TX_SPF_U2_PKTID_ERR_INT_EN BIT(25)
#define B_AX_TX_SPF_U3_PKTID_ERR_INT_EN BIT(24)
#define B_AX_TX_RECORD_PKTID_ERR_INT_EN BIT(23)
#define B_AX_F2PCMD_EMPTY_ERR_INT_EN BIT(15)
#define B_AX_TWTSP_QSEL_ERR_INT_EN BIT(14)
#define B_AX_BCNQ_ORDER_ERR_INT_EN BIT(12)
#define B_AX_Q_PKTID_ERR_INT_EN BIT(11)
#define B_AX_D_PKTID_ERR_INT_EN BIT(10)
#define B_AX_TXPRT_FULL_DROP_ERR_INT_EN BIT(9)
#define B_AX_F2PCMDRPT_FULL_DROP_ERR_INT_EN BIT(8)

#define R_AX_PTCL_ISR0 0xC6C4
#define R_AX_PTCL_ISR0_C1 0xE6C4
#define B_AX_F2PCMD_PKTID_ERR BIT(31)
#define B_AX_F2PCMD_RD_PKTID_ERR BIT(30)
#define B_AX_F2PCMD_ASSIGN_PKTID_ERR BIT(29)
#define B_AX_F2PCMD_USER_ALLC_ERR BIT(28)
#define B_AX_RX_SPF_U0_PKTID_ERR BIT(27)
#define B_AX_TX_SPF_U1_PKTID_ERR BIT(26)
#define B_AX_TX_SPF_U2_PKTID_ERR BIT(25)
#define B_AX_TX_SPF_U3_PKTID_ERR BIT(24)
#define B_AX_TX_RECORD_PKTID_ERR BIT(23)
#define B_AX_F2PCMD_EMPTY_ERR BIT(15)
#define B_AX_TWTSP_QSEL_ERR BIT(14)
#define B_AX_BCNQ_ORDER_ERR BIT(12)
#define B_AX_Q_PKTID_ERR BIT(11)
#define B_AX_D_PKTID_ERR BIT(10)
#define B_AX_TXPRT_FULL_DROP_ERR BIT(9)
#define B_AX_F2PCMDRPT_FULL_DROP_ERR BIT(8)
#define B_AX_FSM_TIMEOUT_ERR BIT(0)

#define R_AX_PTCL_IMR1 0xC6C8
#define R_AX_PTCL_IMR1_C1 0xE6C8

#define R_AX_PTCL_ISR1 0xC6CC
#define R_AX_PTCL_ISR1_C1 0xE6CC

#define R_AX_PTCL_RST_CTRL 0xC6E0
#define R_AX_PTCL_RST_CTRL_C1 0xE6E0
#define B_AX_PTCL_TX_FINISH_REQ_STATUS BIT(24)
#define B_AX_PTCL_WDE_EN BIT(1)
#define B_AX_PTCL_TX_FINISH_REQ BIT(0)

#define R_AX_PTCL_FSM_MON 0xC6E8
#define R_AX_PTCL_FSM_MON_C1 0xE6E8
#define B_AX_PTCL_FSM2_TO_MODE BIT(30)
#define B_AX_PTCL_FSM2_TO_THR_SH 24
#define B_AX_PTCL_FSM2_TO_THR_MSK 0x3f
#define B_AX_PTCL_FSM1_TO_MODE BIT(22)
#define B_AX_PTCL_FSM1_TO_THR_SH 16
#define B_AX_PTCL_FSM1_TO_THR_MSK 0x3f
#define B_AX_PTCL_FSM0_TO_MODE BIT(14)
#define B_AX_PTCL_FSM0_TO_THR_SH 8
#define B_AX_PTCL_FSM0_TO_THR_MSK 0x3f
#define B_AX_PTCL_TX_ARB_TO_MODE BIT(6)
#define B_AX_PTCL_TX_ARB_TO_THR_SH 0
#define B_AX_PTCL_TX_ARB_TO_THR_MSK 0x3f

#define R_AX_PTCL_TX_CTN_SEL 0xC6EC
#define R_AX_PTCL_TX_CTN_SEL_C1 0xE6EC
#define B_AX_PTCL_TX_ON_STAT BIT(7)
#define B_AX_PTCL_DROP BIT(5)
#define B_AX_PTCL_TX_QUEUE_IDX_SH 0
#define B_AX_PTCL_TX_QUEUE_IDX_MSK 0x1f

#define R_AX_PTCL_DBG_INFO 0xC6F0
#define R_AX_PTCL_DBG_INFO_C1 0xE6F0
#define B_AX_PTCL_DBG_INFO_SH 0
#define B_AX_PTCL_DBG_INFO_MSK 0xffffffffL

#define R_AX_NULL_PKT_STATUS 0xC6F6
#define R_AX_NULL_PKT_STATUS_C1 0xE6F6
#define B_AX_P4_NULL_1_STATUS BIT(9)
#define B_AX_P4_NULL_0_STATUS BIT(8)
#define B_AX_P3_NULL_1_STATUS BIT(7)
#define B_AX_P3_NULL_0_STATUS BIT(6)
#define B_AX_P2_NULL_1_STATUS BIT(5)
#define B_AX_P2_NULL_0_STATUS BIT(4)
#define B_AX_P1_NULL_1_STATUS BIT(3)
#define B_AX_P1_NULL_0_STATUS BIT(2)
#define B_AX_P0_NULL_1_STATUS BIT(1)
#define B_AX_P0_NULL_0_STATUS BIT(0)

#define R_AX_PTCL_DBG 0xC6F4
#define R_AX_PTCL_DBG_C1 0xE6F4
#define B_AX_PTCL_DBG_EN BIT(8)
#define B_AX_PTCL_DBG_SEL_SH 0
#define B_AX_PTCL_DBG_SEL_MSK 0xff

#define R_AX_PTCL_TX_MACID_0 0xC6FC
#define R_AX_PTCL_TX_MACID_0_C1 0xE6FC
#define B_AX_TX_MACID_3_SH 24
#define B_AX_TX_MACID_3_MSK 0xff
#define B_AX_TX_MACID_2_SH 16
#define B_AX_TX_MACID_2_MSK 0xff
#define B_AX_TX_MACID_1_SH 8
#define B_AX_TX_MACID_1_MSK 0xff
#define B_AX_TX_MACID_0_SH 0
#define B_AX_TX_MACID_0_MSK 0xff

#define R_AX_TXCMD_DBG_SEL 0xC700
#define R_AX_TXCMD_DBG_SEL_C1 0xE700
#define B_AX_USER_CMD_3_0_VALID_SH 28
#define B_AX_USER_CMD_3_0_VALID_MSK 0xf
#define B_AX_DBG_SEL_F2P_COMMON_SH 20
#define B_AX_DBG_SEL_F2P_COMMON_MSK 0xf
#define B_AX_DBG_SEL_USER_CMD_U3_SH 16
#define B_AX_DBG_SEL_USER_CMD_U3_MSK 0xf
#define B_AX_DBG_SEL_USER_CMD_U2_SH 12
#define B_AX_DBG_SEL_USER_CMD_U2_MSK 0xf
#define B_AX_DBG_SEL_USER_CMD_U1_SH 8
#define B_AX_DBG_SEL_USER_CMD_U1_MSK 0xf
#define B_AX_DBG_SEL_USER_CMD_U0_SH 4
#define B_AX_DBG_SEL_USER_CMD_U0_MSK 0xf
#define B_AX_DBG_SEL_PPDU_CMD_SH 0
#define B_AX_DBG_SEL_PPDU_CMD_MSK 0xf

#define R_AX_PPDU_CMD 0xC704
#define R_AX_PPDU_CMD_C1 0xE704
#define B_AX_PPDU_CMD_SH 0
#define B_AX_PPDU_CMD_MSK 0xffffffffL

#define R_AX_USER_CMD_U0 0xC708
#define R_AX_USER_CMD_U0_C1 0xE708
#define B_AX_USER_CMD_U0_SH 0
#define B_AX_USER_CMD_U0_MSK 0xffffffffL

#define R_AX_USER_CMD_U1 0xC70C
#define R_AX_USER_CMD_U1_C1 0xE70C
#define B_AX_USER_CMD_U1_SH 0
#define B_AX_USER_CMD_U1_MSK 0xffffffffL

#define R_AX_USER_CMD_U2 0xC710
#define R_AX_USER_CMD_U2_C1 0xE710
#define B_AX_USER_CMD_U2_SH 0
#define B_AX_USER_CMD_U2_MSK 0xffffffffL

#define R_AX_USER_CMD_U3 0xC714
#define R_AX_USER_CMD_U3_C1 0xE714
#define B_AX_USER_CMD_U3_SH 0
#define B_AX_USER_CMD_U3_MSK 0xffffffffL

#define R_AX_LEN_CMD_U0 0xC718
#define R_AX_LEN_CMD_U0_C1 0xE718
#define B_AX_LEN_CMD_U0_SH 0
#define B_AX_LEN_CMD_U0_MSK 0xffffffffL

#define R_AX_LEN_CMD_U1 0xC71C
#define R_AX_LEN_CMD_U1_C1 0xE71C
#define B_AX_LEN_CMD_U1_SH 0
#define B_AX_LEN_CMD_U1_MSK 0xffffffffL

#define R_AX_LEN_CMD_U2 0xC720
#define R_AX_LEN_CMD_U2_C1 0xE720
#define B_AX_LEN_CMD_U2_SH 0
#define B_AX_LEN_CMD_U2_MSK 0xffffffffL

#define R_AX_LEN_CMD_U3 0xC724
#define R_AX_LEN_CMD_U3_C1 0xE724
#define B_AX_LEN_CMD_U3_SH 0
#define B_AX_LEN_CMD_U3_MSK 0xffffffffL

#define R_AX_F2P_COMMON 0xC728
#define R_AX_F2P_COMMON_C1 0xE728
#define B_AX_F2P_COMMON_SH 0
#define B_AX_F2P_COMMON_MSK 0xffffffffL

#define R_AX_TXRPT_DBG_INFO 0xC7F0
#define R_AX_TXRPT_DBG_INFO_C1 0xE7F0
#define B_AX_TXRPT_DBG_INFO_SH 0
#define B_AX_TXRPT_DBG_INFO_MSK 0xffffffffL

//
// CMAC_DMA
//

#define R_AX_DLE_CTRL 0xC800
#define R_AX_DLE_CTRL_C1 0xE800
#define B_AX_SET_NULL_PKT_ERROR BIT(30)
#define B_AX_PLE_SET_BURST_NUM_ERROR BIT(29)
#define B_AX_PLE_RESPONSE_ERROR BIT(28)
#define B_AX_PLE_OUTPUT_ERROR BIT(27)
#define B_AX_WDE_SET_BURST_NUM_ERROR BIT(26)
#define B_AX_WDE_RESPONSE_ERROR BIT(25)
#define B_AX_WDE_OUTPUT_ERROR BIT(24)
#define B_AX_NO_RESERVE_PAGE_ERR_IMR BIT(23)
#define B_AX_TXDMA_RU3_FIFO_FULL_WARNING BIT(22)
#define B_AX_TXDMA_RU2_FIFO_FULL_WARNING BIT(21)
#define B_AX_TXDMA_RU1_FIFO_FULL_WARNING BIT(20)
#define B_AX_TXDMA_RU0_FIFO_FULL_WARNING BIT(19)
#define B_AX_RXDATA_FSM_HANG_ERROR BIT(18)
#define B_AX_RXSTS_FSM_HANG_ERROR BIT(17)
#define B_AX_RXDATA_FSM_HANG_ERROR_IMR BIT(15)
#define B_AX_RXSTS_FSM_HANG_ERROR_IMR BIT(14)
#define B_AX_DLE_WDE_STATE_SH 11
#define B_AX_DLE_WDE_STATE_MSK 0x3
#define B_AX_DLE_PLE_STATE_SH 9
#define B_AX_DLE_PLE_STATE_MSK 0x3
#define B_AX_DLE_REQUEST_BUFF_STATE_SH 7
#define B_AX_DLE_REQUEST_BUFF_STATE_MSK 0x3
#define B_AX_DLE_ENQ_STATE BIT(6)
#define B_AX_RECOVERY_INDICATOR BIT(5)
#define B_AX_DLE_CLOCK_FORCE BIT(4)
#define B_AX_TXDMA_CLOCK_FORCE BIT(3)
#define B_AX_RXDMA_CLOCK_FORCE BIT(2)
#define B_AX_DMA_DBG_SEL BIT(1)
#define B_AX_PL_PAGE_128B BIT(0)

#define R_AX_RXDMA_CTRL_0 0xC804
#define R_AX_RXDMA_CTRL_0_C1 0xE804
#define B_AX_RXDMA_DBGOUT_EN BIT(31)
#define B_AX_RXDMA_DBG_SEL_SH 29
#define B_AX_RXDMA_DBG_SEL_MSK 0x3
#define B_AX_RXDMA_FIFO_DBG_SEL_SH 25
#define B_AX_RXDMA_FIFO_DBG_SEL_MSK 0xf
#define B_AX_RXDMA_DEFAULT_PAGE_SH 21
#define B_AX_RXDMA_DEFAULT_PAGE_MSK 0x3
#define B_AX_RXDMA_BUFF_REQ_PRI_SH 19
#define B_AX_RXDMA_BUFF_REQ_PRI_MSK 0x3
#define B_AX_RXDMA_TGT_QUEID_SH 13
#define B_AX_RXDMA_TGT_QUEID_MSK 0x3f
#define B_AX_RXDMA_TGT_PRID_SH 10
#define B_AX_RXDMA_TGT_PRID_MSK 0x7
#define B_AX_RXDMA_DIS_CSI_RELEASE BIT(9)
#define B_AX_RXDMA_DIS_RXSTS_WAIT_PTR_CLR BIT(7)
#define B_AX_RXDMA_DIS_CSI_WAIT_PTR_CLR BIT(6)
#define B_AX_RXSTS_PTR_FULL_MODE BIT(5)
#define B_AX_CSI_PTR_FULL_MODE BIT(4)
#define B_AX_RU3_PTR_FULL_MODE BIT(3)
#define B_AX_RU2_PTR_FULL_MODE BIT(2)
#define B_AX_RU1_PTR_FULL_MODE BIT(1)
#define B_AX_RU0_PTR_FULL_MODE BIT(0)

#define R_AX_RXDMA_CTRL_1 0xC808
#define R_AX_RXDMA_CTRL_1_C1 0xE808
#define B_AX_F2PCMD_FULL_RSV_DEPTH_SH 28
#define B_AX_F2PCMD_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_TXRPT_FULL_RSV_DEPTH_SH 24
#define B_AX_TXRPT_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RXSTS_FULL_RSV_DEPTH_SH 20
#define B_AX_RXSTS_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_CSI_FULL_RSV_DEPTH_SH 16
#define B_AX_CSI_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU3_FULL_RSV_DEPTH_SH 12
#define B_AX_RU3_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU2_FULL_RSV_DEPTH_SH 8
#define B_AX_RU2_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU1_FULL_RSV_DEPTH_SH 4
#define B_AX_RU1_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU0_FULL_RSV_DEPTH_SH 0
#define B_AX_RU0_FULL_RSV_DEPTH_MSK 0xf

#define R_AX_RXDMA_ERR_FLG_0 0xC80C
#define R_AX_RXDMA_ERR_FLG_0_C1 0xE80C
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW BIT(28)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SH 22
#define B_AX_RXDMA_TXRPT_QUEUE_ID_MSK 0x3f
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW BIT(21)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SH 15
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_MSK 0x3f
#define B_AX_RXDMA_ORDER_FIFO_FULL BIT(14)
#define B_AX_RXDMA_F2PCMD_PTR_OVERFLOW BIT(12)
#define B_AX_RXDMA_TXRPT_PTR_OVERFLOW BIT(11)
#define B_AX_RXDMA_RXSTS_PTR_OVERFLOW BIT(10)
#define B_AX_RXDMA_RU3_PTR_OVERFLOW BIT(9)
#define B_AX_RXDMA_RU2_PTR_OVERFLOW BIT(8)
#define B_AX_RXDMA_RU1_PTR_OVERFLOW BIT(7)
#define B_AX_RXDMA_RU0_PTR_OVERFLOW BIT(6)
#define B_AX_RXDMA_RXSTS_PTR_ERROR BIT(5)
#define B_AX_RXDMA_CSI_PTR_ERROR BIT(4)
#define B_AX_RXDMA_RU3_PTR_ERROR BIT(3)
#define B_AX_RXDMA_RU2_PTR_ERROR BIT(2)
#define B_AX_RXDMA_RU1_PTR_ERROR BIT(1)
#define B_AX_RXDMA_RU0_PTR_ERROR BIT(0)

#define R_AX_RXDMA_ERR_FLG_1 0xC810
#define R_AX_RXDMA_ERR_FLG_1_C1 0xE810
#define B_AX_F2PCMD_PKT_ERR_TYPE2 BIT(27)
#define B_AX_F2PCMD_PKT_ERR_TYPE1 BIT(26)
#define B_AX_F2PCMD_DMA_ERR_TYPE2 BIT(25)
#define B_AX_F2PCMD_DMA_ERR_TYPE1 BIT(24)
#define B_AX_TXRPT_PKT_ERR_TYPE2 BIT(23)
#define B_AX_TXRPT_PKT_ERR_TYPE1 BIT(22)
#define B_AX_TXRPT_DMA_ERR_TYPE2 BIT(21)
#define B_AX_TXRPT_DMA_ERR_TYPE1 BIT(20)
#define B_AX_RXSTS_PKT_ERR_TYPE2 BIT(19)
#define B_AX_RXSTS_PKT_ERR_TYPE1 BIT(18)
#define B_AX_RXSTS_DMA_ERR_TYPE2 BIT(17)
#define B_AX_RXSTS_DMA_ERR_TYPE1 BIT(16)
#define B_AX_RU3_PKT_ERR_TYPE2 BIT(15)
#define B_AX_RU3_PKT_ERR_TYPE1 BIT(14)
#define B_AX_RU3_DMA_ERR_TYPE2 BIT(13)
#define B_AX_RU3_DMA_ERR_TYPE1 BIT(12)
#define B_AX_RU2_PKT_ERR_TYPE2 BIT(11)
#define B_AX_RU2_PKT_ERR_TYPE1 BIT(10)
#define B_AX_RU2_DMA_ERR_TYPE2 BIT(9)
#define B_AX_RU2_DMA_ERR_TYPE1 BIT(8)
#define B_AX_RU1_PKT_ERR_TYPE2 BIT(7)
#define B_AX_RU1_PKT_ERR_TYPE1 BIT(6)
#define B_AX_RU1_DMA_ERR_TYPE2 BIT(5)
#define B_AX_RU1_DMA_ERR_TYPE1 BIT(4)
#define B_AX_RU0_PKT_ERR_TYPE2 BIT(3)
#define B_AX_RU0_PKT_ERR_TYPE1 BIT(2)
#define B_AX_RU0_DMA_ERR_TYPE2 BIT(1)
#define B_AX_RU0_DMA_ERR_TYPE1 BIT(0)

#define R_AX_RXDMA_PKT_INFO_0 0xC814
#define R_AX_RXDMA_PKT_INFO_0_C1 0xE814
#define B_AX_RU1_IS_IDLE BIT(31)
#define B_AX_RU1_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU1_RXDATA_RECOVER_MANNUL_EX BIT(28)
#define B_AX_RU1_WR_PKT_ID_SH 16
#define B_AX_RU1_WR_PKT_ID_MSK 0xfff
#define B_AX_RU0_IS_IDLE BIT(15)
#define B_AX_RU0_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU0_RXDATA_RECOVER_MANNUL_EX BIT(12)
#define B_AX_RU0_WR_PKT_ID_SH 0
#define B_AX_RU0_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_1 0xC818
#define R_AX_RXDMA_PKT_INFO_1_C1 0xE818
#define B_AX_RU3_IS_IDLE BIT(31)
#define B_AX_RU3_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU3_RXDATA_RECOVER_MANNUL_EX BIT(28)
#define B_AX_RU3_WR_PKT_ID_SH 16
#define B_AX_RU3_WR_PKT_ID_MSK 0xfff
#define B_AX_RU2_IS_IDLE BIT(15)
#define B_AX_RU2_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU2_RXDATA_RECOVER_MANNUL_EX BIT(12)
#define B_AX_RU2_WR_PKT_ID_SH 0
#define B_AX_RU2_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_2 0xC81C
#define R_AX_RXDMA_PKT_INFO_2_C1 0xE81C
#define B_AX_TXRPT_IS_IDLE BIT(31)
#define B_AX_TXRPT_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_TXRPT_RXDATA_RECOVER_MANNUL_EX BIT(28)
#define B_AX_TXRPT_WR_PKT_ID_SH 16
#define B_AX_TXRPT_WR_PKT_ID_MSK 0xfff
#define B_AX_RXSTS_IS_IDLE BIT(15)
#define B_AX_RXSTS_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RXSTS_RXDATA_RECOVER_MANNUL_EX BIT(12)
#define B_AX_RXSTS_WR_PKT_ID_SH 0
#define B_AX_RXSTS_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_3 0xC820
#define R_AX_RXDMA_PKT_INFO_3_C1 0xE820
#define B_AX_CSI_ENQ_FIFO_EMPTY BIT(31)
#define B_AX_CSI_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_F2PCMD_IS_IDLE BIT(15)
#define B_AX_F2PCMD_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_F2PCMD_RXDATA_RECOVER_MANNUL_EX BIT(12)
#define B_AX_F2PCMD_WR_PKT_ID_SH 0
#define B_AX_F2PCMD_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_4 0xC824
#define R_AX_RXDMA_PKT_INFO_4_C1 0xE824
#define B_AX_CSI_PKTID_1_VALID BIT(31)
#define B_AX_CSI_PKTID_1_SH 16
#define B_AX_CSI_PKTID_1_MSK 0xfff
#define B_AX_CSI_PKTID_0_VALID BIT(15)
#define B_AX_CSI_PKTID_0_SH 0
#define B_AX_CSI_PKTID_0_MSK 0xfff

#define R_AX_TXDMA_FIFO_INFO_0 0xC834
#define R_AX_TXDMA_FIFO_INFO_0_C1 0xE834
#define B_AX_MACTX_ALLOT_DEPTH_1_SH 0
#define B_AX_MACTX_ALLOT_DEPTH_1_MSK 0x3fffffff

#define R_AX_TXDMA_FIFO_INFO_1 0xC838
#define R_AX_TXDMA_FIFO_INFO_1_C1 0xE838
#define B_AX_RU1_TXFIFO_COUNT_SH 20
#define B_AX_RU1_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_RU0_TXFIFO_COUNT_SH 10
#define B_AX_RU0_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_MACTX_ALLOT_DEPTH_2_SH 0
#define B_AX_MACTX_ALLOT_DEPTH_2_MSK 0x3ff

#define R_AX_TXDMA_FIFO_INFO_2 0xC83C
#define R_AX_TXDMA_FIFO_INFO_2_C1 0xE83C
#define B_AX_RU3_TXFIFO_COUNT_SH 10
#define B_AX_RU3_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_RU2_TXFIFO_COUNT_SH 0
#define B_AX_RU2_TXFIFO_COUNT_MSK 0x3ff

#define R_AX_TXDMA_DBG 0xC840
#define R_AX_TXDMA_DBG_C1 0xE840
#define B_AX_TXDMA_DBG_SEL_SH 27
#define B_AX_TXDMA_DBG_SEL_MSK 0x1f
#define B_AX_TXDMA_DBG_EN BIT(26)
#define B_AX_TX_FINISH_REQ BIT(6)
#define B_AX_PL_ARB_RU_SH 4
#define B_AX_PL_ARB_RU_MSK 0x3
#define B_AX_WD_ARB_RU_SH 2
#define B_AX_WD_ARB_RU_MSK 0x3
#define B_AX_REQ_WD_PLD_ID_CS_SH 0
#define B_AX_REQ_WD_PLD_ID_CS_MSK 0x3

#define R_AX_TXDMA_RU_INFO_0 0xC844
#define R_AX_TXDMA_RU_INFO_0_C1 0xE844
#define B_AX_RU0_CUR_WD_ID_SH 18
#define B_AX_RU0_CUR_WD_ID_MSK 0xfff
#define B_AX_RU0_CUR_PL_ID_SH 6
#define B_AX_RU0_CUR_PL_ID_MSK 0xfff
#define B_AX_RU0_READ_CS_SH 3
#define B_AX_RU0_READ_CS_MSK 0x7
#define B_AX_RU0_WRITE_CS_SH 0
#define B_AX_RU0_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_1 0xC848
#define R_AX_TXDMA_RU_INFO_1_C1 0xE848
#define B_AX_RU1_CUR_WD_ID_SH 18
#define B_AX_RU1_CUR_WD_ID_MSK 0xfff
#define B_AX_RU1_CUR_PL_ID_SH 6
#define B_AX_RU1_CUR_PL_ID_MSK 0xfff
#define B_AX_RU1_READ_CS_SH 3
#define B_AX_RU1_READ_CS_MSK 0x7
#define B_AX_RU1_WRITE_CS_SH 0
#define B_AX_RU1_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_2 0xC84C
#define R_AX_TXDMA_RU_INFO_2_C1 0xE84C
#define B_AX_RU2_CUR_WD_ID_SH 18
#define B_AX_RU2_CUR_WD_ID_MSK 0xfff
#define B_AX_RU2_CUR_PL_ID_SH 6
#define B_AX_RU2_CUR_PL_ID_MSK 0xfff
#define B_AX_RU2_READ_CS_SH 3
#define B_AX_RU2_READ_CS_MSK 0x7
#define B_AX_RU2_WRITE_CS_SH 0
#define B_AX_RU2_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_3 0xC850
#define R_AX_TXDMA_RU_INFO_3_C1 0xE850
#define B_AX_RU3_CUR_WD_ID_SH 18
#define B_AX_RU3_CUR_WD_ID_MSK 0xfff
#define B_AX_RU3_CUR_PL_ID_SH 6
#define B_AX_RU3_CUR_PL_ID_MSK 0xfff
#define B_AX_RU3_READ_CS_SH 3
#define B_AX_RU3_READ_CS_MSK 0x7
#define B_AX_RU3_WRITE_CS_SH 0
#define B_AX_RU3_WRITE_CS_MSK 0x7

//
// TMAC
//

#define R_AX_TCR0 0xCA00
#define R_AX_TCR0_C1 0xEA00
#define B_AX_TCR_ZLD_NUM_SH 24
#define B_AX_TCR_ZLD_NUM_MSK 0xff
#define B_AX_TCR_UDF_EN BIT(23)
#define B_AX_TCR_UDF_THSD_SH 16
#define B_AX_TCR_UDF_THSD_MSK 0x7f
#define B_AX_TCR_ERRSTEN_SH 10
#define B_AX_TCR_ERRSTEN_MSK 0x3f
#define B_AX_TCR_VHTSIGA1_TXPS BIT(9)
#define B_AX_TCR_PLCP_ERRHDL_EN BIT(8)
#define B_AX_TCR_PADSEL BIT(7)
#define B_AX_TCR_MASK_SIGBCRC BIT(6)
#define B_AX_TCR_SR_VAL15_ALLOW BIT(5)
#define B_AX_TCR_EN_EOF BIT(4)
#define B_AX_TCR_EN_SCRAM_INC BIT(3)
#define B_AX_TCR_EN_20MST BIT(2)
#define B_AX_TCR_CRC BIT(1)
#define B_AX_TCR_DISGCLK BIT(0)

#define R_AX_TCR1 0xCA04
#define R_AX_TCR1_C1 0xEA04
#define B_AX_VHT_SIGB_LENGTH BIT(28)
#define B_AX_TCR_CCK_LOCK_CLK BIT(27)
#define B_AX_TCR_FORCE_READ_TXDFIFO BIT(26)
#define B_AX_TCR_USTIME_SH 16
#define B_AX_TCR_USTIME_MSK 0xff
#define B_AX_TCR_SMOOTH_VAL BIT(15)
#define B_AX_TCR_SMOOTH_CTRL BIT(14)
#define B_AX_CS_REQ_VAL BIT(13)
#define B_AX_CS_REQ_SEL BIT(12)
#define B_AX_TCR_TXTIMEOUT_SH 0
#define B_AX_TCR_TXTIMEOUT_MSK 0xff

#define R_AX_MD_TSFT_STMP_CTL 0xCA08
#define R_AX_MD_TSFT_STMP_CTL_C1 0xEA08
#define B_AX_TSFT_OFS_SH 16
#define B_AX_TSFT_OFS_MSK 0xffff
#define B_AX_STMP_THSD_SH 8
#define B_AX_STMP_THSD_MSK 0xff
#define B_AX_UPD_HGQMD BIT(1)
#define B_AX_UPD_TIMIE BIT(0)

#define R_AX_PPWRBIT_SETTING 0xCA0C
#define R_AX_PPWRBIT_SETTING_C1 0xEA0C
#define B_AX_P4_PWRMGT_CTRL_EN BIT(19)
#define B_AX_P4_PWRMGT_DATA_EN BIT(18)
#define B_AX_P4_PWRMGT_ACT_EN BIT(17)
#define B_AX_P4_PWR_ST BIT(16)
#define B_AX_P3_PWRMGT_CTRL_EN BIT(15)
#define B_AX_P3_PWRMGT_DATA_EN BIT(14)
#define B_AX_P3_PWRMGT_ACT_EN BIT(13)
#define B_AX_P3_PWR_ST BIT(12)
#define B_AX_P2_PWRMGT_CTRL_EN BIT(11)
#define B_AX_P2_PWRMGT_DATA_EN BIT(10)
#define B_AX_P2_PWRMGT_ACT_EN BIT(9)
#define B_AX_P2_PWR_ST BIT(8)
#define B_AX_P1_PWRMGT_CTRL_EN BIT(7)
#define B_AX_P1_PWRMGT_DATA_EN BIT(6)
#define B_AX_P1_PWRMGT_ACT_EN BIT(5)
#define B_AX_P1_PWR_ST BIT(4)
#define B_AX_P0_PWRMGT_CTRL_EN BIT(3)
#define B_AX_P0_PWRMGT_DATA_EN BIT(2)
#define B_AX_P0_PWRMGT_ACT_EN BIT(1)
#define B_AX_P0_PWR_ST BIT(0)

#define R_AX_HTC 0xCA10
#define R_AX_HTC_C1 0xEA10
#define B_AX_MHDR_HTC_SH 0
#define B_AX_MHDR_HTC_MSK 0xffffffffL

#define R_AX_SOUNDING 0xCA14
#define R_AX_SOUNDING_C1 0xEA14
#define B_AX_USE_NSTS BIT(22)
#define B_AX_RETRY_BFRPT_SEQ_UPD BIT(21)
#define B_AX_TXNDP_SIGB_SH 0
#define B_AX_TXNDP_SIGB_MSK 0x1fffff

#define R_AX_BSR_CTRL 0xCA18
#define R_AX_BSR_CTRL_C1 0xEA18
#define B_AX_RO_MIN_TX_PWR_FLAG BIT(21)
#define B_AX_RO_UPH_SH 16
#define B_AX_RO_UPH_MSK 0x1f
#define B_AX_BSR_BK_TID_SEL BIT(4)
#define B_AX_BSR_BE_TID_SEL BIT(3)
#define B_AX_BSR_VI_TID_SEL BIT(2)
#define B_AX_BSR_VO_TID_SEL BIT(1)
#define B_AX_BSR_QOS_SEL BIT(0)

#define R_AX_TXD_FIFO_CTRL 0xCA1C
#define R_AX_TXD_FIFO_CTRL_C1 0xEA1C
#define B_AX_NON_LEGACY_PPDU_ZLD_USTIMER_SH 24
#define B_AX_NON_LEGACY_PPDU_ZLD_USTIMER_MSK 0x1f
#define B_AX_LEGACY_PPDU_ZLD_USTIMER_SH 16
#define B_AX_LEGACY_PPDU_ZLD_USTIMER_MSK 0x1f
#define B_AX_TXDFIFO_HIGH_MCS_THRE_SH 12
#define B_AX_TXDFIFO_HIGH_MCS_THRE_MSK 0xf
#define B_AX_TXDFIFO_LOW_MCS_THRE_SH 8
#define B_AX_TXDFIFO_LOW_MCS_THRE_MSK 0xf
#define B_AX_HIGH_MCS_PHY_RATE_SH 4
#define B_AX_HIGH_MCS_PHY_RATE_MSK 0xf
#define B_AX_BW_PHY_RATE_SH 0
#define B_AX_BW_PHY_RATE_MSK 0x3

#define R_AX_MACTX_DBG_SEL_CNT 0xCA20
#define R_AX_MACTX_DBG_SEL_CNT_C1 0xEA20
#define B_AX_MACTX_MPDU_CNT_SH 24
#define B_AX_MACTX_MPDU_CNT_MSK 0xff
#define B_AX_MACTX_DMA_CNT_SH 16
#define B_AX_MACTX_DMA_CNT_MSK 0xff
#define B_AX_ZLD_FLAG_U3 BIT(15)
#define B_AX_ZLD_FLAG_U2 BIT(14)
#define B_AX_ZLD_FLAG_U1 BIT(13)
#define B_AX_ZLD_FLAG_U0 BIT(12)
#define B_AX_LENGTH_ERR_FLAG_U3 BIT(11)
#define B_AX_LENGTH_ERR_FLAG_U2 BIT(10)
#define B_AX_LENGTH_ERR_FLAG_U1 BIT(9)
#define B_AX_LENGTH_ERR_FLAG_U0 BIT(8)
#define B_AX_DBGSEL_MACTX_SH 0
#define B_AX_DBGSEL_MACTX_MSK 0x3f

#define R_AX_DEBUG_ZLD_COUNTER_U0_U1 0xCA24
#define R_AX_DEBUG_ZLD_COUNTER_U0_U1_C1 0xEA24
#define B_AX_ZLD_CNT_USER1_SH 16
#define B_AX_ZLD_CNT_USER1_MSK 0x3ff
#define B_AX_ZLD_CNT_USER0_SH 0
#define B_AX_ZLD_CNT_USER0_MSK 0x3ff

#define R_AX_DEBUG_ZLD_COUNTER_U2_U3 0xCA28
#define R_AX_DEBUG_ZLD_COUNTER_U2_U3_C1 0xEA28
#define B_AX_ZLD_CNT_USER3_SH 16
#define B_AX_ZLD_CNT_USER3_MSK 0x3ff
#define B_AX_ZLD_CNT_USER2_SH 0
#define B_AX_ZLD_CNT_USER2_MSK 0x3ff

#define R_AX_DEBUG_USER2_MPDU_COUNTER 0xCA2C
#define R_AX_DEBUG_USER2_MPDU_COUNTER_C1 0xEA2C
#define B_AX_MPDU_CNT_USER2_SH 24
#define B_AX_MPDU_CNT_USER2_MSK 0xff
#define B_AX_DMA_CNT_USER2_SH 16
#define B_AX_DMA_CNT_USER2_MSK 0xff
#define B_AX_MPDU_CNT_USER1_SH 8
#define B_AX_MPDU_CNT_USER1_MSK 0xff
#define B_AX_DMA_CNT_USER1_SH 0
#define B_AX_DMA_CNT_USER1_MSK 0xff

#define R_AX_DEBUG_USER3_MPDU_COUNTER 0xCA30
#define R_AX_DEBUG_USER3_MPDU_COUNTER_C1 0xEA30
#define B_AX_TXBF_NSTS_ERROR_FLAG_CLR BIT(28)
#define B_AX_TXBF_NSTS_ERROR_FLAG_U3 BIT(27)
#define B_AX_TXBF_NSTS_ERROR_FLAG_U2 BIT(26)
#define B_AX_TXBF_NSTS_ERROR_FLAG_U1 BIT(25)
#define B_AX_TXBF_NSTS_ERROR_FLAG_U0 BIT(24)
#define B_AX_DATA_LENGTH_STUCK_U3 BIT(23)
#define B_AX_DMA_LENGTH_STUCK_U3 BIT(22)
#define B_AX_DATA_LENGTH_STUCK_U2 BIT(21)
#define B_AX_DMA_LENGTH_STUCK_U2 BIT(20)
#define B_AX_DATA_LENGTH_STUCK_U1 BIT(19)
#define B_AX_DMA_LENGTH_STUCK_U1 BIT(18)
#define B_AX_DATA_LENGTH_STUCK_U0 BIT(17)
#define B_AX_DMA_LENGTH_STUCK_U0 BIT(16)
#define B_AX_MPDU_CNT_USER3_SH 8
#define B_AX_MPDU_CNT_USER3_MSK 0xff
#define B_AX_DMA_CNT_USER3_SH 0
#define B_AX_DMA_CNT_USER3_MSK 0xff

#define R_AX_HEPLCP_SR_FIELD 0xCA34
#define R_AX_HEPLCP_SR_FIELD_C1 0xEA34
#define B_AX_PLCP_SR_FIELD_EN BIT(16)
#define B_AX_PLCP_SR_FIELD_SH 0
#define B_AX_PLCP_SR_FIELD_MSK 0xffff

#define R_AX_HE_SIGB_PADDING_SEQ_0 0xCA38
#define R_AX_HE_SIGB_PADDING_SEQ_0_C1 0xEA38
#define B_AX_HESIGB_PADD_SEQ0_SH 0
#define B_AX_HESIGB_PADD_SEQ0_MSK 0xffffffffL

#define R_AX_HE_SIGB_PADDING_SEQ_1 0xCA3C
#define R_AX_HE_SIGB_PADDING_SEQ_1_C1 0xEA3C
#define B_AX_HESIGB_PADD_SEQ1_SH 0
#define B_AX_HESIGB_PADD_SEQ1_MSK 0xffffffffL

#define R_AX_HE_SIGB_PADDING_SEQ_2 0xCA40
#define R_AX_HE_SIGB_PADDING_SEQ_2_C1 0xEA40
#define B_AX_HESIGB_PADD_SEQ2_SH 0
#define B_AX_HESIGB_PADD_SEQ2_MSK 0xffffffffL

#define R_AX_HE_SIGB_PADDING_SEQ_3 0xCA44
#define R_AX_HE_SIGB_PADDING_SEQ_3_C1 0xEA44
#define B_AX_HESIGB_PADD_SEQ3_SH 0
#define B_AX_HESIGB_PADD_SEQ3_MSK 0xffffffffL

#define R_AX_MACTX_BQR 0xCA48
#define R_AX_MACTX_BQR_C1 0xEA48
#define B_AX_DBG_CCA_PER20_BITMAP_BB_SH 24
#define B_AX_DBG_CCA_PER20_BITMAP_BB_MSK 0xff
#define B_AX_BQR_CHANNEL_MASK_VAL_SH 16
#define B_AX_BQR_CHANNEL_MASK_VAL_MSK 0xff
#define B_AX_BQR_MASK_CTRL_SH 8
#define B_AX_BQR_MASK_CTRL_MSK 0xff
#define B_AX_BQR_CCA_BITMAP_SEL BIT(4)
#define B_AX_BQR_TID_VAL_SH 0
#define B_AX_BQR_TID_VAL_MSK 0xf

#define R_AX_TX_PPDU_CNT 0xCAE0
#define R_AX_TX_PPDU_CNT_C1 0xEAE0
#define B_AX_TX_PPDU_CNT_SH 16
#define B_AX_TX_PPDU_CNT_MSK 0xffff
#define B_AX_RST_PPDU_CNT BIT(12)
#define B_AX_PPDU_CNT_RIDX_SH 8
#define B_AX_PPDU_CNT_RIDX_MSK 0xf
#define B_AX_PPDU_CNT_IDX_SH 0
#define B_AX_PPDU_CNT_IDX_MSK 0xf

#define R_AX_WMAC_TX_CTRL_DEBUG 0xCAE4
#define R_AX_WMAC_TX_CTRL_DEBUG_C1 0xEAE4
#define B_AX_TX_CTRL_DEBUG_SEL_SH 0
#define B_AX_TX_CTRL_DEBUG_SEL_MSK 0xf

#define R_AX_WMAC_TX_INFO0_DEBUG 0xCAE8
#define R_AX_WMAC_TX_INFO0_DEBUG_C1 0xEAE8
#define B_AX_TX_CTRL_INFO_P0_SH 0
#define B_AX_TX_CTRL_INFO_P0_MSK 0xffffffffL

#define R_AX_WMAC_TX_INFO1_DEBUG 0xCAEC
#define R_AX_WMAC_TX_INFO1_DEBUG_C1 0xEAEC
#define B_AX_TX_CTRL_INFO_P1_SH 0
#define B_AX_TX_CTRL_INFO_P1_MSK 0xffffffffL

//
// TRXPTCL
//

#define R_AX_RSP_CHK_SIG 0xCC00
#define R_AX_RSP_CHK_SIG_C1 0xEC00
#define B_AX_RSP_STATIC_RTS_CHK_SERV_BW_EN BIT(30)
#define B_AX_RSP_TBPPDU_CHK_PWR BIT(29)
#define B_AX_RSP_CHK_BASIC_NAV BIT(21)
#define B_AX_RSP_CHK_INTRA_NAV BIT(20)
#define B_AX_RSP_CHK_TXNAV BIT(19)
#define B_AX_TXDATA_END_PS_OPT BIT(18)
#define B_AX_CHECK_SOUNDING_SEQ BIT(17)
#define B_AX_RXBA_IGNOREA2 BIT(16)
#define B_AX_ACKTO_CCK_SH 8
#define B_AX_ACKTO_CCK_MSK 0xff
#define B_AX_ACKTO_SH 0
#define B_AX_ACKTO_MSK 0xff

#define R_AX_TRXPTCL_RESP_0 0xCC04
#define R_AX_TRXPTCL_RESP_0_C1 0xEC04
#define B_AX_WMAC_RESP_STBC_EN BIT(31)
#define B_AX_WMAC_RXFTM_TXACK_SC BIT(30)
#define B_AX_WMAC_RXFTM_TXACKBWEQ BIT(29)
#define B_AX_RSP_CHK_SEC_CCA_80 BIT(28)
#define B_AX_RSP_CHK_SEC_CCA_40 BIT(27)
#define B_AX_RSP_CHK_SEC_CCA_20 BIT(26)
#define B_AX_RSP_CHK_BTCCA BIT(25)
#define B_AX_RSP_CHK_EDCCA BIT(24)
#define B_AX_RSP_CHK_CCA BIT(23)
#define B_AX_WMAC_LDPC_EN BIT(22)
#define B_AX_WMAC_SGIEN BIT(21)
#define B_AX_WMAC_SPLCPEN BIT(20)
#define B_AX_WMAC_RESP_ACK_BA_CHK_CCA BIT(19)
#define B_AX_WMAC_BESP_EARLY_TXBA BIT(17)
#define B_AX_WMAC_SPEC_SIFS_OFDM_SH 8
#define B_AX_WMAC_SPEC_SIFS_OFDM_MSK 0xff
#define B_AX_WMAC_SPEC_SIFS_CCK_SH 0
#define B_AX_WMAC_SPEC_SIFS_CCK_MSK 0xff

#define R_AX_TRXPTCL_RRSR_CTL_0 0xCC08
#define R_AX_TRXPTCL_RRSR_CTL_0_C1 0xEC08
#define B_AX_RESP_TX_MACID_CCA_TH_EN BIT(31)
#define B_AX_RESP_TX_PWRMODE_SH 28
#define B_AX_RESP_TX_PWRMODE_MSK 0x7
#define B_AX_FTM_RRSR_RATE_EN_SH 24
#define B_AX_FTM_RRSR_RATE_EN_MSK 0xf
#define B_AX_NESS_SH 22
#define B_AX_NESS_MSK 0x3
#define B_AX_WMAC_RESP_DOPPLEB_AX_EN BIT(21)
#define B_AX_WMAC_RESP_DCM_EN BIT(20)
#define B_AX_WMAC_RRSB_AX_CCK_SH 16
#define B_AX_WMAC_RRSB_AX_CCK_MSK 0xf
#define B_AX_WMAC_RESP_RATE_EN_SH 12
#define B_AX_WMAC_RESP_RATE_EN_MSK 0xf
#define B_AX_WMAC_RESP_RSC_SH 10
#define B_AX_WMAC_RESP_RSC_MSK 0x3
#define B_AX_WMAC_RESP_REF_RATE_SEL BIT(9)
#define B_AX_WMAC_RESP_REF_RATE_SH 0
#define B_AX_WMAC_RESP_REF_RATE_MSK 0x1ff

#define R_AX_TRXPTCL_RRSR_CTL_1 0xCC0C
#define R_AX_TRXPTCL_RRSR_CTL_1_C1 0xEC0C
#define B_AX_WMAC_RRSR_HE_SH 24
#define B_AX_WMAC_RRSR_HE_MSK 0xff
#define B_AX_WMAC_RRSR_VHT_SH 16
#define B_AX_WMAC_RRSR_VHT_MSK 0xff
#define B_AX_WMAC_RRSR_HT_SH 8
#define B_AX_WMAC_RRSR_HT_MSK 0xff
#define B_AX_WMAC_RRSR_OFDM_SH 0
#define B_AX_WMAC_RRSR_OFDM_MSK 0xff

#define R_AX_RESP_TX_NAV_ABORT_COUNTER 0xCC14
#define R_AX_RESP_TX_NAV_ABORT_COUNTER_C1 0xEC14
#define B_AX_BASIC_NAV_ABORT_RESP_TX_CNT_SH 16
#define B_AX_BASIC_NAV_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_INTRA_NAV_ABORT_RESP_TX_CNT_SH 8
#define B_AX_INTRA_NAV_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_TXNAV_ABORT_RESP_TX_CNT_SH 0
#define B_AX_TXNAV_ABORT_RESP_TX_CNT_MSK 0xff

#define R_AX_RESP_TX_CCA_ABORT_COUNTER 0xCC18
#define R_AX_RESP_TX_CCA_ABORT_COUNTER_C1 0xEC18
#define B_AX_CLR_ABORT_RESP_TX_CNT BIT(24)
#define B_AX_SCH_ABORT_RESP_TX_CNT_SH 16
#define B_AX_SCH_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_BTCCA_ABORT_RESP_TX_CNT_SH 8
#define B_AX_BTCCA_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_EDCCA_ABORT_RESP_TX_CNT_SH 0
#define B_AX_EDCCA_ABORT_RESP_TX_CNT_MSK 0xff

#define R_AX_TRXPTCL_RESP_TX_ABORT_COUNTER 0xCC1C
#define R_AX_TRXPTCL_RESP_TX_ABORT_COUNTER_C1 0xEC1C
#define B_AX_WMAC_SEC_CCA80_ABORT_RESP_TX_SH 24
#define B_AX_WMAC_SEC_CCA80_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_SEC_CCA40_ABORT_RESP_TX_SH 16
#define B_AX_WMAC_SEC_CCA40_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_SEC_CCA20_ABORT_RESP_TX_SH 8
#define B_AX_WMAC_SEC_CCA20_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_CCA_ABORT_RESP_TX_SH 0
#define B_AX_WMAC_CCA_ABORT_RESP_TX_MSK 0xff

#define R_AX_MAC_LOOPBACK 0xCC20
#define R_AX_MAC_LOOPBACK_C1 0xEC20
#define B_AX_MACLBK_RDY_PERIOD_SH 17
#define B_AX_MACLBK_RDY_PERIOD_MSK 0xfff
#define B_AX_MACLBK_PLCP_DLY_SH 8
#define B_AX_MACLBK_PLCP_DLY_MSK 0x1ff
#define B_AX_MACLBK_RDY_NUM_SH 3
#define B_AX_MACLBK_RDY_NUM_MSK 0x1f
#define B_AX_MACLBK_EN BIT(0)

#define R_AX_TRXPTCL_CTS_RRSR 0xCC24
#define R_AX_TRXPTCL_CTS_RRSR_C1 0xEC24
#define B_AX_WMAC_CTS_RRSR_RSC_SH 14
#define B_AX_WMAC_CTS_RRSR_RSC_MSK 0x3
#define B_AX_WMAC_CTS_RESP_OPT BIT(12)
#define B_AX_WMAC_CTS_RRSR_CCK_SH 8
#define B_AX_WMAC_CTS_RRSR_CCK_MSK 0xf
#define B_AX_WMAC_CTS_RRSR_OFDM_SH 0
#define B_AX_WMAC_CTS_RRSR_OFDM_MSK 0xff

#define R_AX_MAC_LOOPBACK_COUNT 0xCC28
#define R_AX_MAC_LOOPBACK_COUNT_C1 0xEC28
#define B_AX_RO_MACLBK_COUNT_SH 16
#define B_AX_RO_MACLBK_COUNT_MSK 0xffff
#define B_AX_MACLBK_COUNT_CLR BIT(0)

#define R_AX_CLIENT_OM_CTRL 0xCC40
#define R_AX_CLIENT_OM_CTRL_C1 0xEC40
#define B_AX_WMAC_DIS_SIGTA BIT(16)
#define B_AX_UL_DATA_DIS_SH 0
#define B_AX_UL_DATA_DIS_MSK 0x1f

#define R_AX_WMAC_FTM_CTL 0xCC50
#define R_AX_WMAC_FTM_CTL_C1 0xEC50
#define B_AX_FTM_RPT_ERROR BIT(15)
#define B_AX_FTM_TIMEOUT_BYPASS BIT(14)
#define B_AX_RXFTM_EN BIT(2)
#define B_AX_RXFTMREQ_EN BIT(1)
#define B_AX_FTM_EN BIT(0)

#define R_AX_GET_RTT 0xCC54
#define R_AX_GET_RTT_C1 0xEC54
#define B_AX_ACTION_FIELD_SH 16
#define B_AX_ACTION_FIELD_MSK 0xff
#define B_AX_CATEGORY_FIELD_SH 8
#define B_AX_CATEGORY_FIELD_MSK 0xff
#define B_AX_RTT_TYPE_SUBTYPE_SH 1
#define B_AX_RTT_TYPE_SUBTYPE_MSK 0x3f
#define B_AX_RTT_FILTER_EN BIT(0)

#define R_AX_FTM_PTT 0xCC58
#define R_AX_FTM_PTT_C1 0xEC58
#define B_AX_FTM_PTT_TSF_R2T_SEL_SH 3
#define B_AX_FTM_PTT_TSF_R2T_SEL_MSK 0x7
#define B_AX_FTM_PTT_TSF_T2R_SEL_SH 0
#define B_AX_FTM_PTT_TSF_T2R_SEL_MSK 0x7

#define R_AX_FTM_TSF 0xCC5C
#define R_AX_FTM_TSF_C1 0xEC5C
#define B_AX_FTM_T2_TSF_SH 16
#define B_AX_FTM_T2_TSF_MSK 0xffff
#define B_AX_FTM_T1_TSF_SH 0
#define B_AX_FTM_T1_TSF_MSK 0xffff

#define R_AX_MD_CTRL 0xCC70
#define R_AX_MD_CTRL_C1 0xEC70
#define B_AX_BC_MD_EN BIT(17)
#define B_AX_UC_MD_EN BIT(16)
#define B_AX_WMMPS_UAPSD_TID7 BIT(7)
#define B_AX_WMMPS_UAPSD_TID6 BIT(6)
#define B_AX_WMMPS_UAPSD_TID5 BIT(5)
#define B_AX_WMMPS_UAPSD_TID4 BIT(4)
#define B_AX_WMMPS_UAPSD_TID3 BIT(3)
#define B_AX_WMMPS_UAPSD_TID2 BIT(2)
#define B_AX_WMMPS_UAPSD_TID1 BIT(1)
#define B_AX_WMMPS_UAPSD_TID0 BIT(0)

#define R_AX_WMAC_NAV_CTL 0xCC80
#define R_AX_WMAC_NAV_CTL_C1 0xEC80
#define B_AX_WMAC_NAV_UPPER_EN BIT(26)
#define B_AX_WMAC_0P125US_TIMER_SH 18
#define B_AX_WMAC_0P125US_TIMER_MSK 0xff
#define B_AX_WMAC_PLCP_UP_NAV_EN BIT(17)
#define B_AX_WMAC_TF_UP_NAV_EN BIT(16)
#define B_AX_WMAC_NAV_UPPER_SH 8
#define B_AX_WMAC_NAV_UPPER_MSK 0xff
#define B_AX_WMAC_RTS_RST_DUR_SH 0
#define B_AX_WMAC_RTS_RST_DUR_MSK 0xff

#define R_AX_WMAC_NAV_UP_INFO 0xCC84
#define R_AX_WMAC_NAV_UP_INFO_C1 0xEC84
#define B_AX_WMAC_INTRA_NAV_UPD BIT(31)
#define B_AX_WMAC_BASIC_NAV_UPD BIT(30)
#define B_AX_WMAC_INTRANAV_INTXOP BIT(29)
#define B_AX_WMAC_BASICNAV_INTXOP BIT(28)
#define B_AX_WMAC_INTRA_NAV_DUR_SH 14
#define B_AX_WMAC_INTRA_NAV_DUR_MSK 0x3fff
#define B_AX_WMAC_BASIC_NAV_DUR_SH 0
#define B_AX_WMAC_BASIC_NAV_DUR_MSK 0x3fff

#define R_AX_RXTRIG_TEST_COMM_0 0xCCA0
#define R_AX_RXTRIG_TEST_COMM_0_C1 0xECA0
#define B_AX_RXTRIG_COMMON_0_SH 0
#define B_AX_RXTRIG_COMMON_0_MSK 0xffffffffL

#define R_AX_RXTRIG_TEST_COMM_1 0xCCA4
#define R_AX_RXTRIG_TEST_COMM_1_C1 0xECA4
#define B_AX_RXTRIG_COMMON_1_SH 0
#define B_AX_RXTRIG_COMMON_1_MSK 0xffffffffL

#define R_AX_RXTRIG_TEST_USER_0 0xCCA8
#define R_AX_RXTRIG_TEST_USER_0_C1 0xECA8
#define B_AX_RXTRIG_USERINFO_0_SH 0
#define B_AX_RXTRIG_USERINFO_0_MSK 0xffffffffL

#define R_AX_RXTRIG_TEST_USER_1 0xCCAC
#define R_AX_RXTRIG_TEST_USER_1_C1 0xECAC
#define B_AX_RXTRIG_USERINFO_1_SH 0
#define B_AX_RXTRIG_USERINFO_1_MSK 0xffffffffL

#define R_AX_RXTRIG_TEST_USER_2 0xCCB0
#define R_AX_RXTRIG_TEST_USER_2_C1 0xECB0
#define B_AX_RXTRIG_MACID_SH 24
#define B_AX_RXTRIG_MACID_MSK 0xff
#define B_AX_RXTRIG_RU26_DIS BIT(21)
#define B_AX_RXTRIG_FCSCHK_EN BIT(20)
#define B_AX_RXTRIG_PORT_SEL_SH 17
#define B_AX_RXTRIG_PORT_SEL_MSK 0x7
#define B_AX_RXTRIG_EN BIT(16)
#define B_AX_RXTRIG_USERINFO_2_SH 0
#define B_AX_RXTRIG_USERINFO_2_MSK 0xffff

#define R_AX_RXTRIG_TEST_CTRL1 0xCCB4
#define R_AX_RXTRIG_TEST_CTRL1_C1 0xECB4
#define B_AX_RXTRIG_STATUS_SH 24
#define B_AX_RXTRIG_STATUS_MSK 0xff
#define B_AX_RXTRIG_BSS_COLOR_SH 16
#define B_AX_RXTRIG_BSS_COLOR_MSK 0x3f
#define B_AX_RXTRIG_DURATION_SH 0
#define B_AX_RXTRIG_DURATION_MSK 0xffff

#define R_AX_SR_CONTROL_DBG 0xCCB8
#define R_AX_SR_CONTROL_DBG_C1 0xECB8
#define B_AX_SR_RESTRICTED BIT(31)
#define B_AX_SR_PD_PTCL_SH 26
#define B_AX_SR_PD_PTCL_MSK 0x1f
#define B_AX_SR_PERIOD_PTCL_SH 16
#define B_AX_SR_PERIOD_PTCL_MSK 0x3ff
#define B_AX_SR_PD_WMAC_SH 11
#define B_AX_SR_PD_WMAC_MSK 0x1f
#define B_AX_SRPERIOD_WMAC_SH 0
#define B_AX_SRPERIOD_WMAC_MSK 0x7ff

#define R_AX_WMAC_TX_TF_INFO_0 0xCCD0
#define R_AX_WMAC_TX_TF_INFO_0_C1 0xECD0
#define B_AX_WMAC_TX_TF_INFO_SEL_SH 0
#define B_AX_WMAC_TX_TF_INFO_SEL_MSK 0x7

#define R_AX_WMAC_TX_TF_INFO_1 0xCCD4
#define R_AX_WMAC_TX_TF_INFO_1_C1 0xECD4
#define B_AX_WMAC_TX_TF_INFO_P0_SH 0
#define B_AX_WMAC_TX_TF_INFO_P0_MSK 0xffffffffL

#define R_AX_WMAC_TX_TF_INFO_2 0xCCD8
#define R_AX_WMAC_TX_TF_INFO_2_C1 0xECD8
#define B_AX_WMAC_TX_TF_INFO_P1_SH 0
#define B_AX_WMAC_TX_TF_INFO_P1_MSK 0xffffffffL

#define R_AX_CTRL_FRAME_CNT_CTRL 0xCCE0
#define R_AX_CTRL_FRAME_CNT_CTRL_C1 0xECE0
#define B_AX_WMAC_ALLCNT_RST BIT(16)
#define B_AX_CTRL_SUBTYPE_SH 12
#define B_AX_CTRL_SUBTYPE_MSK 0xf
#define B_AX_WMAC_WDATA_EN BIT(9)
#define B_AX_WMAC_ALLCNT_EN BIT(8)
#define B_AX_WMAC_CTRL_CNT_IDX_SH 0
#define B_AX_WMAC_CTRL_CNT_IDX_MSK 0xf

#define R_AX_CTRL_FRAME_CNT_SUBCTRL 0xCCE4
#define R_AX_CTRL_FRAME_CNT_SUBCTRL_C1 0xECE4
#define B_AX_CNT_INDEX_SH 8
#define B_AX_CNT_INDEX_MSK 0xf
#define B_AX_CNTRST BIT(1)
#define B_AX_CNTEN BIT(0)

#define R_AX_CTRL_FRAME_CNT_RPT 0xCCE8
#define R_AX_CTRL_FRAME_CNT_RPT_C1 0xECE8
#define B_AX_RX_CTRL_FRAME_CNT_SH 16
#define B_AX_RX_CTRL_FRAME_CNT_MSK 0xffff
#define B_AX_TX_CTRL_FRAME_CNT_SH 0
#define B_AX_TX_CTRL_FRAME_CNT_MSK 0xffff

#define R_AX_TMAC_ERR_IMR_ISR 0xCCEC
#define R_AX_TMAC_ERR_IMR_ISR_C1 0xECEC
#define B_AX_TMAC_TXPLCP_ERR_CLR BIT(19)
#define B_AX_TMAC_RESP_ERR_CLR BIT(18)
#define B_AX_TMAC_TXCTL_ERR_CLR BIT(17)
#define B_AX_TMAC_MACTX_ERR_CLR BIT(16)
#define B_AX_TMAC_TXPLCP_ERR BIT(14)
#define B_AX_TMAC_RESP_ERR BIT(13)
#define B_AX_TMAC_TXCTL_ERR BIT(12)
#define B_AX_TMAC_MACTX_ERR BIT(11)
#define B_AX_TMAC_TXPLCP_INT_EN BIT(10)
#define B_AX_TMAC_RESP_INT_EN BIT(9)
#define B_AX_TMAC_TXCTL_INT_EN BIT(8)
#define B_AX_TMAC_MACTX_INT_EN BIT(7)
#define B_AX_WMAC_INT_MODE BIT(6)
#define B_AX_TMAC_TIMETOUT_THR_SH 0
#define B_AX_TMAC_TIMETOUT_THR_MSK 0x3f

#define R_AX_WMAC_DEBUG_PORT 0xCCF0
#define R_AX_WMAC_DEBUG_PORT_C1 0xECF0
#define B_AX_WMAC_DEBUG_SH 0
#define B_AX_WMAC_DEBUG_MSK 0xffffffffL

#define R_AX_DBGSEL_TRXPTCL 0xCCF4
#define R_AX_DBGSEL_TRXPTCL_C1 0xECF4
#define B_AX_DBGSEL_TRIGCMD_SEL_SH 8
#define B_AX_DBGSEL_TRIGCMD_SEL_MSK 0xf
#define B_AX_DBGSEL_TRXPTCL_SH 0
#define B_AX_DBGSEL_TRXPTCL_MSK 0xff

#define R_AX_PHYINFO_ERR_IMR 0xCCFC
#define R_AX_PHYINFO_ERR_IMR_C1 0xECFC
#define B_AX_CSI_ON_TIMEOUT BIT(29)
#define B_AX_STS_ON_TIMEOUT BIT(28)
#define B_AX_DATA_ON_TIMEOUT BIT(27)
#define B_AX_OFDM_CCA_TIMEOUT BIT(26)
#define B_AX_CCK_CCA_TIMEOUT BIT(25)
#define B_AXC_PHY_TXON_TIMEOUT BIT(24)
#define B_AX_CSI_ON_TIMEOUT_INT_EN BIT(21)
#define B_AX_STS_ON_TIMEOUT_INT_EN BIT(20)
#define B_AX_DATA_ON_TIMEOUT_INT_EN BIT(19)
#define B_AX_OFDM_CCA_TIMEOUT_INT_EN BIT(18)
#define B_AX_CCK_CCA_TIMEOUT_INT_EN BIT(17)
#define B_AX_PHY_TXON_TIMEOUT_INT_EN BIT(16)
#define B_AX_PHYINTF_TIMEOUT_THR_SH 0
#define B_AX_PHYINTF_TIMEOUT_THR_MSK 0x3f

#define R_AX_BFMER_ASSOCIATED_SU0 0xCD00
#define R_AX_BFMER_ASSOCIATED_SU0_C1 0xED00
#define B_AX_MER_IGNORE_SU_BFMEE1_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE1_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE1_EN BIT(24)
#define B_AX_MER_SU_BFMEE1_MACID_SH 16
#define B_AX_MER_SU_BFMEE1_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE0_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE0_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE0_EN BIT(8)
#define B_AX_MER_SU_BFMEE0_MACID_SH 0
#define B_AX_MER_SU_BFMEE0_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU2 0xCD04
#define R_AX_BFMER_ASSOCIATED_SU2_C1 0xED04
#define B_AX_MER_IGNORE_SU_BFMEE3_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE3_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE3_EN BIT(24)
#define B_AX_MER_SU_BFMEE3_MACID_SH 16
#define B_AX_MER_SU_BFMEE3_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE2_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE2_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE2_EN BIT(8)
#define B_AX_MER_SU_BFMEE2_MACID_SH 0
#define B_AX_MER_SU_BFMEE2_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU4 0xCD08
#define R_AX_BFMER_ASSOCIATED_SU4_C1 0xED08
#define B_AX_MER_IGNORE_SU_BFMEE5_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE5_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE5_EN BIT(24)
#define B_AX_MER_SU_BFMEE5_MACID_SH 16
#define B_AX_MER_SU_BFMEE5_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE4_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE4_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE4_EN BIT(8)
#define B_AX_MER_SU_BFMEE4_MACID_SH 0
#define B_AX_MER_SU_BFMEE4_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU6 0xCD0C
#define R_AX_BFMER_ASSOCIATED_SU6_C1 0xED0C
#define B_AX_MER_IGNORE_SU_BFMEE7_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE7_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE7_EN BIT(24)
#define B_AX_MER_SU_BFMEE7_MACID_SH 16
#define B_AX_MER_SU_BFMEE7_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE6_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE6_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE6_EN BIT(8)
#define B_AX_MER_SU_BFMEE6_MACID_SH 0
#define B_AX_MER_SU_BFMEE6_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU8 0xCD10
#define R_AX_BFMER_ASSOCIATED_SU8_C1 0xED10
#define B_AX_MER_IGNORE_SU_BFMEE9_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE9_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE9_EN BIT(24)
#define B_AX_MER_SU_BFMEE9_MACID_SH 16
#define B_AX_MER_SU_BFMEE9_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE8_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE8_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE8_EN BIT(8)
#define B_AX_MER_SU_BFMEE8_MACID_SH 0
#define B_AX_MER_SU_BFMEE8_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU10 0xCD14
#define R_AX_BFMER_ASSOCIATED_SU10_C1 0xED14
#define B_AX_MER_IGNORE_SU_BFMEE11_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE11_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE11_EN BIT(24)
#define B_AX_MER_SU_BFMEE11_MACID_SH 16
#define B_AX_MER_SU_BFMEE11_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE10_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE10_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE10_EN BIT(8)
#define B_AX_MER_SU_BFMEE10_MACID_SH 0
#define B_AX_MER_SU_BFMEE10_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU12 0xCD18
#define R_AX_BFMER_ASSOCIATED_SU12_C1 0xED18
#define B_AX_MER_IGNORE_SU_BFMEE13_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE13_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE13_EN BIT(24)
#define B_AX_MER_SU_BFMEE13_MACID_SH 16
#define B_AX_MER_SU_BFMEE13_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE12_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE12_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE12_EN BIT(8)
#define B_AX_MER_SU_BFMEE12_MACID_SH 0
#define B_AX_MER_SU_BFMEE12_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU14 0xCD1C
#define R_AX_BFMER_ASSOCIATED_SU14_C1 0xED1C
#define B_AX_MER_IGNORE_SU_BFMEE15_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE15_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE15_EN BIT(24)
#define B_AX_MER_SU_BFMEE15_MACID_SH 16
#define B_AX_MER_SU_BFMEE15_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE14_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE14_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE14_EN BIT(8)
#define B_AX_MER_SU_BFMEE14_MACID_SH 0
#define B_AX_MER_SU_BFMEE14_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU0 0xCD20
#define R_AX_BFMER_ASSOCIATED_MU0_C1 0xED20
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE1 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE1_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE1_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE1_EN BIT(24)
#define B_AX_MER_MU_BFMEE1_MACID_SH 16
#define B_AX_MER_MU_BFMEE1_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE0 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE0_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE0_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE0_EN BIT(8)
#define B_AX_MER_MU_BFMEE0_MACID_SH 0
#define B_AX_MER_MU_BFMEE0_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU2 0xCD24
#define R_AX_BFMER_ASSOCIATED_MU2_C1 0xED24
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE3 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE3_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE3_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE3_EN BIT(24)
#define B_AX_MER_MU_BFMEE3_MACID_SH 16
#define B_AX_MER_MU_BFMEE3_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE2 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE2_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE2_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE2_EN BIT(8)
#define B_AX_MER_MU_BFMEE2_MACID_SH 0
#define B_AX_MER_MU_BFMEE2_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU4 0xCD28
#define R_AX_BFMER_ASSOCIATED_MU4_C1 0xED28
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE5 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE5_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE5_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE5_EN BIT(24)
#define B_AX_MER_MU_BFMEE5_MACID_SH 16
#define B_AX_MER_MU_BFMEE5_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE4 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE4_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE4_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE4_EN BIT(8)
#define B_AX_MER_MU_BFMEE4_MACID_SH 0
#define B_AX_MER_MU_BFMEE4_MACID_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX0 0xCD2C
#define R_AX_BFMER_CSI_BUFF_IDX0_C1 0xED2C
#define B_AX_MER_TXBF_CSI_BUFF_IDX0_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX0_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX0_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX0_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX0_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX0_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX1 0xCD30
#define R_AX_BFMER_CSI_BUFF_IDX1_C1 0xED30
#define B_AX_MER_TXBF_CSI_BUFF_IDX1_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX1_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX1_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX1_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX1_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX1_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX2 0xCD34
#define R_AX_BFMER_CSI_BUFF_IDX2_C1 0xED34
#define B_AX_MER_TXBF_CSI_BUFF_IDX2_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX2_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX2_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX2_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX2_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX2_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX3 0xCD38
#define R_AX_BFMER_CSI_BUFF_IDX3_C1 0xED38
#define B_AX_MER_TXBF_CSI_BUFF_IDX3_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX3_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX3_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX3_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX3_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX3_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX4 0xCD3C
#define R_AX_BFMER_CSI_BUFF_IDX4_C1 0xED3C
#define B_AX_MER_TXBF_CSI_BUFF_IDX4_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX4_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX4_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX4_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX4_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX4_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX5 0xCD40
#define R_AX_BFMER_CSI_BUFF_IDX5_C1 0xED40
#define B_AX_MER_TXBF_CSI_BUFF_IDX5_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX5_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX5_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX5_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX5_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX5_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX6 0xCD44
#define R_AX_BFMER_CSI_BUFF_IDX6_C1 0xED44
#define B_AX_MER_TXBF_CSI_BUFF_IDX6_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX6_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX6_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX6_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX6_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX6_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX7 0xCD48
#define R_AX_BFMER_CSI_BUFF_IDX7_C1 0xED48
#define B_AX_MER_TXBF_CSI_BUFF_IDX7_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX7_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX7_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX7_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX7_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX7_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX8 0xCD4C
#define R_AX_BFMER_CSI_BUFF_IDX8_C1 0xED4C
#define B_AX_MER_TXBF_CSI_BUFF_IDX8_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX8_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX8_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX8_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX8_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX8_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX9 0xCD50
#define R_AX_BFMER_CSI_BUFF_IDX9_C1 0xED50
#define B_AX_MER_TXBF_CSI_BUFF_IDX9_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX9_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX9_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX9_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX9_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX9_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX10 0xCD54
#define R_AX_BFMER_CSI_BUFF_IDX10_C1 0xED54
#define B_AX_MER_TXBF_CSI_BUFF_IDX10_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX10_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX10_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX10_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX10_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX10_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX11 0xCD58
#define R_AX_BFMER_CSI_BUFF_IDX11_C1 0xED58
#define B_AX_MER_TXBF_CSI_BUFF_IDX11_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX11_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX11_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX11_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX11_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX11_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX12 0xCD5C
#define R_AX_BFMER_CSI_BUFF_IDX12_C1 0xED5C
#define B_AX_MER_TXBF_CSI_BUFF_IDX12_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX12_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX12_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX12_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX12_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX12_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX13 0xCD60
#define R_AX_BFMER_CSI_BUFF_IDX13_C1 0xED60
#define B_AX_MER_TXBF_CSI_BUFF_IDX13_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX13_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX13_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX13_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX13_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX13_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX14 0xCD64
#define R_AX_BFMER_CSI_BUFF_IDX14_C1 0xED64
#define B_AX_MER_TXBF_CSI_BUFF_IDX14_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX14_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX14_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX14_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX14_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX14_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX15 0xCD68
#define R_AX_BFMER_CSI_BUFF_IDX15_C1 0xED68
#define B_AX_MER_TXBF_CSI_BUFF_IDX15_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX15_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX15_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX15_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX15_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX15_MSK 0xff

#define R_AX_BFMER_SND_DEBUG_CNT 0xCD6C
#define R_AX_BFMER_SND_DEBUG_CNT_C1 0xED6C
#define B_AX_DBG_BFMER_MIMO_CTRL_USER_SH 28
#define B_AX_DBG_BFMER_MIMO_CTRL_USER_MSK 0xf
#define B_AX_DBG_BFMER_MIMO_CTRL_HIGH_LOW_4BYTE BIT(27)
#define B_AX_DBG_BFMER_MIMO_CTRL_MODE_SH 25
#define B_AX_DBG_BFMER_MIMO_CTRL_MODE_MSK 0x3
#define B_AX_TB_CSI_ERR_FLAG_CLR BIT(24)
#define B_AX_BFMER_BBINFO_DBG_SEL_SH 21
#define B_AX_BFMER_BBINFO_DBG_SEL_MSK 0x7
#define B_AX_SND_DNGCNT_RST BIT(20)
#define B_AX_MER_SND_DBGCNT_SEL_SH 16
#define B_AX_MER_SND_DBGCNT_SEL_MSK 0xf
#define B_AX_TB_CSI_UL_LENGTH_ERR_FLAG BIT(8)
#define B_AX_MER_SND_DNGCNT_SH 0
#define B_AX_MER_SND_DNGCNT_MSK 0xff

#define R_AX_BFMER_UPD_MEE_PARA 0xCD70
#define R_AX_BFMER_UPD_MEE_PARA_C1 0xED70
#define B_AX_MER_UPDMEE_OPTION BIT(31)
#define B_AX_MER_UPDMEE_USERID_SH 16
#define B_AX_MER_UPDMEE_USERID_MSK 0xf
#define B_AX_MER_UPDMEE BIT(15)
#define B_AX_MER_UPDMEE_FT_SH 12
#define B_AX_MER_UPDMEE_FT_MSK 0x3
#define B_AX_MER_UPDMEE_BW_SH 10
#define B_AX_MER_UPDMEE_BW_MSK 0x3
#define B_AX_MER_UPDMEE_CB_SH 8
#define B_AX_MER_UPDMEE_CB_MSK 0x3
#define B_AX_MER_UPDMEE_NG_SH 6
#define B_AX_MER_UPDMEE_NG_MSK 0x3
#define B_AX_MER_UPDMEE_NR_SH 3
#define B_AX_MER_UPDMEE_NR_MSK 0x7
#define B_AX_MER_UPDMEE_NC_SH 0
#define B_AX_MER_UPDMEE_NC_MSK 0x7

#define R_AX_BFMER_RO_MEE_PARA 0xCD74
#define R_AX_BFMER_RO_MEE_PARA_C1 0xED74
#define B_AX_BFMER_CTRLINFO_MACID_SH 24
#define B_AX_BFMER_CTRLINFO_MACID_MSK 0xff
#define B_AX_RO_USER_ID_SEL_SH 16
#define B_AX_RO_USER_ID_SEL_MSK 0x1f
#define B_AX_BFMER_RO_MEE_PARA_FT_SH 12
#define B_AX_BFMER_RO_MEE_PARA_FT_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_BW_SH 10
#define B_AX_BFMER_RO_MEE_PARA_BW_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_CB_SH 8
#define B_AX_BFMER_RO_MEE_PARA_CB_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_NG_SH 6
#define B_AX_BFMER_RO_MEE_PARA_NG_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_NR_SH 3
#define B_AX_BFMER_RO_MEE_PARA_NR_MSK 0x7
#define B_AX_BFMER_RO_MEE_PARA_NC_SH 0
#define B_AX_BFMER_RO_MEE_PARA_NC_MSK 0x7

#define R_AX_BFMER_CTRL_0 0xCD78
#define R_AX_BFMER_CTRL_0_C1 0xED78
#define B_AX_BFMER_HE_CSI_OFFSET_SH 24
#define B_AX_BFMER_HE_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_VHT_CSI_OFFSET_SH 16
#define B_AX_BFMER_VHT_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_HT_CSI_OFFSET_SH 8
#define B_AX_BFMER_HT_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_NDP_BFEN BIT(2)
#define B_AX_BFMER_VHT_BFPRT_CHK BIT(0)

#define R_AX_BFMER_DEBUG_MIMO_CTRL_FIELD 0xCD7C
#define R_AX_BFMER_DEBUG_MIMO_CTRL_FIELD_C1 0xED7C
#define B_AX_DBG_BFMER_MIMO_CTRL_SH 0
#define B_AX_DBG_BFMER_MIMO_CTRL_MSK 0xffffffffL

#define R_AX_BFMEE_RESP_OPTION 0xCD80
#define R_AX_BFMEE_RESP_OPTION_C1 0xED80
#define B_AX_BFMEE_NDP_RX_STANDBY_TIMER_SH 24
#define B_AX_BFMEE_NDP_RX_STANDBY_TIMER_MSK 0xff
#define B_AX_BFMEE_BFRP_RX_STANDBY_TIMER_SH 20
#define B_AX_BFMEE_BFRP_RX_STANDBY_TIMER_MSK 0xf
#define B_AX_CSI_OFDMCCA BIT(19)
#define B_AX_MU_BFRPTSEG_SEL_SH 17
#define B_AX_MU_BFRPTSEG_SEL_MSK 0x3
#define B_AX_BFMEE_NDP_RXSTDBY_SEL BIT(16)
#define B_AX_BFMEE_MU_BFEE_DIS BIT(7)
#define B_AX_BFMEE_CHECK_RPTPOLL_MACID_DIS BIT(6)
#define B_AX_BFMEE_NOCHK_BFPOLL_BMP BIT(5)
#define B_AX_BFMEE_HE_NDPA_EN BIT(2)
#define B_AX_BFMEE_VHT_NDPA_EN BIT(1)
#define B_AX_BFMEE_HT_NDPA_EN BIT(0)

#define R_AX_BFMEE_OPTION 0xCD84
#define R_AX_BFMEE_OPTION_C1 0xED84
#define B_AX_CSI_IS_HE BIT(31)
#define B_AX_CSI_IS_VHT BIT(30)
#define B_AX_CSI_IS_HT BIT(29)
#define B_AX_CSI_RPT_LEN_SH 16
#define B_AX_CSI_RPT_LEN_MSK 0x1fff
#define B_AX_CSI_RPT_CNT_SH 0
#define B_AX_CSI_RPT_CNT_MSK 0x3ff

#define R_AX_TRXPTCL_RESP_CSI_CTRL_0 0xCD88
#define R_AX_TRXPTCL_RESP_CSI_CTRL_0_C1 0xED88
#define B_AX_BFMEE_CSISEQ_SEL BIT(29)
#define B_AX_BFMEE_BFPARAM_SEL BIT(28)
#define B_AX_BFMEE_OFDM_LEN_TH_SH 24
#define B_AX_BFMEE_OFDM_LEN_TH_MSK 0xf
#define B_AX_BFMEE_BF_PORT_SEL BIT(23)
#define B_AX_BFMEE_USE_NSTS BIT(22)
#define B_AX_BFMEE_CSI_RATE_FB_EN BIT(21)
#define B_AX_BFMEE_CSI_GID_SEL BIT(20)
#define B_AX_BFMEE_CSI_RSC_SH 18
#define B_AX_BFMEE_CSI_RSC_MSK 0x3
#define B_AX_BFMEE_CSI_FORCE_RETE_EN BIT(17)
#define B_AX_BFMEE_CSI_USE_NDPARATE BIT(16)
#define B_AX_BFMEE_CSI_WITHHTC_EN BIT(15)
#define B_AX_BFMEE_CSIINFO0_BF_EN BIT(14)
#define B_AX_BFMEE_CSIINFO0_STBC_EN BIT(13)
#define B_AX_BFMEE_CSIINFO0_LDPC_EN BIT(12)
#define B_AX_BFMEE_CSIINFO0_CS_SH 10
#define B_AX_BFMEE_CSIINFO0_CS_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_CB_SH 8
#define B_AX_BFMEE_CSIINFO0_CB_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_NG_SH 6
#define B_AX_BFMEE_CSIINFO0_NG_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_NR_SH 3
#define B_AX_BFMEE_CSIINFO0_NR_MSK 0x7
#define B_AX_BFMEE_CSIINFO0_NC_SH 0
#define B_AX_BFMEE_CSIINFO0_NC_MSK 0x7

#define R_AX_TRXPTCL_RESP_CSI_RRSC 0xCD8C
#define R_AX_TRXPTCL_RESP_CSI_RRSC_C1 0xED8C
#define B_AX_BFMEE_CSI_RRSC_BMAP_SH 0
#define B_AX_BFMEE_CSI_RRSC_BMAP_MSK 0xffffffffL

#define R_AX_TRXPTCL_RESP_CSI_RATE 0xCD90
#define R_AX_TRXPTCL_RESP_CSI_RATE_C1 0xED90
#define B_AX_BFMEE_HE_CSI_RATE_SH 16
#define B_AX_BFMEE_HE_CSI_RATE_MSK 0x7f
#define B_AX_BFMEE_VHT_CSI_RATE_SH 8
#define B_AX_BFMEE_VHT_CSI_RATE_MSK 0x7f
#define B_AX_BFMEE_HT_CSI_RATE_SH 0
#define B_AX_BFMEE_HT_CSI_RATE_MSK 0x7f

#define R_AX_TRXPTCL_RESP_CSI_CTRL_1 0xCD94
#define R_AX_TRXPTCL_RESP_CSI_CTRL_1_C1 0xED94
#define B_AX_BFMEE_CSIINFO1_BF_EN BIT(14)
#define B_AX_BFMEE_CSIINFO1_STBC_EN BIT(13)
#define B_AX_BFMEE_CSIINFO1_LDPC_EN BIT(12)
#define B_AX_BFMEE_CSIINFO1_CS_SH 10
#define B_AX_BFMEE_CSIINFO1_CS_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_CB_SH 8
#define B_AX_BFMEE_CSIINFO1_CB_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_NG_SH 6
#define B_AX_BFMEE_CSIINFO1_NG_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_NR_SH 3
#define B_AX_BFMEE_CSIINFO1_NR_MSK 0x7
#define B_AX_BFMEE_CSIINFO1_NC_SH 0
#define B_AX_BFMEE_CSIINFO1_NC_MSK 0x7

//
// RMAC
//

#define R_AX_RCR 0xCE00
#define R_AX_RCR_C1 0xEE00
#define B_AX_STOP_RX_IN BIT(11)
#define B_AX_DRV_INFO_SIZE_SH 8
#define B_AX_DRV_INFO_SIZE_MSK 0x7
#define B_AX_CH_EN_SH 0
#define B_AX_CH_EN_MSK 0xf

#define R_AX_DLK_PROTECT_CTL 0xCE02
#define R_AX_DLK_PROTECT_CTL_C1 0xEE02
#define B_AX_RX_DLK_CCA_TIME_SH 8
#define B_AX_RX_DLK_CCA_TIME_MSK 0xff
#define B_AX_RX_DLK_DATA_TIME_SH 4
#define B_AX_RX_DLK_DATA_TIME_MSK 0xf
#define B_AX_RX_DLK_RST_EN BIT(1)
#define B_AX_RX_DLK_INT_EN BIT(0)

#define R_AX_PLCP_HDR_FLTR 0xCE04
#define R_AX_PLCP_HDR_FLTR_C1 0xEE04
#define B_AX_DIS_CHK_MIN_LEN BIT(8)
#define B_AX_HE_SIGB_CRC_CHK BIT(6)
#define B_AX_VHT_MU_SIGB_CRC_CHK BIT(5)
#define B_AX_VHT_SU_SIGB_CRC_CHK BIT(4)
#define B_AX_SIGA_CRC_CHK BIT(3)
#define B_AX_LSIG_PARITY_CHK_EN BIT(2)
#define B_AX_CCK_SIG_CHK BIT(1)
#define B_AX_CCK_CRC_CHK BIT(0)

#define R_AX_RXGCK_CTRL 0xCE06
#define R_AX_RXGCK_CTRL_C1 0xEE06
#define B_AX_RXGCK_GCK_RATE_LIMIT_SH 8
#define B_AX_RXGCK_GCK_RATE_LIMIT_MSK 0x3
#define B_AX_RXGCK_ENTRY_DELAY_SH 4
#define B_AX_RXGCK_ENTRY_DELAY_MSK 0x7
#define B_AX_RXGCK_GCK_CYCLE_SH 2
#define B_AX_RXGCK_GCK_CYCLE_MSK 0x3
#define B_AX_RXGCK_CCA_EN BIT(1)
#define B_AX_DISGCLK BIT(0)

#define R_AX_RXPSF_CTRL 0xCE08
#define R_AX_RXPSF_CTRL_C1 0xEE08
#define B_AX_RXPSF_PKT_TIME_THR_SH 16
#define B_AX_RXPSF_PKT_TIME_THR_MSK 0xf
#define B_AX_RXPSF_ERRTHR_SH 12
#define B_AX_RXPSF_ERRTHR_MSK 0x7
#define B_AX_INVALID_WIDTH_SH 8
#define B_AX_INVALID_WIDTH_MSK 0x3
#define B_AX_RXPSF_PLCP_CHKEN BIT(4)
#define B_AX_RXPSF_BSS_CHKEN BIT(3)
#define B_AX_RXPSF_MHCHKEN BIT(2)
#define B_AX_RXPSF_CONT_ERRCHKEN BIT(1)

#define R_AX_RXPSF_MGT_TYPE 0xCE0E
#define R_AX_RXPSF_MGT_TYPE_C1 0xEE0E
#define B_AX_RXPSF_MGT15_PRSV BIT(15)
#define B_AX_RXPSF_MGT14_PRSV BIT(14)
#define B_AX_RXPSF_MGT13_PRSV BIT(13)
#define B_AX_RXPSF_MGT12_PRSV BIT(12)
#define B_AX_RXPSF_MGT11_PRSV BIT(11)
#define B_AX_RXPSF_MGT10_PRSV BIT(10)
#define B_AX_RXPSF_MGT9_PRSV BIT(9)
#define B_AX_RXPSF_MGT8_PRSV BIT(8)
#define B_AX_RXPSF_MGT7_PRSV BIT(7)
#define B_AX_RXPSF_MGT6_PRSV BIT(6)
#define B_AX_RXPSF_MGT5_PRSV BIT(5)
#define B_AX_RXPSF_MGT4_PRSV BIT(4)
#define B_AX_RXPSF_MGT3_PRSV BIT(3)
#define B_AX_RXPSF_MGT2_PRSV BIT(2)
#define B_AX_RXPSF_MGT1_PRSV BIT(1)
#define B_AX_RXPSF_MGT0_PRSV BIT(0)

#define R_AX_RXPSF_DATA_TYPE 0xCE0C
#define R_AX_RXPSF_DATA_TYPE_C1 0xEE0C
#define B_AX_RXPSF_DATA15_PRSV BIT(15)
#define B_AX_RXPSF_DATA14_PRSV BIT(14)
#define B_AX_RXPSF_DATA13_PRSV BIT(13)
#define B_AX_RXPSF_DATA12_PRSV BIT(12)
#define B_AX_RXPSF_DATA11_PRSV BIT(11)
#define B_AX_RXPSF_DATA10_PRSV BIT(10)
#define B_AX_RXPSF_DATA9_PRSV BIT(9)
#define B_AX_RXPSF_DATA8_PRSV BIT(8)
#define B_AX_RXPSF_DATA7_PRSV BIT(7)
#define B_AX_RXPSF_DATA6_PRSV BIT(6)
#define B_AX_RXPSF_DATA5_PRSV BIT(5)
#define B_AX_RXPSF_DATA4_PRSV BIT(4)
#define B_AX_RXPSF_DATA3_PRSV BIT(3)
#define B_AX_RXPSF_DATA2_PRSV BIT(2)
#define B_AX_RXPSF_DATA1_PRSV BIT(1)
#define B_AX_RXPSF_DATA_PRSV BIT(0)

#define R_AX_RXPSF_CTRL_TYPE 0xCE10
#define R_AX_RXPSF_CTRL_TYPE_C1 0xEE10
#define B_AX_RXPSF_CTRL_PRSV BIT(0)

#define R_AX_RXPSF_RATE 0xCE12
#define R_AX_RXPSF_RATE_C1 0xEE12
#define B_AX_RXPSF_HETB_PRSV BIT(8)
#define B_AX_RXPSF_HEMU_PRSV BIT(7)
#define B_AX_RXPSF_HEERSU_PRSV BIT(6)
#define B_AX_RXPSF_HESU_PRSV BIT(5)
#define B_AX_RXPSF_VHTMU_PRSV BIT(4)
#define B_AX_RXPSF_VHTSU_PRSV BIT(3)
#define B_AX_RXPSF_HT_PRSV BIT(2)
#define B_AX_RXPSF_OFDM_PRSV BIT(1)
#define B_AX_RXPSF_CCK_PRSV BIT(0)

#define R_AX_RXAI_CTRL 0xCE14
#define R_AX_RXAI_CTRL_C1 0xEE14
#define B_AX_RXAI_INFO_RST BIT(7)
#define B_AX_RXAI_PRTCT_REL BIT(6)
#define B_AX_RXAI_PRTCT_VIO BIT(5)
#define B_AX_RXAI_PRTCT_SEL BIT(1)
#define B_AX_RXAI_PRTCT_EN BIT(0)
#define B_AX_RXDFIFO_ADDR_CLR BIT(31)
#define B_AX_RXDFIFO_ADDR_MODE_SH 28
#define B_AX_RXDFIFO_ADDR_MODE_MSK 0x3
#define B_AX_RXDFIFO_RADDR_SH 8
#define B_AX_RXDFIFO_RADDR_MSK 0xff
#define B_AX_RXDFIFO_WADDR_SH 0
#define B_AX_RXDFIFO_WADDR_MSK 0xff

#define R_AX_RX_FIFO_CTRL 0xCE1C
#define R_AX_RX_FIFO_CTRL_C1 0xEE1C
#define B_AX_RXD_FIFO_MAX_LEV_CLR BIT(23)
#define B_AX_RXD_FIFO_MAX_LEV_SH 8
#define B_AX_RXD_FIFO_MAX_LEV_MSK 0xff
#define B_AX_RXD_FIFO_FULL_TH_SH 0
#define B_AX_RXD_FIFO_FULL_TH_MSK 0xff

#define R_AX_RX_FLTR_OPT 0xCE20
#define R_AX_RX_FLTR_OPT_C1 0xEE20
#define B_AX_UID_FILTER_SH 24
#define B_AX_UID_FILTER_MSK 0xff
#define B_AX_UNSPT_FILTER_SH 22
#define B_AX_UNSPT_FILTER_MSK 0x3
#define B_AX_RX_MPDU_MAX_LEN_SH 16
#define B_AX_RX_MPDU_MAX_LEN_MSK 0x3f
#define B_AX_A_FTM_REQ BIT(14)
#define B_AX_A_ERR_PKT BIT(13)
#define B_AX_A_UNSUP_PKT BIT(12)
#define B_AX_A_CRC32_ERR BIT(11)
#define B_AX_A_PWR_MGNT BIT(10)
#define B_AX_A_BCN_CHK_RULE_SH 8
#define B_AX_A_BCN_CHK_RULE_MSK 0x3
#define B_AX_A_BCN_CHK_EN BIT(7)
#define B_AX_A_MC_LIST_CAM_MATCH BIT(6)
#define B_AX_A_BC_CAM_MATCH BIT(5)
#define B_AX_A_UC_CAM_MATCH BIT(4)
#define B_AX_A_MC BIT(3)
#define B_AX_A_BC BIT(2)
#define B_AX_A_A1_MATCH BIT(1)
#define B_AX_SNIFFER_MODE BIT(0)

#define R_AX_CTRL_FLTR 0xCE24
#define R_AX_CTRL_FLTR_C1 0xEE24
#define B_AX_A_CTRL15_SH 30
#define B_AX_A_CTRL15_MSK 0x3
#define B_AX_A_CTRL14_SH 28
#define B_AX_A_CTRL14_MSK 0x3
#define B_AX_A_CTRL13_SH 26
#define B_AX_A_CTRL13_MSK 0x3
#define B_AX_A_CTRL12_SH 24
#define B_AX_A_CTRL12_MSK 0x3
#define B_AX_A_CTRL11_SH 22
#define B_AX_A_CTRL11_MSK 0x3
#define B_AX_A_CTRL10_SH 20
#define B_AX_A_CTRL10_MSK 0x3
#define B_AX_A_CTRL9_SH 18
#define B_AX_A_CTRL9_MSK 0x3
#define B_AX_A_CTRL8_SH 16
#define B_AX_A_CTRL8_MSK 0x3
#define B_AX_A_CTRL7_SH 14
#define B_AX_A_CTRL7_MSK 0x3
#define B_AX_A_CTRL6_SH 12
#define B_AX_A_CTRL6_MSK 0x3
#define B_AX_A_CTRL5_SH 10
#define B_AX_A_CTRL5_MSK 0x3
#define B_AX_A_CTRL4_SH 8
#define B_AX_A_CTRL4_MSK 0x3
#define B_AX_A_CTRL3_SH 6
#define B_AX_A_CTRL3_MSK 0x3
#define B_AX_A_CTRL2_SH 4
#define B_AX_A_CTRL2_MSK 0x3
#define B_AX_A_CTRL1_SH 2
#define B_AX_A_CTRL1_MSK 0x3
#define B_AX_A_CTRL0_SH 0
#define B_AX_A_CTRL0_MSK 0x3

#define R_AX_MGNT_FLTR 0xCE28
#define R_AX_MGNT_FLTR_C1 0xEE28
#define B_AX_A_MGNT15_SH 30
#define B_AX_A_MGNT15_MSK 0x3
#define B_AX_A_MGNT14_SH 28
#define B_AX_A_MGNT14_MSK 0x3
#define B_AX_A_MGNT13_SH 26
#define B_AX_A_MGNT13_MSK 0x3
#define B_AX_A_MGNT12_SH 24
#define B_AX_A_MGNT12_MSK 0x3
#define B_AX_A_MGNT11_SH 22
#define B_AX_A_MGNT11_MSK 0x3
#define B_AX_A_MGNT10_SH 20
#define B_AX_A_MGNT10_MSK 0x3
#define B_AX_A_MGNT9_SH 18
#define B_AX_A_MGNT9_MSK 0x3
#define B_AX_A_MGNT8_SH 16
#define B_AX_A_MGNT8_MSK 0x3
#define B_AX_A_MGNT7_SH 14
#define B_AX_A_MGNT7_MSK 0x3
#define B_AX_A_MGNT6_SH 12
#define B_AX_A_MGNT6_MSK 0x3
#define B_AX_A_MGNT5_SH 10
#define B_AX_A_MGNT5_MSK 0x3
#define B_AX_A_MGNT4_SH 8
#define B_AX_A_MGNT4_MSK 0x3
#define B_AX_A_MGNT3_SH 6
#define B_AX_A_MGNT3_MSK 0x3
#define B_AX_A_MGNT2_SH 4
#define B_AX_A_MGNT2_MSK 0x3
#define B_AX_A_MGNT1_SH 2
#define B_AX_A_MGNT1_MSK 0x3
#define B_AX_A_MGNT0_SH 0
#define B_AX_A_MGNT0_MSK 0x3

#define R_AX_DATA_FLTR 0xCE2C
#define R_AX_DATA_FLTR_C1 0xEE2C
#define B_AX_A_DATA15_SH 30
#define B_AX_A_DATA15_MSK 0x3
#define B_AX_A_DATA14_SH 28
#define B_AX_A_DATA14_MSK 0x3
#define B_AX_A_DATA13_SH 26
#define B_AX_A_DATA13_MSK 0x3
#define B_AX_A_DATA12_SH 24
#define B_AX_A_DATA12_MSK 0x3
#define B_AX_A_DATA11_SH 22
#define B_AX_A_DATA11_MSK 0x3
#define B_AX_A_DATA10_SH 20
#define B_AX_A_DATA10_MSK 0x3
#define B_AX_A_DATA9_SH 18
#define B_AX_A_DATA9_MSK 0x3
#define B_AX_A_DATA8_SH 16
#define B_AX_A_DATA8_MSK 0x3
#define B_AX_A_DATA7_SH 14
#define B_AX_A_DATA7_MSK 0x3
#define B_AX_A_DATA6_SH 12
#define B_AX_A_DATA6_MSK 0x3
#define B_AX_A_DATA5_SH 10
#define B_AX_A_DATA5_MSK 0x3
#define B_AX_A_DATA4_SH 8
#define B_AX_A_DATA4_MSK 0x3
#define B_AX_A_DATA3_SH 6
#define B_AX_A_DATA3_MSK 0x3
#define B_AX_A_DATA2_SH 4
#define B_AX_A_DATA2_MSK 0x3
#define B_AX_A_DATA1_SH 2
#define B_AX_A_DATA1_MSK 0x3
#define B_AX_A_DATA0_SH 0
#define B_AX_A_DATA0_MSK 0x3

#define R_AX_ZLENDEL_COUNT 0xCE30
#define R_AX_ZLENDEL_COUNT_C1 0xEE30
#define B_AX_RXD_DELI_NUM_SH 8
#define B_AX_RXD_DELI_NUM_MSK 0xff
#define B_AX_RXD_DELI_NUM_SEL_SH 4
#define B_AX_RXD_DELI_NUM_SEL_MSK 0xf
#define B_AX_RXD_DELI_UNIT_SH 1
#define B_AX_RXD_DELI_UNIT_MSK 0x3
#define B_AX_RXD_DELI_EN BIT(0)

#define R_AX_ADDR_CAM_CTRL 0xCE34
#define R_AX_ADDR_CAM_CTRL_C1 0xEE34
#define B_AX_ADDR_CAM_RANGE_SH 16
#define B_AX_ADDR_CAM_RANGE_MSK 0xff
#define B_AX_ADDR_CAM_CMPLIMT_SH 12
#define B_AX_ADDR_CAM_CMPLIMT_MSK 0xf
#define B_AX_ADDR_CAM_CLR BIT(8)
#define B_AX_ADDR_CAM_A2_B0_CHK BIT(2)
#define B_AX_ADDR_CAM_SRCH_PERPKT BIT(1)
#define B_AX_ADDR_CAM_EN BIT(0)

#define R_AX_ADDR_CAM_DIS_INFO 0xCE38
#define R_AX_ADDR_CAM_DIS_INFO_C1 0xEE38
#define B_AX_ADDR_CAM_DIS_MACID_SH 24
#define B_AX_ADDR_CAM_DIS_MACID_MSK 0xff
#define B_AX_ADDR_CAM_DIS_SEC_IDX_SH 16
#define B_AX_ADDR_CAM_DIS_SEC_IDX_MSK 0xff
#define B_AX_ADDR_CAM_DIS_PORT_SH 12
#define B_AX_ADDR_CAM_DIS_PORT_MSK 0x7
#define B_AX_ADDR_CAM_DIS_A3_HIT BIT(11)
#define B_AX_ADDR_CAM_DIS_A2_HIT BIT(10)
#define B_AX_ADDR_CAM_DIS_A1_HIT BIT(9)
#define B_AX_ADDR_CAM_DIS_CAM_HIT BIT(8)
#define B_AX_ADDR_CAM_DIS_IDX_SH 0
#define B_AX_ADDR_CAM_DIS_IDX_MSK 0xff

#define R_AX_RESPBA_CAM_CTRL 0xCE3C
#define R_AX_RESPBA_CAM_CTRL_C1 0xEE3C
#define B_AX_DEST_ENTRY_IDX_SH 12
#define B_AX_DEST_ENTRY_IDX_MSK 0xf
#define B_AX_SRC_ENTRY_IDX_SH 8
#define B_AX_SRC_ENTRY_IDX_MSK 0xf
#define B_AX_BACAM_SHIFT_POLL BIT(7)
#define B_AX_BACAM_ENT_CFG BIT(4)
#define B_AX_COMPL_VAL BIT(3)
#define B_AX_SSN_SEL BIT(2)
#define B_AX_BACAM_RST_SH 0
#define B_AX_BACAM_RST_MSK 0x3

#define R_AX_PPDU_STAT 0xCE40
#define R_AX_PPDU_STAT_C1 0xEE40
#define B_AX_PPDU_STAT_RPT_TRIG BIT(8)
#define B_AX_PPDU_STAT_RPT_CRC32 BIT(5)
#define B_AX_PPDU_STAT_RPT_ADDR BIT(4)
#define B_AX_APP_PLCP_HDR_RPT BIT(3)
#define B_AX_APP_RX_CNT_RPT BIT(2)
#define B_AX_APP_MAC_INFO_RPT BIT(1)
#define B_AX_PPDU_STAT_RPT_EN BIT(0)

#define R_AX_PPDU_STAT_ERR 0xCE42
#define R_AX_PPDU_STAT_ERR_C1 0xEE42
#define B_AX_PPDU_STAT_CNTR_SH 8
#define B_AX_PPDU_STAT_CNTR_MSK 0xff
#define B_AX_PPDU_STAT_BUSY_DROP BIT(2)
#define B_AX_PPDU_STAT_OVF BIT(1)
#define B_AX_PPDU_STAT_DROP BIT(0)

#define R_AX_CH_INFO_QRY 0xCE44
#define R_AX_CH_INFO_QRY_C1 0xEE44
#define B_AX_CH_INFO_TIME_SH 24
#define B_AX_CH_INFO_TIME_MSK 0xff
#define B_AX_CH_INFO_CNT_SH 21
#define B_AX_CH_INFO_CNT_MSK 0x7
#define B_AX_CH_INFO_REQUSTING BIT(20)
#define B_AX_CH_INFO_MGNT_FRM BIT(19)
#define B_AX_CH_INFO_CTRL_FRM BIT(18)
#define B_AX_CH_INFO_DATA_FRM BIT(17)
#define B_AX_CH_INFO_CRC_FAIL BIT(16)
#define B_AX_CH_INFO_MACID_SH 8
#define B_AX_CH_INFO_MACID_MSK 0xff
#define B_AX_CH_INFO_MODE_SH 1
#define B_AX_CH_INFO_MODE_MSK 0x7
#define B_AX_GET_CH_INFO_EN BIT(0)

#define R_AX_MACID_MATCH 0xCE48
#define R_AX_MACID_MATCH_C1 0xEE48
#define B_AX_MACID_MATCH_SH 8
#define B_AX_MACID_MATCH_MSK 0xff
#define B_AX_MACID_MATCH_MODE BIT(1)
#define B_AX_MACID_MATCH_EN BIT(0)

#define R_AX_RX_SR_CTRL 0xCE4A
#define R_AX_RX_SR_CTRL_C1 0xEE4A
#define B_AX_SR_OP_MODE_SH 4
#define B_AX_SR_OP_MODE_MSK 0x3
#define B_AX_SRG_CHK_EN BIT(2)
#define B_AX_SR_CTRL_PLCP_EN BIT(1)
#define B_AX_SR_EN BIT(0)

#define R_AX_BSSID_SRC_CTRL 0xCE4B
#define R_AX_BSSID_SRC_CTRL_C1 0xEE4B
#define B_AX_BSSID_MATCH BIT(3)
#define B_AX_PARTIAL_AID_MATCH BIT(2)
#define B_AX_BSSCOLOR_MATCH BIT(1)
#define B_AX_PLCP_SRC_EN BIT(0)

#define R_AX_SR_OBSS_PD 0xCE4C
#define R_AX_SR_OBSS_PD_C1 0xEE4C
#define B_AX_SRG_OBSS_PD_MAX_SH 24
#define B_AX_SRG_OBSS_PD_MAX_MSK 0xff
#define B_AX_SRG_OBSS_PD_MIN_SH 16
#define B_AX_SRG_OBSS_PD_MIN_MSK 0xff
#define B_AX_NONSRG_OBSS_PD_MAX_SH 8
#define B_AX_NONSRG_OBSS_PD_MAX_MSK 0xff
#define B_AX_NONSRG_OBSS_PD_MIN_SH 0
#define B_AX_NONSRG_OBSS_PD_MIN_MSK 0xff

#define R_AX_SR_BSSCOLOR_BITMAP 0xCE50
#define R_AX_SR_BSSCOLOR_BITMAP_C1 0xEE50
#define B_AX_BSSCOLOR_BITMAP_SH 0
#define B_AX_BSSCOLOR_BITMAP_MSK 0xffffffffL

#define R_AX_SR_BSSCOLOR_BITMAP_H 0xCE54
#define R_AX_SR_BSSCOLOR_BITMAP_H_C1 0xEE54
#define B_AX_BSSCOLOR_BITMAP_H_SH 0
#define B_AX_BSSCOLOR_BITMAP_H_MSK 0xffffffffL

#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP 0xCE58
#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP_C1 0xEE58
#define B_AX_PARTIAL_BSSID_BITMAP_SH 0
#define B_AX_PARTIAL_BSSID_BITMAP_MSK 0xffffffffL

#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP_H 0xCE5C
#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP_H_C1 0xEE5C
#define B_AX_PARTIAL_BSSID_BITMAP_H_SH 0
#define B_AX_PARTIAL_BSSID_BITMAP_H_MSK 0xffffffffL

#define R_AX_SEGMENT_CTRL 0xCE60
#define R_AX_SEGMENT_CTRL_C1 0xEE60
#define B_AX_SEG_LENGTH_SH 4
#define B_AX_SEG_LENGTH_MSK 0xf
#define B_AX_SEG_APP_ZERO BIT(1)
#define B_AX_SEG_EN BIT(0)

#define R_AX_CSIRPT_OPTION 0xCE64
#define R_AX_CSIRPT_OPTION_C1 0xEE64
#define B_AX_CSIRPT_CHKSUM_ERROR BIT(31)
#define B_AX_CSIRPT_BBLEN_LT_MAC BIT(30)
#define B_AX_CSIRPT_BBLEN_GT_MAC BIT(29)
#define B_AX_CSIPRT_HESU_AID_EN BIT(25)
#define B_AX_CSIPRT_VHTSU_AID_EN BIT(24)
#define B_AX_CSIRPT_FIFO_RESUME_THR_SH 16
#define B_AX_CSIRPT_FIFO_RESUME_THR_MSK 0xff
#define B_AX_CSIRPT_FIFO_PAUSE_THR_SH 8
#define B_AX_CSIRPT_FIFO_PAUSE_THR_MSK 0xff
#define B_AX_CSIRPT_LEN_MISMATCH BIT(6)
#define B_AX_CSIRPT_DMAFULL_IGNORE BIT(5)
#define B_AX_CSIRPT_FILTER_SH 3
#define B_AX_CSIRPT_FILTER_MSK 0x3
#define B_AX_CSIRPT_CHECKSUM_DIS BIT(2)
#define B_AX_CSIRPT_EMPTY_APPZERO BIT(1)
#define B_AX_CSIRPT_NDPPLCP_CHK_EN BIT(0)

#define R_AX_BSR_UPD_CTRL 0xCE68
#define R_AX_BSR_UPD_CTRL_C1 0xEE68
#define B_AX_QSIZE_UPD BIT(0)

#define R_AX_BCN_PSR_CTRL 0xCE80
#define R_AX_BCN_PSR_CTRL_C1 0xEE80
#define B_AX_BCN_HIT_INT_PORT_SH 4
#define B_AX_BCN_HIT_INT_PORT_MSK 0xf
#define B_AX_BCAID_HIT_INT_EN BIT(3)
#define B_AX_UNIAID_HIT_INT_EN BIT(2)
#define B_AX_IE_HIT_INT_EN BIT(1)
#define B_AX_TIM_PARSER_EN BIT(0)

#define R_AX_BCN_IECAM_CTRL 0xCE82
#define R_AX_BCN_IECAM_CTRL_C1 0xEE82
#define B_AX_BCN_PSR_BUSY BIT(15)
#define B_AX_BCN_IE_NOHIT_FRWD_SH 10
#define B_AX_BCN_IE_NOHIT_FRWD_MSK 0x3
#define B_AX_BCN_IE_HIT_FRWD_SH 8
#define B_AX_BCN_IE_HIT_FRWD_MSK 0x3
#define B_AX_BCN_IECAM_PORT_SH 4
#define B_AX_BCN_IECAM_PORT_MSK 0xf
#define B_AX_BCN_IECAM_CLR BIT(3)
#define B_AX_BCN_IE_NOHIT_FRWD_EN BIT(2)
#define B_AX_BCN_IE_HIT_FRWD_EN BIT(1)
#define B_AX_BCN_IECAM_EN BIT(0)

#define R_AX_BCN_PSR_RPT_P0 0xCE84
#define R_AX_BCN_PSR_RPT_P0_C1 0xEE84
#define B_AX_DTIM_CNT_P0_SH 24
#define B_AX_DTIM_CNT_P0_MSK 0xff
#define B_AX_DTIM_PERIOD_P0_SH 16
#define B_AX_DTIM_PERIOD_P0_MSK 0xff
#define B_AX_BCAID_HIT_P0 BIT(15)
#define B_AX_UNIAID_HIT_P0 BIT(14)
#define B_AX_IE_HIT_P0 BIT(13)
#define B_AX_TIM_ILEGAL_P0 BIT(12)
#define B_AX_RPT_VALID_P0 BIT(11)
#define B_AX_BCAID_P0_SH 0
#define B_AX_BCAID_P0_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P1 0xCE88
#define R_AX_BCN_PSR_RPT_P1_C1 0xEE88
#define B_AX_DTIM_CNT_P1_SH 24
#define B_AX_DTIM_CNT_P1_MSK 0xff
#define B_AX_DTIM_PERIOD_P1_SH 16
#define B_AX_DTIM_PERIOD_P1_MSK 0xff
#define B_AX_BCAID_HIT_P1 BIT(15)
#define B_AX_UNIAID_HIT_P1 BIT(14)
#define B_AX_IE_HIT_P1 BIT(13)
#define B_AX_TIM_ILEGAL_P1 BIT(12)
#define B_AX_RPT_VALID_P1 BIT(11)
#define B_AX_BCAID_P1_SH 0
#define B_AX_BCAID_P1_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P2 0xCE8C
#define R_AX_BCN_PSR_RPT_P2_C1 0xEE8C
#define B_AX_DTIM_CNT_P2_SH 24
#define B_AX_DTIM_CNT_P2_MSK 0xff
#define B_AX_DTIM_PERIOD_P2_SH 16
#define B_AX_DTIM_PERIOD_P2_MSK 0xff
#define B_AX_BCAID_HIT_P2 BIT(15)
#define B_AX_UNIAID_HIT_P2 BIT(14)
#define B_AX_IE_HIT_P2 BIT(13)
#define B_AX_TIM_ILEGAL_P2 BIT(12)
#define B_AX_RPT_VALID_P2 BIT(11)
#define B_AX_BCAID_P2_SH 0
#define B_AX_BCAID_P2_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P3 0xCE90
#define R_AX_BCN_PSR_RPT_P3_C1 0xEE90
#define B_AX_DTIM_CNT_P3_SH 24
#define B_AX_DTIM_CNT_P3_MSK 0xff
#define B_AX_DTIM_PERIOD_P3_SH 16
#define B_AX_DTIM_PERIOD_P3_MSK 0xff
#define B_AX_BCAID_HIT_P3 BIT(15)
#define B_AX_UNIAID_HIT_P3 BIT(14)
#define B_AX_IE_HIT_P3 BIT(13)
#define B_AX_TIM_ILEGAL_P3 BIT(12)
#define B_AX_RPT_VALID_P3 BIT(11)
#define B_AX_BCAID_P3_SH 0
#define B_AX_BCAID_P3_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P4 0xCE94
#define R_AX_BCN_PSR_RPT_P4_C1 0xEE94
#define B_AX_DTIM_CNT_P4_SH 24
#define B_AX_DTIM_CNT_P4_MSK 0xff
#define B_AX_DTIM_PERIOD_P4_SH 16
#define B_AX_DTIM_PERIOD_P4_MSK 0xff
#define B_AX_BCAID_HIT_P4 BIT(15)
#define B_AX_UNIAID_HIT_P4 BIT(14)
#define B_AX_IE_HIT_P4 BIT(13)
#define B_AX_TIM_ILEGAL_P4 BIT(12)
#define B_AX_RPT_VALID_P4 BIT(11)
#define B_AX_BCAID_P4_SH 0
#define B_AX_BCAID_P4_MSK 0x7ff

#define R_AX_PS_RXINFO 0xCEA0
#define R_AX_PS_RXINFO_C1 0xEEA0
#define B_AX_P4_RXCTRL BIT(14)
#define B_AX_P4_RXMGT BIT(13)
#define B_AX_P4_RXDATA BIT(12)
#define B_AX_P3_RXCTRL BIT(11)
#define B_AX_P3_RXMGT BIT(10)
#define B_AX_P3_RXDATA BIT(9)
#define B_AX_P2_RXCTRL BIT(8)
#define B_AX_P2_RXMGT BIT(7)
#define B_AX_P2_RXDATA BIT(6)
#define B_AX_P1_RXCTRL BIT(5)
#define B_AX_P1_RXMGT BIT(4)
#define B_AX_P1_RXDATA BIT(3)
#define B_AX_P0_RXCTRL BIT(2)
#define B_AX_P0_RXMGT BIT(1)
#define B_AX_P0_RXDATA BIT(0)

#define R_AX_PWRINT_CTRL 0xCEAC
#define R_AX_PWRINT_CTRL_C1 0xEEAC
#define B_AX_SEQNUM_MACID_SH 16
#define B_AX_SEQNUM_MACID_MSK 0xffff
#define B_AX_REF_MACID_SH 8
#define B_AX_REF_MACID_MSK 0x7f
#define B_AX_PWRINT_EN BIT(0)

#define R_AX_SPWR0 0xCEB0
#define R_AX_SPWR0_C1 0xEEB0
#define B_AX_MID_31TO0_SH 0
#define B_AX_MID_31TO0_MSK 0xffffffffL

#define R_AX_SPWR1 0xCEB4
#define R_AX_SPWR1_C1 0xEEB4
#define B_AX_MID_63TO32_SH 0
#define B_AX_MID_63TO32_MSK 0xffffffffL

#define R_AX_SPWR2 0xCEB8
#define R_AX_SPWR2_C1 0xEEB8
#define B_AX_MID_95O64_SH 0
#define B_AX_MID_95O64_MSK 0xffffffffL

#define R_AX_SPWR3 0xCEBC
#define R_AX_SPWR3_C1 0xEEBC
#define B_AX_MID_127TO96_SH 0
#define B_AX_MID_127TO96_MSK 0xffffffffL

#define R_AX_SNIFFER_MODE_CTRL 0xCEC0
#define R_AX_SNIFFER_MODE_CTRL_C1 0xEEC0
#define B_AX_AID3_ENABLE BIT(3)
#define B_AX_AID2_ENABLE BIT(2)
#define B_AX_AID1_ENABLE BIT(1)
#define B_AX_AID0_ENABLE BIT(0)

#define R_AX_SNIFFER_MODE_AID0 0xCEC4
#define R_AX_SNIFFER_MODE_AID0_C1 0xEEC4
#define B_AX_SNIFFER_MODE_AID1_SH 16
#define B_AX_SNIFFER_MODE_AID1_MSK 0xfff
#define B_AX_SNIFFER_MODE_AID0_SH 0
#define B_AX_SNIFFER_MODE_AID0_MSK 0xfff

#define R_AX_SNIFFER_MODE_AID1 0xCEC8
#define R_AX_SNIFFER_MODE_AID1_C1 0xEEC8
#define B_AX_SNIFFER_MODE_AID3_SH 16
#define B_AX_SNIFFER_MODE_AID3_MSK 0xfff
#define B_AX_SNIFFER_MODE_AID2_SH 0
#define B_AX_SNIFFER_MODE_AID2_MSK 0xfff

#define R_AX_RX_DBG_CNT_SEL 0xCEE0
#define R_AX_RX_DBG_CNT_SEL_C1 0xEEE0
#define B_AX_RX_DBG_CNT_SH 16
#define B_AX_RX_DBG_CNT_MSK 0xffff
#define B_AX_RXERR_RPT_RST BIT(8)
#define B_AX_RX_CNT_IDX_SH 0
#define B_AX_RX_CNT_IDX_MSK 0x3f

#define R_AX_RX_DBG_CNT_UD 0xCEE4
#define R_AX_RX_DBG_CNT_UD_C1 0xEEE4
#define B_AX_UD_W1S BIT(31)
#define B_AX_UD_CNT_MODE_SH 28
#define B_AX_UD_CNT_MODE_MSK 0x7
#define B_AX_UD_MSK_RUTONE BIT(27)
#define B_AX_UD_MSK_RATE BIT(26)
#define B_AX_UD_MSK_BSSID BIT(25)
#define B_AX_UD_MSK_FC BIT(24)
#define B_AX_UD_SUB_TYPE_SH 20
#define B_AX_UD_SUB_TYPE_MSK 0xf
#define B_AX_UD_TYPE_SH 18
#define B_AX_UD_TYPE_MSK 0x3
#define B_AX_UD_RUTONE_SH 15
#define B_AX_UD_RUTONE_MSK 0x7
#define B_AX_UD_SELECT_BSSID_SH 12
#define B_AX_UD_SELECT_BSSID_MSK 0x7
#define B_AX_UD_GI_TYPE_SH 9
#define B_AX_UD_GI_TYPE_MSK 0x7
#define B_AX_UD_RATE_SH 0
#define B_AX_UD_RATE_MSK 0x1ff

#define R_AX_RX_TIME_MON 0xCEEC
#define R_AX_RX_TIME_MON_C1 0xEEEC
#define B_AX_DMA_WR_TIME_SH 28
#define B_AX_DMA_WR_TIME_MSK 0xf
#define B_AX_DMA_WR_TIMEOUT_SH 24
#define B_AX_DMA_WR_TIMEOUT_MSK 0xf
#define B_AX_INTF_TIMEOUT_THR_SH 16
#define B_AX_INTF_TIMEOUT_THR_MSK 0x3f
#define B_AX_LATENCY_TIME_SH 8
#define B_AX_LATENCY_TIME_MSK 0xf
#define B_AX_CCA2DAT_TIME_SH 0
#define B_AX_CCA2DAT_TIME_MSK 0xff

#define R_AX_RX_STATE_MONITOR 0xCEF0
#define R_AX_RX_STATE_MONITOR_C1 0xEEF0
#define B_AX_STATE_CUR_SH 16
#define B_AX_STATE_CUR_MSK 0xffff
#define B_AX_STATE_NXT_SH 8
#define B_AX_STATE_NXT_MSK 0x3f
#define B_AX_STATE_UPD BIT(7)
#define B_AX_STATE_SEL_SH 0
#define B_AX_STATE_SEL_MSK 0x1f

#define R_AX_RMAC_ERR_ISR 0xCEF4
#define R_AX_RMAC_ERR_ISR_C1 0xEEF4
#define B_AX_RXERR_INTPS_EN BIT(31)
#define B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN BIT(19)
#define B_AX_RMAC_RX_TIMEOUT_INT_EN BIT(18)
#define B_AX_RMAC_CSI_TIMEOUT_INT_EN BIT(17)
#define B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN BIT(16)
#define B_AX_RMAC_CCA_TIMEOUT_INT_EN BIT(15)
#define B_AX_RMAC_DMA_TIMEOUT_INT_EN BIT(14)
#define B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN BIT(13)
#define B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN BIT(12)
#define B_AX_RMAC_RX_CSI_TIMEOUT_FLAG BIT(7)
#define B_AX_RMAC_RX_TIMEOUT_FLAG BIT(6)
#define B_AX_RMAC_CSI_TIMEOUT_FLAG BIT(5)
#define B_AX_RMAC_DATA_ON_TIMEOUT_FLAG BIT(4)
#define B_AX_RMAC_CCA_TIMEOUT_FLAG BIT(3)
#define B_AX_RMAC_DMA_TIMEOUT_FLAG BIT(2)
#define B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_FLAG BIT(1)
#define B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_FLAG BIT(0)

#define R_AX_RMAC_PLCP_MON 0xCEF8
#define R_AX_RMAC_PLCP_MON_C1 0xEEF8
#define B_AX_PCLP_MON_SEL_SH 28
#define B_AX_PCLP_MON_SEL_MSK 0xf
#define B_AX_PCLP_MON_CONT_SH 0
#define B_AX_PCLP_MON_CONT_MSK 0xfffffff

#define R_AX_RX_DEBUG_SELECT 0xCEFC
#define R_AX_RX_DEBUG_SELECT_C1 0xEEFC
#define B_AX_DEBUG_SEL_SH 0
#define B_AX_DEBUG_SEL_MSK 0xff

//
// PWR
//

#define R_AX_PWR_RATE_CTRL 0xD200
#define R_AX_PWR_RATE_CTRL_C1 0xF200
#define B_AX_TXPWR_CTRL_CLR BIT(31)
#define B_AX_FORCE_MODE_IDX_SH 28
#define B_AX_FORCE_MODE_IDX_MSK 0x7
#define B_AX_TXAGC_OFDM_REF_SH 19
#define B_AX_TXAGC_OFDM_REF_MSK 0x1ff
#define B_AX_TXAGC_CCK_REF_SH 10
#define B_AX_TXAGC_CCK_REF_MSK 0x1ff
#define B_AX_FORCE_PWR_BY_RATE_EN BIT(9)
#define B_AX_FORCE_PWR_BY_RATE_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_RATE_VALUE_MSK 0x1ff

#define R_AX_PWR_RATE_OFST_CTRL 0xD204
#define R_AX_PWR_RATE_OFST_CTRL_C1 0xF204
#define B_AX_TXAGC_TBL_RD BIT(26)
#define B_AX_TXAGC_TBL_RA_SH 20
#define B_AX_TXAGC_TBL_RA_MSK 0x3f
#define B_AX_TXAGC_CCK_HT_OFFSET_SH 16
#define B_AX_TXAGC_CCK_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_LEGACY_HT_OFFSET_SH 12
#define B_AX_TXAGC_LEGACY_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_HT_OFFSET_SH 8
#define B_AX_TXAGC_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_VHT_HT_OFFSET_SH 4
#define B_AX_TXAGC_VHT_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_HE_HT_OFFSET_SH 0
#define B_AX_TXAGC_HE_HT_OFFSET_MSK 0xf

#define R_AX_PWR_LMT_CTRL 0xD208
#define R_AX_PWR_LMT_CTRL_C1 0xF208
#define B_AX_FORCE_NORM_RSP_HE_TB_EN_ON BIT(24)
#define B_AX_FORCE_PWR_BY_LIMIT_BF0_EN BIT(23)
#define B_AX_FORCE_PWR_BY_LIMIT_BF1_EN BIT(22)
#define B_AX_TXAGC_PWR_LIM_BF0_EN BIT(21)
#define B_AX_TXAGC_PWR_LIM_BF1_EN BIT(20)
#define B_AX_TXAGC_BW20_BW40_OFFSET_SH 16
#define B_AX_TXAGC_BW20_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_RFBW_40M_OFFSET_SH 12
#define B_AX_TXAGC_RFBW_40M_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW80_BW40_OFFSET_SH 8
#define B_AX_TXAGC_BW80_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW160_BW40_OFFSET_SH 4
#define B_AX_TXAGC_BW160_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW80_80_BW40_OFFSET_SH 0
#define B_AX_TXAGC_BW80_80_BW40_OFFSET_MSK 0xf

#define R_AX_PWR_MACID_CTRL 0xD20C
#define R_AX_PWR_MACID_CTRL_C1 0xF20C
#define B_AX_TXAGC_PWR_BY_MACID_EN BIT(29)
#define B_AX_FORCE_CCA_PWR_TH_VALUE_EN BIT(28)
#define B_AX_FORCE_CCA_PWR_TH_VALUE_SH 20
#define B_AX_FORCE_CCA_PWR_TH_VALUE_MSK 0xff
#define B_AX_FORCE_CCA_PWR_TH_EN BIT(17)
#define B_AX_FORCE_PWR_BY_MACID_EN BIT(16)
#define B_AX_FORCE_PWR_BY_MACID_VALUE_SH 8
#define B_AX_FORCE_PWR_BY_MACID_VALUE_MSK 0xff
#define B_AX_FORCE_PWR_BY_MACID_VALUE_EN BIT(7)
#define B_AX_TXPWR_LIM_TBL_RD BIT(6)
#define B_AX_TXPWR_LIM_TBL_RA_SH 0
#define B_AX_TXPWR_LIM_TBL_RA_MSK 0x3f

#define R_AX_PWR_BF_CTRL 0xD210
#define R_AX_PWR_BF_CTRL_C1 0xF210
#define B_AX_TXAGC_BF_PWR_BOOST_EN BIT(31)
#define B_AX_HE_ER_SU_PWR_REDUCE_VAL_SH 19
#define B_AX_HE_ER_SU_PWR_REDUCE_VAL_MSK 0x3f
#define B_AX_HE_ER_SU_PWR_REDUCE_EN BIT(18)
#define B_AX_FORCE_PWR_BY_LIMIT_BFOFF_VALUE_SH 9
#define B_AX_FORCE_PWR_BY_LIMIT_BFOFF_VALUE_MSK 0x1ff
#define B_AX_FORCE_PWR_BY_LIMIT_BFON_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_LIMIT_BFON_VALUE_MSK 0x1ff

#define R_AX_PWR_MACID_REG 0xD214
#define R_AX_PWR_MACID_REG_C1 0xF214
#define B_AX_TXPWR_REG3_SH 24
#define B_AX_TXPWR_REG3_MSK 0xff
#define B_AX_TXPWR_REG2_SH 16
#define B_AX_TXPWR_REG2_MSK 0xff
#define B_AX_TXPWR_REG1_SH 8
#define B_AX_TXPWR_REG1_MSK 0xff
#define B_AX_TXPWR_REG0_SH 0
#define B_AX_TXPWR_REG0_MSK 0xff

#define R_AX_PWR_MACID_REG2 0xD218
#define R_AX_PWR_MACID_REG2_C1 0xF218
#define B_AX_TXPWR_BY_MACID_TBL_RD BIT(31)
#define B_AX_TXPWR_BY_MACID_TBL_RA_SH 24
#define B_AX_TXPWR_BY_MACID_TBL_RA_MSK 0x7f
#define B_AX_TXPWR_REG5_EN BIT(21)
#define B_AX_TXPWR_REG4_EN BIT(20)
#define B_AX_TXPWR_REG3_EN BIT(19)
#define B_AX_TXPWR_REG2_EN BIT(18)
#define B_AX_TXPWR_REG1_EN BIT(17)
#define B_AX_TXPWR_REG0_EN BIT(16)
#define B_AX_TXPWR_REG5_SH 8
#define B_AX_TXPWR_REG5_MSK 0xff
#define B_AX_TXPWR_REG4_SH 0
#define B_AX_TXPWR_REG4_MSK 0xff

#define R_AX_PWR_RU_LMT_CTRL 0xD21C
#define R_AX_PWR_RU_LMT_CTRL_C1 0xF21C
#define B_AX_TXAGC_LTE_SH 19
#define B_AX_TXAGC_LTE_MSK 0x1ff
#define B_AX_TXPWR_RU_LIM_EN BIT(18)
#define B_AX_TXPWR_RU_LIM_TBL_RD BIT(17)
#define B_AX_TXPWR_RU_LIM_TBL_RA_SH 11
#define B_AX_TXPWR_RU_LIM_TBL_RA_MSK 0x3f
#define B_AX_FORCE_PWR_BY_RU_LIMIT_EN BIT(10)
#define B_AX_FORCE_PWR_BY_RU_LIMIT_EN_VALUE BIT(9)
#define B_AX_FORCE_PWR_BY_RU_LIMIT_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_RU_LIMIT_VALUE_MSK 0x1ff

#define R_AX_PWR_COEXT_CTRL 0xD220
#define R_AX_PWR_COEXT_CTRL_C1 0xF220
#define B_AX_CCK_NORM_TERM_SH 18
#define B_AX_CCK_NORM_TERM_MSK 0x7f
#define B_AX_TXPWR_MAC_MAX_BND_SH 12
#define B_AX_TXPWR_MAC_MAX_BND_MSK 0x3f
#define B_AX_TXAGC_BT_SH 3
#define B_AX_TXAGC_BT_MSK 0x1ff
#define B_AX_TXAGC_LTE_EN BIT(2)
#define B_AX_TXAGC_BT_EN BIT(1)

#define R_AX_PWR_SWING_LEG_CTRL 0xD224
#define R_AX_PWR_SWING_LEG_CTRL_C1 0xF224
#define B_AX_TXBIAS_LEGACY_BELOW_TH_VAL_SH 29
#define B_AX_TXBIAS_LEGACY_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_LEGACY_OV_TH_VAL_SH 27
#define B_AX_TXBIAS_LEGACY_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_LEGACY_BELOW_TH_VAL_SH 23
#define B_AX_TXBBSWING_LEGACY_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_LEGACY_OV_TH_VAL_SH 19
#define B_AX_TXBBSWING_LEGACY_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_LEGACY_TH_SH 15
#define B_AX_TXBBSWING_TXBIAS_LEGACY_TH_MSK 0xf
#define B_AX_TXBIAS_CCK_BELOW_TH_VAL_SH 13
#define B_AX_TXBIAS_CCK_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_CCK_OV_TH_VAL_SH 11
#define B_AX_TXBIAS_CCK_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_CCK_BELOW_TH_VAL_SH 7
#define B_AX_TXBBSWING_CCK_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_CCK_OV_TH_VAL_SH 3
#define B_AX_TXBBSWING_CCK_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_CCK_TH_SH 0
#define B_AX_TXBBSWING_TXBIAS_CCK_TH_MSK 0x7

#define R_AX_PWR_SWING_VHT_CTRL 0xD228
#define R_AX_PWR_SWING_VHT_CTRL_C1 0xF228
#define B_AX_TXBIAS_VHT_OV_TH_VAL_SH 30
#define B_AX_TXBIAS_VHT_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_VHT_BELOW_TH_VAL_SH 26
#define B_AX_TXBBSWING_VHT_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_VHT_OV_TH_VAL_SH 22
#define B_AX_TXBBSWING_VHT_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_VHT_TH_SH 18
#define B_AX_TXBBSWING_TXBIAS_VHT_TH_MSK 0xf
#define B_AX_TXBIAS_HT_BELOW_TH_VAL_SH 16
#define B_AX_TXBIAS_HT_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_HT_OV_TH_VAL_SH 14
#define B_AX_TXBIAS_HT_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_HT_BELOW_TH_VAL_SH 10
#define B_AX_TXBBSWING_HT_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_HT_OV_TH_VAL_SH 6
#define B_AX_TXBBSWING_HT_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_HT_TH_SH 2
#define B_AX_TXBBSWING_TXBIAS_HT_TH_MSK 0xf

#define R_AX_PWR_SWING_HE_CTRL 0xD22C
#define R_AX_PWR_SWING_HE_CTRL_C1 0xF22C
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_BELOW_TH_VAL BIT(28)
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_OV_TH_VAL BIT(27)
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_TH_SH 23
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_CCK_BELOW_TH_VAL BIT(22)
#define B_AX_CFIR_BY_RATE_OFF_CCK_OV_TH_VAL BIT(21)
#define B_AX_CFIR_BY_RATE_OFF_CCK_TH_SH 18
#define B_AX_CFIR_BY_RATE_OFF_CCK_TH_MSK 0x7
#define B_AX_TXBIAS_HE_BELOW_TH_VAL_SH 16
#define B_AX_TXBIAS_HE_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_HE_OV_TH_VAL_SH 14
#define B_AX_TXBIAS_HE_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_HE_BELOW_TH_VAL_SH 10
#define B_AX_TXBBSWING_HE_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_HE_OV_TH_VAL_SH 6
#define B_AX_TXBBSWING_HE_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_HE_TH_SH 2
#define B_AX_TXBBSWING_TXBIAS_HE_TH_MSK 0xf
#define B_AX_TXBIAS_VHT_BELOW_TH_VAL_SH 0
#define B_AX_TXBIAS_VHT_BELOW_TH_VAL_MSK 0x3

#define R_AX_PWR_SWING_OTHER_CTRL0 0xD230
#define R_AX_PWR_SWING_OTHER_CTRL0_C1 0xF230
#define B_AX_DPD_BY_RATE_OFF_LEGACY_BELOW_TH_VAL BIT(28)
#define B_AX_DPD_BY_RATE_OFF_LEGACY_OV_TH_VAL BIT(27)
#define B_AX_DPD_BY_RATE_OFF_LEGACY_TH_SH 23
#define B_AX_DPD_BY_RATE_OFF_LEGACY_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_CCK_BELOW_TH_VAL BIT(22)
#define B_AX_DPD_BY_RATE_OFF_CCK_OV_TH_VAL BIT(21)
#define B_AX_DPD_BY_RATE_OFF_CCK_TH_SH 18
#define B_AX_DPD_BY_RATE_OFF_CCK_TH_MSK 0x7
#define B_AX_CFIR_BY_RATE_OFF_HE_BELOW_TH_VAL BIT(17)
#define B_AX_CFIR_BY_RATE_OFF_HE_OV_TH_VAL BIT(16)
#define B_AX_CFIR_BY_RATE_OFF_HE_TH_SH 12
#define B_AX_CFIR_BY_RATE_OFF_HE_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_VHT_BELOW_TH_VAL BIT(11)
#define B_AX_CFIR_BY_RATE_OFF_VHT_OV_TH_VAL BIT(10)
#define B_AX_CFIR_BY_RATE_OFF_VHT_TH_SH 6
#define B_AX_CFIR_BY_RATE_OFF_VHT_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_HT_BELOW_TH_VAL BIT(5)
#define B_AX_CFIR_BY_RATE_OFF_HT_OV_TH_VAL BIT(4)
#define B_AX_CFIR_BY_RATE_OFF_HT_TH_SH 0
#define B_AX_CFIR_BY_RATE_OFF_HT_TH_MSK 0xf

#define R_AX_PWR_SWING_OTHER_CTRL1 0xD234
#define R_AX_PWR_SWING_OTHER_CTRL1_C1 0xF234
#define B_AX_DPD_BY_RATE_OFF_SR_DONT_APPLY BIT(30)
#define B_AX_CFIR_BY_RATE_OFF_SR_DONT_APPLY BIT(29)
#define B_AX_TXBBSWING_TXBIAS_SR_DONT_APPLY BIT(28)
#define B_AX_DPD_BY_RATE_OFF_HE_BELOW_TH_VAL BIT(17)
#define B_AX_DPD_BY_RATE_OFF_HE_OV_TH_VAL BIT(16)
#define B_AX_DPD_BY_RATE_OFF_HE_TH_SH 12
#define B_AX_DPD_BY_RATE_OFF_HE_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_VHT_BELOW_TH_VAL BIT(11)
#define B_AX_DPD_BY_RATE_OFF_VHT_OV_TH_VAL BIT(10)
#define B_AX_DPD_BY_RATE_OFF_VHT_TH_SH 6
#define B_AX_DPD_BY_RATE_OFF_VHT_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_HT_BELOW_TH_VAL BIT(5)
#define B_AX_DPD_BY_RATE_OFF_HT_OV_TH_VAL BIT(4)
#define B_AX_DPD_BY_RATE_OFF_HT_TH_SH 0
#define B_AX_DPD_BY_RATE_OFF_HT_TH_MSK 0xf

#define R_AX_PWR_SR_CTRL0 0xD238
#define R_AX_PWR_SR_CTRL0_C1 0xF238
#define B_AX_SR_PWR_CTRL_DBG_EN BIT(31)
#define B_AX_SR_RATE_TBL_RD_MCS_TXDIFF_SH 20
#define B_AX_SR_RATE_TBL_RD_MCS_TXDIFF_MSK 0x1f
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_SEL BIT(19)
#define B_AX_TXPWR_SR_FORCE_OFF BIT(18)
#define B_AX_TXPWR_STA_UL_FORCE_OFF BIT(17)
#define B_AX_SR_TXPWR_PD_WITH_PD_MACID BIT(16)
#define B_AX_SR_RATE_MAP_TBL_RD BIT(15)
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_SH 11
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_MSK 0xf
#define B_AX_TXPWR_CTRL_NORM_RESP_DBG_EN BIT(10)
#define B_AX_TXAGC_PSEUDO_PWR_EN BIT(9)
#define B_AX_TXAGC_PSEUDO_PWR_SH 0
#define B_AX_TXAGC_PSEUDO_PWR_MSK 0x1ff

#define R_AX_PWR_SR_CTRL1 0xD23C
#define R_AX_PWR_SR_CTRL1_C1 0xF23C
#define B_AX_MCS_TH_HE_SH 24
#define B_AX_MCS_TH_HE_MSK 0xf
#define B_AX_MCS_TH_VHT_SH 20
#define B_AX_MCS_TH_VHT_MSK 0xf
#define B_AX_MCS_TH_HT_MOD8_SH 16
#define B_AX_MCS_TH_HT_MOD8_MSK 0xf
#define B_AX_MCS_TH_LEGACY_SH 12
#define B_AX_MCS_TH_LEGACY_MSK 0xf
#define B_AX_MCS_TH_CCK_SH 8
#define B_AX_MCS_TH_CCK_MSK 0xf
#define B_AX_TXPWR_REF_SH 0
#define B_AX_TXPWR_REF_MSK 0x7f

#define R_AX_PWR_UL_CTRL0 0xD240
#define R_AX_PWR_UL_CTRL0_C1 0xF240
#define B_AX_PL_TOLER_RANGE_SH 20
#define B_AX_PL_TOLER_RANGE_MSK 0x1ff
#define B_AX_PWR_BB_MIN_DBM_SH 9
#define B_AX_PWR_BB_MIN_DBM_MSK 0x1ff
#define B_AX_PWR_ERROR_TOLER_SH 0
#define B_AX_PWR_ERROR_TOLER_MSK 0xff

#define R_AX_PWR_UL_CTRL1 0xD244
#define R_AX_PWR_UL_CTRL1_C1 0xF244
#define B_AX_MACID3_SH 24
#define B_AX_MACID3_MSK 0x7f
#define B_AX_MACID2_SH 16
#define B_AX_MACID2_MSK 0x7f
#define B_AX_MACID1_SH 8
#define B_AX_MACID1_MSK 0x7f
#define B_AX_MACID0_SH 0
#define B_AX_MACID0_MSK 0x7f

#define R_AX_PWR_UL_CTRL2 0xD248
#define R_AX_PWR_UL_CTRL2_C1 0xF248
#define B_AX_CFO_COMP_SR_SH 24
#define B_AX_CFO_COMP_SR_MSK 0x7
#define B_AX_CFO_COMP_NORM_RESP_SH 20
#define B_AX_CFO_COMP_NORM_RESP_MSK 0x7
#define B_AX_CFO_COMP4_SH 16
#define B_AX_CFO_COMP4_MSK 0x7
#define B_AX_CFO_COMP3_SH 12
#define B_AX_CFO_COMP3_MSK 0x7
#define B_AX_CFO_COMP2_SH 8
#define B_AX_CFO_COMP2_MSK 0x7
#define B_AX_CFO_COMP1_SH 4
#define B_AX_CFO_COMP1_MSK 0x7
#define B_AX_CFO_COMP0_SH 0
#define B_AX_CFO_COMP0_MSK 0x7

#define R_AX_PWR_UL_CTRL3 0xD24C
#define R_AX_PWR_UL_CTRL3_C1 0xF24C
#define B_AX_TF_RDY_TXBF_FORCE_OFF BIT(22)
#define B_AX_FORCE_PL_UPPER_EN_EQUL_N_TX_DIVIDE2 BIT(21)
#define B_AX_FORCE_N_TX_DIVIDE2_OFF BIT(20)
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MAX_SH 11
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MAX_MSK 0x1ff
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MIN_SH 0
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MIN_MSK 0x1ff

#define R_AX_PWR_UL_CTRL4 0xD250
#define R_AX_PWR_UL_CTRL4_C1 0xF250
#define B_AX_STA_PWR_CTRL_RPL_LIM_MIN_SH 16
#define B_AX_STA_PWR_CTRL_RPL_LIM_MIN_MSK 0x3ff
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MAX_SH 8
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MAX_MSK 0xff
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MIN_SH 0
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MIN_MSK 0xff

#define R_AX_PWR_UL_CTRL5 0xD254
#define R_AX_PWR_UL_CTRL5_C1 0xF254
#define B_AX_FORCE_PL_UPPER_EN_VAL BIT(23)
#define B_AX_FORCE_PL_UPPER_EN_ON BIT(22)
#define B_AX_SR_TXPWR_RESP_RDY_FORCE_OFF BIT(15)
#define B_AX_SR_TXPWR_PD_RDY_FORCE_OFF BIT(14)
#define B_AX_SR_TXPWR_RATE_RDY_FORCE_OFF BIT(13)
#define B_AX_TF_RDY_FORCE_OFF BIT(12)
#define B_AX_TXCTRL_INFO_RDY_FORCE_OFF BIT(11)
#define B_AX_STA_PWR_CTRL_DBG_EN BIT(10)
#define B_AX_STA_PWR_CTRL_RPL_LIM_MAX_SH 0
#define B_AX_STA_PWR_CTRL_RPL_LIM_MAX_MSK 0x3ff

#define R_AX_PWR_UL_CTRL6 0xD258
#define R_AX_PWR_UL_CTRL6_C1 0xF258
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MIN_SH 24
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MIN_MSK 0x7f
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MAX_SH 16
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MAX_MSK 0x7f
#define B_AX_TXPWR_FORCE_RATE_EN BIT(12)
#define B_AX_TXPWR_FORCE_RATE_SH 0
#define B_AX_TXPWR_FORCE_RATE_MSK 0xfff

#define R_AX_PWR_NORM_FORCE0 0xD25C
#define R_AX_PWR_NORM_FORCE0_C1 0xF25C
#define B_AX_FORCE_MACID_EN BIT(30)
#define B_AX_FORCE_MACID_VALUE_SH 23
#define B_AX_FORCE_MACID_VALUE_MSK 0x7f
#define B_AX_FORCE_BW80P80_EN_EN BIT(22)
#define B_AX_FORCE_BW80P80_EN_VALUE BIT(21)
#define B_AX_FORCE_RF_BW_IDX_EN BIT(20)
#define B_AX_FORCE_RF_BW_IDX_VALUE_SH 18
#define B_AX_FORCE_RF_BW_IDX_VALUE_MSK 0x3
#define B_AX_FORCE_DCM_EN BIT(17)
#define B_AX_FORCE_DCM_VALUE BIT(16)
#define B_AX_FORCE_DBW_IDX_EN BIT(15)
#define B_AX_FORCE_DBW_IDX_VALUE_SH 13
#define B_AX_FORCE_DBW_IDX_VALUE_MSK 0x3
#define B_AX_FORCE_MAX_RATE_EN BIT(12)
#define B_AX_FORCE_MAX_RATE_VALUE_SH 0
#define B_AX_FORCE_MAX_RATE_VALUE_MSK 0xfff

#define R_AX_PWR_NORM_FORCE1 0xD260
#define R_AX_PWR_NORM_FORCE1_C1 0xF260
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_EN BIT(29)
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_SH 24
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_MSK 0x1f
#define B_AX_FORCE_HE_ER_SU_EN_EN BIT(23)
#define B_AX_FORCE_HE_ER_SU_EN_VALUE BIT(22)
#define B_AX_FORCE_MACID_CCA_TH_EN_EN BIT(21)
#define B_AX_FORCE_MACID_CCA_TH_EN_VALUE BIT(20)
#define B_AX_FORCE_BT_GRANT_EN BIT(19)
#define B_AX_FORCE_BT_GRANT_VALUE BIT(18)
#define B_AX_FORCE_RX_LTE_EN BIT(17)
#define B_AX_FORCE_RX_LTE_VALUE BIT(16)
#define B_AX_FORCE_TXBF_EN_EN BIT(15)
#define B_AX_FORCE_TXBF_EN_VALUE BIT(14)
#define B_AX_FORCE_TXSC_EN BIT(13)
#define B_AX_FORCE_TXSC_VALUE_SH 9
#define B_AX_FORCE_TXSC_VALUE_MSK 0xf
#define B_AX_FORCE_NTX_EN BIT(6)
#define B_AX_FORCE_NTX_VALUE BIT(5)
#define B_AX_FORCE_PWR_MODE_EN BIT(3)
#define B_AX_FORCE_PWR_MODE_VALUE_SH 0
#define B_AX_FORCE_PWR_MODE_VALUE_MSK 0x7

#define R_AX_PWR_SR_FORCE0 0xD264
#define R_AX_PWR_SR_FORCE0_C1 0xF264
#define B_AX_FORCE_SR_RESP_DCM_EN BIT(30)
#define B_AX_FORCE_SR_RESP_DCM_VALUE BIT(29)
#define B_AX_FORCE_SR_RATE_DCM_EN BIT(28)
#define B_AX_FORCE_SR_RATE_DCM_VALUE BIT(27)
#define B_AX_FORCE_SR_TXPWR_PD_EN BIT(26)
#define B_AX_FORCE_SR_TXPWR_PD_VALUE_SH 20
#define B_AX_FORCE_SR_TXPWR_PD_VALUE_MSK 0x3f
#define B_AX_FORCE_SR_RATE_IDX_EN BIT(19)
#define B_AX_FORCE_SR_RATE_IDX_VALUE_SH 7
#define B_AX_FORCE_SR_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_EN BIT(6)
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_VALUE_SH 0
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_VALUE_MSK 0x3f

#define R_AX_PWR_SR_FORCE1 0xD268
#define R_AX_PWR_SR_FORCE1_C1 0xF268
#define B_AX_FORCE_RPL_EN BIT(29)
#define B_AX_FORCE_RPL_VALUE_SH 20
#define B_AX_FORCE_RPL_VALUE_MSK 0x1ff
#define B_AX_FORCE_SR_RESP_RATE_IDX_EN BIT(19)
#define B_AX_FORCE_SR_RESP_RATE_IDX_VALUE_SH 7
#define B_AX_FORCE_SR_RESP_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_SR_RESP_TXPWR_PD_EN BIT(6)
#define B_AX_FORCE_SR_RESP_TXPWR_PD_VALUE_SH 0
#define B_AX_FORCE_SR_RESP_TXPWR_PD_VALUE_MSK 0x3f

#define R_AX_PWR_SR_FORCE2 0xD46C
#define R_AX_PWR_SR_FORCE2_C1 0xF46C
#define B_AX_FORCE_TF_AP_TX_PWR_EN BIT(31)
#define B_AX_FORCE_TF_AP_TX_PWR_VALUE_SH 25
#define B_AX_FORCE_TF_AP_TX_PWR_VALUE_MSK 0x3f
#define B_AX_FORCE_TF_RATE_IDX_EN BIT(24)
#define B_AX_FORCE_TF_RATE_IDX_VALUE_SH 12
#define B_AX_FORCE_TF_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_RPL_UPPER_EN_EN BIT(11)
#define B_AX_FORCE_RPL_UPPER_EN_VALUE BIT(10)
#define B_AX_FORCE_RPL_UPPER_EN BIT(9)
#define B_AX_FORCE_RPL_UPPER_VALUE_SH 0
#define B_AX_FORCE_RPL_UPPER_VALUE_MSK 0x1ff

#define R_AX_PWR_UL_FORCE0 0xD470
#define R_AX_PWR_UL_FORCE0_C1 0xF470
#define B_AX_FORCE_RU_ALLOC_EN BIT(24)
#define B_AX_FORCE_RU_ALLOC_VALUE_SH 16
#define B_AX_FORCE_RU_ALLOC_VALUE_MSK 0xff
#define B_AX_FORCE_TF_MACID_EN BIT(15)
#define B_AX_FORCE_TF_MACID_VALUE_SH 8
#define B_AX_FORCE_TF_MACID_VALUE_MSK 0x7f
#define B_AX_FORCE_TF_RSSI_TARGET_EN BIT(7)
#define B_AX_FORCE_TF_RSSI_TARGET_VALUE_SH 0
#define B_AX_FORCE_TF_RSSI_TARGET_VALUE_MSK 0x7f

#define R_AX_PWR_NORM_FORCE2 0xD474
#define R_AX_PWR_NORM_FORCE2_C1 0xF474
#define B_AX_FORCE_OUT_CCA_PWR_TH_EN_ON BIT(18)
#define B_AX_FORCE_OUT_CCA_PWR_TH_EN BIT(17)
#define B_AX_FORCE_OUT_CCA_PWR_TH_ON BIT(16)
#define B_AX_FORCE_OUT_CCA_PWR_TH_SH 8
#define B_AX_FORCE_OUT_CCA_PWR_TH_MSK 0xff
#define B_AX_TXPWR_CTRL_DBG_SEL_SH 0
#define B_AX_TXPWR_CTRL_DBG_SEL_MSK 0x3f

#define R_AX_PWR_UL_FORCE1 0xD278
#define R_AX_PWR_UL_FORCE1_C1 0xF278
#define B_AX_FORCE_OUT_CFO_COMP_ON BIT(31)
#define B_AX_FORCE_OUT_CFO_COMP_SH 28
#define B_AX_FORCE_OUT_CFO_COMP_MSK 0x7
#define B_AX_FORCE_OUT_ABORT_TX_IDX_ON BIT(27)
#define B_AX_FORCE_OUT_ABORT_TX_IDX_SH 25
#define B_AX_FORCE_OUT_ABORT_TX_IDX_MSK 0x3
#define B_AX_FORCE_OUT_MIN_TX_PWR_FLAG_ON BIT(24)
#define B_AX_FORCE_OUT_MIN_TX_PWR_FLAG BIT(23)
#define B_AX_FORCE_OUT_UPH_ON BIT(22)
#define B_AX_FORCE_OUT_UPH_SH 17
#define B_AX_FORCE_OUT_UPH_MSK 0x1f
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_ON BIT(16)
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_SH 10
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_MSK 0x3f
#define B_AX_FORCE_OUT_STA_TXPWR_BB_ON BIT(9)
#define B_AX_FORCE_OUT_STA_TXPWR_BB_SH 0
#define B_AX_FORCE_OUT_STA_TXPWR_BB_MSK 0x1ff

#define R_AX_PWR_NORM_FORCE3 0xD27C
#define R_AX_PWR_NORM_FORCE3_C1 0xF27C
#define B_AX_FORCE_OUT_TXAGC_BBSWING_ON BIT(31)
#define B_AX_FORCE_OUT_TXAGC_BBSWING_SH 27
#define B_AX_FORCE_OUT_TXAGC_BBSWING_MSK 0xf
#define B_AX_FORCE_OUT_TXBIAS_ON BIT(26)
#define B_AX_FORCE_OUT_TXBIAS_SH 24
#define B_AX_FORCE_OUT_TXBIAS_MSK 0x3
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_ON BIT(23)
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_SH 18
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_MSK 0x1f
#define B_AX_FORCE_OUT_TXPWR_BB_ON BIT(17)
#define B_AX_FORCE_OUT_TXPWR_BB_SH 8
#define B_AX_FORCE_OUT_TXPWR_BB_MSK 0x1ff
#define B_AX_FORCE_OUT_TXPWR_MAC_ON BIT(6)
#define B_AX_FORCE_OUT_TXPWR_MAC_SH 0
#define B_AX_FORCE_OUT_TXPWR_MAC_MSK 0x3f

#define R_AX_PWR_NORM_FORCE4 0xD280
#define R_AX_PWR_NORM_FORCE4_C1 0xF280
#define B_AX_FORCE_OUT_SR_DCM_ON BIT(25)
#define B_AX_FORCE_OUT_SR_DCM BIT(24)
#define B_AX_FORCE_OUT_SR_MCS_ON BIT(23)
#define B_AX_FORCE_OUT_SR_MCS_SH 11
#define B_AX_FORCE_OUT_SR_MCS_MSK 0xfff
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_ON BIT(10)
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_SH 4
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_MSK 0x3f
#define B_AX_FORCE_OUT_CFIR_BY_RATE_OFF_ON BIT(3)
#define B_AX_FORCE_OUT_CFIR_BY_RATE_OFF BIT(2)
#define B_AX_FORCE_OUT_DPD_BY_RATE_OFF_ON BIT(1)
#define B_AX_FORCE_OUT_DPD_BY_RATE_OFF BIT(0)
#define B_AX_RU_PWR_LIM_MUX_EN BIT(31)
#define B_AX_RU_NORM_EN BIT(30)
#define B_AX_RU_NORM_RU106_SH 20
#define B_AX_RU_NORM_RU106_MSK 0x3ff
#define B_AX_RU_NORM_RU52_SH 10
#define B_AX_RU_NORM_RU52_MSK 0x3ff
#define B_AX_RU_NORM_RU26_SH 0
#define B_AX_RU_NORM_RU26_MSK 0x3ff

#define R_AX_PWR_RST 0xD288
#define R_AX_PWR_RST_C1 0xF288
#define B_AX_FUNC_RST_FORCE_VAL BIT(1)
#define B_AX_FUNC_RST_FORCE_ON BIT(0)

#define R_AX_PWR_BY_RATE_TABLE0 0xD2C0
#define R_AX_PWR_BY_RATE_TABLE0_C1 0xF2C0
#define B_AX_TXAGC_CCK11M_SH 24
#define B_AX_TXAGC_CCK11M_MSK 0x7f
#define B_AX_TXAGC_CCK5P5M_SH 16
#define B_AX_TXAGC_CCK5P5M_MSK 0x7f
#define B_AX_TXAGC_CCK2M_SH 8
#define B_AX_TXAGC_CCK2M_MSK 0x7f
#define B_AX_TXAGC_CCK1M_SH 0
#define B_AX_TXAGC_CCK1M_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE1 0xD2C4
#define R_AX_PWR_BY_RATE_TABLE1_C1 0xF2C4
#define B_AX_TXAGC_LEGACY18M_SH 24
#define B_AX_TXAGC_LEGACY18M_MSK 0x7f
#define B_AX_TXAGC_LEGACY12M_SH 16
#define B_AX_TXAGC_LEGACY12M_MSK 0x7f
#define B_AX_TXAGC_LEGACY9M_SH 8
#define B_AX_TXAGC_LEGACY9M_MSK 0x7f
#define B_AX_TXAGC_LEGACY6M_SH 0
#define B_AX_TXAGC_LEGACY6M_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE2 0xD2C8
#define R_AX_PWR_BY_RATE_TABLE2_C1 0xF2C8
#define B_AX_TXAGC_LEGACY54M_SH 24
#define B_AX_TXAGC_LEGACY54M_MSK 0x7f
#define B_AX_TXAGC_LEGACY48M_SH 16
#define B_AX_TXAGC_LEGACY48M_MSK 0x7f
#define B_AX_TXAGC_LEGACY36M_SH 8
#define B_AX_TXAGC_LEGACY36M_MSK 0x7f
#define B_AX_TXAGC_LEGACY24M_SH 0
#define B_AX_TXAGC_LEGACY24M_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE3 0xD2CC
#define R_AX_PWR_BY_RATE_TABLE3_C1 0xF2CC
#define B_AX_TXAGC_NONLEGACY_MCS3_1NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS3_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS2_1NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS2_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS1_1NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS0_1NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_1NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE4 0xD2D0
#define R_AX_PWR_BY_RATE_TABLE4_C1 0xF2D0
#define B_AX_TXAGC_NONLEGACY_MCS7_1NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS7_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS6_1NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS6_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS5_1NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS5_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS4_1NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS4_1NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE5 0xD2D4
#define R_AX_PWR_BY_RATE_TABLE5_C1 0xF2D4
#define B_AX_TXAGC_NONLEGACY_MCS11_1NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS11_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS10_1NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS10_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS9_1NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS9_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS8_1NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS8_1NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE6 0xD2D8
#define R_AX_PWR_BY_RATE_TABLE6_C1 0xF2D8
#define B_AX_TXAGC_NONLEGACY_MCS4_DCM_1NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS4_DCM_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS3_DCM_1NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS3_DCM_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS1_DCM_1NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_DCM_1NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS0_DCM_1NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_DCM_1NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE7 0xD2DC
#define R_AX_PWR_BY_RATE_TABLE7_C1 0xF2DC
#define B_AX_TXAGC_NONLEGACY_MCS3_2NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS3_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS2_2NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS2_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS1_2NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS0_2NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_2NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE8 0xD2E0
#define R_AX_PWR_BY_RATE_TABLE8_C1 0xF2E0
#define B_AX_TXAGC_NONLEGACY_MCS7_2NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS7_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS6_2NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS6_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS5_2NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS5_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS4_2NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS4_2NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE9 0xD2E4
#define R_AX_PWR_BY_RATE_TABLE9_C1 0xF2E4
#define B_AX_TXAGC_NONLEGACY_MCS11_2NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS11_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS10_2NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS10_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS9_2NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS9_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS8_2NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS8_2NSS_MSK 0x7f

#define R_AX_PWR_BY_RATE_TABLE10 0xD2E8
#define R_AX_PWR_BY_RATE_TABLE10_C1 0xF2E8
#define B_AX_TXAGC_NONLEGACY_MCS4_DCM_2NSS_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS4_DCM_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS3_DCM_2NSS_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS3_DCM_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS1_DCM_2NSS_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_DCM_2NSS_MSK 0x7f
#define B_AX_TXAGC_NONLEGACY_MCS0_DCM_2NSS_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_DCM_2NSS_MSK 0x7f

#define R_AX_PWR_LMT_TABLE0 0xD2EC
#define R_AX_PWR_LMT_TABLE0_C1 0xF2EC
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW40M_SH 24
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_1TX_BW40M_SH 16
#define B_AX_TXAGC_MAX_CCK_1TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW20M_SH 8
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW20M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_1TX_BW20M_SH 0
#define B_AX_TXAGC_MAX_CCK_1TX_BW20M_MSK 0x7f

#define R_AX_PWR_LMT_TABLE1 0xD2F0
#define R_AX_PWR_LMT_TABLE1_C1 0xF2F0
#define B_AX_TXAGC_MAX_1TX_BF_BW20_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_0_SH 16
#define B_AX_TXAGC_MAX_1TX_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_1TX_SH 8
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_1TX_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_1TX_SH 0
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_1TX_MSK 0x7f

#define R_AX_PWR_LMT_TABLE2 0xD2F4
#define R_AX_PWR_LMT_TABLE2_C1 0xF2F4
#define B_AX_TXAGC_MAX_1TX_BF_BW20_2_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_2_SH 16
#define B_AX_TXAGC_MAX_1TX_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_1_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE3 0xD2F8
#define R_AX_PWR_LMT_TABLE3_C1 0xF2F8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_4_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_4_SH 16
#define B_AX_TXAGC_MAX_1TX_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_3_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_3_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_3_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE4 0xD2FC
#define R_AX_PWR_LMT_TABLE4_C1 0xF2FC
#define B_AX_TXAGC_MAX_1TX_BF_BW20_6_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_6_SH 16
#define B_AX_TXAGC_MAX_1TX_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_5_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_5_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE5 0xD300
#define R_AX_PWR_LMT_TABLE5_C1 0xF300
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_0_SH 16
#define B_AX_TXAGC_MAX_1TX_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_7_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_7_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_7_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_7_MSK 0x7f

#define R_AX_PWR_LMT_TABLE6 0xD304
#define R_AX_PWR_LMT_TABLE6_C1 0xF304
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_2_SH 16
#define B_AX_TXAGC_MAX_1TX_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_1_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE7 0xD308
#define R_AX_PWR_LMT_TABLE7_C1 0xF308
#define B_AX_TXAGC_MAX_1TX_BF_BW80_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW80_0_SH 16
#define B_AX_TXAGC_MAX_1TX_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_3_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_3_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_3_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE8 0xD30C
#define R_AX_PWR_LMT_TABLE8_C1 0xF30C
#define B_AX_TXAGC_MAX_1TX_BF_BW160_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW160_0_SH 16
#define B_AX_TXAGC_MAX_1TX_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW80_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW80_1_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW80_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW80_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE9 0xD310
#define R_AX_PWR_LMT_TABLE9_C1 0xF310
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2P5_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_2P5_SH 16
#define B_AX_TXAGC_MAX_1TX_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0P5_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0P5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_0P5_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_0P5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE10 0xD314
#define R_AX_PWR_LMT_TABLE10_C1 0xF314
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW40M_SH 24
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_2TX_BW40M_SH 16
#define B_AX_TXAGC_MAX_CCK_2TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW20M_SH 8
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW20M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_2TX_BW20M_SH 0
#define B_AX_TXAGC_MAX_CCK_2TX_BW20M_MSK 0x7f

#define R_AX_PWR_LMT_TABLE11 0xD318
#define R_AX_PWR_LMT_TABLE11_C1 0xF318
#define B_AX_TXAGC_MAX_2TX_BF_BW20_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_0_SH 16
#define B_AX_TXAGC_MAX_2TX_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_2TX_SH 8
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_2TX_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_2TX_SH 0
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_2TX_MSK 0x7f

#define R_AX_PWR_LMT_TABLE12 0xD31C
#define R_AX_PWR_LMT_TABLE12_C1 0xF31C
#define B_AX_TXAGC_MAX_2TX_BF_BW20_2_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_2_SH 16
#define B_AX_TXAGC_MAX_2TX_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_1_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE13 0xD320
#define R_AX_PWR_LMT_TABLE13_C1 0xF320
#define B_AX_TXAGC_MAX_2TX_BF_BW20_4_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_4_SH 16
#define B_AX_TXAGC_MAX_2TX_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_3_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_3_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_3_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE14 0xD324
#define R_AX_PWR_LMT_TABLE14_C1 0xF324
#define B_AX_TXAGC_MAX_2TX_BF_BW20_6_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_6_SH 16
#define B_AX_TXAGC_MAX_2TX_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_5_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_5_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_5_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE15 0xD328
#define R_AX_PWR_LMT_TABLE15_C1 0xF328
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_0_SH 16
#define B_AX_TXAGC_MAX_2TX_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_7_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_7_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_7_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_7_MSK 0x7f

#define R_AX_PWR_LMT_TABLE16 0xD32C
#define R_AX_PWR_LMT_TABLE16_C1 0xF32C
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_2_SH 16
#define B_AX_TXAGC_MAX_2TX_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW40_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW40_1_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW40_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE17 0xD330
#define R_AX_PWR_LMT_TABLE17_C1 0xF330
#define B_AX_TXAGC_MAX_2TX_BF_BW80_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW80_0_SH 16
#define B_AX_TXAGC_MAX_2TX_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW40_3_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW40_3_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_3_SH 0
#define B_AX_TXAGC_MAX_2TX_BW40_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE18 0xD334
#define R_AX_PWR_LMT_TABLE18_C1 0xF334
#define B_AX_TXAGC_MAX_2TX_BF_BW160_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW160_0_SH 16
#define B_AX_TXAGC_MAX_2TX_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW80_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW80_1_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW80_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW80_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE19 0xD338
#define R_AX_PWR_LMT_TABLE19_C1 0xF338
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2P5_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_2P5_SH 16
#define B_AX_TXAGC_MAX_2TX_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0P5_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0P5_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_0P5_SH 0
#define B_AX_TXAGC_MAX_2TX_BW40_0P5_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE0 0xD33C
#define R_AX_PWR_RU_LMT_TABLE0_C1 0xF33C
#define B_AX_RU_LIM_0TX_RU26_BW160_3_SH 24
#define B_AX_RU_LIM_0TX_RU26_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_2_SH 16
#define B_AX_RU_LIM_0TX_RU26_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_1_SH 8
#define B_AX_RU_LIM_0TX_RU26_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_0_SH 0
#define B_AX_RU_LIM_0TX_RU26_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE1 0xD340
#define R_AX_PWR_RU_LMT_TABLE1_C1 0xF340
#define B_AX_RU_LIM_0TX_RU26_BW160_7_SH 24
#define B_AX_RU_LIM_0TX_RU26_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_6_SH 16
#define B_AX_RU_LIM_0TX_RU26_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_5_SH 8
#define B_AX_RU_LIM_0TX_RU26_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU26_BW160_4_SH 0
#define B_AX_RU_LIM_0TX_RU26_BW160_4_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE2 0xD344
#define R_AX_PWR_RU_LMT_TABLE2_C1 0xF344
#define B_AX_RU_LIM_0TX_RU52_BW160_3_SH 24
#define B_AX_RU_LIM_0TX_RU52_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_2_SH 16
#define B_AX_RU_LIM_0TX_RU52_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_1_SH 8
#define B_AX_RU_LIM_0TX_RU52_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_0_SH 0
#define B_AX_RU_LIM_0TX_RU52_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE3 0xD348
#define R_AX_PWR_RU_LMT_TABLE3_C1 0xF348
#define B_AX_RU_LIM_0TX_RU52_BW160_7_SH 24
#define B_AX_RU_LIM_0TX_RU52_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_6_SH 16
#define B_AX_RU_LIM_0TX_RU52_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_5_SH 8
#define B_AX_RU_LIM_0TX_RU52_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU52_BW160_4_SH 0
#define B_AX_RU_LIM_0TX_RU52_BW160_4_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE4 0xD34C
#define R_AX_PWR_RU_LMT_TABLE4_C1 0xF34C
#define B_AX_RU_LIM_0TX_RU106_BW160_3_SH 24
#define B_AX_RU_LIM_0TX_RU106_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_2_SH 16
#define B_AX_RU_LIM_0TX_RU106_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_1_SH 8
#define B_AX_RU_LIM_0TX_RU106_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_0_SH 0
#define B_AX_RU_LIM_0TX_RU106_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE5 0xD350
#define R_AX_PWR_RU_LMT_TABLE5_C1 0xF350
#define B_AX_RU_LIM_0TX_RU106_BW160_7_SH 24
#define B_AX_RU_LIM_0TX_RU106_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_6_SH 16
#define B_AX_RU_LIM_0TX_RU106_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_5_SH 8
#define B_AX_RU_LIM_0TX_RU106_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_0TX_RU106_BW160_4_SH 0
#define B_AX_RU_LIM_0TX_RU106_BW160_4_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE6 0xD354
#define R_AX_PWR_RU_LMT_TABLE6_C1 0xF354
#define B_AX_RU_LIM_1TX_RU26_BW160_3_SH 24
#define B_AX_RU_LIM_1TX_RU26_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_2_SH 16
#define B_AX_RU_LIM_1TX_RU26_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_1_SH 8
#define B_AX_RU_LIM_1TX_RU26_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_0_SH 0
#define B_AX_RU_LIM_1TX_RU26_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE7 0xD358
#define R_AX_PWR_RU_LMT_TABLE7_C1 0xF358
#define B_AX_RU_LIM_1TX_RU26_BW160_7_SH 24
#define B_AX_RU_LIM_1TX_RU26_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_6_SH 16
#define B_AX_RU_LIM_1TX_RU26_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_5_SH 8
#define B_AX_RU_LIM_1TX_RU26_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU26_BW160_4_SH 0
#define B_AX_RU_LIM_1TX_RU26_BW160_4_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE8 0xD35C
#define R_AX_PWR_RU_LMT_TABLE8_C1 0xF35C
#define B_AX_RU_LIM_1TX_RU52_BW160_3_SH 24
#define B_AX_RU_LIM_1TX_RU52_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_2_SH 16
#define B_AX_RU_LIM_1TX_RU52_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_1_SH 8
#define B_AX_RU_LIM_1TX_RU52_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_0_SH 0
#define B_AX_RU_LIM_1TX_RU52_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE9 0xD360
#define R_AX_PWR_RU_LMT_TABLE9_C1 0xF360
#define B_AX_RU_LIM_1TX_RU52_BW160_7_SH 24
#define B_AX_RU_LIM_1TX_RU52_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_6_SH 16
#define B_AX_RU_LIM_1TX_RU52_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_5_SH 8
#define B_AX_RU_LIM_1TX_RU52_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU52_BW160_4_SH 0
#define B_AX_RU_LIM_1TX_RU52_BW160_4_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE10 0xD364
#define R_AX_PWR_RU_LMT_TABLE10_C1 0xF364
#define B_AX_RU_LIM_1TX_RU106_BW160_3_SH 24
#define B_AX_RU_LIM_1TX_RU106_BW160_3_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_2_SH 16
#define B_AX_RU_LIM_1TX_RU106_BW160_2_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_1_SH 8
#define B_AX_RU_LIM_1TX_RU106_BW160_1_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_0_SH 0
#define B_AX_RU_LIM_1TX_RU106_BW160_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE11 0xD368
#define R_AX_PWR_RU_LMT_TABLE11_C1 0xF368
#define B_AX_RU_LIM_1TX_RU106_BW160_7_SH 24
#define B_AX_RU_LIM_1TX_RU106_BW160_7_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_6_SH 16
#define B_AX_RU_LIM_1TX_RU106_BW160_6_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_5_SH 8
#define B_AX_RU_LIM_1TX_RU106_BW160_5_MSK 0x7f
#define B_AX_RU_LIM_1TX_RU106_BW160_4_SH 0
#define B_AX_RU_LIM_1TX_RU106_BW160_4_MSK 0x7f

#define R_AX_PWR_MACID_LMT_TABLE0 0xD36C
#define R_AX_PWR_MACID_LMT_TABLE0_C1 0xF36C
#define B_AX_MACID_0_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_0_TXPWR1_EN BIT(25)
#define B_AX_MACID_0_TXPWR0_EN BIT(24)
#define B_AX_MACID_0_CCA_PWR_TH_SH 16
#define B_AX_MACID_0_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_0_TXPWR1_SH 8
#define B_AX_MACID_0_TXPWR1_MSK 0xff
#define B_AX_MACID_0_TXPWR0_SH 0
#define B_AX_MACID_0_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE1 0xD370
#define R_AX_PWR_MACID_LMT_TABLE1_C1 0xF370
#define B_AX_MACID_1_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_1_TXPWR1_EN BIT(25)
#define B_AX_MACID_1_TXPWR0_EN BIT(24)
#define B_AX_MACID_1_CCA_PWR_TH_SH 16
#define B_AX_MACID_1_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_1_TXPWR1_SH 8
#define B_AX_MACID_1_TXPWR1_MSK 0xff
#define B_AX_MACID_1_TXPWR0_SH 0
#define B_AX_MACID_1_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE2 0xD374
#define R_AX_PWR_MACID_LMT_TABLE2_C1 0xF374
#define B_AX_MACID_2_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_2_TXPWR1_EN BIT(25)
#define B_AX_MACID_2_TXPWR0_EN BIT(24)
#define B_AX_MACID_2_CCA_PWR_TH_SH 16
#define B_AX_MACID_2_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_2_TXPWR1_SH 8
#define B_AX_MACID_2_TXPWR1_MSK 0xff
#define B_AX_MACID_2_TXPWR0_SH 0
#define B_AX_MACID_2_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE3 0xD378
#define R_AX_PWR_MACID_LMT_TABLE3_C1 0xF378
#define B_AX_MACID_3_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_3_TXPWR1_EN BIT(25)
#define B_AX_MACID_3_TXPWR0_EN BIT(24)
#define B_AX_MACID_3_CCA_PWR_TH_SH 16
#define B_AX_MACID_3_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_3_TXPWR1_SH 8
#define B_AX_MACID_3_TXPWR1_MSK 0xff
#define B_AX_MACID_3_TXPWR0_SH 0
#define B_AX_MACID_3_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE4 0xD37C
#define R_AX_PWR_MACID_LMT_TABLE4_C1 0xF37C
#define B_AX_MACID_4_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_4_TXPWR1_EN BIT(25)
#define B_AX_MACID_4_TXPWR0_EN BIT(24)
#define B_AX_MACID_4_CCA_PWR_TH_SH 16
#define B_AX_MACID_4_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_4_TXPWR1_SH 8
#define B_AX_MACID_4_TXPWR1_MSK 0xff
#define B_AX_MACID_4_TXPWR0_SH 0
#define B_AX_MACID_4_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE5 0xD380
#define R_AX_PWR_MACID_LMT_TABLE5_C1 0xF380
#define B_AX_MACID_5_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_5_TXPWR1_EN BIT(25)
#define B_AX_MACID_5_TXPWR0_EN BIT(24)
#define B_AX_MACID_5_CCA_PWR_TH_SH 16
#define B_AX_MACID_5_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_5_TXPWR1_SH 8
#define B_AX_MACID_5_TXPWR1_MSK 0xff
#define B_AX_MACID_5_TXPWR0_SH 0
#define B_AX_MACID_5_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE6 0xD384
#define R_AX_PWR_MACID_LMT_TABLE6_C1 0xF384
#define B_AX_MACID_6_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_6_TXPWR1_EN BIT(25)
#define B_AX_MACID_6_TXPWR0_EN BIT(24)
#define B_AX_MACID_6_CCA_PWR_TH_SH 16
#define B_AX_MACID_6_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_6_TXPWR1_SH 8
#define B_AX_MACID_6_TXPWR1_MSK 0xff
#define B_AX_MACID_6_TXPWR0_SH 0
#define B_AX_MACID_6_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE7 0xD388
#define R_AX_PWR_MACID_LMT_TABLE7_C1 0xF388
#define B_AX_MACID_7_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_7_TXPWR1_EN BIT(25)
#define B_AX_MACID_7_TXPWR0_EN BIT(24)
#define B_AX_MACID_7_CCA_PWR_TH_SH 16
#define B_AX_MACID_7_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_7_TXPWR1_SH 8
#define B_AX_MACID_7_TXPWR1_MSK 0xff
#define B_AX_MACID_7_TXPWR0_SH 0
#define B_AX_MACID_7_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE8 0xD38C
#define R_AX_PWR_MACID_LMT_TABLE8_C1 0xF38C
#define B_AX_MACID_8_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_8_TXPWR1_EN BIT(25)
#define B_AX_MACID_8_TXPWR0_EN BIT(24)
#define B_AX_MACID_8_CCA_PWR_TH_SH 16
#define B_AX_MACID_8_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_8_TXPWR1_SH 8
#define B_AX_MACID_8_TXPWR1_MSK 0xff
#define B_AX_MACID_8_TXPWR0_SH 0
#define B_AX_MACID_8_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE9 0xD390
#define R_AX_PWR_MACID_LMT_TABLE9_C1 0xF390
#define B_AX_MACID_9_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_9_TXPWR1_EN BIT(25)
#define B_AX_MACID_9_TXPWR0_EN BIT(24)
#define B_AX_MACID_9_CCA_PWR_TH_SH 16
#define B_AX_MACID_9_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_9_TXPWR1_SH 8
#define B_AX_MACID_9_TXPWR1_MSK 0xff
#define B_AX_MACID_9_TXPWR0_SH 0
#define B_AX_MACID_9_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE10 0xD394
#define R_AX_PWR_MACID_LMT_TABLE10_C1 0xF394
#define B_AX_MACID_10_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_10_TXPWR1_EN BIT(25)
#define B_AX_MACID_10_TXPWR0_EN BIT(24)
#define B_AX_MACID_10_CCA_PWR_TH_SH 16
#define B_AX_MACID_10_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_10_TXPWR1_SH 8
#define B_AX_MACID_10_TXPWR1_MSK 0xff
#define B_AX_MACID_10_TXPWR0_SH 0
#define B_AX_MACID_10_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE11 0xD398
#define R_AX_PWR_MACID_LMT_TABLE11_C1 0xF398
#define B_AX_MACID_11_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_11_TXPWR1_EN BIT(25)
#define B_AX_MACID_11_TXPWR0_EN BIT(24)
#define B_AX_MACID_11_CCA_PWR_TH_SH 16
#define B_AX_MACID_11_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_11_TXPWR1_SH 8
#define B_AX_MACID_11_TXPWR1_MSK 0xff
#define B_AX_MACID_11_TXPWR0_SH 0
#define B_AX_MACID_11_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE12 0xD39C
#define R_AX_PWR_MACID_LMT_TABLE12_C1 0xF39C
#define B_AX_MACID_12_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_12_TXPWR1_EN BIT(25)
#define B_AX_MACID_12_TXPWR0_EN BIT(24)
#define B_AX_MACID_12_CCA_PWR_TH_SH 16
#define B_AX_MACID_12_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_12_TXPWR1_SH 8
#define B_AX_MACID_12_TXPWR1_MSK 0xff
#define B_AX_MACID_12_TXPWR0_SH 0
#define B_AX_MACID_12_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE13 0xD3A0
#define R_AX_PWR_MACID_LMT_TABLE13_C1 0xF3A0
#define B_AX_MACID_13_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_13_TXPWR1_EN BIT(25)
#define B_AX_MACID_13_TXPWR0_EN BIT(24)
#define B_AX_MACID_13_CCA_PWR_TH_SH 16
#define B_AX_MACID_13_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_13_TXPWR1_SH 8
#define B_AX_MACID_13_TXPWR1_MSK 0xff
#define B_AX_MACID_13_TXPWR0_SH 0
#define B_AX_MACID_13_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE14 0xD3A4
#define R_AX_PWR_MACID_LMT_TABLE14_C1 0xF3A4
#define B_AX_MACID_14_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_14_TXPWR1_EN BIT(25)
#define B_AX_MACID_14_TXPWR0_EN BIT(24)
#define B_AX_MACID_14_CCA_PWR_TH_SH 16
#define B_AX_MACID_14_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_14_TXPWR1_SH 8
#define B_AX_MACID_14_TXPWR1_MSK 0xff
#define B_AX_MACID_14_TXPWR0_SH 0
#define B_AX_MACID_14_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE15 0xD3A8
#define R_AX_PWR_MACID_LMT_TABLE15_C1 0xF3A8
#define B_AX_MACID_15_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_15_TXPWR1_EN BIT(25)
#define B_AX_MACID_15_TXPWR0_EN BIT(24)
#define B_AX_MACID_15_CCA_PWR_TH_SH 16
#define B_AX_MACID_15_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_15_TXPWR1_SH 8
#define B_AX_MACID_15_TXPWR1_MSK 0xff
#define B_AX_MACID_15_TXPWR0_SH 0
#define B_AX_MACID_15_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE16 0xD3AC
#define R_AX_PWR_MACID_LMT_TABLE16_C1 0xF3AC
#define B_AX_MACID_16_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_16_TXPWR1_EN BIT(25)
#define B_AX_MACID_16_TXPWR0_EN BIT(24)
#define B_AX_MACID_16_CCA_PWR_TH_SH 16
#define B_AX_MACID_16_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_16_TXPWR1_SH 8
#define B_AX_MACID_16_TXPWR1_MSK 0xff
#define B_AX_MACID_16_TXPWR0_SH 0
#define B_AX_MACID_16_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE17 0xD3B0
#define R_AX_PWR_MACID_LMT_TABLE17_C1 0xF3B0
#define B_AX_MACID_17_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_17_TXPWR1_EN BIT(25)
#define B_AX_MACID_17_TXPWR0_EN BIT(24)
#define B_AX_MACID_17_CCA_PWR_TH_SH 16
#define B_AX_MACID_17_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_17_TXPWR1_SH 8
#define B_AX_MACID_17_TXPWR1_MSK 0xff
#define B_AX_MACID_17_TXPWR0_SH 0
#define B_AX_MACID_17_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE18 0xD3B4
#define R_AX_PWR_MACID_LMT_TABLE18_C1 0xF3B4
#define B_AX_MACID_18_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_18_TXPWR1_EN BIT(25)
#define B_AX_MACID_18_TXPWR0_EN BIT(24)
#define B_AX_MACID_18_CCA_PWR_TH_SH 16
#define B_AX_MACID_18_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_18_TXPWR1_SH 8
#define B_AX_MACID_18_TXPWR1_MSK 0xff
#define B_AX_MACID_18_TXPWR0_SH 0
#define B_AX_MACID_18_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE19 0xD3B8
#define R_AX_PWR_MACID_LMT_TABLE19_C1 0xF3B8
#define B_AX_MACID_19_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_19_TXPWR1_EN BIT(25)
#define B_AX_MACID_19_TXPWR0_EN BIT(24)
#define B_AX_MACID_19_CCA_PWR_TH_SH 16
#define B_AX_MACID_19_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_19_TXPWR1_SH 8
#define B_AX_MACID_19_TXPWR1_MSK 0xff
#define B_AX_MACID_19_TXPWR0_SH 0
#define B_AX_MACID_19_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE20 0xD3BC
#define R_AX_PWR_MACID_LMT_TABLE20_C1 0xF3BC
#define B_AX_MACID_20_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_20_TXPWR1_EN BIT(25)
#define B_AX_MACID_20_TXPWR0_EN BIT(24)
#define B_AX_MACID_20_CCA_PWR_TH_SH 16
#define B_AX_MACID_20_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_20_TXPWR1_SH 8
#define B_AX_MACID_20_TXPWR1_MSK 0xff
#define B_AX_MACID_20_TXPWR0_SH 0
#define B_AX_MACID_20_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE21 0xD3C0
#define R_AX_PWR_MACID_LMT_TABLE21_C1 0xF3C0
#define B_AX_MACID_21_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_21_TXPWR1_EN BIT(25)
#define B_AX_MACID_21_TXPWR0_EN BIT(24)
#define B_AX_MACID_21_CCA_PWR_TH_SH 16
#define B_AX_MACID_21_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_21_TXPWR1_SH 8
#define B_AX_MACID_21_TXPWR1_MSK 0xff
#define B_AX_MACID_21_TXPWR0_SH 0
#define B_AX_MACID_21_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE22 0xD3C4
#define R_AX_PWR_MACID_LMT_TABLE22_C1 0xF3C4
#define B_AX_MACID_22_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_22_TXPWR1_EN BIT(25)
#define B_AX_MACID_22_TXPWR0_EN BIT(24)
#define B_AX_MACID_22_CCA_PWR_TH_SH 16
#define B_AX_MACID_22_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_22_TXPWR1_SH 8
#define B_AX_MACID_22_TXPWR1_MSK 0xff
#define B_AX_MACID_22_TXPWR0_SH 0
#define B_AX_MACID_22_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE23 0xD3C8
#define R_AX_PWR_MACID_LMT_TABLE23_C1 0xF3C8
#define B_AX_MACID_23_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_23_TXPWR1_EN BIT(25)
#define B_AX_MACID_23_TXPWR0_EN BIT(24)
#define B_AX_MACID_23_CCA_PWR_TH_SH 16
#define B_AX_MACID_23_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_23_TXPWR1_SH 8
#define B_AX_MACID_23_TXPWR1_MSK 0xff
#define B_AX_MACID_23_TXPWR0_SH 0
#define B_AX_MACID_23_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE24 0xD3CC
#define R_AX_PWR_MACID_LMT_TABLE24_C1 0xF3CC
#define B_AX_MACID_24_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_24_TXPWR1_EN BIT(25)
#define B_AX_MACID_24_TXPWR0_EN BIT(24)
#define B_AX_MACID_24_CCA_PWR_TH_SH 16
#define B_AX_MACID_24_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_24_TXPWR1_SH 8
#define B_AX_MACID_24_TXPWR1_MSK 0xff
#define B_AX_MACID_24_TXPWR0_SH 0
#define B_AX_MACID_24_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE25 0xD3D0
#define R_AX_PWR_MACID_LMT_TABLE25_C1 0xF3D0
#define B_AX_MACID_25_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_25_TXPWR1_EN BIT(25)
#define B_AX_MACID_25_TXPWR0_EN BIT(24)
#define B_AX_MACID_25_CCA_PWR_TH_SH 16
#define B_AX_MACID_25_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_25_TXPWR1_SH 8
#define B_AX_MACID_25_TXPWR1_MSK 0xff
#define B_AX_MACID_25_TXPWR0_SH 0
#define B_AX_MACID_25_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE26 0xD3D4
#define R_AX_PWR_MACID_LMT_TABLE26_C1 0xF3D4
#define B_AX_MACID_26_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_26_TXPWR1_EN BIT(25)
#define B_AX_MACID_26_TXPWR0_EN BIT(24)
#define B_AX_MACID_26_CCA_PWR_TH_SH 16
#define B_AX_MACID_26_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_26_TXPWR1_SH 8
#define B_AX_MACID_26_TXPWR1_MSK 0xff
#define B_AX_MACID_26_TXPWR0_SH 0
#define B_AX_MACID_26_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE27 0xD3D8
#define R_AX_PWR_MACID_LMT_TABLE27_C1 0xF3D8
#define B_AX_MACID_27_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_27_TXPWR1_EN BIT(25)
#define B_AX_MACID_27_TXPWR0_EN BIT(24)
#define B_AX_MACID_27_CCA_PWR_TH_SH 16
#define B_AX_MACID_27_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_27_TXPWR1_SH 8
#define B_AX_MACID_27_TXPWR1_MSK 0xff
#define B_AX_MACID_27_TXPWR0_SH 0
#define B_AX_MACID_27_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE28 0xD3DC
#define R_AX_PWR_MACID_LMT_TABLE28_C1 0xF3DC
#define B_AX_MACID_28_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_28_TXPWR1_EN BIT(25)
#define B_AX_MACID_28_TXPWR0_EN BIT(24)
#define B_AX_MACID_28_CCA_PWR_TH_SH 16
#define B_AX_MACID_28_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_28_TXPWR1_SH 8
#define B_AX_MACID_28_TXPWR1_MSK 0xff
#define B_AX_MACID_28_TXPWR0_SH 0
#define B_AX_MACID_28_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE29 0xD3E0
#define R_AX_PWR_MACID_LMT_TABLE29_C1 0xF3E0
#define B_AX_MACID_29_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_29_TXPWR1_EN BIT(25)
#define B_AX_MACID_29_TXPWR0_EN BIT(24)
#define B_AX_MACID_29_CCA_PWR_TH_SH 16
#define B_AX_MACID_29_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_29_TXPWR1_SH 8
#define B_AX_MACID_29_TXPWR1_MSK 0xff
#define B_AX_MACID_29_TXPWR0_SH 0
#define B_AX_MACID_29_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE30 0xD3E4
#define R_AX_PWR_MACID_LMT_TABLE30_C1 0xF3E4
#define B_AX_MACID_30_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_30_TXPWR1_EN BIT(25)
#define B_AX_MACID_30_TXPWR0_EN BIT(24)
#define B_AX_MACID_30_CCA_PWR_TH_SH 16
#define B_AX_MACID_30_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_30_TXPWR1_SH 8
#define B_AX_MACID_30_TXPWR1_MSK 0xff
#define B_AX_MACID_30_TXPWR0_SH 0
#define B_AX_MACID_30_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE31 0xD3E8
#define R_AX_PWR_MACID_LMT_TABLE31_C1 0xF3E8
#define B_AX_MACID_31_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_31_TXPWR1_EN BIT(25)
#define B_AX_MACID_31_TXPWR0_EN BIT(24)
#define B_AX_MACID_31_CCA_PWR_TH_SH 16
#define B_AX_MACID_31_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_31_TXPWR1_SH 8
#define B_AX_MACID_31_TXPWR1_MSK 0xff
#define B_AX_MACID_31_TXPWR0_SH 0
#define B_AX_MACID_31_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE32 0xD3EC
#define R_AX_PWR_MACID_LMT_TABLE32_C1 0xF3EC
#define B_AX_MACID_32_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_32_TXPWR1_EN BIT(25)
#define B_AX_MACID_32_TXPWR0_EN BIT(24)
#define B_AX_MACID_32_CCA_PWR_TH_SH 16
#define B_AX_MACID_32_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_32_TXPWR1_SH 8
#define B_AX_MACID_32_TXPWR1_MSK 0xff
#define B_AX_MACID_32_TXPWR0_SH 0
#define B_AX_MACID_32_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE33 0xD3F0
#define R_AX_PWR_MACID_LMT_TABLE33_C1 0xF3F0
#define B_AX_MACID_33_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_33_TXPWR1_EN BIT(25)
#define B_AX_MACID_33_TXPWR0_EN BIT(24)
#define B_AX_MACID_33_CCA_PWR_TH_SH 16
#define B_AX_MACID_33_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_33_TXPWR1_SH 8
#define B_AX_MACID_33_TXPWR1_MSK 0xff
#define B_AX_MACID_33_TXPWR0_SH 0
#define B_AX_MACID_33_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE34 0xD3F4
#define R_AX_PWR_MACID_LMT_TABLE34_C1 0xF3F4
#define B_AX_MACID_34_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_34_TXPWR1_EN BIT(25)
#define B_AX_MACID_34_TXPWR0_EN BIT(24)
#define B_AX_MACID_34_CCA_PWR_TH_SH 16
#define B_AX_MACID_34_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_34_TXPWR1_SH 8
#define B_AX_MACID_34_TXPWR1_MSK 0xff
#define B_AX_MACID_34_TXPWR0_SH 0
#define B_AX_MACID_34_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE35 0xD3F8
#define R_AX_PWR_MACID_LMT_TABLE35_C1 0xF3F8
#define B_AX_MACID_35_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_35_TXPWR1_EN BIT(25)
#define B_AX_MACID_35_TXPWR0_EN BIT(24)
#define B_AX_MACID_35_CCA_PWR_TH_SH 16
#define B_AX_MACID_35_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_35_TXPWR1_SH 8
#define B_AX_MACID_35_TXPWR1_MSK 0xff
#define B_AX_MACID_35_TXPWR0_SH 0
#define B_AX_MACID_35_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE36 0xD3FC
#define R_AX_PWR_MACID_LMT_TABLE36_C1 0xF3FC
#define B_AX_MACID_36_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_36_TXPWR1_EN BIT(25)
#define B_AX_MACID_36_TXPWR0_EN BIT(24)
#define B_AX_MACID_36_CCA_PWR_TH_SH 16
#define B_AX_MACID_36_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_36_TXPWR1_SH 8
#define B_AX_MACID_36_TXPWR1_MSK 0xff
#define B_AX_MACID_36_TXPWR0_SH 0
#define B_AX_MACID_36_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE37 0xD400
#define R_AX_PWR_MACID_LMT_TABLE37_C1 0xF400
#define B_AX_MACID_37_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_37_TXPWR1_EN BIT(25)
#define B_AX_MACID_37_TXPWR0_EN BIT(24)
#define B_AX_MACID_37_CCA_PWR_TH_SH 16
#define B_AX_MACID_37_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_37_TXPWR1_SH 8
#define B_AX_MACID_37_TXPWR1_MSK 0xff
#define B_AX_MACID_37_TXPWR0_SH 0
#define B_AX_MACID_37_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE38 0xD404
#define R_AX_PWR_MACID_LMT_TABLE38_C1 0xF404
#define B_AX_MACID_38_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_38_TXPWR1_EN BIT(25)
#define B_AX_MACID_38_TXPWR0_EN BIT(24)
#define B_AX_MACID_38_CCA_PWR_TH_SH 16
#define B_AX_MACID_38_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_38_TXPWR1_SH 8
#define B_AX_MACID_38_TXPWR1_MSK 0xff
#define B_AX_MACID_38_TXPWR0_SH 0
#define B_AX_MACID_38_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE39 0xD408
#define R_AX_PWR_MACID_LMT_TABLE39_C1 0xF408
#define B_AX_MACID_39_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_39_TXPWR1_EN BIT(25)
#define B_AX_MACID_39_TXPWR0_EN BIT(24)
#define B_AX_MACID_39_CCA_PWR_TH_SH 16
#define B_AX_MACID_39_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_39_TXPWR1_SH 8
#define B_AX_MACID_39_TXPWR1_MSK 0xff
#define B_AX_MACID_39_TXPWR0_SH 0
#define B_AX_MACID_39_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE40 0xD40C
#define R_AX_PWR_MACID_LMT_TABLE40_C1 0xF40C
#define B_AX_MACID_40_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_40_TXPWR1_EN BIT(25)
#define B_AX_MACID_40_TXPWR0_EN BIT(24)
#define B_AX_MACID_40_CCA_PWR_TH_SH 16
#define B_AX_MACID_40_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_40_TXPWR1_SH 8
#define B_AX_MACID_40_TXPWR1_MSK 0xff
#define B_AX_MACID_40_TXPWR0_SH 0
#define B_AX_MACID_40_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE41 0xD410
#define R_AX_PWR_MACID_LMT_TABLE41_C1 0xF410
#define B_AX_MACID_41_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_41_TXPWR1_EN BIT(25)
#define B_AX_MACID_41_TXPWR0_EN BIT(24)
#define B_AX_MACID_41_CCA_PWR_TH_SH 16
#define B_AX_MACID_41_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_41_TXPWR1_SH 8
#define B_AX_MACID_41_TXPWR1_MSK 0xff
#define B_AX_MACID_41_TXPWR0_SH 0
#define B_AX_MACID_41_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE42 0xD414
#define R_AX_PWR_MACID_LMT_TABLE42_C1 0xF414
#define B_AX_MACID_42_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_42_TXPWR1_EN BIT(25)
#define B_AX_MACID_42_TXPWR0_EN BIT(24)
#define B_AX_MACID_42_CCA_PWR_TH_SH 16
#define B_AX_MACID_42_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_42_TXPWR1_SH 8
#define B_AX_MACID_42_TXPWR1_MSK 0xff
#define B_AX_MACID_42_TXPWR0_SH 0
#define B_AX_MACID_42_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE43 0xD418
#define R_AX_PWR_MACID_LMT_TABLE43_C1 0xF418
#define B_AX_MACID_43_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_43_TXPWR1_EN BIT(25)
#define B_AX_MACID_43_TXPWR0_EN BIT(24)
#define B_AX_MACID_43_CCA_PWR_TH_SH 16
#define B_AX_MACID_43_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_43_TXPWR1_SH 8
#define B_AX_MACID_43_TXPWR1_MSK 0xff
#define B_AX_MACID_43_TXPWR0_SH 0
#define B_AX_MACID_43_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE44 0xD41C
#define R_AX_PWR_MACID_LMT_TABLE44_C1 0xF41C
#define B_AX_MACID_44_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_44_TXPWR1_EN BIT(25)
#define B_AX_MACID_44_TXPWR0_EN BIT(24)
#define B_AX_MACID_44_CCA_PWR_TH_SH 16
#define B_AX_MACID_44_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_44_TXPWR1_SH 8
#define B_AX_MACID_44_TXPWR1_MSK 0xff
#define B_AX_MACID_44_TXPWR0_SH 0
#define B_AX_MACID_44_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE45 0xD420
#define R_AX_PWR_MACID_LMT_TABLE45_C1 0xF420
#define B_AX_MACID_45_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_45_TXPWR1_EN BIT(25)
#define B_AX_MACID_45_TXPWR0_EN BIT(24)
#define B_AX_MACID_45_CCA_PWR_TH_SH 16
#define B_AX_MACID_45_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_45_TXPWR1_SH 8
#define B_AX_MACID_45_TXPWR1_MSK 0xff
#define B_AX_MACID_45_TXPWR0_SH 0
#define B_AX_MACID_45_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE46 0xD424
#define R_AX_PWR_MACID_LMT_TABLE46_C1 0xF424
#define B_AX_MACID_46_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_46_TXPWR1_EN BIT(25)
#define B_AX_MACID_46_TXPWR0_EN BIT(24)
#define B_AX_MACID_46_CCA_PWR_TH_SH 16
#define B_AX_MACID_46_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_46_TXPWR1_SH 8
#define B_AX_MACID_46_TXPWR1_MSK 0xff
#define B_AX_MACID_46_TXPWR0_SH 0
#define B_AX_MACID_46_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE47 0xD428
#define R_AX_PWR_MACID_LMT_TABLE47_C1 0xF428
#define B_AX_MACID_47_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_47_TXPWR1_EN BIT(25)
#define B_AX_MACID_47_TXPWR0_EN BIT(24)
#define B_AX_MACID_47_CCA_PWR_TH_SH 16
#define B_AX_MACID_47_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_47_TXPWR1_SH 8
#define B_AX_MACID_47_TXPWR1_MSK 0xff
#define B_AX_MACID_47_TXPWR0_SH 0
#define B_AX_MACID_47_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE48 0xD42C
#define R_AX_PWR_MACID_LMT_TABLE48_C1 0xF42C
#define B_AX_MACID_48_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_48_TXPWR1_EN BIT(25)
#define B_AX_MACID_48_TXPWR0_EN BIT(24)
#define B_AX_MACID_48_CCA_PWR_TH_SH 16
#define B_AX_MACID_48_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_48_TXPWR1_SH 8
#define B_AX_MACID_48_TXPWR1_MSK 0xff
#define B_AX_MACID_48_TXPWR0_SH 0
#define B_AX_MACID_48_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE49 0xD430
#define R_AX_PWR_MACID_LMT_TABLE49_C1 0xF430
#define B_AX_MACID_49_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_49_TXPWR1_EN BIT(25)
#define B_AX_MACID_49_TXPWR0_EN BIT(24)
#define B_AX_MACID_49_CCA_PWR_TH_SH 16
#define B_AX_MACID_49_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_49_TXPWR1_SH 8
#define B_AX_MACID_49_TXPWR1_MSK 0xff
#define B_AX_MACID_49_TXPWR0_SH 0
#define B_AX_MACID_49_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE50 0xD434
#define R_AX_PWR_MACID_LMT_TABLE50_C1 0xF434
#define B_AX_MACID_50_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_50_TXPWR1_EN BIT(25)
#define B_AX_MACID_50_TXPWR0_EN BIT(24)
#define B_AX_MACID_50_CCA_PWR_TH_SH 16
#define B_AX_MACID_50_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_50_TXPWR1_SH 8
#define B_AX_MACID_50_TXPWR1_MSK 0xff
#define B_AX_MACID_50_TXPWR0_SH 0
#define B_AX_MACID_50_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE51 0xD438
#define R_AX_PWR_MACID_LMT_TABLE51_C1 0xF438
#define B_AX_MACID_51_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_51_TXPWR1_EN BIT(25)
#define B_AX_MACID_51_TXPWR0_EN BIT(24)
#define B_AX_MACID_51_CCA_PWR_TH_SH 16
#define B_AX_MACID_51_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_51_TXPWR1_SH 8
#define B_AX_MACID_51_TXPWR1_MSK 0xff
#define B_AX_MACID_51_TXPWR0_SH 0
#define B_AX_MACID_51_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE52 0xD43C
#define R_AX_PWR_MACID_LMT_TABLE52_C1 0xF43C
#define B_AX_MACID_52_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_52_TXPWR1_EN BIT(25)
#define B_AX_MACID_52_TXPWR0_EN BIT(24)
#define B_AX_MACID_52_CCA_PWR_TH_SH 16
#define B_AX_MACID_52_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_52_TXPWR1_SH 8
#define B_AX_MACID_52_TXPWR1_MSK 0xff
#define B_AX_MACID_52_TXPWR0_SH 0
#define B_AX_MACID_52_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE53 0xD440
#define R_AX_PWR_MACID_LMT_TABLE53_C1 0xF440
#define B_AX_MACID_53_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_53_TXPWR1_EN BIT(25)
#define B_AX_MACID_53_TXPWR0_EN BIT(24)
#define B_AX_MACID_53_CCA_PWR_TH_SH 16
#define B_AX_MACID_53_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_53_TXPWR1_SH 8
#define B_AX_MACID_53_TXPWR1_MSK 0xff
#define B_AX_MACID_53_TXPWR0_SH 0
#define B_AX_MACID_53_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE54 0xD444
#define R_AX_PWR_MACID_LMT_TABLE54_C1 0xF444
#define B_AX_MACID_54_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_54_TXPWR1_EN BIT(25)
#define B_AX_MACID_54_TXPWR0_EN BIT(24)
#define B_AX_MACID_54_CCA_PWR_TH_SH 16
#define B_AX_MACID_54_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_54_TXPWR1_SH 8
#define B_AX_MACID_54_TXPWR1_MSK 0xff
#define B_AX_MACID_54_TXPWR0_SH 0
#define B_AX_MACID_54_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE55 0xD448
#define R_AX_PWR_MACID_LMT_TABLE55_C1 0xF448
#define B_AX_MACID_55_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_55_TXPWR1_EN BIT(25)
#define B_AX_MACID_55_TXPWR0_EN BIT(24)
#define B_AX_MACID_55_CCA_PWR_TH_SH 16
#define B_AX_MACID_55_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_55_TXPWR1_SH 8
#define B_AX_MACID_55_TXPWR1_MSK 0xff
#define B_AX_MACID_55_TXPWR0_SH 0
#define B_AX_MACID_55_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE56 0xD44C
#define R_AX_PWR_MACID_LMT_TABLE56_C1 0xF44C
#define B_AX_MACID_56_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_56_TXPWR1_EN BIT(25)
#define B_AX_MACID_56_TXPWR0_EN BIT(24)
#define B_AX_MACID_56_CCA_PWR_TH_SH 16
#define B_AX_MACID_56_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_56_TXPWR1_SH 8
#define B_AX_MACID_56_TXPWR1_MSK 0xff
#define B_AX_MACID_56_TXPWR0_SH 0
#define B_AX_MACID_56_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE57 0xD450
#define R_AX_PWR_MACID_LMT_TABLE57_C1 0xF450
#define B_AX_MACID_57_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_57_TXPWR1_EN BIT(25)
#define B_AX_MACID_57_TXPWR0_EN BIT(24)
#define B_AX_MACID_57_CCA_PWR_TH_SH 16
#define B_AX_MACID_57_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_57_TXPWR1_SH 8
#define B_AX_MACID_57_TXPWR1_MSK 0xff
#define B_AX_MACID_57_TXPWR0_SH 0
#define B_AX_MACID_57_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE58 0xD454
#define R_AX_PWR_MACID_LMT_TABLE58_C1 0xF454
#define B_AX_MACID_58_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_58_TXPWR1_EN BIT(25)
#define B_AX_MACID_58_TXPWR0_EN BIT(24)
#define B_AX_MACID_58_CCA_PWR_TH_SH 16
#define B_AX_MACID_58_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_58_TXPWR1_SH 8
#define B_AX_MACID_58_TXPWR1_MSK 0xff
#define B_AX_MACID_58_TXPWR0_SH 0
#define B_AX_MACID_58_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE59 0xD458
#define R_AX_PWR_MACID_LMT_TABLE59_C1 0xF458
#define B_AX_MACID_59_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_59_TXPWR1_EN BIT(25)
#define B_AX_MACID_59_TXPWR0_EN BIT(24)
#define B_AX_MACID_59_CCA_PWR_TH_SH 16
#define B_AX_MACID_59_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_59_TXPWR1_SH 8
#define B_AX_MACID_59_TXPWR1_MSK 0xff
#define B_AX_MACID_59_TXPWR0_SH 0
#define B_AX_MACID_59_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE60 0xD45C
#define R_AX_PWR_MACID_LMT_TABLE60_C1 0xF45C
#define B_AX_MACID_60_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_60_TXPWR1_EN BIT(25)
#define B_AX_MACID_60_TXPWR0_EN BIT(24)
#define B_AX_MACID_60_CCA_PWR_TH_SH 16
#define B_AX_MACID_60_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_60_TXPWR1_SH 8
#define B_AX_MACID_60_TXPWR1_MSK 0xff
#define B_AX_MACID_60_TXPWR0_SH 0
#define B_AX_MACID_60_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE61 0xD460
#define R_AX_PWR_MACID_LMT_TABLE61_C1 0xF460
#define B_AX_MACID_61_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_61_TXPWR1_EN BIT(25)
#define B_AX_MACID_61_TXPWR0_EN BIT(24)
#define B_AX_MACID_61_CCA_PWR_TH_SH 16
#define B_AX_MACID_61_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_61_TXPWR1_SH 8
#define B_AX_MACID_61_TXPWR1_MSK 0xff
#define B_AX_MACID_61_TXPWR0_SH 0
#define B_AX_MACID_61_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE62 0xD464
#define R_AX_PWR_MACID_LMT_TABLE62_C1 0xF464
#define B_AX_MACID_62_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_62_TXPWR1_EN BIT(25)
#define B_AX_MACID_62_TXPWR0_EN BIT(24)
#define B_AX_MACID_62_CCA_PWR_TH_SH 16
#define B_AX_MACID_62_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_62_TXPWR1_SH 8
#define B_AX_MACID_62_TXPWR1_MSK 0xff
#define B_AX_MACID_62_TXPWR0_SH 0
#define B_AX_MACID_62_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE63 0xD468
#define R_AX_PWR_MACID_LMT_TABLE63_C1 0xF468
#define B_AX_MACID_63_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_63_TXPWR1_EN BIT(25)
#define B_AX_MACID_63_TXPWR0_EN BIT(24)
#define B_AX_MACID_63_CCA_PWR_TH_SH 16
#define B_AX_MACID_63_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_63_TXPWR1_SH 8
#define B_AX_MACID_63_TXPWR1_MSK 0xff
#define B_AX_MACID_63_TXPWR0_SH 0
#define B_AX_MACID_63_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE64 0xD46C
#define R_AX_PWR_MACID_LMT_TABLE64_C1 0xF46C
#define B_AX_MACID_64_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_64_TXPWR1_EN BIT(25)
#define B_AX_MACID_64_TXPWR0_EN BIT(24)
#define B_AX_MACID_64_CCA_PWR_TH_SH 16
#define B_AX_MACID_64_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_64_TXPWR1_SH 8
#define B_AX_MACID_64_TXPWR1_MSK 0xff
#define B_AX_MACID_64_TXPWR0_SH 0
#define B_AX_MACID_64_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE65 0xD470
#define R_AX_PWR_MACID_LMT_TABLE65_C1 0xF470
#define B_AX_MACID_65_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_65_TXPWR1_EN BIT(25)
#define B_AX_MACID_65_TXPWR0_EN BIT(24)
#define B_AX_MACID_65_CCA_PWR_TH_SH 16
#define B_AX_MACID_65_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_65_TXPWR1_SH 8
#define B_AX_MACID_65_TXPWR1_MSK 0xff
#define B_AX_MACID_65_TXPWR0_SH 0
#define B_AX_MACID_65_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE66 0xD474
#define R_AX_PWR_MACID_LMT_TABLE66_C1 0xF474
#define B_AX_MACID_66_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_66_TXPWR1_EN BIT(25)
#define B_AX_MACID_66_TXPWR0_EN BIT(24)
#define B_AX_MACID_66_CCA_PWR_TH_SH 16
#define B_AX_MACID_66_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_66_TXPWR1_SH 8
#define B_AX_MACID_66_TXPWR1_MSK 0xff
#define B_AX_MACID_66_TXPWR0_SH 0
#define B_AX_MACID_66_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE67 0xD478
#define R_AX_PWR_MACID_LMT_TABLE67_C1 0xF478
#define B_AX_MACID_67_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_67_TXPWR1_EN BIT(25)
#define B_AX_MACID_67_TXPWR0_EN BIT(24)
#define B_AX_MACID_67_CCA_PWR_TH_SH 16
#define B_AX_MACID_67_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_67_TXPWR1_SH 8
#define B_AX_MACID_67_TXPWR1_MSK 0xff
#define B_AX_MACID_67_TXPWR0_SH 0
#define B_AX_MACID_67_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE68 0xD47C
#define R_AX_PWR_MACID_LMT_TABLE68_C1 0xF47C
#define B_AX_MACID_68_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_68_TXPWR1_EN BIT(25)
#define B_AX_MACID_68_TXPWR0_EN BIT(24)
#define B_AX_MACID_68_CCA_PWR_TH_SH 16
#define B_AX_MACID_68_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_68_TXPWR1_SH 8
#define B_AX_MACID_68_TXPWR1_MSK 0xff
#define B_AX_MACID_68_TXPWR0_SH 0
#define B_AX_MACID_68_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE69 0xD480
#define R_AX_PWR_MACID_LMT_TABLE69_C1 0xF480
#define B_AX_MACID_69_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_69_TXPWR1_EN BIT(25)
#define B_AX_MACID_69_TXPWR0_EN BIT(24)
#define B_AX_MACID_69_CCA_PWR_TH_SH 16
#define B_AX_MACID_69_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_69_TXPWR1_SH 8
#define B_AX_MACID_69_TXPWR1_MSK 0xff
#define B_AX_MACID_69_TXPWR0_SH 0
#define B_AX_MACID_69_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE70 0xD484
#define R_AX_PWR_MACID_LMT_TABLE70_C1 0xF484
#define B_AX_MACID_70_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_70_TXPWR1_EN BIT(25)
#define B_AX_MACID_70_TXPWR0_EN BIT(24)
#define B_AX_MACID_70_CCA_PWR_TH_SH 16
#define B_AX_MACID_70_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_70_TXPWR1_SH 8
#define B_AX_MACID_70_TXPWR1_MSK 0xff
#define B_AX_MACID_70_TXPWR0_SH 0
#define B_AX_MACID_70_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE71 0xD488
#define R_AX_PWR_MACID_LMT_TABLE71_C1 0xF488
#define B_AX_MACID_71_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_71_TXPWR1_EN BIT(25)
#define B_AX_MACID_71_TXPWR0_EN BIT(24)
#define B_AX_MACID_71_CCA_PWR_TH_SH 16
#define B_AX_MACID_71_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_71_TXPWR1_SH 8
#define B_AX_MACID_71_TXPWR1_MSK 0xff
#define B_AX_MACID_71_TXPWR0_SH 0
#define B_AX_MACID_71_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE72 0xD48C
#define R_AX_PWR_MACID_LMT_TABLE72_C1 0xF48C
#define B_AX_MACID_72_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_72_TXPWR1_EN BIT(25)
#define B_AX_MACID_72_TXPWR0_EN BIT(24)
#define B_AX_MACID_72_CCA_PWR_TH_SH 16
#define B_AX_MACID_72_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_72_TXPWR1_SH 8
#define B_AX_MACID_72_TXPWR1_MSK 0xff
#define B_AX_MACID_72_TXPWR0_SH 0
#define B_AX_MACID_72_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE73 0xD490
#define R_AX_PWR_MACID_LMT_TABLE73_C1 0xF490
#define B_AX_MACID_73_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_73_TXPWR1_EN BIT(25)
#define B_AX_MACID_73_TXPWR0_EN BIT(24)
#define B_AX_MACID_73_CCA_PWR_TH_SH 16
#define B_AX_MACID_73_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_73_TXPWR1_SH 8
#define B_AX_MACID_73_TXPWR1_MSK 0xff
#define B_AX_MACID_73_TXPWR0_SH 0
#define B_AX_MACID_73_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE74 0xD494
#define R_AX_PWR_MACID_LMT_TABLE74_C1 0xF494
#define B_AX_MACID_74_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_74_TXPWR1_EN BIT(25)
#define B_AX_MACID_74_TXPWR0_EN BIT(24)
#define B_AX_MACID_74_CCA_PWR_TH_SH 16
#define B_AX_MACID_74_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_74_TXPWR1_SH 8
#define B_AX_MACID_74_TXPWR1_MSK 0xff
#define B_AX_MACID_74_TXPWR0_SH 0
#define B_AX_MACID_74_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE75 0xD498
#define R_AX_PWR_MACID_LMT_TABLE75_C1 0xF498
#define B_AX_MACID_75_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_75_TXPWR1_EN BIT(25)
#define B_AX_MACID_75_TXPWR0_EN BIT(24)
#define B_AX_MACID_75_CCA_PWR_TH_SH 16
#define B_AX_MACID_75_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_75_TXPWR1_SH 8
#define B_AX_MACID_75_TXPWR1_MSK 0xff
#define B_AX_MACID_75_TXPWR0_SH 0
#define B_AX_MACID_75_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE76 0xD49C
#define R_AX_PWR_MACID_LMT_TABLE76_C1 0xF49C
#define B_AX_MACID_76_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_76_TXPWR1_EN BIT(25)
#define B_AX_MACID_76_TXPWR0_EN BIT(24)
#define B_AX_MACID_76_CCA_PWR_TH_SH 16
#define B_AX_MACID_76_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_76_TXPWR1_SH 8
#define B_AX_MACID_76_TXPWR1_MSK 0xff
#define B_AX_MACID_76_TXPWR0_SH 0
#define B_AX_MACID_76_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE77 0xD4A0
#define R_AX_PWR_MACID_LMT_TABLE77_C1 0xF4A0
#define B_AX_MACID_77_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_77_TXPWR1_EN BIT(25)
#define B_AX_MACID_77_TXPWR0_EN BIT(24)
#define B_AX_MACID_77_CCA_PWR_TH_SH 16
#define B_AX_MACID_77_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_77_TXPWR1_SH 8
#define B_AX_MACID_77_TXPWR1_MSK 0xff
#define B_AX_MACID_77_TXPWR0_SH 0
#define B_AX_MACID_77_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE78 0xD4A4
#define R_AX_PWR_MACID_LMT_TABLE78_C1 0xF4A4
#define B_AX_MACID_78_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_78_TXPWR1_EN BIT(25)
#define B_AX_MACID_78_TXPWR0_EN BIT(24)
#define B_AX_MACID_78_CCA_PWR_TH_SH 16
#define B_AX_MACID_78_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_78_TXPWR1_SH 8
#define B_AX_MACID_78_TXPWR1_MSK 0xff
#define B_AX_MACID_78_TXPWR0_SH 0
#define B_AX_MACID_78_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE79 0xD4A8
#define R_AX_PWR_MACID_LMT_TABLE79_C1 0xF4A8
#define B_AX_MACID_79_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_79_TXPWR1_EN BIT(25)
#define B_AX_MACID_79_TXPWR0_EN BIT(24)
#define B_AX_MACID_79_CCA_PWR_TH_SH 16
#define B_AX_MACID_79_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_79_TXPWR1_SH 8
#define B_AX_MACID_79_TXPWR1_MSK 0xff
#define B_AX_MACID_79_TXPWR0_SH 0
#define B_AX_MACID_79_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE80 0xD4AC
#define R_AX_PWR_MACID_LMT_TABLE80_C1 0xF4AC
#define B_AX_MACID_80_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_80_TXPWR1_EN BIT(25)
#define B_AX_MACID_80_TXPWR0_EN BIT(24)
#define B_AX_MACID_80_CCA_PWR_TH_SH 16
#define B_AX_MACID_80_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_80_TXPWR1_SH 8
#define B_AX_MACID_80_TXPWR1_MSK 0xff
#define B_AX_MACID_80_TXPWR0_SH 0
#define B_AX_MACID_80_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE81 0xD4B0
#define R_AX_PWR_MACID_LMT_TABLE81_C1 0xF4B0
#define B_AX_MACID_81_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_81_TXPWR1_EN BIT(25)
#define B_AX_MACID_81_TXPWR0_EN BIT(24)
#define B_AX_MACID_81_CCA_PWR_TH_SH 16
#define B_AX_MACID_81_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_81_TXPWR1_SH 8
#define B_AX_MACID_81_TXPWR1_MSK 0xff
#define B_AX_MACID_81_TXPWR0_SH 0
#define B_AX_MACID_81_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE82 0xD4B4
#define R_AX_PWR_MACID_LMT_TABLE82_C1 0xF4B4
#define B_AX_MACID_82_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_82_TXPWR1_EN BIT(25)
#define B_AX_MACID_82_TXPWR0_EN BIT(24)
#define B_AX_MACID_82_CCA_PWR_TH_SH 16
#define B_AX_MACID_82_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_82_TXPWR1_SH 8
#define B_AX_MACID_82_TXPWR1_MSK 0xff
#define B_AX_MACID_82_TXPWR0_SH 0
#define B_AX_MACID_82_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE83 0xD4B8
#define R_AX_PWR_MACID_LMT_TABLE83_C1 0xF4B8
#define B_AX_MACID_83_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_83_TXPWR1_EN BIT(25)
#define B_AX_MACID_83_TXPWR0_EN BIT(24)
#define B_AX_MACID_83_CCA_PWR_TH_SH 16
#define B_AX_MACID_83_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_83_TXPWR1_SH 8
#define B_AX_MACID_83_TXPWR1_MSK 0xff
#define B_AX_MACID_83_TXPWR0_SH 0
#define B_AX_MACID_83_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE84 0xD4BC
#define R_AX_PWR_MACID_LMT_TABLE84_C1 0xF4BC
#define B_AX_MACID_84_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_84_TXPWR1_EN BIT(25)
#define B_AX_MACID_84_TXPWR0_EN BIT(24)
#define B_AX_MACID_84_CCA_PWR_TH_SH 16
#define B_AX_MACID_84_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_84_TXPWR1_SH 8
#define B_AX_MACID_84_TXPWR1_MSK 0xff
#define B_AX_MACID_84_TXPWR0_SH 0
#define B_AX_MACID_84_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE85 0xD4C0
#define R_AX_PWR_MACID_LMT_TABLE85_C1 0xF4C0
#define B_AX_MACID_85_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_85_TXPWR1_EN BIT(25)
#define B_AX_MACID_85_TXPWR0_EN BIT(24)
#define B_AX_MACID_85_CCA_PWR_TH_SH 16
#define B_AX_MACID_85_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_85_TXPWR1_SH 8
#define B_AX_MACID_85_TXPWR1_MSK 0xff
#define B_AX_MACID_85_TXPWR0_SH 0
#define B_AX_MACID_85_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE86 0xD4C4
#define R_AX_PWR_MACID_LMT_TABLE86_C1 0xF4C4
#define B_AX_MACID_86_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_86_TXPWR1_EN BIT(25)
#define B_AX_MACID_86_TXPWR0_EN BIT(24)
#define B_AX_MACID_86_CCA_PWR_TH_SH 16
#define B_AX_MACID_86_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_86_TXPWR1_SH 8
#define B_AX_MACID_86_TXPWR1_MSK 0xff
#define B_AX_MACID_86_TXPWR0_SH 0
#define B_AX_MACID_86_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE87 0xD4C8
#define R_AX_PWR_MACID_LMT_TABLE87_C1 0xF4C8
#define B_AX_MACID_87_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_87_TXPWR1_EN BIT(25)
#define B_AX_MACID_87_TXPWR0_EN BIT(24)
#define B_AX_MACID_87_CCA_PWR_TH_SH 16
#define B_AX_MACID_87_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_87_TXPWR1_SH 8
#define B_AX_MACID_87_TXPWR1_MSK 0xff
#define B_AX_MACID_87_TXPWR0_SH 0
#define B_AX_MACID_87_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE88 0xD4CC
#define R_AX_PWR_MACID_LMT_TABLE88_C1 0xF4CC
#define B_AX_MACID_88_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_88_TXPWR1_EN BIT(25)
#define B_AX_MACID_88_TXPWR0_EN BIT(24)
#define B_AX_MACID_88_CCA_PWR_TH_SH 16
#define B_AX_MACID_88_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_88_TXPWR1_SH 8
#define B_AX_MACID_88_TXPWR1_MSK 0xff
#define B_AX_MACID_88_TXPWR0_SH 0
#define B_AX_MACID_88_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE89 0xD4D0
#define R_AX_PWR_MACID_LMT_TABLE89_C1 0xF4D0
#define B_AX_MACID_89_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_89_TXPWR1_EN BIT(25)
#define B_AX_MACID_89_TXPWR0_EN BIT(24)
#define B_AX_MACID_89_CCA_PWR_TH_SH 16
#define B_AX_MACID_89_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_89_TXPWR1_SH 8
#define B_AX_MACID_89_TXPWR1_MSK 0xff
#define B_AX_MACID_89_TXPWR0_SH 0
#define B_AX_MACID_89_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE90 0xD4D4
#define R_AX_PWR_MACID_LMT_TABLE90_C1 0xF4D4
#define B_AX_MACID_90_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_90_TXPWR1_EN BIT(25)
#define B_AX_MACID_90_TXPWR0_EN BIT(24)
#define B_AX_MACID_90_CCA_PWR_TH_SH 16
#define B_AX_MACID_90_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_90_TXPWR1_SH 8
#define B_AX_MACID_90_TXPWR1_MSK 0xff
#define B_AX_MACID_90_TXPWR0_SH 0
#define B_AX_MACID_90_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE91 0xD4D8
#define R_AX_PWR_MACID_LMT_TABLE91_C1 0xF4D8
#define B_AX_MACID_91_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_91_TXPWR1_EN BIT(25)
#define B_AX_MACID_91_TXPWR0_EN BIT(24)
#define B_AX_MACID_91_CCA_PWR_TH_SH 16
#define B_AX_MACID_91_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_91_TXPWR1_SH 8
#define B_AX_MACID_91_TXPWR1_MSK 0xff
#define B_AX_MACID_91_TXPWR0_SH 0
#define B_AX_MACID_91_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE92 0xD4DC
#define R_AX_PWR_MACID_LMT_TABLE92_C1 0xF4DC
#define B_AX_MACID_92_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_92_TXPWR1_EN BIT(25)
#define B_AX_MACID_92_TXPWR0_EN BIT(24)
#define B_AX_MACID_92_CCA_PWR_TH_SH 16
#define B_AX_MACID_92_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_92_TXPWR1_SH 8
#define B_AX_MACID_92_TXPWR1_MSK 0xff
#define B_AX_MACID_92_TXPWR0_SH 0
#define B_AX_MACID_92_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE93 0xD4E0
#define R_AX_PWR_MACID_LMT_TABLE93_C1 0xF4E0
#define B_AX_MACID_93_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_93_TXPWR1_EN BIT(25)
#define B_AX_MACID_93_TXPWR0_EN BIT(24)
#define B_AX_MACID_93_CCA_PWR_TH_SH 16
#define B_AX_MACID_93_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_93_TXPWR1_SH 8
#define B_AX_MACID_93_TXPWR1_MSK 0xff
#define B_AX_MACID_93_TXPWR0_SH 0
#define B_AX_MACID_93_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE94 0xD4E4
#define R_AX_PWR_MACID_LMT_TABLE94_C1 0xF4E4
#define B_AX_MACID_94_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_94_TXPWR1_EN BIT(25)
#define B_AX_MACID_94_TXPWR0_EN BIT(24)
#define B_AX_MACID_94_CCA_PWR_TH_SH 16
#define B_AX_MACID_94_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_94_TXPWR1_SH 8
#define B_AX_MACID_94_TXPWR1_MSK 0xff
#define B_AX_MACID_94_TXPWR0_SH 0
#define B_AX_MACID_94_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE95 0xD4E8
#define R_AX_PWR_MACID_LMT_TABLE95_C1 0xF4E8
#define B_AX_MACID_95_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_95_TXPWR1_EN BIT(25)
#define B_AX_MACID_95_TXPWR0_EN BIT(24)
#define B_AX_MACID_95_CCA_PWR_TH_SH 16
#define B_AX_MACID_95_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_95_TXPWR1_SH 8
#define B_AX_MACID_95_TXPWR1_MSK 0xff
#define B_AX_MACID_95_TXPWR0_SH 0
#define B_AX_MACID_95_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE96 0xD4EC
#define R_AX_PWR_MACID_LMT_TABLE96_C1 0xF4EC
#define B_AX_MACID_96_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_96_TXPWR1_EN BIT(25)
#define B_AX_MACID_96_TXPWR0_EN BIT(24)
#define B_AX_MACID_96_CCA_PWR_TH_SH 16
#define B_AX_MACID_96_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_96_TXPWR1_SH 8
#define B_AX_MACID_96_TXPWR1_MSK 0xff
#define B_AX_MACID_96_TXPWR0_SH 0
#define B_AX_MACID_96_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE97 0xD4F0
#define R_AX_PWR_MACID_LMT_TABLE97_C1 0xF4F0
#define B_AX_MACID_97_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_97_TXPWR1_EN BIT(25)
#define B_AX_MACID_97_TXPWR0_EN BIT(24)
#define B_AX_MACID_97_CCA_PWR_TH_SH 16
#define B_AX_MACID_97_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_97_TXPWR1_SH 8
#define B_AX_MACID_97_TXPWR1_MSK 0xff
#define B_AX_MACID_97_TXPWR0_SH 0
#define B_AX_MACID_97_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE98 0xD4F4
#define R_AX_PWR_MACID_LMT_TABLE98_C1 0xF4F4
#define B_AX_MACID_98_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_98_TXPWR1_EN BIT(25)
#define B_AX_MACID_98_TXPWR0_EN BIT(24)
#define B_AX_MACID_98_CCA_PWR_TH_SH 16
#define B_AX_MACID_98_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_98_TXPWR1_SH 8
#define B_AX_MACID_98_TXPWR1_MSK 0xff
#define B_AX_MACID_98_TXPWR0_SH 0
#define B_AX_MACID_98_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE99 0xD4F8
#define R_AX_PWR_MACID_LMT_TABLE99_C1 0xF4F8
#define B_AX_MACID_99_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_99_TXPWR1_EN BIT(25)
#define B_AX_MACID_99_TXPWR0_EN BIT(24)
#define B_AX_MACID_99_CCA_PWR_TH_SH 16
#define B_AX_MACID_99_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_99_TXPWR1_SH 8
#define B_AX_MACID_99_TXPWR1_MSK 0xff
#define B_AX_MACID_99_TXPWR0_SH 0
#define B_AX_MACID_99_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE100 0xD4FC
#define R_AX_PWR_MACID_LMT_TABLE100_C1 0xF4FC
#define B_AX_MACID_100_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_100_TXPWR1_EN BIT(25)
#define B_AX_MACID_100_TXPWR0_EN BIT(24)
#define B_AX_MACID_100_CCA_PWR_TH_SH 16
#define B_AX_MACID_100_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_100_TXPWR1_SH 8
#define B_AX_MACID_100_TXPWR1_MSK 0xff
#define B_AX_MACID_100_TXPWR0_SH 0
#define B_AX_MACID_100_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE101 0xD500
#define R_AX_PWR_MACID_LMT_TABLE101_C1 0xF500
#define B_AX_MACID_101_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_101_TXPWR1_EN BIT(25)
#define B_AX_MACID_101_TXPWR0_EN BIT(24)
#define B_AX_MACID_101_CCA_PWR_TH_SH 16
#define B_AX_MACID_101_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_101_TXPWR1_SH 8
#define B_AX_MACID_101_TXPWR1_MSK 0xff
#define B_AX_MACID_101_TXPWR0_SH 0
#define B_AX_MACID_101_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE102 0xD504
#define R_AX_PWR_MACID_LMT_TABLE102_C1 0xF504
#define B_AX_MACID_102_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_102_TXPWR1_EN BIT(25)
#define B_AX_MACID_102_TXPWR0_EN BIT(24)
#define B_AX_MACID_102_CCA_PWR_TH_SH 16
#define B_AX_MACID_102_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_102_TXPWR1_SH 8
#define B_AX_MACID_102_TXPWR1_MSK 0xff
#define B_AX_MACID_102_TXPWR0_SH 0
#define B_AX_MACID_102_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE103 0xD508
#define R_AX_PWR_MACID_LMT_TABLE103_C1 0xF508
#define B_AX_MACID_103_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_103_TXPWR1_EN BIT(25)
#define B_AX_MACID_103_TXPWR0_EN BIT(24)
#define B_AX_MACID_103_CCA_PWR_TH_SH 16
#define B_AX_MACID_103_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_103_TXPWR1_SH 8
#define B_AX_MACID_103_TXPWR1_MSK 0xff
#define B_AX_MACID_103_TXPWR0_SH 0
#define B_AX_MACID_103_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE104 0xD50C
#define R_AX_PWR_MACID_LMT_TABLE104_C1 0xF50C
#define B_AX_MACID_104_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_104_TXPWR1_EN BIT(25)
#define B_AX_MACID_104_TXPWR0_EN BIT(24)
#define B_AX_MACID_104_CCA_PWR_TH_SH 16
#define B_AX_MACID_104_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_104_TXPWR1_SH 8
#define B_AX_MACID_104_TXPWR1_MSK 0xff
#define B_AX_MACID_104_TXPWR0_SH 0
#define B_AX_MACID_104_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE105 0xD510
#define R_AX_PWR_MACID_LMT_TABLE105_C1 0xF510
#define B_AX_MACID_105_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_105_TXPWR1_EN BIT(25)
#define B_AX_MACID_105_TXPWR0_EN BIT(24)
#define B_AX_MACID_105_CCA_PWR_TH_SH 16
#define B_AX_MACID_105_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_105_TXPWR1_SH 8
#define B_AX_MACID_105_TXPWR1_MSK 0xff
#define B_AX_MACID_105_TXPWR0_SH 0
#define B_AX_MACID_105_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE106 0xD514
#define R_AX_PWR_MACID_LMT_TABLE106_C1 0xF514
#define B_AX_MACID_106_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_106_TXPWR1_EN BIT(25)
#define B_AX_MACID_106_TXPWR0_EN BIT(24)
#define B_AX_MACID_106_CCA_PWR_TH_SH 16
#define B_AX_MACID_106_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_106_TXPWR1_SH 8
#define B_AX_MACID_106_TXPWR1_MSK 0xff
#define B_AX_MACID_106_TXPWR0_SH 0
#define B_AX_MACID_106_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE107 0xD518
#define R_AX_PWR_MACID_LMT_TABLE107_C1 0xF518
#define B_AX_MACID_107_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_107_TXPWR1_EN BIT(25)
#define B_AX_MACID_107_TXPWR0_EN BIT(24)
#define B_AX_MACID_107_CCA_PWR_TH_SH 16
#define B_AX_MACID_107_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_107_TXPWR1_SH 8
#define B_AX_MACID_107_TXPWR1_MSK 0xff
#define B_AX_MACID_107_TXPWR0_SH 0
#define B_AX_MACID_107_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE108 0xD51C
#define R_AX_PWR_MACID_LMT_TABLE108_C1 0xF51C
#define B_AX_MACID_108_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_108_TXPWR1_EN BIT(25)
#define B_AX_MACID_108_TXPWR0_EN BIT(24)
#define B_AX_MACID_108_CCA_PWR_TH_SH 16
#define B_AX_MACID_108_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_108_TXPWR1_SH 8
#define B_AX_MACID_108_TXPWR1_MSK 0xff
#define B_AX_MACID_108_TXPWR0_SH 0
#define B_AX_MACID_108_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE109 0xD520
#define R_AX_PWR_MACID_LMT_TABLE109_C1 0xF520
#define B_AX_MACID_109_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_109_TXPWR1_EN BIT(25)
#define B_AX_MACID_109_TXPWR0_EN BIT(24)
#define B_AX_MACID_109_CCA_PWR_TH_SH 16
#define B_AX_MACID_109_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_109_TXPWR1_SH 8
#define B_AX_MACID_109_TXPWR1_MSK 0xff
#define B_AX_MACID_109_TXPWR0_SH 0
#define B_AX_MACID_109_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE110 0xD524
#define R_AX_PWR_MACID_LMT_TABLE110_C1 0xF524
#define B_AX_MACID_110_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_110_TXPWR1_EN BIT(25)
#define B_AX_MACID_110_TXPWR0_EN BIT(24)
#define B_AX_MACID_110_CCA_PWR_TH_SH 16
#define B_AX_MACID_110_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_110_TXPWR1_SH 8
#define B_AX_MACID_110_TXPWR1_MSK 0xff
#define B_AX_MACID_110_TXPWR0_SH 0
#define B_AX_MACID_110_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE111 0xD528
#define R_AX_PWR_MACID_LMT_TABLE111_C1 0xF528
#define B_AX_MACID_111_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_111_TXPWR1_EN BIT(25)
#define B_AX_MACID_111_TXPWR0_EN BIT(24)
#define B_AX_MACID_111_CCA_PWR_TH_SH 16
#define B_AX_MACID_111_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_111_TXPWR1_SH 8
#define B_AX_MACID_111_TXPWR1_MSK 0xff
#define B_AX_MACID_111_TXPWR0_SH 0
#define B_AX_MACID_111_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE112 0xD52C
#define R_AX_PWR_MACID_LMT_TABLE112_C1 0xF52C
#define B_AX_MACID_112_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_112_TXPWR1_EN BIT(25)
#define B_AX_MACID_112_TXPWR0_EN BIT(24)
#define B_AX_MACID_112_CCA_PWR_TH_SH 16
#define B_AX_MACID_112_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_112_TXPWR1_SH 8
#define B_AX_MACID_112_TXPWR1_MSK 0xff
#define B_AX_MACID_112_TXPWR0_SH 0
#define B_AX_MACID_112_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE113 0xD530
#define R_AX_PWR_MACID_LMT_TABLE113_C1 0xF530
#define B_AX_MACID_113_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_113_TXPWR1_EN BIT(25)
#define B_AX_MACID_113_TXPWR0_EN BIT(24)
#define B_AX_MACID_113_CCA_PWR_TH_SH 16
#define B_AX_MACID_113_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_113_TXPWR1_SH 8
#define B_AX_MACID_113_TXPWR1_MSK 0xff
#define B_AX_MACID_113_TXPWR0_SH 0
#define B_AX_MACID_113_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE114 0xD534
#define R_AX_PWR_MACID_LMT_TABLE114_C1 0xF534
#define B_AX_MACID_114_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_114_TXPWR1_EN BIT(25)
#define B_AX_MACID_114_TXPWR0_EN BIT(24)
#define B_AX_MACID_114_CCA_PWR_TH_SH 16
#define B_AX_MACID_114_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_114_TXPWR1_SH 8
#define B_AX_MACID_114_TXPWR1_MSK 0xff
#define B_AX_MACID_114_TXPWR0_SH 0
#define B_AX_MACID_114_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE115 0xD538
#define R_AX_PWR_MACID_LMT_TABLE115_C1 0xF538
#define B_AX_MACID_115_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_115_TXPWR1_EN BIT(25)
#define B_AX_MACID_115_TXPWR0_EN BIT(24)
#define B_AX_MACID_115_CCA_PWR_TH_SH 16
#define B_AX_MACID_115_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_115_TXPWR1_SH 8
#define B_AX_MACID_115_TXPWR1_MSK 0xff
#define B_AX_MACID_115_TXPWR0_SH 0
#define B_AX_MACID_115_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE116 0xD53C
#define R_AX_PWR_MACID_LMT_TABLE116_C1 0xF53C
#define B_AX_MACID_116_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_116_TXPWR1_EN BIT(25)
#define B_AX_MACID_116_TXPWR0_EN BIT(24)
#define B_AX_MACID_116_CCA_PWR_TH_SH 16
#define B_AX_MACID_116_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_116_TXPWR1_SH 8
#define B_AX_MACID_116_TXPWR1_MSK 0xff
#define B_AX_MACID_116_TXPWR0_SH 0
#define B_AX_MACID_116_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE117 0xD540
#define R_AX_PWR_MACID_LMT_TABLE117_C1 0xF540
#define B_AX_MACID_117_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_117_TXPWR1_EN BIT(25)
#define B_AX_MACID_117_TXPWR0_EN BIT(24)
#define B_AX_MACID_117_CCA_PWR_TH_SH 16
#define B_AX_MACID_117_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_117_TXPWR1_SH 8
#define B_AX_MACID_117_TXPWR1_MSK 0xff
#define B_AX_MACID_117_TXPWR0_SH 0
#define B_AX_MACID_117_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE118 0xD544
#define R_AX_PWR_MACID_LMT_TABLE118_C1 0xF544
#define B_AX_MACID_118_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_118_TXPWR1_EN BIT(25)
#define B_AX_MACID_118_TXPWR0_EN BIT(24)
#define B_AX_MACID_118_CCA_PWR_TH_SH 16
#define B_AX_MACID_118_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_118_TXPWR1_SH 8
#define B_AX_MACID_118_TXPWR1_MSK 0xff
#define B_AX_MACID_118_TXPWR0_SH 0
#define B_AX_MACID_118_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE119 0xD548
#define R_AX_PWR_MACID_LMT_TABLE119_C1 0xF548
#define B_AX_MACID_119_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_119_TXPWR1_EN BIT(25)
#define B_AX_MACID_119_TXPWR0_EN BIT(24)
#define B_AX_MACID_119_CCA_PWR_TH_SH 16
#define B_AX_MACID_119_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_119_TXPWR1_SH 8
#define B_AX_MACID_119_TXPWR1_MSK 0xff
#define B_AX_MACID_119_TXPWR0_SH 0
#define B_AX_MACID_119_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE120 0xD54C
#define R_AX_PWR_MACID_LMT_TABLE120_C1 0xF54C
#define B_AX_MACID_120_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_120_TXPWR1_EN BIT(25)
#define B_AX_MACID_120_TXPWR0_EN BIT(24)
#define B_AX_MACID_120_CCA_PWR_TH_SH 16
#define B_AX_MACID_120_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_120_TXPWR1_SH 8
#define B_AX_MACID_120_TXPWR1_MSK 0xff
#define B_AX_MACID_120_TXPWR0_SH 0
#define B_AX_MACID_120_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE121 0xD550
#define R_AX_PWR_MACID_LMT_TABLE121_C1 0xF550
#define B_AX_MACID_121_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_121_TXPWR1_EN BIT(25)
#define B_AX_MACID_121_TXPWR0_EN BIT(24)
#define B_AX_MACID_121_CCA_PWR_TH_SH 16
#define B_AX_MACID_121_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_121_TXPWR1_SH 8
#define B_AX_MACID_121_TXPWR1_MSK 0xff
#define B_AX_MACID_121_TXPWR0_SH 0
#define B_AX_MACID_121_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE122 0xD554
#define R_AX_PWR_MACID_LMT_TABLE122_C1 0xF554
#define B_AX_MACID_122_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_122_TXPWR1_EN BIT(25)
#define B_AX_MACID_122_TXPWR0_EN BIT(24)
#define B_AX_MACID_122_CCA_PWR_TH_SH 16
#define B_AX_MACID_122_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_122_TXPWR1_SH 8
#define B_AX_MACID_122_TXPWR1_MSK 0xff
#define B_AX_MACID_122_TXPWR0_SH 0
#define B_AX_MACID_122_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE123 0xD558
#define R_AX_PWR_MACID_LMT_TABLE123_C1 0xF558
#define B_AX_MACID_123_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_123_TXPWR1_EN BIT(25)
#define B_AX_MACID_123_TXPWR0_EN BIT(24)
#define B_AX_MACID_123_CCA_PWR_TH_SH 16
#define B_AX_MACID_123_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_123_TXPWR1_SH 8
#define B_AX_MACID_123_TXPWR1_MSK 0xff
#define B_AX_MACID_123_TXPWR0_SH 0
#define B_AX_MACID_123_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE124 0xD55C
#define R_AX_PWR_MACID_LMT_TABLE124_C1 0xF55C
#define B_AX_MACID_124_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_124_TXPWR1_EN BIT(25)
#define B_AX_MACID_124_TXPWR0_EN BIT(24)
#define B_AX_MACID_124_CCA_PWR_TH_SH 16
#define B_AX_MACID_124_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_124_TXPWR1_SH 8
#define B_AX_MACID_124_TXPWR1_MSK 0xff
#define B_AX_MACID_124_TXPWR0_SH 0
#define B_AX_MACID_124_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE125 0xD560
#define R_AX_PWR_MACID_LMT_TABLE125_C1 0xF560
#define B_AX_MACID_125_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_125_TXPWR1_EN BIT(25)
#define B_AX_MACID_125_TXPWR0_EN BIT(24)
#define B_AX_MACID_125_CCA_PWR_TH_SH 16
#define B_AX_MACID_125_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_125_TXPWR1_SH 8
#define B_AX_MACID_125_TXPWR1_MSK 0xff
#define B_AX_MACID_125_TXPWR0_SH 0
#define B_AX_MACID_125_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE126 0xD564
#define R_AX_PWR_MACID_LMT_TABLE126_C1 0xF564
#define B_AX_MACID_126_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_126_TXPWR1_EN BIT(25)
#define B_AX_MACID_126_TXPWR0_EN BIT(24)
#define B_AX_MACID_126_CCA_PWR_TH_SH 16
#define B_AX_MACID_126_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_126_TXPWR1_SH 8
#define B_AX_MACID_126_TXPWR1_MSK 0xff
#define B_AX_MACID_126_TXPWR0_SH 0
#define B_AX_MACID_126_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_LMT_TABLE127 0xD568
#define R_AX_PWR_MACID_LMT_TABLE127_C1 0xF568
#define B_AX_MACID_127_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_127_TXPWR1_EN BIT(25)
#define B_AX_MACID_127_TXPWR0_EN BIT(24)
#define B_AX_MACID_127_CCA_PWR_TH_SH 16
#define B_AX_MACID_127_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_127_TXPWR1_SH 8
#define B_AX_MACID_127_TXPWR1_MSK 0xff
#define B_AX_MACID_127_TXPWR0_SH 0
#define B_AX_MACID_127_TXPWR0_MSK 0xff

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE0 0xD56C
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE0_C1 0xF56C
#define B_AX_MCS0_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE1 0xD570
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE1_C1 0xF570
#define B_AX_MCS0_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE2 0xD574
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE2_C1 0xF574
#define B_AX_MCS0_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE3 0xD578
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE3_C1 0xF578
#define B_AX_MCS0_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE0 0xD57C
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE0_C1 0xF57C
#define B_AX_MCS1_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE1 0xD580
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE1_C1 0xF580
#define B_AX_MCS1_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE2 0xD584
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE2_C1 0xF584
#define B_AX_MCS1_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE3 0xD588
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE3_C1 0xF588
#define B_AX_MCS1_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE0 0xD58C
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE0_C1 0xF58C
#define B_AX_MCS2_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE1 0xD590
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE1_C1 0xF590
#define B_AX_MCS2_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE2 0xD594
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE2_C1 0xF594
#define B_AX_MCS2_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE3 0xD598
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE3_C1 0xF598
#define B_AX_MCS2_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE0 0xD59C
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE0_C1 0xF59C
#define B_AX_MCS3_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE1 0xD5A0
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE1_C1 0xF5A0
#define B_AX_MCS3_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE2 0xD5A4
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE2_C1 0xF5A4
#define B_AX_MCS3_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE3 0xD5A8
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE3_C1 0xF5A8
#define B_AX_MCS3_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE0 0xD5AC
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE0_C1 0xF5AC
#define B_AX_MCS4_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE1 0xD5B0
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE1_C1 0xF5B0
#define B_AX_MCS4_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE2 0xD5B4
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE2_C1 0xF5B4
#define B_AX_MCS4_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE3 0xD5B8
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE3_C1 0xF5B8
#define B_AX_MCS4_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE0 0xD5BC
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE0_C1 0xF5BC
#define B_AX_MCS5_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE1 0xD5C0
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE1_C1 0xF5C0
#define B_AX_MCS5_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE2 0xD5C4
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE2_C1 0xF5C4
#define B_AX_MCS5_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE3 0xD5C8
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE3_C1 0xF5C8
#define B_AX_MCS5_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE0 0xD5CC
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE0_C1 0xF5CC
#define B_AX_MCS6_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE1 0xD5D0
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE1_C1 0xF5D0
#define B_AX_MCS6_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE2 0xD5D4
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE2_C1 0xF5D4
#define B_AX_MCS6_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE3 0xD5D8
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE3_C1 0xF5D8
#define B_AX_MCS6_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE0 0xD5DC
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE0_C1 0xF5DC
#define B_AX_MCS7_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE1 0xD5E0
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE1_C1 0xF5E0
#define B_AX_MCS7_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE2 0xD5E4
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE2_C1 0xF5E4
#define B_AX_MCS7_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE3 0xD5E8
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE3_C1 0xF5E8
#define B_AX_MCS7_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE0 0xD5EC
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE0_C1 0xF5EC
#define B_AX_MCS8_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE1 0xD5F0
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE1_C1 0xF5F0
#define B_AX_MCS8_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE2 0xD5F4
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE2_C1 0xF5F4
#define B_AX_MCS8_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE3 0xD5F8
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE3_C1 0xF5F8
#define B_AX_MCS8_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE0 0xD5FC
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE0_C1 0xF5FC
#define B_AX_MCS9_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE1 0xD600
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE1_C1 0xF600
#define B_AX_MCS9_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE2 0xD604
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE2_C1 0xF604
#define B_AX_MCS9_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE3 0xD608
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE3_C1 0xF608
#define B_AX_MCS9_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE0 0xD60C
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE0_C1 0xF60C
#define B_AX_MCS10_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE1 0xD610
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE1_C1 0xF610
#define B_AX_MCS10_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE2 0xD614
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE2_C1 0xF614
#define B_AX_MCS10_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE3 0xD618
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE3_C1 0xF618
#define B_AX_MCS10_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE0 0xD61C
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE0_C1 0xF61C
#define B_AX_MCS11_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE1 0xD620
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE1_C1 0xF620
#define B_AX_MCS11_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE2 0xD624
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE2_C1 0xF624
#define B_AX_MCS11_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE3 0xD628
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE3_C1 0xF628
#define B_AX_MCS11_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_CCK1M_TXDIFF_TABLE0 0xD62C
#define R_AX_PWR_CCK1M_TXDIFF_TABLE0_C1 0xF62C
#define B_AX_CCK1M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK1M_TXDIFF_TABLE1 0xD630
#define R_AX_PWR_CCK1M_TXDIFF_TABLE1_C1 0xF630
#define B_AX_CCK1M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK1M_TXDIFF_TABLE2 0xD634
#define R_AX_PWR_CCK1M_TXDIFF_TABLE2_C1 0xF634
#define B_AX_CCK1M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK1M_TXDIFF_TABLE3 0xD638
#define R_AX_PWR_CCK1M_TXDIFF_TABLE3_C1 0xF638
#define B_AX_CCK1M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK2M_TXDIFF_TABLE0 0xD63C
#define R_AX_PWR_CCK2M_TXDIFF_TABLE0_C1 0xF63C
#define B_AX_CCK2M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK2M_TXDIFF_TABLE1 0xD640
#define R_AX_PWR_CCK2M_TXDIFF_TABLE1_C1 0xF640
#define B_AX_CCK2M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK2M_TXDIFF_TABLE2 0xD644
#define R_AX_PWR_CCK2M_TXDIFF_TABLE2_C1 0xF644
#define B_AX_CCK2M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK2M_TXDIFF_TABLE3 0xD648
#define R_AX_PWR_CCK2M_TXDIFF_TABLE3_C1 0xF648
#define B_AX_CCK2M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE0 0xD64C
#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE0_C1 0xF64C
#define B_AX_CCK5P5M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE1 0xD650
#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE1_C1 0xF650
#define B_AX_CCK5P5M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE2 0xD654
#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE2_C1 0xF654
#define B_AX_CCK5P5M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE3 0xD658
#define R_AX_PWR_CCK5P5M_TXDIFF_TABLE3_C1 0xF658
#define B_AX_CCK5P5M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK11M_TXDIFF_TABLE0 0xD65C
#define R_AX_PWR_CCK11M_TXDIFF_TABLE0_C1 0xF65C
#define B_AX_CCK11M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK11M_TXDIFF_TABLE1 0xD660
#define R_AX_PWR_CCK11M_TXDIFF_TABLE1_C1 0xF660
#define B_AX_CCK11M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK11M_TXDIFF_TABLE2 0xD664
#define R_AX_PWR_CCK11M_TXDIFF_TABLE2_C1 0xF664
#define B_AX_CCK11M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_CCK11M_TXDIFF_TABLE3 0xD668
#define R_AX_PWR_CCK11M_TXDIFF_TABLE3_C1 0xF668
#define B_AX_CCK11M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE0 0xD66C
#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE0_C1 0xF66C
#define B_AX_LEGACY6M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE1 0xD670
#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE1_C1 0xF670
#define B_AX_LEGACY6M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE2 0xD674
#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE2_C1 0xF674
#define B_AX_LEGACY6M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE3 0xD678
#define R_AX_PWR_LEGACY6M_TXDIFF_TABLE3_C1 0xF678
#define B_AX_LEGACY6M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE0 0xD67C
#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE0_C1 0xF67C
#define B_AX_LEGACY9M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE1 0xD680
#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE1_C1 0xF680
#define B_AX_LEGACY9M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE2 0xD684
#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE2_C1 0xF684
#define B_AX_LEGACY9M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE3 0xD688
#define R_AX_PWR_LEGACY9M_TXDIFF_TABLE3_C1 0xF688
#define B_AX_LEGACY9M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE0 0xD68C
#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE0_C1 0xF68C
#define B_AX_LEGACY12M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE1 0xD690
#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE1_C1 0xF690
#define B_AX_LEGACY12M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE2 0xD694
#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE2_C1 0xF694
#define B_AX_LEGACY12M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE3 0xD698
#define R_AX_PWR_LEGACY12M_TXDIFF_TABLE3_C1 0xF698
#define B_AX_LEGACY12M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE0 0xD69C
#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE0_C1 0xF69C
#define B_AX_LEGACY18M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE1 0xD6A0
#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE1_C1 0xF6A0
#define B_AX_LEGACY18M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE2 0xD6A4
#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE2_C1 0xF6A4
#define B_AX_LEGACY18M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE3 0xD6A8
#define R_AX_PWR_LEGACY18M_TXDIFF_TABLE3_C1 0xF6A8
#define B_AX_LEGACY18M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE0 0xD6AC
#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE0_C1 0xF6AC
#define B_AX_LEGACY24M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE1 0xD6B0
#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE1_C1 0xF6B0
#define B_AX_LEGACY24M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE2 0xD6B4
#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE2_C1 0xF6B4
#define B_AX_LEGACY24M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE3 0xD6B8
#define R_AX_PWR_LEGACY24M_TXDIFF_TABLE3_C1 0xF6B8
#define B_AX_LEGACY24M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE0 0xD6BC
#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE0_C1 0xF6BC
#define B_AX_LEGACY36M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE1 0xD6C0
#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE1_C1 0xF6C0
#define B_AX_LEGACY36M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE2 0xD6C4
#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE2_C1 0xF6C4
#define B_AX_LEGACY36M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE3 0xD6C8
#define R_AX_PWR_LEGACY36M_TXDIFF_TABLE3_C1 0xF6C8
#define B_AX_LEGACY36M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE0 0xD6CC
#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE0_C1 0xF6CC
#define B_AX_LEGACY48M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE1 0xD6D0
#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE1_C1 0xF6D0
#define B_AX_LEGACY48M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE2 0xD6D4
#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE2_C1 0xF6D4
#define B_AX_LEGACY48M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE3 0xD6D8
#define R_AX_PWR_LEGACY48M_TXDIFF_TABLE3_C1 0xF6D8
#define B_AX_LEGACY48M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE0 0xD6DC
#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE0_C1 0xF6DC
#define B_AX_LEGACY54M_TXDIFF_5DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_5DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_4DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_4DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_3DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_3DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_2DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_2DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_1DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_1DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE1 0xD6E0
#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE1_C1 0xF6E0
#define B_AX_LEGACY54M_TXDIFF_10DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_10DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_9DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_9DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_8DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_8DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_7DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_7DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_6DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_6DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE2 0xD6E4
#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE2_C1 0xF6E4
#define B_AX_LEGACY54M_TXDIFF_15DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_15DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_14DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_14DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_13DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_13DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_12DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_12DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_11DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_11DB_RATE_OFFSET_MSK 0xf

#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE3 0xD6E8
#define R_AX_PWR_LEGACY54M_TXDIFF_TABLE3_C1 0xF6E8
#define B_AX_LEGACY54M_TXDIFF_20DB_RATE_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_20DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_19DB_RATE_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_19DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_18DB_RATE_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_18DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_17DB_RATE_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_17DB_RATE_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_16DB_RATE_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_16DB_RATE_OFFSET_MSK 0xf

#define R_AX_TXPWR_IMR 0xD9E0
#define R_AX_TXPWR_IMR_C1 0xF9E0
#define B_AX_TXPWR_FSM_TIMEOUT_INT_EN BIT(0)

#define R_AX_TXPWR_ISR 0xD9E4
#define R_AX_TXPWR_ISR_C1 0xF9E4
#define B_AX_TXPWR_FSM_TIMEOUT_ISR BIT(0)

#define R_AX_TXPWR_DBG_CFG 0xD9F8
#define R_AX_TXPWR_DBG_CFG_C1 0xF9F8
#define B_AX_TXPWR_DBG_SEL_SH 24
#define B_AX_TXPWR_DBG_SEL_MSK 0xff
#define B_AX_TXPWR_DBG_EN BIT(17)
#define B_AX_TXPWR_CLK_GATING_DIS BIT(16)
#define B_AX_TXPWR_TB_NTX BIT(8)

#define R_AX_TXPWR_DBG 0xD9FC
#define R_AX_TXPWR_DBG_C1 0xF9FC
#define B_AX_TXPWR_CTRL_DBG_SH 0
#define B_AX_TXPWR_CTRL_DBG_MSK 0xffffffffL

//
// BTCOEX
//

#define R_AX_BTC_CFG 0xDA00
#define R_AX_BTC_CFG_C1 0xFA00
#define B_AX_COEX_DLY_CLK_SH 8
#define B_AX_COEX_DLY_CLK_MSK 0xff
#define B_AX_BT_BLE_EN BIT(5)
#define B_AX_BTC_DBG_SEL_SH 3
#define B_AX_BTC_DBG_SEL_MSK 0x3
#define B_AX_DIS_BTC_CLK_G BIT(2)
#define B_AX_GNT_WL_RX_CTRL BIT(1)
#define B_AX_WL_SRC BIT(0)

#define R_AX_BTC_RST 0xDA04
#define R_AX_BTC_RST_C1 0xFA04
#define B_AX_RST_PTA BIT(0)

#define R_AX_COEX_ERR_FLAG 0xDA08
#define R_AX_COEX_ERR_FLAG_C1 0xFA08
#define B_AX_COEX_CMD_CRC BIT(1)
#define B_AX_COEX_CMD_INC BIT(0)

#define R_AX_WL_PRI_MSK 0xDA10
#define R_AX_WL_PRI_MSK_C1 0xFA10
#define B_AX_PRI_MASK_RX_TIME_SH 9
#define B_AX_PRI_MASK_RX_TIME_MSK 0x3
#define B_AX_PTA_WL_PRI_MASK_BCNQ BIT(8)
#define B_AX_PTA_WL_PRI_MASK_HIQ BIT(7)
#define B_AX_PTA_WL_PRI_MASK_CPUMGQ BIT(6)
#define B_AX_PTA_WL_PRI_MASK_PSMGQ BIT(5)
#define B_AX_PTA_WL_PRI_MASK_MGQ BIT(4)
#define B_AX_PTA_WL_PRI_MASK_BK BIT(3)
#define B_AX_PTA_WL_PRI_MASK_BE BIT(2)
#define B_AX_PTA_WL_PRI_MASK_VI BIT(1)
#define B_AX_PTA_WL_PRI_MASK_VO BIT(0)

#define R_AX_BTC_FUNC_EN 0xDA20
#define R_AX_BTC_FUNC_EN_C1 0xFA20
#define B_AX_PTA_WL_TX_EN BIT(1)
#define B_AX_PTA_EDCCA_EN BIT(0)

#define R_AX_COEX_TABLE_1 0xDA24
#define R_AX_COEX_TABLE_1_C1 0xFA24
#define B_AX_COEX_TABLE_1_SH 0
#define B_AX_COEX_TABLE_1_MSK 0xffffffffL

#define R_AX_COEX_TABLE_2 0xDA28
#define R_AX_COEX_TABLE_2_C1 0xFA28
#define B_AX_COEX_TABLE_2_SH 0
#define B_AX_COEX_TABLE_2_MSK 0xffffffffL

#define R_AX_BREAK_TABLE 0xDA2C
#define R_AX_BREAK_TABLE_C1 0xFA2C
#define B_AX_COEX_BREAK_TABLE_2_SH 16
#define B_AX_COEX_BREAK_TABLE_2_MSK 0xffff
#define B_AX_COEX_BREAK_TABLE_1_SH 0
#define B_AX_COEX_BREAK_TABLE_1_MSK 0xffff

#define R_AX_BT_COEX_MSK_TABLE 0xDA30
#define R_AX_BT_COEX_MSK_TABLE_C1 0xFA30
#define B_AX_PRI_MASK_RX_RESP_V1 BIT(30)
#define B_AX_PRI_MASK_RXOFDM_V1 BIT(29)
#define B_AX_PRI_MASK_RXCCK_V1 BIT(28)
#define B_AX_PRI_MASK_TXAC_SH 21
#define B_AX_PRI_MASK_TXAC_MSK 0x7f
#define B_AX_PRI_MASK_NAV_SH 13
#define B_AX_PRI_MASK_NAV_MSK 0xff
#define B_AX_PRI_MASK_CCK_V1 BIT(12)
#define B_AX_PRI_MASK_OFDM_V1 BIT(11)
#define B_AX_PRI_MASK_RTY_V1 BIT(10)
#define B_AX_PRI_MASK_NUM_SH 6
#define B_AX_PRI_MASK_NUM_MSK 0xf
#define B_AX_PRI_MASK_TYPE_SH 2
#define B_AX_PRI_MASK_TYPE_MSK 0xf
#define B_AX_OOB_V1 BIT(1)
#define B_AX_ANT_SEL_V1 BIT(0)

#define R_AX_BT_COEX_CFG_2 0xDA34
#define R_AX_BT_COEX_CFG_2_C1 0xFA34
#define B_AX_GNT_BT_BYPASS_PRIORITY BIT(12)
#define B_AX_GNT_BT_POLARITY BIT(8)
#define B_AX_TIMER_SH 0
#define B_AX_TIMER_MSK 0xff

#define R_AX_BT_COEX_CFG_3 0xDA38
#define R_AX_BT_COEX_CFG_3_C1 0xFA38
#define B_AX_R_BT_CNT_THREN BIT(8)
#define B_AX_R_BT_CNT_THR_SH 0
#define B_AX_R_BT_CNT_THR_MSK 0xff

#define R_AX_BT_COEX_CFG_4 0xDA3C
#define R_AX_BT_COEX_CFG_4_C1 0xFA3C
#define B_AX_ANT_DIVERSITY_SEL_1 BIT(9)
#define B_AX_ANTSEL_FOR_BT_CTRL_EN_1 BIT(8)
#define B_AX_WLACT_LOW_GNTWL_EN_1 BIT(2)
#define B_AX_WLACT_HIGH_GNTBT_EN_1 BIT(1)
#define B_AX_NAV_UPPER_1_V1 BIT(0)

#define R_AX_CSR_MODE 0xDA40
#define R_AX_CSR_MODE_C1 0xFA40
#define B_AX_BT_CNT_RST BIT(16)
#define B_AX_BT_STAT_DELAY_SH 12
#define B_AX_BT_STAT_DELAY_MSK 0xf
#define B_AX_BT_TRX_INIT_DETECT_SH 8
#define B_AX_BT_TRX_INIT_DETECT_MSK 0xf
#define B_AX_BT_PRI_DETECT_TO_SH 4
#define B_AX_BT_PRI_DETECT_TO_MSK 0xf
#define B_AX_WL_ACT_MSK BIT(3)
#define B_AX_STATIS_BT_EN BIT(2)
#define B_AX_WL_ACT_MASK_ENABLE BIT(1)
#define B_AX_ENHANCED_BT BIT(0)

#define R_AX_BT_STAST_HIGH 0xDA44
#define R_AX_BT_STAST_HIGH_C1 0xFA44
#define B_AX_STATIS_BT_HI_RX_SH 16
#define B_AX_STATIS_BT_HI_RX_MSK 0xffff
#define B_AX_STATIS_BT_HI_TX_SH 0
#define B_AX_STATIS_BT_HI_TX_MSK 0xffff

#define R_AX_BT_STAST_LOW 0xDA48
#define R_AX_BT_STAST_LOW_C1 0xFA48
#define B_AX_STATIS_BT_LO_RX_1_SH 16
#define B_AX_STATIS_BT_LO_RX_1_MSK 0xffff
#define B_AX_STATIS_BT_LO_TX_1_SH 0
#define B_AX_STATIS_BT_LO_TX_1_MSK 0xffff

#define R_AX_TDMA_MODE 0xDA4C
#define R_AX_TDMA_MODE_C1 0xFA4C
#define B_AX_R_BT_CMD_RPT_SH 16
#define B_AX_R_BT_CMD_RPT_MSK 0xffff
#define B_AX_R_RPT_FROM_BT_SH 8
#define B_AX_R_RPT_FROM_BT_MSK 0xff
#define B_AX_BT_HID_ISR_SET_SH 6
#define B_AX_BT_HID_ISR_SET_MSK 0x3
#define B_AX_TDMA_BT_START_NOTIFY BIT(5)
#define B_AX_ENABLE_TDMA_FW_MODE BIT(4)
#define B_AX_ENABLE_PTA_TDMA_MODE BIT(3)
#define B_AX_ENABLE_COEXIST_TAB_IN_TDMA BIT(2)
#define B_AX_GPIO2_GPIO3_EXANGE_OR_NO_BT_CCA BIT(1)
#define B_AX_RTK_BT_ENABLE BIT(0)

#define R_AX_RTK_MODE_RPT 0xDA50
#define R_AX_RTK_MODE_RPT_C1 0xFA50
#define B_AX_BT_PROFILE_SH 24
#define B_AX_BT_PROFILE_MSK 0xff
#define B_AX_BT_POWER_SH 16
#define B_AX_BT_POWER_MSK 0xff
#define B_AX_BT_PREDECT_STATUS_SH 8
#define B_AX_BT_PREDECT_STATUS_MSK 0xff
#define B_AX_BT_CMD_INFO_SH 0
#define B_AX_BT_CMD_INFO_MSK 0xff

#define R_AX_RTK_MODE_CFG 0xDA54
#define R_AX_RTK_MODE_CFG_C1 0xFA54
#define B_AX_EN_MAC_NULL_PKT_NOTIFY BIT(31)
#define B_AX_EN_WLAN_RPT_AND_BT_QUERY BIT(30)
#define B_AX_EN_BT_STSTUS_RPT BIT(29)
#define B_AX_EN_BT_POWER BIT(28)
#define B_AX_EN_BT_CHANNEL BIT(27)
#define B_AX_EN_BT_SLOT_CHANGE BIT(26)
#define B_AX_EN_BT_PROFILE_OR_HID BIT(25)
#define B_AX_WLAN_RPT_NOTIFY BIT(24)
#define B_AX_WLAN_RPT_DATA_SH 16
#define B_AX_WLAN_RPT_DATA_MSK 0xff
#define B_AX_CMD_ID_SH 8
#define B_AX_CMD_ID_MSK 0xff
#define B_AX_BT_DATA_SH 0
#define B_AX_BT_DATA_MSK 0xff

#define R_AX_RTK_MODE_TO 0xDA58
#define R_AX_RTK_MODE_TO_C1 0xFA58
#define B_AX_WLAN_RPT_TO_SH 0
#define B_AX_WLAN_RPT_TO_MSK 0xff

#define R_AX_BT_COEX_ISO 0xDA5C
#define R_AX_BT_COEX_ISO_C1 0xFA5C
#define B_AX_ISOLATION_CHK_0_SH 1
#define B_AX_ISOLATION_CHK_0_MSK 0x7fffff
#define B_AX_ISOLATION_EN BIT(0)

#define R_AX_BT_COEX_ISO_CHK_1 0xDA60
#define R_AX_BT_COEX_ISO_CHK_1_C1 0xFA60
#define B_AX_ISOLATION_CHK_1_SH 0
#define B_AX_ISOLATION_CHK_1_MSK 0xffffffffL

#define R_AX_BT_COEX_ISO_CHK_2 0xDA64
#define R_AX_BT_COEX_ISO_CHK_2_C1 0xFA64
#define B_AX_BT_HID_ISR BIT(31)
#define B_AX_BT_QUERY_ISR BIT(30)
#define B_AX_MAC_NULL_PKT_NOTIFY_ISR BIT(29)
#define B_AX_WLAN_RPT_ISR BIT(28)
#define B_AX_BT_POWER_ISR BIT(27)
#define B_AX_BT_CHANNEL_ISR BIT(26)
#define B_AX_BT_SLOT_CHANGE_ISR BIT(25)
#define B_AX_BT_PROFILE_ISR BIT(24)
#define B_AX_ISOLATION_CHK_2_SH 0
#define B_AX_ISOLATION_CHK_2_MSK 0xffffff

#define R_AX_BT_COEX_CFG_5 0xDA6C
#define R_AX_BT_COEX_CFG_5_C1 0xFA6C
#define B_AX_BT_TIME_SH 6
#define B_AX_BT_TIME_MSK 0x3ffffff
#define B_AX_BT_RPT_SAMPLE_RATE_SH 0
#define B_AX_BT_RPT_SAMPLE_RATE_MSK 0x3f

#define R_AX_BT_ACT_CFG 0xDA70
#define R_AX_BT_ACT_CFG_C1 0xFA70
#define B_AX_BT_EISR_EN_SH 16
#define B_AX_BT_EISR_EN_MSK 0xff
#define B_AX_BT_ACT_FALLING_ISR BIT(10)
#define B_AX_BT_ACT_RISING_ISR BIT(9)
#define B_AX_TDMA_TO_ISR BIT(8)
#define B_AX_BT_CH_SH 0
#define B_AX_BT_CH_MSK 0x7f

#define R_AX_BT_TIME_CNT 0xDA74
#define R_AX_BT_TIME_CNT_C1 0xFA74
#define B_AX_BT_TIME_CNT_SH 0
#define B_AX_BT_TIME_CNT_MSK 0xff

#define R_AX_WLACT_MASK_CTRL 0xDA7C
#define R_AX_WLACT_MASK_CTRL_C1 0xFA7C
#define B_AX_RX_RTS_NAV_SH 8
#define B_AX_RX_RTS_NAV_MSK 0xff
#define B_AX_RESET_RTS_SH 0
#define B_AX_RESET_RTS_MSK 0xff

#define R_AX_LTE_CTRL 0xDAF0
#define R_AX_LTE_CTRL_C1 0xFAF0
#define B_AX_LTE_SET BIT(31)
#define B_AX_LTE_RW BIT(30)
#define B_AX_LTE_RDY BIT(29)
#define B_AX_LTE_BYTE_EN_SH 16
#define B_AX_LTE_BYTE_EN_MSK 0xf
#define B_AX_LTE_ADDR_SH 0
#define B_AX_LTE_ADDR_MSK 0xffff

#define R_AX_LTE_WDATA 0xDAF4
#define R_AX_LTE_WDATA_C1 0xFAF4
#define B_AX_LTE_WDATA_SH 0
#define B_AX_LTE_WDATA_MSK 0xffffffffL

#define R_AX_LTE_RDATA 0xDAF8
#define R_AX_LTE_RDATA_C1 0xFAF8
#define B_AX_LTE_RDATA_SH 0
#define B_AX_LTE_RDATA_MSK 0xffffffffL

//
// WL_AX_Reg_CMAC_0.xls
//

//
// COMMON
//
#define B_AX_R_BIST_TMCK BIT(15)

//
// SCH
//
#define B_AX_PORT_RST_TSF_ADV BIT(1)
#define B_AX_SCH_RESP_CTRL BIT(0)

//
// PTCL
//

//
// CMAC_DMA
//

//
// TMAC
//
#define B_AX_TXBF_EN_ERROR_FLAG_CLR BIT(28)

//
// TRXPTCL
//
#define B_AX_WMAC_RMAC_BUSY_ABORT_RESP_TX_SH 24
#define B_AX_WMAC_RMAC_BUSY_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_NAV_ABORT_RESP_TX_SH 16
#define B_AX_WMAC_NAV_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_SEC_CCA_ABORT_RESP_TX_SH 8
#define B_AX_WMAC_SEC_CCA_ABORT_RESP_TX_MSK 0xff

#define R_AX_BFMER_CTRL_1 0xCD7C
#define R_AX_BFMER_CTRL_1_C1 0xED7C

//
// RMAC
//

//
// PWR
//

//
// BTCOEX
//

//
// WL_AX_Reg_CMAC_0.xls
//

//
// COMMON
//

#define R_AX_CMAC_TABLE 0xC008
#define R_AX_CMAC_TABLE_C1 0xE008
#define B_AX_CMAC_TABLE_IO_RST BIT(16)
#define B_AX_CMAC_TABLE_ADDR_HOLE_SH 0
#define B_AX_CMAC_TABLE_ADDR_HOLE_MSK 0xffff

#define R_AX_CMAC_HWSSN01 0xC020
#define R_AX_CMAC_HWSSN01_C1 0xE020
#define B_AX_HW_CMAC_SSN1_SH 16
#define B_AX_HW_CMAC_SSN1_MSK 0xfff
#define B_AX_HW_CMAC_SSN0_SH 0
#define B_AX_HW_CMAC_SSN0_MSK 0xfff

#define R_AX_CMAC_HWSSN23 0xC024
#define R_AX_CMAC_HWSSN23_C1 0xE024
#define B_AX_HW_CMAC_SSN3_SH 16
#define B_AX_HW_CMAC_SSN3_MSK 0xfff
#define B_AX_HW_CMAC_SSN2_SH 0
#define B_AX_HW_CMAC_SSN2_MSK 0xfff
#define B_AX_R_BIST_TMCK_W BIT(15)

#define R_AX_PARAM_BIST_RSTN 0xC050
#define R_AX_PARAM_BIST_RSTN_C1 0xE050
#define B_AX_BIST_RST_N_SH 0
#define B_AX_BIST_RST_N_MSK 0x7ff

#define R_AX_PARAM_BIST_DONE 0xC054
#define R_AX_PARAM_BIST_DONE_C1 0xE054
#define B_AX_BIST_DONE_SH 0
#define B_AX_BIST_DONE_MSK 0xffffffffL

#define R_AX_PARAM_BIST_FAIL 0xC058
#define R_AX_PARAM_BIST_FAIL_C1 0xE058
#define B_AX_BIST_FAIL_SH 0
#define B_AX_BIST_FAIL_MSK 0xffffffffL

#define R_AX_PARAM_DRF_PAUSE 0xC05C
#define R_AX_PARAM_DRF_PAUSE_C1 0xE05C
#define B_AX_BIST_DRF_PAUSE_CMAC_SH 0
#define B_AX_BIST_DRF_PAUSE_CMAC_MSK 0xffffffffL

#define R_AX_PARAM_BIST_RSTN_SHARE 0xC060
#define R_AX_PARAM_BIST_RSTN_SHARE_C1 0xE060
#define B_AX_R_BIST_RST_N_CMAC_SHARE_SH 0
#define B_AX_R_BIST_RST_N_CMAC_SHARE_MSK 0x1f

#define R_AX_PARAM_BIST_DONE_SHARE 0xC064
#define R_AX_PARAM_BIST_DONE_SHARE_C1 0xE064
#define B_AX_BIST_DONE_CMAC_SHARE_SH 0
#define B_AX_BIST_DONE_CMAC_SHARE_MSK 0xffffffffL

#define R_AX_PARAM_BIST_FAIL_SHARE 0xC068
#define R_AX_PARAM_BIST_FAIL_SHARE_C1 0xE068
#define B_AX_BIST_FAIL_CMAC_SHARE_SH 0
#define B_AX_BIST_FAIL_CMAC_SHARE_MSK 0xffffffffL

#define R_AX_RARAM_DRF_PAUSE_SHARE 0xC06C
#define R_AX_RARAM_DRF_PAUSE_SHARE_C1 0xE06C
#define B_AX_BIST_DRF_PAUSE_CMAC_SHARE_SH 0
#define B_AX_BIST_DRF_PAUSE_CMAC_SHARE_MSK 0xffffffffL
#define B_AX_GID_15_00_POSITION_SH 0
#define B_AX_GID_15_00_POSITION_MSK 0xffffffffL
#define B_AX_GID_31_16_POSITION_SH 0
#define B_AX_GID_31_16_POSITION_MSK 0xffffffffL
#define B_AX_GID_47_32_POSITION_SH 0
#define B_AX_GID_47_32_POSITION_MSK 0xffffffffL
#define B_AX_GID_63_48_POSITION_SH 0
#define B_AX_GID_63_48_POSITION_MSK 0xffffffffL
#define B_AX_GID_31_00_POSITION_EN_SH 0
#define B_AX_GID_31_00_POSITION_EN_MSK 0xffffffffL
#define B_AX_GID_63_32_POSITION_EN_SH 0
#define B_AX_GID_63_32_POSITION_EN_MSK 0xffffffffL
#define B_AX_FS_PSTIMER_6_INT_EN BIT(30)
#define B_AX_FS_PSTIMER_6_INT BIT(30)
#define B_AX_RDATA_158_SH 0
#define B_AX_RDATA_158_MSK 0xffffffffL
#define B_AX_RDATA_15C_SH 0
#define B_AX_RDATA_15C_MSK 0xffffffffL
#define B_AX_CMAC_FW_ERR_IDCT_EN BIT(16)
#define B_AX_PTCL_TX_IDLETO_IDCT_EN BIT(9)
#define B_AX_WMAC_RX_IDLETO_IDCT_EN BIT(8)
#define B_AX_CMAC_FW_ERR_IDCT BIT(16)
#define B_AX_PTCL_TX_IDLETO_IDCT BIT(9)
#define B_AX_WMAC_RX_IDLETO_IDCT BIT(8)
#define B_AX_DMAC_FW_ERR_IDCT_IMR BIT(31)
#define B_AX_DMAC_FW_TRIG_IDCT BIT(0)
#define B_AX_DMAC_FW_ERR_IDCT_SRC BIT(31)

//
// SCH
//
#define B_AX_CMAC_MGQ_MACID31_0_DROP_SH 0
#define B_AX_CMAC_MGQ_MACID31_0_DROP_MSK 0xffffffffL
#define B_AX_CMAC_MGQ_MACID63_32_DROP_SH 0
#define B_AX_CMAC_MGQ_MACID63_32_DROP_MSK 0xffffffffL
#define B_AX_CMAC_MGQ_MACID95_64_DROP_SH 0
#define B_AX_CMAC_MGQ_MACID95_64_DROP_MSK 0xffffffffL
#define B_AX_CMAC_MGQ_MACID127_96_DROP_SH 0
#define B_AX_CMAC_MGQ_MACID127_96_DROP_MSK 0xffffffffL
#define B_AX_SLOT_EXT_THD_SH 24
#define B_AX_SLOT_EXT_THD_MSK 0xf
#define B_AX_BURST_CNT_DOWN_TIME_SH 16
#define B_AX_BURST_CNT_DOWN_TIME_MSK 0x7f
#define B_AX_US_TIME_SH 8
#define B_AX_US_TIME_MSK 0xff
#define B_AX_SIFS_TIMEOUT_TB_AGGR_V1_SH 24
#define B_AX_SIFS_TIMEOUT_TB_AGGR_V1_MSK 0xff
#define B_AX_R_SIFS_AGGR_TIME_V1_SH 24
#define B_AX_R_SIFS_AGGR_TIME_V1_MSK 0xff
#define B_AX_TXPKTCTL_RST_EDCA_EN BIT(17)
#define B_AX_WMAC_RST_EDCA_EN BIT(16)
#define B_AX_EDCCA_PER20_BITMAP_SIFS_EN BIT(10)
#define B_AX_SCH_DBG_FORCE_ABORT_CNT_SH 24
#define B_AX_SCH_DBG_FORCE_ABORT_CNT_MSK 0xf
#define B_AX_SCH_ABORT_BRK_TB_EN BIT(12)
#define B_AX_SCH_ABORT_BRK_BURST_EN BIT(11)
#define B_AX_PORT_FUNC_EN_LOW_AUTO_RST BIT(10)
#define B_AX_SCH_CLK_GATING_DIS BIT(9)
#define B_AX_SCH_DBG_RST_EDCA_CLR_P BIT(7)
#define B_AX_SCH_DBG_RST_EDCA_EN BIT(6)
#define B_AX_SCH_FORCE_ABORT_P BIT(3)
#define B_AX_SCH_FORCE_ABORT_AUTO_EN BIT(2)
#define B_AX_CTN_TXEN_TWT_3 BIT(17)
#define B_AX_CTN_TXEN_TWT_2 BIT(16)
#define B_AX_PREBKF_TIME_NONAC_SH 8
#define B_AX_PREBKF_TIME_NONAC_MSK 0x1f
#define B_AX_TB_CHK_EDCCA_PER20 BIT(24)

#define R_AX_CTN_DRV_TXEN 0xC398
#define R_AX_CTN_DRV_TXEN_C1 0xE398
#define B_AX_TXFIAL_BRK_TXOP_EN BIT(9)
#define B_AX_PSTIMER6_EN BIT(27)
#define B_AX_PSTIMER6_SEL_SH 24
#define B_AX_PSTIMER6_SEL_MSK 0x7

#define R_AX_PSTIMER6 0xC5F4
#define R_AX_PSTIMER6_C1 0xE5F4
#define B_AX_PSTIMER6_VAL_SH 0
#define B_AX_PSTIMER6_VAL_MSK 0xffffffffL

//
// PTCL
//
#define B_AX_DIS_PTCL_CLK_GATING BIT(5)
#define B_AX_EN_MU2SU_CHK_PROTECT_PPDU BIT(19)
#define B_AX_RPT_TXOP_START_PROTECT BIT(18)
#define B_AX_RANDOM_GEN_CMD_ABORT_EN BIT(17)
#define B_AX_PHYTXON_ENDPS_RESP_CHK BIT(16)
#define B_AX_CTN_CHK_SEQ_REQ_EN BIT(15)
#define B_AX_PTCL_RLS_ALLFAIL_EN BIT(14)
#define B_AX_MAX_AGG_NUM_FIX_MODE_EN BIT(13)
#define B_AX_DIS_MURU_SEC_Q_EMPTY_CHK BIT(12)
#define B_AX_OFDM_LEN_TH_SH 20
#define B_AX_OFDM_LEN_TH_MSK 0xfff
#define B_AX_BAR_TXRATE_FOR_NULL_WD_SH 20
#define B_AX_BAR_TXRATE_FOR_NULL_WD_MSK 0xf
#define B_AX_OFDM_CCK_ERR_PROC BIT(6)
#define B_AX_PKT_LAST_TX BIT(5)
#define B_AX_ATM_PRI BIT(13)
#define B_AX_CMAC_DMA_BLOCK_TX_THD_SH 16
#define B_AX_CMAC_DMA_BLOCK_TX_THD_MSK 0x3f
#define B_AX_TXOP_END_RPT_EN BIT(10)

#define R_AX_PTCL_F2P_RLS 0xC664
#define R_AX_PTCL_F2P_RLS_C1 0xE664
#define B_AX_F2PRLS_PRTID_NEED_RPT_SH 24
#define B_AX_F2PRLS_PRTID_NEED_RPT_MSK 0x7
#define B_AX_F2PRLS_QUEID_NEED_RPT_SH 16
#define B_AX_F2PRLS_QUEID_NEED_RPT_MSK 0x3f
#define B_AX_F2PRLS_PRTID_NO_RPT_SH 8
#define B_AX_F2PRLS_PRTID_NO_RPT_MSK 0x7
#define B_AX_F2PRLS_QUEID_NO_RPT_SH 0
#define B_AX_F2PRLS_QUEID_NO_RPT_MSK 0x3f

#define R_AX_PTCL_PRELD_CTRL 0xC668
#define R_AX_PTCL_PRELD_CTRL_C1 0xE668
#define B_AX_PRELD_MGQ2_EN BIT(22)
#define B_AX_PRELD_MGQ1_EN BIT(21)
#define B_AX_PRELD_MGQ0_EN BIT(20)
#define B_AX_PRELD_HIQ_P4_EN BIT(19)
#define B_AX_PRELD_HIQ_P3_EN BIT(18)
#define B_AX_PRELD_HIQ_P2_EN BIT(17)
#define B_AX_PRELD_HIQ_P1_EN BIT(16)
#define B_AX_PRELD_HIQ_P0MB15_EN BIT(15)
#define B_AX_PRELD_HIQ_P0MB14_EN BIT(14)
#define B_AX_PRELD_HIQ_P0MB13_EN BIT(13)
#define B_AX_PRELD_HIQ_P0MB12_EN BIT(12)
#define B_AX_PRELD_HIQ_P0MB11_EN BIT(11)
#define B_AX_PRELD_HIQ_P0MB10_EN BIT(10)
#define B_AX_PRELD_HIQ_P0MB9_EN BIT(9)
#define B_AX_PRELD_HIQ_P0MB8_EN BIT(8)
#define B_AX_PRELD_HIQ_P0MB7_EN BIT(7)
#define B_AX_PRELD_HIQ_P0MB6_EN BIT(6)
#define B_AX_PRELD_HIQ_P0MB5_EN BIT(5)
#define B_AX_PRELD_HIQ_P0MB4_EN BIT(4)
#define B_AX_PRELD_HIQ_P0MB3_EN BIT(3)
#define B_AX_PRELD_HIQ_P0MB2_EN BIT(2)
#define B_AX_PRELD_HIQ_P0MB1_EN BIT(1)
#define B_AX_PRELD_HIQ_P0_EN BIT(0)
#define B_AX_DISABLE_TXOP_CFE BIT(31)
#define B_AX_DISABLE_LSIG_CFE BIT(30)
#define B_AX_CMAC_DMA_BLOCK_TX BIT(26)
#define B_AX_CMAC_DMA_BREAK_TXOP BIT(25)
#define B_AX_TXOP_BK_EN_V1_SH 16
#define B_AX_TXOP_BK_EN_V1_MSK 0x1ff
#define B_AX_TXQ_NAV_MSK_SH 24
#define B_AX_TXQ_NAV_MSK_MSK 0xff
#define B_AX_LSIG_TXOP_TXCMD_NAV BIT(18)
#define B_AX_RTS_NAV_TXOP BIT(17)
#define B_AX_BCN_DROP_DSTQUEID_SH 8
#define B_AX_BCN_DROP_DSTQUEID_MSK 0x3f
#define B_AX_BCN_DROP_PRTQUEID_SH 4
#define B_AX_BCN_DROP_PRTQUEID_MSK 0x7
#define B_AX_BCNQ_PKTIN_EN BIT(1)

#define R_AX_PTCL_IMR_2 0xC6B8
#define R_AX_PTCL_IMR_2_C1 0xE6B8
#define B_AX_PTCL_IMR2_SH 0
#define B_AX_PTCL_IMR2_MSK 0xffffffffL

#define R_AX_PTCL_ISR_2 0xC6BC
#define R_AX_PTCL_ISR_2_C1 0xE6BC
#define B_AX_PTCL_ISR2_SH 0
#define B_AX_PTCL_ISR2_MSK 0xffffffffL
#define B_AX_FSM1_TIMEOUT_ERR_INT_EN BIT(1)
#define B_AX_PTCL_IMR1_SH 0
#define B_AX_PTCL_IMR1_MSK 0xffffffffL
#define B_AX_PTCL_ISR1_SH 0
#define B_AX_PTCL_ISR1_MSK 0xffffffffL

#define R_AX_PTCL_F2P_INFO_PRI 0xC6D0
#define R_AX_PTCL_F2P_INFO_PRI_C1 0xE6D0
#define B_AX_F2PCMD_PKTID_INFO_PRI_SH 0
#define B_AX_F2PCMD_PKTID_INFO_PRI_MSK 0xffffffffL

#define R_AX_PTCL_F2P_INFO_0_1 0xC6D4
#define R_AX_PTCL_F2P_INFO_0_1_C1 0xE6D4
#define B_AX_F2PCMD_PKTID_INFO_S1_S0_SH 0
#define B_AX_F2PCMD_PKTID_INFO_S1_S0_MSK 0xffffffffL

#define R_AX_PTCL_F2P_INFO_2_3 0xC6D8
#define R_AX_PTCL_F2P_INFO_2_3_C1 0xE6D8
#define B_AX_F2PCMD_PKTID_INFO_S3_S2_SH 0
#define B_AX_F2PCMD_PKTID_INFO_S3_S2_MSK 0xffffffffL

#define R_AX_PTCL_F2P_INFO_4_5 0xC6DC
#define R_AX_PTCL_F2P_INFO_4_5_C1 0xE6DC
#define B_AX_F2PCMD_PKTID_INFO_S5_S4_SH 0
#define B_AX_F2PCMD_PKTID_INFO_S5_S4_MSK 0xffffffffL
#define B_AX_FSM1_TIMEOUT_THB_AX_UNIT_SH 8
#define B_AX_FSM1_TIMEOUT_THB_AX_UNIT_MSK 0x3
#define B_AX_RPT_ABORT_CNT_RST BIT(4)
#define B_AX_TX_ABORT_ALWAYS_END_CMD BIT(2)
#define B_AX_PTCL_TXOP_STAT BIT(8)
#define B_AX_RPT_CMAC_DBG_INFO_SEL_SH 12
#define B_AX_RPT_CMAC_DBG_INFO_SEL_MSK 0xf

#define R_AX_PTCL_ERR_FLAG 0xC6F8
#define R_AX_PTCL_ERR_FLAG_C1 0xE6F8

#define R_AX_PTCL_DBG_INFO_1 0xC6FC
#define R_AX_PTCL_DBG_INFO_1_C1 0xE6FC
#define B_AX_PTCL_RPT_CMAC_DBG_INFO_SH 0
#define B_AX_PTCL_RPT_CMAC_DBG_INFO_MSK 0xffff
#define B_AX_USER_CMD_VALID_SH 24
#define B_AX_USER_CMD_VALID_MSK 0xff

#define R_AX_USR_CMD_U4 0xC718
#define R_AX_USR_CMD_U4_C1 0xE718
#define B_AX_USER_CMD_U4_SH 0
#define B_AX_USER_CMD_U4_MSK 0xffffffffL

#define R_AX_USR_CMD_U5 0xC71C
#define R_AX_USR_CMD_U5_C1 0xE71C
#define B_AX_USER_CMD_U5_SH 0
#define B_AX_USER_CMD_U5_MSK 0xffffffffL

#define R_AX_USR_CMD_U6 0xC720
#define R_AX_USR_CMD_U6_C1 0xE720
#define B_AX_USER_CMD_U6_SH 0
#define B_AX_USER_CMD_U6_MSK 0xffffffffL

#define R_AX_USR_CMD_U7 0xC724
#define R_AX_USR_CMD_U7_C1 0xE724
#define B_AX_USER_CMD_U7_SH 0
#define B_AX_USER_CMD_U7_MSK 0xffffffffL

#define R_AX_LEN_CMD_U0_V1 0xC72C
#define R_AX_LEN_CMD_U0_V1_C1 0xE72C

#define R_AX_LEN_CMD_U1_V1 0xC730
#define R_AX_LEN_CMD_U1_V1_C1 0xE730

#define R_AX_LEN_CMD_U2_V1 0xC734
#define R_AX_LEN_CMD_U2_V1_C1 0xE734

#define R_AX_LEN_CMD_U3_V1 0xC738
#define R_AX_LEN_CMD_U3_V1_C1 0xE738

#define R_AX_LEN_CMD_U4 0xC73C
#define R_AX_LEN_CMD_U4_C1 0xE73C
#define B_AX_LEN_CMD_U4_SH 0
#define B_AX_LEN_CMD_U4_MSK 0xffffffffL

#define R_AX_LEN_CMD_U5 0xC740
#define R_AX_LEN_CMD_U5_C1 0xE740
#define B_AX_LEN_CMD_U5_SH 0
#define B_AX_LEN_CMD_U5_MSK 0xffffffffL

#define R_AX_LEN_CMD_U6 0xC744
#define R_AX_LEN_CMD_U6_C1 0xE744
#define B_AX_LEN_CMD_U6_SH 0
#define B_AX_LEN_CMD_U6_MSK 0xffffffffL

#define R_AX_LEN_CMD_U7 0xC748
#define R_AX_LEN_CMD_U7_C1 0xE748
#define B_AX_LEN_CMD_U7_SH 0
#define B_AX_LEN_CMD_U7_MSK 0xffffffffL

#define R_AX_USR_INFO_U0 0xC74C
#define R_AX_USR_INFO_U0_C1 0xE74C
#define B_AX_USB_AX_IFO_U0_SH 0
#define B_AX_USB_AX_IFO_U0_MSK 0xffffffffL

#define R_AX_USR_INFO_U1 0xC750
#define R_AX_USR_INFO_U1_C1 0xE750
#define B_AX_USB_AX_IFO_U1_SH 0
#define B_AX_USB_AX_IFO_U1_MSK 0xffffffffL

#define R_AX_USR_INFO_U2 0xC754
#define R_AX_USR_INFO_U2_C1 0xE754
#define B_AX_USB_AX_IFO_U2_SH 0
#define B_AX_USB_AX_IFO_U2_MSK 0xffffffffL

#define R_AX_USR_INFO_U3 0xC758
#define R_AX_USR_INFO_U3_C1 0xE758
#define B_AX_USB_AX_IFO_U3_SH 0
#define B_AX_USB_AX_IFO_U3_MSK 0xffffffffL

#define R_AX_USR_INFO_U4 0xC75C
#define R_AX_USR_INFO_U4_C1 0xE75C
#define B_AX_USB_AX_IFO_U4_SH 0
#define B_AX_USB_AX_IFO_U4_MSK 0xffffffffL

#define R_AX_USR_INFO_U5 0xC760
#define R_AX_USR_INFO_U5_C1 0xE760
#define B_AX_USB_AX_IFO_U5_SH 0
#define B_AX_USB_AX_IFO_U5_MSK 0xffffffffL

#define R_AX_USR_INFO_U6 0xC764
#define R_AX_USR_INFO_U6_C1 0xE764
#define B_AX_USB_AX_IFO_U6_SH 0
#define B_AX_USB_AX_IFO_U6_MSK 0xffffffffL

#define R_AX_USR_INFO_U7 0xC768
#define R_AX_USR_INFO_U7_C1 0xE768
#define B_AX_USB_AX_IFO_U7_SH 0
#define B_AX_USB_AX_IFO_U7_MSK 0xffffffffL

#define R_AX_PTCL_TX_MACID_0_V1 0xC76C
#define R_AX_PTCL_TX_MACID_0_V1_C1 0xE76C

#define R_AX_PTCL_TX_MACID_1 0xC770
#define R_AX_PTCL_TX_MACID_1_C1 0xE770
#define B_AX_TX_MACID_7_SH 24
#define B_AX_TX_MACID_7_MSK 0xff
#define B_AX_TX_MACID_6_SH 16
#define B_AX_TX_MACID_6_MSK 0xff
#define B_AX_TX_MACID_5_SH 8
#define B_AX_TX_MACID_5_MSK 0xff
#define B_AX_TX_MACID_4_SH 0
#define B_AX_TX_MACID_4_MSK 0xff

#define R_AX_PTCL_F2P_INFO_6_7 0xC774
#define R_AX_PTCL_F2P_INFO_6_7_C1 0xE774
#define B_AX_F2PCMD_PKTID_INFO_S7_S6_SH 0
#define B_AX_F2PCMD_PKTID_INFO_S7_S6_MSK 0xffffffffL

#define R_AX_PTCL_SIGB_PADDING_0 0xC7E0
#define R_AX_PTCL_SIGB_PADDING_0_C1 0xE7E0
#define B_AX_SIGB_PADDING_0_SH 0
#define B_AX_SIGB_PADDING_0_MSK 0xffffffffL

#define R_AX_PTCL_SIGB_PADDING_1 0xC7E4
#define R_AX_PTCL_SIGB_PADDING_1_C1 0xE7E4
#define B_AX_SIGB_PADDING_1_SH 0
#define B_AX_SIGB_PADDING_1_MSK 0xffffffffL

#define R_AX_PTCL_SIGB_PADDING_2 0xC7E8
#define R_AX_PTCL_SIGB_PADDING_2_C1 0xE7E8
#define B_AX_SIGB_PADDING_2_SH 0
#define B_AX_SIGB_PADDING_2_MSK 0xffffffffL

#define R_AX_PTCL_SIGB_PADDING_3 0xC7EC
#define R_AX_PTCL_SIGB_PADDING_3_C1 0xE7EC
#define B_AX_SIGB_PADDING_3_SH 0
#define B_AX_SIGB_PADDING_3_MSK 0xffffffffL

#define R_AX_PTCL_SIGB_HW_SETTING 0xC7F0
#define R_AX_PTCL_SIGB_HW_SETTING_C1 0xE7F0
#define B_AX_SIGB_HW_TIME_LMT_SH 0
#define B_AX_SIGB_HW_TIME_LMT_MSK 0x7

//
// CMAC_DMA
//

#define R_AX_RX_ERR_FLAG 0xC800
#define R_AX_RX_ERR_FLAG_C1 0xE800
#define B_AX_RX_GET_NO_PAGE_ERR BIT(31)
#define B_AX_RX_GET_NULL_PKT_ERR BIT(30)
#define B_AX_RX_RU0_FSM_HANG_ERR BIT(29)
#define B_AX_RX_RU1_FSM_HANG_ERR BIT(28)
#define B_AX_RX_RU2_FSM_HANG_ERR BIT(27)
#define B_AX_RX_RU3_FSM_HANG_ERR BIT(26)
#define B_AX_RX_RU4_FSM_HANG_ERR BIT(25)
#define B_AX_RX_RU5_FSM_HANG_ERR BIT(24)
#define B_AX_RX_RU6_FSM_HANG_ERR BIT(23)
#define B_AX_RX_RU7_FSM_HANG_ERR BIT(22)
#define B_AX_RX_RXSTS_FSM_HANG_ERR BIT(21)
#define B_AX_RX_CSI_FSM_HANG_ERR BIT(20)
#define B_AX_RX_TXRPT_FSM_HANG_ERR BIT(19)
#define B_AX_RX_F2PCMD_FSM_HANG_ERR BIT(18)
#define B_AX_RX_RU0_ZERO_LEN_ERR BIT(17)
#define B_AX_RX_RU1_ZERO_LEN_ERR BIT(16)
#define B_AX_RX_RU2_ZERO_LEN_ERR BIT(15)
#define B_AX_RX_RU3_ZERO_LEN_ERR BIT(14)
#define B_AX_RX_RU4_ZERO_LEN_ERR BIT(13)
#define B_AX_RX_RU5_ZERO_LEN_ERR BIT(12)
#define B_AX_RX_RU6_ZERO_LEN_ERR BIT(11)
#define B_AX_RX_RU7_ZERO_LEN_ERR BIT(10)
#define B_AX_RX_RXSTS_ZERO_LEN_ERR BIT(9)
#define B_AX_RX_CSI_ZERO_LEN_ERR BIT(8)
#define B_AX_PLE_DATA_OPT_FSM_HANG BIT(7)
#define B_AX_PLE_RXDATA_REQ_BUF_FSM_HANG BIT(6)
#define B_AX_PLE_TXRPT_REQ_BUF_FSM_HANG BIT(5)
#define B_AX_PLE_WD_OPT_FSM_HANG BIT(4)
#define B_AX_PLE_ENQ_FSM_HANG BIT(3)
#define B_AX_RXDATA_ENQUE_ORDER_ERR BIT(2)
#define B_AX_RXSTS_ENQUE_ORDER_ERR BIT(1)
#define B_AX_RX_CSI_PKT_NUM_ERR BIT(0)

#define R_AX_RX_ERR_FLAG_IMR 0xC804
#define R_AX_RX_ERR_FLAG_IMR_C1 0xE804
#define B_AX_RX_GET_NULL_PKT_ERR_MSK BIT(30)
#define B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK BIT(29)
#define B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK BIT(28)
#define B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK BIT(27)
#define B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK BIT(26)
#define B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK BIT(25)
#define B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK BIT(24)
#define B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK BIT(23)
#define B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK BIT(22)
#define B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK BIT(21)
#define B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK BIT(20)
#define B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK BIT(19)
#define B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK BIT(18)
#define B_AX_RX_RU0_ZERO_LEN_ERR_MSK BIT(17)
#define B_AX_RX_RU1_ZERO_LEN_ERR_MSK BIT(16)
#define B_AX_RX_RU2_ZERO_LEN_ERR_MSK BIT(15)
#define B_AX_RX_RU3_ZERO_LEN_ERR_MSK BIT(14)
#define B_AX_RX_RU4_ZERO_LEN_ERR_MSK BIT(13)
#define B_AX_RX_RU5_ZERO_LEN_ERR_MSK BIT(12)
#define B_AX_RX_RU6_ZERO_LEN_ERR_MSK BIT(11)
#define B_AX_RX_RU7_ZERO_LEN_ERR_MSK BIT(10)
#define B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK BIT(9)
#define B_AX_RX_CSI_ZERO_LEN_ERR_MSK BIT(8)
#define B_AX_PLE_DATA_OPT_FSM_HANG_MSK BIT(7)
#define B_AX_PLE_RXDATA_REQ_BUF_FSM_HANG_MSK BIT(6)
#define B_AX_PLE_TXRPT_REQ_BUF_FSM_HANG_MSK BIT(5)
#define B_AX_PLE_WD_OPT_FSM_HANG_MSK BIT(4)
#define B_AX_PLE_ENQ_FSM_HANG_MSK BIT(3)
#define B_AX_RXDATA_ENQUE_ORDER_ERR_MSK BIT(2)
#define B_AX_RXSTS_ENQUE_ORDER_ERR_MSK BIT(1)
#define B_AX_RX_CSI_PKT_NUM_ERR_MSK BIT(0)

#define R_AX_RX_CTRL0 0xC808
#define R_AX_RX_CTRL0_C1 0xE808
#define B_AX_DLE_CLOCK_FORCE_V1 BIT(31)
#define B_AX_TXDMA_CLOCK_FORCE_V1 BIT(30)
#define B_AX_RXDMA_CLOCK_FORCE_V1 BIT(29)
#define B_AX_RXDMA_DEFAULT_PAGE_V1_SH 24
#define B_AX_RXDMA_DEFAULT_PAGE_V1_MSK 0x1f
#define B_AX_RXDMA_CSI_TGT_QUEID_SH 18
#define B_AX_RXDMA_CSI_TGT_QUEID_MSK 0x3f
#define B_AX_RXDMA_CSI_TGT_PRID_SH 15
#define B_AX_RXDMA_CSI_TGT_PRID_MSK 0x7
#define B_AX_RXDMA_DIS_CSI_RELEASE_V1 BIT(14)
#define B_AX_CSI_PTR_FULL_MODE_V1 BIT(13)
#define B_AX_RXDATA_PTR_FULL_MODE BIT(12)
#define B_AX_RXSTS_PTR_FULL_MODE_V1 BIT(11)
#define B_AX_TXRPT_FULL_RSV_DEPTH_V1_SH 8
#define B_AX_TXRPT_FULL_RSV_DEPTH_V1_MSK 0x7
#define B_AX_RXDATA_FULL_RSV_DEPTH_SH 5
#define B_AX_RXDATA_FULL_RSV_DEPTH_MSK 0x7
#define B_AX_RXSTS_FULL_RSV_DEPTH_V1_SH 2
#define B_AX_RXSTS_FULL_RSV_DEPTH_V1_MSK 0x7
#define B_AX_ORDER_FIFO_CNT_SH 0
#define B_AX_ORDER_FIFO_CNT_MSK 0x3

#define R_AX_RX_CTRL1 0xC80C
#define R_AX_RX_CTRL1_C1 0xE80C
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW_EN BIT(31)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW_V1_SH 25
#define B_AX_RXDMA_TXRPT_QUEUE_ID_SW_V1_MSK 0x3f
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW_EN BIT(24)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW_V1_SH 18
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_SW_V1_MSK 0x3f
#define B_AX_RXDMA_TXRPT_QUEUE_ID_TGT_SW_EN BIT(17)
#define B_AX_RXDMA_TXRPT_QUEUE_ID_TGT_SW_1_SH 11
#define B_AX_RXDMA_TXRPT_QUEUE_ID_TGT_SW_1_MSK 0x3f
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_EN BIT(10)
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_1_SH 4
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_1_MSK 0x3f
#define B_AX_ORDER_FIFO_OUT BIT(3)
#define B_AX_ORDER_FIFO_EMPTY BIT(2)
#define B_AX_DBG_SEL_SH 0
#define B_AX_DBG_SEL_MSK 0x3

#define R_AX_RX_CTRL2 0xC810
#define R_AX_RX_CTRL2_C1 0xE810
#define B_AX_DLE_WDE_STATE_V1_SH 30
#define B_AX_DLE_WDE_STATE_V1_MSK 0x3
#define B_AX_DLE_PLE_STATE_V1_SH 28
#define B_AX_DLE_PLE_STATE_V1_MSK 0x3
#define B_AX_DLE_REQ_BUF_STATE_SH 26
#define B_AX_DLE_REQ_BUF_STATE_MSK 0x3
#define B_AX_DLE_ENQ_STATE_V1 BIT(25)
#define B_AX_RX_DBG_SEL_SH 19
#define B_AX_RX_DBG_SEL_MSK 0x3f
#define B_AX_MACRX_CS_SH 14
#define B_AX_MACRX_CS_MSK 0x1f
#define B_AX_RXSTS_CS_SH 9
#define B_AX_RXSTS_CS_MSK 0x1f
#define B_AX_ERR_INDICATOR BIT(5)
#define B_AX_TXRPT_CS_SH 0
#define B_AX_TXRPT_CS_MSK 0x1f

#define R_AX_RX_INFO_RU0RU1 0xC814
#define R_AX_RX_INFO_RU0RU1_C1 0xE814
#define B_AX_RU1_IS_REQ_BUF BIT(29)
#define B_AX_RU1_IS_ENQ BIT(28)
#define B_AX_RU0_IS_REQ_BUF BIT(13)
#define B_AX_RU0_IS_ENQ BIT(12)

#define R_AX_RX_INFO_RU2RU3 0xC818
#define R_AX_RX_INFO_RU2RU3_C1 0xE818
#define B_AX_RU3_IS_REQ_BUF BIT(29)
#define B_AX_RU3_IS_ENQ BIT(28)
#define B_AX_RU2_IS_REQ_BUF BIT(13)
#define B_AX_RU2_IS_ENQ BIT(12)

#define R_AX_RX_INFO_RU4RU5 0xC81C
#define R_AX_RX_INFO_RU4RU5_C1 0xE81C
#define B_AX_RU5_IS_IDLE BIT(31)
#define B_AX_RU5_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU5_IS_REQ_BUF BIT(29)
#define B_AX_RU5_IS_ENQ BIT(28)
#define B_AX_RU5_WR_PKT_ID_SH 16
#define B_AX_RU5_WR_PKT_ID_MSK 0xfff
#define B_AX_RU4_IS_IDLE BIT(15)
#define B_AX_RU4_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU4_IS_REQ_BUF BIT(13)
#define B_AX_RU4_IS_ENQ BIT(12)
#define B_AX_RU4_WR_PKT_ID_SH 0
#define B_AX_RU4_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_RU6RU7 0xC820
#define R_AX_RX_INFO_RU6RU7_C1 0xE820
#define B_AX_RU7_IS_IDLE BIT(31)
#define B_AX_RU7_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU7_IS_REQ_BUF BIT(29)
#define B_AX_RU7_IS_ENQ BIT(28)
#define B_AX_RU7_WR_PKT_ID_SH 16
#define B_AX_RU7_WR_PKT_ID_MSK 0xfff
#define B_AX_RU6_IS_IDLE BIT(15)
#define B_AX_RU6_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU6_IS_REQ_BUF BIT(13)
#define B_AX_RU6_IS_ENQ BIT(12)
#define B_AX_RU6_WR_PKT_ID_SH 0
#define B_AX_RU6_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_F2P_TXRPT 0xC824
#define R_AX_RX_INFO_F2P_TXRPT_C1 0xE824
#define B_AX_F2PCMD_IS_IDLE_V1 BIT(31)
#define B_AX_F2PCMD_RXDATA_RECOVER_MANNUL_V1 BIT(30)
#define B_AX_F2PCMD_IS_REQ_BUF BIT(29)
#define B_AX_F2PCMD_IS_ENQ BIT(28)
#define B_AX_F2PCMD_WR_PKT_ID_V1_SH 16
#define B_AX_F2PCMD_WR_PKT_ID_V1_MSK 0xfff
#define B_AX_TXRPT_IS_IDLE_V1 BIT(15)
#define B_AX_TXRPT_RXDATA_RECOVER_MANNUL_V1 BIT(14)
#define B_AX_TXRPT_IS_REQ_BUF BIT(13)
#define B_AX_TXRPT_IS_ENQ BIT(12)
#define B_AX_TXRPT_WR_PKT_ID_V1_SH 0
#define B_AX_TXRPT_WR_PKT_ID_V1_MSK 0xfff

#define R_AX_RX_INFO_RXSTS 0xC828
#define R_AX_RX_INFO_RXSTS_C1 0xE828
#define B_AX_ENQ_FIFO_EMPTY BIT(31)
#define B_AX_RXSTS_IS_REQ_BUF BIT(13)
#define B_AX_RXSTS_IS_ENQ BIT(12)

#define R_AX_RX_INFO_CSI 0xC82C
#define R_AX_RX_INFO_CSI_C1 0xE82C
#define B_AX_CSI_PKTID_1_VALID_V1 BIT(31)
#define B_AX_CSI_PKTID_1_V1_SH 16
#define B_AX_CSI_PKTID_1_V1_MSK 0xfff
#define B_AX_CSI_PKTID_0_VALID_V1 BIT(15)
#define B_AX_CSI_PKTID_0_V1_SH 0
#define B_AX_CSI_PKTID_0_V1_MSK 0xfff

#define R_AX_RX_DEBUG_OUT 0xC830
#define R_AX_RX_DEBUG_OUT_C1 0xE830
#define B_AX_RXDMA_DBG_OUT_SH 0
#define B_AX_RXDMA_DBG_OUT_MSK 0xffffffffL

#define R_AX_TX_FIFO_INFO_RU0RU1 0xC834
#define R_AX_TX_FIFO_INFO_RU0RU1_C1 0xE834
#define B_AX_TXDMA_RU1_CNT_SH 16
#define B_AX_TXDMA_RU1_CNT_MSK 0xffff
#define B_AX_TXDMA_RU0_CNT_SH 0
#define B_AX_TXDMA_RU0_CNT_MSK 0xffff

#define R_AX_TX_FIFO_INFO_RU2RU3 0xC838
#define R_AX_TX_FIFO_INFO_RU2RU3_C1 0xE838
#define B_AX_TXDMA_RU3_CNT_SH 16
#define B_AX_TXDMA_RU3_CNT_MSK 0xffff
#define B_AX_TXDMA_RU2_CNT_SH 0
#define B_AX_TXDMA_RU2_CNT_MSK 0xffff

#define R_AX_TX_FIFO_INFO_RU4RU5 0xC83C
#define R_AX_TX_FIFO_INFO_RU4RU5_C1 0xE83C
#define B_AX_TXDMA_RU5_CNT_SH 16
#define B_AX_TXDMA_RU5_CNT_MSK 0xffff
#define B_AX_TXDMA_RU4_CNT_SH 0
#define B_AX_TXDMA_RU4_CNT_MSK 0xffff

#define R_AX_TX_FIFO_INFO_RU6RU7 0xC840
#define R_AX_TX_FIFO_INFO_RU6RU7_C1 0xE840
#define B_AX_TXDMA_RU7_CNT_SH 16
#define B_AX_TXDMA_RU7_CNT_MSK 0xffff
#define B_AX_TXDMA_RU6_CNT_SH 0
#define B_AX_TXDMA_RU6_CNT_MSK 0xffff

#define R_AX_TXDMA_CTRL 0xC844
#define R_AX_TXDMA_CTRL_C1 0xE844
#define B_AX_TX_CSI_MODE BIT(31)
#define B_AX_TX_FINISH_REQ_V1 BIT(30)
#define B_AX_REQ_WD_PLD_ID_CS_V1_SH 28
#define B_AX_REQ_WD_PLD_ID_CS_V1_MSK 0x3
#define B_AX_WD_ARB_RU_V1_SH 25
#define B_AX_WD_ARB_RU_V1_MSK 0x7
#define B_AX_PL_ARB_RU_V1_SH 22
#define B_AX_PL_ARB_RU_V1_MSK 0x7
#define B_AX_TXDMA_DBG_SEL_V1_SH 16
#define B_AX_TXDMA_DBG_SEL_V1_MSK 0x3f
#define B_AX_TXDMA_DEFAULT_PAGE_SH 11
#define B_AX_TXDMA_DEFAULT_PAGE_MSK 0x1f

#define R_AX_TX_INFO_RU0 0xC848
#define R_AX_TX_INFO_RU0_C1 0xE848
#define B_AX_RU0_VLD BIT(31)
#define B_AX_RU0_WAIT_FINISH BIT(30)
#define B_AX_RU0_CUR_WD_ID_V1_SH 18
#define B_AX_RU0_CUR_WD_ID_V1_MSK 0xfff
#define B_AX_RU0_CUR_PL_ID_V1_SH 6
#define B_AX_RU0_CUR_PL_ID_V1_MSK 0xfff
#define B_AX_RU0_READ_CS_V1_SH 3
#define B_AX_RU0_READ_CS_V1_MSK 0x7
#define B_AX_RU0_WRITE_CS_V1_SH 0
#define B_AX_RU0_WRITE_CS_V1_MSK 0x7

#define R_AX_TX_INFO_RU1 0xC84C
#define R_AX_TX_INFO_RU1_C1 0xE84C
#define B_AX_RU1_VLD BIT(31)
#define B_AX_RU1_WAIT_FINISH BIT(30)
#define B_AX_RU1_CUR_WD_ID_V1_SH 18
#define B_AX_RU1_CUR_WD_ID_V1_MSK 0xfff
#define B_AX_RU1_CUR_PL_ID_V1_SH 6
#define B_AX_RU1_CUR_PL_ID_V1_MSK 0xfff
#define B_AX_RU1_READ_CS_V1_SH 3
#define B_AX_RU1_READ_CS_V1_MSK 0x7
#define B_AX_RU1_WRITE_CS_V1_SH 0
#define B_AX_RU1_WRITE_CS_V1_MSK 0x7

#define R_AX_TX_INFO_RU2 0xC850
#define R_AX_TX_INFO_RU2_C1 0xE850
#define B_AX_RU2_VLD BIT(31)
#define B_AX_RU2_WAIT_FINISH BIT(30)
#define B_AX_RU2_CUR_WD_ID_V1_SH 18
#define B_AX_RU2_CUR_WD_ID_V1_MSK 0xfff
#define B_AX_RU2_CUR_PL_ID_V1_SH 6
#define B_AX_RU2_CUR_PL_ID_V1_MSK 0xfff
#define B_AX_RU2_READ_CS_V1_SH 3
#define B_AX_RU2_READ_CS_V1_MSK 0x7
#define B_AX_RU2_WRITE_CS_V1_SH 0
#define B_AX_RU2_WRITE_CS_V1_MSK 0x7

#define R_AX_TX_INFO_RU3 0xC854
#define R_AX_TX_INFO_RU3_C1 0xE854
#define B_AX_RU3_VLD BIT(31)
#define B_AX_RU3_WAIT_FINISH BIT(30)
#define B_AX_RU3_CUR_WD_ID_V1_SH 18
#define B_AX_RU3_CUR_WD_ID_V1_MSK 0xfff
#define B_AX_RU3_CUR_PL_ID_V1_SH 6
#define B_AX_RU3_CUR_PL_ID_V1_MSK 0xfff
#define B_AX_RU3_READ_CS_V1_SH 3
#define B_AX_RU3_READ_CS_V1_MSK 0x7
#define B_AX_RU3_WRITE_CS_V1_SH 0
#define B_AX_RU3_WRITE_CS_V1_MSK 0x7

#define R_AX_TX_INFO_RU4 0xC858
#define R_AX_TX_INFO_RU4_C1 0xE858
#define B_AX_RU4_VLD BIT(31)
#define B_AX_RU4_WAIT_FINISH BIT(30)
#define B_AX_RU4_CUR_WD_ID_SH 18
#define B_AX_RU4_CUR_WD_ID_MSK 0xfff
#define B_AX_RU4_CUR_PL_ID_SH 6
#define B_AX_RU4_CUR_PL_ID_MSK 0xfff
#define B_AX_RU4_READ_CS_SH 3
#define B_AX_RU4_READ_CS_MSK 0x7
#define B_AX_RU4_WRITE_CS_SH 0
#define B_AX_RU4_WRITE_CS_MSK 0x7

#define R_AX_TX_INFO_RU5 0xC85C
#define R_AX_TX_INFO_RU5_C1 0xE85C
#define B_AX_RU5_VLD BIT(31)
#define B_AX_RU5_WAIT_FINISH BIT(30)
#define B_AX_RU5_CUR_WD_ID_SH 18
#define B_AX_RU5_CUR_WD_ID_MSK 0xfff
#define B_AX_RU5_CUR_PL_ID_SH 6
#define B_AX_RU5_CUR_PL_ID_MSK 0xfff
#define B_AX_RU5_READ_CS_SH 3
#define B_AX_RU5_READ_CS_MSK 0x7
#define B_AX_RU5_WRITE_CS_SH 0
#define B_AX_RU5_WRITE_CS_MSK 0x7

#define R_AX_TX_INFO_RU6 0xC860
#define R_AX_TX_INFO_RU6_C1 0xE860
#define B_AX_RU6_VLD BIT(31)
#define B_AX_RU6_WAIT_FINISH BIT(30)
#define B_AX_RU6_CUR_WD_ID_SH 18
#define B_AX_RU6_CUR_WD_ID_MSK 0xfff
#define B_AX_RU6_CUR_PL_ID_SH 6
#define B_AX_RU6_CUR_PL_ID_MSK 0xfff
#define B_AX_RU6_READ_CS_SH 3
#define B_AX_RU6_READ_CS_MSK 0x7
#define B_AX_RU6_WRITE_CS_SH 0
#define B_AX_RU6_WRITE_CS_MSK 0x7

#define R_AX_TX_INFO_RU7 0xC864
#define R_AX_TX_INFO_RU7_C1 0xE864
#define B_AX_RU7_VLD BIT(31)
#define B_AX_RU7_WAIT_FINISH BIT(30)
#define B_AX_RU7_CUR_WD_ID_SH 18
#define B_AX_RU7_CUR_WD_ID_MSK 0xfff
#define B_AX_RU7_CUR_PL_ID_SH 6
#define B_AX_RU7_CUR_PL_ID_MSK 0xfff
#define B_AX_RU7_READ_CS_SH 3
#define B_AX_RU7_READ_CS_MSK 0x7
#define B_AX_RU7_WRITE_CS_SH 0
#define B_AX_RU7_WRITE_CS_MSK 0x7

#define R_AX_TX_INFO_CSI 0xC868
#define R_AX_TX_INFO_CSI_C1 0xE868
#define B_AX_CSI_VLD BIT(31)
#define B_AX_CSI_WAIT_FINISH BIT(30)
#define B_AX_CSI_PRE_EN BIT(29)
#define B_AX_CSI_TX_DONE_MONITOR BIT(28)
#define B_AX_CSI_CUR_PL_ID_SH 6
#define B_AX_CSI_CUR_PL_ID_MSK 0xfff
#define B_AX_CSI_READ_CS_SH 3
#define B_AX_CSI_READ_CS_MSK 0x7
#define B_AX_CSI_WRITE_CS_SH 0
#define B_AX_CSI_WRITE_CS_MSK 0x7

#define R_AX_TX_ERR_FLAG 0xC86C
#define R_AX_TX_ERR_FLAG_C1 0xE86C
#define B_AX_TX_RU0_FSM_HANG_ERR BIT(31)
#define B_AX_TX_RU1_FSM_HANG_ERR BIT(30)
#define B_AX_TX_RU2_FSM_HANG_ERR BIT(29)
#define B_AX_TX_RU3_FSM_HANG_ERR BIT(28)
#define B_AX_TX_RU4_FSM_HANG_ERR BIT(27)
#define B_AX_TX_RU5_FSM_HANG_ERR BIT(26)
#define B_AX_TX_RU6_FSM_HANG_ERR BIT(25)
#define B_AX_TX_RU7_FSM_HANG_ERR BIT(24)
#define B_AX_TX_RU8_FSM_HANG_ERR BIT(23)
#define B_AX_TX_RU9_FSM_HANG_ERR BIT(22)
#define B_AX_TX_RU10_FSM_HANG_ERR BIT(21)
#define B_AX_TX_RU11_FSM_HANG_ERR BIT(20)
#define B_AX_TX_RU12_FSM_HANG_ERR BIT(19)
#define B_AX_TX_RU13_FSM_HANG_ERR BIT(18)
#define B_AX_TX_RU14_FSM_HANG_ERR BIT(17)
#define B_AX_TX_RU15_FSM_HANG_ERR BIT(16)
#define B_AX_TX_CSI_FSM_HANG_ERR BIT(15)
#define B_AX_TX_WD_PLD_ID_FSM_HANG_ERR BIT(14)

#define R_AX_TX_ERR_FLAG_IMR 0xC870
#define R_AX_TX_ERR_FLAG_IMR_C1 0xE870
#define B_AX_TX_RU0_FSM_HANG_ERR_MSK BIT(31)
#define B_AX_TX_RU1_FSM_HANG_ERR_MSK BIT(30)
#define B_AX_TX_RU2_FSM_HANG_ERR_MSK BIT(29)
#define B_AX_TX_RU3_FSM_HANG_ERR_MSK BIT(28)
#define B_AX_TX_RU4_FSM_HANG_ERR_MSK BIT(27)
#define B_AX_TX_RU5_FSM_HANG_ERR_MSK BIT(26)
#define B_AX_TX_RU6_FSM_HANG_ERR_MSK BIT(25)
#define B_AX_TX_RU7_FSM_HANG_ERR_MSK BIT(24)
#define B_AX_TX_RU8_FSM_HANG_ERR_MSK BIT(23)
#define B_AX_TX_RU9_FSM_HANG_ERR_MSK BIT(22)
#define B_AX_TX_RU10_FSM_HANG_ERR_MSK BIT(21)
#define B_AX_TX_RU11_FSM_HANG_ERR_MSK BIT(20)
#define B_AX_TX_RU12_FSM_HANG_ERR_MSK BIT(19)
#define B_AX_TX_RU13_FSM_HANG_ERR_MSK BIT(18)
#define B_AX_TX_RU14_FSM_HANG_ERR_MSK BIT(17)
#define B_AX_TX_RU15_FSM_HANG_ERR_MSK BIT(16)
#define B_AX_TX_CSI_FSM_HANG_ERR_MSK BIT(15)
#define B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK BIT(14)

#define R_AX_TX_DBG_OUT 0xC874
#define R_AX_TX_DBG_OUT_C1 0xE874
#define B_AX_TXDMA_DBG_OUT_SH 0
#define B_AX_TXDMA_DBG_OUT_MSK 0xffffffffL

#define R_AX_MISC_CTRL 0xC878
#define R_AX_MISC_CTRL_C1 0xE878
#define B_AX_QARBIT_SEL BIT(31)
#define B_AX_RX_FSM_1MS_TIMEOUT_SH 24
#define B_AX_RX_FSM_1MS_TIMEOUT_MSK 0x7f
#define B_AX_TX_FSM_1MS_TIMEOUT_SH 17
#define B_AX_TX_FSM_1MS_TIMEOUT_MSK 0x7f
#define B_AX_QARBIT_FORCE BIT(16)
#define B_AX_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_2_SH 10
#define B_AX_RXDMA_TXRPRT_QUEUE_ID_TGT_SW_2_MSK 0x3f
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_2_SH 4
#define B_AX_RXDMA_F2PCMD_QUEUE_ID_TGT_SW_2_MSK 0x3f
#define B_AX_QARBIT_FORCE2 BIT(3)
#define B_AX_FSM_LOCK_SEL BIT(2)

#define R_AX_RX_INFO_CSI_1 0xC87C
#define R_AX_RX_INFO_CSI_1_C1 0xE87C
#define B_AX_CSI_PKTID_3_VALID BIT(31)
#define B_AX_CSI_PKTID_3_SH 16
#define B_AX_CSI_PKTID_3_MSK 0xfff
#define B_AX_CSI_PKTID_2_VALID BIT(15)
#define B_AX_CSI_PKTID_2_SH 0
#define B_AX_CSI_PKTID_2_MSK 0xfff

#define R_AX_MISC_CTRL_2 0xC880
#define R_AX_MISC_CTRL_2_C1 0xE880
#define B_AX_RXSTS_ENQUE_THRESHOLD_SH 16
#define B_AX_RXSTS_ENQUE_THRESHOLD_MSK 0xffff
#define B_AX_CSI_AUTO_UNLOCK BIT(1)
#define B_AX_SRAM_IO_PROT BIT(0)

//
// TMAC
//
#define B_AX_TCR_EOF_BIT_CHK_ACK_POLICY BIT(12)
#define B_AX_HW_SIGB_GEN_ERR_RST_EN BIT(11)
#define B_AX_TXDFIFO_ACCESS_RST_OPT BIT(10)
#define B_AX_TCR_AMPDU_FINAL_PAD_CTRL BIT(31)
#define B_AX_TCR_EN_BB_PADD_LEN_ERR_FLAG BIT(30)
#define B_AX_TCR_PSDU_PADD_LEN_UNIT BIT(29)
#define B_AX_TCR_BB_PADD_LIMIT_SH 8
#define B_AX_TCR_BB_PADD_LIMIT_MSK 0xf
#define B_AX_CAS_PSRT_PPDU_CTRL BIT(5)
#define B_AX_HW_SIGB_GEN_ERR BIT(14)
#define B_AX_DBG_USER_SEL_SH 10
#define B_AX_DBG_USER_SEL_MSK 0xf
#define B_AX_TXBF_EN_ERROR_FLAG_CLR_V1 BIT(9)
#define B_AX_TXCNT_CLEAR_PER_TXPPDU BIT(8)
#define B_AX_ZLD_FLAG_CLEAR_PER_TXPPDU BIT(7)
#define B_AX_DBGSEL_MACTX_V1_SH 0
#define B_AX_DBGSEL_MACTX_V1_MSK 0x7f

#define R_AX_MACTX_ZLD_CNT 0xCA24
#define R_AX_MACTX_ZLD_CNT_C1 0xEA24
#define B_AX_MACTX_ZLD_CNT_SH 0
#define B_AX_MACTX_ZLD_CNT_MSK 0x3ff

#define R_AX_DEBUG_USER_ERR_FLAG 0xCA28
#define R_AX_DEBUG_USER_ERR_FLAG_C1 0xEA28
#define B_AX_TXDMA_LENGTH_STUCK_ERR_FLAG_SH 24
#define B_AX_TXDMA_LENGTH_STUCK_ERR_FLAG_MSK 0xff
#define B_AX_TXBF_NSTS_ERR_FLAG_SH 16
#define B_AX_TXBF_NSTS_ERR_FLAG_MSK 0xff
#define B_AX_ZLD_FLAG_SH 8
#define B_AX_ZLD_FLAG_MSK 0xff
#define B_AX_LENGTH_ERR_FLAG_SH 0
#define B_AX_LENGTH_ERR_FLAG_MSK 0xff
#define B_AX_CSI_SEQ_SEL_SH 0
#define B_AX_CSI_SEQ_SEL_MSK 0x3
#define B_AX_PRI20_BITMAP_SH 24
#define B_AX_PRI20_BITMAP_MSK 0xff
#define B_AX_BQR_BMP_BIT_SHIFT_SH 5
#define B_AX_BQR_BMP_BIT_SHIFT_MSK 0x7

#define R_AX_WMAC_TX_INFO_DEBUG_SEL 0xCAE4
#define R_AX_WMAC_TX_INFO_DEBUG_SEL_C1 0xEAE4
#define B_AX_TX_TIME_EFF_FLAG_RST BIT(7)
#define B_AX_TX_PSDU_LEN_ERR_FLAG BIT(5)
#define B_AX_TX_NSYM_ERR_FLAG BIT(4)
#define B_AX_TX_INFO_DEBUG_SEL_SH 0
#define B_AX_TX_INFO_DEBUG_SEL_MSK 0xf
#define B_AX_TX_INFO_L4B_SH 0
#define B_AX_TX_INFO_L4B_MSK 0xffffffffL
#define B_AX_TX_INFO_H4B_SH 0
#define B_AX_TX_INFO_H4B_MSK 0xffffffffL

#define R_AX_WMAC_TX_PHY_UID_DEBUG 0xCAF0
#define R_AX_WMAC_TX_PHY_UID_DEBUG_C1 0xEAF0
#define B_AX_ERROR_DET_UID_SH 4
#define B_AX_ERROR_DET_UID_MSK 0xff
#define B_AX_ERROR_DET_STATE_SH 0
#define B_AX_ERROR_DET_STATE_MSK 0xf

//
// TRXPTCL
//
#define B_AX_RESP_TX_ABORT_TEST_EN BIT(24)
#define B_AX_RESP_TSSI_FAST_MODE_EN BIT(23)
#define B_AX_RESP_CHK_TB_EDCCA_PER20_BMP BIT(22)
#define B_AX_WMAC_MBA_DUR_FORCE BIT(16)
#define B_AX_WMAC_RESP_SR_MODE_EN BIT(31)
#define B_AX_TB_EDCCA_BMP_ABORT_RESP_TX_CNT_SH 24
#define B_AX_TB_EDCCA_BMP_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_DBG_FORCE_ABORT_RESP_TX_CNT_SH 24
#define B_AX_DBG_FORCE_ABORT_RESP_TX_CNT_MSK 0xff
#define B_AX_CLR_ABORT_RESP_TX_CNT_V1 BIT(0)
#define B_AX_WMAC_DIS_ALL_RESP BIT(23)
#define B_AX_WMAC_TRIGDAT_RESP_NRLACK BIT(17)

#define R_AX_WMAC_RX_WMMPS_UAPSD 0xCC70
#define R_AX_WMAC_RX_WMMPS_UAPSD_C1 0xEC70

#define R_AX_WMAC_NAV_OPTION 0xCC88
#define R_AX_WMAC_NAV_OPTION_C1 0xEC88
#define B_AX_WMAC_VIR_TUAL_CCA BIT(0)
#define B_AX_SR_PD_WMAC_C_SH 25
#define B_AX_SR_PD_WMAC_C_MSK 0x3f
#define B_AX_SRPERIOD_WMAC_C_SH 16
#define B_AX_SRPERIOD_WMAC_C_MSK 0x1ff
#define B_AX_SR_PD_PTCL_C_SH 10
#define B_AX_SR_PD_PTCL_C_MSK 0x3f
#define B_AX_SR_PERIOD_PTCL_C_SH 0
#define B_AX_SR_PERIOD_PTCL_C_MSK 0x3ff

#define R_AX_TRXPTCL_ERROR_INDICA_MASK 0xCCBC
#define R_AX_TRXPTCL_ERROR_INDICA_MASK_C1 0xECBC
#define B_AX_WMAC_MODE BIT(22)
#define B_AX_WMAC_TIMETOUT_THR_SH 16
#define B_AX_WMAC_TIMETOUT_THR_MSK 0x3f
#define B_AX_RMAC_FTM BIT(8)
#define B_AX_RMAC_CSI BIT(7)
#define B_AX_TMAC_MIMO_CTRL BIT(6)
#define B_AX_TMAC_RXTB BIT(5)
#define B_AX_TMAC_HWSIGB_GEN BIT(4)
#define B_AX_TMAC_TXPLCP BIT(3)
#define B_AX_TMAC_RESP BIT(2)
#define B_AX_TMAC_TXCTL BIT(1)
#define B_AX_TMAC_MACTX BIT(0)

#define R_AX_TRXPTCL_ERROR_INDICA 0xCCC0
#define R_AX_TRXPTCL_ERROR_INDICA_C1 0xECC0
#define B_AX_FTM_ERROR_FLAG_CLR BIT(8)
#define B_AX_CSI_ERROR_FLAG_CLR BIT(7)
#define B_AX_MIMOCTRL_ERROR_FLAG_CLR BIT(6)
#define B_AX_RXTB_ERROR_FLAG_CLR BIT(5)
#define B_AX_HWSIGB_GEN_ERROR_FLAG_CLR BIT(4)
#define B_AX_TXPLCP_ERROR_FLAG_CLR BIT(3)
#define B_AX_RESP_ERROR_FLAG_CLR BIT(2)
#define B_AX_TXCTL_ERROR_FLAG_CLR BIT(1)
#define B_AX_MACTX_ERROR_FLAG_CLR BIT(0)

#define R_AX_RX_TB_CTRL_INFO_CFG 0xCCD0
#define R_AX_RX_TB_CTRL_INFO_CFG_C1 0xECD0
#define B_AX_WMAC_RX_TB_CTRL_DBG_SEL_SH 0
#define B_AX_WMAC_RX_TB_CTRL_DBG_SEL_MSK 0xf

#define R_AX_RX_TB_CTRL_INFO_0 0xCCD4
#define R_AX_RX_TB_CTRL_INFO_0_C1 0xECD4
#define B_AX_RX_TB_CTRL_L4B_SH 0
#define B_AX_RX_TB_CTRL_L4B_MSK 0xffffffffL

#define R_AX_RX_TB_CTRL_INFO_1 0xCCD8
#define R_AX_RX_TB_CTRL_INFO_1_C1 0xECD8
#define B_AX_RX_TB_CTRL_H4B_SH 0
#define B_AX_RX_TB_CTRL_H4B_MSK 0xffffffffL

#define R_AX_WMAC_RX_STATUS_MONITOR 0xCCEC
#define R_AX_WMAC_RX_STATUS_MONITOR_C1 0xECEC
#define B_AX_RX_IDLE_TIMEOUT_CLR BIT(24)
#define B_AX_RX_IDLE_TIMEOUT_MASK BIT(16)
#define B_AX_RXSTS_FCS_TO_DIS BIT(11)
#define B_AX_RXSTS_PLCP_TO_DIS BIT(10)
#define B_AX_RXSTS_DATA_ON_TO_DIS BIT(9)
#define B_AX_RXSTS_CCA_TO_DIS BIT(8)
#define B_AX_RXSTS_TIMEOUT_THB_AX_UNIT_SH 6
#define B_AX_RXSTS_TIMEOUT_THB_AX_UNIT_MSK 0x3
#define B_AX_RXSTS_TIMEOUT_THR_SH 0
#define B_AX_RXSTS_TIMEOUT_THR_MSK 0x3f
#define B_AX_WMAC_CHNSTS_STATE_SH 16
#define B_AX_WMAC_CHNSTS_STATE_MSK 0xf

#define R_AX_PHYINFO_ERR_IMR_V1 0xCCF8
#define R_AX_PHYINFO_ERR_IMR_V1_C1 0xECF8
#define B_AX_PHYINTF_TIMEOUT_THR_V1_SH 16
#define B_AX_PHYINTF_TIMEOUT_THR_V1_MSK 0x3f
#define B_AX_CSI_ON_TIMEOUT_EN BIT(5)
#define B_AX_STS_ON_TIMEOUT_EN BIT(4)
#define B_AX_DATA_ON_TIMEOUT_EN BIT(3)
#define B_AX_OFDM_CCA_TIMEOUT_EN BIT(2)
#define B_AX_CCK_CCA_TIMEOUT_EN BIT(1)
#define B_AX_PHY_TXON_TIMEOUT_EN BIT(0)

#define R_AX_PHYINFO_ERR_ISR 0xCCFC
#define R_AX_PHYINFO_ERR_ISR_C1 0xECFC
#define B_AX_CSI_ON_TIMEOUT_ERR BIT(5)
#define B_AX_STS_ON_TIMEOUT_ERR BIT(4)
#define B_AX_DATA_ON_TIMEOUT_ERR BIT(3)
#define B_AX_OFDM_CCA_TIMEOUT_ERR BIT(2)
#define B_AX_CCK_CCA_TIMEOUT_ERR BIT(1)
#define B_AX_PHY_TXON_TIMEOUT_ERR BIT(0)
#define B_AX_MER_UPDMEE_USERID_C_SH 16
#define B_AX_MER_UPDMEE_USERID_C_MSK 0x1f
#define B_AX_MER_UPDMEE_CSI BIT(15)
#define B_AX_BFMEE_NDP_RX_TIMEOUT_SH 24
#define B_AX_BFMEE_NDP_RX_TIMEOUT_MSK 0xff
#define B_AX_BFMEE_CSI_RELEASE_TIMER_SH 20
#define B_AX_BFMEE_CSI_RELEASE_TIMER_MSK 0xf
#define B_AX_CSI_RPT_CNT_V1_SH 0
#define B_AX_CSI_RPT_CNT_V1_MSK 0x1fff
#define B_AX_BFMEE_CSI_TXTIME_LEN_LIMIT_SH 16
#define B_AX_BFMEE_CSI_TXTIME_LEN_LIMIT_MSK 0xff

//
// RMAC
//
#define B_AX_BUSY_CHKSN BIT(15)
#define B_AX_DYN_CHEN BIT(14)
#define B_AX_AUTO_RST BIT(13)
#define B_AX_TIMER_SEL BIT(12)
#define B_AX_CH_EN_V1_SH 0
#define B_AX_CH_EN_V1_MSK 0xff
#define B_AX_RX_DLK_RST_FSM BIT(3)
#define B_AX_RX_DLK_RST_SKIPDMA BIT(2)
#define B_AX_PLCP_RXFA_RESET_TYPE_SH 12
#define B_AX_PLCP_RXFA_RESET_TYPE_MSK 0xf
#define B_AX_PLCP_RXFA_RESET_EN BIT(11)
#define B_AX_RXAI_RECCA_DIS BIT(2)

#define R_AX_RX_FIFO_STATUS 0xCE18
#define R_AX_RX_FIFO_STATUS_C1 0xEE18
#define B_AX_RXS_FIFO_IORST BIT(24)
#define B_AX_ADDR_CAM_IORST BIT(10)
#define B_AX_DIS_ADDR_CLK_GATED BIT(9)
#define B_AX_BACAM_SKIP_ALL_QOSNULL BIT(24)
#define B_AX_BACAM_IORST BIT(6)
#define B_AX_BACAM_GCK_DIS BIT(5)
#define B_AX_PPDU_STAT_WR_BW_SH 10
#define B_AX_PPDU_STAT_WR_BW_MSK 0x3
#define B_AX_PPDU_STAT_DMA_MODE BIT(9)
#define B_AX_PPDU_STAT_ERR_FLAG_SH 0
#define B_AX_PPDU_STAT_ERR_FLAG_MSK 0xff

#define R_AX_SCOPE_CTRL 0xCE60
#define R_AX_SCOPE_CTRL_C1 0xEE60
#define B_AX_SCOPE_LEN_SH 8
#define B_AX_SCOPE_LEN_MSK 0xf
#define B_AX_SCOPE_FILTER_SH 4
#define B_AX_SCOPE_FILTER_MSK 0x3
#define B_AX_SCOPE_APPZERO BIT(3)
#define B_AX_SCOPE_MODE_SH 0
#define B_AX_SCOPE_MODE_MSK 0x7

#define R_AX_DRV_INFO_OPTION 0xCE70
#define R_AX_DRV_INFO_OPTION_C1 0xEE70
#define B_AX_DRV_INFO_PHYRPT_EN BIT(0)
#define B_AX_BCN_IECAM_IORST BIT(14)

#define R_AX_SNIFFER_MODE_CFG0 0xCEC4
#define R_AX_SNIFFER_MODE_CFG0_C1 0xEEC4

#define R_AX_SNIFFER_MODE_CFG1 0xCEC8
#define R_AX_SNIFFER_MODE_CFG1_C1 0xEEC8

#define R_AX_RPL_CFG 0xCECC
#define R_AX_RPL_CFG_C1 0xEECC
#define B_AX_RPLCFG_UPPEB_AX_EN BIT(31)
#define B_AX_RPLCFG_UPPEB_AX_DBM_SH 16
#define B_AX_RPLCFG_UPPEB_AX_DBM_MSK 0x1ff
#define B_AX_RPLCFG_EN BIT(15)
#define B_AX_RPLCFG_DBM_SH 0
#define B_AX_RPLCFG_DBM_MSK 0x1ff

#define R_AX_RX_TO_BRK_OPT 0xCED0
#define R_AX_RX_TO_BRK_OPT_C1 0xEED0
#define B_AX_RXPSR_PAUSE_FRMTYPE_SH 24
#define B_AX_RXPSR_PAUSE_FRMTYPE_MSK 0x3f
#define B_AX_RXPSR_PAUSE_BEACON BIT(21)
#define B_AX_RXPSR_PAUSE_TRIGGER BIT(20)
#define B_AX_RXPSR_PAUSE_BAR BIT(19)
#define B_AX_RXPSR_PAUSE_BA BIT(18)
#define B_AX_RXPSR_PAUSE_MODE_SH 16
#define B_AX_RXPSR_PAUSE_MODE_MSK 0x3
#define B_AX_RXBRK_TB_TIME_SH 8
#define B_AX_RXBRK_TB_TIME_MSK 0x1f
#define B_AX_RXBRK_TIME_SH 0
#define B_AX_RXBRK_TIME_MSK 0xf

#define R_AX_RX_CNT_RPT_CFG 0xCEE4
#define R_AX_RX_CNT_RPT_CFG_C1 0xEEE4
#define B_AX_PKTCNT_SET BIT(31)
#define B_AX_UPD_PKTCNT_CFG_SH 0
#define B_AX_UPD_PKTCNT_CFG_MSK 0x7fffffffL

#define R_AX_RX_PLCP_MON 0xCEE8
#define R_AX_RX_PLCP_MON_C1 0xEEE8
#define B_AX_RX_PLCP_MON_SEL_SH 28
#define B_AX_RX_PLCP_MON_SEL_MSK 0xf
#define B_AX_RX_PLCP_CONT_SH 0
#define B_AX_RX_PLCP_CONT_MSK 0xfffffff
#define B_AX_STATE_EXSEL_SH 14
#define B_AX_STATE_EXSEL_MSK 0x3
#define B_AX_STATE_MODE_SH 5
#define B_AX_STATE_MODE_MSK 0x3

#define R_AX_RX_ERR_ISR 0xCEF4
#define R_AX_RX_ERR_ISR_C1 0xEEF4
#define B_AX_RX_ERR_TRIG_ACT_TO BIT(9)
#define B_AX_RX_ERR_STS_ACT_TO BIT(8)
#define B_AX_RX_ERR_CSI_ACT_TO BIT(7)
#define B_AX_RX_ERR_ACT_TO BIT(6)
#define B_AX_CSI_DATAON_ASSERT_TO BIT(5)
#define B_AX_DATAON_ASSERT_TO BIT(4)
#define B_AX_CCA_ASSERT_TO BIT(3)
#define B_AX_RX_ERR_DMA_TO BIT(2)
#define B_AX_RX_ERR_DATA_TO BIT(1)
#define B_AX_RX_ERR_CCA_TO BIT(0)

#define R_AX_RX_ERR_IMR 0xCEF8
#define R_AX_RX_ERR_IMR_C1 0xEEF8
#define B_AX_RX_ERR_TRIG_ACT_TO_MSK BIT(9)
#define B_AX_RX_ERR_STS_ACT_TO_MSK BIT(8)
#define B_AX_RX_ERR_CSI_ACT_TO_MSK BIT(7)
#define B_AX_RX_ERR_ACT_TO_MSK BIT(6)
#define B_AX_CSI_DATAON_ASSERT_TO_MSK BIT(5)
#define B_AX_DATAON_ASSERT_TO_MSK BIT(4)
#define B_AX_CCA_ASSERT_TO_MSK BIT(3)
#define B_AX_RX_ERR_DMA_TO_MSK BIT(2)
#define B_AX_RX_ERR_DATA_TO_MSK BIT(1)
#define B_AX_RX_ERR_CCA_TO_MSK BIT(0)

//
// PWR
//

//
// BTCOEX
//
#define B_AX_BTC_EN BIT(31)
#define B_AX_EN_EXT_BT_PINMUX BIT(29)
#define B_AX_BTC_RST BIT(28)
#define B_AX_BTC_DBG_SRC_SEL BIT(27)
#define B_AX_BTC_MODE_SH 24
#define B_AX_BTC_MODE_MSK 0x3
#define B_AX_INV_WL_ACT2 BIT(17)
#define B_AX_BTG_LNA1_GAIN_SEL BIT(16)
#define B_AX_IGN_GNT_BT2_RX BIT(7)
#define B_AX_IGN_GNT_BT2_TX BIT(6)
#define B_AX_IGN_GNT_BT2 BIT(5)

#define R_AX_RTK_MODE_CFG_V1 0xDA04
#define R_AX_RTK_MODE_CFG_V1_C1 0xFA04
#define B_AX_BT_BLE_EN_V1 BIT(24)
#define B_AX_BT_ULTRA_EN BIT(16)
#define B_AX_BT_L_RX_ULTRA_SH 14
#define B_AX_BT_L_RX_ULTRA_MSK 0x3
#define B_AX_BT_L_TX_ULTRA_SH 12
#define B_AX_BT_L_TX_ULTRA_MSK 0x3
#define B_AX_BT_H_RX_ULTRA_SH 10
#define B_AX_BT_H_RX_ULTRA_MSK 0x3
#define B_AX_BT_H_TX_ULTRA_SH 8
#define B_AX_BT_H_TX_ULTRA_MSK 0x3
#define B_AX_SAMPLE_CLK_SH 0
#define B_AX_SAMPLE_CLK_MSK 0xff

#define R_AX_CSR_MODE_CFG 0xDA08
#define R_AX_CSR_MODE_CFG_C1 0xFA08
#define B_AX_BT_TIME_CNT_V1_SH 16
#define B_AX_BT_TIME_CNT_V1_MSK 0xff
#define B_AX_CSR_DELAY_SH 8
#define B_AX_CSR_DELAY_MSK 0xf
#define B_AX_CSR_TRX_SH 4
#define B_AX_CSR_TRX_MSK 0xf
#define B_AX_CSR_PRI_SH 0
#define B_AX_CSR_PRI_MSK 0xf

#define R_AX_BT_CNT_CFG 0xDA10
#define R_AX_BT_CNT_CFG_C1 0xFA10
#define B_AX_BT_CNT_RST_V1 BIT(1)
#define B_AX_BT_CNT_EN BIT(0)

#define R_AX_BT_CNT_HI 0xDA14
#define R_AX_BT_CNT_HI_C1 0xFA14
#define B_AX_BT_HI_RX_SH 16
#define B_AX_BT_HI_RX_MSK 0xffff
#define B_AX_BT_HI_TX_SH 0
#define B_AX_BT_HI_TX_MSK 0xffff

#define R_AX_BT_CNT_LOW 0xDA18
#define R_AX_BT_CNT_LOW_C1 0xFA18
#define B_AX_BT_LOW_RX_SH 16
#define B_AX_BT_LOW_RX_MSK 0xffff
#define B_AX_BT_LOW_TX_SH 0
#define B_AX_BT_LOW_TX_MSK 0xffff

#define R_AX_RTK_CMD_ERR_RPT 0xDA20
#define R_AX_RTK_CMD_ERR_RPT_C1 0xFA20
#define B_AX_RTK_CMD_CRC BIT(1)
#define B_AX_RTK_CMD_INC BIT(0)

#define R_AX_COEX_WL_REQ 0xDA24
#define R_AX_COEX_WL_REQ_C1 0xFA24
#define B_AX_TX_BCN_HI BIT(22)
#define B_AX_TX_NDP_HI BIT(21)
#define B_AX_TX_PROT_HI BIT(20)
#define B_AX_TX_CF_END_HI BIT(19)
#define B_AX_TX_BAR_HI BIT(18)
#define B_AX_TX_TRI_HI BIT(17)
#define B_AX_TX_VOQ_HI BIT(16)
#define B_AX_TX_VIQ_HI BIT(15)
#define B_AX_TX_BEQ_HI BIT(14)
#define B_AX_TX_BKQ_HI BIT(13)
#define B_AX_TX_MGQ_HI BIT(12)
#define B_AX_TX_HIQ_HI BIT(11)
#define B_AX_RSP_ACK_HI BIT(10)
#define B_AX_RSP_CSI_HI BIT(9)
#define B_AX_RSP_BSR_BQR_HI BIT(8)
#define B_AX_PRI_MASK_TX_TIME_SH 3
#define B_AX_PRI_MASK_TX_TIME_MSK 0x3
#define B_AX_PRI_MASK_RX_TIME_V1_SH 1
#define B_AX_PRI_MASK_RX_TIME_V1_MSK 0x3
#define B_AX_WL_RX BIT(0)

#define R_AX_BTC_COEX_SEL 0xDA30
#define R_AX_BTC_COEX_SEL_C1 0xFA30
#define B_AX_COEX_TBL_SEL_SH 0
#define B_AX_COEX_TBL_SEL_MSK 0x3

#define R_AX_BT_COEX_TABLE_0 0xDA34
#define R_AX_BT_COEX_TABLE_0_C1 0xFA34
#define B_AX_BT_COEX_TBL_0_SH 0
#define B_AX_BT_COEX_TBL_0_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_1 0xDA38
#define R_AX_BT_COEX_TABLE_1_C1 0xFA38
#define B_AX_BT_COEX_TBL_1_SH 0
#define B_AX_BT_COEX_TBL_1_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_2 0xDA3C
#define R_AX_BT_COEX_TABLE_2_C1 0xFA3C
#define B_AX_BT_COEX_TBL_2_SH 0
#define B_AX_BT_COEX_TBL_2_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_3 0xDA40
#define R_AX_BT_COEX_TABLE_3_C1 0xFA40
#define B_AX_BT_COEX_TBL_3_SH 0
#define B_AX_BT_COEX_TBL_3_MSK 0xffffffffL

#define R_AX_BT_BREAK_TABLE 0xDA44
#define R_AX_BT_BREAK_TABLE_C1 0xFA44
#define B_AX_BREAK_WL_SH 16
#define B_AX_BREAK_WL_MSK 0xffff
#define B_AX_BREAK_BT_SH 0
#define B_AX_BREAK_BT_MSK 0xffff

#define R_AX_GNT_SW_CTRL 0xDA48
#define R_AX_GNT_SW_CTRL_C1 0xFA48
#define B_AX_WL_ACT2_VAL BIT(21)
#define B_AX_WL_ACT2_SWCTRL BIT(20)
#define B_AX_WL_ACT_VAL BIT(19)
#define B_AX_WL_ACT_SWCTRL BIT(18)
#define B_AX_GNT_BT_RX_VAL BIT(17)
#define B_AX_GNT_BT_RX_SWCTRL BIT(16)
#define B_AX_GNT_BT_TX_VAL BIT(15)
#define B_AX_GNT_BT_TX_SWCTRL BIT(14)
#define B_AX_GNT_WL_RX_VAL BIT(13)
#define B_AX_GNT_WL_RX_SWCTRL BIT(12)
#define B_AX_GNT_WL_TX_VAL BIT(11)
#define B_AX_GNT_WL_TX_SWCTRL BIT(10)
#define B_AX_GNT_BT_RFC_S1_VAL BIT(9)
#define B_AX_GNT_BT_RFC_S1_SWCTRL BIT(8)
#define B_AX_GNT_WL_RFC_S1_VAL BIT(7)
#define B_AX_GNT_WL_RFC_S1_SWCTRL BIT(6)
#define B_AX_GNT_BT_RFC_S0_VAL BIT(5)
#define B_AX_GNT_BT_RFC_S0_SWCTRL BIT(4)
#define B_AX_GNT_WL_RFC_S0_VAL BIT(3)
#define B_AX_GNT_WL_RFC_S0_SWCTRL BIT(2)
#define B_AX_GNT_WL_BB_VAL BIT(1)
#define B_AX_GNT_WL_BB_SWCTRL BIT(0)

#define R_AX_GNT_VAL 0xDA4C
#define R_AX_GNT_VAL_C1 0xFA4C
#define B_AX_WL_ACT2 BIT(10)
#define B_AX_WL_ACT BIT(9)
#define B_AX_GNT_BT_RX BIT(8)
#define B_AX_GNT_BT_TX BIT(7)
#define B_AX_GNT_WL_RX BIT(6)
#define B_AX_GNT_WL_TX BIT(5)
#define B_AX_GNT_BT_RFC_S1 BIT(4)
#define B_AX_GNT_BT_RFC_S0 BIT(3)
#define B_AX_GNT_WL_RFC_S1 BIT(2)
#define B_AX_GNT_WL_RFC_S0 BIT(1)
#define B_AX_GNT_WL_BB BIT(0)

#define R_AX_BTC_CFG_V2 0xDB00
#define R_AX_BTC_CFG_V2_C1 0xFB00

#define R_AX_RTK_MODE_CFG2 0xDB04
#define R_AX_RTK_MODE_CFG2_C1 0xFB04
#define B_AX_BT2_BLE_EN_V1 BIT(24)
#define B_AX_BT2_ULTRA_EN BIT(16)
#define B_AX_BT2_L_RX_ULTRA_SH 14
#define B_AX_BT2_L_RX_ULTRA_MSK 0x3
#define B_AX_BT2_L_TX_ULTRA_SH 12
#define B_AX_BT2_L_TX_ULTRA_MSK 0x3
#define B_AX_BT2_H_RX_ULTRA_SH 10
#define B_AX_BT2_H_RX_ULTRA_MSK 0x3
#define B_AX_BT2_H_TX_ULTRA_SH 8
#define B_AX_BT2_H_TX_ULTRA_MSK 0x3
#define B_AX_SAMPLE_CLK_2_SH 0
#define B_AX_SAMPLE_CLK_2_MSK 0xff

#define R_AX_CSR_MODE_CFG2 0xDB08
#define R_AX_CSR_MODE_CFG2_C1 0xFB08
#define B_AX_BT2_TIME_CNT_SH 16
#define B_AX_BT2_TIME_CNT_MSK 0xff
#define B_AX_CSR_DELAY_2_SH 8
#define B_AX_CSR_DELAY_2_MSK 0xf
#define B_AX_CSR_TRX_2_SH 4
#define B_AX_CSR_TRX_2_MSK 0xf
#define B_AX_CSR_PRI_2_SH 0
#define B_AX_CSR_PRI_2_MSK 0xf

#define R_AX_BT_CNT_CFG2 0xDB10
#define R_AX_BT_CNT_CFG2_C1 0xFB10
#define B_AX_BT2_CNT_RST_V1 BIT(1)
#define B_AX_BT2_CNT_EN BIT(0)

#define R_AX_BT_CNT_HI2 0xDB14
#define R_AX_BT_CNT_HI2_C1 0xFB14
#define B_AX_BT2_HI_RX_SH 16
#define B_AX_BT2_HI_RX_MSK 0xffff
#define B_AX_BT2_HI_TX_SH 0
#define B_AX_BT2_HI_TX_MSK 0xffff

#define R_AX_BT_CNT_LOW2 0xDB18
#define R_AX_BT_CNT_LOW2_C1 0xFB18
#define B_AX_BT2_LOW_RX_SH 16
#define B_AX_BT2_LOW_RX_MSK 0xffff
#define B_AX_BT2_LOW_TX_SH 0
#define B_AX_BT2_LOW_TX_MSK 0xffff

#define R_AX_RTK_CMD_ERR_RPT2 0xDB20
#define R_AX_RTK_CMD_ERR_RPT2_C1 0xFB20
#define B_AX_RTK_CMD_CRC_2 BIT(1)
#define B_AX_RTK_CMD_INC_2 BIT(0)

#define R_AX_BTC_COEX_SEL2 0xDB30
#define R_AX_BTC_COEX_SEL2_C1 0xFB30
#define B_AX_COEX_TBL_SEL_2_SH 0
#define B_AX_COEX_TBL_SEL_2_MSK 0x3

#define R_AX_BT_COEX_TABLE_0_2 0xDB34
#define R_AX_BT_COEX_TABLE_0_2_C1 0xFB34
#define B_AX_BT_COEX_TBL_0_2_SH 0
#define B_AX_BT_COEX_TBL_0_2_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_1_2 0xDB38
#define R_AX_BT_COEX_TABLE_1_2_C1 0xFB38
#define B_AX_BT_COEX_TBL_1_2_SH 0
#define B_AX_BT_COEX_TBL_1_2_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_2_2 0xDB3C
#define R_AX_BT_COEX_TABLE_2_2_C1 0xFB3C
#define B_AX_BT_COEX_TBL_2_2_SH 0
#define B_AX_BT_COEX_TBL_2_2_MSK 0xffffffffL

#define R_AX_BT_COEX_TABLE_3_2 0xDB40
#define R_AX_BT_COEX_TABLE_3_2_C1 0xFB40
#define B_AX_BT_COEX_TBL_3_2_SH 0
#define B_AX_BT_COEX_TBL_3_2_MSK 0xffffffffL

#define R_AX_BT_BREAK_TABLE_2 0xDB44
#define R_AX_BT_BREAK_TABLE_2_C1 0xFB44
#define B_AX_BREAK_WL_2_SH 16
#define B_AX_BREAK_WL_2_MSK 0xffff
#define B_AX_BREAK_BT_2_SH 0
#define B_AX_BREAK_BT_2_MSK 0xffff

//
// WL_AX_Reg_CMAC_0.xls
//

//
// COMMON
//

//
// SCH
//

//
// PTCL
//

//
// CMAC_DMA
//

//
// TMAC
//

//
// TRXPTCL
//

//
// RMAC
//

//
// PWR
//

//
// BTCOEX
//

//
// WL_AX_Reg_HAXIDMA.xls
//

//
// PCIE
//

#define R_AX_HAXI_INIT_CFG1 0x1000
#define B_AX_WD_ITVL_IDLE_V1_SH 28
#define B_AX_WD_ITVL_IDLE_V1_MSK 0xf
#define B_AX_WD_ITVL_ACT_V1_SH 24
#define B_AX_WD_ITVL_ACT_V1_MSK 0xf
#define B_AX_DMA_MODE_SH 18
#define B_AX_DMA_MODE_MSK 0x3
#define B_AX_STOP_AXI_MST BIT(17)
#define B_AX_HAXI_RST_KEEP_REG BIT(16)
#define B_AX_RXHCI_EN_V1 BIT(15)
#define B_AX_RXBD_MODE_V1 BIT(14)
#define B_AX_HAXI_MAX_RXDMA_SH 8
#define B_AX_HAXI_MAX_RXDMA_MSK 0x3
#define B_AX_TXHCI_EN_V1 BIT(7)
#define B_AX_FLUSH_AXI_MST BIT(4)
#define B_AX_RST_BDRAM BIT(3)
#define B_AX_HAXI_MAX_TXDMA_SH 0
#define B_AX_HAXI_MAX_TXDMA_MSK 0x3

#define R_AX_HAXI_DMA_RXQ_APPLEN 0x1004
#define B_AX_PCIE_RX_APPLEN_SH 0
#define B_AX_PCIE_RX_APPLEN_MSK 0x3fff

#define R_AX_HAXI_DMA_STOP1 0x1010
#define B_AX_STOP_WPDMA BIT(19)
#define B_AX_STOP_CH12 BIT(18)
#define B_AX_STOP_CH9 BIT(17)
#define B_AX_STOP_CH8 BIT(16)
#define B_AX_STOP_ACH7 BIT(15)
#define B_AX_STOP_ACH6 BIT(14)
#define B_AX_STOP_ACH5 BIT(13)
#define B_AX_STOP_ACH4 BIT(12)
#define B_AX_STOP_ACH3 BIT(11)
#define B_AX_STOP_ACH2 BIT(10)
#define B_AX_STOP_ACH1 BIT(9)
#define B_AX_STOP_ACH0 BIT(8)

#define R_AX_TXBD_RWPTR_CLR1 0x1014
#define B_AX_CLR_CH12_IDX BIT(10)
#define B_AX_CLR_CH9_IDX BIT(9)
#define B_AX_CLR_CH8_IDX BIT(8)
#define B_AX_CLR_ACH7_IDX BIT(7)
#define B_AX_CLR_ACH6_IDX BIT(6)
#define B_AX_CLR_ACH5_IDX BIT(5)
#define B_AX_CLR_ACH4_IDX BIT(4)
#define B_AX_CLR_ACH3_IDX BIT(3)
#define B_AX_CLR_ACH2_IDX BIT(2)
#define B_AX_CLR_ACH1_IDX BIT(1)
#define B_AX_CLR_ACH0_IDX BIT(0)

#define R_AX_HAXI_DMA_BUSY1 0x101C
#define B_AX_HAXIIO_BUSY BIT(20)
#define B_AX_WPDMA_BUSY BIT(19)
#define B_AX_CH12_BUSY BIT(18)
#define B_AX_CH9_BUSY BIT(17)
#define B_AX_CH8_BUSY BIT(16)
#define B_AX_ACH7_BUSY BIT(15)
#define B_AX_ACH6_BUSY BIT(14)
#define B_AX_ACH5_BUSY BIT(13)
#define B_AX_ACH4_BUSY BIT(12)
#define B_AX_ACH3_BUSY BIT(11)
#define B_AX_ACH2_BUSY BIT(10)
#define B_AX_ACH1_BUSY BIT(9)
#define B_AX_ACH0_BUSY BIT(8)

#define R_AX_ACH0_TXBD_NUM 0x1024
#define B_AX_HAXI_ACH0_FLAG BIT(14)
#define B_AX_ACH0_DESC_NUM_SH 0
#define B_AX_ACH0_DESC_NUM_MSK 0x3ff

#define R_AX_ACH1_TXBD_NUM 0x1026
#define B_AX_HAXI_ACH1_FLAG BIT(14)
#define B_AX_ACH1_DESC_NUM_SH 0
#define B_AX_ACH1_DESC_NUM_MSK 0x3ff

#define R_AX_ACH2_TXBD_NUM 0x1028
#define B_AX_HAXI_ACH2_FLAG BIT(14)
#define B_AX_ACH2_DESC_NUM_SH 0
#define B_AX_ACH2_DESC_NUM_MSK 0x3ff

#define R_AX_ACH3_TXBD_NUM 0x102A
#define B_AX_HAXI_ACH3_FLAG BIT(14)
#define B_AX_ACH3_DESC_NUM_SH 0
#define B_AX_ACH3_DESC_NUM_MSK 0x3ff

#define R_AX_ACH4_TXBD_NUM 0x102C
#define B_AX_HAXI_ACH4_FLAG BIT(14)
#define B_AX_ACH4_DESC_NUM_SH 0
#define B_AX_ACH4_DESC_NUM_MSK 0x3ff

#define R_AX_ACH5_TXBD_NUM 0x102E
#define B_AX_HAXI_ACH5_FLAG BIT(14)
#define B_AX_ACH5_DESC_NUM_SH 0
#define B_AX_ACH5_DESC_NUM_MSK 0x3ff

#define R_AX_ACH6_TXBD_NUM 0x1030
#define B_AX_HAXI_ACH6_FLAG BIT(14)
#define B_AX_ACH6_DESC_NUM_SH 0
#define B_AX_ACH6_DESC_NUM_MSK 0x3ff

#define R_AX_ACH7_TXBD_NUM 0x1032
#define B_AX_HAXI_ACH7_FLAG BIT(14)
#define B_AX_ACH7_DESC_NUM_SH 0
#define B_AX_ACH7_DESC_NUM_MSK 0x3ff

#define R_AX_CH8_TXBD_NUM 0x1034
#define B_AX_HAXI_CH8_FLAG BIT(14)
#define B_AX_CH8_DESC_NUM_SH 0
#define B_AX_CH8_DESC_NUM_MSK 0x3ff

#define R_AX_CH9_TXBD_NUM 0x1036
#define B_AX_HAXI_CH9_FLAG BIT(14)
#define B_AX_CH9_DESC_NUM_SH 0
#define B_AX_CH9_DESC_NUM_MSK 0x3ff

#define R_AX_CH12_TXBD_NUM 0x1038
#define B_AX_HAXI_CH12_FLAG BIT(14)
#define B_AX_CH12_DESC_NUM_SH 0
#define B_AX_CH12_DESC_NUM_MSK 0x3ff

#define R_AX_ACH0_TXBD_IDX 0x1058
#define B_AX_ACH0_HW_IDX_SH 16
#define B_AX_ACH0_HW_IDX_MSK 0x3ff
#define B_AX_ACH0_HOST_IDX_SH 0
#define B_AX_ACH0_HOST_IDX_MSK 0x3ff

#define R_AX_ACH1_TXBD_IDX 0x105C
#define B_AX_ACH1_HW_IDX_SH 16
#define B_AX_ACH1_HW_IDX_MSK 0x3ff
#define B_AX_ACH1_HOST_IDX_SH 0
#define B_AX_ACH1_HOST_IDX_MSK 0x3ff

#define R_AX_ACH2_TXBD_IDX 0x1060
#define B_AX_ACH2_HW_IDX_SH 16
#define B_AX_ACH2_HW_IDX_MSK 0x3ff
#define B_AX_ACH2_HOST_IDX_SH 0
#define B_AX_ACH2_HOST_IDX_MSK 0x3ff

#define R_AX_ACH3_TXBD_IDX 0x1064
#define B_AX_ACH3_HW_IDX_SH 16
#define B_AX_ACH3_HW_IDX_MSK 0x3ff
#define B_AX_ACH3_HOST_IDX_SH 0
#define B_AX_ACH3_HOST_IDX_MSK 0x3ff

#define R_AX_ACH4_TXBD_IDX 0x1068
#define B_AX_ACH4_HW_IDX_SH 16
#define B_AX_ACH4_HW_IDX_MSK 0x3ff
#define B_AX_ACH4_HOST_IDX_SH 0
#define B_AX_ACH4_HOST_IDX_MSK 0x3ff

#define R_AX_ACH5_TXBD_IDX 0x106C
#define B_AX_ACH5_HW_IDX_SH 16
#define B_AX_ACH5_HW_IDX_MSK 0x3ff
#define B_AX_ACH5_HOST_IDX_SH 0
#define B_AX_ACH5_HOST_IDX_MSK 0x3ff

#define R_AX_ACH6_TXBD_IDX 0x1070
#define B_AX_ACH6_HW_IDX_SH 16
#define B_AX_ACH6_HW_IDX_MSK 0x3ff
#define B_AX_ACH6_HOST_IDX_SH 0
#define B_AX_ACH6_HOST_IDX_MSK 0x3ff

#define R_AX_ACH7_TXBD_IDX 0x1074
#define B_AX_ACH7_HW_IDX_SH 16
#define B_AX_ACH7_HW_IDX_MSK 0x3ff
#define B_AX_ACH7_HOST_IDX_SH 0
#define B_AX_ACH7_HOST_IDX_MSK 0x3ff

#define R_AX_CH8_TXBD_IDX 0x1078
#define B_AX_CH8_HW_IDX_SH 16
#define B_AX_CH8_HW_IDX_MSK 0x3ff
#define B_AX_CH8_HOST_IDX_SH 0
#define B_AX_CH8_HOST_IDX_MSK 0x3ff

#define R_AX_CH9_TXBD_IDX 0x107C
#define B_AX_CH9_HW_IDX_SH 16
#define B_AX_CH9_HW_IDX_MSK 0x3ff
#define B_AX_CH9_HOST_IDX_SH 0
#define B_AX_CH9_HOST_IDX_MSK 0x3ff

#define R_AX_CH12_TXBD_IDX 0x1080
#define B_AX_CH12_HW_IDX_SH 16
#define B_AX_CH12_HW_IDX_MSK 0x3ff
#define B_AX_CH12_HOST_IDX_SH 0
#define B_AX_CH12_HOST_IDX_MSK 0x3ff

#define R_AX_HAXI_HIMR00 0x10B0
#define B_AX_RPQBD_FULL_INT_EN BIT(20)
#define B_AX_RDU_INT_EN BIT(19)
#define B_AX_RXDMA_STUCK_INT_EN BIT(18)
#define B_AX_TXDMA_STUCK_INT_EN BIT(17)
#define B_AX_TXDMA_CH12_INT_EN BIT(13)
#define B_AX_TXDMA_CH9_INT_EN BIT(12)
#define B_AX_TXDMA_CH8_INT_EN BIT(11)
#define B_AX_TXDMA_ACH7_INT_EN BIT(10)
#define B_AX_TXDMA_ACH6_INT_EN BIT(9)
#define B_AX_TXDMA_ACH5_INT_EN BIT(8)
#define B_AX_TXDMA_ACH4_INT_EN BIT(7)
#define B_AX_TXDMA_ACH3_INT_EN BIT(6)
#define B_AX_TXDMA_ACH2_INT_EN BIT(5)
#define B_AX_TXDMA_ACH1_INT_EN BIT(4)
#define B_AX_TXDMA_ACH0_INT_EN BIT(3)
#define B_AX_RPQDMA_INT_EN BIT(2)
#define B_AX_RXP1DMA_INT_EN BIT(1)
#define B_AX_RXDMA_INT_EN BIT(0)

#define R_AX_HAXI_HISR00 0x10B4
#define B_AX_RPQBD_FULL_INT BIT(20)
#define B_AX_RDU_INT BIT(19)
#define B_AX_RXDMA_STUCK_INT BIT(18)
#define B_AX_TXDMA_STUCK_INT BIT(17)
#define B_AX_TXDMA_CH12_INT BIT(13)
#define B_AX_TXDMA_CH9_INT BIT(12)
#define B_AX_TXDMA_CH8_INT BIT(11)
#define B_AX_TXDMA_ACH7_INT BIT(10)
#define B_AX_TXDMA_ACH6_INT BIT(9)
#define B_AX_TXDMA_ACH5_INT BIT(8)
#define B_AX_TXDMA_ACH4_INT BIT(7)
#define B_AX_TXDMA_ACH3_INT BIT(6)
#define B_AX_TXDMA_ACH2_INT BIT(5)
#define B_AX_TXDMA_ACH1_INT BIT(4)
#define B_AX_TXDMA_ACH0_INT BIT(3)
#define B_AX_RPQDMA_INT BIT(2)
#define B_AX_RXP1DMA_INT BIT(1)
#define B_AX_RXDMA_INT BIT(0)

#define R_AX_HAXI_IDCT_MSK 0x10B8
#define B_AX__TXBD_LEN0_ERR_IDCT_MSK BIT(3)
#define B_AX__TXBD_4KBOUND_ERR_IDCT_MSK BIT(2)
#define B_AX_RXMDA_STUCK_IDCT_MSK BIT(1)
#define B_AX_TXMDA_STUCK_IDCT_MSK BIT(0)

#define R_AX_HAXI_IDCT 0x10BC
#define B_AX__TXBD_LEN0_ERR_IDCT BIT(3)
#define B_AX__TXBD_4KBOUND_ERR_IDCT BIT(2)
#define B_AX_RXMDA_STUCK_IDCT BIT(1)
#define B_AX_TXMDA_STUCK_IDCT BIT(0)

#define R_AX_HAXI_DBG_CTRL 0x1100
#define B_AX_HAXI_DBG_SEL_SH 16
#define B_AX_HAXI_DBG_SEL_MSK 0xff
#define B_AX_EN_CHKDSC_NO_RX_STUCK_V1 BIT(2)
#define B_AX_ASFF_FULL_NO_STK BIT(1)
#define B_AX_EN_STUCK_DBG BIT(0)

#define R_AX_DBG_ERR_FLAG_V1 0x1104
#define B_AX_HAXI_RPQ_FULL BIT(6)
#define B_AX_HAXI_RXQ_FULL BIT(5)
#define B_AX_RX_STUCK_V1 BIT(4)
#define B_AX_TX_STUCK_V1 BIT(3)
#define B_AX_HAXI_RXP1_ERR0 BIT(2)
#define B_AX_HAXI_TXBD_LEN0 BIT(1)
#define B_AX_HAXI_TXBD_4KBOUD_LENERR BIT(0)

#define R_AX_HAXI_INFO 0x1108
#define B_AX_HAXIRX_IDLE BIT(1)
#define B_AX_HAXITX_IDLE BIT(0)

#define R_AX_HAXI_MST_WDT_TIMEOUT_SEL 0x110C
#define B_AX_HAXI_MST_WDT_TIMEOUT_SEL_SH 0
#define B_AX_HAXI_MST_WDT_TIMEOUT_SEL_MSK 0x3

#define R_AX_INT_MIT_TX_V1 0x1180
#define B_AX_TXMIT_CH12_SEL BIT(31)
#define B_AX_TXMIT_CH11_SEL BIT(30)
#define B_AX_TXMIT_CH10_SEL BIT(29)
#define B_AX_TXMIT_CH9_SEL BIT(28)
#define B_AX_TXMIT_CH8_SEL BIT(27)
#define B_AX_TXMIT_ACH7_SEL BIT(26)
#define B_AX_TXMIT_ACH6_SEL BIT(25)
#define B_AX_TXMIT_ACH5_SEL BIT(24)
#define B_AX_TXMIT_ACH4_SEL BIT(23)
#define B_AX_TXMIT_ACH3_SEL BIT(22)
#define B_AX_TXMIT_ACH2_SEL BIT(21)
#define B_AX_TXMIT_ACH1_SEL BIT(20)
#define B_AX_TXMIT_ACH0_SEL BIT(19)
#define B_AX_MIT_TXTIMER_UNIT_SH 16
#define B_AX_MIT_TXTIMER_UNIT_MSK 0x3
#define B_AX_MIT_TXCOUNTER_MATCH_SH 8
#define B_AX_MIT_TXCOUNTER_MATCH_MSK 0xff
#define B_AX_MIT_TXTIMER_MATCH_SH 0
#define B_AX_MIT_TXTIMER_MATCH_MSK 0xff

#define R_AX_INT_MIT_RX_V1 0x1184
#define B_AX_RXMIT_RXP2_SEL_V1 BIT(19)
#define B_AX_RXMIT_RXP1_SEL_V1 BIT(18)
#define B_AX_MIT_RXTIMER_UNIT_SH 16
#define B_AX_MIT_RXTIMER_UNIT_MSK 0x3
#define B_AX_MIT_RXCOUNTER_MATCH_SH 8
#define B_AX_MIT_RXCOUNTER_MATCH_MSK 0xff
#define B_AX_MIT_RXTIMER_MATCH_SH 0
#define B_AX_MIT_RXTIMER_MATCH_MSK 0xff

#define R_AX_HAXI_DMA_STOP2 0x11C0
#define B_AX_STOP_CH11 BIT(1)
#define B_AX_STOP_CH10 BIT(0)

#define R_AX_TXBD_RWPTR_CLR2_V1 0x11C4
#define B_AX_CLR_CH11_IDX BIT(1)
#define B_AX_CLR_CH10_IDX BIT(0)

#define R_AX_HAXI_DMA_BUSY2 0x11C8
#define B_AX_CH11_BUSY BIT(1)
#define B_AX_CH10_BUSY BIT(0)

#define R_AX_CH10_TXBD_IDX_V1 0x11D0
#define B_AX_CH10_HW_IDX_SH 16
#define B_AX_CH10_HW_IDX_MSK 0x3ff
#define B_AX_CH10_HOST_IDX_SH 0
#define B_AX_CH10_HOST_IDX_MSK 0x3ff

#define R_AX_CH11_TXBD_IDX_V1 0x11D4
#define B_AX_CH11_HW_IDX_SH 16
#define B_AX_CH11_HW_IDX_MSK 0x3ff
#define B_AX_CH11_HOST_IDX_SH 0
#define B_AX_CH11_HOST_IDX_MSK 0x3ff

#define R_AX_HAXI_HIMR10 0x11E0
#define B_AX_TXDMA_CH11_INT_EN_V1 BIT(1)
#define B_AX_TXDMA_CH10_INT_EN_V1 BIT(0)

#define R_AX_HAXI_HISR10 0x11E4
#define B_AX_TXDMA_CH11_INT_V1 BIT(1)
#define B_AX_TXDMA_CH10_INT_V1 BIT(0)

#define R_AX_RXBD_RWPTR_CLR_V1 0x1200
#define B_AX_CLR_RPQ_IDX BIT(1)
#define B_AX_CLR_RXQ_IDX BIT(0)

#define R_AX_HAXI_EXP_CTRL 0x1204
#define B_AX_MAX_TAG_NUM_V1_SH 0
#define B_AX_MAX_TAG_NUM_V1_MSK 0x7

#define R_AX_HAXI_DMA_BUSY3 0x1208
#define B_AX_RPQ_BUSY BIT(1)
#define B_AX_RXQ_BUSY BIT(0)

#define R_AX_RXQ_RXBD_NUM_V1 0x1210
#define B_AX_RXQ_DESC_NUM_SH 0
#define B_AX_RXQ_DESC_NUM_MSK 0x3ff

#define R_AX_RPQ_RXBD_NUM_V1 0x1212
#define B_AX_RPQ_DESC_NUM_SH 0
#define B_AX_RPQ_DESC_NUM_MSK 0x3ff

#define R_AX_RXQ_RXBD_IDX_V1 0x1218
#define B_AX_RXQ_HW_IDX_SH 16
#define B_AX_RXQ_HW_IDX_MSK 0x3ff
#define B_AX_RXQ_HOST_IDX_SH 0
#define B_AX_RXQ_HOST_IDX_MSK 0x3ff

#define R_AX_RPQ_RXBD_IDX_V1 0x121C
#define B_AX_RPQ_HW_IDX_SH 16
#define B_AX_RPQ_HW_IDX_MSK 0x3ff
#define B_AX_RPQ_HOST_IDX_SH 0
#define B_AX_RPQ_HOST_IDX_MSK 0x3ff

#define R_AX_RXQ_RXBD_DESA_L_V1 0x1220
#define B_AX_RXQ_RXBD_DESA_L_SH 0
#define B_AX_RXQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RXQ_RXBD_DESA_H_V1 0x1224
#define B_AX_RXQ_RXBD_DESA_H_SH 0
#define B_AX_RXQ_RXBD_DESA_H_MSK 0xff

#define R_AX_RPQ_RXBD_DESA_L_V1 0x1228
#define B_AX_RPQ_RXBD_DESA_L_SH 0
#define B_AX_RPQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RPQ_RXBD_DESA_H_V1 0x122C
#define B_AX_RPQ_RXBD_DESA_H_SH 0
#define B_AX_RPQ_RXBD_DESA_H_MSK 0xff

#define R_AX_ACH0_TXBD_DESA_L_V1 0x1230
#define B_AX_ACH0_TXBD_DESA_L_SH 0
#define B_AX_ACH0_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH0_TXBD_DESA_H_V1 0x1234
#define B_AX_ACH0_TXBD_DESA_H_SH 0
#define B_AX_ACH0_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH1_TXBD_DESA_L_V1 0x1238
#define B_AX_ACH1_TXBD_DESA_L_SH 0
#define B_AX_ACH1_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH1_TXBD_DESA_H_V1 0x123C
#define B_AX_ACH1_TXBD_DESA_H_SH 0
#define B_AX_ACH1_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH2_TXBD_DESA_L_V1 0x1240
#define B_AX_ACH2_TXBD_DESA_L_SH 0
#define B_AX_ACH2_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH2_TXBD_DESA_H_V1 0x1244
#define B_AX_ACH2_TXBD_DESA_H_SH 0
#define B_AX_ACH2_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH3_TXBD_DESA_L_V1 0x1248
#define B_AX_ACH3_TXBD_DESA_L_SH 0
#define B_AX_ACH3_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH3_TXBD_DESA_H_V1 0x124C
#define B_AX_ACH3_TXBD_DESA_H_SH 0
#define B_AX_ACH3_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH4_TXBD_DESA_L_V1 0x1250
#define B_AX_ACH4_TXBD_DESA_L_SH 0
#define B_AX_ACH4_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH4_TXBD_DESA_H_V1 0x1254
#define B_AX_ACH4_TXBD_DESA_H_SH 0
#define B_AX_ACH4_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH5_TXBD_DESA_L_V1 0x1258
#define B_AX_ACH5_TXBD_DESA_L_SH 0
#define B_AX_ACH5_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH5_TXBD_DESA_H_V1 0x125C
#define B_AX_ACH5_TXBD_DESA_H_SH 0
#define B_AX_ACH5_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH6_TXBD_DESA_L_V1 0x1260
#define B_AX_ACH6_TXBD_DESA_L_SH 0
#define B_AX_ACH6_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH6_TXBD_DESA_H_V1 0x1264
#define B_AX_ACH6_TXBD_DESA_H_SH 0
#define B_AX_ACH6_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH7_TXBD_DESA_L_V1 0x1268
#define B_AX_ACH7_TXBD_DESA_L_SH 0
#define B_AX_ACH7_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH7_TXBD_DESA_H_V1 0x126C
#define B_AX_ACH7_TXBD_DESA_H_SH 0
#define B_AX_ACH7_TXBD_DESA_H_MSK 0xff

#define R_AX_CH8_TXBD_DESA_L_V1 0x1270
#define B_AX_CH8_TXBD_DESA_L_SH 0
#define B_AX_CH8_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH8_TXBD_DESA_H_V1 0x1274
#define B_AX_CH8_TXBD_DESA_H_SH 0
#define B_AX_CH8_TXBD_DESA_H_MSK 0xff

#define R_AX_CH9_TXBD_DESA_L_V1 0x1278
#define B_AX_CH9_TXBD_DESA_L_SH 0
#define B_AX_CH9_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH9_TXBD_DESA_H_V1 0x127C
#define B_AX_CH9_TXBD_DESA_H_SH 0
#define B_AX_CH9_TXBD_DESA_H_MSK 0xff

#define R_AX_CH12_TXBD_DESA_L_V1 0x1280
#define B_AX_CH12_TXBD_DESA_L_SH 0
#define B_AX_CH12_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH12_TXBD_DESA_H_V1 0x1284
#define B_AX_CH12_TXBD_DESA_H_SH 0
#define B_AX_CH12_TXBD_DESA_H_MSK 0xff

#define R_AX_BD_ADDR_H_V1 0x12E0
#define B_AX_BD_ADDR_H_SH 8
#define B_AX_BD_ADDR_H_MSK 0xffffff

#define R_AX_WD_ADDR_H_V1 0x12E4
#define B_AX_WD_ADDR_H_SH 8
#define B_AX_WD_ADDR_H_MSK 0xffffff

#define R_AX_WP_ADDR_H_V1 0x12E8
#define B_AX_WP_ADDR_H_SH 8
#define B_AX_WP_ADDR_H_MSK 0xffffff

#define R_AX_RXP1_ADDR_H_V1 0x12EC
#define B_AX_RXP1_ADDR_H_SH 8
#define B_AX_RXP1_ADDR_H_MSK 0xffffff

#define R_AX_RX_ADDR_H_V1 0x12F0
#define B_AX_RX_ADDR_H_SH 8
#define B_AX_RX_ADDR_H_MSK 0xffffff

#define R_AX_ACH0_BDRAM_CTRL_V1 0x1300
#define B_AX_ACH0_BDRAM_MIN_SH 16
#define B_AX_ACH0_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH0_BDRAM_MAX_SH 8
#define B_AX_ACH0_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH0_BDRAM_SIDX_SH 0
#define B_AX_ACH0_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH1_BDRAM_CTRL_V1 0x1304
#define B_AX_ACH1_BDRAM_MIN_SH 16
#define B_AX_ACH1_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH1_BDRAM_MAX_SH 8
#define B_AX_ACH1_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH1_BDRAM_SIDX_SH 0
#define B_AX_ACH1_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH2_BDRAM_CTRL_V1 0x1308
#define B_AX_ACH2_BDRAM_MIN_SH 16
#define B_AX_ACH2_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH2_BDRAM_MAX_SH 8
#define B_AX_ACH2_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH2_BDRAM_SIDX_SH 0
#define B_AX_ACH2_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH3_BDRAM_CTRL_V1 0x130C
#define B_AX_ACH3_BDRAM_MIN_SH 16
#define B_AX_ACH3_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH3_BDRAM_MAX_SH 8
#define B_AX_ACH3_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH3_BDRAM_SIDX_SH 0
#define B_AX_ACH3_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH4_BDRAM_CTRL_V1 0x1310
#define B_AX_ACH4_BDRAM_MIN_SH 16
#define B_AX_ACH4_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH4_BDRAM_MAX_SH 8
#define B_AX_ACH4_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH4_BDRAM_SIDX_SH 0
#define B_AX_ACH4_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH5_BDRAM_CTRL_V1 0x1314
#define B_AX_ACH5_BDRAM_MIN_SH 16
#define B_AX_ACH5_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH5_BDRAM_MAX_SH 8
#define B_AX_ACH5_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH5_BDRAM_SIDX_SH 0
#define B_AX_ACH5_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH6_BDRAM_CTRL_V1 0x1318
#define B_AX_ACH6_BDRAM_MIN_SH 16
#define B_AX_ACH6_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH6_BDRAM_MAX_SH 8
#define B_AX_ACH6_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH6_BDRAM_SIDX_SH 0
#define B_AX_ACH6_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH7_BDRAM_CTRL_V1 0x131C
#define B_AX_ACH7_BDRAM_MIN_SH 16
#define B_AX_ACH7_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH7_BDRAM_MAX_SH 8
#define B_AX_ACH7_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH7_BDRAM_SIDX_SH 0
#define B_AX_ACH7_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH8_BDRAM_CTRL_V1 0x1320
#define B_AX_CH8_BDRAM_MIN_SH 16
#define B_AX_CH8_BDRAM_MIN_MSK 0x3f
#define B_AX_CH8_BDRAM_MAX_SH 8
#define B_AX_CH8_BDRAM_MAX_MSK 0x3f
#define B_AX_CH8_BDRAM_SIDX_SH 0
#define B_AX_CH8_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH9_BDRAM_CTRL_V1 0x1324
#define B_AX_CH9_BDRAM_MIN_SH 16
#define B_AX_CH9_BDRAM_MIN_MSK 0x3f
#define B_AX_CH9_BDRAM_MAX_SH 8
#define B_AX_CH9_BDRAM_MAX_MSK 0x3f
#define B_AX_CH9_BDRAM_SIDX_SH 0
#define B_AX_CH9_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH12_BDRAM_CTRL_V1 0x1328
#define B_AX_CH12_BDRAM_MIN_SH 16
#define B_AX_CH12_BDRAM_MIN_MSK 0x3f
#define B_AX_CH12_BDRAM_MAX_SH 8
#define B_AX_CH12_BDRAM_MAX_MSK 0x3f
#define B_AX_CH12_BDRAM_SIDX_SH 0
#define B_AX_CH12_BDRAM_SIDX_MSK 0x3f

#define R_AX_SEL_BDRAM_RWPTR 0x1330
#define B_AX_SEL_BDRAM_PTR_CH_SH 16
#define B_AX_SEL_BDRAM_PTR_CH_MSK 0xf
#define B_AX_SEL_BDRAM_WPTR_SH 8
#define B_AX_SEL_BDRAM_WPTR_MSK 0x3f
#define B_AX_SEL_BDRAM_RPTR_SH 0
#define B_AX_SEL_BDRAM_RPTR_MSK 0x3f

#define R_AX_WP_ADDR_H_SEL0_3 0x1334
#define B_AX_WP_ADDR_SEL3_SH 24
#define B_AX_WP_ADDR_SEL3_MSK 0xff
#define B_AX_WP_ADDR_SEL2_SH 16
#define B_AX_WP_ADDR_SEL2_MSK 0xff
#define B_AX_WP_ADDR_SEL1_SH 8
#define B_AX_WP_ADDR_SEL1_MSK 0xff
#define B_AX_WP_ADDR_SEL0_SH 0
#define B_AX_WP_ADDR_SEL0_MSK 0xff

#define R_AX_WP_ADDR_H_SEL4_7 0x1338
#define B_AX_WP_ADDR_SEL7_SH 24
#define B_AX_WP_ADDR_SEL7_MSK 0xff
#define B_AX_WP_ADDR_SEL6_SH 16
#define B_AX_WP_ADDR_SEL6_MSK 0xff
#define B_AX_WP_ADDR_SEL5_SH 8
#define B_AX_WP_ADDR_SEL5_MSK 0xff
#define B_AX_WP_ADDR_SEL4_SH 0
#define B_AX_WP_ADDR_SEL4_MSK 0xff

#define R_AX_WP_ADDR_H_SEL8_11 0x133C
#define B_AX_WP_ADDR_SEL11_SH 24
#define B_AX_WP_ADDR_SEL11_MSK 0xff
#define B_AX_WP_ADDR_SEL10_SH 16
#define B_AX_WP_ADDR_SEL10_MSK 0xff
#define B_AX_WP_ADDR_SEL9_SH 8
#define B_AX_WP_ADDR_SEL9_MSK 0xff
#define B_AX_WP_ADDR_SEL8_SH 0
#define B_AX_WP_ADDR_SEL8_MSK 0xff

#define R_AX_WP_ADDR_H_SEL12_15 0x1340
#define B_AX_WP_ADDR_SEL15_SH 24
#define B_AX_WP_ADDR_SEL15_MSK 0xff
#define B_AX_WP_ADDR_SEL14_SH 16
#define B_AX_WP_ADDR_SEL14_MSK 0xff
#define B_AX_WP_ADDR_SEL13_SH 8
#define B_AX_WP_ADDR_SEL13_MSK 0xff
#define B_AX_WP_ADDR_SEL12_SH 0
#define B_AX_WP_ADDR_SEL12_MSK 0xff

#define R_AX_CH10_BDRAM_CTRL_V1 0x1420
#define B_AX_ACH10_BDRAM_MIN_SH 16
#define B_AX_ACH10_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH10_BDRAM_MAX_SH 8
#define B_AX_ACH10_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH10_BDRAM_SIDX_SH 0
#define B_AX_ACH10_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH11_BDRAM_CTRL_V1 0x1424
#define B_AX_ACH11_BDRAM_MIN_SH 16
#define B_AX_ACH11_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH11_BDRAM_MAX_SH 8
#define B_AX_ACH11_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH11_BDRAM_SIDX_SH 0
#define B_AX_ACH11_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH10_TXBD_NUM_V1 0x1438
#define B_AX_HAXI_CH10_FLAG BIT(14)
#define B_AX_CH10_DESC_NUM_SH 0
#define B_AX_CH10_DESC_NUM_MSK 0x3ff

#define R_AX_CH11_TXBD_NUM_V1 0x143A
#define B_AX_HAXI_CH11_FLAG BIT(14)
#define B_AX_CH11_DESC_NUM_SH 0
#define B_AX_CH11_DESC_NUM_MSK 0x3ff

#define R_AX_CH10_TXBD_DESA_L_V1 0x1458
#define B_AX_CH10_TXBD_DESA_L_SH 0
#define B_AX_CH10_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH10_TXBD_DESA_H_V1 0x145C
#define B_AX_CH10_TXBD_DESA_H_SH 0
#define B_AX_CH10_TXBD_DESA_H_MSK 0xff

#define R_AX_CH11_TXBD_DESA_L_V1 0x1460
#define B_AX_CH11_TXBD_DESA_L_SH 0
#define B_AX_CH11_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH11_TXBD_DESA_H_V1 0x1464
#define B_AX_CH11_TXBD_DESA_H_SH 0
#define B_AX_CH11_TXBD_DESA_H_MSK 0xff

#define R_AX_WR_TXBD_DATA 0x1500
#define B_AX_WRITE_TXBD_DATA_SH 0
#define B_AX_WRITE_TXBD_DATA_MSK 0xffffffffL

#define R_AX_WR_PRECOST_REQ 0x1504
#define B_AX_REQ_CH_PG_SH 0
#define B_AX_REQ_CH_PG_MSK 0x1fff

#define R_AX_LTR_DEC_CTRL 0x1600
#define B_AX_LTR_IDX_DRV_VLD BIT(16)
#define B_AX_LTR_CURR_IDX_DRV_SH 14
#define B_AX_LTR_CURR_IDX_DRV_MSK 0x3
#define B_AX_LTR_IDX_FW_VLD BIT(13)
#define B_AX_LTR_CURR_IDX_FW_SH 11
#define B_AX_LTR_CURR_IDX_FW_MSK 0x3
#define B_AX_LTR_IDX_HW_VLD BIT(10)
#define B_AX_LTR_CURR_IDX_HW_SH 8
#define B_AX_LTR_CURR_IDX_HW_MSK 0x3
#define B_AX_LTR_REQ_DRV BIT(7)
#define B_AX_LTR_IDX_DRV_SH 5
#define B_AX_LTR_IDX_DRV_MSK 0x3
#define B_AX_LTR_DRV_DEC_EN BIT(4)
#define B_AX_LTR_FW_DEC_EN BIT(3)
#define B_AX_LTR_HW_DEC_EN BIT(2)
#define B_AX_LTR_SPACE_IDX_V1_SH 0
#define B_AX_LTR_SPACE_IDX_V1_MSK 0x3

#define R_AX_LTR_LATENCY_IDX0 0x1604
#define B_AX_LTR_LATENCY_IDX0_SH 0
#define B_AX_LTR_LATENCY_IDX0_MSK 0xffffffffL

#define R_AX_LTR_LATENCY_IDX1 0x1608
#define B_AX_LTR_LATENCY_IDX1_SH 0
#define B_AX_LTR_LATENCY_IDX1_MSK 0xffffffffL

#define R_AX_LTR_LATENCY_IDX2 0x160C
#define B_AX_LTR_LATENCY_IDX2_SH 0
#define B_AX_LTR_LATENCY_IDX2_MSK 0xffffffffL

#define R_AX_LTR_LATENCY_IDX3 0x1610
#define B_AX_LTR_LATENCY_IDX3_SH 0
#define B_AX_LTR_LATENCY_IDX3_MSK 0xffffffffL

#define R_AX_LTR_CURR_LATENCY 0x1614
#define B_AX_LTR_CURR_LATENCY_SH 0
#define B_AX_LTR_CURR_LATENCY_MSK 0xffffffffL

#define R_AX_HCI_FC_CTRL_V1 0x1700

#define R_AX_CH_PAGE_CTRL_V1 0x1704

#define R_AX_ACH011_INTRPT_STAT_V1 0x1708

#define R_AX_HCI_FC_ERR_FLAG_V1 0x170C
#define B_AX_PUB_AVAL_PG_UFW_V1 BIT(3)
#define B_AX_PUB_USE_PG_UFW_V1 BIT(2)
#define B_AX_CH011_USE_PG_UFW_V1 BIT(1)
#define B_AX_CH011_AVAL_PG_UFW_V1 BIT(0)

#define R_AX_ACH0_PAGE_CTRL_V1 0x1710

#define R_AX_ACH1_PAGE_CTRL_V1 0x1714

#define R_AX_ACH2_PAGE_CTRL_V1 0x1718

#define R_AX_ACH3_PAGE_CTRL_V1 0x171C

#define R_AX_ACH4_PAGE_CTRL_V1 0x1720

#define R_AX_ACH5_PAGE_CTRL_V1 0x1724

#define R_AX_ACH6_PAGE_CTRL_V1 0x1728

#define R_AX_ACH7_PAGE_CTRL_V1 0x172C

#define R_AX_CH8_PAGE_CTRL_V1 0x1730

#define R_AX_CH9_PAGE_CTRL_V1 0x1734

#define R_AX_CH10_PAGE_CTRL_V1 0x1738

#define R_AX_CH11_PAGE_CTRL_V1 0x173C

#define R_AX_ACH0_PAGE_INFO_V1 0x1750

#define R_AX_ACH1_PAGE_INFO_V1 0x1754

#define R_AX_ACH2_PAGE_INFO_V1 0x1758

#define R_AX_ACH3_PAGE_INFO_V1 0x175C

#define R_AX_ACH4_PAGE_INFO_V1 0x1760

#define R_AX_ACH5_PAGE_INFO_V1 0x1764

#define R_AX_ACH6_PAGE_INFO_V1 0x1768

#define R_AX_ACH7_PAGE_INFO_V1 0x176C

#define R_AX_CH8_PAGE_INFO_V1 0x1770

#define R_AX_CH9_PAGE_INFO_V1 0x1774

#define R_AX_CH10_PAGE_INFO_V1 0x1778

#define R_AX_CH11_PAGE_INFO_V1 0x177C

#define R_AX_CH12_PAGE_INFO_V1 0x1780

#define R_AX_PUB_PAGE_INFO3_V1 0x178C

#define R_AX_PUB_PAGE_CTRL1_V1 0x1790

#define R_AX_PUB_PAGE_CTRL2_V1 0x1794

#define R_AX_PUB_PAGE_INFO1_V1 0x1798

#define R_AX_PUB_PAGE_INFO2_V1 0x179C

#define R_AX_WP_PAGE_CTRL1_V1 0x17A0

#define R_AX_WP_PAGE_CTRL2_V1 0x17A4

#define R_AX_WP_PAGE_INFO1_V1 0x17A8

#define R_AX_ACH0_THR_V1 0x17B0

#define R_AX_ACH1_THR_V1 0x17B4

#define R_AX_ACH2_THR_V1 0x17B8

#define R_AX_ACH3_THR_V1 0x17BC

#define R_AX_ACH4_THR_V1 0x17C0

#define R_AX_ACH5_THR_V1 0x17C4

#define R_AX_ACH6_THR_V1 0x17C8

#define R_AX_ACH7_THR_V1 0x17CC

#define R_AX_CH8_THR_V1 0x17D0

#define R_AX_CH9_THR_V1 0x17D4

#define R_AX_CH10_THR_V1 0x17D8

#define R_AX_CH11_THR_V1 0x17DC

//
// WL_AX_Reg_HAXIDMA.xls
//

//
// PCIE
//

//
// WL_AX_Reg_LTECOEX.xls
//

//
// LTECoex
//

#define R_AX_LTE_SW_CFG_1 0x0038
#define B_AX_GNT_BT_RFC_S1_SW_VAL BIT(31)
#define B_AX_GNT_BT_RFC_S1_SW_CTRL BIT(30)
#define B_AX_GNT_WL_RFC_S1_SW_VAL BIT(29)
#define B_AX_GNT_WL_RFC_S1_SW_CTRL BIT(28)
#define B_AX_GNT_BT_BB_S1_SW_VAL BIT(27)
#define B_AX_GNT_BT_BB_S1_SW_CTRL BIT(26)
#define B_AX_GNT_WL_BB_S1_SW_VAL BIT(25)
#define B_AX_GNT_WL_BB_S1_SW_CTRL BIT(24)
#define B_AX_BT_SW_CTRL_WL_PRIORITY BIT(19)
#define B_AX_WL_SW_CTRL_WL_PRIORITY BIT(18)
#define B_AX_LTE_PATTERN_2_EN BIT(17)
#define B_AX_LTE_PATTERN_1_EN BIT(16)
#define B_AX_GNT_BT_RFC_S0_SW_VAL BIT(15)
#define B_AX_GNT_BT_RFC_S0_SW_CTRL BIT(14)
#define B_AX_GNT_WL_RFC_S0_SW_VAL BIT(13)
#define B_AX_GNT_WL_RFC_S0_SW_CTRL BIT(12)
#define B_AX_GNT_BT_BB_S0_SW_VAL BIT(11)
#define B_AX_GNT_BT_BB_S0_SW_CTRL BIT(10)
#define B_AX_GNT_WL_BB_S0_SW_VAL BIT(9)
#define B_AX_GNT_WL_BB_S0_SW_CTRL BIT(8)
#define B_AX_LTECOEX_FUN_EN BIT(7)
#define B_AX_LTECOEX_3WIRE_CTRL_MUX BIT(6)
#define B_AX_LTECOEX_OP_MODE_SEL_SH 4
#define B_AX_LTECOEX_OP_MODE_SEL_MSK 0x3
#define B_AX_LTECOEX_UART_MUX BIT(3)
#define B_AX_LTECOEX_UART_MODE_SEL_SH 0
#define B_AX_LTECOEX_UART_MODE_SEL_MSK 0x7

#define R_AX_LTE_SW_CFG_2 0x003C
#define B_AX_WL_RX_CTRL BIT(8)
#define B_AX_GNT_WL_RX_SW_VAL BIT(7)
#define B_AX_GNT_WL_RX_SW_CTRL BIT(6)
#define B_AX_GNT_WL_TX_SW_VAL BIT(5)
#define B_AX_GNT_WL_TX_SW_CTRL BIT(4)
#define B_AX_GNT_BT_RX_SW_VAL BIT(3)
#define B_AX_GNT_BT_RX_SW_CTRL BIT(2)
#define B_AX_GNT_BT_TX_SW_VAL BIT(1)
#define B_AX_GNT_BT_TX_SW_CTRL BIT(0)

#define R_AX_LTECOEX_STATUS 0x0054
#define B_AX_GNT_BT_RFC_S1_STA BIT(5)
#define B_AX_GNT_WL_RFC_S1_STA BIT(4)
#define B_AX_GNT_BT_RFC_S0_STA BIT(3)
#define B_AX_GNT_WL_RFC_S0_STA BIT(2)

//
// WL_AX_Reg_LTECOEX.xls
//

//
// LTECoex
//

#endif
